/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR)
public class RFDAwowogei
extends BasicQuestHelper {
    ItemRequirement cookedSnake;
    ItemRequirement cookedSnakeHighlighted;
    ItemRequirement mAmulet;
    ItemRequirement gorillaGreegree;
    ItemRequirement ninjaGreegree;
    ItemRequirement zombieGreegree;
    ItemRequirement bananaHighlighted;
    ItemRequirement monkeyNutsHighlighted;
    ItemRequirement ropeHighlighted;
    ItemRequirement knife;
    ItemRequirement pestleAndMortar;
    ItemRequirement tchikiNuts;
    ItemRequirement tchikiNutsHighlighted;
    ItemRequirement redBanana;
    ItemRequirement redBananaHighlighted;
    ItemRequirement snakeCorpse;
    ItemRequirement snakeCorpseHighlighted;
    ItemRequirement rawStuffedSnake;
    ItemRequirement rawStuffedSnakeHighlighted;
    ItemRequirement slicedRedBanana;
    ItemRequirement greegreeEquipped;
    ItemRequirement paste;
    ItemRequirement combatGear;
    Requirement protectMelee;
    Requirement inDiningRoom;
    Requirement askedAboutBanana;
    Requirement askedAboutNut;
    Requirement hasSnakeCorpse;
    Requirement hasRedBanana;
    Requirement hasTchikiNut;
    Requirement onCrashIsland;
    Requirement inSnakeHole;
    Requirement inNutHole;
    Requirement inTempleDungeon;
    Requirement inCookRoom;
    QuestStep enterDiningRoom;
    QuestStep inspectAwowogei;
    QuestStep talkToAwowogei;
    QuestStep talkToWiseMonkeys;
    QuestStep useBananaOnWiseMonkeys;
    QuestStep useNutsOnWiseMonkeys;
    QuestStep goToCrashIsland;
    QuestStep enterCrashHole;
    QuestStep killSnake;
    QuestStep leaveSnakeHole;
    QuestStep returnToApeAtoll;
    QuestStep useRopeOnTree;
    QuestStep enterNutHole;
    QuestStep takeNuts;
    QuestStep grindNuts;
    QuestStep sliceBanana;
    QuestStep stuffSnake;
    QuestStep enterZombieDungeon;
    QuestStep enterCookingHole;
    QuestStep cookSnake;
    QuestStep enterDiningRoomAgain;
    QuestStep useSnakeOnAwowogei;
    Zone diningRoom;
    Zone crashIsland;
    Zone snakeHole;
    Zone nutHole;
    Zone templeDungeon;
    Zone cookRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectSkrach = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectSkrach.addStep(this.inDiningRoom, this.inspectAwowogei);
        steps.put(0, goInspectSkrach);
        steps.put(5, this.talkToAwowogei);
        steps.put(10, this.talkToWiseMonkeys);
        ConditionalStep prepareMeal = new ConditionalStep((QuestHelper)this, this.useBananaOnWiseMonkeys, new Requirement[0]);
        prepareMeal.addStep(new Conditions(new Conditions(this.inDiningRoom, this.cookedSnake)), this.useSnakeOnAwowogei);
        prepareMeal.addStep(new Conditions(this.cookedSnake), this.enterDiningRoomAgain);
        prepareMeal.addStep(new Conditions(this.rawStuffedSnake, this.inCookRoom), this.cookSnake);
        prepareMeal.addStep(new Conditions(this.rawStuffedSnake, this.inTempleDungeon), this.enterCookingHole);
        prepareMeal.addStep(new Conditions(this.rawStuffedSnake), this.enterZombieDungeon);
        prepareMeal.addStep(new Conditions(this.hasSnakeCorpse, this.slicedRedBanana, this.paste), this.stuffSnake);
        prepareMeal.addStep(new Conditions(this.hasSnakeCorpse, this.hasRedBanana, this.paste), this.sliceBanana);
        prepareMeal.addStep(new Conditions(this.hasSnakeCorpse, this.hasRedBanana, this.hasTchikiNut), this.grindNuts);
        prepareMeal.addStep(new Conditions(this.askedAboutNut, this.hasSnakeCorpse, this.hasRedBanana, this.inNutHole), this.takeNuts);
        prepareMeal.addStep(new Conditions(this.askedAboutNut, this.hasSnakeCorpse, this.hasRedBanana), this.enterNutHole);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut, this.onCrashIsland, this.hasSnakeCorpse), this.returnToApeAtoll);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut, this.inSnakeHole, this.hasSnakeCorpse), this.leaveSnakeHole);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut, this.hasSnakeCorpse), this.useRopeOnTree);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut, this.inSnakeHole), this.killSnake);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut, this.onCrashIsland), this.enterCrashHole);
        prepareMeal.addStep(new Conditions(this.askedAboutBanana, this.askedAboutNut), this.goToCrashIsland);
        prepareMeal.addStep(this.askedAboutBanana, this.useNutsOnWiseMonkeys);
        steps.put(15, prepareMeal);
        steps.put(20, prepareMeal);
        steps.put(30, prepareMeal);
        steps.put(40, prepareMeal);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cookedSnake = new ItemRequirement("Stuffed snake", 7579);
        this.cookedSnakeHighlighted = new ItemRequirement("Stuffed snake", 7579);
        this.cookedSnakeHighlighted.setHighlightInInventory(true);
        this.mAmulet = new ItemRequirement("M'speak amulet", 4021, 1, true);
        this.gorillaGreegree = new ItemRequirement("Gorilla greegree", 4026, 1, true).isNotConsumed();
        this.gorillaGreegree.addAlternates(4028, 4027);
        this.gorillaGreegree.setTooltip("Kill a gorilla in the monkey temple for their bones, and make a greegree from them");
        this.ninjaGreegree = new ItemRequirement("Ninja greegree", 4024, 1, true).isNotConsumed();
        this.ninjaGreegree.setTooltip("Kill a monkey archer in the monkey market for its bones and make a greegree from them");
        this.ninjaGreegree.addAlternates(4025, 19525);
        this.zombieGreegree = new ItemRequirement("Zombie greegree", 4029, 1, true).isNotConsumed();
        this.zombieGreegree.setTooltip("Kill a zombie monkey under the monkey temple and make a greegree from them");
        this.zombieGreegree.addAlternates(4030);
        this.greegreeEquipped = new ItemRequirement("Any greegree", ItemCollections.GREEGREES).equipped().isNotConsumed();
        this.bananaHighlighted = new ItemRequirement("Banana", 1963);
        this.bananaHighlighted.setHighlightInInventory(true);
        this.monkeyNutsHighlighted = new ItemRequirement("Monkey nuts", 4012);
        this.monkeyNutsHighlighted.setHighlightInInventory(true);
        this.monkeyNutsHighlighted.setTooltip("You can buy some from Solihib in the monkey market");
        this.ropeHighlighted = new ItemRequirement("Rope", 954).isNotConsumed();
        this.ropeHighlighted.setHighlightInInventory(true);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.knife.setHighlightInInventory(true);
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleAndMortar.setHighlightInInventory(true);
        this.tchikiNuts = new ItemRequirement("Tchiki monkey nuts", 7573);
        this.tchikiNutsHighlighted = new ItemRequirement("Tchiki monkey nuts", 7573);
        this.tchikiNutsHighlighted.setHighlightInInventory(true);
        this.redBanana = new ItemRequirement("Red banana", 7572);
        this.redBananaHighlighted = new ItemRequirement("Red banana", 7572);
        this.redBananaHighlighted.setHighlightInInventory(true);
        this.snakeCorpse = new ItemRequirement("Snake corpse", 7576);
        this.snakeCorpseHighlighted = new ItemRequirement("Snake corpse", 7576);
        this.snakeCorpseHighlighted.setHighlightInInventory(true);
        this.rawStuffedSnake = new ItemRequirement("Raw stuffed snake", 7577);
        this.rawStuffedSnakeHighlighted = new ItemRequirement("Raw stuffed snake", 7577);
        this.rawStuffedSnakeHighlighted.setHighlightInInventory(true);
        this.slicedRedBanana = new ItemRequirement("Sliced red banana", 7574);
        this.paste = new ItemRequirement("Tchiki nut paste", 7575);
        this.paste.setHighlightInInventory(true);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.protectMelee = new PrayerRequirement("Protect from Melee", Prayer.PROTECT_FROM_MELEE);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.crashIsland = new Zone(new WorldPoint(2883, 2693, 0), new WorldPoint(2941, 2747, 0));
        this.snakeHole = new Zone(new WorldPoint(3019, 5484, 0), new WorldPoint(3028, 5492, 0));
        this.nutHole = new Zone(new WorldPoint(3014, 5451, 0), new WorldPoint(3030, 5462, 0));
        this.templeDungeon = new Zone(new WorldPoint(2777, 9185, 0), new WorldPoint(2818, 9219, 0));
        this.cookRoom = new Zone(new WorldPoint(3049, 5477, 0), new WorldPoint(3069, 5492, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.onCrashIsland = new ZoneRequirement(this.crashIsland);
        this.inSnakeHole = new ZoneRequirement(this.snakeHole);
        this.inNutHole = new ZoneRequirement(this.nutHole);
        this.inTempleDungeon = new ZoneRequirement(this.templeDungeon);
        this.inCookRoom = new ZoneRequirement(this.cookRoom);
        this.askedAboutBanana = new VarbitRequirement(1915, 10, Operation.GREATER_EQUAL);
        this.askedAboutNut = new VarbitRequirement(1916, 10, Operation.GREATER_EQUAL);
        this.hasSnakeCorpse = new Conditions(LogicType.OR, this.snakeCorpse, this.rawStuffedSnake);
        this.hasRedBanana = new Conditions(LogicType.OR, this.redBanana, this.slicedRedBanana);
        this.hasTchikiNut = new Conditions(LogicType.OR, this.tchikiNuts, this.paste);
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Awowogei in Lumbridge Castle.", new Requirement[0]);
        this.inspectAwowogei = new ObjectStep((QuestHelper)this, 12347, new WorldPoint(1865, 5319, 0), "Inspect Awowogei.", new Requirement[0]);
        this.inspectAwowogei.addSubSteps(this.enterDiningRoom);
        this.talkToAwowogei = new ObjectStep((QuestHelper)this, 4771, new WorldPoint(2803, 2765, 0), "Talk to Awowogei on Ape Atoll.", this.greegreeEquipped, this.mAmulet);
        this.talkToWiseMonkeys = new NpcStep((QuestHelper)this, 2977, new WorldPoint(2789, 2795, 0), "Talk to the three monkeys sat in the temple.", this.greegreeEquipped, this.mAmulet);
        this.talkToWiseMonkeys.addDialogStep("Do you know anything about the King's favourite dish?");
        this.useBananaOnWiseMonkeys = new NpcStep((QuestHelper)this, 2977, new WorldPoint(2789, 2795, 0), "Use a banana on the one of the three monkeys.", this.bananaHighlighted, this.greegreeEquipped, this.mAmulet);
        this.useBananaOnWiseMonkeys.addIcon(1963);
        this.useNutsOnWiseMonkeys = new NpcStep((QuestHelper)this, 2977, new WorldPoint(2789, 2795, 0), "Use some monkey nuts on the one of the three monkeys.", this.monkeyNutsHighlighted, this.greegreeEquipped, this.mAmulet);
        this.useNutsOnWiseMonkeys.addIcon(4012);
        this.goToCrashIsland = new NpcStep((QuestHelper)this, 1454, new WorldPoint(2802, 2706, 0), "Travel to Crash Island with Lumdo.", this.combatGear);
        this.enterCrashHole = new ObjectStep((QuestHelper)this, 15572, new WorldPoint(2922, 2722, 0), "Enter the hole on Crash Island. Protect melee when entering as you'll be attacked straight away by snakes.", this.combatGear, this.protectMelee);
        this.enterCrashHole.addDialogStep("Yes, I'm as hard as nails.");
        this.killSnake = new NpcStep((QuestHelper)this, 2978, new WorldPoint(3019, 5485, 0), "Kill a giant snake for its corpse. Kill a few in case you burn it.", this.snakeCorpse);
        this.leaveSnakeHole = new ObjectStep((QuestHelper)this, 15571, new WorldPoint(3024, 5489, 0), "Leave the hole.", new Requirement[0]);
        this.returnToApeAtoll = new NpcStep((QuestHelper)this, 1454, new WorldPoint(2892, 2723, 0), "Travel back to Ape Atoll with Lumdo.", new Requirement[0]);
        this.useRopeOnTree = new ObjectStep((QuestHelper)this, 15580, new WorldPoint(2697, 2786, 0), "Use a rope on the red banana tree on the north west of Ape Atoll as a gorilla.", this.gorillaGreegree, this.ropeHighlighted);
        this.useRopeOnTree.addIcon(954);
        this.enterNutHole = new ObjectStep((QuestHelper)this, 15491, new WorldPoint(2758, 2729, 0), "Go around the monkey agility course until you reach a hole, and go down it.", this.ninjaGreegree);
        this.takeNuts = new ObjectStep((QuestHelper)this, 16059, new WorldPoint(3021, 5458, 0), "Take a nut from the bush. Take a few in case you burn the final meal.", new Requirement[0]);
        this.grindNuts = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the tchiki nuts.", this.pestleAndMortar, this.tchikiNutsHighlighted);
        this.sliceBanana = new DetailedQuestStep((QuestHelper)this, "Use a knife/slash weapon on the red banana.", this.knife, this.redBananaHighlighted);
        this.stuffSnake = new DetailedQuestStep((QuestHelper)this, "Use the paste on the snake to stuff it.", this.paste, this.slicedRedBanana, this.snakeCorpseHighlighted);
        this.enterZombieDungeon = new ObjectStep((QuestHelper)this, 4880, new WorldPoint(2807, 2785, 0), "Enter the trapdoor in the monkey temple.", this.zombieGreegree, this.rawStuffedSnake);
        ((ObjectStep)this.enterZombieDungeon).addAlternateObjects(4879);
        this.enterCookingHole = new ObjectStep((QuestHelper)this, 16061, new WorldPoint(2805, 9199, 0), "Enter the hole just under where you entered.", this.zombieGreegree, this.rawStuffedSnake);
        this.cookSnake = new ObjectStep((QuestHelper)this, 26175, new WorldPoint(3056, 5485, 0), "Go across the hot rocks with the zombie greegree equipped. Cook the stuffed snake on the rock at the end of the room.", this.zombieGreegree, this.rawStuffedSnakeHighlighted);
        this.cookSnake.addIcon(7577);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Go give the snake to Awowogei to finish the quest.", this.cookedSnake);
        this.useSnakeOnAwowogei = new ObjectStep((QuestHelper)this, 12347, new WorldPoint(1865, 5319, 0), "Give the snake to Awowogei to finish the quest.", this.cookedSnakeHighlighted);
        this.useSnakeOnAwowogei.addIcon(7579);
        this.useSnakeOnAwowogei.addSubSteps(this.enterDiningRoomAgain);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.mAmulet, this.bananaHighlighted, this.monkeyNutsHighlighted, this.ropeHighlighted, this.knife, this.pestleAndMortar, this.gorillaGreegree, this.ninjaGreegree, this.zombieGreegree);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Big Snake (level 84)", "If you need the greegrees still, a zombie, ninja, and guard monkey");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("If you don't have the ninja/gorilla/zombie greegrees ready, it's recommended you get them all in a single run to Zooknock to save time.");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new VarbitRequirement(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId(), Operation.GREATER_EQUAL, 3, "Started Recipe for Disaster"));
        req.add(new QuestRequirement(QuestHelperQuest.MONKEY_MADNESS_I, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 48));
        req.add(new SkillRequirement(Skill.COOKING, 70, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 10000), new ExperienceReward(Skill.AGILITY, 10000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to teleport to Ape Atoll"), new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.inspectAwowogei), new Requirement[0]));
        allSteps.add(new PanelDetails("Saving Awowogei", Arrays.asList(this.talkToAwowogei, this.talkToWiseMonkeys, this.useBananaOnWiseMonkeys, this.useNutsOnWiseMonkeys, this.goToCrashIsland, this.enterCrashHole, this.killSnake, this.leaveSnakeHole, this.returnToApeAtoll, this.useRopeOnTree, this.enterNutHole, this.takeNuts, this.grindNuts, this.sliceBanana, this.stuffSnake, this.enterZombieDungeon, this.enterCookingHole, this.cookSnake, this.useSnakeOnAwowogei), this.mAmulet, this.bananaHighlighted, this.monkeyNutsHighlighted, this.ropeHighlighted, this.knife, this.pestleAndMortar, this.zombieGreegree, this.ninjaGreegree, this.gorillaGreegree));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 50) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_MONKEY_AMBASSADOR.getId()) >= 50 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

