/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class QuizSteps
extends DetailedOwnerStep {
    DetailedQuestStep answerQuestions;
    DetailedQuestStep answerWeaponQuestion;
    DetailedQuestStep answerRuneQuestion;
    ItemRequirement milk = new ItemRequirement("Bucket of milk", 1927);
    ItemRequirement flour = new ItemRequirement("Pot of flour", 1933);
    ItemRequirement egg = new ItemRequirement("Egg", 1944);
    String weaponChoice = "How many weapons were you shown?";
    String runeChoice = "How many types of rune were there?";

    public QuizSteps(QuestHelper questHelper) {
        super(questHelper, "Talk to Traiborn and complete his tests to enchant the ingredients.", new Requirement[0]);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        Widget currentDialog;
        boolean eggEnchanted = this.client.getVarbitValue(1894) == 1;
        boolean flourEnchanted = this.client.getVarbitValue(1897) == 1;
        boolean milkEnchanted = this.client.getVarbitValue(1898) == 1;
        ArrayList<ItemRequirement> items = new ArrayList<ItemRequirement>();
        if (!eggEnchanted) {
            items.add(this.egg);
        }
        if (!milkEnchanted) {
            items.add(this.milk);
        }
        if (!flourEnchanted) {
            items.add(this.flour);
        }
        if ((currentDialog = this.client.getWidget(15138822)) != null && currentDialog.getText() != null) {
            if (currentDialog.getText().equals(this.weaponChoice)) {
                this.answerWeaponQuestion.setRequirements(items);
                this.startUpStep(this.answerWeaponQuestion);
                return;
            }
            if (currentDialog.getText().equals(this.runeChoice)) {
                this.answerRuneQuestion.setRequirements(items);
                this.startUpStep(this.answerRuneQuestion);
                return;
            }
        }
        this.answerQuestions.setRequirements(items);
        this.startUpStep(this.answerQuestions);
    }

    @Override
    protected void setupSteps() {
        this.answerQuestions = new NpcStep(this.getQuestHelper(), 5081, new WorldPoint(3112, 3162, 1), "Talk to Traiborn.", new Requirement[0]);
        this.answerQuestions.addDialogSteps("Ask about helping the Lumbridge Guide.", "Okay. Let's start!", "Okay. I'm ready!", "Quiz me!");
        this.answerQuestions.addDialogSteps("Unferth", "Gertrude", "King Lathas", "Pirate Pete", "Islwyn", "Hetty", "Observatory Professsor Gronigen", "Ali Morrisane", "Velorina", "Reldo");
        this.answerQuestions.addDialogSteps("Bandit camp", "Flour, Eggs and milk", "20", "Sand, bucket, soda ash, glass blowing pipe", "16", "North to South", "46", "2", "Keep Le Faye", "Dark Wizards'", "Catherby", "Legends'");
        this.answerQuestions.addDialogSteps("Trout", "Mind Talisman", "Guthix Prayer Book, Magic Logs, Pike");
        this.answerQuestions.addDialogStep(1, "10");
        this.answerQuestions.addDialogStep(3, "10");
        this.answerWeaponQuestion = new NpcStep(this.getQuestHelper(), 5081, new WorldPoint(3112, 3162, 1), "Talk to Traiborn.", new Requirement[0]);
        this.answerWeaponQuestion.addDialogStep("Three");
        this.answerRuneQuestion = new NpcStep(this.getQuestHelper(), 5081, new WorldPoint(3112, 3162, 1), "Talk to Traiborn.", new Requirement[0]);
        this.answerRuneQuestion.addDialogStep("Two");
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.answerQuestions, this.answerRuneQuestion, this.answerWeaponQuestion);
    }
}

