/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.NpcCollections;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.FollowerItemRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class MakeEvilStew
extends DetailedOwnerStep {
    DetailedQuestStep catchRats;
    DetailedQuestStep enterBasement;
    DetailedQuestStep useStewOnEvilDave;
    DetailedQuestStep restart;
    Requirement inEvilDaveRoom;
    Zone evilDaveRoom;
    ItemRequirement redSpice;
    ItemRequirement orangeSpice;
    ItemRequirement brownSpice;
    ItemRequirement yellowSpice;
    ItemRequirement evilStewHighlighted;
    ItemRequirement evilStew;
    ItemRequirement stew;
    Requirement cat;

    public MakeEvilStew(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        int redNeeded = this.client.getVarbitValue(1883);
        int yellowNeeded = this.client.getVarbitValue(1884);
        int brownNeeded = this.client.getVarbitValue(1885);
        int orangeNeeded = this.client.getVarbitValue(1886);
        int redInStew = this.client.getVarbitValue(1879);
        int yellowInStew = this.client.getVarbitValue(1880);
        int brownInStew = this.client.getVarbitValue(1881);
        int orangeInStew = this.client.getVarbitValue(1882);
        int numRedStillNeeded = redNeeded - redInStew;
        int numOrangeStillNeeded = orangeNeeded - orangeInStew;
        int numBrownStillNeeded = brownNeeded - brownInStew;
        int numYellowStillNeeded = yellowNeeded - yellowInStew;
        if (!this.inEvilDaveRoom.check(this.client)) {
            this.startUpStep(this.enterBasement);
        }
        this.catchRats.setRequirements(Collections.singletonList(this.cat));
        this.catchRats.setText("Have your cat catch Hell-Rats for spices, and add them to your stew. You will need to add a random number between 1-3 of each spice (red/orange/yellow/brown). Try adding 1 of a spice to a stew, then using the stew on Evil Dave to see if it's right. If not, try with 2 and then 3. Rinse and repeat until you know the right quantity of each spice, then use the perfect stew combination on Evil Dave.");
        this.startUpStep(this.catchRats);
    }

    @Override
    protected void setupSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.catchRats = new DetailedQuestStep(this.getQuestHelper(), "Have your cat catch Hell-Rats for spices, and add them to your stew to match the required quantities.", new Requirement[0]);
        this.restart = new DetailedQuestStep(this.getQuestHelper(), "You've added too much of a spice. Eat your spicy stew and start again.", this.evilStewHighlighted);
        this.enterBasement = new ObjectStep(this.getQuestHelper(), 12267, new WorldPoint(3077, 3493, 0), "Go back down to Evil Dave.", new Requirement[0]);
        ((ObjectStep)this.enterBasement).addAlternateObjects(12268);
        this.useStewOnEvilDave = new NpcStep(this.getQuestHelper(), 4806, new WorldPoint(3080, 9889, 0), "Use the spicy stew on Evil Dave.", this.evilStewHighlighted);
    }

    protected void setupRequirements() {
        this.redSpice = new ItemRequirement("Red spice", 7483);
        this.redSpice.addAlternates(7482, 7481, 7480);
        this.redSpice.setHighlightInInventory(true);
        this.orangeSpice = new ItemRequirement("Orange spice", 7487);
        this.orangeSpice.addAlternates(7486, 7485, 7484);
        this.orangeSpice.setHighlightInInventory(true);
        this.yellowSpice = new ItemRequirement("Yellow spice", 7495);
        this.yellowSpice.addAlternates(7494, 7493, 7492);
        this.yellowSpice.setHighlightInInventory(true);
        this.brownSpice = new ItemRequirement("Brown spice", 7491);
        this.brownSpice.addAlternates(7490, 7489, 7488);
        this.brownSpice.setHighlightInInventory(true);
        this.evilStew = new ItemRequirement("Spicy stew", 7479);
        this.evilStewHighlighted = new ItemRequirement("Spicy stew", 7479);
        this.evilStewHighlighted.setHighlightInInventory(true);
        this.stew = new ItemRequirement("Stew", 2003);
        this.stew.setHighlightInInventory(true);
        this.cat = new FollowerItemRequirement("A non-overgrown cat for catching rats", ItemCollections.HUNTING_CATS, NpcCollections.getHuntingCats());
    }

    public void setupZones() {
        this.evilDaveRoom = new Zone(new WorldPoint(3068, 9874, 0), new WorldPoint(3086, 9904, 0));
    }

    public void setupConditions() {
        this.inEvilDaveRoom = new ZoneRequirement(this.evilDaveRoom);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.catchRats, this.enterBasement, this.useStewOnEvilDave);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.catchRats, this.useStewOnEvilDave);
    }
}

