/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ratcatchers;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class RatCharming
extends DetailedOwnerStep {
    QuestStep goNext;
    QuestStep goPrevious;
    QuestStep clickOctave;
    QuestStep clickDone;
    QuestStep[] noteSteps;
    Requirement[] noteRequirements;

    public RatCharming(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        int currentPage = this.client.getVarbitValue(1420);
        for (int i = 0; i < this.noteSteps.length; ++i) {
            int octaveRaised;
            if (this.noteRequirements[i].check(this.client)) continue;
            if (currentPage < i) {
                this.startUpStep(this.goNext);
                return;
            }
            if (currentPage > i) {
                this.startUpStep(this.goPrevious);
                return;
            }
            if (i == 4 && (octaveRaised = this.client.getVarbitValue(1413)) == 0) {
                this.startUpStep(this.clickOctave);
                return;
            }
            this.startUpStep(this.noteSteps[i]);
            return;
        }
        this.startUpStep(this.clickDone);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    public void setupRequirements() {
        this.noteRequirements = new Requirement[8];
        this.noteRequirements[0] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 63), new VarbitRequirement(1420, 0)), new VarbitRequirement(1395, 63));
        this.noteRequirements[1] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 56), new VarbitRequirement(1420, 1)), new VarbitRequirement(1396, 56));
        this.noteRequirements[2] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 62), new VarbitRequirement(1420, 2)), new VarbitRequirement(1397, 62));
        this.noteRequirements[3] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 60), new VarbitRequirement(1420, 3)), new VarbitRequirement(1398, 60));
        this.noteRequirements[4] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 127), new VarbitRequirement(1420, 4)), new VarbitRequirement(1399, 127));
        this.noteRequirements[5] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 32), new VarbitRequirement(1420, 5)), new VarbitRequirement(1400, 32));
        this.noteRequirements[6] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 1), new VarbitRequirement(1420, 6)), new VarbitRequirement(1401, 1));
        this.noteRequirements[7] = new Conditions(LogicType.OR, new Conditions(new VarbitRequirement(1411, 48), new VarbitRequirement(1420, 7)), new VarbitRequirement(1402, 48));
    }

    @Override
    protected void setupSteps() {
        this.setupRequirements();
        this.noteSteps = new QuestStep[8];
        this.noteSteps[0] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 2);
        this.noteSteps[1] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 5);
        this.noteSteps[2] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 3);
        this.noteSteps[3] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 4);
        this.noteSteps[4] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 2);
        this.noteSteps[5] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 7);
        this.noteSteps[6] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 8);
        this.noteSteps[7] = new WidgetStep(this.getQuestHelper(), "Click the marked note.", 282, 6);
        this.goNext = new WidgetStep(this.getQuestHelper(), "Go to the next page.", 282, 24);
        this.goPrevious = new WidgetStep(this.getQuestHelper(), "Go to the previous page.", 282, 23);
        this.clickOctave = new WidgetStep(this.getQuestHelper(), "Click the raise octave button.", 282, 11);
        this.clickDone = new WidgetStep(this.getQuestHelper(), "Click play.", 282, 20);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        ArrayList<QuestStep> returnSteps = new ArrayList<QuestStep>(Arrays.asList(this.noteSteps));
        returnSteps.addAll(Arrays.asList(this.goNext, this.goPrevious, this.clickOctave, this.clickDone));
        return returnSteps;
    }
}

