/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ratcatchers;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.NpcCollections;
import com.questhelper.helpers.quests.ratcatchers.RatCharming;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.FollowerItemRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.FollowerRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RATCATCHERS)
public class RatCatchers
extends BasicQuestHelper {
    ItemRequirement ratPoison;
    ItemRequirement cheese;
    ItemRequirement marrentill;
    ItemRequirement unicornHornDust;
    ItemRequirement bucketOfMilk;
    ItemRequirement catspeakAmuletOrDS2;
    ItemRequirement potOfWeeds;
    ItemRequirement tinderbox;
    ItemRequirement coins101;
    ItemRequirement snakeCharm;
    ItemRequirement fish8;
    ItemRequirement cat;
    ItemRequirement coin;
    ItemRequirement kwuarm;
    ItemRequirement vial;
    ItemRequirement redEggs;
    Requirement catFollower;
    ItemRequirement varrockTeleport;
    ItemRequirement sarimTeleport;
    ItemRequirement pollnivneachTeleport;
    ItemRequirement ardougneTeleport;
    ItemRequirement keldagrimTeleport;
    ItemRequirement carpetCoins;
    ItemRequirement directions;
    ItemRequirement poisonedCheese4;
    ItemRequirement poisonedCheese3;
    ItemRequirement poisonedCheese2;
    ItemRequirement poisonedCheese1;
    ItemRequirement smoulderingPot;
    ItemRequirement catantipoison;
    ItemRequirement musicScroll;
    Requirement inVarrockSewer;
    Requirement inMansionGrounds;
    Requirement inMansionF1;
    Requirement inMansionF0;
    Requirement inGiantRatArea;
    Requirement inKelgdagrim;
    Requirement inRatPit;
    Requirement inPortSarim;
    Requirement caughtRat1;
    Requirement caughtRat2And3;
    Requirement poisonedHole1;
    Requirement poisonedHole2;
    Requirement poisonedHole3;
    Requirement poisonedHole4;
    Requirement catSeenFailure;
    Requirement inPlayWidget;
    QuestStep talkToGertrude;
    QuestStep enterSewer;
    QuestStep talkToPhingspet;
    QuestStep catch8Rats;
    QuestStep talkToPhingspetAgain;
    QuestStep talkToJimmy;
    QuestStep readDirections;
    QuestStep climbTrellis;
    QuestStep climbTrellisNoPath;
    QuestStep climbDownLadderInMansion;
    QuestStep talkToJimmyAgain;
    NpcStep catchRat1;
    NpcStep catchRat2And3;
    NpcStep catchRemainingRats;
    QuestStep talkToJack;
    QuestStep climbJackLadder;
    QuestStep useRatPoisonOnCheese;
    QuestStep useCheeseOnHole1;
    QuestStep useCheeseOnHole2;
    QuestStep useCheeseOnHole3;
    QuestStep useCheeseOnHole4;
    QuestStep goDownToJack;
    QuestStep talkToJackAfterCheese;
    QuestStep talkToApoth;
    QuestStep talkToJackAfterApoth;
    QuestStep talkToJackAfterCure;
    QuestStep climbJackLadderAgain;
    QuestStep useCatOnHole;
    QuestStep feedCatAsItFights;
    QuestStep goDownToJackAfterFight;
    QuestStep talkToJackAfterFight;
    QuestStep travelToKeldagrim;
    QuestStep talkToSmokinJoe;
    QuestStep lightWeeds;
    QuestStep usePotOnHole;
    QuestStep usePotOnHoleAgain;
    QuestStep talkToJoeAgain;
    QuestStep enterSarimRatPits;
    QuestStep talkToFelkrash;
    QuestStep leaveSarimRatPits;
    QuestStep talkToTheFaceAgain;
    QuestStep useCoinOnPot;
    QuestStep returnToSarim;
    QuestStep clickSnakeCharm;
    RatCharming playSnakeCharm;
    QuestStep enterPitsForEnd;
    QuestStep talkToFelkrashForEnd;
    Zone varrockSewer;
    Zone mansionGrounds;
    Zone mansionF1;
    Zone mansionF0;
    Zone giantRatArea;
    Zone keldagrim;
    Zone ratPit;
    Zone portSarim;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToGertrude);
        ConditionalStep goTalkToSewerPeople = new ConditionalStep((QuestHelper)this, this.enterSewer, new Requirement[0]);
        goTalkToSewerPeople.addStep(this.inVarrockSewer, this.talkToPhingspet);
        steps.put(5, goTalkToSewerPeople);
        ConditionalStep goCatchSewerRats = new ConditionalStep((QuestHelper)this, this.enterSewer, new Requirement[0]);
        goCatchSewerRats.addStep(this.inVarrockSewer, this.catch8Rats);
        steps.put(10, goCatchSewerRats);
        ConditionalStep goTalkToSewerPeopleAgain = new ConditionalStep((QuestHelper)this, this.enterSewer, new Requirement[0]);
        goTalkToSewerPeopleAgain.addStep(this.inVarrockSewer, this.talkToPhingspetAgain);
        steps.put(15, goTalkToSewerPeopleAgain);
        steps.put(20, this.talkToJimmy);
        ConditionalStep goEnterMansion = new ConditionalStep((QuestHelper)this, this.readDirections, new Requirement[0]);
        goEnterMansion.addStep(this.inMansionGrounds, this.climbTrellis);
        steps.put(25, goEnterMansion);
        ConditionalStep goCatchMansionRats = new ConditionalStep((QuestHelper)this, this.readDirections, new Requirement[0]);
        goCatchMansionRats.addStep(new Conditions(this.inMansionF0, this.caughtRat1, this.caughtRat2And3), this.catchRemainingRats);
        goCatchMansionRats.addStep(new Conditions(this.inMansionF1, this.caughtRat1, this.caughtRat2And3), this.climbDownLadderInMansion);
        goCatchMansionRats.addStep(new Conditions(this.inMansionF1, this.caughtRat1), this.catchRat2And3);
        goCatchMansionRats.addStep(this.inMansionF1, this.catchRat1);
        goCatchMansionRats.addStep(this.inMansionGrounds, this.climbTrellisNoPath);
        steps.put(30, goCatchMansionRats);
        steps.put(35, this.talkToJimmyAgain);
        steps.put(40, this.talkToJack);
        steps.put(45, this.talkToJack);
        ConditionalStep goPoisonRats = new ConditionalStep((QuestHelper)this, this.climbJackLadder, new Requirement[0]);
        goPoisonRats.addStep(new Conditions(this.inGiantRatArea, this.poisonedCheese1, this.poisonedHole1, this.poisonedHole2, this.poisonedHole3), this.useCheeseOnHole4);
        goPoisonRats.addStep(new Conditions(this.inGiantRatArea, this.poisonedCheese1, this.poisonedHole1, this.poisonedHole2), this.useCheeseOnHole3);
        goPoisonRats.addStep(new Conditions(this.inGiantRatArea, this.poisonedCheese1, this.poisonedHole1), this.useCheeseOnHole2);
        goPoisonRats.addStep(new Conditions(this.inGiantRatArea, this.poisonedCheese1), this.useCheeseOnHole1);
        goPoisonRats.addStep(new Conditions(this.inGiantRatArea), this.useRatPoisonOnCheese);
        steps.put(50, goPoisonRats);
        ConditionalStep goToJackAfterPoisoning = new ConditionalStep((QuestHelper)this, this.talkToJackAfterCheese, new Requirement[0]);
        goToJackAfterPoisoning.addStep(this.inGiantRatArea, this.goDownToJack);
        steps.put(55, goToJackAfterPoisoning);
        steps.put(57, goToJackAfterPoisoning);
        steps.put(60, this.talkToApoth);
        steps.put(65, this.talkToApoth);
        steps.put(70, this.talkToJackAfterApoth);
        steps.put(75, this.talkToJackAfterCure);
        ConditionalStep goKillBigRat = new ConditionalStep((QuestHelper)this, this.climbJackLadderAgain, new Requirement[0]);
        goKillBigRat.addStep(this.inGiantRatArea, this.useCatOnHole);
        steps.put(80, goKillBigRat);
        ConditionalStep goTalkToJackAfterFight = new ConditionalStep((QuestHelper)this, this.talkToJackAfterFight, new Requirement[0]);
        goTalkToJackAfterFight.addStep(this.inGiantRatArea, this.goDownToJackAfterFight);
        steps.put(85, goTalkToJackAfterFight);
        ConditionalStep goTalkToJoe = new ConditionalStep((QuestHelper)this, this.travelToKeldagrim, new Requirement[0]);
        goTalkToJoe.addStep(this.inKelgdagrim, this.talkToSmokinJoe);
        steps.put(90, goTalkToJoe);
        ConditionalStep goSmokeHole = new ConditionalStep((QuestHelper)this, this.travelToKeldagrim, new Requirement[0]);
        goSmokeHole.addStep(new Conditions(this.inKelgdagrim, this.smoulderingPot, this.catSeenFailure), this.usePotOnHoleAgain);
        goSmokeHole.addStep(new Conditions(this.inKelgdagrim, this.smoulderingPot), this.usePotOnHole);
        goSmokeHole.addStep(new Conditions(this.inKelgdagrim), this.lightWeeds);
        steps.put(95, goSmokeHole);
        ConditionalStep goTalkToJoeAgain = new ConditionalStep((QuestHelper)this, this.travelToKeldagrim, new Requirement[0]);
        goTalkToJoeAgain.addStep(this.inKelgdagrim, this.talkToJoeAgain);
        steps.put(100, goTalkToJoeAgain);
        ConditionalStep goTalkToFelk = new ConditionalStep((QuestHelper)this, this.enterSarimRatPits, new Requirement[0]);
        goTalkToFelk.addStep(this.inRatPit, this.talkToFelkrash);
        steps.put(105, goTalkToFelk);
        ConditionalStep goTalkToFace = new ConditionalStep((QuestHelper)this, this.talkToTheFaceAgain, new Requirement[0]);
        goTalkToFace.addStep(this.inRatPit, this.leaveSarimRatPits);
        steps.put(110, goTalkToFace);
        steps.put(115, this.useCoinOnPot);
        ConditionalStep goKillRats = new ConditionalStep((QuestHelper)this, this.returnToSarim, new Requirement[0]);
        goKillRats.addStep(new Conditions(this.inPortSarim, this.inPlayWidget), this.playSnakeCharm);
        goKillRats.addStep(this.inPortSarim, this.clickSnakeCharm);
        steps.put(120, goKillRats);
        ConditionalStep goFinishQuest = new ConditionalStep((QuestHelper)this, this.enterPitsForEnd, new Requirement[0]);
        goFinishQuest.addStep(this.inRatPit, this.talkToFelkrashForEnd);
        steps.put(125, goFinishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cat = new FollowerItemRequirement("A non-overgrown cat", ItemCollections.HUNTING_CATS, NpcCollections.getHuntingCats()).isNotConsumed();
        this.catFollower = new FollowerRequirement("A non-overgrown cat following you", NpcCollections.getHuntingCats());
        this.ratPoison = new ItemRequirement("Rat poison", 24);
        this.ratPoison.canBeObtainedDuringQuest();
        this.cheese = new ItemRequirement("Cheese", 1985);
        this.cheese.addAlternates(6768);
        this.marrentill = new ItemRequirement("Marrentill", 251);
        this.unicornHornDust = new ItemRequirement("Unicorn horn dust", 235);
        this.bucketOfMilk = new ItemRequirement("Bucket of milk", 1927);
        this.catspeakAmuletOrDS2 = new ItemRequirement("Catspeak amulet", 4677);
        this.catspeakAmuletOrDS2.addAlternates(6544);
        this.potOfWeeds = new ItemRequirement("Pot of weeds", 6771);
        this.potOfWeeds.setTooltip("You can make this by using some weeds on a pot");
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.coins101 = new ItemRequirement("Coins", ItemCollections.COINS, 101);
        this.coin = new ItemRequirement("Coins", ItemCollections.COINS);
        this.kwuarm = new ItemRequirement("Clean kwuarm", 263);
        this.redEggs = new ItemRequirement("Red spiders' eggs", 223);
        this.vial = new ItemRequirement("Empty vial", 229);
        this.snakeCharm = new ItemRequirement("Snake charm", 4605).isNotConsumed();
        this.snakeCharm.canBeObtainedDuringQuest();
        this.fish8 = new ItemRequirement("Fish or more, raw or cooked", ItemCollections.FISH_FOOD, 8);
        this.fish8.addAlternates(ItemCollections.RAW_FISH);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.sarimTeleport = new ItemRequirement("Port Sarim teleport", ItemCollections.AMULET_OF_GLORIES);
        this.sarimTeleport.addAlternates(19615);
        this.pollnivneachTeleport = new ItemRequirement("Pollnivneach teleport", 11743);
        this.ardougneTeleport = new ItemRequirement("Ardougne teleport", 8011);
        this.ardougneTeleport.addAlternates(13121, 13122, 13123, 13124);
        this.keldagrimTeleport = new ItemRequirement("Mine cart access to Keldagrim from the GE", -1, -1);
        this.keldagrimTeleport.setDisplayItemId(5020);
        this.carpetCoins = new ItemRequirement("Coins for magic carpet travel", ItemCollections.COINS, 1000);
        this.directions = new ItemRequirement("Directions", 6770);
        this.poisonedCheese1 = new ItemRequirement("Poisoned cheese", 6768);
        this.poisonedCheese2 = new ItemRequirement("Poisoned cheese", 6768, 2);
        this.poisonedCheese3 = new ItemRequirement("Poisoned cheese", 6768, 3);
        this.poisonedCheese4 = new ItemRequirement("Poisoned cheese", 6768, 4);
        this.smoulderingPot = new ItemRequirement("Smouldering pot", 6772);
        this.catantipoison = new ItemRequirement("Cat antipoison", 6766);
        this.catantipoison.setTooltip("You can get another from the Apothecary");
        this.musicScroll = new ItemRequirement("Music scroll", 6769);
        this.musicScroll.setTooltip("You can get another from the snake charmer");
    }

    public void loadZones() {
        this.varrockSewer = new Zone(new WorldPoint(3151, 9855, 0), new WorldPoint(3290, 9919, 0));
        this.mansionGrounds = new Zone(new WorldPoint(2821, 5061, 0), new WorldPoint(2874, 5120, 0));
        this.mansionF0 = new Zone(new WorldPoint(2831, 5085, 0), new WorldPoint(2864, 5101, 0));
        this.mansionF1 = new Zone(new WorldPoint(2829, 5083, 1), new WorldPoint(2869, 5108, 2));
        this.giantRatArea = new Zone(new WorldPoint(3263, 3375, 1), new WorldPoint(3274, 3386, 2));
        this.keldagrim = new Zone(new WorldPoint(2816, 10112, 0), new WorldPoint(2950, 10239, 3));
        this.ratPit = new Zone(new WorldPoint(2945, 9622, 0), new WorldPoint(3005, 9680, 0));
        this.portSarim = new Zone(new WorldPoint(3019, 3232, 0));
    }

    public void setupConditions() {
        this.inVarrockSewer = new ZoneRequirement(this.varrockSewer);
        this.inMansionGrounds = new ZoneRequirement(this.mansionGrounds);
        this.inMansionF0 = new ZoneRequirement(this.mansionF0);
        this.inMansionF1 = new ZoneRequirement(this.mansionF1);
        this.inGiantRatArea = new ZoneRequirement(this.giantRatArea);
        this.inKelgdagrim = new ZoneRequirement(this.keldagrim);
        this.inRatPit = new ZoneRequirement(this.ratPit);
        this.inPortSarim = new ZoneRequirement(this.portSarim);
        this.caughtRat1 = new VarbitRequirement(1424, 1);
        this.caughtRat2And3 = new Conditions(new VarbitRequirement(1425, 1), new VarbitRequirement(1426, 1));
        this.poisonedHole1 = new VarbitRequirement(1406, 1);
        this.poisonedHole2 = new VarbitRequirement(1407, 1);
        this.poisonedHole3 = new VarbitRequirement(1408, 1);
        this.poisonedHole4 = new VarbitRequirement(1409, 1);
        this.catSeenFailure = new VarbitRequirement(1410, 1);
        this.inPlayWidget = new WidgetTextRequirement(282, 20, "PLAY");
    }

    public void setupSteps() {
        this.talkToGertrude = new NpcStep((QuestHelper)this, 7723, new WorldPoint(3151, 3413, 0), "Talk to Gertrude west of Varrock.", this.catspeakAmuletOrDS2.equipped());
        this.enterSewer = new ObjectStep((QuestHelper)this, 882, new WorldPoint(3237, 3458, 0), "Go down into Varrock Sewer via the Manhole south east of Varrock Castle.", this.cat);
        ((ObjectStep)this.enterSewer).addAlternateObjects(881);
        this.talkToPhingspet = new NpcStep((QuestHelper)this, 4587, new WorldPoint(3243, 9867, 0), "Talk to Phingspet in Varrock Sewer.", this.cat);
        this.catch8Rats = new NpcStep((QuestHelper)this, 2854, new WorldPoint(3243, 9867, 0), "Have your cat catch 8 rats.", true, this.catFollower);
        ((NpcStep)this.catch8Rats).setHideWorldArrow(true);
        this.talkToPhingspetAgain = new NpcStep((QuestHelper)this, 4587, new WorldPoint(3243, 9867, 0), "Talk to Phingspet in Varrock Sewer again.", new Requirement[0]);
        this.talkToJimmy = new NpcStep((QuestHelper)this, 4589, new WorldPoint(2563, 3320, 0), "Talk to Jimmy Dazzler north of Ardougne Castle.", this.cat);
        this.readDirections = new DetailedQuestStep((QuestHelper)this, "Read the directions.", this.cat, this.directions.highlighted());
        this.readDirections.addDialogStep("Follow the directions to the house.");
        this.climbTrellis = new ObjectStep((QuestHelper)this, 10323, new WorldPoint(2844, 5105, 0), "Climb the trellis around the back of the mansion, avoiding the guards. You may need to deviate from the marked path depending on what the guards are doing.", new Requirement[0]);
        ((ObjectStep)this.climbTrellis).setLinePoints(Arrays.asList(new WorldPoint(2847, 5066, 0), new WorldPoint(2840, 5066, 0), new WorldPoint(2840, 5075, 0), new WorldPoint(2826, 5075, 0), new WorldPoint(2826, 5082, 0), new WorldPoint(2824, 5084, 0), new WorldPoint(2824, 5088, 0), new WorldPoint(2826, 5090, 0), new WorldPoint(2826, 5093, 0), new WorldPoint(2824, 5095, 0), new WorldPoint(2824, 5099, 0), new WorldPoint(2826, 5101, 0), new WorldPoint(2826, 5111, 0), new WorldPoint(2835, 5112, 0), new WorldPoint(2837, 5112, 0), new WorldPoint(2837, 5111, 0), new WorldPoint(2844, 5105, 0)));
        this.climbTrellisNoPath = new ObjectStep((QuestHelper)this, 10323, new WorldPoint(2844, 5105, 0), "Climb the trellis.", new Requirement[0]);
        this.climbTrellis.addSubSteps(this.climbTrellisNoPath);
        this.catchRat1 = new NpcStep((QuestHelper)this, 4593, new WorldPoint(2835, 5098, 1), "Catch the rat in the north west room with your cat.", this.catFollower);
        this.catchRat1.addTileMarker(new WorldPoint(2841, 5104, 1), 162);
        this.catchRat1.setMaxRoamRange(7);
        this.catchRat2And3 = new NpcStep((QuestHelper)this, 4593, new WorldPoint(2859, 5091, 1), "Hide in the north east room until it's safe to go to the south east room, then catch the rats there.", true, new Requirement[0]);
        this.catchRat2And3.addTileMarker(new WorldPoint(2857, 5098, 1), 162);
        this.climbDownLadderInMansion = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2862, 5092, 1), "Climb down the ladder.", new Requirement[0]);
        this.catchRemainingRats = new NpcStep((QuestHelper)this, 4593, new WorldPoint(2860, 5093, 0), "Catch the 3 rats down here.", true, this.catFollower);
        this.talkToJimmyAgain = new NpcStep((QuestHelper)this, 4589, new WorldPoint(2563, 3320, 0), "Talk to Jimmy Dazzler again.", this.cat);
        this.talkToJack = new NpcStep((QuestHelper)this, 4588, new WorldPoint(3268, 3401, 0), "Talk to Hooknosed Jack in south east Varrock.  You can give Jack your vial, kwuarm, and red spiders' eggs for the rat poison", this.cat, this.kwuarm, this.vial, this.redEggs);
        this.climbJackLadder = new ObjectStep((QuestHelper)this, 11794, new WorldPoint(3268, 3379, 0), "Climb up the ladder south of Jack.", this.cheese.quantity(4), this.ratPoison);
        this.useRatPoisonOnCheese = new DetailedQuestStep((QuestHelper)this, "Add rat poison to your cheese.", this.ratPoison.highlighted(), this.cheese.highlighted());
        this.useCheeseOnHole1 = new ObjectStep((QuestHelper)this, 10346, new WorldPoint(3265, 3378, 1), "Use a poisoned cheese on the rat holes.", this.poisonedCheese1.highlighted());
        this.useCheeseOnHole2 = new ObjectStep((QuestHelper)this, 10347, new WorldPoint(3273, 3377, 1), "Use a poisoned cheese on the rat holes.", this.poisonedCheese1.highlighted());
        this.useCheeseOnHole3 = new ObjectStep((QuestHelper)this, 10348, new WorldPoint(3273, 3381, 1), "Use a poisoned cheese on the rat holes.", this.poisonedCheese1.highlighted());
        this.useCheeseOnHole4 = new ObjectStep((QuestHelper)this, 10349, new WorldPoint(3271, 3384, 1), "Use a poisoned cheese on the rat holes.", this.poisonedCheese1.highlighted());
        this.useCheeseOnHole1.addSubSteps(this.useCheeseOnHole2, this.useCheeseOnHole3, this.useCheeseOnHole4);
        this.goDownToJack = new ObjectStep((QuestHelper)this, 11795, new WorldPoint(3268, 3379, 1), "Return to Jack.", new Requirement[0]);
        this.talkToJackAfterCheese = new NpcStep((QuestHelper)this, 4588, new WorldPoint(3268, 3401, 0), "Return to Jack.", this.cat);
        this.talkToJackAfterCheese.addDialogSteps("Can I help?");
        this.talkToJackAfterCheese.addSubSteps(this.goDownToJack);
        this.talkToApoth = new NpcStep((QuestHelper)this, 5036, new WorldPoint(3196, 3404, 0), "Talk to the Apothecary in west Varrock.", this.bucketOfMilk, this.unicornHornDust, this.marrentill);
        this.talkToApoth.addDialogSteps("Talk about something else.", "Talk about the Ratcatchers Quest.");
        this.talkToJackAfterApoth = new NpcStep((QuestHelper)this, 4588, new WorldPoint(3268, 3401, 0), "Talk to Jack again.", this.catantipoison, this.cat);
        this.talkToJackAfterCure = new NpcStep((QuestHelper)this, 4588, new WorldPoint(3268, 3401, 0), "Talk to Jack again.", this.catantipoison, this.cat);
        this.talkToJackAfterApoth.addSubSteps(this.talkToJackAfterCure);
        this.climbJackLadderAgain = new ObjectStep((QuestHelper)this, 11794, new WorldPoint(3268, 3379, 0), "Climb up the ladder south of Jack.", this.cat, this.fish8);
        this.useCatOnHole = new ObjectStep((QuestHelper)this, 10320, new WorldPoint(3270, 3379, 1), "Use your cat on the hole in the wall. You'll need to feed it by using fish ON THE WALL whenever its health gets low.", this.cat.highlighted(), this.fish8);
        this.useCatOnHole.addDialogStep("Yes");
        this.feedCatAsItFights = new ObjectStep((QuestHelper)this, 10320, new WorldPoint(3270, 3379, 1), "Use fish on the wall whenever your cat's health gets low.", this.fish8.highlighted());
        this.goDownToJackAfterFight = new ObjectStep((QuestHelper)this, 11795, new WorldPoint(3268, 3379, 1), "Return to Jack.", new Requirement[0]);
        this.talkToJackAfterFight = new NpcStep((QuestHelper)this, 4588, new WorldPoint(3268, 3401, 0), "Return to Jack.", new Requirement[0]);
        this.talkToJackAfterFight.addSubSteps(this.goDownToJackAfterFight);
        this.travelToKeldagrim = new ObjectStep((QuestHelper)this, 16168, new WorldPoint(3140, 3504, 0), "Travel to Keldagrim.", this.cat, this.potOfWeeds, this.tinderbox);
        this.talkToSmokinJoe = new NpcStep((QuestHelper)this, 4592, new WorldPoint(2929, 10213, 0), "Talk to Smokin' Joe in the north east of Keldagrim.", this.cat, this.potOfWeeds, this.tinderbox);
        this.talkToSmokinJoe.addDialogStep("I could help you.");
        this.lightWeeds = new DetailedQuestStep((QuestHelper)this, "Use a tinderbox on the pot of weeds.", this.potOfWeeds.highlighted(), this.tinderbox.highlighted());
        this.usePotOnHole = new ObjectStep((QuestHelper)this, 10350, new WorldPoint(2933, 10212, 0), "Use the smouldering pot on the hole east of Joe with your cat following you and your catspeak amulet equipped.", this.smoulderingPot.highlighted(), this.catFollower, this.catspeakAmuletOrDS2.equipped());
        this.usePotOnHole.addIcon(6772);
        this.usePotOnHoleAgain = new ObjectStep((QuestHelper)this, 10350, new WorldPoint(2933, 10212, 0), "Use the smouldering pot on the rat hole again.", this.smoulderingPot.highlighted(), this.catFollower, this.catspeakAmuletOrDS2.equipped());
        this.usePotOnHoleAgain.addIcon(6772);
        this.talkToJoeAgain = new NpcStep((QuestHelper)this, 4592, new WorldPoint(2929, 10213, 0), "Talk to Smokin' Joe again.", new Requirement[0]);
        this.enterSarimRatPits = new ObjectStep((QuestHelper)this, 10321, new WorldPoint(3018, 3232, 0), "Go down the manhole near The Face.", new Requirement[0]);
        this.talkToFelkrash = new NpcStep((QuestHelper)this, 4591, new WorldPoint(2978, 9640, 0), "Talk to Felkrash in the Port Sarim Rat Pits.", new Requirement[0]);
        ((NpcStep)this.talkToFelkrash).setWorldMapPoint(new WorldPoint(3044, 9645, 0));
        this.leaveSarimRatPits = new ObjectStep((QuestHelper)this, 10309, new WorldPoint(2962, 9651, 0), "Leave the rat pits.", new Requirement[0]);
        this.talkToTheFaceAgain = new NpcStep((QuestHelper)this, 4590, new WorldPoint(3019, 3232, 0), "Talk to The Face in Port Sarim again.", this.cat, this.catspeakAmuletOrDS2);
        this.useCoinOnPot = new ObjectStep((QuestHelper)this, 6230, new WorldPoint(3355, 2953, 0), "Use a coin on the pot next to the Snake Charmer in Pollnivneach.", this.coin.quantity(101).highlighted());
        this.useCoinOnPot.addDialogSteps("I want to talk to you about animal charming.", "Forget about it. I don't care.", "What if I offered you some money?", "Walk away slowly", "Stop");
        this.useCoinOnPot.addIcon(617);
        this.returnToSarim = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3019, 3232, 0), "Return to just outside the Port Sarim Rat Pits.", this.snakeCharm, this.musicScroll);
        this.clickSnakeCharm = new DetailedQuestStep((QuestHelper)this, "Click your snake charm and play it.", this.snakeCharm.highlighted());
        this.playSnakeCharm = new RatCharming(this);
        this.enterPitsForEnd = new ObjectStep((QuestHelper)this, 10321, new WorldPoint(3018, 3232, 0), "Return to Felkrash to finish.", new Requirement[0]);
        this.talkToFelkrashForEnd = new NpcStep((QuestHelper)this, 4591, new WorldPoint(2978, 9640, 0), "Return to Felkrash to finish.", new Requirement[0]);
        ((NpcStep)this.talkToFelkrashForEnd).setWorldMapPoint(new WorldPoint(3044, 9645, 0));
        this.talkToFelkrashForEnd.addSubSteps(this.enterPitsForEnd);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.cat, this.cheese.quantity(4), this.marrentill, this.unicornHornDust, this.bucketOfMilk, this.catspeakAmuletOrDS2, this.vial, this.kwuarm, this.redEggs, this.potOfWeeds, this.tinderbox, this.coins101, this.snakeCharm, this.fish8);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ratPoison, this.varrockTeleport, this.sarimTeleport, this.pollnivneachTeleport, this.ardougneTeleport, this.keldagrimTeleport, this.carpetCoins);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestState.FINISHED));
        req.add(new VarbitRequirement(QuestVarbits.QUEST_THE_GIANT_DWARF.getId(), Operation.GREATER_EQUAL, 1, "Started The Giant Dwarf"));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 4500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Rat Pole", 6773, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Rat Pits"), new UnlockReward("Ability to train Overgrown Cats into Wiley and Lazy Cats"));
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("Alternatively, rat poison could be obtained in the basement of the Clocktower south of East Ardougne. If you already have the rat poison it follows that you would not need the vial, red spiders' eggs, or kwuarm.");
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToGertrude, this.enterSewer, this.talkToPhingspet, this.catch8Rats, this.talkToPhingspetAgain), this.cat));
        allSteps.add(new PanelDetails("Helping Jimmy", Arrays.asList(this.talkToJimmy, this.readDirections, this.climbTrellis, this.catchRat1, this.catchRat2And3, this.climbDownLadderInMansion, this.catchRemainingRats, this.talkToJimmyAgain), this.cat));
        allSteps.add(new PanelDetails("Helping Jack", Arrays.asList(this.talkToJack, this.useRatPoisonOnCheese, this.climbJackLadder, this.useCheeseOnHole1, this.talkToJackAfterCheese, this.talkToApoth, this.talkToJackAfterApoth, this.climbJackLadderAgain, this.useCatOnHole, this.feedCatAsItFights, this.talkToJackAfterFight), this.cheese.quantity(4), this.bucketOfMilk, this.marrentill, this.unicornHornDust, this.cat, this.fish8, this.vial, this.kwuarm, this.redEggs, this.ratPoison));
        allSteps.add(new PanelDetails("Helping Joe", Arrays.asList(this.travelToKeldagrim, this.talkToSmokinJoe, this.usePotOnHole, this.usePotOnHoleAgain, this.talkToJoeAgain), this.cat, this.catspeakAmuletOrDS2, this.potOfWeeds, this.tinderbox));
        allSteps.add(new PanelDetails("Helping Felkrash", Arrays.asList(this.enterSarimRatPits, this.talkToFelkrash, this.leaveSarimRatPits, this.talkToTheFaceAgain, this.useCoinOnPot, this.returnToSarim, this.clickSnakeCharm, this.talkToFelkrashForEnd), this.snakeCharm, this.coins101));
        return allSteps;
    }
}

