/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ragandboneman;

import com.questhelper.bank.QuestBank;
import com.questhelper.helpers.quests.ragandboneman.RagBoneState;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RagBoneGroups {
    public static List<RagBoneState> getRagBoneIStates() {
        return Arrays.asList(RagBoneState.GIANT_RAT_BONE, RagBoneState.UNICORN_BONE, RagBoneState.BEAR_RIBS, RagBoneState.RAM_SKULL, RagBoneState.GOBLIN_SKULL, RagBoneState.BIG_FROG_LEGS, RagBoneState.MONKEY_PAW, RagBoneState.GIANT_BAT_WING);
    }

    public static List<RagBoneState> getRagBoneIIStates() {
        return Arrays.asList(RagBoneState.BAT_WING, RagBoneState.UNDEAD_COW_RIBS, RagBoneState.EXPERIMENT_BONE, RagBoneState.WEREWOLF_BONE, RagBoneState.GHOUL_BONE, RagBoneState.ZOMBIE_BONE, RagBoneState.RAT_BONE, RagBoneState.MOSS_GIANT_BONE, RagBoneState.CAVE_GOBLIN_SKULL, RagBoneState.JACKAL_BONE, RagBoneState.SNAKE_SPINE, RagBoneState.DESERT_LIZARD_BONE, RagBoneState.VULTURE_WING, RagBoneState.SEAGULL_WING, RagBoneState.ICE_GIANT_RIBS, RagBoneState.MOGRE_BONE, RagBoneState.JOGRE_BONE, RagBoneState.BABY_DRAGON_BONE, RagBoneState.TROLL_BONE, RagBoneState.RABBIT_BONE, RagBoneState.BASILISK_BONE, RagBoneState.DAGANNOTH_RIBS, RagBoneState.FIRE_GIANT_BONE, RagBoneState.TERRORBIRD_WING, RagBoneState.WOLF_BONE, RagBoneState.OGRE_BONE, RagBoneState.ZOGRE_BONE);
    }

    public static List<ItemRequirement> getBones(List<RagBoneState> states) {
        ArrayList<ItemRequirement> bones = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneState : states) {
            bones.add(ragBoneState.getBoneItem());
        }
        return bones;
    }

    public static List<Requirement> getBonesOnFloor(List<ItemRequirement> bones) {
        ArrayList<Requirement> bonesOnFloor = new ArrayList<Requirement>();
        for (ItemRequirement bone : bones) {
            bonesOnFloor.add(new ItemOnTileRequirement(bone));
        }
        return bonesOnFloor;
    }

    public static List<Requirement> allBonesObtained(List<RagBoneState> states, QuestBank questBank) {
        ArrayList<Requirement> boneReq = new ArrayList<Requirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.hadBoneItem(questBank));
        }
        return boneReq;
    }

    public static List<Requirement> allBonesAddedToVinegar(List<RagBoneState> states, QuestBank questBank) {
        ArrayList<Requirement> boneReq = new ArrayList<Requirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.hadBoneInVinegarItem(questBank));
        }
        return boneReq;
    }

    public static List<Requirement> allBonesPolished(List<RagBoneState> states, QuestBank questBank) {
        ArrayList<Requirement> boneReq = new ArrayList<Requirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.boneProcessed(questBank));
        }
        return boneReq;
    }

    public static List<ItemRequirement> pickupBones(List<RagBoneState> states) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneItem().hideConditioned(new Conditions(LogicType.NOR, new ItemOnTileRequirement(ragBoneIState.getBoneItem()))));
        }
        return boneReq;
    }

    public static List<ItemRequirement> bonesToAddToVinegar(List<RagBoneState> states, QuestBank questBank) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneItem().hideConditioned(ragBoneIState.hadBoneInVinegarItem(questBank)).highlighted());
        }
        return boneReq;
    }

    public static List<ItemRequirement> bonesToAddToBoiler(List<RagBoneState> states, QuestBank questBank) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneInVinegarItem().hideConditioned(new Conditions(LogicType.OR, ragBoneIState.boneProcessed(questBank))).highlighted());
        }
        return boneReq;
    }

    public static List<ItemRequirement> dirtyBonesNotHandedIn(List<RagBoneState> states) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneItem().hideConditioned(ragBoneIState.handedInBone()));
        }
        return boneReq;
    }

    public static List<ItemRequirement> vinegarBonesNotHandedIn(List<RagBoneState> states) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneInVinegarItem().hideConditioned(ragBoneIState.handedInBone()));
        }
        return boneReq;
    }

    public static List<ItemRequirement> cleanBonesNotHandedIn(List<RagBoneState> states) {
        ArrayList<ItemRequirement> boneReq = new ArrayList<ItemRequirement>();
        for (RagBoneState ragBoneIState : states) {
            boneReq.add(ragBoneIState.getBoneCleanedItem().hideConditioned(ragBoneIState.handedInBone()));
        }
        return boneReq;
    }
}

