/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ragandboneman;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.helpers.quests.ragandboneman.RagBoneGroups;
import com.questhelper.helpers.quests.ragandboneman.RagBoneState;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.QuestTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.RAG_AND_BONE_MAN_II)
public class RagAndBoneManII
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement pots;
    ItemRequirement logs;
    ItemRequirement tinderbox;
    ItemRequirement lightSource;
    ItemRequirement rope;
    ItemRequirement dustyKey;
    ItemRequirement mirrorShield;
    ItemRequirement iceCooler;
    ItemRequirement fishingExplosive;
    ItemRequirement coinsOrVinegar;
    ItemRequirement antifireShield;
    ItemRequirement inoculationBracelet;
    ItemRequirement digsitePendant;
    ItemRequirement ectophial;
    ItemRequirement ringOfDueling;
    ItemRequirement gamesNecklace;
    ItemRequirement varrockTeleport;
    ItemRequirement lumbridgeTeleport;
    ItemRequirement nardahTeleport;
    ItemRequirement draynorTeleport;
    ItemRequirement karamjaTeleport;
    ItemRequirement taverleyTeleport;
    ItemRequirement rellekkaTeleport;
    ItemRequirement gnomeTeleport;
    ItemRequirement feldipTeleport;
    ItemRequirement dramenStaff;
    ItemRequirement rellekkaNETeleport;
    ItemRequirement jugOfVinegar;
    ItemRequirement jugOfVinegarNeeded;
    ItemRequirement potOfVinegar;
    ItemRequirement potOfVinegarNeeded;
    ItemRequirement potNeeded;
    ItemRequirement axe;
    ItemRequirement jailKey;
    ItemRequirement boneInVinegar;
    DetailedQuestStep finishP1;
    DetailedQuestStep killBat;
    DetailedQuestStep killUndeadCow;
    DetailedQuestStep killExperiment;
    DetailedQuestStep killWerewolf;
    DetailedQuestStep killGhoul;
    DetailedQuestStep enterSewer;
    DetailedQuestStep killZombie;
    DetailedQuestStep killRat;
    DetailedQuestStep killMossGiant;
    DetailedQuestStep killCaveGoblin;
    DetailedQuestStep killJackal;
    DetailedQuestStep killLizard;
    DetailedQuestStep killVulture;
    DetailedQuestStep killSeagull;
    DetailedQuestStep enterAsgarniaDungeon;
    DetailedQuestStep killIceGiant;
    DetailedQuestStep killMogre;
    DetailedQuestStep killSnake;
    DetailedQuestStep killJogre;
    DetailedQuestStep enterBrimhavenDungeon;
    DetailedQuestStep killFireGiant;
    DetailedQuestStep enterTaverleyDungeon;
    DetailedQuestStep killBabyBlueDragon;
    DetailedQuestStep killTroll;
    DetailedQuestStep killRabbit;
    DetailedQuestStep enterFremmyDungeon;
    DetailedQuestStep killBasilisk;
    DetailedQuestStep travelToWaterbirth;
    DetailedQuestStep enterWaterbirthDungeon;
    DetailedQuestStep killDagannoth;
    DetailedQuestStep killTerrorbird;
    DetailedQuestStep killWolf;
    DetailedQuestStep killOgre;
    DetailedQuestStep killZogre;
    DetailedQuestStep pickupBone;
    DetailedQuestStep enterExperimentCave;
    DetailedQuestStep throwExplosive;
    DetailedQuestStep goThroughPipe;
    DetailedQuestStep killJailerForKey;
    DetailedQuestStep getDustyFromAdventurer;
    DetailedQuestStep enterDeeperTaverley;
    DetailedQuestStep pickUpJailKey;
    DetailedQuestStep addRope;
    DetailedQuestStep enterSwamp;
    DetailedQuestStep leaveJunaRoom;
    DetailedQuestStep enterKeldagrimCave;
    DetailedQuestStep makePotOfVinegar;
    DetailedQuestStep useBonesOnVinegar;
    DetailedQuestStep placeLogs;
    DetailedQuestStep useBoneOnBoiler;
    DetailedQuestStep lightLogs;
    DetailedQuestStep waitForCooking;
    DetailedQuestStep removePot;
    DetailedQuestStep repeatSteps;
    DetailedQuestStep giveBones;
    DetailedQuestStep talkToFinish;
    Requirement inSwamp;
    Requirement inJunaRoom;
    Requirement inExperimentCave;
    Requirement inVarrockSewer;
    Requirement inAsgarniaDungeon;
    Requirement inBrimhavenDungeon;
    Requirement inTaverleyDungeon;
    Requirement inTrollCave;
    Requirement inFremennikSlayerDungeon;
    Requirement onWaterbirth;
    Requirement inWaterbirthDungeon;
    Requirement addedRope;
    Requirement inDeepTaverleyDungeon;
    Requirement inJailCell;
    Requirement boneNearby;
    Requirement hadAllBones;
    Requirement jailKeyOnFloor;
    Requirement mogreNearby;
    Requirement hadVinegar;
    Requirement allBonesAtLeastAddedToVinegar;
    Requirement allBonesPolished;
    Requirement logAdded;
    Requirement boneAddedToBoiler;
    Requirement logLit;
    Requirement boneReady;
    Zone swamp;
    Zone junaRoom;
    Zone experimentCave;
    Zone varrockSewer;
    Zone asgarniaDungeon;
    Zone brimhavenDungeon;
    Zone taverleyDungeon;
    Zone trollCave;
    Zone fremennikSlayerDungeon;
    Zone waterbirth;
    Zone waterbirthDungeon;
    Zone deepTaverleyDungeon1;
    Zone deepTaverleyDungeon2;
    Zone deepTaverleyDungeon3;
    Zone deepTaverleyDungeon4;
    Zone jailCell;
    ConditionalStep morySteps;
    ConditionalStep varrockSteps;
    ConditionalStep lumbridgeSteps;
    ConditionalStep desertSteps;
    ConditionalStep sarimSteps;
    ConditionalStep karamjaSteps;
    ConditionalStep taverleySteps;
    ConditionalStep fremennikSteps;
    ConditionalStep strongholdSteps;
    ConditionalStep feldipSteps;
    ConditionalStep collectBonesSteps;
    ConditionalStep preparingBonesSteps;
    ConditionalStep cookingSteps;
    HashMap<RagBoneState, QuestStep> stepsForRagAndBoneManII = new LinkedHashMap<RagBoneState, QuestStep>();
    HashMap<RagBoneState, QuestStep> mapForMory = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> moryReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForVarrock = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> varrockReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForLumbridge = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> lumbridgeReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForDesert = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> desertReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForSarim = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> sarimReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForKaramja = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> karamjaReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForTaverley = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> taverleyReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForFremennik = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> fremennikReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForStronghold = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> strongholdReqsList = new ArrayList<Requirement>();
    HashMap<RagBoneState, QuestStep> mapForFeldip = new LinkedHashMap<RagBoneState, QuestStep>();
    List<Requirement> feldipReqsList = new ArrayList<Requirement>();
    Conditions moryReqs;
    Conditions varrockReqs;
    Conditions lumbridgeReqs;
    Conditions desertReqs;
    Conditions sarimReqs;
    Conditions karamjaReqs;
    Conditions taverleyReqs;
    Conditions fremennikReqs;
    Conditions strongholdReqs;
    Conditions feldipReqs;
    ConditionalStep pickupBoneSteps;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.preparingBonesSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.makePotOfVinegar, new Requirement[0]);
        this.preparingBonesSteps.addStep(this.potOfVinegarNeeded, this.useBonesOnVinegar);
        this.preparingBonesSteps.setLockingCondition(this.allBonesAtLeastAddedToVinegar);
        this.cookingSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.placeLogs, new Requirement[0]);
        this.cookingSteps.addStep(this.boneReady, this.removePot);
        this.cookingSteps.addStep(this.logLit, this.waitForCooking);
        this.cookingSteps.addStep(this.boneAddedToBoiler, this.lightLogs);
        this.cookingSteps.addStep(this.logAdded, this.useBoneOnBoiler);
        this.cookingSteps.setLockingCondition(this.allBonesPolished);
        this.collectBonesSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state general.", new Requirement[0]), new Requirement[0]);
        this.collectBonesSteps.addStep(this.boneNearby, this.pickupBoneSteps);
        this.collectBonesSteps.addStep(this.allBonesPolished, this.giveBones);
        this.collectBonesSteps.addStep(this.allBonesAtLeastAddedToVinegar, this.cookingSteps);
        this.collectBonesSteps.addStep(this.hadAllBones, this.preparingBonesSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.moryReqs), this.morySteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.varrockReqs), this.varrockSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.lumbridgeReqs), this.lumbridgeSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.desertReqs), this.desertSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.sarimReqs), this.sarimSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.karamjaReqs), this.karamjaSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.taverleyReqs), this.taverleySteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.fremennikReqs), this.fremennikSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.strongholdReqs), this.strongholdSteps);
        this.collectBonesSteps.addStep(LogicHelper.nor(this.feldipReqs), this.feldipSteps);
        this.collectBonesSteps.setLockingCondition(this.hadAllBones);
        steps.put(0, this.finishP1);
        steps.put(1, this.finishP1);
        steps.put(2, this.finishP1);
        steps.put(3, this.finishP1);
        steps.put(4, this.collectBonesSteps);
        steps.put(5, this.talkToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS);
        this.pots = new ItemRequirement("Pot", 1931).isNotConsumed();
        this.potNeeded = new ItemRequirement("Pot", 1931, 8).alsoCheckBank(this.questBank).highlighted().isNotConsumed();
        this.logs = new ItemRequirement("Logs", 1511);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.dustyKey = new KeyringRequirement("Dusty Key", this.configManager, KeyringCollection.DUSTY_KEY).isNotConsumed();
        this.dustyKey.canBeObtainedDuringQuest();
        this.mirrorShield = new ItemRequirement("Mirror shield", 4156).isNotConsumed();
        this.mirrorShield.addAlternates(24265, 24266);
        this.iceCooler = new ItemRequirement("Ice coolers", 6696, 10);
        this.fishingExplosive = new ItemRequirement("Fishing explosive", 6660, 10);
        this.fishingExplosive.addAlternates(6664);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge teleport", 8008);
        this.digsitePendant = new ItemRequirement("Digsite pendant", ItemCollections.DIGSITE_PENDANTS);
        this.draynorTeleport = new ItemRequirement("Draynor teleport", ItemCollections.AMULET_OF_GLORIES);
        this.draynorTeleport.addAlternates(19615);
        this.karamjaTeleport = new ItemRequirement("Karamja teleport", ItemCollections.AMULET_OF_GLORIES);
        this.karamjaTeleport.addAlternates(11745, 12409);
        this.antifireShield = new ItemRequirement("Antifire shield", ItemCollections.ANTIFIRE_SHIELDS).isNotConsumed();
        this.inoculationBracelet = new ItemRequirement("Inoculation bracelet or a potion for Disease", ItemCollections.ANTIDISEASE);
        this.ectophial = new ItemRequirement("Ectophial", 4251).isNotConsumed();
        this.ringOfDueling = new ItemRequirement("Ring of dueling", ItemCollections.RING_OF_DUELINGS);
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.nardahTeleport = new ItemRequirement("Nardah teleport", 12402);
        this.nardahTeleport.addAlternates(ItemCollections.PHAROAH_SCEPTRE);
        this.taverleyTeleport = new ItemRequirement("Taverley teleport", 11742);
        this.taverleyTeleport.addAlternates(8009);
        this.rellekkaTeleport = new ItemRequirement("Rellekka teleport", ItemCollections.ENCHANTED_LYRE);
        this.rellekkaTeleport.addAlternates(11744);
        this.gnomeTeleport = new ItemRequirement("Teleport to Gnome Stronghold (Spirit tree/Gnome Glider", -1, 1);
        this.feldipTeleport = new ItemRequirement("Teleport to Feldip Hills (Gnome Glider or Fairy Ring (AKS))", 12404);
        this.dramenStaff = new ItemRequirement("Dramen staff", 772).isNotConsumed();
        this.dramenStaff.addAlternates(9084);
        this.rellekkaNETeleport = new ItemRequirement("Fairy Ring (DKS)", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.jugOfVinegar = new ItemRequirement("Jar of vinegar", 7810);
        this.potOfVinegar = new ItemRequirement("Pot of vinegar", 7811);
        this.potOfVinegarNeeded = new ItemRequirement("Pot of vinegar", 7811, 8).alsoCheckBank(this.questBank).highlighted();
        this.jugOfVinegarNeeded = new ItemRequirement("Jug of vinegar", 7810, 8).alsoCheckBank(this.questBank).highlighted();
        this.coinsOrVinegar = new ItemRequirement("Pots/Jugs of vinegar, or coins to buy", 7811);
        this.coinsOrVinegar.addAlternates(7810, 995);
        ArrayList<Integer> bonesInVinegar = new ArrayList<Integer>();
        for (int i = 7813; i <= 7915; i += 3) {
            bonesInVinegar.add(i);
        }
        this.boneInVinegar = new ItemRequirement("Bone in vinegar", 7813);
        this.boneInVinegar.addAlternates(bonesInVinegar);
        this.jailKey = new ItemRequirement("Jail key", 1591);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        AtomicInteger winesNeededQuantity = new AtomicInteger(27);
        this.stepsForRagAndBoneManII.forEach((state, step) -> {
            if (state.hadBoneInVinegarItem(this.questBank).check(this.client)) {
                winesNeededQuantity.getAndDecrement();
            }
        });
        this.potOfVinegarNeeded.setQuantity(winesNeededQuantity.get());
        int jugsNeeded = winesNeededQuantity.get();
        this.potNeeded.setQuantity(jugsNeeded -= this.potOfVinegar.alsoCheckBank(this.questBank).getMatches(this.client));
        this.jugOfVinegarNeeded.setQuantity(jugsNeeded);
    }

    private void setupZones() {
        this.swamp = new Zone(new WorldPoint(3138, 9536, 0), new WorldPoint(3261, 9601, 0));
        this.junaRoom = new Zone(new WorldPoint(3205, 9484, 0), new WorldPoint(3263, 9537, 2));
        this.experimentCave = new Zone(new WorldPoint(3466, 9921, 0), new WorldPoint(3582, 9982, 0));
        this.varrockSewer = new Zone(new WorldPoint(3086, 9821, 0), new WorldPoint(3290, 9919, 0));
        this.asgarniaDungeon = new Zone(new WorldPoint(2979, 9538, 0), new WorldPoint(3069, 9602, 0));
        this.brimhavenDungeon = new Zone(new WorldPoint(2560, 9411, 0), new WorldPoint(2752, 9599, 2));
        this.taverleyDungeon = new Zone(new WorldPoint(2816, 9668, 0), new WorldPoint(2973, 9855, 0));
        this.deepTaverleyDungeon1 = new Zone(new WorldPoint(2816, 9856, 0), new WorldPoint(2880, 9760, 0));
        this.deepTaverleyDungeon2 = new Zone(new WorldPoint(2880, 9760, 0), new WorldPoint(2907, 9793, 0));
        this.deepTaverleyDungeon3 = new Zone(new WorldPoint(2889, 9793, 0), new WorldPoint(2923, 9815, 0));
        this.deepTaverleyDungeon4 = new Zone(new WorldPoint(2907, 9772, 0), new WorldPoint(2928, 9793, 0));
        this.jailCell = new Zone(new WorldPoint(2928, 9683, 0), new WorldPoint(2934, 9689, 0));
        this.trollCave = new Zone(new WorldPoint(2762, 10123, 0), new WorldPoint(2804, 10164, 0));
        this.fremennikSlayerDungeon = new Zone(new WorldPoint(2688, 9984, 0), new WorldPoint(2811, 10047, 0));
        this.waterbirth = new Zone(new WorldPoint(2496, 3712, 0), new WorldPoint(2559, 3774, 0));
        this.waterbirthDungeon = new Zone(new WorldPoint(2432, 10113, 0), new WorldPoint(2559, 10175, 0));
    }

    private void setupConditions() {
        this.inSwamp = new ZoneRequirement(this.swamp);
        this.inJunaRoom = new ZoneRequirement(this.junaRoom);
        this.inExperimentCave = new ZoneRequirement(this.experimentCave);
        this.inVarrockSewer = new ZoneRequirement(this.varrockSewer);
        this.inAsgarniaDungeon = new ZoneRequirement(this.asgarniaDungeon);
        this.inBrimhavenDungeon = new ZoneRequirement(this.brimhavenDungeon);
        this.inTaverleyDungeon = new ZoneRequirement(this.taverleyDungeon);
        this.inDeepTaverleyDungeon = new ZoneRequirement(this.deepTaverleyDungeon1, this.deepTaverleyDungeon2, this.deepTaverleyDungeon3, this.deepTaverleyDungeon4);
        this.inJailCell = new ZoneRequirement(this.jailCell);
        this.inTrollCave = new ZoneRequirement(this.trollCave);
        this.inFremennikSlayerDungeon = new ZoneRequirement(this.fremennikSlayerDungeon);
        this.onWaterbirth = new ZoneRequirement(this.waterbirth);
        this.inWaterbirthDungeon = new ZoneRequirement(this.waterbirthDungeon);
        this.addedRope = new VarbitRequirement(279, 1);
        this.boneNearby = new Conditions(LogicType.OR, RagBoneGroups.getBonesOnFloor(RagBoneGroups.getBones(RagBoneGroups.getRagBoneIIStates())));
        this.logAdded = new VarbitRequirement(2046, 1, Operation.GREATER_EQUAL);
        this.boneAddedToBoiler = new VarbitRequirement(2046, 2, Operation.GREATER_EQUAL);
        this.logLit = new VarbitRequirement(2046, 3, Operation.GREATER_EQUAL);
        this.boneReady = new VarbitRequirement(2046, 4);
        this.jailKeyOnFloor = new ItemOnTileRequirement(this.jailKey);
        this.mogreNearby = new NpcInteractingRequirement(2592);
        this.allBonesPolished = new Conditions(RagBoneGroups.allBonesPolished(RagBoneGroups.getRagBoneIIStates(), this.questBank));
        this.allBonesAtLeastAddedToVinegar = new Conditions(RagBoneGroups.allBonesAddedToVinegar(RagBoneGroups.getRagBoneIIStates(), this.questBank));
        this.hadAllBones = new Conditions(RagBoneGroups.allBonesObtained(RagBoneGroups.getRagBoneIIStates(), this.questBank));
        this.hadVinegar = new Conditions(this.jugOfVinegar.alsoCheckBank(this.questBank));
    }

    public void setupSteps() {
        this.finishP1 = new DetailedQuestStep((QuestHelper)this, "Finish Rag and Bone Man I.", new Requirement[0]);
        this.addRope = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to the Lumbridge Swamp caves.", this.rope.highlighted(), this.lightSource, this.tinderbox);
        this.addRope.addIcon(954);
        this.leaveJunaRoom = new ObjectStep((QuestHelper)this, 6658, new WorldPoint(3219, 9534, 2), "Enter the Lumbridge Swamp caves.", new Requirement[0]);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to the Lumbridge Swamp caves.", this.lightSource, this.tinderbox);
        this.enterSwamp.addSubSteps(this.addRope, this.leaveJunaRoom);
        this.killBat = new NpcStep((QuestHelper)this, 2827, new WorldPoint(3367, 3486, 0), "Kill bats south of the Odd Old Man.", new Requirement[0]);
        this.killUndeadCow = new NpcStep((QuestHelper)this, 2992, new WorldPoint(3617, 3526, 0), "Kill undead cows west of the Ectofuntus.", true, new Requirement[0]);
        this.killUndeadCow.addTeleport(this.ectophial);
        this.enterExperimentCave = new ObjectStep((QuestHelper)this, 5167, new WorldPoint(3578, 3528, 0), "Enter the Experiment Cave near Castle Fenkenstrain.", new Requirement[0]);
        this.killExperiment = new NpcStep((QuestHelper)this, 1274, new WorldPoint(3557, 9946, 0), "Kill Experiments.", true, new Requirement[0]);
        ((NpcStep)this.killExperiment).addAlternateNpcs(1275);
        this.killWerewolf = new NpcStep((QuestHelper)this, 2611, new WorldPoint(3491, 3487, 0), "Kill the citizens/werewolves in Canifis. (Do not use Wolfbane)", true, new Requirement[0]);
        ArrayList<Integer> werewolves = new ArrayList<Integer>();
        for (int i = 2594; i <= 2632; ++i) {
            werewolves.add(i);
        }
        ((NpcStep)this.killWerewolf).addAlternateNpcs(werewolves);
        this.killGhoul = new NpcStep((QuestHelper)this, 289, new WorldPoint(3434, 3461, 0), "Kill Ghouls west of Canifis.", true, new Requirement[0]);
        this.enterSewer = new ObjectStep((QuestHelper)this, 882, new WorldPoint(3237, 3458, 0), "Go down into Varrock Sewer via the Manhole south east of Varrock Castle.", new Requirement[0]);
        ((ObjectStep)this.enterSewer).addAlternateObjects(881);
        this.killZombie = new NpcStep((QuestHelper)this, 41, new WorldPoint(3244, 9892, 0), "Kill zombies in the sewer.", true, new Requirement[0]);
        ((NpcStep)this.killZombie).addAlternateNpcs(39);
        this.killRat = new NpcStep((QuestHelper)this, 2854, new WorldPoint(3244, 9892, 0), "Kill rats.", true, new Requirement[0]);
        this.killMossGiant = new NpcStep((QuestHelper)this, 2090, new WorldPoint(2654, 9565, 0), "Kill Moss Giants near the entrance.", true, new Requirement[0]);
        ((NpcStep)this.killMossGiant).addAlternateNpcs(2091, 2092, 2093);
        this.killCaveGoblin = new NpcStep((QuestHelper)this, 6434, new WorldPoint(3248, 9574, 0), "Kill Cave Goblins in the east of the Lumbridge Caves. Run between the marked tiles to avoid the Wall Beasts.", true, new Requirement[0]);
        ((NpcStep)this.killCaveGoblin).addAlternateNpcs(6435, 6436, 6437);
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3161, 9573, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3163, 9573, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3163, 9555, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3165, 9555, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3197, 9553, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3199, 9553, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3214, 9559, 0), 670));
        this.killCaveGoblin.addTileMarker(new QuestTile(new WorldPoint(3216, 9559, 0), 670));
        this.killJackal = new NpcStep((QuestHelper)this, 4185, new WorldPoint(3400, 2997, 0), "Kill Jackals north of Nardah.", true, new Requirement[0]);
        this.killSnake = new NpcStep((QuestHelper)this, 3544, new WorldPoint(3400, 3035, 0), "Kill desert snakes north of Nardah.", true, new Requirement[0]);
        this.killLizard = new NpcStep((QuestHelper)this, 458, new WorldPoint(3439, 3036, 0), "Kill the giant lizards north of Nardah.", true, this.iceCooler);
        this.killVulture = new NpcStep((QuestHelper)this, 1267, new WorldPoint(3348, 2875, 0), "Kill vultures south west of Nardah.", true, new Requirement[0]);
        ((NpcStep)this.killVulture).addAlternateNpcs(1268);
        this.killSeagull = new NpcStep((QuestHelper)this, 1338, new WorldPoint(3033, 3235, 0), "Kill seagulls on the Port Sarim docks.", true, new Requirement[0]);
        ((NpcStep)this.killSeagull).addAlternateNpcs(1339);
        this.enterAsgarniaDungeon = new ObjectStep((QuestHelper)this, 1738, new WorldPoint(3008, 3150, 0), "Enter the Asgarnia Dungeon by Mudskipper Point.", new Requirement[0]);
        this.killIceGiant = new NpcStep((QuestHelper)this, 2086, new WorldPoint(3059, 9576, 0), "Kill Ice Giants at the end of the dungeon.", true, new Requirement[0]);
        ((NpcStep)this.killIceGiant).addAlternateNpcs(2087, 2088, 2089);
        this.throwExplosive = new ObjectStep((QuestHelper)this, 10087, new WorldPoint(2982, 3113, 0), "Throw a fishing explosive to attract a Mogre on Mudskipper Point.", this.fishingExplosive.highlighted());
        this.throwExplosive.addIcon(6664);
        this.killMogre = new NpcStep((QuestHelper)this, 2592, new WorldPoint(2988, 3111, 0), "Kill the Mogre.", new Requirement[0]);
        this.killJogre = new NpcStep((QuestHelper)this, 2094, new WorldPoint(2921, 3051, 0), "Kill Jogres on Karamja.", true, new Requirement[0]);
        this.enterBrimhavenDungeon = new ObjectStep((QuestHelper)this, 20876, new WorldPoint(2745, 3155, 0), "Enter Brimhaven Dungeon.", this.axe, this.coins.quantity(875));
        this.enterBrimhavenDungeon.addDialogStep("Yes");
        this.killFireGiant = new NpcStep((QuestHelper)this, 2075, new WorldPoint(2662, 9494, 0), "Kill fire giants deep in the dungeon.", true, new Requirement[0]);
        ((NpcStep)this.killFireGiant).addAlternateNpcs(2076, 2077, 2078, 2079, 2080, 2081, 2082, 2083, 2084);
        this.enterTaverleyDungeon = this.client.getRealSkillLevel(Skill.AGILITY) >= 70 ? new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. Bring an antifire shield if you can.", new Requirement[0]) : new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. Bring a dusty key if you have one, otherwise you can get one in the dungeon. Bring an antifire shield if you can.", this.dustyKey);
        this.enterTaverleyDungeon.addTeleport(this.taverleyTeleport);
        this.goThroughPipe = new ObjectStep((QuestHelper)this, 16509, new WorldPoint(2888, 9799, 0), "Squeeze through the obstacle pipe.", new Requirement[0]);
        this.killJailerForKey = new NpcStep((QuestHelper)this, 300, new WorldPoint(2930, 9692, 0), "Travel through Taverley Dungeon until you reach the Black Knights' Base. Kill the Jailer in the east side of the base for a jail key.", new Requirement[0]);
        this.pickUpJailKey = new ItemStep((QuestHelper)this, "Pick up the jail key.", this.jailKey);
        this.getDustyFromAdventurer = new NpcStep((QuestHelper)this, 4925, new WorldPoint(2930, 9685, 0), "Use the jail key on the south door and talk to Velrak for a dusty key.", this.jailKey);
        this.getDustyFromAdventurer.addDialogStep("So... do you know anywhere good to explore?");
        this.getDustyFromAdventurer.addDialogStep("Yes please!");
        this.enterDeeperTaverley = new ObjectStep((QuestHelper)this, 2623, new WorldPoint(2924, 9803, 0), "Enter the gate to the deeper Taverley dungeon.", this.dustyKey);
        this.enterTaverleyDungeon.addSubSteps(this.goThroughPipe, this.killJailerForKey, this.getDustyFromAdventurer, this.enterDeeperTaverley);
        this.killBabyBlueDragon = new NpcStep((QuestHelper)this, 241, new WorldPoint(2906, 9802, 0), "Kill baby blue dragons. South east near the lava is a good spot without any adult dragons.", true, new Requirement[0]);
        ((NpcStep)this.killBabyBlueDragon).addAlternateNpcs(242, 243);
        this.enterKeldagrimCave = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Enter the cave north east of Rellekka.", new Requirement[0]);
        this.enterKeldagrimCave.addTeleport(this.rellekkaNETeleport);
        this.killTroll = new NpcStep((QuestHelper)this, 936, new WorldPoint(2830, 10107, 0), "Kill trolls.", true, new Requirement[0]);
        ((NpcStep)this.killTroll).addAlternateNpcs(937, 938, 939, 940, 941, 942);
        this.killRabbit = new NpcStep((QuestHelper)this, 3902, new WorldPoint(2738, 3637, 0), "Kill bunnies south east of Rellekka.", true, new Requirement[0]);
        ((NpcStep)this.killRabbit).addAlternateNpcs(3903);
        this.enterFremmyDungeon = new ObjectStep((QuestHelper)this, 2123, new WorldPoint(2798, 3615, 0), "Enter the Fremennik Slayer Dungeon.", this.mirrorShield.equipped());
        this.killBasilisk = new NpcStep((QuestHelper)this, 417, new WorldPoint(2743, 10010, 0), "Kill basilisks in the middle of the dungeon.", true, this.mirrorShield.equipped(), new SkillRequirement(Skill.SLAYER, 40, true));
        this.travelToWaterbirth = new NpcStep((QuestHelper)this, 5937, new WorldPoint(2620, 3685, 0), "Travel to Waterbirth Island.", new Requirement[0]);
        ((NpcStep)this.travelToWaterbirth).addAlternateNpcs(7205, 10407);
        this.enterWaterbirthDungeon = new ObjectStep((QuestHelper)this, 8929, new WorldPoint(2521, 3740, 0), "Enter waterbirth dungeon.", new Requirement[0]);
        this.killDagannoth = new NpcStep((QuestHelper)this, 3185, new WorldPoint(2452, 10146, 0), "Kill dagannoths.", true, new Requirement[0]);
        this.killTerrorbird = new NpcStep((QuestHelper)this, 2064, new WorldPoint(2379, 3433, 0), "Kill Terrorbirds in the Tree Gnome Stronghold.", true, new Requirement[0]);
        ((NpcStep)this.killTerrorbird).addAlternateNpcs(2065, 2066);
        this.killWolf = new NpcStep((QuestHelper)this, 106, new WorldPoint(2591, 2966, 0), "Kill wolves in Feldip Hills.", true, new Requirement[0]);
        this.killWolf.addTeleport(this.feldipTeleport);
        this.killOgre = new NpcStep((QuestHelper)this, 2095, new WorldPoint(2570, 2975, 0), "Kill ogres in Feldip Hills.", true, new Requirement[0]);
        this.killOgre.addTeleport(this.feldipTeleport);
        this.killZogre = new NpcStep((QuestHelper)this, 866, new WorldPoint(2460, 3048, 0), "Kill Zogres in Jiggig.", true, this.inoculationBracelet);
        ((NpcStep)this.killZogre).addAlternateNpcs(867, 868, 869, 870, 871, 873, 874, 875, 876);
        this.killZogre.addTeleport(this.feldipTeleport);
        this.pickupBone = new ItemStep((QuestHelper)this, "Pickup the bone.", new Requirement[0]);
        this.pickupBone.addItemRequirements(RagBoneGroups.pickupBones(RagBoneGroups.getRagBoneIIStates()));
        this.pickupBone.setShowInSidebar(false);
        this.makePotOfVinegar = new DetailedQuestStep((QuestHelper)this, "Buy 27 jugs of vinegar from Fortunato in Draynor Village, then use them on pots.", this.jugOfVinegarNeeded, this.potNeeded);
        this.useBonesOnVinegar = new DetailedQuestStep((QuestHelper)this, "Use the bones on the pots of vinegar.", this.potOfVinegar.highlighted());
        this.useBonesOnVinegar.addItemRequirements(RagBoneGroups.bonesToAddToVinegar(RagBoneGroups.getRagBoneIIStates(), this.questBank));
        this.placeLogs = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Place logs under the pot-boiler near the Odd Old Man. If you've already polished all the bones, hand them in to the Odd Old Man.", this.logs.highlighted());
        this.placeLogs.addIcon(1511);
        this.useBoneOnBoiler = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Add a bone to the pot boiler.", this.boneInVinegar.highlighted());
        this.useBoneOnBoiler.addIcon(7813);
        this.lightLogs = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Light the logs under the pot-boiler.", this.tinderbox.highlighted());
        this.lightLogs.addIcon(590);
        this.waitForCooking = new DetailedQuestStep((QuestHelper)this, "Wait for the bones to be cleaned. You can hop worlds to make this happen instantly.", new Requirement[0]);
        this.removePot = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Take the pot from the pot-boiler.", new Requirement[0]);
        this.giveBones = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3362, 3502, 0), "Give the Odd Old Man the bones.", new Requirement[0]);
        this.giveBones.addItemRequirements(RagBoneGroups.cleanBonesNotHandedIn(RagBoneGroups.getRagBoneIIStates()));
        this.talkToFinish = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3362, 3502, 0), "Talk to the Odd Old Man to finish.", new Requirement[0]);
        this.giveBones.addSubSteps(this.talkToFinish);
        this.repeatSteps = new DetailedQuestStep((QuestHelper)this, "Repeat the steps until all the bones are cleaned.", new Requirement[0]);
    }

    public void setupConditionalSteps() {
        this.pickupBoneSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.mapForMory.put(RagBoneState.BAT_WING, this.killBat);
        this.mapForMory.put(RagBoneState.UNDEAD_COW_RIBS, this.killUndeadCow);
        ConditionalStep goKillExperiment = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterExperimentCave, new Requirement[0]);
        goKillExperiment.addStep(this.inExperimentCave, this.killExperiment);
        this.mapForMory.put(RagBoneState.EXPERIMENT_BONE, goKillExperiment);
        this.mapForMory.put(RagBoneState.WEREWOLF_BONE, this.killWerewolf);
        this.mapForMory.put(RagBoneState.GHOUL_BONE, this.killGhoul);
        this.stepsForRagAndBoneManII.putAll(this.mapForMory);
        ConditionalStep goGetZombieBone = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterSewer, new Requirement[0]);
        goGetZombieBone.addStep(this.inVarrockSewer, this.killZombie);
        this.mapForVarrock.put(RagBoneState.ZOMBIE_BONE, goGetZombieBone);
        ConditionalStep goGetRatBone = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterSewer, new Requirement[0]);
        goGetRatBone.addStep(this.inVarrockSewer, this.killRat);
        this.mapForVarrock.put(RagBoneState.RAT_BONE, goGetRatBone);
        this.stepsForRagAndBoneManII.putAll(this.mapForVarrock);
        ConditionalStep goGetCaveGoblinBone = new ConditionalStep((QuestHelper)this, (QuestStep)this.addRope, new Requirement[0]);
        goGetCaveGoblinBone.addStep(this.inSwamp, this.killCaveGoblin);
        goGetCaveGoblinBone.addStep(this.inJunaRoom, this.leaveJunaRoom);
        goGetCaveGoblinBone.addStep(this.addedRope, this.enterSwamp);
        this.mapForLumbridge.put(RagBoneState.CAVE_GOBLIN_SKULL, goGetCaveGoblinBone);
        this.stepsForRagAndBoneManII.putAll(this.mapForLumbridge);
        this.mapForDesert.put(RagBoneState.JACKAL_BONE, this.killJackal);
        this.mapForDesert.put(RagBoneState.SNAKE_SPINE, this.killSnake);
        this.mapForDesert.put(RagBoneState.DESERT_LIZARD_BONE, this.killLizard);
        this.mapForDesert.put(RagBoneState.VULTURE_WING, this.killVulture);
        this.stepsForRagAndBoneManII.putAll(this.mapForDesert);
        this.mapForSarim.put(RagBoneState.SEAGULL_WING, this.killSeagull);
        ConditionalStep goKillIceGiant = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterAsgarniaDungeon, new Requirement[0]);
        goKillIceGiant.addStep(this.inAsgarniaDungeon, this.killIceGiant);
        this.mapForSarim.put(RagBoneState.ICE_GIANT_RIBS, goKillIceGiant);
        ConditionalStep goKillMogre = new ConditionalStep((QuestHelper)this, (QuestStep)this.throwExplosive, new Requirement[0]);
        goKillMogre.addStep(this.mogreNearby, this.killMogre);
        this.mapForSarim.put(RagBoneState.MOGRE_BONE, goKillMogre);
        this.stepsForRagAndBoneManII.putAll(this.mapForSarim);
        this.mapForKaramja.put(RagBoneState.JOGRE_BONE, this.killJogre);
        ConditionalStep goKillMossGiant = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBrimhavenDungeon, new Requirement[0]);
        goKillMossGiant.addStep(this.inBrimhavenDungeon, this.killMossGiant);
        this.mapForKaramja.put(RagBoneState.MOSS_GIANT_BONE, goKillMossGiant);
        ConditionalStep goKillFireGiant = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBrimhavenDungeon, new Requirement[0]);
        goKillFireGiant.addStep(this.inBrimhavenDungeon, this.killFireGiant);
        this.mapForKaramja.put(RagBoneState.FIRE_GIANT_BONE, goKillFireGiant);
        this.stepsForRagAndBoneManII.putAll(this.mapForKaramja);
        ConditionalStep goKillBabyBlue = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTaverleyDungeon, new Requirement[0]);
        goKillBabyBlue.addStep(new Conditions(this.inDeepTaverleyDungeon), this.killBabyBlueDragon);
        goKillBabyBlue.addStep(new Conditions(this.inTaverleyDungeon, new SkillRequirement(Skill.AGILITY, 70, true)), this.goThroughPipe);
        goKillBabyBlue.addStep(new Conditions(this.inTaverleyDungeon, this.dustyKey), this.enterDeeperTaverley);
        goKillBabyBlue.addStep(new Conditions(this.inTaverleyDungeon, new Conditions(LogicType.OR, this.inJailCell, this.jailKey)), this.getDustyFromAdventurer);
        goKillBabyBlue.addStep(new Conditions(this.inTaverleyDungeon, this.jailKeyOnFloor), this.pickUpJailKey);
        goKillBabyBlue.addStep(new Conditions(this.inTaverleyDungeon), this.killJailerForKey);
        this.mapForTaverley.put(RagBoneState.BABY_DRAGON_BONE, goKillBabyBlue);
        this.stepsForRagAndBoneManII.putAll(this.mapForTaverley);
        ConditionalStep goKillTroll = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterKeldagrimCave, new Requirement[0]);
        goKillTroll.addStep(this.inTrollCave, this.killTroll);
        this.mapForFremennik.put(RagBoneState.TROLL_BONE, goKillTroll);
        this.mapForFremennik.put(RagBoneState.RABBIT_BONE, this.killRabbit);
        ConditionalStep goKillBasilisk = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterFremmyDungeon, new Requirement[0]);
        goKillBasilisk.addStep(this.inFremennikSlayerDungeon, this.killBasilisk);
        this.mapForFremennik.put(RagBoneState.BASILISK_BONE, goKillBasilisk);
        ConditionalStep goKillDagannoth = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToWaterbirth, new Requirement[0]);
        goKillDagannoth.addStep(this.inWaterbirthDungeon, this.killDagannoth);
        goKillDagannoth.addStep(this.onWaterbirth, this.enterWaterbirthDungeon);
        this.mapForFremennik.put(RagBoneState.DAGANNOTH_RIBS, goKillDagannoth);
        this.stepsForRagAndBoneManII.putAll(this.mapForFremennik);
        this.mapForStronghold.put(RagBoneState.TERRORBIRD_WING, this.killTerrorbird);
        this.stepsForRagAndBoneManII.putAll(this.mapForStronghold);
        this.mapForFeldip.put(RagBoneState.WOLF_BONE, this.killWolf);
        this.mapForFeldip.put(RagBoneState.OGRE_BONE, this.killOgre);
        this.mapForFeldip.put(RagBoneState.ZOGRE_BONE, this.killZogre);
        this.stepsForRagAndBoneManII.putAll(this.mapForFeldip);
        this.morySteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Morytania", new Requirement[0]), new Requirement[0]);
        this.mapForMory.forEach((state, step) -> {
            this.moryReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.morySteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.moryReqs = new Conditions(this.moryReqsList);
        this.morySteps.setLockingCondition(this.moryReqs);
        this.varrockSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Varrock", new Requirement[0]), new Requirement[0]);
        this.mapForVarrock.forEach((state, step) -> {
            this.varrockReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.varrockSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.varrockReqs = new Conditions(this.varrockReqsList);
        this.varrockSteps.setLockingCondition(this.varrockReqs);
        this.lumbridgeSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Lumbridge", new Requirement[0]), new Requirement[0]);
        this.mapForLumbridge.forEach((state, step) -> {
            this.lumbridgeReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.lumbridgeSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.lumbridgeReqs = new Conditions(this.lumbridgeReqsList);
        this.lumbridgeSteps.setLockingCondition(this.lumbridgeReqs);
        this.desertSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Desert", new Requirement[0]), new Requirement[0]);
        this.mapForDesert.forEach((state, step) -> {
            this.desertReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.desertSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.desertReqs = new Conditions(this.desertReqsList);
        this.desertSteps.setLockingCondition(this.desertReqs);
        this.sarimSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Port Sarim", new Requirement[0]), new Requirement[0]);
        this.mapForSarim.forEach((state, step) -> {
            this.sarimReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.sarimSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.sarimReqs = new Conditions(this.sarimReqsList);
        this.sarimSteps.setLockingCondition(this.sarimReqs);
        this.karamjaSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Karamja", new Requirement[0]), new Requirement[0]);
        this.mapForKaramja.forEach((state, step) -> {
            this.karamjaReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.karamjaSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.karamjaReqs = new Conditions(this.karamjaReqsList);
        this.karamjaSteps.setLockingCondition(this.karamjaReqs);
        this.taverleySteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Taverley", new Requirement[0]), new Requirement[0]);
        this.mapForTaverley.forEach((state, step) -> {
            this.taverleyReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.taverleySteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.taverleyReqs = new Conditions(this.taverleyReqsList);
        this.taverleySteps.setLockingCondition(this.taverleyReqs);
        this.fremennikSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Fremennik", new Requirement[0]), new Requirement[0]);
        this.mapForFremennik.forEach((state, step) -> {
            this.fremennikReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.fremennikSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.fremennikReqs = new Conditions(this.fremennikReqsList);
        this.fremennikSteps.setLockingCondition(this.fremennikReqs);
        this.strongholdSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Gnome", new Requirement[0]), new Requirement[0]);
        this.mapForStronghold.forEach((state, step) -> {
            this.strongholdReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            if (step instanceof ConditionalStep) {
                ((ConditionalStep)step).getSteps().forEach(substep -> substep.addSubSteps(pickupBoneStep));
            }
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.strongholdSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.strongholdReqs = new Conditions(this.strongholdReqsList);
        this.strongholdSteps.setLockingCondition(this.strongholdReqs);
        this.feldipSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state Feldip", new Requirement[0]), new Requirement[0]);
        this.mapForFeldip.forEach((state, step) -> {
            this.feldipReqsList.add(state.hadBoneItem(this.questBank));
            ItemStep pickupBoneStep = new ItemStep((QuestHelper)this, "Pickup the bone.", state.getBoneItem());
            step.addSubSteps(pickupBoneStep);
            this.pickupBoneSteps.addStep(new ItemOnTileRequirement(state.getBoneItem()), pickupBoneStep);
            this.feldipSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step);
        });
        this.feldipReqs = new Conditions(this.feldipReqsList);
        this.feldipSteps.setLockingCondition(this.feldipReqs);
        this.feldipSteps.setBlocker(true);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("27 low to mid leveled monsters for their bones");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        requirements.add(new SkillRequirement(Skill.SLAYER, 40, true));
        requirements.add(new SkillRequirement(Skill.DEFENCE, 20));
        requirements.add(new QuestRequirement(QuestHelperQuest.RAG_AND_BONE_MAN_I, QuestState.FINISHED));
        requirements.add(new QuestRequirement(QuestHelperQuest.SKIPPY_AND_THE_MOGRES, QuestState.FINISHED));
        Conditions canAccessExperimentCave = new Conditions(LogicType.OR, new VarbitRequirement(192, 1), new VarplayerRequirement(QuestVarPlayer.QUEST_CREATURE_OF_FENKENSTRAIN.getId(), 2, Operation.GREATER_EQUAL));
        canAccessExperimentCave.setText("Partial completion of Creature of Fenkenstrain");
        requirements.add(canAccessExperimentCave);
        requirements.add(new VarbitRequirement(QuestVarbits.QUEST_ZOGRE_FLESH_EATERS.getId(), Operation.GREATER_EQUAL, 3, "Partial completion of Zogre Flesh Eaters"));
        return requirements;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(902), this.pots.quantity(27), this.logs.quantity(27), this.tinderbox, this.lightSource, this.rope.hideConditioned(this.addedRope), this.dustyKey.hideConditioned(new SkillRequirement(Skill.AGILITY, 70, true)), this.iceCooler, this.fishingExplosive, this.mirrorShield, this.axe);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.antifireShield, this.inoculationBracelet, this.digsitePendant, this.ectophial, this.ringOfDueling, this.gamesNecklace, this.varrockTeleport, this.lumbridgeTeleport, this.nardahTeleport, this.draynorTeleport, this.karamjaTeleport, this.taverleyTeleport, this.rellekkaTeleport, this.gnomeTeleport, this.feldipTeleport, this.dramenStaff);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("If you've handed in any bones to the Odd Old Man, open the quest journal to sync up the helper's state");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.PRAYER, 5000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A Bonesack", 7918, 1), new ItemReward("A Ram Skull Helm", 7917, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails collectingMorytaniaPanel = new PanelDetails("Morytania bones", Arrays.asList(this.killBat, this.killUndeadCow, this.enterExperimentCave, this.killExperiment, this.killWerewolf, this.killGhoul), null, Collections.singletonList(this.ectophial));
        collectingMorytaniaPanel.setLockingStep(this.morySteps);
        allSteps.add(collectingMorytaniaPanel);
        PanelDetails collectingVarrockPanel = new PanelDetails("Varrock Sewer bones", Arrays.asList(this.enterSewer, this.killZombie, this.killRat), new Requirement[0]);
        collectingVarrockPanel.setLockingStep(this.varrockSteps);
        allSteps.add(collectingVarrockPanel);
        PanelDetails collectingLumbridgePanel = new PanelDetails("Lumbridge Swamp bone", Arrays.asList(this.enterSwamp, this.killCaveGoblin), this.rope.hideConditioned(this.addedRope), this.lightSource, this.tinderbox);
        collectingLumbridgePanel.setLockingStep(this.lumbridgeSteps);
        allSteps.add(collectingLumbridgePanel);
        PanelDetails collectingDesertPanel = new PanelDetails("Desert bones", Arrays.asList(this.killJackal, this.killSnake, this.killLizard, this.killVulture), this.iceCooler);
        collectingDesertPanel.setLockingStep(this.desertSteps);
        allSteps.add(collectingDesertPanel);
        PanelDetails collectingSarimPanel = new PanelDetails("Port Sarim bones", Arrays.asList(this.killSeagull, this.enterAsgarniaDungeon, this.killIceGiant, this.throwExplosive, this.killMogre), this.fishingExplosive);
        collectingSarimPanel.setLockingStep(this.sarimSteps);
        allSteps.add(collectingSarimPanel);
        PanelDetails collectingKaramjaPanel = new PanelDetails("Karamja bones", Arrays.asList(this.killJogre, this.enterBrimhavenDungeon, this.killMossGiant, this.killFireGiant), this.coins.quantity(875).hideConditioned(new VarbitRequirement(8122, 1)), this.axe);
        collectingKaramjaPanel.setLockingStep(this.karamjaSteps);
        allSteps.add(collectingKaramjaPanel);
        PanelDetails collectingTaverleyPanel = new PanelDetails("Taverley Dungeon bone", Arrays.asList(this.enterTaverleyDungeon, this.killBabyBlueDragon), Collections.singletonList(this.dustyKey.hideConditioned(new SkillRequirement(Skill.AGILITY, 70, true))), Arrays.asList(this.taverleyTeleport, this.antifireShield));
        collectingTaverleyPanel.setLockingStep(this.taverleySteps);
        allSteps.add(collectingTaverleyPanel);
        PanelDetails collectingFremennikPanel = new PanelDetails("Fremennik bones", Arrays.asList(this.enterKeldagrimCave, this.killTroll, this.killRabbit, this.enterFremmyDungeon, this.killBasilisk, this.travelToWaterbirth, this.enterWaterbirthDungeon, this.killDagannoth), Collections.singletonList(this.mirrorShield), Arrays.asList(this.rellekkaTeleport, this.rellekkaNETeleport));
        collectingFremennikPanel.setLockingStep(this.fremennikSteps);
        allSteps.add(collectingFremennikPanel);
        PanelDetails collectingStrongholdPanel = new PanelDetails("Gnome Stronghold bones", Collections.singletonList(this.killTerrorbird), new Requirement[0]);
        collectingStrongholdPanel.setLockingStep(this.strongholdSteps);
        allSteps.add(collectingStrongholdPanel);
        PanelDetails collectingFeldipPanel = new PanelDetails("Feldip Hills bones", Arrays.asList(this.killWolf, this.killOgre, this.killZogre), null, Collections.singletonList(this.feldipTeleport));
        collectingFeldipPanel.setLockingStep(this.feldipSteps);
        allSteps.add(collectingFeldipPanel);
        ArrayList<Requirement> dirtyBones = new ArrayList<Requirement>(Arrays.asList(this.coinsOrVinegar.quantity(27), this.pots.quantity(27)));
        dirtyBones.addAll(RagBoneGroups.dirtyBonesNotHandedIn(RagBoneGroups.getRagBoneIIStates()));
        PanelDetails preparingPanel = new PanelDetails("Preparing the bones", Arrays.asList(this.makePotOfVinegar, this.useBonesOnVinegar), dirtyBones);
        preparingPanel.setLockingStep(this.preparingBonesSteps);
        allSteps.add(preparingPanel);
        ArrayList<Requirement> cleaningBones = new ArrayList<Requirement>(Arrays.asList(this.logs.quantity(27), this.tinderbox));
        PanelDetails cookingPanel = new PanelDetails("Cleaning the bones", Arrays.asList(this.placeLogs, this.useBoneOnBoiler, this.lightLogs, this.waitForCooking, this.removePot, this.repeatSteps), cleaningBones);
        cookingPanel.setLockingStep(this.cookingSteps);
        allSteps.add(cookingPanel);
        allSteps.add(new PanelDetails("Handing the bones in", Collections.singletonList(this.giveBones), new Requirement[0]));
        return allSteps;
    }
}

