/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ragandboneman;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.ragandboneman.RagBoneGroups;
import com.questhelper.helpers.quests.ragandboneman.RagBoneState;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.QuestTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.RAG_AND_BONE_MAN_I)
public class RagAndBoneManI
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement pots;
    ItemRequirement logs;
    ItemRequirement tinderbox;
    ItemRequirement lightSource;
    ItemRequirement rope;
    ItemRequirement spinyHelmet;
    ItemRequirement varrockTeleport;
    ItemRequirement lumbridgeTeleport;
    ItemRequirement digsitePendant;
    ItemRequirement draynorTeleport;
    ItemRequirement karamjaTeleport;
    ItemRequirement dramenStaff;
    ItemRequirement jugOfVinegar;
    ItemRequirement jugOfVinegarNeeded;
    ItemRequirement potOfVinegar;
    ItemRequirement potOfVinegarNeeded;
    ItemRequirement potNeeded;
    DetailedQuestStep talkToOddOldMan;
    DetailedQuestStep killGiantRat;
    DetailedQuestStep killUnicorn;
    DetailedQuestStep killBear;
    DetailedQuestStep killRam;
    DetailedQuestStep killGoblin;
    DetailedQuestStep killFrog;
    DetailedQuestStep killMonkey;
    DetailedQuestStep killBat;
    DetailedQuestStep pickupBone;
    DetailedQuestStep addRope;
    DetailedQuestStep enterSwamp;
    DetailedQuestStep leaveJunaRoom;
    DetailedQuestStep enterKaramjaDungeon;
    DetailedQuestStep talkToFortunato;
    DetailedQuestStep makePotOfVinegar;
    DetailedQuestStep useBonesOnVinegar;
    DetailedQuestStep placeLogs;
    DetailedQuestStep useBoneOnBoiler;
    DetailedQuestStep lightLogs;
    DetailedQuestStep waitForCooking;
    DetailedQuestStep removePot;
    DetailedQuestStep repeatSteps;
    DetailedQuestStep giveBones;
    DetailedQuestStep talkToFinish;
    Requirement inSwamp;
    Requirement inJunaRoom;
    Requirement inKaramjaDungeon;
    Requirement addedRope;
    Requirement boneNearby;
    Requirement hadAllBones;
    Requirement talkedToFortunato;
    Requirement hadVinegar;
    Requirement allBonesAtLeastAddedToVinegar;
    Requirement allBonesPolished;
    Requirement logAdded;
    Requirement boneAddedToBoiler;
    Requirement logLit;
    Requirement boneReady;
    Zone swamp;
    Zone junaRoom;
    Zone karamjaDungeon;
    ConditionalStep collectBonesSteps;
    ConditionalStep preparingBonesSteps;
    ConditionalStep cookingSteps;
    LinkedHashMap<RagBoneState, QuestStep> stepsForRagAndBoneManI = new LinkedHashMap();

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToOddOldMan);
        steps.put(1, this.talkToOddOldMan);
        this.collectBonesSteps = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "Unknown state.", new Requirement[0]), new Requirement[0]);
        this.collectBonesSteps.addStep(this.boneNearby, this.pickupBone);
        this.stepsForRagAndBoneManI.forEach((state, step) -> this.collectBonesSteps.addStep(LogicHelper.nor(state.hadBoneItem(this.questBank)), (QuestStep)step));
        this.collectBonesSteps.setLockingCondition(this.hadAllBones);
        this.preparingBonesSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToFortunato, new Requirement[0]);
        this.preparingBonesSteps.addStep(this.potOfVinegarNeeded, this.useBonesOnVinegar);
        this.preparingBonesSteps.addStep(this.talkedToFortunato, this.makePotOfVinegar);
        this.preparingBonesSteps.setLockingCondition(this.allBonesAtLeastAddedToVinegar);
        this.cookingSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.placeLogs, new Requirement[0]);
        this.cookingSteps.addStep(this.boneReady, this.removePot);
        this.cookingSteps.addStep(this.logLit, this.waitForCooking);
        this.cookingSteps.addStep(this.boneAddedToBoiler, this.lightLogs);
        this.cookingSteps.addStep(this.logAdded, this.useBoneOnBoiler);
        this.cookingSteps.setLockingCondition(this.allBonesPolished);
        ConditionalStep doQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.collectBonesSteps, new Requirement[0]);
        doQuest.addStep(this.allBonesPolished, this.giveBones);
        doQuest.addStep(this.allBonesAtLeastAddedToVinegar, this.cookingSteps);
        doQuest.addStep(this.hadAllBones, this.preparingBonesSteps);
        steps.put(2, doQuest);
        steps.put(3, this.talkToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS);
        this.pots = new ItemRequirement("Pot", 1931).isNotConsumed();
        this.potNeeded = new ItemRequirement("Pot", 1931, 8).alsoCheckBank(this.questBank).highlighted();
        this.logs = new ItemRequirement("Logs", 1511);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954);
        this.spinyHelmet = new ItemRequirement("Spiny helmet", 4551);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge teleport", 8008);
        this.digsitePendant = new ItemRequirement("Digsite pendant", ItemCollections.DIGSITE_PENDANTS);
        this.draynorTeleport = new ItemRequirement("Draynor teleport", ItemCollections.AMULET_OF_GLORIES);
        this.draynorTeleport.addAlternates(19615);
        this.karamjaTeleport = new ItemRequirement("Karamja teleport", ItemCollections.AMULET_OF_GLORIES);
        this.karamjaTeleport.addAlternates(11745, 12409);
        this.dramenStaff = new ItemRequirement("Dramen staff for fairy rings", 772).isNotConsumed();
        this.jugOfVinegar = new ItemRequirement("Jar of vinegar", 7810);
        this.potOfVinegar = new ItemRequirement("Pot of vinegar", 7811);
        this.potOfVinegarNeeded = new ItemRequirement("Pot of vinegar", 7811, 8).alsoCheckBank(this.questBank).highlighted();
        this.jugOfVinegarNeeded = new ItemRequirement("Jug of vinegar", 7810, 8).alsoCheckBank(this.questBank).highlighted();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        AtomicInteger winesNeededQuantity = new AtomicInteger(8);
        this.stepsForRagAndBoneManI.forEach((state, step) -> {
            if (state.hadBoneInVinegarItem(this.questBank).check(this.client)) {
                winesNeededQuantity.getAndDecrement();
            }
        });
        this.potOfVinegarNeeded.setQuantity(winesNeededQuantity.get());
        int jugsNeeded = winesNeededQuantity.get();
        this.potNeeded.setQuantity(jugsNeeded -= this.potOfVinegar.alsoCheckBank(this.questBank).getMatches(this.client));
        this.jugOfVinegarNeeded.setQuantity(jugsNeeded);
    }

    private void setupZones() {
        this.swamp = new Zone(new WorldPoint(3138, 9536, 0), new WorldPoint(3261, 9601, 0));
        this.junaRoom = new Zone(new WorldPoint(3205, 9484, 0), new WorldPoint(3263, 9537, 2));
        this.karamjaDungeon = new Zone(new WorldPoint(2827, 9547, 0), new WorldPoint(2867, 9599, 0));
    }

    private void setupConditions() {
        this.inSwamp = new ZoneRequirement(this.swamp);
        this.inJunaRoom = new ZoneRequirement(this.junaRoom);
        this.inKaramjaDungeon = new ZoneRequirement(this.karamjaDungeon);
        this.addedRope = new VarbitRequirement(279, 1);
        this.boneNearby = new Conditions(LogicType.OR, RagBoneGroups.getBonesOnFloor(RagBoneGroups.getBones(RagBoneGroups.getRagBoneIStates())));
        this.logAdded = new VarbitRequirement(2046, 1, Operation.GREATER_EQUAL);
        this.boneAddedToBoiler = new VarbitRequirement(2046, 2, Operation.GREATER_EQUAL);
        this.logLit = new VarbitRequirement(2046, 3, Operation.GREATER_EQUAL);
        this.boneReady = new VarbitRequirement(2046, 4);
        this.allBonesPolished = new Conditions(RagBoneGroups.allBonesPolished(RagBoneGroups.getRagBoneIStates(), this.questBank));
        this.allBonesAtLeastAddedToVinegar = new Conditions(RagBoneGroups.allBonesAddedToVinegar(RagBoneGroups.getRagBoneIStates(), this.questBank));
        this.hadAllBones = new Conditions(RagBoneGroups.allBonesObtained(RagBoneGroups.getRagBoneIStates(), this.questBank));
        this.talkedToFortunato = new VarbitRequirement(2047, 1);
        this.hadVinegar = new Conditions(this.jugOfVinegar.alsoCheckBank(this.questBank));
    }

    public void setupSteps() {
        this.talkToOddOldMan = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3362, 3502, 0), "Talk to the Odd Old Man east of Varrock.", new Requirement[0]);
        this.talkToOddOldMan.addDialogSteps("Anything I can do to help?", "Yes");
        this.killGiantRat = new NpcStep((QuestHelper)this, 2856, new WorldPoint(3289, 3373, 0), "Kill a giant rat south east of Varrock.", true, new Requirement[0]);
        ((NpcStep)this.killGiantRat).addAlternateNpcs(2857, 2858, 2859, 2860, 2861, 2862, 2863, 2864);
        this.killUnicorn = new NpcStep((QuestHelper)this, 2837, new WorldPoint(3285, 3351, 0), "Kill the unicorn south east of Varrock.", true, new Requirement[0]);
        this.killBear = new NpcStep((QuestHelper)this, 2839, new WorldPoint(3295, 3354, 0), "Kill the bear south east of Varrock.", true, new Requirement[0]);
        this.killRam = new NpcStep((QuestHelper)this, 1261, new WorldPoint(3253, 3350, 0), "Kill a ram south of Varrock.", true, new Requirement[0]);
        ((NpcStep)this.killRam).addAlternateNpcs(1262, 1263, 1264, 1265);
        this.killGoblin = new NpcStep((QuestHelper)this, 3028, new WorldPoint(3252, 3251, 0), "Kill a goblin east of Lumbridge.", true, new Requirement[0]);
        ((NpcStep)this.killGoblin).addAlternateNpcs(3029, 3030, 3031, 3032, 3033, 3034, 3035, 3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043, 3044, 3045, 3046, 3047, 3048);
        this.addRope = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to the Lumbridge Swamp caves.", this.rope.highlighted(), this.lightSource, this.tinderbox);
        this.addRope.addIcon(954);
        this.leaveJunaRoom = new ObjectStep((QuestHelper)this, 6658, new WorldPoint(3219, 9534, 2), "Enter the Lumbridge Swamp caves.", new Requirement[0]);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to the Lumbridge Swamp caves.", this.lightSource, this.tinderbox);
        this.enterSwamp.addSubSteps(this.addRope, this.leaveJunaRoom);
        this.killFrog = new NpcStep((QuestHelper)this, 478, new WorldPoint(3153, 9558, 0), "Kill a big frog in the south west of the caves. Make sure to RUN between the two marked run tiles to avoid the Wall Beast.", true, new Requirement[0]);
        this.killFrog.addTileMarker(new QuestTile(new WorldPoint(3161, 9574, 0), 670));
        this.killFrog.addTileMarker(new QuestTile(new WorldPoint(3163, 9574, 0), 670));
        ConditionalStep killFrogSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.addRope, new Requirement[0]);
        killFrogSteps.addStep(this.inSwamp, this.killFrog);
        killFrogSteps.addStep(this.inJunaRoom, this.leaveJunaRoom);
        killFrogSteps.addStep(this.addedRope, this.enterSwamp);
        this.killMonkey = new NpcStep((QuestHelper)this, 2848, new WorldPoint(2886, 3167, 0), "Kill a monkey on Karamja.", true, new Requirement[0]);
        this.enterKaramjaDungeon = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Kill a giant bat in the Karamja Volcano Dungeon.", new Requirement[0]);
        this.killBat = new NpcStep((QuestHelper)this, 2834, new WorldPoint(2858, 9572, 0), "Kill a giant bat in the Karamja Volcano Dungeon.", true, new Requirement[0]);
        this.killBat.addSubSteps(this.enterKaramjaDungeon);
        ConditionalStep killBatSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterKaramjaDungeon, new Requirement[0]);
        killBatSteps.addStep(this.inKaramjaDungeon, this.killBat);
        this.stepsForRagAndBoneManI.put(RagBoneState.GIANT_RAT_BONE, this.killGiantRat);
        this.stepsForRagAndBoneManI.put(RagBoneState.UNICORN_BONE, this.killUnicorn);
        this.stepsForRagAndBoneManI.put(RagBoneState.BEAR_RIBS, this.killBear);
        this.stepsForRagAndBoneManI.put(RagBoneState.RAM_SKULL, this.killRam);
        this.stepsForRagAndBoneManI.put(RagBoneState.GOBLIN_SKULL, this.killGoblin);
        this.stepsForRagAndBoneManI.put(RagBoneState.BIG_FROG_LEGS, killFrogSteps);
        this.stepsForRagAndBoneManI.put(RagBoneState.MONKEY_PAW, this.killMonkey);
        this.stepsForRagAndBoneManI.put(RagBoneState.GIANT_BAT_WING, killBatSteps);
        this.pickupBone = new ItemStep((QuestHelper)this, "Pickup the bone.", new Requirement[0]);
        this.pickupBone.addItemRequirements(RagBoneGroups.pickupBones(RagBoneGroups.getRagBoneIStates()));
        this.pickupBone.setShowInSidebar(false);
        this.talkToFortunato = new NpcStep((QuestHelper)this, 1260, new WorldPoint(3085, 3251, 0), "Talk to Fortunato in Draynor Village, and then buy 8 jugs of vinegar from him.", this.coins.quantity(8));
        this.makePotOfVinegar = new DetailedQuestStep((QuestHelper)this, "Use the vinegar on pots for 8 pots of vinegar.", this.jugOfVinegarNeeded, this.potNeeded);
        this.useBonesOnVinegar = new DetailedQuestStep((QuestHelper)this, "Use the bones on the pots of vinegar.", this.potOfVinegar.highlighted());
        this.useBonesOnVinegar.addItemRequirements(RagBoneGroups.bonesToAddToVinegar(RagBoneGroups.getRagBoneIStates(), this.questBank));
        this.placeLogs = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Place logs under the pot-boiler near the Odd Old Man. If you've already polished all the bones, hand them in to the Odd Old Man.", this.logs.highlighted());
        this.placeLogs.addIcon(1511);
        this.useBoneOnBoiler = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Add a bone to the pot boiler.", new Requirement[0]);
        this.useBoneOnBoiler.addIcon(7813);
        this.useBoneOnBoiler.addItemRequirements(RagBoneGroups.bonesToAddToBoiler(RagBoneGroups.getRagBoneIStates(), this.questBank));
        this.lightLogs = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Light the logs under the pot-boiler.", this.tinderbox.highlighted());
        this.lightLogs.addIcon(590);
        this.waitForCooking = new DetailedQuestStep((QuestHelper)this, "Wait for the bones to be cleaned. You can hop worlds to make this happen instantly.", new Requirement[0]);
        this.removePot = new ObjectStep((QuestHelper)this, 14004, new WorldPoint(3360, 3505, 0), "Take the pot from the pot-boiler.", new Requirement[0]);
        this.giveBones = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3362, 3502, 0), "Give the Odd Old Man the bones.", new Requirement[0]);
        this.giveBones.addItemRequirements(RagBoneGroups.cleanBonesNotHandedIn(RagBoneGroups.getRagBoneIStates()));
        this.talkToFinish = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3362, 3502, 0), "Talk to the Odd Old Man to finish.", new Requirement[0]);
        this.giveBones.addSubSteps(this.talkToFinish);
        this.repeatSteps = new DetailedQuestStep((QuestHelper)this, "Repeat the steps until all the bones are cleaned.", new Requirement[0]);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("8 low leveled monsters for their bones");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(8), this.pots.quantity(8), this.logs.quantity(8), this.tinderbox, this.lightSource, this.rope.hideConditioned(this.addedRope));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTeleport, this.lumbridgeTeleport, this.digsitePendant, this.draynorTeleport, this.karamjaTeleport);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("If you've handed in any bones to the Odd Old Man, open the quest journal to sync up the helper's state");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 500), new ExperienceReward(Skill.PRAYER, 500));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting out", Collections.singletonList(this.talkToOddOldMan), new Requirement[0]));
        PanelDetails collectingPanel = new PanelDetails("Collecting bones", Arrays.asList(this.killGiantRat, this.killUnicorn, this.killBear, this.killRam, this.killGoblin, this.enterSwamp, this.killFrog, this.killMonkey, this.killBat, this.pickupBone), this.tinderbox, this.lightSource, this.rope.hideConditioned(this.addedRope));
        collectingPanel.setLockingStep(this.collectBonesSteps);
        allSteps.add(collectingPanel);
        ArrayList<Requirement> dirtyBones = new ArrayList<Requirement>(Arrays.asList(this.coins.quantity(8), this.pots.quantity(8)));
        dirtyBones.addAll(RagBoneGroups.dirtyBonesNotHandedIn(RagBoneGroups.getRagBoneIStates()));
        PanelDetails preparingPanel = new PanelDetails("Preparing the bones", Arrays.asList(this.talkToFortunato, this.makePotOfVinegar, this.useBonesOnVinegar), dirtyBones);
        preparingPanel.setLockingStep(this.preparingBonesSteps);
        allSteps.add(preparingPanel);
        ArrayList<Requirement> cleaningBones = new ArrayList<Requirement>(Arrays.asList(this.logs.quantity(8), this.tinderbox));
        cleaningBones.addAll(RagBoneGroups.vinegarBonesNotHandedIn(RagBoneGroups.getRagBoneIStates()));
        PanelDetails cookingPanel = new PanelDetails("Cleaning the bones", Arrays.asList(this.placeLogs, this.useBoneOnBoiler, this.lightLogs, this.waitForCooking, this.removePot, this.repeatSteps), cleaningBones);
        cookingPanel.setLockingStep(this.cookingSteps);
        allSteps.add(cookingPanel);
        ArrayList<Requirement> cleanedBones = new ArrayList<Requirement>(RagBoneGroups.cleanBonesNotHandedIn(RagBoneGroups.getRagBoneIStates()));
        allSteps.add(new PanelDetails("Handing the bones in", Collections.singletonList(this.giveBones), cleanedBones));
        return allSteps;
    }
}

