/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.princealirescue;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.PRINCE_ALI_RESCUE)
public class PrinceAliRescue
extends BasicQuestHelper {
    ItemRequirement softClay;
    ItemRequirement ballsOfWool3;
    ItemRequirement yellowDye;
    ItemRequirement redberries;
    ItemRequirement ashes;
    ItemRequirement bucketOfWater;
    ItemRequirement potOfFlour;
    ItemRequirement bronzeBar;
    ItemRequirement pinkSkirt;
    ItemRequirement beers3;
    ItemRequirement rope;
    ItemRequirement coins100;
    ItemRequirement wig;
    ItemRequirement dyedWig;
    ItemRequirement paste;
    ItemRequirement keyMould;
    ItemRequirement key;
    ItemRequirement ropeReqs;
    ItemRequirement yellowDyeReqs;
    ItemRequirement ropeHighlighted;
    ItemRequirement keyHighlighted;
    ItemRequirement glory;
    Requirement hasOrGivenKeyMould;
    Requirement inCell;
    Requirement givenKeyMould;
    Requirement hasWigPasteAndKey;
    RuneliteRequirement madeMould;
    QuestStep talkToHassan;
    QuestStep talkToOsman;
    QuestStep talkToNed;
    QuestStep talkToAggie;
    QuestStep dyeWig;
    QuestStep talkToKeli;
    QuestStep bringImprintToOsman;
    QuestStep talkToLeela;
    QuestStep talkToJoe;
    QuestStep useRopeOnKeli;
    QuestStep useKeyOnDoor;
    QuestStep talkToAli;
    QuestStep returnToHassan;
    ConditionalStep makeDyedWig;
    ConditionalStep makePaste;
    ConditionalStep makeKeyMould;
    ConditionalStep getKey;
    Zone cell;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToHassan);
        steps.put(10, this.talkToOsman);
        this.makeDyedWig = new ConditionalStep((QuestHelper)this, this.talkToNed, new Requirement[0]);
        this.makeDyedWig.addStep(this.wig.alsoCheckBank(this.questBank), this.dyeWig);
        this.makeDyedWig.setLockingCondition(this.dyedWig.alsoCheckBank(this.questBank));
        this.makePaste = new ConditionalStep((QuestHelper)this, this.talkToAggie, new Requirement[0]);
        this.makePaste.setLockingCondition(this.paste.alsoCheckBank(this.questBank));
        this.makeKeyMould = new ConditionalStep((QuestHelper)this, this.talkToKeli, new Requirement[0]);
        this.makeKeyMould.setLockingCondition(this.hasOrGivenKeyMould);
        this.getKey = new ConditionalStep((QuestHelper)this, this.bringImprintToOsman, new Requirement[0]);
        this.getKey.setLockingCondition(this.givenKeyMould);
        ConditionalStep prepareToSaveAli = new ConditionalStep((QuestHelper)this, (QuestStep)this.makeDyedWig, new Requirement[0]);
        prepareToSaveAli.addStep(new Conditions(this.dyedWig.alsoCheckBank(this.questBank), this.paste.alsoCheckBank(this.questBank), new Conditions(LogicType.OR, this.madeMould, this.givenKeyMould)), this.talkToLeela);
        prepareToSaveAli.addStep(new Conditions(this.dyedWig.alsoCheckBank(this.questBank), this.paste.alsoCheckBank(this.questBank), this.hasOrGivenKeyMould), this.getKey);
        prepareToSaveAli.addStep(new Conditions(this.dyedWig.alsoCheckBank(this.questBank), this.paste.alsoCheckBank(this.questBank)), this.makeKeyMould);
        prepareToSaveAli.addStep(this.dyedWig.alsoCheckBank(this.questBank), this.makePaste);
        steps.put(20, prepareToSaveAli);
        ConditionalStep getJoeDrunk = new ConditionalStep((QuestHelper)this, (QuestStep)this.makeDyedWig, new Requirement[0]);
        getJoeDrunk.addStep(this.hasWigPasteAndKey, this.talkToJoe);
        getJoeDrunk.addStep(this.dyedWig.alsoCheckBank(this.questBank), this.makePaste);
        steps.put(30, getJoeDrunk);
        steps.put(31, getJoeDrunk);
        steps.put(32, getJoeDrunk);
        steps.put(33, getJoeDrunk);
        ConditionalStep tieUpKeli = new ConditionalStep((QuestHelper)this, (QuestStep)this.makeDyedWig, new Requirement[0]);
        tieUpKeli.addStep(this.hasWigPasteAndKey, this.useRopeOnKeli);
        tieUpKeli.addStep(this.dyedWig.alsoCheckBank(this.questBank), this.makePaste);
        steps.put(40, tieUpKeli);
        ConditionalStep freeAli = new ConditionalStep((QuestHelper)this, (QuestStep)this.makeDyedWig, new Requirement[0]);
        freeAli.addStep(new Conditions(this.hasWigPasteAndKey, this.inCell), this.talkToAli);
        freeAli.addStep(this.hasWigPasteAndKey, this.useKeyOnDoor);
        freeAli.addStep(this.dyedWig.alsoCheckBank(this.questBank), this.makePaste);
        steps.put(50, freeAli);
        steps.put(100, this.returnToHassan);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.softClay = new ItemRequirement("Soft clay", 1761);
        this.ballsOfWool3 = new ItemRequirement("Balls of wool", 1759, 3);
        this.yellowDye = new ItemRequirement("Yellow dye", 1765);
        this.yellowDye.setHighlightInInventory(true);
        this.redberries = new ItemRequirement("Redberries", 1951);
        this.ashes = new ItemRequirement("Ashes", 592);
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.potOfFlour = new ItemRequirement("Pot of flour", 1933);
        this.bronzeBar = new ItemRequirement("Bronze bar", 2349);
        this.pinkSkirt = new ItemRequirement("Pink skirt", 1013);
        this.beers3 = new ItemRequirement("Beers", 1917, 3);
        this.rope = new ItemRequirement("Rope", 954);
        this.ropeHighlighted = new ItemRequirement("Rope", 954);
        this.ropeHighlighted.setHighlightInInventory(true);
        this.ropeReqs = new ItemRequirement("Rope, or 15 coins / 4 balls of wool to obtain during the quest", 954);
        this.coins100 = new ItemRequirement("Coins minimum", ItemCollections.COINS, 100);
        this.wig = new ItemRequirement("Wig", 2421);
        this.wig.setHighlightInInventory(true);
        this.dyedWig = new ItemRequirement("Wig (dyed)", 2419);
        this.paste = new ItemRequirement("Paste", 2424);
        this.keyMould = new ItemRequirement("Key print", 2423);
        this.key = new ItemRequirement("Bronze key", 2418);
        this.key.setTooltip("You can get another from Leela for 15 coins");
        this.keyHighlighted = new ItemRequirement("Bronze key", 2418);
        this.keyHighlighted.setHighlightInInventory(true);
        this.yellowDyeReqs = new ItemRequirement("Yellow dye, or 2 onions + 5 coins to obtain during quest", 1765);
        this.glory = new ItemRequirement("Amulet of Glory for Al Kharid and Draynor Village teleports", ItemCollections.AMULET_OF_GLORIES);
    }

    public void setupConditions() {
        this.inCell = new ZoneRequirement(this.cell);
        this.hasWigPasteAndKey = new Conditions(this.dyedWig.alsoCheckBank(this.questBank), this.paste.alsoCheckBank(this.questBank), this.key.alsoCheckBank(this.questBank));
        this.givenKeyMould = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "I have duplicated a key, I need to get it from"), new WidgetTextRequirement(119, 3, true, "I got a duplicated cell door key"), new WidgetTextRequirement(11, 2, true, "You give Osman the imprint along with a bronze bar."), new DialogRequirement("I'll use this to have a copy of the key made. I'll send it to Leela once it's ready."), new DialogRequirement("I think I have everything needed."), this.key.alsoCheckBank(this.questBank));
        this.madeMould = new RuneliteRequirement(this.getConfigManager(), "princealikeymouldhandedin", "true", this.givenKeyMould);
        this.madeMould.initWithValue("false");
        this.hasOrGivenKeyMould = new Conditions(LogicType.OR, this.keyMould, this.givenKeyMould, this.key.alsoCheckBank(this.questBank));
    }

    public void setupZones() {
        this.cell = new Zone(new WorldPoint(3121, 3240, 0), new WorldPoint(3125, 3243, 0));
    }

    public void setupSteps() {
        this.talkToHassan = new NpcStep((QuestHelper)this, 4285, new WorldPoint(3298, 3163, 0), "Talk to Hassan in the Al Kharid Palace.", new Requirement[0]);
        this.talkToHassan.addDialogSteps("Is there anything I can help you with?", "Yes.");
        this.talkToOsman = new NpcStep((QuestHelper)this, 4286, new WorldPoint(3286, 3180, 0), "Talk to Osman north of the Al Kharid Palace.", new Requirement[0]);
        this.talkToNed = new NpcStep((QuestHelper)this, 4280, new WorldPoint(3097, 3257, 0), "Have Ned in Draynor Village make you a wig from 3 balls of wool. He can also sell you a rope for 15 coins or 4 balls of wool.", this.ballsOfWool3);
        this.talkToNed.addDialogStep("Could you make other things apart from rope?");
        this.talkToNed.addDialogStep("How about some sort of wig?");
        this.talkToNed.addDialogStep("I have them here. Please make me a wig.");
        this.dyeWig = new DetailedQuestStep((QuestHelper)this, "Dye the wig with yellow dye. Buy a yellow dye with two onions and 5 coins if you still need it from Aggie in Draynor Village.", this.yellowDye, this.wig);
        this.talkToAggie = new NpcStep((QuestHelper)this, 4284, new WorldPoint(3086, 3257, 0), "Talk to Aggie in Draynor Village to get some paste.", this.redberries, this.ashes, this.potOfFlour, this.bucketOfWater);
        this.talkToAggie.addDialogStep("Can you make skin paste?");
        this.talkToAggie.addDialogStep("Yes please. Mix me some skin paste.");
        this.talkToKeli = new NpcStep((QuestHelper)this, 11578, new WorldPoint(3127, 3244, 0), "Talk to Keli in the jail east of Draynor Village. If you've already made the key mould, open the quest journal to re-sync.", this.softClay);
        this.talkToKeli.addDialogStep("Heard of you? You're famous in Gielinor!");
        this.talkToKeli.addDialogStep("What's your latest plan then?");
        this.talkToKeli.addDialogStep("How do you know someone won't try to free him?");
        this.talkToKeli.addDialogStep("Could I see the key please?");
        this.talkToKeli.addDialogStep("Could I touch the key for a moment please?");
        this.bringImprintToOsman = new NpcStep((QuestHelper)this, 4286, new WorldPoint(3285, 3179, 0), "Bring the key print to Osman north of the Al Kharid Palace. If you already have, open the quest journal to re-sync.", this.keyMould, this.bronzeBar);
        this.talkToLeela = new NpcStep((QuestHelper)this, 4274, new WorldPoint(3113, 3262, 0), "Talk to Leela east of Draynor Village.", this.beers3, this.dyedWig, this.paste, this.rope, this.pinkSkirt);
        this.talkToJoe = new NpcStep((QuestHelper)this, 11577, new WorldPoint(3124, 3245, 0), "Bring everything to the jail and give Joe there three beers.", this.beers3, this.key, this.dyedWig, this.paste, this.rope, this.pinkSkirt);
        this.talkToJoe.addDialogStep("I have some beer here. Fancy one?");
        this.useRopeOnKeli = new NpcStep((QuestHelper)this, 11578, new WorldPoint(3127, 3244, 0), "Use rope on Keli.", this.ropeHighlighted);
        this.useRopeOnKeli.addIcon(954);
        this.useKeyOnDoor = new ObjectStep((QuestHelper)this, 2881, new WorldPoint(3123, 3243, 0), "Use the key on the prison door. If Lady Keli respawned you'll need to tie her up again.", this.keyHighlighted, this.dyedWig, this.paste, this.pinkSkirt);
        this.useKeyOnDoor.addIcon(2418);
        this.talkToAli = new NpcStep((QuestHelper)this, 11579, new WorldPoint(3123, 3240, 0), "Talk to Prince Ali and free him.", this.key, this.dyedWig, this.paste, this.pinkSkirt);
        this.returnToHassan = new NpcStep((QuestHelper)this, 4285, new WorldPoint(3298, 3163, 0), "Return to Hassan in the Al Kharid Palace to complete the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.softClay);
        reqs.add(this.ballsOfWool3);
        reqs.add(this.yellowDye);
        reqs.add(this.redberries);
        reqs.add(this.ashes);
        reqs.add(this.bucketOfWater);
        reqs.add(this.potOfFlour);
        reqs.add(this.bronzeBar);
        reqs.add(this.pinkSkirt);
        reqs.add(this.beers3);
        reqs.add(this.rope);
        reqs.add(this.coins100);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.glory);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Able to survive jail guards (level 26) attacking you");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 700));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Free use of the Al Kharid toll gates."), new UnlockReward("Access to Sorceress's Garden Minigame (Members)"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToHassan, this.talkToOsman), new Requirement[0]));
        PanelDetails makeWigPanel = new PanelDetails("Make a blonde wig", Arrays.asList(this.talkToNed, this.dyeWig), this.yellowDye, this.ballsOfWool3);
        makeWigPanel.setLockingStep(this.makeDyedWig);
        allSteps.add(makeWigPanel);
        PanelDetails makePastePanel = new PanelDetails("Make paste", Collections.singletonList(this.talkToAggie), this.redberries, this.ashes, this.potOfFlour, this.bucketOfWater);
        makePastePanel.setLockingStep(this.makePaste);
        allSteps.add(makePastePanel);
        PanelDetails makeKeyMouldPanel = new PanelDetails("Make a key mould", Collections.singletonList(this.talkToKeli), this.softClay);
        makeKeyMouldPanel.setLockingStep(this.makeKeyMould);
        allSteps.add(makeKeyMouldPanel);
        PanelDetails getKeyPanel = new PanelDetails("Make the key", Collections.singletonList(this.bringImprintToOsman), this.bronzeBar, this.keyMould);
        getKeyPanel.setLockingStep(this.getKey);
        allSteps.add(getKeyPanel);
        allSteps.add(new PanelDetails("Return with the items", Collections.singletonList(this.talkToLeela), this.dyedWig, this.paste, this.rope, this.beers3, this.pinkSkirt));
        allSteps.add(new PanelDetails("Free Ali", Arrays.asList(this.talkToJoe, this.useRopeOnKeli, this.useKeyOnDoor, this.talkToAli), this.key, this.dyedWig, this.paste, this.rope, this.beers3, this.pinkSkirt));
        allSteps.add(new PanelDetails("Return to Al Kharid", Collections.singletonList(this.returnToHassan), new Requirement[0]));
        return allSteps;
    }
}

