/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.priestinperil;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.helpers.quests.priestinperil.BringDrezelPureEssenceStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.PRIEST_IN_PERIL)
public class PriestInPeril
extends BasicQuestHelper {
    ItemRequirement runeEssence;
    ItemRequirement lotsOfRuneEssence;
    ItemRequirement bucket;
    ItemRequirement weaponAndArmour;
    ItemRequirement goldenKey;
    ItemRequirement rangedMagedGear;
    ItemRequirement murkyWater;
    ItemRequirement ironKey;
    ItemRequirement blessedWaterHighlighted;
    ItemRequirement bucketHighlighted;
    ItemRequirement goldenKeyHighlighted;
    ItemRequirement runePouches;
    ItemRequirement varrockTeleport;
    Requirement inUnderground;
    Requirement hasGoldenOrIronKey;
    Requirement inTempleGroundFloor;
    Requirement inTemple;
    Requirement inTempleFirstFloor;
    Requirement inTempleSecondFloor;
    QuestStep talkToRoald;
    QuestStep goToTemple;
    QuestStep goDownToDog;
    QuestStep killTheDog;
    QuestStep climbUpAfterKillingDog;
    QuestStep returnToKingRoald;
    QuestStep returnToTemple;
    QuestStep killMonk;
    QuestStep talkToDrezel;
    QuestStep goUpToFloorTwoTemple;
    QuestStep goUpToFloorOneTemple;
    QuestStep goDownToFloorOneTemple;
    QuestStep goDownToGroundFloorTemple;
    QuestStep enterUnderground;
    QuestStep fillBucket;
    QuestStep useKeyForKey;
    QuestStep openDoor;
    QuestStep useBlessedWater;
    QuestStep blessWater;
    QuestStep goUpWithWaterToSurface;
    QuestStep goUpWithWaterToFirstFloor;
    QuestStep goUpWithWaterToSecondFloor;
    QuestStep talkToDrezelAfterFreeing;
    QuestStep goDownToFloorOneAfterFreeing;
    QuestStep goDownToGroundFloorAfterFreeing;
    QuestStep enterUndergroundAfterFreeing;
    QuestStep talkToDrezelUnderground;
    QuestStep bringDrezelEssence;
    Zone underground;
    Zone temple1;
    Zone temple2;
    Zone temple3;
    Zone temple4;
    Zone temple5;
    Zone temple6;
    Zone templeFloorOne;
    Zone templeFloorTwo;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToRoald);
        steps.put(1, this.goToTemple);
        ConditionalStep goDownAndKillDog = new ConditionalStep((QuestHelper)this, this.goDownToDog, new Requirement[0]);
        goDownAndKillDog.addStep(this.inUnderground, this.killTheDog);
        steps.put(2, goDownAndKillDog);
        ConditionalStep reportKillingDog = new ConditionalStep((QuestHelper)this, this.returnToKingRoald, new Requirement[0]);
        reportKillingDog.addStep(this.inUnderground, this.climbUpAfterKillingDog);
        steps.put(3, reportKillingDog);
        ConditionalStep goTalkToDrezel = new ConditionalStep((QuestHelper)this, this.returnToTemple, new Requirement[0]);
        goTalkToDrezel.addStep(new Conditions(this.hasGoldenOrIronKey, this.inTempleSecondFloor), this.talkToDrezel);
        goTalkToDrezel.addStep(new Conditions(this.hasGoldenOrIronKey, this.inTempleFirstFloor), this.goUpToFloorTwoTemple);
        goTalkToDrezel.addStep(new Conditions(this.hasGoldenOrIronKey, this.inTempleGroundFloor), this.goUpToFloorOneTemple);
        goTalkToDrezel.addStep(this.inTemple, this.killMonk);
        steps.put(4, goTalkToDrezel);
        ConditionalStep goGetKey = new ConditionalStep((QuestHelper)this, this.returnToTemple, new Requirement[0]);
        goGetKey.addStep(new Conditions(this.ironKey, this.murkyWater, this.inTempleSecondFloor), this.openDoor);
        goGetKey.addStep(new Conditions(this.ironKey, this.murkyWater, this.inTempleFirstFloor), this.goUpWithWaterToSecondFloor);
        goGetKey.addStep(new Conditions(this.ironKey, this.murkyWater, this.inUnderground), this.goUpWithWaterToSurface);
        goGetKey.addStep(new Conditions(this.ironKey, this.murkyWater), this.goUpWithWaterToFirstFloor);
        goGetKey.addStep(new Conditions(this.ironKey, this.inUnderground), this.fillBucket);
        goGetKey.addStep(new Conditions(this.hasGoldenOrIronKey, this.inUnderground), this.useKeyForKey);
        goGetKey.addStep(new Conditions(this.hasGoldenOrIronKey, this.inTempleSecondFloor), this.goDownToFloorOneTemple);
        goGetKey.addStep(new Conditions(this.hasGoldenOrIronKey, this.inTempleFirstFloor), this.goDownToGroundFloorTemple);
        goGetKey.addStep(this.hasGoldenOrIronKey, this.enterUnderground);
        goGetKey.addStep(this.inTemple, this.killMonk);
        steps.put(5, goGetKey);
        ConditionalStep goGetWater = new ConditionalStep((QuestHelper)this, this.enterUnderground, new Requirement[0]);
        goGetWater.addStep(new Conditions(this.blessedWaterHighlighted, this.inTempleSecondFloor), this.useBlessedWater);
        goGetWater.addStep(new Conditions(this.murkyWater, this.inTempleSecondFloor), this.blessWater);
        goGetWater.addStep(new Conditions(this.murkyWater, this.inTempleFirstFloor), this.goUpWithWaterToSecondFloor);
        goGetWater.addStep(new Conditions(this.murkyWater, this.inUnderground), this.goUpWithWaterToSurface);
        goGetWater.addStep(this.murkyWater, this.goUpWithWaterToFirstFloor);
        goGetWater.addStep(this.inUnderground, this.fillBucket);
        goGetWater.addStep(this.inTempleSecondFloor, this.goDownToFloorOneTemple);
        goGetWater.addStep(this.inTempleFirstFloor, this.goDownToGroundFloorTemple);
        steps.put(6, goGetWater);
        ConditionalStep goTalkToDrezelAfterFreeing = new ConditionalStep((QuestHelper)this, this.goUpWithWaterToFirstFloor, new Requirement[0]);
        goTalkToDrezelAfterFreeing.addStep(this.inTempleSecondFloor, this.talkToDrezelAfterFreeing);
        goTalkToDrezelAfterFreeing.addStep(this.inTempleFirstFloor, this.goUpWithWaterToSecondFloor);
        steps.put(7, goTalkToDrezelAfterFreeing);
        ConditionalStep goDownToDrezel = new ConditionalStep((QuestHelper)this, this.enterUndergroundAfterFreeing, new Requirement[0]);
        goDownToDrezel.addStep(this.inUnderground, this.talkToDrezelUnderground);
        goDownToDrezel.addStep(this.inTempleFirstFloor, this.goDownToGroundFloorAfterFreeing);
        goDownToDrezel.addStep(this.inTempleSecondFloor, this.goDownToFloorOneAfterFreeing);
        steps.put(8, goDownToDrezel);
        steps.put(9, goDownToDrezel);
        steps.put(10, this.bringDrezelEssence);
        steps.put(11, this.bringDrezelEssence);
        steps.put(12, this.bringDrezelEssence);
        steps.put(13, this.bringDrezelEssence);
        steps.put(14, this.bringDrezelEssence);
        steps.put(15, this.bringDrezelEssence);
        steps.put(16, this.bringDrezelEssence);
        steps.put(17, this.bringDrezelEssence);
        steps.put(18, this.bringDrezelEssence);
        steps.put(19, this.bringDrezelEssence);
        steps.put(20, this.bringDrezelEssence);
        steps.put(21, this.bringDrezelEssence);
        steps.put(22, this.bringDrezelEssence);
        steps.put(23, this.bringDrezelEssence);
        steps.put(24, this.bringDrezelEssence);
        steps.put(25, this.bringDrezelEssence);
        steps.put(26, this.bringDrezelEssence);
        steps.put(27, this.bringDrezelEssence);
        steps.put(28, this.bringDrezelEssence);
        steps.put(29, this.bringDrezelEssence);
        steps.put(30, this.bringDrezelEssence);
        steps.put(31, this.bringDrezelEssence);
        steps.put(32, this.bringDrezelEssence);
        steps.put(33, this.bringDrezelEssence);
        steps.put(34, this.bringDrezelEssence);
        steps.put(35, this.bringDrezelEssence);
        steps.put(36, this.bringDrezelEssence);
        steps.put(37, this.bringDrezelEssence);
        steps.put(38, this.bringDrezelEssence);
        steps.put(39, this.bringDrezelEssence);
        steps.put(40, this.bringDrezelEssence);
        steps.put(41, this.bringDrezelEssence);
        steps.put(42, this.bringDrezelEssence);
        steps.put(43, this.bringDrezelEssence);
        steps.put(44, this.bringDrezelEssence);
        steps.put(45, this.bringDrezelEssence);
        steps.put(46, this.bringDrezelEssence);
        steps.put(47, this.bringDrezelEssence);
        steps.put(48, this.bringDrezelEssence);
        steps.put(49, this.bringDrezelEssence);
        steps.put(50, this.bringDrezelEssence);
        steps.put(51, this.bringDrezelEssence);
        steps.put(52, this.bringDrezelEssence);
        steps.put(53, this.bringDrezelEssence);
        steps.put(54, this.bringDrezelEssence);
        steps.put(55, this.bringDrezelEssence);
        steps.put(56, this.bringDrezelEssence);
        steps.put(57, this.bringDrezelEssence);
        steps.put(58, this.bringDrezelEssence);
        steps.put(59, this.bringDrezelEssence);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.runeEssence = new ItemRequirement("Rune or Pure Essence", 1436, 50);
        this.runeEssence.addAlternates(7936);
        this.bucket = new ItemRequirement("Bucket", 1925).isNotConsumed();
        this.bucketHighlighted = this.bucket.highlighted();
        this.runePouches = new ItemRequirements(LogicType.OR, "Essence pouches for carrying essence", new ItemRequirement("Small pouch", 5509), new ItemRequirement("Medium pouch", 5510), new ItemRequirement("Large pouch", 5512), new ItemRequirement("Giant pouch", 5514)).isNotConsumed();
        this.varrockTeleport = new ItemRequirement("Varrock teleports", 8007, 3);
        this.weaponAndArmour = new ItemRequirement("Ranged or melee weapon + armour", -1, -1).isNotConsumed();
        this.weaponAndArmour.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.goldenKey = new ItemRequirement("Golden key", 2944);
        this.goldenKeyHighlighted = new ItemRequirement("Golden key", 2944);
        this.goldenKeyHighlighted.setHighlightInInventory(true);
        this.rangedMagedGear = new ItemRequirement("Combat gear, ranged or mage to safespot", -1, -1).isNotConsumed();
        this.rangedMagedGear.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.lotsOfRuneEssence = new ItemRequirement("As much essence as you can carry, you'll need to bring 50 UNNOTED in total", 7936, -1);
        this.murkyWater = new ItemRequirement("Murky water", 2953);
        this.murkyWater.addAlternates(2954);
        this.ironKey = new ItemRequirement("Iron key", 2945);
        this.blessedWaterHighlighted = new ItemRequirement("Blessed water", 2954);
        this.blessedWaterHighlighted.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.underground = new Zone(new WorldPoint(3402, 9880, 0), new WorldPoint(3443, 9907, 0));
        this.temple1 = new Zone(new WorldPoint(3409, 3483, 0), new WorldPoint(3411, 3494, 0));
        this.temple2 = new Zone(new WorldPoint(3408, 3485, 0), new WorldPoint(3408, 3486, 0));
        this.temple3 = new Zone(new WorldPoint(3408, 3491, 0), new WorldPoint(3408, 3492, 0));
        this.temple4 = new Zone(new WorldPoint(3412, 3484, 0), new WorldPoint(3415, 3493, 0));
        this.temple5 = new Zone(new WorldPoint(3416, 3483, 0), new WorldPoint(3417, 3494, 0));
        this.temple6 = new Zone(new WorldPoint(3418, 3484, 0), new WorldPoint(3418, 3493, 0));
        this.templeFloorOne = new Zone(new WorldPoint(3408, 3483, 1), new WorldPoint(3419, 3494, 1));
        this.templeFloorTwo = new Zone(new WorldPoint(3408, 3483, 2), new WorldPoint(3419, 3494, 2));
    }

    public void setupConditions() {
        this.inUnderground = new ZoneRequirement(this.underground);
        this.inTempleGroundFloor = new ZoneRequirement(this.temple1, this.temple2, this.temple3, this.temple4, this.temple5, this.temple6);
        this.inTempleFirstFloor = new ZoneRequirement(this.templeFloorOne);
        this.inTempleSecondFloor = new ZoneRequirement(this.templeFloorTwo);
        this.inTemple = new ZoneRequirement(this.temple1, this.temple2, this.temple3, this.temple4, this.temple5, this.temple6, this.templeFloorOne, this.templeFloorTwo);
        this.hasGoldenOrIronKey = new Conditions(LogicType.OR, this.goldenKey, this.ironKey);
    }

    public void setupSteps() {
        this.talkToRoald = new NpcStep((QuestHelper)this, 5215, new WorldPoint(3222, 3473, 0), "Speak to King Roald in Varrock Castle.", new Requirement[0]);
        this.talkToRoald.addDialogStep("I'm looking for a quest!");
        this.talkToRoald.addDialogStep("Yes.");
        this.goToTemple = new ObjectStep((QuestHelper)this, 3490, new WorldPoint(3408, 3488, 0), "Go to the temple east of Varrock by the river and click on the large door.", this.weaponAndArmour);
        this.goToTemple.addDialogSteps("I'll get going.", "Roald sent me to check on Drezel.", "Sure. I'm a helpful person!");
        this.goDownToDog = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3405, 3507, 0), "Go down the ladder north of the temple.", new Requirement[0]);
        this.goDownToDog.addDialogStep("Yes.");
        ((ObjectStep)this.goDownToDog).addAlternateObjects(1581);
        this.killTheDog = new NpcStep((QuestHelper)this, 7620, new WorldPoint(3405, 9901, 0), "Kill the Temple Guardian (level 30). It is immune to magic so you will need to use either ranged or melee.", new Requirement[0]);
        this.climbUpAfterKillingDog = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3405, 9907, 0), "Climb back up the ladder and return to King Roald.", new Requirement[0]);
        this.returnToKingRoald = new NpcStep((QuestHelper)this, 5215, new WorldPoint(3222, 3473, 0), "Return to King Roald.", new Requirement[0]);
        this.returnToKingRoald.addSubSteps(this.climbUpAfterKillingDog);
        this.returnToTemple = new ObjectStep((QuestHelper)this, 3490, new WorldPoint(3408, 3488, 0), "Return to the temple.", this.bucket, this.lotsOfRuneEssence, this.rangedMagedGear);
        this.killMonk = new NpcStep((QuestHelper)this, 3486, new WorldPoint(3412, 3488, 0), "Kill a Monk of Zamorak (level 30) for a golden key. You can safespot using the pews.", true, this.goldenKey);
        this.goUpToFloorOneTemple = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(3418, 3493, 0), "Go upstairs.", new Requirement[0]);
        this.goUpToFloorTwoTemple = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3410, 3485, 1), "Climb up the ladder.", new Requirement[0]);
        this.talkToDrezel = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3418, 3489, 2), "Talk to Drezel on the top floor of the temple.", new Requirement[0]);
        this.talkToDrezel.addDialogSteps("So, what now?", "Yes, of course.");
        this.talkToDrezel.addSubSteps(this.goUpToFloorOneTemple, this.goUpToFloorTwoTemple);
        this.fillBucket = new ObjectStep((QuestHelper)this, 3485, new WorldPoint(3423, 9890, 0), "Use the bucket on the well in the central room.", this.bucketHighlighted);
        this.fillBucket.addIcon(1925);
        this.useKeyForKey = new DetailedQuestStep((QuestHelper)this, "Go to the central room, and study the monuments to find which has a key on it. Use the Golden Key on it.", this.goldenKeyHighlighted);
        this.useKeyForKey.addIcon(2944);
        this.goDownToFloorOneTemple = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(3410, 3485, 2), "Go down to the underground of the temple.", this.bucket);
        this.goDownToGroundFloorTemple = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(3417, 3485, 0), "Go down to the underground of the temple.", this.bucket);
        this.enterUnderground = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3405, 3507, 0), "Go down to the underground of the temple.", this.bucket);
        this.enterUnderground.addSubSteps(this.goDownToFloorOneTemple, this.goDownToGroundFloorTemple);
        ((ObjectStep)this.enterUnderground).addAlternateObjects(1581);
        this.goUpWithWaterToSurface = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3405, 9907, 0), "Go back up to the top floor of the temple.", new Requirement[0]);
        this.goUpWithWaterToFirstFloor = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(3418, 3493, 0), "Go back up to the top floor of the temple.", new Requirement[0]);
        this.goUpWithWaterToSecondFloor = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3410, 3485, 1), "Go back up to the top floor of the temple.", new Requirement[0]);
        this.goUpWithWaterToSecondFloor.addSubSteps(this.goUpWithWaterToSurface, this.goUpWithWaterToFirstFloor);
        this.openDoor = new ObjectStep((QuestHelper)this, 3463, new WorldPoint(3415, 3489, 2), "Open the cell door.", this.ironKey);
        this.blessWater = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3418, 3489, 2), "Talk to Drezel to bless the water.", this.murkyWater);
        this.useBlessedWater = new ObjectStep((QuestHelper)this, 3480, new WorldPoint(3413, 3487, 2), "Use the blessed water on the coffin.", this.blessedWaterHighlighted);
        this.useBlessedWater.addIcon(2954);
        this.talkToDrezelAfterFreeing = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3418, 3489, 2), "Talk to Drezel again.", new Requirement[0]);
        this.goDownToFloorOneAfterFreeing = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(3410, 3485, 2), "Go down to the underground of the temple.", this.lotsOfRuneEssence);
        this.goDownToGroundFloorAfterFreeing = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(3417, 3485, 0), "Go down to the underground of the temple.", this.lotsOfRuneEssence);
        this.enterUndergroundAfterFreeing = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3405, 3507, 0), "Go down to the underground of the temple.", this.lotsOfRuneEssence);
        ((ObjectStep)this.enterUndergroundAfterFreeing).addAlternateObjects(1581);
        this.talkToDrezelUnderground = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3439, 9896, 0), "Talk to Drezel in the east of the underground temple area.", this.lotsOfRuneEssence);
        this.talkToDrezelUnderground.addSubSteps(this.goDownToFloorOneAfterFreeing, this.goDownToGroundFloorAfterFreeing, this.enterUndergroundAfterFreeing);
        this.bringDrezelEssence = new BringDrezelPureEssenceStep(this);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.runePouches);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.runeEssence);
        reqs.add(this.bucket);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Temple Guardian (level 30). You cannot use Magic. Rings of recoil will not award the kill.", "Monk of Zamorak (level 30)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.PRAYER, 1406));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Wolfbane Dagger", 2952, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Canifis and Morytania"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Collections.singletonList(this.talkToRoald), new Requirement[0]));
        allSteps.add(new PanelDetails("Go to the temple", Arrays.asList(this.goToTemple, this.killTheDog, this.returnToKingRoald), this.weaponAndArmour));
        allSteps.add(new PanelDetails("Return to the temple", Arrays.asList(this.returnToTemple, this.killMonk, this.talkToDrezel), this.weaponAndArmour, this.bucket, this.lotsOfRuneEssence));
        allSteps.add(new PanelDetails("Freeing Drezel", Arrays.asList(this.enterUnderground, this.useKeyForKey, this.fillBucket, this.goUpWithWaterToSecondFloor, this.openDoor, this.blessWater, this.useBlessedWater, this.talkToDrezelAfterFreeing), this.weaponAndArmour, this.bucket, this.lotsOfRuneEssence));
        allSteps.add(new PanelDetails("Curing the Salve", Arrays.asList(this.talkToDrezelUnderground, this.bringDrezelEssence), this.runeEssence));
        return allSteps;
    }
}

