/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.plaguecity;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.PLAGUE_CITY)
public class PlagueCity
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement dwellberries;
    ItemRequirement rope;
    ItemRequirement bucketOfMilk;
    ItemRequirement chocolateDust;
    ItemRequirement snapeGrass;
    ItemRequirement pictureOfElena;
    ItemRequirement gasMask;
    ItemRequirement book;
    ItemRequirement bucketOfChocolateMilk;
    ItemRequirement hangoverCure;
    ItemRequirement warrant;
    ItemRequirement key;
    ItemRequirement fourBucketsOfWater;
    ItemRequirement threeBucketsOfWater;
    ItemRequirement twoBucketsOfWater;
    ItemRequirement bucketOfWater;
    Requirement inUnderground;
    Requirement hasTriedToPullGrill;
    Requirement inWestArdougne;
    Requirement inUpstairsMathasHouse;
    Requirement inPlagueHouse;
    Requirement inDownstairsOfPlagueHouse;
    Requirement manholeClosed;
    QuestStep talkToEdmond;
    QuestStep talkToAlrena;
    QuestStep talkToEdmondAgain;
    QuestStep useWaterOnMudPatch1;
    QuestStep useWaterOnMudPatch2;
    QuestStep useWaterOnMudPatch3;
    QuestStep useWaterOnMudPatch4;
    QuestStep digHole;
    QuestStep grabPictureOfElena;
    QuestStep goDownHole;
    QuestStep attemptToPullGrill;
    QuestStep climbMudPile;
    QuestStep talkToEdmondUnderground;
    QuestStep useRopeOnGrill;
    QuestStep climbThroughPipe;
    QuestStep talkToJethick;
    QuestStep enterMarthasHouse;
    QuestStep talkToMartha;
    QuestStep talkToMilli;
    QuestStep goUpstairsInMarthasHouse;
    QuestStep tryToEnterPlagueHouse;
    QuestStep talkToClerk;
    QuestStep talkToBravek;
    QuestStep useDustOnMilk;
    QuestStep useSnapeGrassOnChocolateMilk;
    QuestStep giveHangoverCureToBravek;
    QuestStep talkToBravekAgain;
    QuestStep tryToEnterPlagueHouseAgain;
    QuestStep searchBarrel;
    QuestStep goDownstairsInPlagueHouse;
    QuestStep goUpstairsInPlagueHouse;
    QuestStep talkToElena;
    QuestStep goUpstairsInPlagueHouseToFinish;
    QuestStep goDownManhole;
    QuestStep goDownManhole2;
    QuestStep climbMudPileToFinish;
    QuestStep talkToEdmondToFinish;
    Zone underground;
    Zone westArdougne1;
    Zone westArdougne2;
    Zone westArdougne3;
    Zone upstairsMathasHouse;
    Zone plagueHouse1;
    Zone plagueHouse2;
    Zone downstairsOfPlagueHouse;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToEdmond);
        steps.put(1, this.talkToAlrena);
        ConditionalStep getPictureThenTalkEdmond = new ConditionalStep((QuestHelper)this, this.grabPictureOfElena, new Requirement[0]);
        getPictureThenTalkEdmond.addStep(this.pictureOfElena, this.talkToEdmondAgain);
        steps.put(2, getPictureThenTalkEdmond);
        steps.put(3, this.useWaterOnMudPatch1);
        steps.put(4, this.useWaterOnMudPatch2);
        steps.put(5, this.useWaterOnMudPatch3);
        steps.put(6, this.useWaterOnMudPatch4);
        ConditionalStep getPictureThenDig = new ConditionalStep((QuestHelper)this, this.grabPictureOfElena, new Requirement[0]);
        getPictureThenDig.addStep(this.pictureOfElena, this.digHole);
        steps.put(7, getPictureThenDig);
        ConditionalStep attemptToOpenGrill = new ConditionalStep((QuestHelper)this, this.grabPictureOfElena, new Requirement[0]);
        attemptToOpenGrill.addStep(new Conditions(this.hasTriedToPullGrill, this.inUnderground, this.pictureOfElena), this.useRopeOnGrill);
        attemptToOpenGrill.addStep(new Conditions(this.inUnderground, this.pictureOfElena), this.attemptToPullGrill);
        attemptToOpenGrill.addStep(this.inUnderground, this.climbMudPile);
        attemptToOpenGrill.addStep(this.pictureOfElena, this.goDownHole);
        steps.put(8, attemptToOpenGrill);
        ConditionalStep pullOffGrill = new ConditionalStep((QuestHelper)this, this.grabPictureOfElena, new Requirement[0]);
        pullOffGrill.addStep(new Conditions(this.inUnderground, this.pictureOfElena), this.talkToEdmondUnderground);
        pullOffGrill.addStep(this.inUnderground, this.climbMudPile);
        pullOffGrill.addStep(this.pictureOfElena, this.goDownHole);
        steps.put(9, pullOffGrill);
        ConditionalStep enterWestArdougne = new ConditionalStep((QuestHelper)this, this.grabPictureOfElena, new Requirement[0]);
        enterWestArdougne.addStep(new Conditions(this.inWestArdougne, this.pictureOfElena), this.talkToJethick);
        enterWestArdougne.addStep(new Conditions(this.inUnderground, this.pictureOfElena), this.climbThroughPipe);
        enterWestArdougne.addStep(this.inUnderground, this.climbMudPile);
        enterWestArdougne.addStep(this.pictureOfElena, this.goDownHole);
        steps.put(10, enterWestArdougne);
        ConditionalStep goToMarthasHouse = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        goToMarthasHouse.addStep(new Conditions(this.inWestArdougne, this.book), this.enterMarthasHouse);
        goToMarthasHouse.addStep(this.inWestArdougne, this.talkToJethick);
        goToMarthasHouse.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(20, goToMarthasHouse);
        ConditionalStep talkToMarthaInHouse = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        talkToMarthaInHouse.addStep(this.inWestArdougne, this.talkToMartha);
        talkToMarthaInHouse.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(21, talkToMarthaInHouse);
        ConditionalStep talkToMilliInHouse = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        talkToMilliInHouse.addStep(this.inUpstairsMathasHouse, this.talkToMilli);
        talkToMilliInHouse.addStep(this.inWestArdougne, this.goUpstairsInMarthasHouse);
        talkToMilliInHouse.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(22, talkToMilliInHouse);
        ConditionalStep goToPlagueHouse = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        goToPlagueHouse.addStep(this.inWestArdougne, this.tryToEnterPlagueHouse);
        goToPlagueHouse.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(23, goToPlagueHouse);
        ConditionalStep goSpeakToClerk = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        goSpeakToClerk.addStep(this.inWestArdougne, this.talkToClerk);
        goSpeakToClerk.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(24, goSpeakToClerk);
        ConditionalStep goTalkToBravek = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        goTalkToBravek.addStep(this.inWestArdougne, this.talkToBravek);
        goTalkToBravek.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(25, goTalkToBravek);
        ConditionalStep createHangoverCureForBravek = new ConditionalStep((QuestHelper)this, this.useDustOnMilk, new Requirement[0]);
        createHangoverCureForBravek.addStep(new Conditions(this.inWestArdougne, this.hangoverCure), this.giveHangoverCureToBravek);
        createHangoverCureForBravek.addStep(new Conditions(this.hangoverCure, this.inUnderground), this.climbThroughPipe);
        createHangoverCureForBravek.addStep(this.hangoverCure, this.goDownHole);
        createHangoverCureForBravek.addStep(this.bucketOfChocolateMilk, this.useSnapeGrassOnChocolateMilk);
        steps.put(26, createHangoverCureForBravek);
        ConditionalStep continueTalkingToBravek = new ConditionalStep((QuestHelper)this, this.goDownHole, new Requirement[0]);
        continueTalkingToBravek.addStep(new Conditions(this.inDownstairsOfPlagueHouse, this.key), this.talkToElena);
        continueTalkingToBravek.addStep(new Conditions(this.inPlagueHouse, this.key), this.goDownstairsInPlagueHouse);
        continueTalkingToBravek.addStep(this.inPlagueHouse, this.searchBarrel);
        continueTalkingToBravek.addStep(this.inDownstairsOfPlagueHouse, this.goUpstairsInPlagueHouse);
        continueTalkingToBravek.addStep(new Conditions(this.warrant, this.inWestArdougne), this.tryToEnterPlagueHouseAgain);
        continueTalkingToBravek.addStep(this.inWestArdougne, this.talkToBravekAgain);
        continueTalkingToBravek.addStep(this.inUnderground, this.climbThroughPipe);
        steps.put(27, continueTalkingToBravek);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.talkToEdmondToFinish, new Requirement[0]);
        finishQuest.addStep(this.inDownstairsOfPlagueHouse, this.goUpstairsInPlagueHouseToFinish);
        finishQuest.addStep(new Conditions(this.inWestArdougne, this.manholeClosed), this.goDownManhole2);
        finishQuest.addStep(this.inWestArdougne, this.goDownManhole);
        finishQuest.addStep(this.inUnderground, this.climbMudPileToFinish);
        steps.put(28, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.dwellberries = new ItemRequirement("Dwellberries", 2126);
        this.dwellberries.setTooltip("You can get these from McGrubor's Wood west of Seers' Village");
        this.rope = new ItemRequirement("Rope", 954);
        this.rope.setHighlightInInventory(true);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.spade.setHighlightInInventory(true);
        this.fourBucketsOfWater = new ItemRequirement("Buckets of water", 1929, 4);
        this.fourBucketsOfWater.setHighlightInInventory(true);
        this.fourBucketsOfWater.setTooltip("You can use the bucket near the start of the quest on the sink nearby");
        this.threeBucketsOfWater = new ItemRequirement("Buckets of water", 1929, 3);
        this.threeBucketsOfWater.setHighlightInInventory(true);
        this.threeBucketsOfWater.setTooltip("You can use the bucket near the start of the quest on the sink nearby");
        this.twoBucketsOfWater = new ItemRequirement("Buckets of water", 1929, 2);
        this.twoBucketsOfWater.setHighlightInInventory(true);
        this.twoBucketsOfWater.setTooltip("You can use the bucket near the start of the quest on the sink nearby");
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.bucketOfWater.setHighlightInInventory(true);
        this.bucketOfMilk = new ItemRequirement("Bucket of milk", 1927);
        this.bucketOfMilk.setHighlightInInventory(true);
        this.chocolateDust = new ItemRequirement("Chocolate dust", 1975);
        this.chocolateDust.setHighlightInInventory(true);
        this.snapeGrass = new ItemRequirement("Snape grass", 231);
        this.snapeGrass.setHighlightInInventory(true);
        this.pictureOfElena = new ItemRequirement("Picture", 1510);
        this.gasMask = new ItemRequirement("Gas mask", 1506, 1, true).isNotConsumed();
        this.gasMask.setTooltip("You can get another from the cupboard in Edmond's house.");
        this.book = new ItemRequirement("Book", 1509);
        this.bucketOfChocolateMilk = new ItemRequirement("Chocolatey milk", 1977);
        this.bucketOfChocolateMilk.setHighlightInInventory(true);
        this.hangoverCure = new ItemRequirement("Hangover cure", 1504);
        this.warrant = new ItemRequirement("Warrant", 1503);
        this.inPlagueHouse = new ZoneRequirement(this.plagueHouse1, this.plagueHouse2);
        this.inDownstairsOfPlagueHouse = new ZoneRequirement(this.downstairsOfPlagueHouse);
        this.key = new ItemRequirement("A small key", 1507);
    }

    public void loadZones() {
        this.underground = new Zone(new WorldPoint(2506, 9737, 0), new WorldPoint(2532, 9781, 0));
        this.westArdougne1 = new Zone(new WorldPoint(2460, 3279, 0), new WorldPoint(2556, 3334, 2));
        this.westArdougne2 = new Zone(new WorldPoint(2434, 3305, 0), new WorldPoint(2464, 3323, 2));
        this.westArdougne3 = new Zone(new WorldPoint(2510, 3265, 0), new WorldPoint(2556, 3280, 2));
        this.upstairsMathasHouse = new Zone(new WorldPoint(2527, 3329, 1), new WorldPoint(2533, 3333, 1));
        this.plagueHouse1 = new Zone(new WorldPoint(2532, 3268, 0), new WorldPoint(2541, 3271, 0));
        this.plagueHouse2 = new Zone(new WorldPoint(2535, 3272, 0), new WorldPoint(2541, 3272, 0));
        this.downstairsOfPlagueHouse = new Zone(new WorldPoint(2535, 9670, 0), new WorldPoint(2542, 9673, 0));
    }

    public void setupConditions() {
        this.inUnderground = new ZoneRequirement(this.underground);
        this.hasTriedToPullGrill = new VarbitRequirement(1786, 1);
        this.inWestArdougne = new ZoneRequirement(this.westArdougne1, this.westArdougne2, this.westArdougne3);
        this.inUpstairsMathasHouse = new ZoneRequirement(this.upstairsMathasHouse);
        this.manholeClosed = new ObjectCondition(2543);
    }

    public void setupSteps() {
        this.talkToEdmond = new NpcStep((QuestHelper)this, 4256, new WorldPoint(2568, 3333, 0), "Talk to Edmond in the north-west corner of East Ardougne.", new Requirement[0]);
        this.talkToEdmond.addDialogStep("What's happened to her?");
        this.talkToEdmond.addDialogStep("Yes.");
        this.talkToAlrena = new NpcStep((QuestHelper)this, 4249, new WorldPoint(2573, 3333, 0), "Talk to Alrena nearby.", this.dwellberries);
        this.talkToEdmondAgain = new NpcStep((QuestHelper)this, 4256, new WorldPoint(2568, 3332, 0), "Talk to Edmond again.", new Requirement[0]);
        this.useWaterOnMudPatch1 = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Use four buckets of water on the mud patch in Edmond's garden patch.", this.fourBucketsOfWater);
        this.useWaterOnMudPatch1.addIcon(1929);
        this.useWaterOnMudPatch2 = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Use three more buckets of water on the mud patch in Edmond's garden patch.", this.threeBucketsOfWater);
        this.useWaterOnMudPatch2.addIcon(1929);
        this.useWaterOnMudPatch3 = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Use two more buckets of water on the mud patch in Edmond's garden patch.", this.twoBucketsOfWater);
        this.useWaterOnMudPatch3.addIcon(1929);
        this.useWaterOnMudPatch4 = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Use one more bucket of water on the mud patch in Edmond's garden patch.", this.bucketOfWater);
        this.useWaterOnMudPatch4.addIcon(1929);
        this.useWaterOnMudPatch1.addSubSteps(this.useWaterOnMudPatch2, this.useWaterOnMudPatch3, this.useWaterOnMudPatch4);
        this.digHole = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Use a spade on the mud patch.", this.spade);
        this.digHole.addIcon(952);
        this.grabPictureOfElena = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2576, 3334, 0), "Grab the Picture from Edmond's house.", this.pictureOfElena);
        this.goDownHole = new ObjectStep((QuestHelper)this, 2532, new WorldPoint(2566, 3332, 0), "Go down the hole.", new Requirement[0]);
        this.attemptToPullGrill = new ObjectStep((QuestHelper)this, 11422, new WorldPoint(2514, 9739, 0), "Attempt to pull the grill in the south of the sewer.", new Requirement[0]);
        this.climbMudPile = new ObjectStep((QuestHelper)this, 2533, new WorldPoint(2519, 9760, 0), "Climb the mud pile.", new Requirement[0]);
        this.grabPictureOfElena.addSubSteps(this.climbMudPile);
        this.useRopeOnGrill = new ObjectStep((QuestHelper)this, 11422, new WorldPoint(2514, 9739, 0), "Use a rope on the grill.", this.rope);
        this.useRopeOnGrill.addIcon(954);
        this.talkToEdmondUnderground = new NpcStep((QuestHelper)this, 4256, new WorldPoint(2517, 9753, 0), "Talk to Edmond.", new Requirement[0]);
        this.climbThroughPipe = new ObjectStep((QuestHelper)this, 2542, new WorldPoint(2514, 9738, 0), "Equip the gas mask and climb through the pipe.", this.gasMask.highlighted());
        this.talkToJethick = new NpcStep((QuestHelper)this, 8974, new WorldPoint(2540, 3305, 0), "Talk to Jethick east of where you emerge.", this.gasMask, this.pictureOfElena);
        this.talkToJethick.addDialogStep("Yes, I'll return it for you.");
        this.enterMarthasHouse = new ObjectStep((QuestHelper)this, 2537, new WorldPoint(2531, 3328, 0), "Enter the tall house in north West Ardougne.", new Requirement[0]);
        this.talkToMartha = new NpcStep((QuestHelper)this, 4264, new WorldPoint(2531, 3331, 0), "Talk to Martha or Ted Renison", new Requirement[0]);
        this.goUpstairsInMarthasHouse = new ObjectStep((QuestHelper)this, 2539, new WorldPoint(2528, 3333, 0), "Talk to Milli upstairs.", new Requirement[0]);
        this.talkToMilli = new NpcStep((QuestHelper)this, 4266, new WorldPoint(2531, 3331, 1), "Talk to Milli.", new Requirement[0]);
        this.goUpstairsInMarthasHouse.addSubSteps(this.talkToMilli);
        this.tryToEnterPlagueHouse = new ObjectStep((QuestHelper)this, 37321, new WorldPoint(2540, 3273, 0), "Try to enter the house in the south-east corner of West Ardougne.", new Requirement[0]);
        this.tryToEnterPlagueHouse.addDialogStep("I fear not a mere plague.");
        this.tryToEnterPlagueHouse.addDialogStep("I want to check anyway.");
        this.talkToClerk = new NpcStep((QuestHelper)this, 4255, new WorldPoint(2528, 3317, 0), "Talk to the Clerk in the large building north of the manhole.", new Requirement[0]);
        this.talkToClerk.addDialogStep("I need permission to enter a plague house.");
        this.talkToClerk.addDialogStep("This is urgent though! Someone's been kidnapped!");
        this.talkToBravek = new NpcStep((QuestHelper)this, 4252, new WorldPoint(2534, 3314, 0), "Talk to the Bravek in the room to the east.", new Requirement[0]);
        this.talkToBravek.addDialogStep("This is really important though!");
        this.talkToBravek.addDialogStep("Do you know what's in the cure?");
        this.useDustOnMilk = new DetailedQuestStep((QuestHelper)this, "Use your chocolate dust on the bucket of milk.", this.bucketOfMilk, this.chocolateDust);
        this.useSnapeGrassOnChocolateMilk = new DetailedQuestStep((QuestHelper)this, "Use the snape grass on the chocolatey milk", this.bucketOfChocolateMilk, this.snapeGrass);
        this.giveHangoverCureToBravek = new NpcStep((QuestHelper)this, 4252, new WorldPoint(2534, 3314, 0), "Talk to the Bravek again.", this.hangoverCure);
        this.talkToBravekAgain = new NpcStep((QuestHelper)this, 4252, new WorldPoint(2534, 3314, 0), "Talk to the Bravek again.", this.warrant);
        this.talkToBravekAgain.addDialogStep("They won't listen to me!");
        this.giveHangoverCureToBravek.addSubSteps(this.talkToBravekAgain);
        this.tryToEnterPlagueHouseAgain = new ObjectStep((QuestHelper)this, 37321, new WorldPoint(2540, 3273, 0), "Try to enter the plague house again.", this.warrant);
        this.searchBarrel = new ObjectStep((QuestHelper)this, 2530, new WorldPoint(2534, 3268, 0), "Search the barrel in the room for a small key.", new Requirement[0]);
        this.goDownstairsInPlagueHouse = new ObjectStep((QuestHelper)this, 2522, new WorldPoint(2537, 3269, 0), "Go downstairs.", this.key);
        this.goUpstairsInPlagueHouse = new ObjectStep((QuestHelper)this, 2523, new WorldPoint(2537, 9672, 0), "Go back upstairs to get the key for Elena's cell.", new Requirement[0]);
        this.searchBarrel.addSubSteps(this.goUpstairsInPlagueHouse);
        this.talkToElena = new NpcStep((QuestHelper)this, 4257, new WorldPoint(2541, 9671, 0), "Enter the jail and talk to Elena.", this.key);
        this.goUpstairsInPlagueHouseToFinish = new ObjectStep((QuestHelper)this, 2523, new WorldPoint(2537, 9672, 0), "Go back upstairs and return to Edmond to finish the quest.", new Requirement[0]);
        this.goDownManhole = new ObjectStep((QuestHelper)this, 2544, new WorldPoint(2529, 3303, 0), "Go back down the manhole to return to Edmond.", new Requirement[0]);
        this.goDownManhole2 = new ObjectStep((QuestHelper)this, 2543, new WorldPoint(2529, 3303, 0), "Go back down the manhole to return to Edmond.", new Requirement[0]);
        this.climbMudPileToFinish = new ObjectStep((QuestHelper)this, 2533, new WorldPoint(2519, 9760, 0), "Climb the mud pile to return to Edmond.", new Requirement[0]);
        this.talkToEdmondToFinish = new NpcStep((QuestHelper)this, 4256, new WorldPoint(2568, 3333, 0), "Return to Edmond to finish the quest.", new Requirement[0]);
        this.talkToEdmondToFinish.addSubSteps(this.goUpstairsInPlagueHouseToFinish, this.goDownManhole, this.goDownManhole2, this.climbMudPileToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.dwellberries);
        reqs.add(this.spade);
        reqs.add(this.rope);
        reqs.add(this.bucketOfMilk);
        reqs.add(this.chocolateDust);
        reqs.add(this.snapeGrass);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.fourBucketsOfWater);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MINING, 2426));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to use Ardougne teleport spell and tablets"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Collections.singletonList(this.talkToEdmond), this.dwellberries, this.spade, this.rope, this.bucketOfMilk, this.chocolateDust, this.snapeGrass));
        allSteps.add(new PanelDetails("Infiltrate West Ardougne", Arrays.asList(this.talkToAlrena, this.talkToEdmondAgain, this.useWaterOnMudPatch1, this.grabPictureOfElena, this.digHole, this.goDownHole, this.attemptToPullGrill, this.useRopeOnGrill, this.talkToEdmondUnderground, this.climbThroughPipe), new Requirement[0]));
        allSteps.add(new PanelDetails("Discover Elena's location", Arrays.asList(this.talkToJethick, this.enterMarthasHouse, this.talkToMartha, this.goUpstairsInMarthasHouse), new Requirement[0]));
        allSteps.add(new PanelDetails("Freeing Elena", Arrays.asList(this.tryToEnterPlagueHouse, this.talkToClerk, this.talkToBravek, this.useDustOnMilk, this.useSnapeGrassOnChocolateMilk, this.giveHangoverCureToBravek, this.tryToEnterPlagueHouseAgain, this.searchBarrel, this.goDownstairsInPlagueHouse, this.talkToElena), new Requirement[0]));
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.talkToEdmondToFinish), new Requirement[0]));
        return allSteps;
    }
}

