/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.piratestreasure;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class RumSmugglingStep
extends ConditionalStep {
    private Zone karamjaZone1;
    private Zone karamjaZone2;
    private Zone karamjaBoat;
    private ItemRequirement karamjanRum;
    private ItemRequirement tenBananas;
    private ItemRequirement whiteApron;
    private ItemRequirement whiteApronEquipped;
    private ItemRequirement whiteApronHanging;
    private Requirement onKaramja;
    private Conditions atStart;
    private Conditions employed;
    private Conditions stashedRum;
    private Conditions haveShippedRum;
    private Requirement verifiedAState;
    private Requirement hasRumOffKaramja;
    private Conditions hadRumOffKaramja;
    private Conditions lostRum;
    private Conditions filledCrateWithBananasAndRum;
    private ChatMessageRequirement crateSent;
    private ChatMessageRequirement fillCrateWithBananasChat;
    private QuestStep talkToCustomsOfficer;
    private QuestStep getRumFromCrate;
    private QuestStep getWhiteApron;
    private QuestStep addBananasToCrate;
    private QuestStep addRumToCrate;
    private QuestStep talkToZambo;
    private QuestStep talkToLuthas;
    private QuestStep talkToLuthasAgain;
    private QuestStep goToKaramja;
    private QuestStep bringRumToRedbeard;

    public RumSmugglingStep(QuestHelper questHelper) {
        super(questHelper, (QuestStep)new DetailedQuestStep(questHelper, "Please open Pirate Treasure's Quest Journal to sync the current quest state.", new Requirement[0]), new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
    }

    private void addSteps() {
        this.addStep(new Conditions(this.hasRumOffKaramja), this.bringRumToRedbeard);
        this.addStep(new Conditions(this.verifiedAState, this.haveShippedRum, this.onKaramja), this.talkToCustomsOfficer);
        this.addStep(new Conditions(this.verifiedAState, this.haveShippedRum, this.whiteApron), this.getRumFromCrate);
        this.addStep(new Conditions(this.verifiedAState, this.haveShippedRum), this.getWhiteApron);
        this.addStep(new Conditions(this.verifiedAState, this.filledCrateWithBananasAndRum, this.onKaramja), this.talkToLuthasAgain);
        this.addStep(new Conditions(this.verifiedAState, this.stashedRum, this.onKaramja), this.addBananasToCrate);
        this.addStep(new Conditions(this.verifiedAState, this.employed, this.karamjanRum, this.onKaramja), this.addRumToCrate);
        this.addStep(new Conditions(this.verifiedAState, this.employed, this.onKaramja), this.talkToZambo);
        this.addStep(new Conditions(this.verifiedAState, this.atStart, this.karamjanRum, this.onKaramja), this.talkToLuthas);
        this.addStep(new Conditions(this.verifiedAState, this.atStart, this.onKaramja), this.talkToZambo);
        this.addStep(this.verifiedAState, this.goToKaramja);
    }

    @Override
    protected void updateSteps() {
        if (this.hadRumOffKaramja.check(this.client) && !this.hasRumOffKaramja.check(this.client) || this.lostRum.check(this.client)) {
            this.haveShippedRum.setHasPassed(false);
            this.stashedRum.setHasPassed(false);
            this.atStart.setHasPassed(true);
            this.hadRumOffKaramja.setHasPassed(false);
            this.lostRum.setHasPassed(false);
        }
        if (this.crateSent.check(this.client)) {
            this.haveShippedRum.check(this.client);
            this.employed.setHasPassed(false);
            this.fillCrateWithBananasChat.setHasReceivedChatMessage(false);
            this.filledCrateWithBananasAndRum.setHasPassed(false);
            this.crateSent.setHasReceivedChatMessage(false);
        }
        super.updateSteps();
    }

    private void setupZones() {
        this.karamjaZone1 = new Zone(new WorldPoint(2688, 3235, 0), new WorldPoint(2903, 2879, 0));
        this.karamjaZone2 = new Zone(new WorldPoint(2903, 2879, 0), new WorldPoint(2964, 3187, 0));
        this.karamjaBoat = new Zone(new WorldPoint(2964, 3138, 0), new WorldPoint(2951, 3144, 1));
    }

    private void setupItemRequirements() {
        this.karamjanRum = new ItemRequirement("Karamjan rum", 431);
        this.tenBananas = new ItemRequirement("Banana", 1963, 10);
        this.whiteApron = new ItemRequirement("White apron", 1005);
        this.whiteApronEquipped = new ItemRequirement("White apron", 1005, 1, true);
        this.whiteApronHanging = new ItemRequirement("White apron", 7957);
        this.whiteApronHanging.addAlternates(1005);
    }

    private void setupConditions() {
        this.onKaramja = new ZoneRequirement(this.karamjaZone1, this.karamjaZone2, this.karamjaBoat);
        ZoneRequirement offKaramja = new ZoneRequirement(false, this.karamjaZone1, this.karamjaZone2, this.karamjaBoat);
        WidgetTextRequirement inPirateTreasureMenu = new WidgetTextRequirement(0x770002, this.getQuestHelper().getQuest().getName());
        this.hasRumOffKaramja = new Conditions(LogicType.AND, this.karamjanRum, offKaramja);
        this.hadRumOffKaramja = new Conditions(true, this.karamjanRum, offKaramja);
        this.lostRum = new Conditions(LogicType.AND, inPirateTreasureMenu, new WidgetTextRequirement(119, 8, "I seem to have lost it."));
        Conditions haveRumFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 8, "I should take it to"));
        DialogRequirement agreedToGetRum = new DialogRequirement("Ok, I will bring you some rum.");
        Conditions atStartFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 8, "I need to go to"));
        this.atStart = new Conditions(true, LogicType.OR, agreedToGetRum, atStartFromWidget, this.lostRum, this.hadRumOffKaramja, haveRumFromWidget);
        this.crateSent = new ChatMessageRequirement("Luthas hands you 30 coins.");
        Conditions employedFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 8, "I have taken employment"));
        Conditions employedByWydinFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 8, "I have taken a job at"));
        Conditions employedFromDialog = new Conditions(new DialogRequirement("If you could fill it up with bananas, I'll pay you 30 gold.", "Have you completed your task yet?", "you should see the old crate"));
        this.employed = new Conditions(true, LogicType.OR, employedFromDialog, employedFromWidget, employedByWydinFromWidget);
        Conditions stashedRumFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 12, "I have hidden my"));
        Conditions stashedRumFromDialog = new Conditions(new WidgetTextRequirement(229, 1, "You stash the rum in the crate."));
        Conditions stashedRumFromChat = new Conditions(new ChatMessageRequirement("There is also some rum stashed in here too.", "There's already some rum in here...", "There is some rum in here, although with no bananas to cover it. It is a little obvious."));
        this.stashedRum = new Conditions(true, LogicType.OR, stashedRumFromDialog, stashedRumFromWidget, stashedRumFromChat, employedByWydinFromWidget);
        Conditions fillCrateBananas = new Conditions(new WidgetTextRequirement(229, 1, "You fill the crate with bananas."));
        this.fillCrateWithBananasChat = new ChatMessageRequirement("The crate is full of bananas.", "The crate is already full.");
        Conditions filledCrateWithBananas = new Conditions(false, LogicType.OR, this.fillCrateWithBananasChat, fillCrateBananas);
        this.filledCrateWithBananasAndRum = new Conditions(true, LogicType.AND, filledCrateWithBananas, this.stashedRum);
        Conditions shippedRumFromWidget = new Conditions(inPirateTreasureMenu, new WidgetTextRequirement(119, 15, "the crate has been shipped"));
        Conditions shippedRumFromDialog = new Conditions(this.stashedRum, this.crateSent);
        ChatMessageRequirement shippedRumFromChat = new ChatMessageRequirement("There is already some rum in Wydin's store, I should go and get that first.");
        this.haveShippedRum = new Conditions(true, LogicType.OR, shippedRumFromWidget, shippedRumFromDialog, shippedRumFromChat);
        this.verifiedAState = new Conditions(true, LogicType.OR, this.atStart, employedFromWidget, employedByWydinFromWidget, stashedRumFromWidget, shippedRumFromWidget, this.lostRum, this.hadRumOffKaramja, haveRumFromWidget);
    }

    private void setupSteps() {
        this.goToKaramja = new NpcStep(this.getQuestHelper(), 3645, new WorldPoint(3027, 3222, 0), "Talk to one of the Seamen on the docks in Port Sarim to go to Karamja.", new ItemRequirement("Coins", ItemCollections.COINS, 60));
        this.goToKaramja.addDialogStep("Yes please.");
        this.talkToZambo = new NpcStep(this.getQuestHelper(), 3205, new WorldPoint(2929, 3145, 0), "Talk to Zambo in the Karamja Wines, Spirits and Beers bar. Buy one Karamjan rum.", new ItemRequirement("Coins", ItemCollections.COINS, 30));
        this.talkToZambo.addDialogStep("Yes please.");
        this.talkToLuthas = new NpcStep(this.getQuestHelper(), 3647, new WorldPoint(2938, 3154, 0), "Pick 10 bananas nearby, and then talk to Luthas about working for him.", new ItemRequirement("Karamjan rum", 431), new ItemRequirement("Banana", 1963, 10));
        this.talkToLuthas.addDialogStep("Could you offer me employment on your plantation?");
        this.talkToLuthas.addDialogStep("Will you pay me for another crate full?");
        this.addRumToCrate = new ObjectStep(this.getQuestHelper(), 2072, new WorldPoint(2943, 3151, 0), "Put the Karamjan rum into the crate.", this.karamjanRum.highlighted(), this.tenBananas);
        this.addRumToCrate.addIcon(431);
        this.addBananasToCrate = new ObjectStep(this.getQuestHelper(), 2072, new WorldPoint(2943, 3151, 0), "Right-click fill the rest of the crate with bananas, then talk to Luthas.", this.tenBananas);
        this.talkToLuthasAgain = new NpcStep(this.getQuestHelper(), 3647, new WorldPoint(2938, 3154, 0), "Talk to Luthas and tell him you finished filling the crate.", new Requirement[0]);
        this.talkToCustomsOfficer = new NpcStep(this.getQuestHelper(), 3648, new WorldPoint(2955, 3146, 0), "Head back to Port Sarim. Pay the Customs Officer to sail there.", new ItemRequirement("Coins", ItemCollections.COINS, 30));
        this.talkToCustomsOfficer.addDialogStep("Thank you, I'll be on my way");
        this.talkToCustomsOfficer.addDialogStep("Can I journey on this ship?");
        this.talkToCustomsOfficer.addDialogStep("Search away, I have nothing to hide.");
        this.talkToCustomsOfficer.addDialogStep("Ok.");
        this.getWhiteApron = new DetailedQuestStep(this.getQuestHelper(), new WorldPoint(3016, 3229, 0), "Grab the white apron from the Fishing Shop.", this.whiteApronHanging);
        this.getRumFromCrate = new ObjectStep(this.getQuestHelper(), 2071, new WorldPoint(3009, 3207, 0), "Search the crate in the back room of the Port Sarim food shop. Make sure you're wearing your white apron.", this.whiteApronEquipped);
        this.getRumFromCrate.addDialogStep("Well, can I get a job here?");
        this.bringRumToRedbeard = new NpcStep(this.getQuestHelper(), 3643, new WorldPoint(3053, 3251, 0), "Bring the Karamjan rum to Redbeard Frank in Port Sarim.", this.karamjanRum);
    }

    public List<PanelDetails> panelDetails() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Rum smuggling", Arrays.asList(this.goToKaramja, this.talkToZambo, this.talkToLuthas, this.addRumToCrate, this.addBananasToCrate, this.talkToLuthas), new Requirement[0]));
        allSteps.add(new PanelDetails("Back to Port Sarim", Arrays.asList(this.talkToCustomsOfficer, this.getWhiteApron, this.getRumFromCrate, this.bringRumToRedbeard), new Requirement[0]));
        return allSteps;
    }
}

