/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.piratestreasure;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.piratestreasure.RumSmugglingStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.PIRATES_TREASURE)
public class PiratesTreasure
extends BasicQuestHelper {
    ItemRequirement sixtyCoins;
    ItemRequirement spade;
    ItemRequirement pirateMessage;
    ItemRequirement chestKey;
    private NpcStep speakToRedbeard;
    private RumSmugglingStep smuggleRum;
    private QuestStep readPirateMessage;
    private ObjectStep openChest;
    private ObjectStep climbStairs;
    private QuestStep digUpTreasure;
    Zone blueMoonFirst;
    ZoneRequirement inBlueMoonFirst;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.speakToRedbeard = new NpcStep((QuestHelper)this, 3643, new WorldPoint(3053, 3251, 0), "Talk to Redbeard Frank in Port Sarim.", new Requirement[0]);
        this.speakToRedbeard.addDialogStep("I'm in search of treasure.");
        this.speakToRedbeard.addDialogStep("Ok, I will bring you some rum");
        steps.put(0, this.speakToRedbeard);
        this.smuggleRum = new RumSmugglingStep(this);
        steps.put(1, this.smuggleRum);
        this.readPirateMessage = new DetailedQuestStep((QuestHelper)this, "Read the Pirate message.", this.pirateMessage.highlighted());
        this.climbStairs = new ObjectStep((QuestHelper)this, 11796, new WorldPoint(3228, 3393, 0), "Climb up the stairs in The Blue Moon Inn in Varrock.", new Requirement[0]);
        this.openChest = new ObjectStep((QuestHelper)this, 2079, new WorldPoint(3219, 3396, 1), "Open the chest by using the key on it.", this.chestKey.highlighted());
        this.openChest.addDialogStep("Ok thanks, I'll go and get it.");
        this.openChest.addIcon(432);
        this.inBlueMoonFirst = new ZoneRequirement(this.blueMoonFirst);
        this.blueMoonFirst = new Zone(new WorldPoint(3213, 3405, 1), new WorldPoint(3234, 3391, 1));
        ConditionalStep getTreasureMap = new ConditionalStep((QuestHelper)this, (QuestStep)this.climbStairs, new Requirement[0]);
        getTreasureMap.addStep(new Conditions(this.chestKey, this.inBlueMoonFirst), this.openChest);
        getTreasureMap.addStep(this.pirateMessage, this.readPirateMessage);
        steps.put(2, getTreasureMap);
        this.digUpTreasure = new DigStep((QuestHelper)this, new WorldPoint(2999, 3383, 0), "Dig in the middle of the cross in Falador Park, and kill the Gardener (level 4) who appears. Once killed, dig again.", new Requirement[0]);
        steps.put(3, this.digUpTreasure);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.sixtyCoins = new ItemRequirement("Coins", ItemCollections.COINS, 60);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.pirateMessage = new ItemRequirement("Pirate message", 433);
        this.chestKey = new ItemRequirement("Chest key", 432);
        this.chestKey.setTooltip("You can get another one from Redbeard Frank");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.sixtyCoins);
        reqs.add(this.spade);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(new ItemRequirement("A teleport to Varrock", 8007));
        reqs.add(new ItemRequirement("A teleport to Falador", 8009));
        reqs.add(new ItemRequirement("Bananas (obtainable in quest)", 1963, 10));
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Gardener (level 4)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A Gold Ring", 1635, 1), new ItemReward("An Emerald", 1605, 1), new ItemReward("Coins", 995, 450));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to Redbeard Frank", Collections.singletonList(this.speakToRedbeard), this.sixtyCoins));
        allSteps.addAll(this.smuggleRum.panelDetails());
        allSteps.add(new PanelDetails("Discover the treasure", Arrays.asList(this.climbStairs, this.openChest, this.readPirateMessage, this.digUpTreasure), this.spade));
        return allSteps;
    }
}

