/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.olafsquest;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.olafsquest.PaintingWall;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.OLAFS_QUEST)
public class OlafsQuest
extends BasicQuestHelper {
    ItemRequirement axe;
    ItemRequirement tinderbox;
    ItemRequirement spade;
    ItemRequirement dampPlanks;
    ItemRequirement windsweptLogs;
    ItemRequirement crudeCarving;
    ItemRequirement cruderCarving;
    ItemRequirement key;
    ItemRequirement rottenBarrels2;
    ItemRequirement rottenBarrel;
    ItemRequirement ropes6;
    ItemRequirement ropes3;
    ItemRequirement crossKey;
    ItemRequirement squareKey;
    ItemRequirement triangleKey;
    ItemRequirement circleKey;
    ItemRequirement starKey;
    ItemRequirement prayerPotions;
    ItemRequirement food;
    ItemRequirement combatGear;
    Requirement givenIngridCarving;
    Requirement inFirstArea;
    Requirement inSecondArea;
    Requirement inThirdArea;
    Requirement keyNearby;
    Requirement puzzleOpen;
    Requirement has2Barrels6Ropes;
    Requirement hasBarrel3Ropes;
    Requirement placedBarrel1;
    Requirement placedBarrel2;
    Requirement keyInterfaceOpen;
    Requirement ulfricNearby;
    Requirement killedUlfric;
    Requirement tenFreeSlots;
    QuestStep talkToOlaf;
    QuestStep chopTree;
    QuestStep giveLogToOlaf;
    QuestStep talkToIngrid;
    QuestStep talkToVolf;
    QuestStep returnToOlaf;
    QuestStep useDampPlanks;
    QuestStep talkToOlafAfterPlanks;
    QuestStep digHole;
    QuestStep pickUpKey;
    QuestStep searchPainting;
    QuestStep doPuzzle;
    QuestStep pickUpItems;
    QuestStep pickUpItems2;
    QuestStep useBarrel;
    QuestStep useBarrel2;
    QuestStep openGate;
    QuestStep chooseSquare;
    QuestStep chooseCross;
    QuestStep chooseTriangle;
    QuestStep chooseCircle;
    QuestStep chooseStar;
    QuestStep killUlfric;
    NpcStep killSkeleton;
    ObjectStep searchChest;
    ObjectStep searchChestAgain;
    Zone firstArea;
    Zone firstArea2;
    Zone secondArea;
    Zone secondArea2;
    Zone thirdArea;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToOlaf);
        ConditionalStep getLogs = new ConditionalStep((QuestHelper)this, this.chopTree, new Requirement[0]);
        getLogs.addStep(this.windsweptLogs, this.giveLogToOlaf);
        steps.put(10, getLogs);
        ConditionalStep bringCarvings = new ConditionalStep((QuestHelper)this, this.talkToIngrid, new Requirement[0]);
        bringCarvings.addStep(this.givenIngridCarving, this.talkToVolf);
        steps.put(20, bringCarvings);
        steps.put(30, this.returnToOlaf);
        steps.put(40, this.useDampPlanks);
        steps.put(50, this.talkToOlafAfterPlanks);
        ConditionalStep solvePuzzleSteps = new ConditionalStep((QuestHelper)this, this.digHole, new Requirement[0]);
        solvePuzzleSteps.addStep(new Conditions(this.inThirdArea, this.killedUlfric), this.searchChestAgain);
        solvePuzzleSteps.addStep(new Conditions(this.ulfricNearby, this.inThirdArea), this.killUlfric);
        solvePuzzleSteps.addStep(this.inThirdArea, this.searchChest);
        solvePuzzleSteps.addStep(new Conditions(this.starKey, this.keyInterfaceOpen), this.chooseStar);
        solvePuzzleSteps.addStep(new Conditions(this.circleKey, this.keyInterfaceOpen), this.chooseCircle);
        solvePuzzleSteps.addStep(new Conditions(this.triangleKey, this.keyInterfaceOpen), this.chooseTriangle);
        solvePuzzleSteps.addStep(new Conditions(this.squareKey, this.keyInterfaceOpen), this.chooseSquare);
        solvePuzzleSteps.addStep(new Conditions(this.crossKey, this.keyInterfaceOpen), this.chooseCross);
        solvePuzzleSteps.addStep(new Conditions(this.key, this.inSecondArea, this.placedBarrel2), this.openGate);
        solvePuzzleSteps.addStep(new Conditions(this.key, this.placedBarrel1, this.inSecondArea, this.hasBarrel3Ropes), this.useBarrel2);
        solvePuzzleSteps.addStep(new Conditions(this.placedBarrel1, this.inSecondArea, this.key), this.pickUpItems2);
        solvePuzzleSteps.addStep(new Conditions(this.has2Barrels6Ropes, this.inSecondArea, this.key), this.useBarrel);
        solvePuzzleSteps.addStep(new Conditions(this.inSecondArea, this.key), this.pickUpItems);
        solvePuzzleSteps.addStep(this.puzzleOpen, this.doPuzzle);
        solvePuzzleSteps.addStep(LogicHelper.and(this.inFirstArea, this.key), this.searchPainting);
        solvePuzzleSteps.addStep(LogicHelper.and(this.inFirstArea, this.keyNearby), this.pickUpKey);
        solvePuzzleSteps.addStep(new Conditions(this.inFirstArea), this.killSkeleton);
        steps.put(60, solvePuzzleSteps);
        steps.put(70, solvePuzzleSteps);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.food.setUrlSuffix("Food");
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.dampPlanks = new ItemRequirement("Damp planks", 11031);
        this.windsweptLogs = new ItemRequirement("Windswept logs", 11035);
        this.crudeCarving = new ItemRequirement("Crude carving", 11032);
        this.crudeCarving.setTooltip("You can get another from Olaf");
        this.cruderCarving = new ItemRequirement("Cruder carving", 11033);
        this.cruderCarving.setTooltip("You can get another from Olaf");
        this.key = new ItemRequirement("Key", 11039);
        this.key.addAlternates(11040, 11041, 11042, 11043);
        this.crossKey = new ItemRequirement("Key", 11039);
        this.squareKey = new ItemRequirement("Key", 11040);
        this.triangleKey = new ItemRequirement("Key", 11041);
        this.circleKey = new ItemRequirement("Key", 11042);
        this.starKey = new ItemRequirement("Key", 11043);
        this.tenFreeSlots = new FreeInventorySlotRequirement(10);
        this.tenFreeSlots.setTooltip("Only need 4 slots free if bringing 6 rope with you.");
        this.rottenBarrel = new ItemRequirement("Rotten barrel", 11044);
        this.rottenBarrel.addAlternates(11045);
        this.rottenBarrels2 = new ItemRequirement("Rotten barrel", 11044, 2);
        this.rottenBarrels2.addAlternates(11045);
        this.ropes3 = new ItemRequirement("Rope", 954, 3);
        this.ropes3.addAlternates(11046);
        this.ropes6 = new ItemRequirement("Rope", 954, 6);
        this.ropes6.addAlternates(11046);
    }

    public void setupConditions() {
        this.givenIngridCarving = new VarbitRequirement(3536, 1, Operation.GREATER_EQUAL);
        this.inFirstArea = new ZoneRequirement(this.firstArea, this.firstArea2);
        this.inSecondArea = new ZoneRequirement(this.secondArea, this.secondArea2);
        this.inThirdArea = new ZoneRequirement(this.thirdArea);
        this.keyNearby = new ItemOnTileRequirement(this.key);
        this.puzzleOpen = new WidgetModelRequirement(253, 0, 24126);
        this.hasBarrel3Ropes = new Conditions(this.rottenBarrel, this.ropes3);
        this.has2Barrels6Ropes = new Conditions(this.rottenBarrels2, this.ropes6);
        this.placedBarrel1 = new VarbitRequirement(3547, 1);
        this.placedBarrel2 = new VarbitRequirement(3548, 1);
        this.keyInterfaceOpen = new WidgetModelRequirement(252, 0, 24124);
        this.ulfricNearby = new NpcCondition(4500);
        this.killedUlfric = new VarbitRequirement(3539, 1);
    }

    public void loadZones() {
        this.firstArea = new Zone(new WorldPoint(2689, 10116, 0), new WorldPoint(2707, 10141, 0));
        this.firstArea2 = new Zone(new WorldPoint(2707, 10118, 0), new WorldPoint(2739, 10148, 0));
        this.secondArea = new Zone(new WorldPoint(2691, 10143, 0), new WorldPoint(2706, 10170, 0));
        this.secondArea2 = new Zone(new WorldPoint(2707, 10149, 0), new WorldPoint(2735, 10170, 0));
        this.thirdArea = new Zone(new WorldPoint(2726, 10154, 0), new WorldPoint(2749, 10170, 0));
    }

    public void setupSteps() {
        this.talkToOlaf = new NpcStep((QuestHelper)this, 4488, new WorldPoint(2722, 3727, 0), "Talk to Olaf Hradson north east of Rellekka.", new Requirement[0]);
        this.talkToOlaf.addDialogStep("Yes.");
        this.chopTree = new ObjectStep((QuestHelper)this, 18137, new WorldPoint(2749, 3735, 0), "Chop a log from the Windswept Tree east of Olaf.", this.axe);
        this.giveLogToOlaf = new NpcStep((QuestHelper)this, 4488, new WorldPoint(2722, 3727, 0), "Bring the logs to Olaf Hradson north east of Rellekka.", this.windsweptLogs);
        this.talkToIngrid = new NpcStep((QuestHelper)this, 4490, new WorldPoint(2670, 3670, 0), "Talk to Ingrid Hradson in Rellekka.", this.crudeCarving);
        this.talkToVolf = new NpcStep((QuestHelper)this, 4489, new WorldPoint(2662, 3700, 0), "Talk to Volf Hradson in Rellekka.", this.cruderCarving);
        this.returnToOlaf = new NpcStep((QuestHelper)this, 4488, new WorldPoint(2722, 3727, 0), "Return to Olaf Hradson north east of Rellekka.", new Requirement[0]);
        this.useDampPlanks = new ObjectStep((QuestHelper)this, 14172, new WorldPoint(2724, 3728, 0), "Use the damp planks on Olaf's embers.", this.dampPlanks);
        this.talkToOlafAfterPlanks = new NpcStep((QuestHelper)this, 4488, new WorldPoint(2722, 3727, 0), "Talk to Olaf again, and give him some food.", this.food);
        this.talkToOlafAfterPlanks.addDialogStep("Alright, here, have some food. Now give me the map.");
        this.digHole = new DigStep((QuestHelper)this, new WorldPoint(2748, 3732, 0), "Dig next to the Windswept Tree.", new Requirement[0]);
        this.pickUpKey = new ItemStep((QuestHelper)this, "Pick up the dropped key.", this.key);
        this.killSkeleton = new NpcStep((QuestHelper)this, 4491, new WorldPoint(2727, 10141, 0), "Go deeper into the caverns and kill a Skeleton Fremennik for a key.", true, new Requirement[0]);
        this.killSkeleton.addAlternateNpcs(4492, 4493, 4494, 4495, 4496, 4497, 4498, 4499);
        this.killSkeleton.addSubSteps(this.pickUpKey);
        this.searchPainting = new ObjectStep((QuestHelper)this, 23156, new WorldPoint(2707, 10147, 0), "Search the picture wall in the north room.", new Requirement[0]);
        this.doPuzzle = new PaintingWall(this);
        this.pickUpItems = new DetailedQuestStep((QuestHelper)this, "Pick up 2 rotten barrels and 6 ropes from around the room.", this.rottenBarrels2, this.ropes6);
        this.pickUpItems2 = new DetailedQuestStep((QuestHelper)this, "Pick up 1 rotten barrels and 3 ropes from around the room.", this.rottenBarrel, this.ropes3);
        this.pickUpItems.addSubSteps(this.pickUpItems2);
        this.useBarrel = new ObjectStep((QuestHelper)this, 23213, new WorldPoint(2722, 10168, 0), "WALK onto the walkway to the east, and use a barrel on it to repair it.", this.rottenBarrel.highlighted(), this.ropes3);
        this.useBarrel.addIcon(11045);
        this.useBarrel2 = new ObjectStep((QuestHelper)this, 23214, new WorldPoint(2724, 10168, 0), "WALK on the walkway and repair the next hole in it.", this.rottenBarrel.highlighted(), this.ropes3);
        this.useBarrel2.addIcon(11045);
        this.openGate = new ObjectStep((QuestHelper)this, 23216, new WorldPoint(2725, 10168, 0), "Open the gate on the walkway, clicking the key hole which matches your key.", this.key);
        this.chooseSquare = new WidgetStep((QuestHelper)this, "Click the square key hole.", 252, 3);
        this.chooseCross = new WidgetStep((QuestHelper)this, "Click the cross key hole.", 252, 4);
        this.chooseTriangle = new WidgetStep((QuestHelper)this, "Click the triangle key hole.", 252, 5);
        this.chooseCircle = new WidgetStep((QuestHelper)this, "Click the circle key hole.", 252, 6);
        this.chooseStar = new WidgetStep((QuestHelper)this, "Click the star key hole.", 252, 7);
        this.openGate.addSubSteps(this.chooseCircle, this.chooseCross, this.chooseSquare, this.chooseStar, this.chooseTriangle);
        this.searchChest = new ObjectStep((QuestHelper)this, 14197, new WorldPoint(2740, 10164, 0), "WALK off the remaining walkway, and search the chest in the wreck. Be prepared to fight Ulfric.", new Requirement[0]);
        this.searchChest.addAlternateObjects(14196);
        this.killUlfric = new NpcStep((QuestHelper)this, 4500, new WorldPoint(2740, 10164, 0), "Kill Ulfric.", new Requirement[0]);
        this.searchChestAgain = new ObjectStep((QuestHelper)this, 14197, new WorldPoint(2740, 10164, 0), "Search the chest again to finish the quest.", new Requirement[0]);
        this.searchChestAgain.addAlternateObjects(14196);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.axe, this.tinderbox, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.prayerPotions);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Skeleton fremennik (level 40)", "Ulfric (level 100)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.FIREMAKING, 40, true));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 50, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.DEFENCE, 12000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Rubies", 1603, 4));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Brine Rats and the ability to receive them as a slayer task."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToOlaf, this.chopTree, this.giveLogToOlaf, this.talkToIngrid, this.talkToVolf, this.returnToOlaf, this.useDampPlanks, this.talkToOlafAfterPlanks), this.axe, this.tinderbox, this.spade));
        allSteps.add(new PanelDetails("Finding treasure", Arrays.asList(this.digHole, this.killSkeleton, this.searchPainting, this.doPuzzle, this.pickUpItems, this.useBarrel, this.useBarrel2, this.openGate, this.searchChest, this.killUlfric, this.searchChestAgain), this.spade, this.tenFreeSlots, this.combatGear));
        return allSteps;
    }
}

