/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.observatoryquest;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.observatoryquest.StarSignAnswer;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.OBSERVATORY_QUEST)
public class ObservatoryQuest
extends BasicQuestHelper {
    ItemRequirement plank;
    ItemRequirement bronzeBar;
    ItemRequirement moltenGlass;
    ItemRequirement food;
    ItemRequirement duelingRing;
    ItemRequirement antipoison;
    ItemRequirement mould;
    ItemRequirement lens;
    ItemRequirement key;
    Requirement inObservatoryDungeon;
    Requirement inObservatoryF1;
    Requirement inObservatoryF2;
    Requirement usedKey;
    Requirement sleepingGuardNearby;
    Requirement hasMould;
    Requirement lookedThroughTelescope;
    DetailedQuestStep talkToProfessor;
    DetailedQuestStep giveProfessorPlanks;
    DetailedQuestStep giveProfessorBar;
    DetailedQuestStep giveProfessorGlass;
    DetailedQuestStep talkToAssistant;
    DetailedQuestStep enterDungeon;
    DetailedQuestStep searchChests;
    DetailedQuestStep prodGuard;
    DetailedQuestStep inspectStove;
    DetailedQuestStep leaveDungeon;
    DetailedQuestStep giveProfessorMould;
    DetailedQuestStep useGlassOnMould;
    DetailedQuestStep giveProfessorLensAndMould;
    DetailedQuestStep enterDungeonAgain;
    DetailedQuestStep enterObservatory;
    DetailedQuestStep goToF2Observatory;
    DetailedQuestStep viewTelescope;
    DetailedQuestStep tellProfessorConstellation;
    Zone observatoryDungeon;
    Zone observatoryF1;
    Zone observatoryF2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToProfessor);
        steps.put(1, this.giveProfessorPlanks);
        steps.put(2, this.giveProfessorBar);
        steps.put(3, this.giveProfessorGlass);
        ConditionalStep goGetLens = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDungeon, new Requirement[0]);
        goGetLens.addStep(new Conditions(this.inObservatoryDungeon, this.hasMould), this.leaveDungeon);
        goGetLens.addStep(this.hasMould, this.giveProfessorMould);
        goGetLens.addStep(new Conditions(this.inObservatoryDungeon, new Conditions(LogicType.OR, this.key.alsoCheckBank(this.questBank), this.usedKey), this.sleepingGuardNearby), this.prodGuard);
        goGetLens.addStep(new Conditions(this.inObservatoryDungeon, new Conditions(LogicType.OR, this.key.alsoCheckBank(this.questBank), this.usedKey)), this.inspectStove);
        goGetLens.addStep(this.inObservatoryDungeon, this.searchChests);
        steps.put(4, goGetLens);
        ConditionalStep makeLens = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDungeon, new Requirement[0]);
        makeLens.addStep(this.lens, this.giveProfessorLensAndMould);
        makeLens.addStep(new Conditions(this.inObservatoryDungeon, this.hasMould), this.leaveDungeon);
        makeLens.addStep(this.hasMould, this.useGlassOnMould);
        makeLens.addStep(new Conditions(this.inObservatoryDungeon, this.usedKey, this.sleepingGuardNearby), this.prodGuard);
        makeLens.addStep(new Conditions(this.inObservatoryDungeon, this.usedKey), this.inspectStove);
        steps.put(5, makeLens);
        ConditionalStep goLookInTelescope = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDungeonAgain, new Requirement[0]);
        goLookInTelescope.addStep(new Conditions(this.lookedThroughTelescope, this.inObservatoryF2), this.tellProfessorConstellation);
        goLookInTelescope.addStep(this.inObservatoryF2, this.viewTelescope);
        goLookInTelescope.addStep(this.inObservatoryF1, this.goToF2Observatory);
        goLookInTelescope.addStep(this.inObservatoryDungeon, this.enterObservatory);
        steps.put(6, goLookInTelescope);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.plank = new ItemRequirement("Plank", 960);
        this.bronzeBar = new ItemRequirement("Bronze bar", 2349);
        this.moltenGlass = new ItemRequirement("Molten glass", 1775);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.duelingRing = new ItemRequirement("Ring of dueling", ItemCollections.RING_OF_DUELINGS);
        this.antipoison = new ItemRequirement("Antipoison (there is a spawn near the Observatory of superantipoison)", ItemCollections.ANTIPOISONS);
        this.mould = new ItemRequirement("Lens mould", 602).isNotConsumed();
        this.lens = new ItemRequirement("Observatory lens", 603).isNotConsumed();
        this.key = new ItemRequirement("Goblin kitchen key", 601).isNotConsumed();
    }

    public void setupConditions() {
        this.inObservatoryDungeon = new ZoneRequirement(this.observatoryDungeon);
        this.inObservatoryF1 = new ZoneRequirement(this.observatoryF1);
        this.inObservatoryF2 = new ZoneRequirement(this.observatoryF2);
        this.usedKey = new VarbitRequirement(3826, 1);
        this.sleepingGuardNearby = new NpcCondition(5368);
        this.hasMould = new VarbitRequirement(3837, 1);
        this.lookedThroughTelescope = new VarbitRequirement(3836, 1);
    }

    public void loadZones() {
        this.observatoryDungeon = new Zone(new WorldPoint(2295, 9340, 0), new WorldPoint(2370, 9410, 0));
        this.observatoryF1 = new Zone(new WorldPoint(2433, 3154, 0), new WorldPoint(2448, 3169, 0));
        this.observatoryF2 = new Zone(new WorldPoint(2433, 3154, 1), new WorldPoint(2448, 3169, 1));
    }

    public void setupSteps() {
        this.talkToProfessor = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Talk to the Observatory professor north of Castle Wars.", this.plank.quantity(3), this.moltenGlass, this.bronzeBar);
        this.talkToProfessor.addDialogSteps("Talk about the Observatory quest.", "An Observatory?", "Yes.");
        this.giveProfessorPlanks = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Give the professor 3 planks.", this.plank.quantity(3));
        this.giveProfessorPlanks.addDialogSteps("Talk about the Observatory quest.");
        this.giveProfessorBar = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Give the professor a bronze bar.", this.bronzeBar);
        this.giveProfessorBar.addDialogSteps("Talk about the Observatory quest.");
        this.giveProfessorGlass = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Give the professor some molten glass.", this.moltenGlass);
        this.giveProfessorGlass.addDialogSteps("Talk about the Observatory quest.");
        this.talkToAssistant = new NpcStep((QuestHelper)this, 5365, new WorldPoint(2443, 3189, 0), "Talk to the observatory assistant.", new Requirement[0]);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 25432, new WorldPoint(2458, 3186, 0), "Enter the dungeon east of the Professor.", new Requirement[0]);
        this.searchChests = new ObjectStep((QuestHelper)this, 25385, "Search only the marked chests in the dungeon. Unmarked chests contain monsters and may poison you.", new Requirement[0]);
        ((ObjectStep)this.searchChests).addAlternateObjects(25386, 25387, 25388, 25389, 25390);
        this.prodGuard = new NpcStep((QuestHelper)this, 5368, new WorldPoint(2327, 9394, 0), "Prod the sleeping guard in the north of the dungeon. He'll attack you. You need to then either kill him, or get him in the marked spot to the north of the gate.", new Requirement[0]);
        this.prodGuard.addTileMarker(new WorldPoint(2327, 9399, 0), 771);
        this.inspectStove = new ObjectStep((QuestHelper)this, 25442, new WorldPoint(2327, 9389, 0), "Either kill or trap the guard on the marked tile to the north, then search the goblin stove.", new Requirement[0]);
        this.inspectStove.addTileMarker(new WorldPoint(2327, 9399, 0), 771);
        this.leaveDungeon = new ObjectStep((QuestHelper)this, 25429, new WorldPoint(2355, 9396, 0), "Climb the stairs back to the surface.", new Requirement[0]);
        this.giveProfessorMould = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Give the professor the lens mould. If you don't have it, check your bank.", this.mould);
        this.giveProfessorMould.addDialogSteps("Talk about the Observatory quest.");
        this.useGlassOnMould = new DetailedQuestStep((QuestHelper)this, "Use the molten glass on the mould.", this.moltenGlass.highlighted(), this.mould.highlighted());
        this.giveProfessorLensAndMould = new NpcStep((QuestHelper)this, 5366, new WorldPoint(2442, 3186, 0), "Give the professor the lens mould and lens.", this.lens);
        this.giveProfessorLensAndMould.addDialogSteps("Talk about the Observatory quest.");
        this.enterDungeonAgain = new ObjectStep((QuestHelper)this, 25432, new WorldPoint(2458, 3186, 0), "Enter the dungeon east of the Professor.", new Requirement[0]);
        this.enterObservatory = new ObjectStep((QuestHelper)this, 25429, new WorldPoint(2335, 9352, 0), "Follow the dungeon around anti-clockwise to a staircase, then climb it.", new Requirement[0]);
        this.goToF2Observatory = new ObjectStep((QuestHelper)this, 25431, new WorldPoint(2444, 3160, 0), "Climb up the stairs in the observatory.", new Requirement[0]);
        this.viewTelescope = new ObjectStep((QuestHelper)this, 25591, new WorldPoint(2441, 3162, 1), "Use the telescope.", new Requirement[0]);
        this.tellProfessorConstellation = new StarSignAnswer(this);
        this.tellProfessorConstellation.addDialogSteps("Talk about the Observatory quest.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.plank.quantity(3), this.bronzeBar, this.moltenGlass);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.duelingRing, this.antipoison, this.food);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Goblin Guard (level 42, or you can lure it/have someone else kill it)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 2250));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("A reward depending on which constellation you observed."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping the Professor", Arrays.asList(this.talkToProfessor, this.giveProfessorPlanks, this.giveProfessorBar, this.giveProfessorGlass, this.enterDungeon, this.searchChests, this.prodGuard, this.inspectStove, this.leaveDungeon, this.giveProfessorMould, this.useGlassOnMould, this.giveProfessorLensAndMould, this.enterDungeonAgain, this.enterObservatory, this.goToF2Observatory, this.viewTelescope, this.tellProfessorConstellation), this.plank.quantity(3), this.bronzeBar, this.moltenGlass));
        return allSteps;
    }
}

