/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.naturespirit;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.NATURE_SPIRIT)
public class NatureSpirit
extends BasicQuestHelper {
    ItemRequirement ghostspeak;
    ItemRequirement silverSickle;
    ItemRequirement washingBowl;
    ItemRequirement mirror;
    ItemRequirement journal;
    ItemRequirement druidicSpell;
    ItemRequirement druidPouch;
    ItemRequirement blessedSickle;
    ItemRequirement spellCard;
    ItemRequirement mirrorHighlighted;
    ItemRequirement journalHighlighted;
    ItemRequirement mushroom;
    ItemRequirement mushroomHighlighted;
    ItemRequirement druidPouchFull;
    ItemRequirement combatGear;
    ItemRequirement salveTele;
    Requirement inUnderground;
    Requirement fillimanNearby;
    Requirement mirrorNearby;
    Requirement usedMushroom;
    Requirement onOrange;
    Requirement usedCard;
    Requirement inGrotto;
    Requirement natureSpiritNearby;
    Requirement ghastNearby;
    QuestStep goDownToDrezel;
    QuestStep talkToDrezel;
    QuestStep leaveDrezel;
    QuestStep enterSwamp;
    QuestStep tryToEnterGrotto;
    QuestStep talkToFilliman;
    QuestStep takeWashingBowl;
    QuestStep takeMirror;
    QuestStep useMirrorOnFilliman;
    QuestStep searchGrotto;
    QuestStep useJournalOnFilliman;
    QuestStep goBackDownToDrezel;
    QuestStep talkToDrezelForBlessing;
    QuestStep castSpellAndGetMushroom;
    QuestStep useMushroom;
    QuestStep useSpellCard;
    QuestStep standOnOrange;
    QuestStep tellFillimanToCast;
    QuestStep enterGrotto;
    QuestStep searchAltar;
    QuestStep blessSickle;
    QuestStep fillPouches;
    QuestStep killGhasts;
    QuestStep killGhast;
    QuestStep enterGrottoAgain;
    QuestStep touchAltarAgain;
    QuestStep talkToNatureSpiritToFinish;
    QuestStep spawnFillimanForRitual;
    QuestStep talkToFillimanInGrotto;
    Zone underground;
    Zone orangeStone;
    Zone grotto;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.goDownToDrezel, new Requirement[0]);
        startQuest.addStep(this.inUnderground, this.talkToDrezel);
        steps.put(0, startQuest);
        ConditionalStep goEnterSwamp = new ConditionalStep((QuestHelper)this, this.enterSwamp, new Requirement[0]);
        goEnterSwamp.addStep(this.inUnderground, this.leaveDrezel);
        steps.put(1, goEnterSwamp);
        steps.put(2, goEnterSwamp);
        steps.put(3, goEnterSwamp);
        steps.put(4, goEnterSwamp);
        steps.put(5, goEnterSwamp);
        ConditionalStep goTalkToFilliman = new ConditionalStep((QuestHelper)this, this.tryToEnterGrotto, new Requirement[0]);
        goTalkToFilliman.addStep(this.fillimanNearby, this.talkToFilliman);
        steps.put(10, goTalkToFilliman);
        steps.put(15, goTalkToFilliman);
        ConditionalStep showFillimanReflection = new ConditionalStep((QuestHelper)this, this.takeWashingBowl, new Requirement[0]);
        showFillimanReflection.addStep(new Conditions(this.mirror, this.fillimanNearby), this.useMirrorOnFilliman);
        showFillimanReflection.addStep(this.mirror, this.tryToEnterGrotto);
        showFillimanReflection.addStep(this.mirrorNearby, this.takeMirror);
        steps.put(20, showFillimanReflection);
        ConditionalStep goGetJournal = new ConditionalStep((QuestHelper)this, this.searchGrotto, new Requirement[0]);
        goGetJournal.addStep(new Conditions(this.journal, this.fillimanNearby), this.useJournalOnFilliman);
        goGetJournal.addStep(this.journal, this.tryToEnterGrotto);
        steps.put(25, goGetJournal);
        ConditionalStep goOfferHelp = new ConditionalStep((QuestHelper)this, this.tryToEnterGrotto, new Requirement[0]);
        goOfferHelp.addStep(this.fillimanNearby, this.useJournalOnFilliman);
        steps.put(30, goOfferHelp);
        ConditionalStep getBlessed = new ConditionalStep((QuestHelper)this, this.goBackDownToDrezel, new Requirement[0]);
        getBlessed.addStep(this.inUnderground, this.talkToDrezelForBlessing);
        steps.put(35, getBlessed);
        ConditionalStep performRitual = new ConditionalStep((QuestHelper)this, this.castSpellAndGetMushroom, new Requirement[0]);
        performRitual.addStep(new Conditions(this.usedMushroom, this.usedCard, this.fillimanNearby, this.onOrange), this.tellFillimanToCast);
        performRitual.addStep(new Conditions(this.usedMushroom, this.usedCard, this.fillimanNearby), this.standOnOrange);
        performRitual.addStep(new Conditions(this.usedMushroom, this.usedCard), this.spawnFillimanForRitual);
        performRitual.addStep(this.usedMushroom, this.useSpellCard);
        performRitual.addStep(this.mushroom, this.useMushroom);
        steps.put(40, performRitual);
        steps.put(45, performRitual);
        steps.put(50, performRitual);
        steps.put(55, performRitual);
        ConditionalStep goTalkInGrotto = new ConditionalStep((QuestHelper)this, this.enterGrotto, new Requirement[0]);
        goTalkInGrotto.addStep(new Conditions(this.inGrotto, this.fillimanNearby), this.talkToFillimanInGrotto);
        goTalkInGrotto.addStep(this.inGrotto, this.searchAltar);
        steps.put(60, goTalkInGrotto);
        ConditionalStep goBlessSickle = new ConditionalStep((QuestHelper)this, this.enterGrotto, new Requirement[0]);
        goBlessSickle.addStep(new Conditions(this.inGrotto, this.natureSpiritNearby), this.blessSickle);
        goBlessSickle.addStep(this.inGrotto, this.searchAltar);
        steps.put(65, goBlessSickle);
        steps.put(70, goBlessSickle);
        ConditionalStep goKillGhasts = new ConditionalStep((QuestHelper)this, this.fillPouches, new Requirement[0]);
        goKillGhasts.addStep(this.ghastNearby, this.killGhast);
        goKillGhasts.addStep(this.druidPouchFull, this.killGhasts);
        steps.put(75, goKillGhasts);
        steps.put(80, goKillGhasts);
        steps.put(85, goKillGhasts);
        steps.put(90, goKillGhasts);
        steps.put(95, goKillGhasts);
        steps.put(100, goKillGhasts);
        ConditionalStep finishOff = new ConditionalStep((QuestHelper)this, this.enterGrottoAgain, new Requirement[0]);
        finishOff.addStep(new Conditions(this.inGrotto, this.natureSpiritNearby), this.talkToNatureSpiritToFinish);
        finishOff.addStep(this.inGrotto, this.touchAltarAgain);
        steps.put(105, finishOff);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", 552, 1, true).isNotConsumed();
        this.silverSickle = new ItemRequirement("Silver sickle", 2961);
        this.washingBowl = new ItemRequirement("Washing bowl", 2964);
        this.mirror = new ItemRequirement("Mirror", 2966);
        this.mirrorHighlighted = new ItemRequirement("Mirror", 2966);
        this.mirrorHighlighted.setHighlightInInventory(true);
        this.journal = new ItemRequirement("Journal", 2967);
        this.journalHighlighted = new ItemRequirement("Journal", 2967);
        this.journalHighlighted.setHighlightInInventory(true);
        this.druidicSpell = new ItemRequirement("Druidic spell", 2968);
        this.druidicSpell.setTooltip("You can get another from Filliman");
        this.druidPouch = new ItemRequirement("Druidic pouch", 2957);
        this.druidPouch.setTooltip("You can get another from the Grotto");
        this.druidPouchFull = new ItemRequirement("Druidic pouch", 2958);
        this.blessedSickle = new ItemRequirement("Silver sickle (b)", 2963);
        this.blessedSickle.setTooltip("You can bless another silver sickle with the nature spirit");
        this.spellCard = new ItemRequirement("A used spell or druidic spell", 2969);
        this.spellCard.addAlternates(2968);
        this.spellCard.setTooltip("You can get another spell from Filliman");
        this.mushroom = new ItemRequirement("Mort myre fungus", 2970);
        this.mushroomHighlighted = new ItemRequirement("Mort myre fungus", 2970);
        this.mushroomHighlighted.setHighlightInInventory(true);
        this.salveTele = new ItemRequirement("Salve Graveyard Teleports", 19619, 2);
        this.combatGear = new ItemRequirement("Combat gear to kill the ghasts", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.underground = new Zone(new WorldPoint(3402, 9880, 0), new WorldPoint(3443, 9907, 0));
        this.orangeStone = new Zone(new WorldPoint(3440, 3335, 0), new WorldPoint(3440, 3335, 0));
        this.grotto = new Zone(new WorldPoint(3435, 9733, 0), new WorldPoint(3448, 9746, 0));
    }

    public void setupConditions() {
        this.inUnderground = new ZoneRequirement(this.underground);
        this.onOrange = new ZoneRequirement(this.orangeStone);
        this.inGrotto = new ZoneRequirement(this.grotto);
        this.fillimanNearby = new NpcCondition(943);
        this.natureSpiritNearby = new NpcCondition(944);
        this.mirrorNearby = new ItemOnTileRequirement(this.mirror);
        this.usedMushroom = new Conditions(true, LogicType.OR, new ChatMessageRequirement("The stone seems to absorb the fungus."), new WidgetTextRequirement(229, 1, "nature symbol<br>scratched into it. This stone seems complete in some way."), new WidgetTextRequirement(119, 3, true, "Mort Myre Fungi was absorbed"));
        this.usedCard = new Conditions(true, LogicType.OR, new ChatMessageRequirement("The stone seems to absorb the used spell scroll."), new ChatMessageRequirement("The stone seems to absorb the spell scroll."), new WidgetTextRequirement(229, 1, "spirit symbol<br>scratched into it. This stone seems to be complete"), new WidgetTextRequirement(119, 3, true, "spell scroll was absorbed"));
        this.ghastNearby = new NpcCondition(946);
    }

    public void setupSteps() {
        this.goDownToDrezel = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3405, 3507, 0), "Talk to Drezel under the Paterdomus Temple.", new Requirement[0]);
        this.goDownToDrezel.addDialogSteps("Well, what is it, I may be able to help?", "Yes.");
        ((ObjectStep)this.goDownToDrezel).addAlternateObjects(1581);
        this.talkToDrezel = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3439, 9896, 0), "Talk to Drezel under the Paterdomus Temple.", new Requirement[0]);
        this.talkToDrezel.addSubSteps(this.goDownToDrezel);
        this.leaveDrezel = new ObjectStep((QuestHelper)this, 3443, new WorldPoint(3440, 9886, 0), "Enter the Mort Myre from the north gate.", new Requirement[0]);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 3506, new WorldPoint(3444, 3458, 0), "Enter the Mort Myre from the north gate.", this.ghostspeak);
        this.tryToEnterGrotto = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Attempt to enter the Grotto in the south of Mort Myre.", this.ghostspeak);
        this.tryToEnterGrotto.addDialogStep("How long have you been a ghost?");
        this.talkToFilliman = new NpcStep((QuestHelper)this, 943, new WorldPoint(3440, 3336, 0), "Talk to Filliman Tarlock.", this.ghostspeak);
        this.talkToFilliman.addDialogStep("How long have you been a ghost?");
        this.takeWashingBowl = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3437, 3337, 0), "Pick up the washing bowl.", this.washingBowl);
        this.takeMirror = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3437, 3337, 0), "Pick up the mirror.", this.mirror);
        this.useMirrorOnFilliman = new NpcStep((QuestHelper)this, 943, new WorldPoint(3440, 3336, 0), "Use the mirror on Filliman Tarlock.", this.ghostspeak, this.mirrorHighlighted);
        this.useMirrorOnFilliman.addDialogStep("How long have you been a ghost?");
        this.useMirrorOnFilliman.addIcon(2966);
        this.searchGrotto = new ObjectStep((QuestHelper)this, 3517, new WorldPoint(3440, 3339, 0), "Right-click search the grotto tree.", new Requirement[0]);
        this.useJournalOnFilliman = new NpcStep((QuestHelper)this, 943, new WorldPoint(3440, 3336, 0), "Use the journal on Filliman Tarlock.", this.ghostspeak, this.journalHighlighted);
        this.useJournalOnFilliman.addIcon(2967);
        this.useJournalOnFilliman.addDialogStep("How can I help?");
        this.goBackDownToDrezel = new ObjectStep((QuestHelper)this, 3432, new WorldPoint(3422, 3485, 0), "Talk to Drezel to get blessed.", new Requirement[0]);
        ((ObjectStep)this.goBackDownToDrezel).addAlternateObjects(3433);
        this.talkToDrezelForBlessing = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3439, 9896, 0), "Talk to Drezel under the Paterdomus Temple.", new Requirement[0]);
        this.talkToDrezelForBlessing.addSubSteps(this.goBackDownToDrezel);
        this.talkToDrezelForBlessing.addSubSteps(this.goBackDownToDrezel);
        this.castSpellAndGetMushroom = new DetailedQuestStep((QuestHelper)this, "Cast the druidic spell next to a rotten log in Mort Myre to grow a mushroom. Pick it. If you already have, open the quest journal to re-sync your state.", this.druidicSpell);
        this.useMushroom = new ObjectStep((QuestHelper)this, 3527, new WorldPoint(3439, 3336, 0), "Use the mushroom on the brown stone outside the grotto. If you already have, search it instead.", this.mushroomHighlighted);
        this.useMushroom.addIcon(2970);
        this.useSpellCard = new ObjectStep((QuestHelper)this, 3529, new WorldPoint(3441, 3336, 0), "Use the used spell on the gray stone outside the grotto. If you already have, search it instead.", this.spellCard);
        this.useSpellCard.addIcon(2969);
        this.standOnOrange = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3440, 3335, 0), "Stand on the orange stone outside the grotto.", new Requirement[0]);
        this.tellFillimanToCast = new NpcStep((QuestHelper)this, 943, new WorldPoint(3440, 3336, 0), "Tell Filliman Tarlock you're ready.", this.ghostspeak);
        this.tellFillimanToCast.addDialogStep("I think I've solved the puzzle!");
        this.spawnFillimanForRitual = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Attempt to enter the Grotto in the south of Mort Myre to spawn Filliman.", this.ghostspeak);
        this.spawnFillimanForRitual.addDialogStep("I think I've solved the puzzle!");
        this.tellFillimanToCast.addSubSteps(this.spawnFillimanForRitual);
        this.enterGrotto = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Enter the Grotto in the south of Mort Myre.", this.ghostspeak, this.silverSickle);
        this.searchAltar = new ObjectStep((QuestHelper)this, 3520, new WorldPoint(3442, 9741, 0), "Search the grotto inside.", this.ghostspeak);
        this.talkToFillimanInGrotto = new NpcStep((QuestHelper)this, 943, new WorldPoint(3441, 9738, 0), "Talk to Filliman in the grotto to bless your sickle.", this.ghostspeak, this.silverSickle);
        this.blessSickle = new NpcStep((QuestHelper)this, 944, new WorldPoint(3441, 9738, 0), "Talk to the Nature Spirit in the grotto to bless your sickle.", this.ghostspeak, this.silverSickle);
        this.fillPouches = new DetailedQuestStep((QuestHelper)this, "Right-click 'bloom' the blessed sickle next to rotten logs for mort myre fungi. Use these to fill the druid pouch.", this.blessedSickle);
        this.killGhasts = new NpcStep((QuestHelper)this, 945, "Use the filled druid pouch on a ghast to make it attackable and kill it. You'll need to kill 3.", this.druidPouchFull);
        this.killGhast = new NpcStep((QuestHelper)this, 946, "Kill the ghast.", this.druidPouchFull);
        this.killGhasts.addSubSteps(this.killGhast);
        this.enterGrottoAgain = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Enter the Grotto in the south of Mort Myre.", this.ghostspeak);
        this.touchAltarAgain = new ObjectStep((QuestHelper)this, 3520, new WorldPoint(3442, 9741, 0), "Search the grotto inside.", this.ghostspeak);
        this.talkToNatureSpiritToFinish = new NpcStep((QuestHelper)this, 944, new WorldPoint(3441, 9738, 0), "Talk to the Nature Spirit in the grotto to finish the quest!", this.ghostspeak);
        this.talkToNatureSpiritToFinish.addSubSteps(this.touchAltarAgain);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.ghostspeak, this.silverSickle);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.salveTele, this.combatGear);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("Whilst in Mort Myre, the Ghasts will occasionally rot the food in your inventory.");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("3 Ghasts (level 30)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 3000), new ExperienceReward(Skill.DEFENCE, 2000), new ExperienceReward(Skill.HITPOINTS, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to Mort Myre Swamp"), new UnlockReward("Ability to fight Ghasts."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Arrays.asList(this.talkToDrezel, this.enterSwamp, this.tryToEnterGrotto, this.talkToFilliman, this.takeWashingBowl, this.takeMirror, this.useMirrorOnFilliman, this.searchGrotto, this.useJournalOnFilliman), this.ghostspeak, this.silverSickle));
        allSteps.add(new PanelDetails("Helping Filliman", Arrays.asList(this.talkToDrezelForBlessing, this.castSpellAndGetMushroom, this.useMushroom, this.useSpellCard, this.standOnOrange, this.tellFillimanToCast, this.enterGrotto, this.searchAltar, this.talkToFillimanInGrotto, this.blessSickle), this.ghostspeak, this.silverSickle));
        allSteps.add(new PanelDetails("Killing Ghasts", Arrays.asList(this.fillPouches, this.killGhasts, this.enterGrottoAgain, this.talkToNatureSpiritToFinish), this.ghostspeak, this.blessedSickle));
        return allSteps;
    }
}

