/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.murdermystery;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.MURDER_MYSTERY)
public class MurderMystery
extends BasicQuestHelper {
    ItemRequirement pot;
    ItemRequirement pungentPot;
    ItemRequirement criminalsDaggerAny;
    ItemRequirement criminalsDagger;
    ItemRequirement criminalsDaggerFlour;
    ItemRequirement criminalsThread;
    ItemRequirement criminalsThread1;
    ItemRequirement criminalsThread2;
    ItemRequirement criminalsThread3;
    ItemRequirement twoFlypaper;
    ItemRequirement potOfFlourHighlighted;
    ItemRequirement flypaper;
    ItemRequirement unknownPrint;
    ItemRequirement silverNecklace;
    ItemRequirement silverBook;
    ItemRequirement silverBookFlour;
    ItemRequirement silverNecklaceFlour;
    ItemRequirement annaPrint;
    ItemRequirement davidPrint;
    ItemRequirement killersPrint;
    ItemRequirement silverNeedle;
    ItemRequirement silverPot;
    ItemRequirement silverNeedleFlour;
    ItemRequirement silverPotFlour;
    ItemRequirement elizabethPrint;
    ItemRequirement frankPrint;
    ItemRequirement criminalsDaggerHighlighted;
    ItemRequirement criminalsDaggerFlourHighlighted;
    ItemRequirement silverCup;
    ItemRequirement silverCupFlour;
    ItemRequirement silverBottle;
    ItemRequirement silverBottleFlour;
    ItemRequirement bobPrint;
    ItemRequirement carolPrint;
    RuneliteRequirement heardAboutPoisonSalesman;
    RuneliteRequirement talkedToPoisonSalesman;
    RuneliteRequirement hadThread;
    RuneliteRequirement hadPot;
    RuneliteRequirement hadKillerPrint;
    Requirement annaGuilty;
    Requirement bobGuilty;
    Requirement carolGuilty;
    Requirement davidGuilty;
    Requirement elizabethGuilty;
    Requirement frankGuilty;
    Requirement hasCriminalSilverItem;
    Requirement isUpstairs;
    Requirement hasSuspectPrint;
    Requirement hasSilverItemFlour;
    Requirement talkedToAnna;
    Requirement talkedToBob;
    Requirement talkedToCarol;
    Requirement talkedToDavid;
    Requirement talkedToElizabeth;
    Requirement talkedToFrank;
    Requirement talkedToSuspect;
    Requirement pleaseWaitRequirement;
    Requirement checkedAnna;
    Requirement checkedBob;
    Requirement checkedCarol;
    Requirement checkedDavid;
    Requirement checkedElizabeth;
    Requirement checkedFrank;
    Requirement checkedSuspect;
    Zone upstairs;
    QuestStep talkToGuard;
    QuestStep talkToGossip;
    QuestStep talkToPoisonSalesman;
    QuestStep pickUpDagger;
    QuestStep pickUpPungentPot;
    QuestStep searchWindowForThread;
    QuestStep fillPotWithFlour;
    QuestStep useFlourOnDagger;
    QuestStep collectTwoFlypaper;
    QuestStep useFlypaperOnDagger;
    QuestStep searchAnnasBarrel;
    QuestStep searchDavidsBarrel;
    QuestStep searchFranksBarrel;
    QuestStep searchElizabethsBarrel;
    QuestStep searchBobsBarrel;
    QuestStep searchCarolsBarrel;
    QuestStep remainingSteps;
    QuestStep finishQuest;
    QuestStep useFlourOnNecklace;
    QuestStep useFlourOnCup;
    QuestStep useFlourOnBottle;
    QuestStep useFlourOnBook;
    QuestStep useFlourOnNeedle;
    QuestStep useFlourOnPot;
    QuestStep useFlypaperOnNecklace;
    QuestStep useFlypaperOnCup;
    QuestStep useFlypaperOnBottle;
    QuestStep useFlypaperOnBook;
    QuestStep useFlypaperOnNeedle;
    QuestStep useFlypaperOnPot;
    QuestStep collectFlypaper;
    QuestStep fillPotWithFlourForSilver;
    QuestStep compareAnna;
    QuestStep compareBob;
    QuestStep compareCarol;
    QuestStep compareDavid;
    QuestStep compareElizabeth;
    QuestStep compareFrank;
    QuestStep talkToAnna;
    QuestStep talkToBob;
    QuestStep talkToFrank;
    QuestStep talkToDavid;
    QuestStep talkToCarol;
    QuestStep talkToElizabeth;
    QuestStep searchAnna;
    QuestStep searchBob;
    QuestStep searchCarol;
    QuestStep searchDavid;
    QuestStep searchElizabeth;
    QuestStep searchFrank;
    ConditionalStep useFlour;
    ConditionalStep searchBarrel;
    ConditionalStep useFlypaper;
    ConditionalStep comparePrints;
    ConditionalStep talkToSuspect;
    ConditionalStep searchSuspectItem;
    DetailedQuestStep useFlourSidebar;
    DetailedQuestStep searchBarrelSidebar;
    DetailedQuestStep useFlypaperSidebar;
    DetailedQuestStep comparePrintsSidebar;
    DetailedQuestStep talkToSuspectSidebar;
    DetailedQuestStep searchSuspectItemSidebar;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZone();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToGuard);
        Conditions doesntNeedMoreFlypaper = new Conditions(LogicType.OR, this.twoFlypaper, new Conditions(this.flypaper, this.unknownPrint));
        Conditions hadPotAndThread = new Conditions(this.hadThread, this.hadPot);
        ConditionalStep checkingPrintSteps = new ConditionalStep((QuestHelper)this, this.pickUpDagger, new Requirement[0]);
        checkingPrintSteps.addStep(new Conditions(this.unknownPrint, this.hasSuspectPrint), this.comparePrints);
        checkingPrintSteps.addStep(new Conditions(this.unknownPrint, this.hasSilverItemFlour, this.flypaper), this.useFlypaper);
        checkingPrintSteps.addStep(new Conditions(this.unknownPrint, this.hasCriminalSilverItem, this.flypaper, this.potOfFlourHighlighted), this.useFlour);
        checkingPrintSteps.addStep(new Conditions(this.unknownPrint, this.hasCriminalSilverItem, this.flypaper), this.fillPotWithFlourForSilver);
        checkingPrintSteps.addStep(new Conditions(this.unknownPrint, this.hasCriminalSilverItem), this.collectFlypaper);
        checkingPrintSteps.addStep(new Conditions(this.criminalsDaggerFlour, this.hasCriminalSilverItem), this.useFlypaperOnDagger);
        checkingPrintSteps.addStep(new Conditions(this.criminalsDaggerAny, this.hasCriminalSilverItem, this.potOfFlourHighlighted), this.useFlourOnDagger);
        checkingPrintSteps.addStep(new Conditions(this.criminalsDaggerAny, doesntNeedMoreFlypaper, this.hasCriminalSilverItem), this.fillPotWithFlour);
        checkingPrintSteps.addStep(new Conditions(this.criminalsDaggerAny, doesntNeedMoreFlypaper), this.searchBarrel);
        checkingPrintSteps.addStep(new Conditions(this.criminalsDaggerAny), this.collectTwoFlypaper);
        ConditionalStep investigating = new ConditionalStep((QuestHelper)this, this.searchWindowForThread, new Requirement[0]);
        investigating.addStep(new Conditions(hadPotAndThread, this.hadKillerPrint, this.checkedSuspect), this.finishQuest);
        investigating.addStep(new Conditions(hadPotAndThread, this.hadKillerPrint, this.talkedToSuspect), this.searchSuspectItem);
        investigating.addStep(new Conditions(hadPotAndThread, this.hadKillerPrint, this.talkedToPoisonSalesman), this.talkToSuspect);
        investigating.addStep(new Conditions(hadPotAndThread, this.hadKillerPrint, this.heardAboutPoisonSalesman), this.talkToPoisonSalesman);
        investigating.addStep(new Conditions(hadPotAndThread, this.hadKillerPrint), this.talkToGossip);
        investigating.addStep(hadPotAndThread, checkingPrintSteps);
        investigating.addStep(this.hadThread, this.pickUpPungentPot);
        steps.put(1, investigating);
        if (this.client.getVarpValue(195) > 0) {
            this.updateSuspect();
        }
        return steps;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarpId() != 195) {
            return;
        }
        this.updateSuspect();
    }

    private void updateSuspect() {
        int suspect = this.client.getVarpValue(195);
        if (suspect == 1) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnNecklace.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchAnnasBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnNecklace.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareAnna.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToAnna.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchAnna.getText().get(0));
        } else if (suspect == 2) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnCup.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchBobsBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnCup.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareBob.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToBob.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchBob.getText().get(0));
        } else if (suspect == 3) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnBottle.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchCarolsBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnBottle.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareCarol.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToCarol.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchCarol.getText().get(0));
        } else if (suspect == 4) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnBook.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchDavidsBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnBook.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareDavid.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToDavid.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchDavid.getText().get(0));
        } else if (suspect == 5) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnNeedle.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchElizabethsBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnNeedle.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareElizabeth.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToElizabeth.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchElizabeth.getText().get(0));
        } else if (suspect == 6) {
            this.useFlourSidebar.getText().set(0, this.useFlourOnPot.getText().get(0));
            this.searchBarrelSidebar.getText().set(0, this.searchFranksBarrel.getText().get(0));
            this.useFlypaperSidebar.getText().set(0, this.useFlypaperOnPot.getText().get(0));
            this.comparePrintsSidebar.getText().set(0, this.compareFrank.getText().get(0));
            this.talkToSuspectSidebar.getText().set(0, this.talkToFrank.getText().get(0));
            this.searchSuspectItemSidebar.getText().set(0, this.searchFrank.getText().get(0));
        }
    }

    public void setupZone() {
        this.upstairs = new Zone(new WorldPoint(2727, 3571, 1), new WorldPoint(2752, 3585, 1));
    }

    public void setupConditions() {
        this.isUpstairs = new ZoneRequirement(this.upstairs);
        this.hadThread = new RuneliteRequirement(this.getConfigManager(), "murdermysteryhadthread", this.criminalsThread.alsoCheckBank(this.questBank));
        this.hadPot = new RuneliteRequirement(this.getConfigManager(), "murdermysteryhadpot", this.pungentPot.alsoCheckBank(this.questBank));
        this.heardAboutPoisonSalesman = new RuneliteRequirement(this.getConfigManager(), "murdermysterytalkedtogossip", new Conditions(true, new DialogRequirement("Especially as I heard that the poison salesman in the Seers' village made a big sale to one of the family the other day.")));
        this.talkedToPoisonSalesman = new RuneliteRequirement(this.getConfigManager(), "murdermysterytalkedtopoisonsalesman", new Conditions(true, LogicType.OR, new DialogRequirement(this.client.getLocalPlayer().getName(), "Uh... no, it's ok.", false), new DialogRequirement("Anna, Bob, Carol, David, Elizabeth and Frank all bought a bottle! In fact they bought the last of my supplies!")));
        this.hasCriminalSilverItem = new Conditions(LogicType.OR, new Conditions(this.annaGuilty, this.silverNecklace), new Conditions(this.bobGuilty, this.silverCup), new Conditions(this.carolGuilty, this.silverBottle), new Conditions(this.davidGuilty, this.silverBook), new Conditions(this.elizabethGuilty, this.silverNeedle), new Conditions(this.frankGuilty, this.silverPot));
        this.annaGuilty = new VarplayerRequirement(195, 1);
        this.bobGuilty = new VarplayerRequirement(195, 2);
        this.carolGuilty = new VarplayerRequirement(195, 3);
        this.davidGuilty = new VarplayerRequirement(195, 4);
        this.elizabethGuilty = new VarplayerRequirement(195, 5);
        this.frankGuilty = new VarplayerRequirement(195, 6);
        this.hasSuspectPrint = new Conditions(LogicType.OR, new Conditions(this.annaGuilty, this.annaPrint), new Conditions(this.bobGuilty, this.bobPrint), new Conditions(this.carolGuilty, this.carolPrint), new Conditions(this.davidGuilty, this.davidPrint), new Conditions(this.elizabethGuilty, this.elizabethPrint), new Conditions(this.frankGuilty, this.frankPrint));
        this.hadKillerPrint = new RuneliteRequirement(this.getConfigManager(), "murdermysteryhadkillerprint", new Conditions(this.killersPrint));
        this.hasSilverItemFlour = new Conditions(LogicType.OR, new Conditions(this.annaGuilty, this.silverNecklaceFlour), new Conditions(this.bobGuilty, this.silverCupFlour), new Conditions(this.carolGuilty, this.silverBottleFlour), new Conditions(this.davidGuilty, this.silverBookFlour), new Conditions(this.elizabethGuilty, this.silverNeedleFlour), new Conditions(this.frankGuilty, this.silverPotFlour));
        this.pleaseWaitRequirement = new WidgetTextRequirement(231, 5, "Please wait...");
        this.talkedToAnna = new Conditions(true, new DialogRequirement("Anna", "That useless Gardener Stanford has let his compost", false));
        this.talkedToBob = new Conditions(true, new DialogRequirement("Bob", "What's it to you anyway? If you absolutely", false));
        this.talkedToCarol = new Conditions(true, new DialogRequirement("Carol", "I felt I had to do it myself.", false));
        this.talkedToDavid = new Conditions(true, new DialogRequirement("David", "fire the whole workshy lot", false));
        this.talkedToElizabeth = new Conditions(true, new DialogRequirement("Elizabeth", "Doesn't everyone?", false));
        this.talkedToFrank = new Conditions(true, new DialogRequirement("Frank", "clean that family crest", false));
        this.talkedToSuspect = new RuneliteRequirement(this.getConfigManager(), "murdermysterytalkedtosuspect", new Conditions(LogicType.OR, new Conditions(this.annaGuilty, this.talkedToAnna), new Conditions(this.bobGuilty, this.talkedToBob), new Conditions(this.carolGuilty, this.talkedToCarol), new Conditions(this.davidGuilty, this.talkedToDavid), new Conditions(this.elizabethGuilty, this.talkedToElizabeth), new Conditions(this.frankGuilty, this.talkedToFrank)));
        this.checkedAnna = new Conditions(true, new WidgetTextRequirement(229, 1, "The compost is teeming with maggots."));
        this.checkedBob = new Conditions(true, new WidgetTextRequirement(229, 1, "The beehive buzzes with activity."));
        this.checkedCarol = new Conditions(true, new WidgetTextRequirement(229, 1, "The drain is totally blocked."));
        this.checkedDavid = new Conditions(true, new WidgetTextRequirement(229, 1, "few hundred spiders ready to hatch."));
        this.checkedElizabeth = new Conditions(true, new WidgetTextRequirement(229, 1, "The fountain is swarming"));
        this.checkedFrank = new Conditions(true, new WidgetTextRequirement(229, 1, "crest but it is very dirty"));
        this.checkedSuspect = new RuneliteRequirement(this.getConfigManager(), "murdermysterydisprovedsuspect", new Conditions(LogicType.OR, this.checkedAnna, this.checkedBob, this.checkedCarol, this.checkedDavid, this.checkedElizabeth, this.checkedFrank));
    }

    @Override
    public void setupRequirements() {
        this.pot = new ItemRequirement("Pot", 1931);
        this.pungentPot = new ItemRequirement("Pungent pot", 1812);
        this.criminalsDaggerAny = new ItemRequirement("Criminal's dagger", 1813);
        this.criminalsDaggerAny.addAlternates(1814, 1815);
        this.criminalsDagger = new ItemRequirement("Criminal's dagger", 1813);
        this.criminalsDaggerHighlighted = new ItemRequirement("Criminal's dagger", 1813);
        this.criminalsDaggerHighlighted.setHighlightInInventory(true);
        this.criminalsDaggerFlour = new ItemRequirement("Criminal's dagger", 1814);
        this.criminalsDaggerFlourHighlighted = new ItemRequirement("Criminal's dagger", 1814);
        this.criminalsDaggerFlourHighlighted.setHighlightInInventory(true);
        this.criminalsThread = new ItemRequirement("Criminal's thread", 1808);
        this.criminalsThread.addAlternates(1809, 1810);
        this.criminalsThread1 = new ItemRequirement("Criminal's thread", 1808);
        this.criminalsThread2 = new ItemRequirement("Criminal's thread", 1809);
        this.criminalsThread3 = new ItemRequirement("Criminal's thread", 1810);
        this.twoFlypaper = new ItemRequirement("Flypaper", 1811, 2);
        this.flypaper = new ItemRequirement("Flypaper", 1811);
        this.flypaper.setHighlightInInventory(true);
        this.flypaper.setTooltip("You can get more from the sack in the shed on the west of the Sinclair Mansion");
        this.potOfFlourHighlighted = new ItemRequirement("Pot of flour", 1933);
        this.potOfFlourHighlighted.setHighlightInInventory(true);
        this.unknownPrint = new ItemRequirement("Unknown print", 1822);
        this.bobPrint = new ItemRequirement("Bob's print", 1817);
        this.carolPrint = new ItemRequirement("Carol's print", 1818);
        this.silverCup = new ItemRequirement("Silver cup", 1798);
        this.silverCupFlour = new ItemRequirement("Silver cup", 1799);
        this.silverBottle = new ItemRequirement("Silver bottle", 1800);
        this.silverBottleFlour = new ItemRequirement("Silver bottle", 1801);
        this.annaPrint = new ItemRequirement("Anna's print", 1816);
        this.davidPrint = new ItemRequirement("David's print", 1819);
        this.silverNecklace = new ItemRequirement("Silver necklace", 1796);
        this.silverNecklaceFlour = new ItemRequirement("Silver necklace", 1797);
        this.silverBook = new ItemRequirement("Silver book", 1802);
        this.silverBookFlour = new ItemRequirement("Silver book", 1803);
        this.elizabethPrint = new ItemRequirement("Elizabeth's print", 1820);
        this.frankPrint = new ItemRequirement("Frank's print", 1821);
        this.silverNeedle = new ItemRequirement("Silver needle", 1804);
        this.silverNeedleFlour = new ItemRequirement("Silver needle", 1805);
        this.silverPot = new ItemRequirement("Silver needle", 1806);
        this.silverPotFlour = new ItemRequirement("Silver needle", 1807);
        this.killersPrint = new ItemRequirement("Killer's print", 1815);
    }

    public void setupSteps() {
        this.talkToGuard = new NpcStep((QuestHelper)this, 4218, new WorldPoint(2741, 3561, 0), "Talk to the Guard in the Sinclair Manor north of Camelot.", new Requirement[0]);
        this.talkToGuard.addDialogSteps("Yes.", "Sure, I'll help.");
        this.pickUpPungentPot = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2747, 3579, 0), "Enter the mansion and pick up the pungent pot inside the east room.", this.pungentPot);
        this.pickUpDagger = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2746, 3578, 0), "Pick up the criminal's dagger.", this.criminalsDaggerAny);
        this.searchWindowForThread = new ObjectStep((QuestHelper)this, 26123, new WorldPoint(2748, 3577, 0), "Search the window for a clothing thread. The colour of the thread will match the killer's trousers.", this.criminalsThread);
        this.fillPotWithFlour = new ObjectStep((QuestHelper)this, 26122, new WorldPoint(2733, 3582, 0), "Fill your pot with flour from the barrel in the mansion's kitchen.", this.pot);
        this.useFlourOnDagger = new DetailedQuestStep((QuestHelper)this, "Use the pot of flour on the Criminal's dagger.", this.potOfFlourHighlighted, this.criminalsDaggerHighlighted);
        this.collectTwoFlypaper = new ObjectStep((QuestHelper)this, 2663, new WorldPoint(2731, 3582, 0), "Investigate the sacks in the shed for flypaper. Get 2 pieces.", this.twoFlypaper);
        this.collectTwoFlypaper.addDialogStep("Yes, it might be useful.");
        ObjectStep goUpstairs = new ObjectStep((QuestHelper)this, 25682, new WorldPoint(2736, 3581, 0), "Climb up the mansion staircase.", new Requirement[0]);
        this.searchBobsBarrel = new ObjectStep((QuestHelper)this, 2657, new WorldPoint(2735, 3579, 0), "Search Bob's barrel on the ground floor.", new Requirement[0]);
        this.searchCarolsBarrel = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Search Carol's barrel upstairs.", new Requirement[0]);
        ((ConditionalStep)this.searchCarolsBarrel).addStep(this.isUpstairs, new ObjectStep((QuestHelper)this, 2658, new WorldPoint(2733, 3580, 1), "", new Requirement[0]));
        this.searchAnnasBarrel = new ObjectStep((QuestHelper)this, 2656, new WorldPoint(2733, 3575, 0), "Search Anna's barrel on the ground floor.", new Requirement[0]);
        this.searchDavidsBarrel = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Search David's barrel upstairs.", new Requirement[0]);
        ((ConditionalStep)this.searchDavidsBarrel).addStep(this.isUpstairs, new ObjectStep((QuestHelper)this, 2659, new WorldPoint(2733, 3577, 1), "", new Requirement[0]));
        this.searchFranksBarrel = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Search Frank's barrel upstairs.", new Requirement[0]);
        ((ConditionalStep)this.searchFranksBarrel).addStep(this.isUpstairs, new ObjectStep((QuestHelper)this, 2661, new WorldPoint(2747, 3577, 1), "", new Requirement[0]));
        this.searchElizabethsBarrel = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Search Elizabeth's barrel upstairs.", new Requirement[0]);
        ((ConditionalStep)this.searchElizabethsBarrel).addStep(this.isUpstairs, new ObjectStep((QuestHelper)this, 2660, new WorldPoint(2747, 3581, 1), "", new Requirement[0]));
        this.useFlypaperOnDagger = new DetailedQuestStep((QuestHelper)this, "Use the flypaper on the dagger.", this.flypaper, this.criminalsDaggerFlourHighlighted);
        this.collectFlypaper = new ObjectStep((QuestHelper)this, 2663, new WorldPoint(2731, 3582, 0), "Investigate the sacks in the shed for 1 flypaper.", this.flypaper);
        this.collectFlypaper.addDialogStep("Yes, it might be useful.");
        this.fillPotWithFlourForSilver = new ObjectStep((QuestHelper)this, 26122, new WorldPoint(2733, 3582, 0), "Fill your pot with flour from the barrel in the mansion's kitchen.", this.pot);
        this.fillPotWithFlourForSilver.addSubSteps(this.collectFlypaper);
        this.useFlourOnNecklace = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver necklace.", this.silverNecklace.highlighted(), this.potOfFlourHighlighted);
        this.useFlourOnCup = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver cup.", this.silverCup.highlighted(), this.potOfFlourHighlighted);
        this.useFlourOnBottle = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver bottle.", this.silverBottle.highlighted(), this.potOfFlourHighlighted);
        this.useFlourOnBook = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver book.", this.silverBook.highlighted(), this.potOfFlourHighlighted);
        this.useFlourOnNeedle = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver needle.", this.silverNeedle.highlighted(), this.potOfFlourHighlighted);
        this.useFlourOnPot = new DetailedQuestStep((QuestHelper)this, "Use flour on the silver pot.", this.silverPot.highlighted(), this.potOfFlourHighlighted);
        this.useFlypaperOnNecklace = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver necklace.", this.silverNecklaceFlour.highlighted(), this.flypaper.highlighted());
        this.useFlypaperOnCup = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver cup.", this.silverCupFlour.highlighted(), this.flypaper.highlighted());
        this.useFlypaperOnBottle = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver bottle.", this.silverBottleFlour.highlighted(), this.flypaper.highlighted());
        this.useFlypaperOnBook = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver book.", this.silverBookFlour.highlighted(), this.flypaper.highlighted());
        this.useFlypaperOnNeedle = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver needle.", this.silverNeedleFlour.highlighted(), this.flypaper.highlighted());
        this.useFlypaperOnPot = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the silver pot.", this.silverPotFlour.highlighted(), this.flypaper.highlighted());
        this.compareAnna = new DetailedQuestStep((QuestHelper)this, "Use Anna's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.annaPrint.highlighted());
        this.compareBob = new DetailedQuestStep((QuestHelper)this, "Use Bob's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.bobPrint.highlighted());
        this.compareCarol = new DetailedQuestStep((QuestHelper)this, "Use Carol's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.carolPrint.highlighted());
        this.compareDavid = new DetailedQuestStep((QuestHelper)this, "Use David's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.davidPrint.highlighted());
        this.compareElizabeth = new DetailedQuestStep((QuestHelper)this, "Use Elizabeth's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.elizabethPrint.highlighted());
        this.compareFrank = new DetailedQuestStep((QuestHelper)this, "Use Frank's prints on the killer's print to compare them.", this.unknownPrint.highlighted(), this.frankPrint.highlighted());
        this.talkToGossip = new NpcStep((QuestHelper)this, 4219, new WorldPoint(2741, 3557, 0), "Talk to Gossip, just south of the Sinclair Mansion.", new Requirement[0]);
        this.talkToGossip.addDialogStep(2, "Who do you think was responsible?");
        this.talkToPoisonSalesman = new NpcStep((QuestHelper)this, 4227, new WorldPoint(2694, 3493, 0), "Talk to the Poison Salesman in the Seers' Village pub.", new Requirement[0]);
        this.talkToPoisonSalesman.addDialogStep("Who did you sell Poison to at the house?");
        this.talkToPoisonSalesman.addDialogStep("Talk about the Murder Mystery Quest");
        this.talkToAnna = new NpcStep((QuestHelper)this, 4220, new WorldPoint(2734, 3575, 0), "Talk to Anna in the mansion about what she used the poison for. Make sure to finish the dialog.", new Requirement[0]);
        this.talkToBob = new NpcStep((QuestHelper)this, 4221, new WorldPoint(2748, 3559, 0), "Talk to Bob south of the mansion about what he used the poison for. Make sure to finish the dialog.", new Requirement[0]);
        this.talkToFrank = new NpcStep((QuestHelper)this, 4225, new WorldPoint(2742, 3577, 0), "Talk to Frank in the mansion about what he used the poison for. Make sure to finish the dialog.", new Requirement[0]);
        this.talkToDavid = new NpcStep((QuestHelper)this, 4223, new WorldPoint(2739, 3581, 0), "Talk to David in the mansion about what he used the poison for. Make sure to finish the dialog.", new Requirement[0]);
        this.talkToCarol = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Talk to Carol upstairs in the mansion about what she used her poison for. Make sure to finish the dialog.", new Requirement[0]);
        ((ConditionalStep)this.talkToCarol).addStep(this.isUpstairs, new NpcStep((QuestHelper)this, 4222, new WorldPoint(2734, 3581, 1), "", new Requirement[0]));
        this.talkToElizabeth = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Talk to Elizabeth upstairs in the mansion about what she used her poison for.", new Requirement[0]);
        ((ConditionalStep)this.talkToElizabeth).addStep(this.isUpstairs, new NpcStep((QuestHelper)this, 4224, new WorldPoint(2746, 3581, 1), "", new Requirement[0]));
        this.searchAnna = new ObjectStep((QuestHelper)this, 26120, new WorldPoint(2730, 3572, 0), "Search the compost heap south west of the mansion. If a dialog box doesn't come up, go back to Anna to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        this.searchBob = new ObjectStep((QuestHelper)this, 26121, new WorldPoint(2730, 3559, 0), "Search the beehive south west of the mansion. If a dialog box doesn't come up, go back to Bob to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        this.searchCarol = new ObjectStep((QuestHelper)this, 2652, new WorldPoint(2736, 3573, 0), "Search the drain south of the mansion. If a dialog box doesn't come up, go back to Carol to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        this.searchDavid = new ConditionalStep((QuestHelper)this, (QuestStep)goUpstairs, "Search the spider's nest, upstairs in the mansion to the south. If a dialog box doesn't come up, go back to David to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        ((ConditionalStep)this.searchDavid).addStep(this.isUpstairs, new ObjectStep((QuestHelper)this, 26109, new WorldPoint(2740, 3574, 1), "", new Requirement[0]));
        this.searchElizabeth = new ObjectStep((QuestHelper)this, 2654, new WorldPoint(2747, 3563, 0), "Search the fountain south east of the mansion. If a dialog box doesn't come up, go back to Elizabeth to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        this.searchFrank = new ObjectStep((QuestHelper)this, 2655, new WorldPoint(2746, 3573, 0), "Search the family crest attached to the south side of the mansion to the east. If a dialog box doesn't come up, go back to Frank to ask about poison, and COMPLETE THE DIALOG.", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 4218, new WorldPoint(2741, 3561, 0), "Return to the guard outside the Sinclair Mansion and tell him your findings.", new Requirement[0]);
        this.finishQuest.addDialogStep("I know who did it!");
        this.remainingSteps = new DetailedQuestStep((QuestHelper)this, "Follow the steps in the Quest Helper sidebar for the rest of the quest.", new Requirement[0]);
        this.remainingSteps.addDialogStep(2, "Who do you think was responsible?");
        this.remainingSteps.addDialogStep("Why'd you buy poison the other day?");
        this.remainingSteps.addDialogStep("Who did you sell Poison to at the house?");
        this.remainingSteps.addDialogStep("I know who did it!");
        this.remainingSteps.setShowInSidebar(false);
        this.useFlour = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.useFlour.addStep(new Conditions(this.elizabethGuilty), this.useFlourOnNeedle);
        this.useFlour.addStep(new Conditions(this.annaGuilty), this.useFlourOnNecklace);
        this.useFlour.addStep(new Conditions(this.carolGuilty), this.useFlourOnBottle);
        this.useFlour.addStep(new Conditions(this.davidGuilty), this.useFlourOnBook);
        this.useFlour.addStep(new Conditions(this.frankGuilty), this.useFlourOnPot);
        this.useFlour.addStep(new Conditions(this.bobGuilty), this.useFlourOnCup);
        this.useFlourSidebar = new DetailedQuestStep((QuestHelper)this, "Use flour on the suspect's item.", new Requirement[0]);
        this.useFlourSidebar.addSubSteps(this.useFlourOnNeedle, this.useFlourOnNecklace, this.useFlourOnBottle, this.useFlourOnBook, this.useFlourOnPot, this.useFlourOnCup);
        this.searchBarrel = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.searchBarrel.addStep(new Conditions(this.elizabethGuilty), this.searchElizabethsBarrel);
        this.searchBarrel.addStep(new Conditions(this.annaGuilty), this.searchAnnasBarrel);
        this.searchBarrel.addStep(new Conditions(this.carolGuilty), this.searchCarolsBarrel);
        this.searchBarrel.addStep(new Conditions(this.davidGuilty), this.searchDavidsBarrel);
        this.searchBarrel.addStep(new Conditions(this.frankGuilty), this.searchFranksBarrel);
        this.searchBarrel.addStep(new Conditions(this.bobGuilty), this.searchBobsBarrel);
        this.searchBarrelSidebar = new DetailedQuestStep((QuestHelper)this, "Search the suspect's barrel.", new Requirement[0]);
        this.searchBarrelSidebar.addSubSteps(this.searchElizabethsBarrel, this.searchAnnasBarrel, this.searchCarolsBarrel, this.searchDavidsBarrel, this.searchFranksBarrel, this.searchBobsBarrel);
        this.useFlypaper = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.useFlypaper.addStep(new Conditions(this.elizabethGuilty), this.useFlypaperOnNeedle);
        this.useFlypaper.addStep(new Conditions(this.annaGuilty), this.useFlypaperOnNecklace);
        this.useFlypaper.addStep(new Conditions(this.carolGuilty), this.useFlypaperOnBottle);
        this.useFlypaper.addStep(new Conditions(this.davidGuilty), this.useFlypaperOnBook);
        this.useFlypaper.addStep(new Conditions(this.frankGuilty), this.useFlypaperOnPot);
        this.useFlypaper.addStep(new Conditions(this.bobGuilty), this.useFlypaperOnCup);
        this.useFlypaperSidebar = new DetailedQuestStep((QuestHelper)this, "Use flypaper on the floured item.", new Requirement[0]);
        this.useFlypaperSidebar.addSubSteps(this.useFlypaperOnNeedle, this.useFlypaperOnNecklace, this.useFlypaperOnBottle, this.useFlypaperOnBook, this.useFlypaperOnPot, this.useFlypaperOnCup);
        this.comparePrints = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.comparePrints.addStep(new Conditions(this.annaGuilty), this.compareAnna);
        this.comparePrints.addStep(new Conditions(this.bobGuilty), this.compareBob);
        this.comparePrints.addStep(new Conditions(this.carolGuilty), this.compareCarol);
        this.comparePrints.addStep(new Conditions(this.davidGuilty), this.compareDavid);
        this.comparePrints.addStep(new Conditions(this.elizabethGuilty), this.compareElizabeth);
        this.comparePrints.addStep(new Conditions(this.frankGuilty), this.compareFrank);
        this.comparePrintsSidebar = new DetailedQuestStep((QuestHelper)this, "Compare the suspect's prints to the unknown prints.", new Requirement[0]);
        this.comparePrintsSidebar.addSubSteps(this.compareAnna, this.compareBob, this.compareCarol, this.compareDavid, this.compareElizabeth, this.compareFrank);
        this.talkToSuspect = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.talkToSuspect.addStep(new Conditions(this.elizabethGuilty), this.talkToElizabeth);
        this.talkToSuspect.addStep(new Conditions(this.carolGuilty), this.talkToCarol);
        this.talkToSuspect.addStep(new Conditions(this.davidGuilty), this.talkToDavid);
        this.talkToSuspect.addStep(new Conditions(this.frankGuilty), this.talkToFrank);
        this.talkToSuspect.addStep(new Conditions(this.bobGuilty), this.talkToBob);
        this.talkToSuspect.addStep(new Conditions(this.annaGuilty), this.talkToAnna);
        this.talkToSuspect.addDialogStep("Why'd you buy poison the other day?");
        this.talkToSuspectSidebar = new DetailedQuestStep((QuestHelper)this, "Talk to the suspect.", new Requirement[0]);
        this.talkToSuspectSidebar.addSubSteps(this.talkToElizabeth, this.talkToCarol, this.talkToDavid, this.talkToFrank, this.talkToBob, this.talkToAnna);
        this.searchSuspectItem = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        this.searchSuspectItem.addStep(new Conditions(this.elizabethGuilty), this.searchElizabeth);
        this.searchSuspectItem.addStep(new Conditions(this.carolGuilty), this.searchCarol);
        this.searchSuspectItem.addStep(new Conditions(this.davidGuilty), this.searchDavid);
        this.searchSuspectItem.addStep(new Conditions(this.frankGuilty), this.searchFrank);
        this.searchSuspectItem.addStep(new Conditions(this.bobGuilty), this.searchBob);
        this.searchSuspectItem.addStep(new Conditions(this.annaGuilty), this.searchAnna);
        this.searchSuspectItemSidebar = new DetailedQuestStep((QuestHelper)this, "Disprove the suspect's alibi by checking the thing they claimed to clean.", new Requirement[0]);
        this.searchSuspectItemSidebar.addSubSteps(this.searchElizabeth, this.searchCarol, this.searchDavid, this.searchFrank, this.searchBob, this.searchAnna);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> required = new ArrayList<ItemRequirement>();
        required.add(this.pot);
        return required;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 1406));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 2000));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Go to the Sinclair Manor", Collections.singletonList(this.talkToGuard), this.pot));
        allSteps.add(new PanelDetails("Collect evidence", Arrays.asList(this.pickUpPungentPot, this.pickUpDagger, this.searchWindowForThread), new Requirement[0]));
        allSteps.add(new PanelDetails("Collect fingerprints", Arrays.asList(this.collectTwoFlypaper, this.searchBarrelSidebar, this.fillPotWithFlour, this.useFlourOnDagger, this.useFlypaperOnDagger, this.fillPotWithFlourForSilver, this.useFlourSidebar, this.useFlypaperSidebar, this.comparePrintsSidebar), new Requirement[0]));
        allSteps.add(new PanelDetails("Finishing off", Arrays.asList(this.talkToGossip, this.talkToPoisonSalesman, this.talkToSuspectSidebar, this.searchSuspectItemSidebar, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

