/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.mourningsendparti;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MOURNINGS_END_PART_I)
public class MourningsEndPartI
extends BasicQuestHelper {
    ItemRequirement bearFur;
    ItemRequirement silk2;
    ItemRequirement redDye;
    ItemRequirement yellowDye;
    ItemRequirement greenDye;
    ItemRequirement blueDye;
    ItemRequirement waterBucket;
    ItemRequirement feather;
    ItemRequirement rottenApple;
    ItemRequirement toadCrunchies;
    ItemRequirement magicLogs;
    ItemRequirement leather;
    ItemRequirement ogreBellows;
    ItemRequirement coal20AndTar;
    ItemRequirement coal20OrNaphtha;
    ItemRequirement blueBellow;
    ItemRequirement redBellow;
    ItemRequirement yellowBellow;
    ItemRequirement greenBellow;
    ItemRequirement mournerMask;
    ItemRequirement bloodyMournerBody;
    ItemRequirement mournerLegsBroken;
    ItemRequirement mournerBoots;
    ItemRequirement mournerGloves;
    ItemRequirement mournerCloak;
    ItemRequirement mournerLetter;
    ItemRequirement tegidsSoap;
    ItemRequirement mournerBody;
    ItemRequirement mournerLegs;
    ItemRequirement sieve;
    ItemRequirement tarnishedKey;
    ItemRequirement fullMourners;
    ItemRequirement equippedMournerMask;
    ItemRequirement equippedMournerBody;
    ItemRequirement equippedMournerLegs;
    ItemRequirement equippedMournerCloak;
    ItemRequirement equippedMournerGloves;
    ItemRequirement equippedMournerBoots;
    ItemRequirement brokenDevice;
    ItemRequirement featherHighlight;
    ItemRequirement fixedDevice;
    ItemRequirement redToad;
    ItemRequirement yellowToad;
    ItemRequirement greenToad;
    ItemRequirement blueToad;
    ItemRequirement fixedDeviceEquipped;
    ItemRequirement emptyBarrel;
    ItemRequirement barrelOfRottenApples;
    ItemRequirement appleBarrel;
    ItemRequirement naphtha;
    ItemRequirement naphthaAppleMix;
    ItemRequirement toxicNaphtha;
    ItemRequirement toxicPowder;
    ItemRequirement coalTar;
    ItemRequirement outpostTeleport;
    ItemRequirement taverleyTeleport;
    ItemRequirement lletyaTeleport;
    ItemRequirement westArdougneTeleport;
    Requirement hasAllMournerItems;
    Requirement mournerItemsNearby;
    Requirement inMournerHQ;
    Requirement inMournerBasement;
    Requirement knowWeaknesses;
    Requirement torturedGnome;
    Requirement talkedWithItem;
    Requirement releasedGnome;
    Requirement repairedDevice;
    Requirement learntAboutToads;
    Requirement hasAllToads;
    Requirement blueToadLoaded;
    Requirement redToadLoaded;
    Requirement yellowToadLoaded;
    Requirement greenToadLoaded;
    Requirement redToadGot;
    Requirement yellowToadGot;
    Requirement greenToadGot;
    Requirement blueToadGot;
    Requirement greenDyed;
    Requirement yellowDyed;
    Requirement redDyed;
    Requirement blueDyed;
    Requirement givenRottenApple;
    Requirement receivedSieve;
    Requirement poisoned1;
    Requirement poisoned2;
    Requirement poisoned3;
    Requirement twoPoisoned;
    DetailedQuestStep talkToIslwyn;
    DetailedQuestStep talkToArianwyn;
    DetailedQuestStep killMourner;
    DetailedQuestStep pickUpLoot;
    DetailedQuestStep searchLaundry;
    DetailedQuestStep useSoapOnTop;
    DetailedQuestStep talkToOronwen;
    DetailedQuestStep enterMournerBase;
    DetailedQuestStep enterMournerBaseNoPass;
    DetailedQuestStep enterBasement;
    DetailedQuestStep talkToEssyllt;
    DetailedQuestStep talkToGnome;
    DetailedQuestStep enterMournerBaseForGnome;
    DetailedQuestStep enterBasementForGnome;
    DetailedQuestStep useFeatherOnGnome;
    DetailedQuestStep enterMournerBaseAfterTorture;
    DetailedQuestStep enterBasementAfterTorture;
    DetailedQuestStep talkToGnomeWithItems;
    DetailedQuestStep releaseGnome;
    DetailedQuestStep giveGnomeItems;
    DetailedQuestStep askAboutToads;
    DetailedQuestStep getToads;
    DetailedQuestStep loadBlueToad;
    DetailedQuestStep shootBlueToad;
    DetailedQuestStep loadRedToad;
    DetailedQuestStep shootRedToad;
    DetailedQuestStep loadGreenToad;
    DetailedQuestStep shootGreenToad;
    DetailedQuestStep loadYellowToad;
    DetailedQuestStep shootYellowToad;
    DetailedQuestStep dyeSheep;
    DetailedQuestStep enterBaseAfterSheep;
    DetailedQuestStep enterBasementAfterSheep;
    DetailedQuestStep talkToEssylltAfterSheep;
    DetailedQuestStep pickUpRottenApple;
    DetailedQuestStep talkToElena;
    DetailedQuestStep talkToElenaNoApple;
    DetailedQuestStep pickUpBarrel;
    DetailedQuestStep useBarrelOnPile;
    DetailedQuestStep useApplesOnPress;
    DetailedQuestStep getNaphtha;
    DetailedQuestStep useNaphthaOnBarrel;
    DetailedQuestStep useSieveOnBarrel;
    DetailedQuestStep cookNaphtha;
    DetailedQuestStep usePowderOnFood1;
    DetailedQuestStep usePowderOnFood2;
    DetailedQuestStep enterMournerBaseAfterPoison;
    DetailedQuestStep enterMournerBasementAfterPoison;
    DetailedQuestStep talkToEssylltAfterPoison;
    DetailedQuestStep returnToArianwyn;
    ConditionalStep getItems;
    ConditionalStep cleanTopSteps;
    ConditionalStep repairTrousersSteps;
    Zone mournerHQ;
    Zone mournerHQ2;
    Zone mournerBasement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToIslwyn);
        steps.put(1, this.talkToIslwyn);
        steps.put(2, this.talkToArianwyn);
        this.getItems = new ConditionalStep((QuestHelper)this, (QuestStep)this.killMourner, new Requirement[0]);
        this.getItems.addStep(this.mournerItemsNearby, this.pickUpLoot);
        this.getItems.setLockingCondition(this.hasAllMournerItems);
        this.cleanTopSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.searchLaundry, new Requirement[0]);
        this.cleanTopSteps.addStep(this.tegidsSoap, this.useSoapOnTop);
        this.cleanTopSteps.setLockingCondition(this.mournerBody);
        this.repairTrousersSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToOronwen, new Requirement[0]);
        this.repairTrousersSteps.setLockingCondition(this.mournerLegs);
        ConditionalStep enterMournerHQ = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMournerBase, new Requirement[0]);
        enterMournerHQ.addStep(this.inMournerBasement, this.talkToEssyllt);
        enterMournerHQ.addStep(this.inMournerHQ, this.enterBasement);
        ConditionalStep prepareItems = new ConditionalStep((QuestHelper)this, (QuestStep)this.getItems, new Requirement[0]);
        prepareItems.addStep(new Conditions(this.hasAllMournerItems, this.mournerBody.alsoCheckBank(this.questBank), this.mournerLegs.alsoCheckBank(this.questBank)), enterMournerHQ);
        prepareItems.addStep(new Conditions(this.hasAllMournerItems, this.mournerBody.alsoCheckBank(this.questBank)), this.repairTrousersSteps);
        prepareItems.addStep(new Conditions(this.hasAllMournerItems), this.cleanTopSteps);
        steps.put(3, prepareItems);
        ConditionalStep getAssignment = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMournerBaseNoPass, new Requirement[0]);
        getAssignment.addStep(this.inMournerBasement, this.talkToEssyllt);
        getAssignment.addStep(this.inMournerHQ, this.enterBasement);
        steps.put(4, getAssignment);
        ConditionalStep tortureGnome = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMournerBaseForGnome, new Requirement[0]);
        tortureGnome.addStep(new Conditions(this.greenDyed, this.redDyed, this.yellowDyed, this.blueDyed, this.inMournerBasement), this.talkToEssylltAfterSheep);
        tortureGnome.addStep(new Conditions(this.greenDyed, this.redDyed, this.yellowDyed, this.blueDyed, this.inMournerHQ), this.enterBasementAfterSheep);
        tortureGnome.addStep(new Conditions(this.greenDyed, this.redDyed, this.yellowDyed, this.blueDyed), this.enterBaseAfterSheep);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed, this.redDyed, this.yellowDyed, this.blueToadLoaded), this.shootBlueToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed, this.redDyed, this.yellowDyed), this.loadBlueToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed, this.redDyed, this.yellowToadLoaded), this.shootYellowToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed, this.redDyed), this.loadYellowToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed, this.redToadLoaded), this.shootRedToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenDyed), this.loadRedToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads, this.greenToadLoaded), this.shootGreenToad);
        tortureGnome.addStep(new Conditions(this.hasAllToads), this.loadGreenToad);
        tortureGnome.addStep(new Conditions(this.learntAboutToads), this.getToads);
        tortureGnome.addStep(new Conditions(this.inMournerBasement, this.repairedDevice), this.askAboutToads);
        tortureGnome.addStep(new Conditions(this.inMournerBasement, this.releasedGnome), this.giveGnomeItems);
        tortureGnome.addStep(new Conditions(this.inMournerBasement, this.talkedWithItem), this.releaseGnome);
        tortureGnome.addStep(new Conditions(this.inMournerBasement, this.torturedGnome), this.talkToGnomeWithItems);
        tortureGnome.addStep(new Conditions(this.inMournerHQ, this.torturedGnome), this.enterBasementAfterTorture);
        tortureGnome.addStep(new Conditions(this.torturedGnome), this.enterMournerBaseAfterTorture);
        tortureGnome.addStep(new Conditions(this.inMournerBasement, this.knowWeaknesses), this.useFeatherOnGnome);
        tortureGnome.addStep(this.inMournerBasement, this.talkToGnome);
        tortureGnome.addStep(this.inMournerHQ, this.enterBasementForGnome);
        steps.put(5, tortureGnome);
        ConditionalStep takeAppleToElena = new ConditionalStep((QuestHelper)this, (QuestStep)this.pickUpRottenApple, new Requirement[0]);
        takeAppleToElena.addStep(new Conditions(this.twoPoisoned, this.inMournerBasement), this.talkToEssylltAfterPoison);
        takeAppleToElena.addStep(new Conditions(this.twoPoisoned, this.inMournerHQ), this.enterMournerBasementAfterPoison);
        takeAppleToElena.addStep(this.twoPoisoned, this.enterMournerBaseAfterPoison);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.poisoned1), this.usePowderOnFood2);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.toxicPowder.alsoCheckBank(this.questBank)), this.usePowderOnFood1);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.toxicNaphtha), this.cookNaphtha);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.naphthaAppleMix), this.useSieveOnBarrel);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.appleBarrel.alsoCheckBank(this.questBank), this.naphtha), this.useNaphthaOnBarrel);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.appleBarrel.alsoCheckBank(this.questBank)), this.getNaphtha);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.barrelOfRottenApples), this.useApplesOnPress);
        takeAppleToElena.addStep(new Conditions(this.receivedSieve, this.emptyBarrel), this.useBarrelOnPile);
        takeAppleToElena.addStep(this.receivedSieve, this.pickUpBarrel);
        takeAppleToElena.addStep(this.givenRottenApple, this.talkToElenaNoApple);
        takeAppleToElena.addStep(this.rottenApple, this.talkToElena);
        steps.put(6, takeAppleToElena);
        ConditionalStep learnTheSecret = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMournerBaseAfterPoison, new Requirement[0]);
        learnTheSecret.addStep(this.inMournerBasement, this.talkToEssylltAfterPoison);
        learnTheSecret.addStep(this.inMournerHQ, this.enterMournerBasementAfterPoison);
        steps.put(7, learnTheSecret);
        steps.put(8, this.returnToArianwyn);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bearFur = new ItemRequirement("Bear fur", 948);
        this.silk2 = new ItemRequirement("Silk", 950, 2);
        this.redDye = new ItemRequirement("Red dye", 1763);
        this.yellowDye = new ItemRequirement("Yellow dye", 1765);
        this.greenDye = new ItemRequirement("Green dye", 1771);
        this.blueDye = new ItemRequirement("Blue dye", 1767);
        this.waterBucket = new ItemRequirement("Bucket of water", 1929);
        this.rottenApple = new ItemRequirement("Rotten apple", 1984);
        this.rottenApple.setTooltip("Obtained during quest.");
        this.toadCrunchies = new ItemRequirement("Toad crunchies (can be Premade t'd crunch)", 2217);
        this.toadCrunchies.addAlternates(9538, 2243);
        this.magicLogs = new ItemRequirement("Magic logs", 1513);
        this.leather = new ItemRequirement("Leather", 1741);
        this.ogreBellows = new ItemRequirement("Ogre bellows", 2871).isNotConsumed();
        this.ogreBellows.addAlternates(2874, 2873, 2872);
        this.coalTar = new ItemRequirement("Barrel of coal tar", 3220);
        this.coal20AndTar = new ItemRequirements(this.coalTar, new ItemRequirement("Barrel of coal tar + 10-20 coal", 453, 10));
        this.outpostTeleport = new ItemRequirement("Teleport to the Outpost. Necklace of passage (The Outpost [2])", ItemCollections.NECKLACE_OF_PASSAGES);
        this.taverleyTeleport = new ItemRequirement("Teleport to Taverley. Taverley Teleport, Games necklace (Burthorpe. [1])", 11742);
        this.taverleyTeleport.addAlternates(ItemCollections.GAMES_NECKLACES);
        this.lletyaTeleport = new ItemRequirement("Lletya teleport. Teleport crystal", ItemCollections.TELEPORT_CRYSTAL);
        this.westArdougneTeleport = new ItemRequirement("West ardougne teleport", 19623);
        this.westArdougneTeleport.addAlternates(8011);
        this.naphtha = new ItemRequirement("Barrel of naphtha", 3221);
        this.naphtha.setHighlightInInventory(true);
        this.coal20OrNaphtha = new ItemRequirements(LogicType.OR, "Barrel of coal tar + 10-20 coal, or a barrel of naphtha", this.coal20AndTar, this.naphtha);
        this.coal20OrNaphtha.setTooltip("You can get this by using a barrel from Port Tyras on the Poison Waste");
        this.feather = new ItemRequirement("Feather", 314);
        this.greenBellow = new ItemRequirement("Green dye bellows", 6088);
        this.yellowBellow = new ItemRequirement("Yellow dye bellows", 6087);
        this.blueBellow = new ItemRequirement("Blue dye bellows", 6086);
        this.redBellow = new ItemRequirement("Red dye bellows", 6085);
        this.mournerMask = new ItemRequirement("Gas mask", 1506).isNotConsumed();
        this.bloodyMournerBody = new ItemRequirement("Bloody mourner top", 6064);
        this.mournerLegsBroken = new ItemRequirement("Ripped mourner trousers", 6066);
        this.mournerBoots = new ItemRequirement("Mourner boots", 6069);
        this.mournerGloves = new ItemRequirement("Mourner gloves", 6068);
        this.mournerCloak = new ItemRequirement("Mourner cloak", 6070);
        this.mournerLetter = new ItemRequirement("Mourner letter", 6071);
        this.tegidsSoap = new ItemRequirement("Tegid's soap", 6072);
        this.tegidsSoap.setHighlightInInventory(true);
        this.mournerBody = new ItemRequirement("Mourner top", 6065);
        this.mournerLegs = new ItemRequirement("Mourner trousers", 6067);
        this.sieve = new ItemRequirement("Sieve", 6097);
        this.sieve.setHighlightInInventory(true);
        this.sieve.setTooltip("You can get another from Elena");
        this.tarnishedKey = new ItemRequirement("Tarnished key", 6083);
        this.fullMourners = new ItemRequirements("Full mourners' outfit", this.mournerMask, this.mournerBody, this.mournerLegs, this.mournerCloak, this.mournerBoots, this.mournerGloves);
        this.equippedMournerBoots = new ItemRequirement("Mourner boots", 6069, 1, true).isNotConsumed().highlighted();
        this.equippedMournerGloves = new ItemRequirement("Mourner gloves", 6068, 1, true).isNotConsumed().highlighted();
        this.equippedMournerCloak = new ItemRequirement("Mourner cloak", 6070, 1, true).isNotConsumed().highlighted();
        this.equippedMournerBody = new ItemRequirement("Mourner top", 6065, 1, true).isNotConsumed().highlighted();
        this.equippedMournerLegs = new ItemRequirement("Mourner trousers", 6067, 1, true).isNotConsumed().highlighted();
        this.equippedMournerMask = new ItemRequirement("Gas mask", 1506, 1, true).isNotConsumed().highlighted();
        this.brokenDevice = new ItemRequirement("Broken device", 6081);
        this.fixedDevice = new ItemRequirement("Fixed device", 6082);
        this.fixedDeviceEquipped = new ItemRequirement("Fixed device", 6082, 1, true);
        this.featherHighlight = new ItemRequirement("Feather", 314);
        this.featherHighlight.setHighlightInInventory(true);
        this.redToad = new ItemRequirement("Red toad", 6090);
        this.yellowToad = new ItemRequirement("Yellow toad", 6091);
        this.greenToad = new ItemRequirement("Green toad", 6092);
        this.blueToad = new ItemRequirement("Blue toad", 6089);
        this.emptyBarrel = new ItemRequirement("Barrel", 3216);
        this.emptyBarrel.setHighlightInInventory(true);
        this.barrelOfRottenApples = new ItemRequirement("Rotten apples", 6093);
        this.barrelOfRottenApples.setHighlightInInventory(true);
        this.appleBarrel = new ItemRequirement("Apple barrel", 6094);
        this.appleBarrel.setHighlightInInventory(true);
        this.naphthaAppleMix = new ItemRequirement("Naphtha apple mix", 6095);
        this.naphthaAppleMix.setHighlightInInventory(true);
        this.toxicNaphtha = new ItemRequirement("Toxic naphtha", 6096);
        this.toxicNaphtha.setHighlightInInventory(true);
        this.toxicPowder = new ItemRequirement("Toxic powder", 6098);
        this.toxicPowder.setTooltip("You'll have to make more if you've lost it");
        this.toxicPowder.setHighlightInInventory(true);
    }

    public void setupConditions() {
        this.mournerItemsNearby = new Conditions(LogicType.OR, new ItemOnTileRequirement(this.bloodyMournerBody), new ItemOnTileRequirement(this.mournerBoots), new ItemOnTileRequirement(this.mournerGloves), new ItemOnTileRequirement(this.mournerCloak), new ItemOnTileRequirement(this.mournerLegsBroken), new ItemOnTileRequirement(this.mournerMask), new ItemOnTileRequirement(this.mournerLetter));
        this.hasAllMournerItems = new Conditions(LogicType.AND, new ItemRequirements(this.mournerMask, this.mournerLetter, this.mournerMask, this.mournerGloves, this.mournerCloak, this.mournerBoots), new ItemRequirements(LogicType.OR, this.mournerBody, this.bloodyMournerBody), new ItemRequirements(LogicType.OR, this.mournerLegsBroken, this.mournerLegs));
        this.inMournerHQ = new ZoneRequirement(this.mournerHQ, this.mournerHQ2);
        this.inMournerBasement = new ZoneRequirement(this.mournerBasement);
        this.knowWeaknesses = new VarbitRequirement(799, 3, Operation.GREATER_EQUAL);
        this.torturedGnome = new VarbitRequirement(799, 5, Operation.GREATER_EQUAL);
        this.talkedWithItem = new VarbitRequirement(799, 6, Operation.GREATER_EQUAL);
        this.releasedGnome = new VarbitRequirement(799, 7, Operation.GREATER_EQUAL);
        this.repairedDevice = new VarbitRequirement(799, 9, Operation.GREATER_EQUAL);
        this.learntAboutToads = new VarbitRequirement(9155, 1);
        this.redToadLoaded = new VarbitRequirement(804, 1);
        this.greenToadLoaded = new VarbitRequirement(804, 2);
        this.blueToadLoaded = new VarbitRequirement(804, 3);
        this.yellowToadLoaded = new VarbitRequirement(804, 4);
        this.greenDyed = new VarbitRequirement(803, 1);
        this.redDyed = new VarbitRequirement(801, 1);
        this.yellowDyed = new VarbitRequirement(802, 1);
        this.blueDyed = new VarbitRequirement(800, 1);
        this.greenToadGot = new Conditions(LogicType.OR, this.greenToadLoaded, this.greenToad, this.greenDyed);
        this.redToadGot = new Conditions(LogicType.OR, this.redToadLoaded, this.redToad, this.redDyed);
        this.yellowToadGot = new Conditions(LogicType.OR, this.yellowToadLoaded, this.yellowToad, this.yellowDyed);
        this.blueToadGot = new Conditions(LogicType.OR, this.blueToadLoaded, this.blueToad, this.blueDyed);
        this.hasAllToads = new Conditions(true, LogicType.AND, this.greenToadGot, this.yellowToadGot, this.redToadGot, this.blueToadGot);
        this.givenRottenApple = new VarbitRequirement(805, 2, Operation.GREATER_EQUAL);
        this.receivedSieve = new VarbitRequirement(805, 4, Operation.GREATER_EQUAL);
        this.poisoned1 = new VarbitRequirement(806, 1);
        this.poisoned2 = new VarbitRequirement(807, 1);
        this.poisoned3 = new VarbitRequirement(808, 1);
        this.twoPoisoned = new Conditions(LogicType.OR, new Conditions(this.poisoned1, this.poisoned2), new Conditions(this.poisoned1, this.poisoned3), new Conditions(this.poisoned2, this.poisoned3));
    }

    public void loadZones() {
        this.mournerHQ = new Zone(new WorldPoint(2547, 3321, 0), new WorldPoint(2555, 3327, 0));
        this.mournerHQ2 = new Zone(new WorldPoint(2542, 3324, 0), new WorldPoint(2546, 3327, 0));
        this.mournerBasement = new Zone(new WorldPoint(2034, 4628, 0), new WorldPoint(2045, 4651, 0));
    }

    public void setupSteps() {
        this.talkToIslwyn = new NpcStep((QuestHelper)this, 8675, new WorldPoint(2207, 3159, 0), "Talk to Islwyn in Isafdar. If he's not at the marked location, try hopping worlds to find him here.", new Requirement[0]);
        this.talkToIslwyn.addDialogStep("I'm ready now.");
        this.talkToIslwyn.addDialogStep("I'm ready.");
        this.talkToIslwyn.addDialogStep("Yes.");
        this.talkToArianwyn = new NpcStep((QuestHelper)this, 9014, new WorldPoint(2354, 3170, 0), "Talk to Arianwyn in Lletya.", new Requirement[0]);
        this.talkToArianwyn.addDialogStep("Okay, let's begin.");
        this.killMourner = new NpcStep((QuestHelper)this, 9013, new WorldPoint(2385, 3326, 0), "Kill a mourner travelling through the Arandar pass. This is more easily accessed from the north entrance. You'll need 7 free inventory spaces.", true, new Requirement[0]);
        this.killMourner.addTeleport(this.outpostTeleport);
        this.pickUpLoot = new DetailedQuestStep((QuestHelper)this, "Pick up everything the mourner dropped.", this.mournerBoots, this.mournerCloak, this.mournerGloves, this.mournerLegsBroken, this.mournerMask, this.mournerLetter, this.bloodyMournerBody);
        this.searchLaundry = new ObjectStep((QuestHelper)this, 4039, new WorldPoint(2912, 3418, 0), "Search Tegid's laundry basket in south Taverley for some soap.", new Requirement[0]);
        this.searchLaundry.addDialogStep("Steal the soap.");
        this.searchLaundry.addTeleport(this.taverleyTeleport);
        this.useSoapOnTop = new DetailedQuestStep((QuestHelper)this, "Use the soap on the bloody mourner top", this.tegidsSoap, this.waterBucket, this.bloodyMournerBody.highlighted());
        this.talkToOronwen = new NpcStep((QuestHelper)this, 1478, new WorldPoint(2327, 3176, 0), "Teleport to Lletya using a crystal teleport seed and talk to Oronwen to have them repair your trousers. Buy dyes here if you still need them.", this.mournerLegsBroken, this.bearFur, this.silk2);
        this.talkToOronwen.addDialogStep("Do you mend clothes?");
        this.talkToOronwen.addDialogStep("I have all I need to mend my trousers.");
        this.talkToOronwen.addTeleport(this.lletyaTeleport);
        this.enterMournerBase = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Equip the full mourners outfit and enter the Mourners' Headquarters in West Ardougne.", this.toadCrunchies, this.feather, this.magicLogs, this.leather, this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak, this.mournerLetter);
        this.enterMournerBase.addTeleport(this.westArdougneTeleport);
        this.enterMournerBaseNoPass = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Equip the full mourners outfit and enter the Mourners' Headquarters in West Ardougne.", this.toadCrunchies, this.feather, this.magicLogs, this.leather, this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak);
        this.enterMournerBase.addSubSteps(this.enterMournerBaseNoPass);
        this.enterBasement = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Go down the trapdoor in the north west corner of the HQ.", new Requirement[0]);
        this.talkToEssyllt = new NpcStep((QuestHelper)this, 9016, new WorldPoint(2043, 4631, 0), "Talk to Essyllt in the south room.", new Requirement[0]);
        this.talkToGnome = new ObjectStep((QuestHelper)this, 8794, new WorldPoint(2035, 4630, 0), "Talk to the gnome on a rack.", this.tarnishedKey, this.feather, this.toadCrunchies);
        this.talkToGnome.addDialogStep("You talked about toad crunchies and being tickled.");
        this.enterMournerBaseForGnome = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Equip the full mourners outfit and enter the Mourners' Headquarters in West Ardougne.", this.toadCrunchies, this.feather, this.magicLogs, this.leather, this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak);
        this.enterBasementForGnome = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Go down the trapdoor in the north west corner of the HQ.", this.feather, this.toadCrunchies, this.magicLogs, this.leather);
        this.talkToGnome.addSubSteps(this.enterMournerBaseForGnome, this.enterBasementForGnome);
        this.useFeatherOnGnome = new ObjectStep((QuestHelper)this, 8794, new WorldPoint(2035, 4630, 0), "Use a feather on the gnome with toad crunchies in your inventory.", this.tarnishedKey, this.featherHighlight, this.toadCrunchies);
        this.useFeatherOnGnome.addIcon(314);
        this.enterMournerBaseAfterTorture = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Equip the full mourners outfit and enter the Mourners' Headquarters in West Ardougne.", this.toadCrunchies, this.feather, this.magicLogs, this.leather, this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak);
        this.enterBasementAfterTorture = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Go down the trapdoor in the north west corner of the HQ.", this.toadCrunchies, this.magicLogs, this.leather);
        this.talkToGnomeWithItems = new ObjectStep((QuestHelper)this, 8794, new WorldPoint(2035, 4630, 0), "Talk to the gnome again with the required items.", this.toadCrunchies, this.magicLogs, this.leather);
        this.releaseGnome = new ObjectStep((QuestHelper)this, 8794, new WorldPoint(2035, 4630, 0), "Right-click release the gnome with the items.", this.tarnishedKey, this.magicLogs, this.leather, this.toadCrunchies, this.brokenDevice);
        this.giveGnomeItems = new NpcStep((QuestHelper)this, 5309, new WorldPoint(2035, 4630, 0), "Give the gnome a magic log, some soft leather and some toad crunchies.", this.tarnishedKey, this.magicLogs, this.leather, this.toadCrunchies, this.brokenDevice);
        this.askAboutToads = new NpcStep((QuestHelper)this, 5309, new WorldPoint(2035, 4630, 0), "Ask the gnome about ammo.", new Requirement[0]);
        this.getToads = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2599, 2966, 0), "You need to make some dyed toads. Go to Feldip Hills, use a dye on your empty bellows, then use the bellows to inflate a toad. Get at least one toad of each colour.", this.redToad, this.yellowToad, this.greenToad, this.blueToad);
        this.loadGreenToad = new DetailedQuestStep((QuestHelper)this, "Add a green toad to the fixed device.", this.greenToad.highlighted(), this.fixedDevice.highlighted());
        this.loadGreenToad.addTeleport(this.westArdougneTeleport);
        this.shootGreenToad = new NpcStep((QuestHelper)this, 3987, new WorldPoint(2621, 3368, 0), "Wield the fixed device and select Aim and Fire from your combat options to fire at a green sheep north of Ardougne.", true, this.fixedDeviceEquipped);
        this.loadRedToad = new DetailedQuestStep((QuestHelper)this, "Add a red toad to the fixed device.", this.redToad.highlighted(), this.fixedDevice.highlighted());
        this.shootRedToad = new NpcStep((QuestHelper)this, 3986, new WorldPoint(2611, 3344, 0), "Wield the fixed device and select Aim and Fire from your combat options to fire at a shoot the red toad at a red sheep north of Ardougne.", true, this.fixedDeviceEquipped);
        this.loadYellowToad = new DetailedQuestStep((QuestHelper)this, "Add a yellow toad to the fixed device.", this.yellowToad.highlighted(), this.fixedDevice.highlighted());
        this.shootYellowToad = new NpcStep((QuestHelper)this, 3989, new WorldPoint(2610, 3391, 0), "Wield the fixed device and select Aim and Fire from your combat options to fire at a yellow sheep north of Ardougne.", true, this.fixedDeviceEquipped);
        this.loadBlueToad = new DetailedQuestStep((QuestHelper)this, "Add a blue toad to the fixed device.", this.blueToad.highlighted(), this.fixedDevice.highlighted());
        this.shootBlueToad = new NpcStep((QuestHelper)this, 3988, new WorldPoint(2562, 3390, 0), "Wield the fixed device and select Aim and Fire from your combat options to fire at a blue sheep north of Ardougne.", true, this.fixedDeviceEquipped);
        this.dyeSheep = new DetailedQuestStep((QuestHelper)this, "Dye each colour of sheep north of Ardougne by using the dyed toads on the fixed device and select Aim and Fire from your combat options to fire.", new Requirement[0]);
        this.dyeSheep.addSubSteps(this.loadGreenToad, this.loadYellowToad, this.loadBlueToad, this.loadRedToad, this.shootBlueToad, this.shootGreenToad, this.shootRedToad, this.shootYellowToad);
        this.enterBaseAfterSheep = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Equip the full mourners outfit and enter the Mourners' Headquarters in West Ardougne.", this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak);
        this.enterBasementAfterSheep = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Go down the trapdoor in the north west corner of the HQ.", new Requirement[0]);
        this.talkToEssylltAfterSheep = new NpcStep((QuestHelper)this, 9016, new WorldPoint(2043, 4631, 0), "Talk to Essyllt in the south room.", new Requirement[0]);
        this.pickUpRottenApple = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2535, 3333, 0), "Pick up a rotten apple from north-west of the Mourner HQ.", this.rottenApple);
        this.talkToElena = new NpcStep((QuestHelper)this, 1102, new WorldPoint(2592, 3335, 0), "Talk to Elena in north-west of East Ardougne.", this.rottenApple);
        this.talkToElenaNoApple = new NpcStep((QuestHelper)this, 1102, new WorldPoint(2592, 3335, 0), "Talk to Elena in north-west of East Ardougne.", new Requirement[0]);
        this.talkToElena.addSubSteps(this.talkToElenaNoApple);
        this.pickUpBarrel = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2487, 3371, 0), "Pick up a barrel from the Orchard north of Ardougne.", this.emptyBarrel);
        this.useBarrelOnPile = new ObjectStep((QuestHelper)this, 8809, new WorldPoint(2487, 3374, 0), "Use the barrel on a rotten apple pile.", this.emptyBarrel);
        this.useBarrelOnPile.addIcon(3216);
        this.useApplesOnPress = new ObjectStep((QuestHelper)this, 8807, new WorldPoint(2484, 3374, 0), "Use the rotten apples on the apple press.", this.barrelOfRottenApples);
        this.useApplesOnPress.addIcon(6093);
        this.getNaphtha = new ObjectStep((QuestHelper)this, 4026, new WorldPoint(2927, 3212, 0), "Make some Naphtha. Grab another barrel, fill it on the swamp south of the elven lands, then refine it on the fractionalising still at the Chemist in Rimmington with 10-20 coal.", this.coal20OrNaphtha);
        this.getNaphtha.addText("To do this, rotate the 'Tar regulator' wheel twice. Wait until the 'Pressure' indicator is in the green, then rotate the 'Pressure valve' regulator clockwise once.");
        this.getNaphtha.addText("Now all you need to do is occasionally click the 'Add coal' text to add coal, to push the 'Heat' into the green. Be careful to do this slowly so as to not hit the orange heat and ruin the tar.");
        this.useNaphthaOnBarrel = new DetailedQuestStep((QuestHelper)this, "Use a barrel of naptha on the apple barrel.", this.naphtha, this.appleBarrel);
        this.useSieveOnBarrel = new DetailedQuestStep((QuestHelper)this, "Use the sieve on the naphtha apple mix", this.sieve, this.naphthaAppleMix);
        this.cookNaphtha = new ObjectStep((QuestHelper)this, 2859, new WorldPoint(2970, 3210, 0), "Cook the toxic naphtha on a range. DO NOT USE IT ON A FIRE.", this.toxicNaphtha);
        this.usePowderOnFood1 = new ObjectStep((QuestHelper)this, 37330, new WorldPoint(2517, 3315, 0), "Use the toxic powder on the food store in the room north west of West Ardougne's town centre.", this.toxicPowder);
        this.usePowderOnFood1.addIcon(6098);
        this.usePowderOnFood1.addTeleport(this.westArdougneTeleport);
        this.usePowderOnFood2 = new ObjectStep((QuestHelper)this, 37331, new WorldPoint(2525, 3288, 0), "Use the toxic powder on the food store in the church south of West Ardougne's town centre.", this.toxicPowder);
        this.usePowderOnFood2.addIcon(6098);
        this.enterMournerBaseAfterPoison = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Return to Essyllt in the Mourner HQ basement.", this.equippedMournerMask, this.equippedMournerBody, this.equippedMournerLegs, this.equippedMournerBoots, this.equippedMournerGloves, this.equippedMournerCloak);
        this.enterMournerBasementAfterPoison = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Return to Essyllt in the Mourner HQ basement.", new Requirement[0]);
        this.talkToEssylltAfterPoison = new NpcStep((QuestHelper)this, 9016, new WorldPoint(2043, 4631, 0), "Return to Essyllt in the Mourner HQ basement.", new Requirement[0]);
        this.talkToEssylltAfterPoison.addSubSteps(this.enterMournerBasementAfterPoison, this.enterMournerBaseAfterPoison);
        this.returnToArianwyn = new NpcStep((QuestHelper)this, 9014, new WorldPoint(2354, 3170, 0), "Return to Arianwyn in Lletya.", new Requirement[0]);
        this.returnToArianwyn.addTeleport(this.lletyaTeleport);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.bearFur, this.silk2, this.redDye, this.yellowDye, this.blueDye, this.greenDye, this.waterBucket, this.feather, this.rottenApple, this.toadCrunchies, this.magicLogs, this.leather, this.ogreBellows, this.coal20OrNaphtha);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.outpostTeleport, this.taverleyTeleport, this.lletyaTeleport, this.westArdougneTeleport.quantity(3));
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Mourner (level 11)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.ROVING_ELVES, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.SHEEP_HERDER, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.RANGED, 60));
        req.add(new SkillRequirement(Skill.THIEVING, 50));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.THIEVING, 40000), new ExperienceReward(Skill.HITPOINTS, 25000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Elven Teleport Crystal", 6099, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Mourner HQ"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToIslwyn, this.talkToArianwyn), new Requirement[0]));
        PanelDetails pickItemsPanel = new PanelDetails("Get Mourner's outfit", Arrays.asList(this.killMourner, this.pickUpLoot), null, Arrays.asList(this.outpostTeleport, this.taverleyTeleport));
        pickItemsPanel.setLockingStep(this.getItems);
        allSteps.add(pickItemsPanel);
        PanelDetails cleanPanel = new PanelDetails("Clean Mourner top", Arrays.asList(this.searchLaundry, this.useSoapOnTop), Arrays.asList(this.waterBucket), Arrays.asList(this.taverleyTeleport, this.lletyaTeleport));
        cleanPanel.setLockingStep(this.cleanTopSteps);
        PanelDetails repairPanel = new PanelDetails("Repair Mourner trousers", Collections.singletonList(this.talkToOronwen), Arrays.asList(this.bearFur, this.silk2), Arrays.asList(this.lletyaTeleport));
        repairPanel.setLockingStep(this.repairTrousersSteps);
        allSteps.add(cleanPanel);
        allSteps.add(repairPanel);
        PanelDetails enterWestArdougnePanel = new PanelDetails("Infiltrate the Mourners", Arrays.asList(this.enterMournerBase, this.enterBasement, this.talkToEssyllt, this.talkToGnome, this.useFeatherOnGnome, this.talkToGnomeWithItems, this.releaseGnome, this.giveGnomeItems, this.askAboutToads), Arrays.asList(this.fullMourners, this.mournerLetter, this.feather, this.toadCrunchies, this.magicLogs, this.leather), Arrays.asList(this.westArdougneTeleport));
        allSteps.add(enterWestArdougnePanel);
        allSteps.add(new PanelDetails("Dye the sheep", Arrays.asList(this.getToads, this.dyeSheep, this.enterBaseAfterSheep, this.enterBasementAfterSheep, this.talkToEssylltAfterSheep), this.fixedDevice, this.ogreBellows, this.redDye, this.yellowDye, this.greenDye, this.blueDye));
        allSteps.add(new PanelDetails("Poison the citizens", Arrays.asList(this.pickUpRottenApple, this.talkToElena, this.pickUpBarrel, this.useBarrelOnPile, this.useApplesOnPress, this.getNaphtha, this.useNaphthaOnBarrel, this.useSieveOnBarrel, this.cookNaphtha, this.usePowderOnFood1, this.usePowderOnFood2, this.talkToEssylltAfterPoison), Arrays.asList(this.coal20OrNaphtha, this.fullMourners), Arrays.asList(this.westArdougneTeleport, this.lletyaTeleport)));
        allSteps.add(new PanelDetails("Report back to Arianwyn", Collections.singletonList(this.returnToArianwyn), new Requirement[0]));
        return allSteps;
    }
}

