/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.mountaindaughter;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MOUNTAIN_DAUGHTER)
public class MountainDaughter
extends BasicQuestHelper {
    private ItemRequirement axe;
    private ItemRequirement pickaxe;
    private ItemRequirement whitePearl;
    private ItemRequirement whitePearlSeed;
    private ItemRequirement mud;
    private ItemRequirement plank;
    private ItemRequirement muddyRocks;
    private ItemRequirement safetyGuarantee;
    private ItemRequirement halfRock;
    private ItemRequirement gloves;
    private ItemRequirement corpse;
    private ItemRequirement pole;
    private ItemRequirement rope;
    private ItemRequirement rocks;
    private ItemRequirement necklace;
    private ItemRequirement slayerRing;
    private ItemRequirement combatGear;
    private Requirement onIsland1;
    private Requirement onIsland2;
    private Requirement onIsland3;
    private Requirement inTheCamp;
    private Requirement askedAboutDiplomacy;
    private Requirement askedAboutFoodAndDiplomacy;
    private Requirement spokenToSvidi;
    private Requirement spokenToBrundt;
    private Requirement minedRock;
    private Requirement gottenGuarantee;
    private Requirement givenGuaranteeToSvidi;
    private Requirement finishedDiplomacy;
    private Requirement finishedFood;
    private Requirement finishedFoodAndDiplomacy;
    private Requirement inKendalCave;
    private Requirement fightableKendalNearby;
    private Requirement hasBuried;
    private Requirement rubbedMudIntoTree;
    private QuestStep enterCamp;
    private QuestStep enterCampOverRocks;
    private QuestStep talkToHamal;
    private QuestStep digUpMud;
    private QuestStep rubMudIntoTree;
    private QuestStep climbTree;
    private QuestStep poleVaultRocks;
    private QuestStep plankRocks;
    private QuestStep listenToSpirit;
    private QuestStep plankRocksReturn;
    private QuestStep talkToHamalAfterSpirit;
    private QuestStep talkToJokul;
    private QuestStep talkToSvidi;
    private QuestStep speakToBrundt;
    private QuestStep getRockFragment;
    private QuestStep returnToBrundt;
    private QuestStep returnToSvidi;
    private QuestStep getFruit;
    private QuestStep eatFruit;
    private QuestStep returnToSpirit;
    private QuestStep returnToHamalAboutFood;
    private QuestStep returnToHamalAboutDiplomacy;
    private QuestStep talkToKendal;
    private QuestStep killKendal;
    private QuestStep noPlankRocksReturn;
    private QuestStep enterCave;
    private QuestStep grabCorpse;
    private QuestStep bringCorpseToHamal;
    private QuestStep collectRocks;
    private QuestStep createCairn;
    private QuestStep buryCorpseOnIsland;
    private QuestStep speakRagnar;
    private Zone CAMP_ZONE_1;
    private Zone CAMP_ZONE_2;
    private Zone CAMP_ZONE_3;
    private Zone LAKE_ISLAND_1;
    private Zone LAKE_ISLAND_2;
    private Zone LAKE_ISLAND_3;
    private Zone KENDAL_CAVE;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.loadConditions();
        this.loadQuestSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep enteringTheCamp = new ConditionalStep((QuestHelper)this, this.enterCamp, new Requirement[0]);
        enteringTheCamp.addStep(this.inTheCamp, this.talkToHamal);
        steps.put(0, enteringTheCamp);
        ConditionalStep speakToSpirit = new ConditionalStep((QuestHelper)this, this.enterCampOverRocks, new Requirement[0]);
        speakToSpirit.addStep(this.onIsland3, this.listenToSpirit);
        speakToSpirit.addStep(this.onIsland2, this.plankRocks);
        speakToSpirit.addStep(this.onIsland1, this.poleVaultRocks);
        speakToSpirit.addStep(new Conditions(this.inTheCamp, this.rubbedMudIntoTree), this.climbTree);
        speakToSpirit.addStep(new Conditions(this.inTheCamp, this.mud), this.rubMudIntoTree);
        speakToSpirit.addStep(this.inTheCamp, this.digUpMud);
        steps.put(10, speakToSpirit);
        ConditionalStep helpTheCamp = new ConditionalStep((QuestHelper)this, this.enterCampOverRocks, new Requirement[0]);
        helpTheCamp.addStep(this.finishedFoodAndDiplomacy, this.returnToSpirit);
        helpTheCamp.addStep(new Conditions(this.givenGuaranteeToSvidi, this.finishedFood), this.returnToHamalAboutDiplomacy);
        helpTheCamp.addStep(new Conditions(this.givenGuaranteeToSvidi, this.whitePearlSeed.alsoCheckBank(this.questBank)), this.returnToHamalAboutFood);
        helpTheCamp.addStep(new Conditions(this.givenGuaranteeToSvidi, this.whitePearl.alsoCheckBank(this.questBank)), this.eatFruit);
        helpTheCamp.addStep(this.givenGuaranteeToSvidi, this.getFruit);
        helpTheCamp.addStep(this.gottenGuarantee, this.returnToSvidi);
        helpTheCamp.addStep(this.minedRock, this.returnToBrundt);
        helpTheCamp.addStep(this.spokenToBrundt, this.getRockFragment);
        helpTheCamp.addStep(this.spokenToSvidi, this.speakToBrundt);
        helpTheCamp.addStep(this.askedAboutFoodAndDiplomacy, this.talkToSvidi);
        helpTheCamp.addStep(this.askedAboutDiplomacy, this.talkToJokul);
        helpTheCamp.addStep(this.onIsland3, this.plankRocksReturn);
        helpTheCamp.addStep(this.inTheCamp, this.talkToHamalAfterSpirit);
        steps.put(20, helpTheCamp);
        ConditionalStep talkKendal = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        talkKendal.addStep(this.onIsland3, this.noPlankRocksReturn);
        talkKendal.addStep(this.inKendalCave, this.talkToKendal);
        steps.put(30, talkKendal);
        ConditionalStep killKendalStep = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        killKendalStep.addStep(this.fightableKendalNearby, this.killKendal);
        killKendalStep.addStep(this.inKendalCave, this.talkToKendal);
        steps.put(40, killKendalStep);
        ConditionalStep returnTheCorpse = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        returnTheCorpse.addStep(this.corpse.alsoCheckBank(this.questBank), this.bringCorpseToHamal);
        returnTheCorpse.addStep(this.inKendalCave, this.grabCorpse);
        steps.put(50, returnTheCorpse);
        ConditionalStep buryCorpse = new ConditionalStep((QuestHelper)this, this.enterCampOverRocks, new Requirement[0]);
        buryCorpse.addStep(this.hasBuried, this.createCairn);
        buryCorpse.addStep(this.necklace.alsoCheckBank(this.questBank), this.buryCorpseOnIsland);
        buryCorpse.addStep(this.rocks.alsoCheckBank(this.questBank), this.speakRagnar);
        buryCorpse.addStep(this.inTheCamp, this.collectRocks);
        steps.put(60, buryCorpse);
        return steps;
    }

    private void loadZones() {
        this.CAMP_ZONE_1 = new Zone(new WorldPoint(2758, 3660, 0), new WorldPoint(2821, 3664, 0));
        this.CAMP_ZONE_2 = new Zone(new WorldPoint(2767, 3653, 0), new WorldPoint(2821, 3712, 0));
        this.CAMP_ZONE_3 = new Zone(new WorldPoint(2751, 3671, 0), new WorldPoint(2767, 3712, 0));
        this.LAKE_ISLAND_1 = new Zone(new WorldPoint(2770, 3681, 0), new WorldPoint(2775, 3688, 0));
        this.LAKE_ISLAND_2 = new Zone(new WorldPoint(2770, 3689, 0), new WorldPoint(2776, 3694, 0));
        this.LAKE_ISLAND_3 = new Zone(new WorldPoint(2776, 3688, 0), new WorldPoint(2787, 3698, 0));
        this.KENDAL_CAVE = new Zone(new WorldPoint(2828, 10118, 0), new WorldPoint(2746, 10047, 0));
    }

    @Override
    public void setupRequirements() {
        this.rope = new ItemRequirement("Rope", 954);
        this.pickaxe = new ItemRequirement("Any pickaxe", 1265).isNotConsumed();
        this.pickaxe.addAlternates(ItemCollections.PICKAXES);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.plank = new ItemRequirement("Any plank", 960).isNotConsumed();
        this.plank.addAlternates(8778, 8780, 8782);
        this.pole = new ItemRequirement("A staff or a pole", 4494).isNotConsumed();
        this.pole.addAlternates(9084, 1379, 1391);
        this.pole.addAlternates(ItemCollections.AIR_STAFF);
        this.pole.addAlternates(ItemCollections.WATER_STAFF);
        this.pole.addAlternates(ItemCollections.EARTH_STAFF);
        this.pole.addAlternates(ItemCollections.FIRE_STAFF);
        this.pole.setTooltip("A Dramen Staff will NOT work. A pole can be obtained from the goat pen north of Hamal's house.");
        this.gloves = new ItemRequirement("Almost any gloves", 1059).isNotConsumed();
        this.gloves.addAlternates(7462, 7461, 7460, 7459, 7458, 7457, 7456, 7455, 7454, 7453, 22981, 11858, 21736);
        this.gloves.setTooltip("You can use most other gloves, with a few exceptions (Slayer, Mystic, Ranger, Moonclan, Lunar, Infinity, vambraces).");
        this.mud = new ItemRequirement("Mud", 4490);
        this.mud.setTooltip("You can get some mud from the mud pool south of Hamal's tent.");
        this.halfRock = new ItemRequirement("Half a rock", 4487);
        this.halfRock.setTooltip("You can get another piece by using a pickaxe on the Ancient Rock in the Mountain Camp.");
        this.safetyGuarantee = new ItemRequirement("Safety Guarantee", 4484);
        this.safetyGuarantee.setTooltip("You can get another guarantee from Brundt in Rellekka's longhall.");
        this.whitePearl = new ItemRequirement("White pearl", 4485);
        this.whitePearlSeed = new ItemRequirement("White pearl seed", 4486);
        this.corpse = new ItemRequirement("Corpse of woman", 4488);
        this.corpse.setTooltip("You can find this corpse again in the Kendal's cave.");
        this.muddyRocks = new ItemRequirement("Muddy rock", 4492, 5);
        this.slayerRing = new ItemRequirement("Slayer ring for teleports", ItemCollections.SLAYER_RINGS);
        this.combatGear = new ItemRequirement("Combat gear for The Kendal fight", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.rocks = new ItemRequirement("Muddy rock", 4492);
        this.necklace = new ItemRequirement("Asleif's necklace", 4489);
    }

    private void loadConditions() {
        this.onIsland1 = new Conditions(new ZoneRequirement(this.LAKE_ISLAND_1));
        this.onIsland2 = new Conditions(new ZoneRequirement(this.LAKE_ISLAND_2));
        this.onIsland3 = new Conditions(new ZoneRequirement(this.LAKE_ISLAND_3));
        this.inTheCamp = new Conditions(new ZoneRequirement(this.CAMP_ZONE_1, this.CAMP_ZONE_2, this.CAMP_ZONE_3));
        this.askedAboutDiplomacy = new Conditions(new VarbitRequirement(262, 10));
        this.rubbedMudIntoTree = new Conditions(new VarbitRequirement(261, 1));
        VarbitRequirement askedAboutFood = new VarbitRequirement(263, 10, Operation.GREATER_EQUAL);
        this.askedAboutFoodAndDiplomacy = new Conditions(new VarbitRequirement(262, 10), askedAboutFood);
        this.spokenToSvidi = new Conditions(new VarbitRequirement(262, 20), askedAboutFood);
        this.spokenToBrundt = new Conditions(new VarbitRequirement(262, 30), askedAboutFood);
        this.minedRock = new Conditions(new VarbitRequirement(262, 40), askedAboutFood);
        this.gottenGuarantee = new Conditions(new VarbitRequirement(262, 50), askedAboutFood);
        this.givenGuaranteeToSvidi = new Conditions(new VarbitRequirement(262, 60), askedAboutFood);
        this.finishedDiplomacy = new Conditions(new VarbitRequirement(266, 1));
        this.finishedFood = new VarbitRequirement(263, 20);
        this.finishedFoodAndDiplomacy = new Conditions(this.finishedDiplomacy, this.finishedFood);
        this.inKendalCave = new Conditions(new ZoneRequirement(this.KENDAL_CAVE));
        this.fightableKendalNearby = new Conditions(new NpcHintArrowRequirement(1378));
        this.hasBuried = new Conditions(new VarbitRequirement(273, 1));
    }

    private void loadQuestSteps() {
        this.enterCamp = new ObjectStep((QuestHelper)this, 5842, new WorldPoint(2766, 3667, 0), "Use your rope on the boulder outside the Mountain Camp east of Rellekka.", this.rope.highlighted());
        this.enterCamp.addIcon(954);
        this.enterCampOverRocks = new ObjectStep((QuestHelper)this, 5847, new WorldPoint(2760, 3658, 0), "Return to the Mountain Camp.", this.rope.highlighted());
        this.talkToHamal = new NpcStep((QuestHelper)this, 1373, new WorldPoint(2810, 3672, 0), "Speak to Hamal the Chieftain in the Mountain Camp.", this.rope, this.pickaxe, this.axe, this.plank, this.pole, this.gloves);
        this.talkToHamal.addDialogStep("Why is everyone so hostile?");
        this.talkToHamal.addDialogStep("So what are you doing up here?");
        this.talkToHamal.addDialogStep("I will search for her!");
        this.digUpMud = new ObjectStep((QuestHelper)this, 5885, new WorldPoint(2805, 3661, 0), "If you did not bring a staff grab a pole from the goat pen north of Hamal's house. Head south of Hamal's house and dig some mud from the mud pond.", new Requirement[0]);
        this.rubMudIntoTree = new ObjectStep((QuestHelper)this, 5848, new WorldPoint(2772, 3681, 0), "Use mud on the Tall Tree on the lake north of the camp, and then climb it.", this.mud.highlighted(), this.pole, this.plank);
        this.rubMudIntoTree.addIcon(4490);
        this.climbTree = new ObjectStep((QuestHelper)this, 5848, new WorldPoint(2772, 3681, 0), "Climb the Tall Tree on the lake north of the camp.", this.pole, this.plank);
        this.poleVaultRocks = new ObjectStep((QuestHelper)this, 5849, new WorldPoint(2773, 3688, 0), "Use your pole or a staff on the clump of rocks.", this.pole, this.plank);
        this.poleVaultRocks.addIcon(4494);
        this.plankRocks = new ObjectStep((QuestHelper)this, 5850, new WorldPoint(2775, 3691, 0), "Use a plank on the flat stone.", this.plank);
        this.plankRocks.addIcon(960);
        this.listenToSpirit = new ObjectStep((QuestHelper)this, 5897, new WorldPoint(2781, 3689, 0), "Listen to the Shining Pool.", new Requirement[0]);
        this.listenToSpirit.addDialogStep("Hello! Who are you?");
        this.listenToSpirit.addDialogStep("So what exactly do you want from me?");
        this.listenToSpirit.addDialogStep("That sounds like something I can do.");
        this.listenToSpirit.addDialogStep("I'll get right on it.");
        this.plankRocksReturn = new ObjectStep((QuestHelper)this, 5851, new WorldPoint(2777, 3691, 0), "Use a plank on the flat stone to return to shore.", this.plank);
        this.plankRocksReturn.addDialogStep("Yes.");
        this.plankRocksReturn.addIcon(960);
        this.talkToHamalAfterSpirit = new NpcStep((QuestHelper)this, 1373, new WorldPoint(2810, 3672, 0), "Speak to Hamal the Chieftain in the Mountain Camp.", this.rope, this.pickaxe, this.axe, this.plank, this.pole, this.gloves);
        this.talkToHamalAfterSpirit.addDialogStep("About the people of Rellekka...");
        this.talkToJokul = new NpcStep((QuestHelper)this, 1376, new WorldPoint(2812, 3680, 0), "Speak to Jokul north of Hamal's tent.", new Requirement[0]);
        this.talkToSvidi = new NpcStep((QuestHelper)this, 1375, new WorldPoint(2717, 3666, 0), "Speak to Svidi who roams in the forest east of Rellekka.", this.pickaxe);
        this.talkToSvidi.addDialogStep("Can't I persuade you to go in there somehow?");
        this.speakToBrundt = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Speak to Brundt the Chieftain in the Rellekka's longhall.", this.rope, this.pickaxe, this.axe, this.plank, this.pole, this.gloves);
        this.speakToBrundt.addDialogStep("Ask about the mountain camp.");
        this.speakToBrundt.addDialogStep("Did it look pretty?");
        this.getRockFragment = new ObjectStep((QuestHelper)this, 5895, new WorldPoint(2799, 3660, 0), "Use a pickaxe on the Ancient Rock in the Mountain Camp.", this.pickaxe);
        this.getRockFragment.addIcon(1265);
        this.returnToBrundt = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Return to Brundt the Chieftain in the Rellekka's longhall.", this.halfRock);
        this.returnToBrundt.addDialogStep("Ask about the mountain camp.");
        this.returnToSvidi = new NpcStep((QuestHelper)this, 1375, new WorldPoint(2717, 3666, 0), "Return to Svidi who roams in the forest east of Rellekka.", this.safetyGuarantee);
        this.getFruit = new ObjectStep((QuestHelper)this, 5856, new WorldPoint(2849, 3497, 0), "Go to the top of White Wolf Mountain and pick the Thorny Bushes whilst wearing gloves.", this.gloves);
        this.eatFruit = new DetailedQuestStep((QuestHelper)this, "Eat the White Pearl.", this.whitePearl.highlighted());
        this.returnToHamalAboutDiplomacy = new NpcStep((QuestHelper)this, 1373, new WorldPoint(2810, 3672, 0), "Return to Hamal the Chieftain in the Mountain Camp.", this.whitePearlSeed);
        this.returnToHamalAboutDiplomacy.addDialogStep("About the people of Rellekka...");
        this.returnToHamalAboutFood = new NpcStep((QuestHelper)this, 1373, new WorldPoint(2810, 3672, 0), "Return to Hamal the Chieftain in the Mountain Camp.", this.whitePearlSeed);
        this.returnToHamalAboutFood.addDialogStep("About your food supplies...");
        this.returnToHamalAboutDiplomacy.addSubSteps(this.returnToHamalAboutFood);
        this.returnToSpirit = new ObjectStep((QuestHelper)this, 5897, new WorldPoint(2781, 3689, 0), "Return to the centre of the pool north of the Mountain Camp and listen to it.", this.pole, this.plank);
        this.noPlankRocksReturn = new ObjectStep((QuestHelper)this, 5851, new WorldPoint(2777, 3691, 0), "Attempt to jump across the flat stone WITHOUT a plank to return to the north shore.", new Requirement[0]);
        this.enterCave = new ObjectStep((QuestHelper)this, 5857, new WorldPoint(2809, 3703, 0), "Cut through the trees north east of the lake and enter the cave there. Bring combat gear.", this.axe);
        this.talkToKendal = new NpcStep((QuestHelper)this, 1377, new WorldPoint(2788, 10081, 0), "Speak to the Kendal, then kill him.", new Requirement[0]);
        this.talkToKendal.addDialogStep("It's just me, no one special.");
        this.talkToKendal.addDialogStep("You mean a sacrifice?");
        this.talkToKendal.addDialogStep("You look like a man in a bearsuit!");
        this.talkToKendal.addDialogStep("Can I see that corpse?");
        this.talkToKendal.addDialogStep("I humbly request to be given the remains.");
        this.talkToKendal.addDialogStep("I will kill you myself!");
        this.killKendal = new NpcStep((QuestHelper)this, 1377, new WorldPoint(2788, 10081, 0), "Kill the kendal.", new Requirement[0]);
        this.talkToKendal.addSubSteps(this.killKendal);
        this.grabCorpse = new TileStep((QuestHelper)this, new WorldPoint(2784, 10078, 0), "Pick up the Corpse of Woman.", new Requirement[0]);
        this.bringCorpseToHamal = new NpcStep((QuestHelper)this, 1373, new WorldPoint(2810, 3672, 0), "Bring the corpse to Hamal.", this.corpse);
        this.bringCorpseToHamal.addDialogStep("But he's not a god!");
        this.bringCorpseToHamal.addDialogStep("I will.");
        this.collectRocks = new DetailedQuestStep((QuestHelper)this, "Collect 5 Muddy Rocks from around the camp.", this.muddyRocks);
        this.speakRagnar = new NpcStep((QuestHelper)this, 1374, new WorldPoint(2766, 3676, 0), "Speak to Ragnar.", this.corpse, this.muddyRocks);
        this.speakRagnar.addDialogStep("Thank you. I will make sure she's given a proper burial now.");
        this.buryCorpseOnIsland = new TileStep((QuestHelper)this, new WorldPoint(2782, 3694, 0), "Return to the centre of the lake and bury the corpse.", this.corpse, this.pole, this.plank);
        this.createCairn = new ObjectStep((QuestHelper)this, 5862, new WorldPoint(2783, 3694, 0), "Use the Muddy rocks on the Burial Mound at the centre of the Mountain Camp's lake.", this.muddyRocks);
        this.createCairn.addIcon(4492);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.rope);
        reqs.add(this.pickaxe);
        reqs.add(this.axe);
        reqs.add(this.plank);
        reqs.add(this.gloves);
        reqs.add(this.pole);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.slayerRing, this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("The Kendal (level 70)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.AGILITY, 20, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.ATTACK, 1000), new ExperienceReward(Skill.PRAYER, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Bearhead", 4502, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Mountain Camp"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Speak to Hamal", Arrays.asList(this.enterCamp, this.talkToHamal), this.rope, this.plank, this.pickaxe));
        allSteps.add(new PanelDetails("Go to the centre of the lake", Arrays.asList(this.digUpMud, this.rubMudIntoTree, this.climbTree, this.poleVaultRocks, this.plankRocks, this.listenToSpirit), new Requirement[0]));
        allSteps.add(new PanelDetails("Find out how to help", Arrays.asList(this.talkToHamalAfterSpirit, this.talkToJokul), new Requirement[0]));
        allSteps.add(new PanelDetails("Making peace with Rellekka", Arrays.asList(this.talkToSvidi, this.speakToBrundt, this.getRockFragment, this.returnToBrundt, this.returnToSvidi), new Requirement[0]));
        allSteps.add(new PanelDetails("Find a new food source", Arrays.asList(this.getFruit, this.eatFruit), this.axe, this.gloves));
        allSteps.add(new PanelDetails("Prepare for a fight", Collections.singletonList(new DetailedQuestStep((QuestHelper)this, "Prepare to fight The Kendal (level 70)", new Requirement[0])), this.pole, this.plank, this.axe, this.whitePearlSeed));
        allSteps.add(new PanelDetails("Tell Hamal about your success", Collections.singletonList(this.returnToHamalAboutDiplomacy), new Requirement[0]));
        allSteps.add(new PanelDetails("Tell Asleif about your success", Collections.singletonList(this.returnToSpirit), new Requirement[0]));
        allSteps.add(new PanelDetails("Find Asleif's corpse", Arrays.asList(this.enterCave, this.talkToKendal, this.grabCorpse), new Requirement[0]));
        allSteps.add(new PanelDetails("Bring Asleif's corpse to Hamal", Collections.singletonList(this.bringCorpseToHamal), new Requirement[0]));
        allSteps.add(new PanelDetails("Bury Asleif", Arrays.asList(this.collectRocks, this.speakRagnar, this.buryCorpseOnIsland, this.createCairn), new Requirement[0]));
        return allSteps;
    }
}

