/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.monksfriend;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MONKS_FRIEND)
public class MonksFriend
extends BasicQuestHelper {
    ItemRequirement jugOfWater;
    ItemRequirement log;
    ItemRequirement blanket;
    ItemRequirement ardougneCloak;
    Requirement inDungeon;
    QuestStep talkToOmad;
    QuestStep goDownLadder;
    QuestStep grabBlanket;
    QuestStep goUpLadder;
    QuestStep returnToOmadWithBlanket;
    QuestStep talkToOmadAgain;
    QuestStep talkToCedric;
    QuestStep talkToCedricWithJug;
    QuestStep continueTalkingToCedric;
    QuestStep talkToCedricWithLog;
    QuestStep finishQuest;
    Zone dungeon;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToOmad);
        ConditionalStep getBlanket = new ConditionalStep((QuestHelper)this, this.goDownLadder, new Requirement[0]);
        getBlanket.addStep(new Conditions(this.inDungeon, this.blanket.alsoCheckBank(this.questBank)), this.goUpLadder);
        getBlanket.addStep(this.blanket.alsoCheckBank(this.questBank), this.returnToOmadWithBlanket);
        getBlanket.addStep(this.inDungeon, this.grabBlanket);
        steps.put(10, getBlanket);
        steps.put(20, this.talkToOmadAgain);
        steps.put(30, this.talkToCedric);
        steps.put(40, this.talkToCedricWithJug);
        steps.put(50, this.continueTalkingToCedric);
        steps.put(60, this.talkToCedricWithLog);
        steps.put(70, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.log = new ItemRequirement("Logs", 1511);
        this.jugOfWater = new ItemRequirement("Jug of Water", 1937);
        this.blanket = new ItemRequirement("Child's blanket", 90);
        this.ardougneCloak = new ItemRequirement("Ardougne cloak 1 or higher for teleports to the monastery", 770).isNotConsumed();
    }

    public void loadZones() {
        this.dungeon = new Zone(new WorldPoint(2559, 9597, 0), new WorldPoint(2582, 9623, 0));
    }

    public void setupConditions() {
        this.inDungeon = new ZoneRequirement(this.dungeon);
    }

    public void setupSteps() {
        this.talkToOmad = new NpcStep((QuestHelper)this, 4244, new WorldPoint(2607, 3211, 0), "Talk to Brother Omad in the monastery south of West Ardougne.", new Requirement[0]);
        this.talkToOmad.addDialogStep("Why can't you sleep, what's wrong?");
        this.talkToOmad.addDialogStep("Can I help at all?");
        this.goDownLadder = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2561, 3222, 0), "Go down the ladder in a circle of stones west of the monastery.", new Requirement[0]);
        this.grabBlanket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2570, 9604, 0), "Pick up the Child's blanket in the room to the south.", this.blanket);
        this.goUpLadder = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2561, 9622, 0), "Go back up the ladder.", new Requirement[0]);
        this.returnToOmadWithBlanket = new NpcStep((QuestHelper)this, 4244, new WorldPoint(2607, 3211, 0), "Bring the blanket back to Brother Omad.", this.blanket);
        this.talkToOmadAgain = new NpcStep((QuestHelper)this, 4244, new WorldPoint(2607, 3211, 0), "Talk to Brother Omad again.", new Requirement[0]);
        this.talkToOmadAgain.addDialogStep("Is there anything else I can help with?");
        this.talkToOmadAgain.addDialogStep("Who's Brother Cedric?");
        this.talkToOmadAgain.addDialogStep("Where should I look?");
        this.talkToCedric = new NpcStep((QuestHelper)this, 4245, new WorldPoint(2614, 3258, 0), "Talk to Brother Cedric north of the monastery.", new Requirement[0]);
        this.talkToCedricWithJug = new NpcStep((QuestHelper)this, 4245, new WorldPoint(2614, 3258, 0), "Talk to Brother Cedric again.", this.jugOfWater);
        this.talkToCedricWithJug.addDialogStep("Yes, I'd be happy to!");
        this.continueTalkingToCedric = new NpcStep((QuestHelper)this, 4245, new WorldPoint(2614, 3258, 0), "Talk to Brother Cedric again.", new Requirement[0]);
        this.talkToCedricWithJug.addSubSteps(this.continueTalkingToCedric);
        this.talkToCedricWithLog = new NpcStep((QuestHelper)this, 4245, new WorldPoint(2614, 3258, 0), "Talk to Brother Cedric once again with logs.", this.log);
        this.finishQuest = new NpcStep((QuestHelper)this, 4244, new WorldPoint(2607, 3211, 0), "Return to Brother Omad to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.jugOfWater);
        reqs.add(this.log);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.ardougneCloak);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.WOODCUTTING, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Law Runes", 563, 8));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToOmad), this.jugOfWater, this.log));
        allSteps.add(new PanelDetails("Finding the blanket", Arrays.asList(this.goDownLadder, this.grabBlanket, this.goUpLadder, this.returnToOmadWithBlanket), new Requirement[0]));
        allSteps.add(new PanelDetails("Help Cedric", Arrays.asList(this.talkToOmadAgain, this.talkToCedric, this.talkToCedricWithJug, this.talkToCedricWithLog, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

