/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.monkeymadnessii;

import com.questhelper.helpers.quests.monkeymadnessii.MM2AgilityNodes;
import com.questhelper.helpers.quests.monkeymadnessii.MM2Route;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class AgilityDungeonSteps
extends DetailedOwnerStep {
    final int MAX_DEPTH = 20;
    WorldPoint lastPosition = new WorldPoint(0, 0, 0);
    DetailedQuestStep traverseDungeonFirstSection;
    DetailedQuestStep getKey;
    DetailedQuestStep openBronzeDoor;
    DetailedQuestStep traverseDungeonThirdSection;
    DetailedQuestStep openShortcut;
    DetailedQuestStep goToKruk;
    DetailedQuestStep enterShortcut;
    DetailedQuestStep fightKruk;
    DetailedQuestStep leaveFallArea1;
    DetailedQuestStep leaveFallArea2;
    DetailedQuestStep leaveFallArea3;
    DetailedQuestStep leaveFallArea4;
    ItemRequirement bronzeKey;
    Requirement protectFromRanged;
    Requirement protectFromMelee;
    List<WorldPoint> path1V1;
    List<WorldPoint> path1V2;
    List<WorldPoint> pathConnectingPath1V2ToV1;
    List<WorldPoint> pathConnectingPath1V1ToV2;
    List<WorldPoint> path2V1;
    List<WorldPoint> path2V2;
    List<WorldPoint> pathMaze;
    List<WorldPoint> path3V1;
    List<WorldPoint> path3V2;
    List<WorldPoint> pathToChest;
    List<WorldPoint> pathFromChest;
    List<WorldPoint> pathToDoor;
    List<WorldPoint> path4V1;
    List<WorldPoint> path4V2;
    List<WorldPoint> path5V1;
    List<WorldPoint> path5V2;
    List<WorldPoint> path5V3;
    List<WorldPoint> firstHalfSection5Path;
    List<WorldPoint> pathToShortcutV1;
    List<WorldPoint> pathToShortcutV2;
    List<WorldPoint> pathToKrukV1;
    List<WorldPoint> pathToKrukV2;
    Zone fallArea1;
    Zone fallArea2;
    Zone fallArea3;
    Zone fallArea4;
    Zone fallArea4P2;
    Zone cavesSection2;
    Zone cavesSection2P2;
    Zone cavesSection3;
    Zone cavesSection3P2;
    Zone cavesSection4P1;
    Zone cavesSection4P2;
    Zone cavesSection4P3;
    Zone krukRoom;
    Requirement inCavesSection2;
    Requirement inCavesSection3;
    Requirement inCavesSection4;
    Requirement hasBronzeKey;
    Requirement inFallArea1;
    Requirement inFallArea2;
    Requirement inFallArea3;
    Requirement inFallArea4;
    Requirement inKrukRoom;
    Requirement openedShortcut;
    ChatMessageRequirement path1SouthIsWrongChat;
    ChatMessageRequirement path2NorthIsWrongChat;
    ChatMessageRequirement path2NorthIsWrongChat2;
    ChatMessageRequirement path3SouthIsWrongChat;
    ChatMessageRequirement path4NorthIsWrongChat;
    ChatMessageRequirement path5WestIsWrongChat;
    ChatMessageRequirement path5MiddleIsWrongChat;
    ChatMessageRequirement path5EastIsWrongChat;
    ChatMessageRequirement path5WestToMiddleWrongChat;
    ChatMessageRequirement path5MiddleToWestWrongChat;
    ChatMessageRequirement path5MiddleToEastWrongChat;
    ChatMessageRequirement path5EastToMiddleWrongChat;
    ChatMessageRequirement path6WestIsWrongChat;
    Conditions path1SouthIsWrong;
    Conditions path2NorthIsWrong;
    Conditions path3SouthIsWrong;
    Conditions path4NorthIsWrong;
    Conditions path5WestIsWrong;
    Conditions path5MiddleIsWrong;
    Conditions path5EastIsWrong;
    Conditions path6WestIsWrong;
    HashMap<MM2Route, RuneliteRequirement> routeSavedValues;
    MM2AgilityNodes[] fifthSectionMap;
    int[] fifthSectionRightPaths;
    RuneliteRequirement shouldUsePath1V2;
    RuneliteRequirement shouldUsePath2V2;
    RuneliteRequirement shouldUsePath3V2;
    RuneliteRequirement shouldUsePath4V2;
    RuneliteRequirement shouldntUsePath5V1;
    RuneliteRequirement shouldntUsePath5V2;
    RuneliteRequirement shouldntUsePath5V3;
    RuneliteRequirement shouldUsePath6V2;

    public AgilityDungeonSteps(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
        this.updateSection1Route();
        this.updateSection2Route();
        this.updateSection3Route();
    }

    public void setupRequirements() {
        this.bronzeKey = new ItemRequirement("Bronze key", 19566);
        this.protectFromMelee = new PrayerRequirement("Protect from Melee", Prayer.PROTECT_FROM_MELEE);
        this.protectFromRanged = new PrayerRequirement("Protect from Missiles", Prayer.PROTECT_FROM_MISSILES);
    }

    public void setupZones() {
        this.fallArea1 = new Zone(new WorldPoint(2306, 9126, 1), new WorldPoint(2376, 9188, 1));
        this.fallArea2 = new Zone(new WorldPoint(2378, 9153, 1), new WorldPoint(2454, 9187, 1));
        this.fallArea3 = new Zone(new WorldPoint(2375, 9188, 1), new WorldPoint(2423, 9264, 1));
        this.fallArea4 = new Zone(new WorldPoint(2334, 9223, 1), new WorldPoint(2374, 9277, 1));
        this.fallArea4P2 = new Zone(new WorldPoint(2375, 9265, 1), new WorldPoint(2425, 9279, 1));
        this.cavesSection2 = new Zone(new WorldPoint(2621, 9153, 1), new WorldPoint(2653, 9189, 1));
        this.cavesSection2P2 = new Zone(new WorldPoint(2611, 9187, 1), new WorldPoint(2620, 9196, 1));
        this.cavesSection3 = new Zone(new WorldPoint(2565, 9188, 1), new WorldPoint(2610, 9265, 1));
        this.cavesSection3P2 = new Zone(new WorldPoint(2611, 9243, 1), new WorldPoint(2616, 9254, 1));
        this.cavesSection4P1 = new Zone(new WorldPoint(2556, 9266, 1), new WorldPoint(2640, 9278, 1));
        this.cavesSection4P2 = new Zone(new WorldPoint(2528, 9228, 1), new WorldPoint(2565, 9265, 1));
        this.cavesSection4P3 = new Zone(new WorldPoint(2542, 9226, 1), new WorldPoint(2550, 9227, 1));
        this.krukRoom = new Zone(new WorldPoint(2518, 9202, 1), new WorldPoint(2548, 9227, 1));
    }

    public void setupConditions() {
        this.inFallArea1 = new ZoneRequirement(this.fallArea1);
        this.inFallArea2 = new ZoneRequirement(this.fallArea2);
        this.inFallArea3 = new ZoneRequirement(this.fallArea3);
        this.inFallArea4 = new ZoneRequirement(this.fallArea4, this.fallArea4P2);
        this.inCavesSection2 = new ZoneRequirement(this.cavesSection2, this.cavesSection2P2);
        this.inCavesSection3 = new ZoneRequirement(this.cavesSection3, this.cavesSection3P2);
        this.inCavesSection4 = new ZoneRequirement(this.cavesSection4P1, this.cavesSection4P2, this.cavesSection4P3);
        this.inKrukRoom = new ZoneRequirement(this.krukRoom);
        this.hasBronzeKey = this.bronzeKey;
        this.openedShortcut = new VarbitRequirement(5029, 1);
        this.path1SouthIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2512, 9141, 1), new WorldPoint(2515, 9135, 1))), "Something about this route feels wrong.");
        this.path1SouthIsWrong = new Conditions(true, LogicType.OR, this.path1SouthIsWrongChat, new ZoneRequirement(new Zone(new WorldPoint(2511, 9147, 1), new WorldPoint(2527, 9159, 1))));
        this.path2NorthIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2527, 9169, 1), new WorldPoint(2529, 9171, 1))), "Something about this tunnel feels wrong.");
        this.path2NorthIsWrongChat2 = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2548, 9154, 1), new WorldPoint(2550, 9156, 1))), "Something about this route feels wrong.");
        this.path2NorthIsWrong = new Conditions(true, LogicType.OR, this.path2NorthIsWrongChat, this.path2NorthIsWrongChat2, new ZoneRequirement(new Zone(new WorldPoint(2566, 9151, 1), new WorldPoint(2574, 9164, 1))));
        this.path3SouthIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2589, 9160, 1), new WorldPoint(2592, 9164, 1))), "Something about this route feels wrong.");
        this.path3SouthIsWrong = new Conditions(true, LogicType.OR, this.path3SouthIsWrongChat, new ZoneRequirement(new Zone(new WorldPoint(2590, 9173, 1), new WorldPoint(2617, 9180, 1))));
        this.path4NorthIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2600, 9196, 1), new WorldPoint(2600, 9201, 1))), "Something about this route feels wrong.");
        this.path5WestIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2575, 9223, 1), new WorldPoint(2577, 9225, 1))), "Something about this route feels wrong.");
        this.path5MiddleIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2586, 9226, 1), new WorldPoint(2588, 9228, 1))), "Something about this route feels wrong.");
        this.path5EastIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2601, 9228, 1), new WorldPoint(2603, 9230, 1))), "Something about this route feels wrong.");
        this.path5WestToMiddleWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2581, 9224, 1), new WorldPoint(2583, 9226, 1))), "Something about this route feels wrong.");
        this.path5MiddleToWestWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2584, 9223, 1), new WorldPoint(2586, 9224, 1))), "Something about this route feels wrong.");
        this.path5MiddleToEastWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2588, 9221, 1), new WorldPoint(2592, 9222, 1))), "Something about this route feels wrong.");
        this.path5EastToMiddleWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2595, 9221, 1), new WorldPoint(2598, 9221, 1))), "Something about this route feels wrong.");
        this.path4NorthIsWrong = new Conditions(true, LogicType.OR, this.path4NorthIsWrongChat, this.path5WestToMiddleWrongChat, this.path5MiddleToEastWrongChat, new ZoneRequirement(new Zone(new WorldPoint(2565, 9189, 1), new WorldPoint(2596, 9213, 1))));
        this.path5WestIsWrong = new Conditions(LogicType.OR, this.path5WestIsWrongChat, this.path5MiddleToWestWrongChat, this.path5EastToMiddleWrongChat);
        this.path5MiddleIsWrong = new Conditions(LogicType.OR, this.path5MiddleIsWrongChat, this.path5WestToMiddleWrongChat, this.path5EastToMiddleWrongChat);
        this.path5EastIsWrong = new Conditions(LogicType.OR, this.path5EastIsWrongChat, this.path5MiddleToEastWrongChat, this.path5WestToMiddleWrongChat);
        this.path6WestIsWrongChat = new ChatMessageRequirement(new ZoneRequirement(new Zone(new WorldPoint(2550, 9258, 1), new WorldPoint(2553, 9259, 1))), "Something about this route feels wrong.");
        this.path6WestIsWrong = new Conditions(true, LogicType.OR, this.path6WestIsWrongChat, new ZoneRequirement(new Zone(new WorldPoint(2546, 9226, 1), new WorldPoint(2554, 9255, 1))));
        this.shouldUsePath1V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path1v2", "true");
        this.shouldUsePath2V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path2v2", "true");
        this.shouldUsePath3V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path3v2", "true");
        this.shouldUsePath4V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path4v2", "true");
        this.shouldntUsePath5V1 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path5v1", "false");
        this.shouldntUsePath5V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path5v2", "false");
        this.shouldntUsePath5V3 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path5v3", "false");
        this.shouldUsePath6V2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "mm2path6v2", "true");
        this.shouldUsePath1V2.initWithValue("false");
        this.shouldUsePath2V2.initWithValue("false");
        this.shouldUsePath3V2.initWithValue("false");
        this.shouldUsePath4V2.initWithValue("false");
        this.shouldntUsePath5V1.initWithValue("false");
        this.shouldntUsePath5V2.initWithValue("false");
        this.shouldntUsePath5V3.initWithValue("false");
        this.shouldUsePath6V2.initWithValue("false");
    }

    @Override
    public void setupSteps() {
        this.routeSavedValues = new HashMap();
        for (MM2AgilityNodes mm2AgilityNodes : this.fifthSectionMap = MM2AgilityNodes.values()) {
            for (MM2Route path : mm2AgilityNodes.getPaths()) {
                if (path == null) continue;
                this.routeSavedValues.putIfAbsent(path, new RuneliteRequirement(this.questHelper.getConfigManager(), "mm2agilitywrongway" + path.name(), "false"));
                this.routeSavedValues.get((Object)path).initWithValue("false");
            }
        }
        this.fifthSectionRightPaths = new int[this.fifthSectionMap.length];
        Arrays.fill(this.fifthSectionRightPaths, -1);
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupPaths();
        this.leaveFallArea1 = new ObjectStep(this.getQuestHelper(), 28775, new WorldPoint(2317, 9159, 1), "Go up the rope to the west.", this.protectFromMelee);
        this.leaveFallArea2 = new ObjectStep(this.getQuestHelper(), 28775, new WorldPoint(2379, 9168, 1), "Go up the rope to the west.", this.protectFromMelee);
        this.leaveFallArea3 = new ObjectStep(this.getQuestHelper(), 28775, new WorldPoint(2414, 9189, 1), "Climb up the rope to the south east and use Protect from Ranged.", this.protectFromRanged);
        this.leaveFallArea4 = new ObjectStep(this.getQuestHelper(), 28775, new WorldPoint(2364, 9264, 1), "Climb up the rope to the north west and use Protect from Melee.", this.protectFromMelee);
        this.traverseDungeonFirstSection = new DetailedQuestStep(this.getQuestHelper(), "Traverse the next section of the dungeon. Protect from Melee if you fall.", new Requirement[0]);
        this.traverseDungeonThirdSection = new ObjectStep(this.getQuestHelper(), 28764, new WorldPoint(2595, 9266, 1), "Traverse the next section of the dungeon. PROTECT FROM MISSILE if you fall.", new Requirement[0]);
        this.getKey = new ObjectStep(this.getQuestHelper(), 28792, new WorldPoint(2653, 9163, 1), "Right-click unlock the chest in the cavern to the east for a bronze key.", new Requirement[0]);
        ((ObjectStep)this.getKey).addAlternateObjects(28793);
        this.getKey.setLinePoints(this.pathToChest);
        this.openBronzeDoor = new ObjectStep(this.getQuestHelper(), 28794, new WorldPoint(2610, 9195, 1), "Make your way north then through the bronze door.", this.bronzeKey);
        this.openBronzeDoor.setLinePoints(this.pathToDoor);
        this.openShortcut = new ObjectStep(this.getQuestHelper(), 28814, new WorldPoint(2544, 9232, 1), "Continue through the dungeon until you reach a shortcut to open. PROTECT FROM MELEE if you fall.", new Requirement[0]);
        this.enterShortcut = new ObjectStep(this.getQuestHelper(), 28814, new WorldPoint(2515, 9173, 1), "Enter the shortcut near the entrance.", new Requirement[0]);
        this.goToKruk = new ObjectStep(this.getQuestHelper(), 28684, new WorldPoint(2531, 9227, 1), "Prepare to fight Kruk, then enter the hole to the south.", new Requirement[0]);
        this.goToKruk.addSubSteps(this.enterShortcut);
        this.fightKruk = new NpcStep(this.getQuestHelper(), 6805, new WorldPoint(2535, 9213, 1), "Kill Kruk. He can be flinched on a corner in the room by keeping him on a north east tile to you.", new Requirement[0]);
        this.fightKruk.addTileMarker(new WorldPoint(2528, 9220, 1), 301);
        this.fightKruk.addTileMarker(new WorldPoint(2529, 9221, 1), 162);
    }

    private void updateSection1Route() {
        ArrayList<WorldPoint> newRoute = new ArrayList<WorldPoint>();
        if (this.shouldUsePath1V2.check(this.client)) {
            newRoute.addAll(this.path1V2);
        } else {
            newRoute.addAll(this.path1V1);
        }
        if (this.shouldUsePath2V2.check(this.client)) {
            if (this.shouldUsePath1V2.check(this.client)) {
                newRoute.addAll(this.pathConnectingPath1V1ToV2);
            }
            newRoute.addAll(this.path2V2);
        } else {
            if (!this.shouldUsePath1V2.check(this.client)) {
                newRoute.addAll(this.pathConnectingPath1V2ToV1);
            }
            newRoute.addAll(this.path2V1);
        }
        newRoute.addAll(this.pathMaze);
        if (this.shouldUsePath3V2.check(this.client)) {
            newRoute.addAll(this.path3V2);
        } else {
            newRoute.addAll(this.path3V1);
        }
        this.traverseDungeonFirstSection.setLinePoints(newRoute);
    }

    private void updateSection2Route() {
        ArrayList<WorldPoint> newRoute = new ArrayList<WorldPoint>();
        if (this.shouldUsePath4V2.check(this.client)) {
            newRoute.addAll(this.path4V2);
            newRoute.addAll(this.workOutFifthSection(0, new ArrayList<Integer>(), 0));
        } else {
            newRoute.addAll(this.path4V1);
            newRoute.addAll(this.workOutFifthSection(0, new ArrayList<Integer>(), 2));
        }
        this.traverseDungeonThirdSection.setLinePoints(newRoute);
    }

    private void updateSection3Route() {
        if (this.shouldUsePath6V2.check(this.client)) {
            this.goToKruk.setLinePoints(this.pathToKrukV2);
            this.goToKruk.setWorldPoint(new WorldPoint(2548, 9225, 1));
            this.openShortcut.setLinePoints(this.pathToShortcutV2);
            this.openShortcut.setWorldPoint(new WorldPoint(2544, 9232, 1));
        } else {
            this.goToKruk.setLinePoints(this.pathToKrukV1);
            this.goToKruk.setWorldPoint(new WorldPoint(2531, 9227, 1));
            this.openShortcut.setLinePoints(this.pathToShortcutV1);
            this.openShortcut.setWorldPoint(new WorldPoint(2534, 9240, 1));
        }
    }

    public ArrayList<WorldPoint> workOutFifthSection(int currentDepth, ArrayList<Integer> previousIds, int id) {
        previousIds.add(id);
        if (currentDepth > 20) {
            return new ArrayList<WorldPoint>();
        }
        ArrayList<WorldPoint> newPoints = new ArrayList<WorldPoint>();
        MM2AgilityNodes currentNode = this.fifthSectionMap[id];
        int currentCorrectRoute = this.fifthSectionRightPaths[id];
        if (currentCorrectRoute != -1) {
            if (previousIds.contains(currentNode.getPaths()[currentCorrectRoute].getIdEnd())) {
                this.fifthSectionRightPaths[id] = -1;
            } else {
                int nextNodeId = currentNode.getPaths()[currentCorrectRoute].getIdEnd();
                for (MM2Route path : currentNode.getPaths()) {
                    if (path == null || path.getIdEnd() == nextNodeId) continue;
                    this.routeSavedValues.get((Object)path).setConfigValue("true");
                }
                newPoints.addAll(currentNode.getPaths()[currentCorrectRoute].getPath());
                newPoints.addAll(this.workOutFifthSection(currentDepth + 1, previousIds, nextNodeId));
                return newPoints;
            }
        }
        for (int i = 0; i < currentNode.getPaths().length; ++i) {
            if (currentNode.getPaths()[i] == null) continue;
            if (currentNode.getPaths()[i].getWrongWay().check(this.client)) {
                this.routeSavedValues.get((Object)currentNode.getPaths()[i]).setConfigValue("true");
            }
            if (!this.routeSavedValues.get((Object)currentNode.getPaths()[i]).check(this.client) || previousIds.contains(currentNode.getPaths()[i].getIdEnd())) continue;
            int nextNodeId = currentNode.getPaths()[i].getIdEnd();
            newPoints.addAll(currentNode.getPaths()[i].getPath());
            newPoints.addAll(this.workOutFifthSection(currentDepth + 1, previousIds, nextNodeId));
            return newPoints;
        }
        return new ArrayList<WorldPoint>();
    }

    public void checkSection5Successes() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        WorldPoint currentPosition = player.getWorldLocation();
        block0: for (int i = 0; i < this.fifthSectionMap.length; ++i) {
            MM2Route[] pathsFromNode = this.fifthSectionMap[i].getPaths();
            for (int dir = 0; dir < pathsFromNode.length; ++dir) {
                if (pathsFromNode[dir] == null || !pathsFromNode[dir].getStartWp().contains(this.lastPosition) || !pathsFromNode[dir].getEndWp().contains(currentPosition)) continue;
                if (this.fifthSectionRightPaths[i] == dir) continue block0;
                this.fifthSectionRightPaths[i] = dir;
                this.updateSection2Route();
                continue block0;
            }
        }
        this.lastPosition = currentPosition;
    }

    @Subscribe
    public void onGameTick(GameTick ignoredEvent) {
        if (!this.shouldUsePath1V2.check(this.client)) {
            if (this.path1SouthIsWrong.check(this.client)) {
                this.shouldUsePath1V2.setConfigValue("true");
            }
            if (this.shouldUsePath1V2.check(this.client)) {
                this.updateSection1Route();
            }
        }
        if (!this.shouldUsePath2V2.check(this.client)) {
            if (this.path2NorthIsWrong.check(this.client)) {
                this.shouldUsePath2V2.setConfigValue("true");
            }
            if (this.shouldUsePath2V2.check(this.client)) {
                this.updateSection1Route();
            }
        }
        if (!this.shouldUsePath3V2.check(this.client)) {
            if (this.path3SouthIsWrong.check(this.client)) {
                this.shouldUsePath3V2.setConfigValue("true");
            }
            if (this.shouldUsePath3V2.check(this.client)) {
                this.updateSection1Route();
            }
        }
        if (!this.shouldUsePath4V2.check(this.client)) {
            if (this.path4NorthIsWrong.check(this.client)) {
                this.shouldUsePath4V2.setConfigValue("true");
            }
            if (this.shouldUsePath4V2.check(this.client)) {
                this.updateSection2Route();
            }
        }
        if (!this.shouldntUsePath5V1.check(this.client)) {
            if (this.path5EastIsWrong.check(this.client)) {
                this.shouldntUsePath5V1.setConfigValue("true");
            }
            if (this.shouldntUsePath5V1.check(this.client)) {
                this.updateSection2Route();
            }
        }
        if (!this.shouldntUsePath5V2.check(this.client)) {
            if (this.path5MiddleIsWrong.check(this.client)) {
                this.shouldntUsePath5V2.setConfigValue("true");
            }
            if (this.shouldntUsePath5V2.check(this.client)) {
                this.updateSection2Route();
            }
        }
        if (!this.shouldntUsePath5V3.check(this.client)) {
            if (this.path5WestIsWrong.check(this.client)) {
                this.shouldntUsePath5V3.setConfigValue("true");
            }
            if (this.shouldntUsePath5V1.check(this.client)) {
                this.updateSection2Route();
            }
        }
        if (!this.shouldUsePath6V2.check(this.client)) {
            if (this.path6WestIsWrong.check(this.client)) {
                this.shouldUsePath6V2.setConfigValue("true");
            }
            if (this.shouldUsePath6V2.check(this.client)) {
                this.updateSection3Route();
            }
        }
        this.checkSection5Successes();
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        if (this.inCavesSection4.check(this.client)) {
            if (this.openedShortcut.check(this.client)) {
                this.startUpStep(this.goToKruk);
            } else {
                this.startUpStep(this.openShortcut);
            }
        } else if (this.inKrukRoom.check(this.client)) {
            this.startUpStep(this.fightKruk);
        } else if (this.openedShortcut.check(this.client)) {
            this.startUpStep(this.enterShortcut);
        } else if (this.inCavesSection3.check(this.client)) {
            this.startUpStep(this.traverseDungeonThirdSection);
        } else if (this.inCavesSection2.check(this.client)) {
            if (this.hasBronzeKey.check(this.client)) {
                this.startUpStep(this.openBronzeDoor);
            } else {
                this.startUpStep(this.getKey);
            }
        } else if (this.inFallArea1.check(this.client)) {
            this.startUpStep(this.leaveFallArea1);
        } else if (this.inFallArea2.check(this.client)) {
            this.startUpStep(this.leaveFallArea2);
        } else if (this.inFallArea3.check(this.client)) {
            this.startUpStep(this.leaveFallArea3);
        } else if (this.inFallArea4.check(this.client)) {
            this.startUpStep(this.leaveFallArea4);
        } else {
            this.startUpStep(this.traverseDungeonFirstSection);
        }
    }

    @Override
    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            this.path1SouthIsWrongChat.validateCondition(this.client, chatMessage);
            this.path2NorthIsWrongChat.validateCondition(this.client, chatMessage);
            this.path2NorthIsWrongChat2.validateCondition(this.client, chatMessage);
            this.path3SouthIsWrongChat.validateCondition(this.client, chatMessage);
            this.path4NorthIsWrongChat.validateCondition(this.client, chatMessage);
            this.path5WestIsWrongChat.validateCondition(this.client, chatMessage);
            this.path5MiddleIsWrongChat.validateCondition(this.client, chatMessage);
            this.path5EastIsWrongChat.validateCondition(this.client, chatMessage);
            this.path5MiddleToEastWrongChat.validateCondition(this.client, chatMessage);
            this.path5MiddleToWestWrongChat.validateCondition(this.client, chatMessage);
            this.path5EastToMiddleWrongChat.validateCondition(this.client, chatMessage);
            this.path5WestToMiddleWrongChat.validateCondition(this.client, chatMessage);
            this.path6WestIsWrongChat.validateCondition(this.client, chatMessage);
            for (MM2AgilityNodes mm2AgilityNode : this.fifthSectionMap) {
                for (int i = 0; i < mm2AgilityNode.getPaths().length; ++i) {
                    if (mm2AgilityNode.getPaths()[i] == null) continue;
                    mm2AgilityNode.getPaths()[i].getWrongWay().validateCondition(this.client, chatMessage);
                }
            }
            this.updateSection2Route();
        }
    }

    private void setupPaths() {
        this.path1V1 = Arrays.asList(new WorldPoint(2509, 9169, 1), new WorldPoint(2509, 9167, 1), new WorldPoint(2507, 9164, 1), new WorldPoint(2507, 9156, 1), new WorldPoint(2504, 9153, 1), new WorldPoint(2504, 9146, 1), new WorldPoint(2509, 9145, 1), new WorldPoint(2509, 9144, 1), new WorldPoint(2509, 9143, 1), new WorldPoint(2513, 9143, 1), new WorldPoint(2513, 9136, 1), new WorldPoint(2515, 9135, 1), new WorldPoint(2521, 9135, 1), new WorldPoint(2529, 9140, 1), new WorldPoint(2531, 9140, 1), new WorldPoint(2531, 9139, 1), new WorldPoint(2533, 9139, 1), new WorldPoint(2533, 9145, 1), new WorldPoint(2535, 9145, 1), new WorldPoint(2535, 9143, 1), new WorldPoint(2538, 9143, 1), new WorldPoint(2543, 9148, 1), new WorldPoint(2549, 9148, 1));
        this.path1V2 = Arrays.asList(new WorldPoint(2509, 9169, 1), new WorldPoint(2509, 9167, 1), new WorldPoint(2507, 9164, 1), new WorldPoint(2507, 9156, 1), new WorldPoint(2504, 9153, 1), new WorldPoint(2504, 9146, 1), new WorldPoint(2509, 9145, 1), new WorldPoint(2509, 9144, 1), new WorldPoint(2514, 9144, 1), new WorldPoint(2514, 9146, 1), new WorldPoint(2511, 9146, 1), new WorldPoint(2511, 9148, 1), new WorldPoint(2519, 9148, 1), new WorldPoint(2519, 9155, 1), new WorldPoint(2525, 9155, 1), new WorldPoint(2525, 9158, 1), new WorldPoint(2528, 9165, 1));
        this.pathConnectingPath1V2ToV1 = Arrays.asList(new WorldPoint(2549, 9152, 1), new WorldPoint(2549, 9162, 1), new WorldPoint(2539, 9166, 1), new WorldPoint(2528, 9165, 1));
        this.pathConnectingPath1V1ToV2 = Arrays.asList(new WorldPoint(2528, 9165, 1), new WorldPoint(2539, 9166, 1), new WorldPoint(2549, 9162, 1), new WorldPoint(2549, 9152, 1));
        this.path2V1 = Arrays.asList(new WorldPoint(2528, 9173, 1), new WorldPoint(2534, 9173, 1), new WorldPoint(2538, 9180, 1), new WorldPoint(2548, 9180, 1), new WorldPoint(2552, 9184, 1), new WorldPoint(2567, 9184, 1), new WorldPoint(2567, 9178, 1));
        this.path2V2 = Arrays.asList(new WorldPoint(2557, 9152, 1), new WorldPoint(2560, 9156, 1), new WorldPoint(2567, 9156, 1), new WorldPoint(2574, 9164, 1));
        this.pathMaze = Arrays.asList(new WorldPoint(2575, 9170, 1), new WorldPoint(2577, 9170, 1), new WorldPoint(2577, 9172, 1), new WorldPoint(2581, 9172, 1), new WorldPoint(2581, 9169, 1), new WorldPoint(2584, 9169, 1));
        this.path3V1 = Arrays.asList(new WorldPoint(2589, 9162, 1), new WorldPoint(2597, 9162, 1), new WorldPoint(2602, 9162, 1), new WorldPoint(2602, 9168, 1), new WorldPoint(2603, 9169, 1), new WorldPoint(2603, 9171, 1), new WorldPoint(2608, 9171, 1), new WorldPoint(2608, 9165, 1), new WorldPoint(2611, 9162, 1), new WorldPoint(2611, 9159, 1), new WorldPoint(2617, 9160, 1), new WorldPoint(2622, 9160, 1), new WorldPoint(2629, 9167, 1));
        this.path3V2 = Arrays.asList(new WorldPoint(2588, 9177, 1), new WorldPoint(2593, 9177, 1), new WorldPoint(2597, 9176, 1), new WorldPoint(2603, 9176, 1), new WorldPoint(2604, 9179, 1), new WorldPoint(2612, 9179, 1), new WorldPoint(2616, 9173, 1), new WorldPoint(2621, 9173, 1), new WorldPoint(2625, 9172, 1), new WorldPoint(2629, 9172, 1), new WorldPoint(2629, 9167, 1));
        this.pathToChest = Arrays.asList(new WorldPoint(2629, 9167, 1), new WorldPoint(2639, 9167, 1), new WorldPoint(2639, 9163, 1), new WorldPoint(2643, 9163, 1), new WorldPoint(2643, 9165, 1), new WorldPoint(2645, 9165, 1), new WorldPoint(2645, 9163, 1), new WorldPoint(2652, 9163, 1));
        this.pathFromChest = Arrays.asList(new WorldPoint(2652, 9163, 1), new WorldPoint(2639, 9163, 1), new WorldPoint(2639, 9167, 1), new WorldPoint(2629, 9167, 1));
        this.pathToDoor = Arrays.asList(new WorldPoint(2652, 9163, 1), new WorldPoint(2645, 9163, 1), new WorldPoint(2645, 9165, 1), new WorldPoint(2643, 9165, 1), new WorldPoint(2643, 9163, 1), new WorldPoint(2639, 9163, 1), new WorldPoint(2639, 9167, 1), new WorldPoint(2629, 9167, 1), new WorldPoint(2630, 9171, 1), new WorldPoint(2633, 9171, 1), new WorldPoint(2633, 9169, 1), new WorldPoint(2635, 9169, 1), new WorldPoint(2635, 9171, 1), new WorldPoint(2641, 9171, 1), new WorldPoint(2641, 9173, 1), new WorldPoint(2636, 9173, 1), new WorldPoint(2636, 9175, 1), new WorldPoint(2635, 9175, 1), new WorldPoint(2635, 9183, 1), new WorldPoint(2628, 9183, 1), new WorldPoint(2628, 9186, 1), new WorldPoint(2627, 9186, 1), new WorldPoint(2627, 9187, 1), new WorldPoint(2624, 9187, 1), new WorldPoint(2623, 9188, 1), new WorldPoint(2615, 9188, 1), new WorldPoint(2615, 9195, 1), new WorldPoint(2611, 9195, 1));
        this.path4V1 = Arrays.asList(new WorldPoint(2607, 9195, 1), new WorldPoint(2600, 9195, 1), new WorldPoint(2600, 9205, 1), new WorldPoint(2601, 9207, 1), new WorldPoint(2601, 9208, 1), new WorldPoint(2598, 9208, 1), new WorldPoint(2598, 9210, 1), new WorldPoint(2600, 9210, 1), new WorldPoint(2600, 9212, 1), new WorldPoint(2598, 9212, 1), new WorldPoint(2598, 9215, 1), new WorldPoint(2599, 9216, 1), new WorldPoint(2599, 9221, 1));
        this.path4V2 = Arrays.asList(new WorldPoint(2607, 9195, 1), new WorldPoint(2600, 9195, 1), new WorldPoint(2595, 9195, 1), new WorldPoint(2592, 9196, 1), new WorldPoint(2584, 9196, 1), new WorldPoint(2584, 9192, 1), new WorldPoint(2579, 9192, 1), new WorldPoint(2579, 9194, 1), new WorldPoint(2578, 9196, 1), new WorldPoint(2578, 9203, 1), new WorldPoint(2579, 9207, 1), new WorldPoint(2574, 9207, 1), new WorldPoint(2571, 9211, 1), new WorldPoint(2571, 9220, 1), new WorldPoint(2576, 9222, 1));
        this.path5V1 = Arrays.asList(new WorldPoint(2599, 9221, 1), new WorldPoint(2604, 9228, 1), new WorldPoint(2604, 9230, 1), new WorldPoint(2602, 9230, 1), new WorldPoint(2602, 9232, 1));
        this.path5V2 = Arrays.asList(new WorldPoint(2587, 9223, 1), new WorldPoint(2587, 9231, 1), new WorldPoint(2591, 9235, 1), new WorldPoint(2591, 9237, 1));
        this.path5V3 = Arrays.asList(new WorldPoint(2576, 9222, 1), new WorldPoint(2576, 9225, 1), new WorldPoint(2577, 9225, 1), new WorldPoint(2577, 9227, 1), new WorldPoint(2575, 9227, 1), new WorldPoint(2575, 9229, 1), new WorldPoint(2572, 9229, 1), new WorldPoint(2572, 9230, 1), new WorldPoint(2570, 9230, 1), new WorldPoint(2570, 9232, 1), new WorldPoint(2569, 9232, 1), new WorldPoint(2569, 9234, 1), new WorldPoint(2571, 9234, 1), new WorldPoint(2571, 9239, 1));
        this.firstHalfSection5Path = Arrays.asList(new WorldPoint(2593, 9273, 1), new WorldPoint(2570, 9273, 1), new WorldPoint(2554, 9258, 1));
        this.pathToShortcutV1 = new ArrayList<WorldPoint>();
        this.pathToShortcutV1.addAll(this.firstHalfSection5Path);
        this.pathToShortcutV1.addAll(Arrays.asList(new WorldPoint(2545, 9258, 1), new WorldPoint(2544, 9257, 1), new WorldPoint(2544, 9252, 1), new WorldPoint(2541, 9253, 1), new WorldPoint(2532, 9253, 1), new WorldPoint(2529, 9247, 1), new WorldPoint(2529, 9240, 1), new WorldPoint(2533, 9240, 1)));
        this.pathToKrukV1 = new ArrayList<WorldPoint>();
        this.pathToKrukV1.addAll(this.firstHalfSection5Path);
        this.pathToKrukV1.addAll(Arrays.asList(new WorldPoint(2545, 9258, 1), new WorldPoint(2544, 9257, 1), new WorldPoint(2544, 9252, 1), new WorldPoint(2541, 9253, 1), new WorldPoint(2532, 9253, 1), new WorldPoint(2529, 9247, 1), new WorldPoint(2529, 9240, 1), new WorldPoint(2533, 9240, 1), new WorldPoint(2533, 9236, 1), new WorldPoint(2530, 9236, 1), new WorldPoint(2530, 9233, 1), new WorldPoint(2532, 9233, 1), new WorldPoint(2532, 9230, 1), new WorldPoint(2531, 9230, 1), new WorldPoint(2531, 9228, 1)));
        this.pathToShortcutV2 = new ArrayList<WorldPoint>();
        this.pathToShortcutV2.addAll(this.firstHalfSection5Path);
        this.pathToShortcutV2.addAll(Arrays.asList(new WorldPoint(2554, 9253, 1), new WorldPoint(2552, 9253, 1), new WorldPoint(2552, 9254, 1), new WorldPoint(2551, 9254, 1), new WorldPoint(2551, 9255, 1), new WorldPoint(2548, 9255, 1), new WorldPoint(2548, 9252, 1), new WorldPoint(2550, 9252, 1), new WorldPoint(2550, 9251, 1), new WorldPoint(2552, 9251, 1), new WorldPoint(2552, 9249, 1), new WorldPoint(2551, 9249, 1), new WorldPoint(2550, 9244, 1), new WorldPoint(2550, 9239, 1), new WorldPoint(2547, 9237, 1), new WorldPoint(2547, 9232, 1), new WorldPoint(2545, 9232, 1)));
        this.pathToKrukV2 = new ArrayList<WorldPoint>();
        this.pathToKrukV2.addAll(this.firstHalfSection5Path);
        this.pathToKrukV2.addAll(Arrays.asList(new WorldPoint(2554, 9253, 1), new WorldPoint(2552, 9253, 1), new WorldPoint(2552, 9254, 1), new WorldPoint(2551, 9254, 1), new WorldPoint(2551, 9255, 1), new WorldPoint(2548, 9255, 1), new WorldPoint(2548, 9252, 1), new WorldPoint(2550, 9252, 1), new WorldPoint(2550, 9251, 1), new WorldPoint(2552, 9251, 1), new WorldPoint(2552, 9249, 1), new WorldPoint(2551, 9249, 1), new WorldPoint(2550, 9244, 1), new WorldPoint(2550, 9239, 1), new WorldPoint(2547, 9237, 1), new WorldPoint(2547, 9232, 1), new WorldPoint(2548, 9231, 1), new WorldPoint(2548, 9229, 1), new WorldPoint(2546, 9229, 1), new WorldPoint(2546, 9227, 1), new WorldPoint(2548, 9227, 1), new WorldPoint(2548, 9226, 1)));
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.leaveFallArea1, this.leaveFallArea2, this.leaveFallArea3, this.leaveFallArea4, this.traverseDungeonFirstSection, this.getKey, this.openBronzeDoor, this.traverseDungeonThirdSection, this.openShortcut, this.goToKruk, this.enterShortcut, this.fightKruk);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.traverseDungeonFirstSection, this.getKey, this.openBronzeDoor, this.traverseDungeonThirdSection, this.openShortcut, this.goToKruk, this.fightKruk);
    }
}

