/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.misthalinmystery;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MISTHALIN_MYSTERY)
public class MisthalinMystery
extends BasicQuestHelper {
    ItemRequirement bucket;
    ItemRequirement manorKey;
    ItemRequirement knife;
    ItemRequirement notes1;
    ItemRequirement rubyKey;
    ItemRequirement tinderbox;
    ItemRequirement notes2;
    ItemRequirement emeraldKey;
    ItemRequirement notes3;
    ItemRequirement sapphireKey;
    ItemRequirement killersKnife;
    ItemRequirement killersKnifeEquipped;
    Requirement onIsland;
    Requirement litCandle1;
    Requirement litCandle2;
    Requirement litCandle3;
    Requirement inOutsideArea;
    Requirement inPianoWidget;
    Requirement playedD;
    Requirement playedE;
    Requirement playedA;
    Requirement playedAnyKey;
    Requirement inGemWidget;
    Requirement selectedSaphire;
    Requirement selectedDiamond;
    Requirement selectedZenyte;
    Requirement selectedEmerald;
    Requirement selectedOnyx;
    Requirement selectAnyGem;
    Requirement inBossRoom;
    QuestStep talkToAbigale;
    QuestStep takeTheBoat;
    QuestStep takeTheBucket;
    QuestStep searchTheBarrel;
    QuestStep useBucketOnBarrel;
    QuestStep searchTheBarrelForKey;
    QuestStep openManorDoor;
    QuestStep takeKnife;
    QuestStep tryToOpenPinkKnobDoor;
    QuestStep takeNote1;
    QuestStep readNotes1;
    QuestStep useKnifeOnPainting;
    QuestStep searchPainting;
    QuestStep goThroughRubyDoor;
    QuestStep takeTinderbox;
    QuestStep lightCandle1;
    QuestStep lightCandle2;
    QuestStep lightCandle3;
    QuestStep lightCandle4;
    QuestStep lightBarrel;
    QuestStep leaveExplosionRoom;
    QuestStep climbWall;
    QuestStep observeThroughTree;
    QuestStep takeNote2;
    QuestStep readNotes2;
    QuestStep playPiano;
    QuestStep playD;
    QuestStep playE;
    QuestStep playA;
    QuestStep playDAgain;
    QuestStep restartPiano;
    QuestStep searchThePiano;
    QuestStep returnOverBrokenWall;
    QuestStep openEmeraldDoor;
    QuestStep enterBandosGodswordRoomStep;
    QuestStep takeNote3;
    QuestStep readNotes3;
    QuestStep useKnifeOnFireplace;
    QuestStep searchFireplace;
    QuestStep clickSapphire;
    QuestStep clickDiamond;
    QuestStep clickZenyte;
    QuestStep clickEmerald;
    QuestStep clickOnyx;
    QuestStep clickRuby;
    QuestStep restartGems;
    QuestStep searchFireplaceForSapphireKey;
    QuestStep goThroughSapphireDoor;
    QuestStep reflectKnives;
    QuestStep continueThroughSapphireDoor;
    QuestStep pickUpKillersKnife;
    QuestStep fightAbigale;
    QuestStep leaveSapphireRoom;
    QuestStep talkToMandy;
    private Zone island;
    private Zone outside1;
    private Zone outside2;
    private Zone outside3;
    private Zone bossRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToAbigale);
        steps.put(5, this.talkToAbigale);
        ConditionalStep investigatingTheBarrel = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        investigatingTheBarrel.addStep(new Conditions(this.onIsland, this.bucket), this.searchTheBarrel);
        investigatingTheBarrel.addStep(this.onIsland, this.takeTheBucket);
        steps.put(10, investigatingTheBarrel);
        steps.put(15, investigatingTheBarrel);
        ConditionalStep emptyTheBarrel = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        emptyTheBarrel.addStep(new Conditions(this.onIsland, this.bucket), this.useBucketOnBarrel);
        emptyTheBarrel.addStep(this.onIsland, this.takeTheBucket);
        steps.put(20, emptyTheBarrel);
        ConditionalStep enterTheHouse = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        enterTheHouse.addStep(new Conditions(this.onIsland, this.manorKey), this.openManorDoor);
        enterTheHouse.addStep(this.onIsland, this.searchTheBarrelForKey);
        steps.put(25, enterTheHouse);
        ConditionalStep pinkDoor = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        pinkDoor.addStep(this.knife, this.tryToOpenPinkKnobDoor);
        pinkDoor.addStep(this.onIsland, this.takeKnife);
        steps.put(30, pinkDoor);
        ConditionalStep pickUpAndReadNotes1 = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        pickUpAndReadNotes1.addStep(new Conditions(this.onIsland, this.notes1), this.readNotes1);
        pickUpAndReadNotes1.addStep(this.onIsland, this.takeNote1);
        steps.put(35, pickUpAndReadNotes1);
        ConditionalStep cutPainting = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        cutPainting.addStep(new Conditions(this.onIsland, this.knife), this.useKnifeOnPainting);
        cutPainting.addStep(this.onIsland, this.takeKnife);
        steps.put(40, cutPainting);
        ConditionalStep enterRubyRoom = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        enterRubyRoom.addStep(new Conditions(this.onIsland, this.rubyKey), this.goThroughRubyDoor);
        enterRubyRoom.addStep(this.onIsland, this.searchPainting);
        steps.put(45, enterRubyRoom);
        ConditionalStep lightCandles = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        lightCandles.addStep(new Conditions(this.onIsland, this.tinderbox, this.litCandle1, this.litCandle2, this.litCandle3), this.lightCandle4);
        lightCandles.addStep(new Conditions(this.onIsland, this.tinderbox, this.litCandle1, this.litCandle2), this.lightCandle3);
        lightCandles.addStep(new Conditions(this.onIsland, this.tinderbox, this.litCandle1), this.lightCandle2);
        lightCandles.addStep(new Conditions(this.onIsland, this.tinderbox), this.lightCandle1);
        lightCandles.addStep(this.onIsland, this.takeTinderbox);
        steps.put(50, lightCandles);
        ConditionalStep lightFuseOnBarrel = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        lightFuseOnBarrel.addStep(new Conditions(this.onIsland, this.tinderbox), this.lightBarrel);
        lightFuseOnBarrel.addStep(this.onIsland, this.takeTinderbox);
        steps.put(55, lightFuseOnBarrel);
        steps.put(60, this.leaveExplosionRoom);
        ConditionalStep goToLacey = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        goToLacey.addStep(this.inOutsideArea, this.observeThroughTree);
        goToLacey.addStep(this.onIsland, this.climbWall);
        steps.put(65, goToLacey);
        ConditionalStep pickUpAndReadNotes2 = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        pickUpAndReadNotes2.addStep(this.notes2, this.readNotes2);
        pickUpAndReadNotes2.addStep(this.inOutsideArea, this.takeNote2);
        pickUpAndReadNotes2.addStep(this.onIsland, this.climbWall);
        steps.put(70, pickUpAndReadNotes2);
        ConditionalStep playMusic = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        playMusic.addStep(this.playedA, this.playDAgain);
        playMusic.addStep(this.playedE, this.playA);
        playMusic.addStep(this.playedD, this.playE);
        playMusic.addStep(new Conditions(this.playedAnyKey, this.inPianoWidget), this.restartPiano);
        playMusic.addStep(this.inPianoWidget, this.playD);
        playMusic.addStep(this.inOutsideArea, this.playPiano);
        playMusic.addStep(this.onIsland, this.climbWall);
        steps.put(75, playMusic);
        ConditionalStep openingTheEmeraldDoor = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        openingTheEmeraldDoor.addStep(new Conditions(this.inOutsideArea, this.emeraldKey), this.returnOverBrokenWall);
        openingTheEmeraldDoor.addStep(this.inOutsideArea, this.searchThePiano);
        openingTheEmeraldDoor.addStep(new Conditions(this.onIsland, this.emeraldKey), this.openEmeraldDoor);
        openingTheEmeraldDoor.addStep(this.onIsland, this.climbWall);
        steps.put(80, openingTheEmeraldDoor);
        ConditionalStep enterBandosGodswordRoom = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        enterBandosGodswordRoom.addStep(this.onIsland, this.enterBandosGodswordRoomStep);
        steps.put(85, enterBandosGodswordRoom);
        ConditionalStep startPuzzle3 = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        startPuzzle3.addStep(new Conditions(this.onIsland, this.notes3), this.readNotes3);
        startPuzzle3.addStep(this.onIsland, this.takeNote3);
        steps.put(90, startPuzzle3);
        ConditionalStep openFireplace = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        openFireplace.addStep(new Conditions(this.onIsland, this.knife), this.useKnifeOnFireplace);
        openFireplace.addStep(this.onIsland, this.takeKnife);
        steps.put(95, openFireplace);
        ConditionalStep solveFireplacePuzzle = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        solveFireplacePuzzle.addStep(this.selectedOnyx, this.clickRuby);
        solveFireplacePuzzle.addStep(this.selectedEmerald, this.clickOnyx);
        solveFireplacePuzzle.addStep(this.selectedZenyte, this.clickEmerald);
        solveFireplacePuzzle.addStep(this.selectedDiamond, this.clickZenyte);
        solveFireplacePuzzle.addStep(this.selectedSaphire, this.clickDiamond);
        solveFireplacePuzzle.addStep(this.selectAnyGem, this.restartGems);
        solveFireplacePuzzle.addStep(this.inGemWidget, this.clickSapphire);
        solveFireplacePuzzle.addStep(this.onIsland, this.searchFireplace);
        steps.put(100, solveFireplacePuzzle);
        ConditionalStep openSapphireDoor = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        openSapphireDoor.addStep(new Conditions(this.onIsland, this.sapphireKey), this.goThroughSapphireDoor);
        openSapphireDoor.addStep(this.onIsland, this.searchFireplaceForSapphireKey);
        steps.put(105, openSapphireDoor);
        ConditionalStep goDoBoss = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        goDoBoss.addStep(this.inBossRoom, this.reflectKnives);
        goDoBoss.addStep(this.onIsland, this.goThroughSapphireDoor);
        steps.put(110, goDoBoss);
        steps.put(111, goDoBoss);
        ConditionalStep watchRevealCutscene = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        watchRevealCutscene.addStep(this.onIsland, this.continueThroughSapphireDoor);
        steps.put(115, watchRevealCutscene);
        ConditionalStep goFightAbigale = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        goFightAbigale.addStep(new Conditions(this.inBossRoom, this.killersKnife), this.fightAbigale);
        goFightAbigale.addStep(this.inBossRoom, this.pickUpKillersKnife);
        goFightAbigale.addStep(this.onIsland, this.continueThroughSapphireDoor);
        steps.put(120, goFightAbigale);
        ConditionalStep attemptToLeaveSapphireRoom = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        attemptToLeaveSapphireRoom.addStep(this.onIsland, this.leaveSapphireRoom);
        steps.put(125, attemptToLeaveSapphireRoom);
        ConditionalStep finishTheQuest = new ConditionalStep((QuestHelper)this, this.takeTheBoat, new Requirement[0]);
        finishTheQuest.addStep(this.onIsland, this.talkToMandy);
        steps.put(130, finishTheQuest);
        return steps;
    }

    public void setupZones() {
        this.island = new Zone(new WorldPoint(1600, 4800, 0), new WorldPoint(1679, 4845, 0));
        this.outside1 = new Zone(new WorldPoint(1648, 4825, 0), new WorldPoint(1654, 4852, 0));
        this.outside2 = new Zone(new WorldPoint(1634, 4840, 0), new WorldPoint(1648, 4852, 0));
        this.outside3 = new Zone(new WorldPoint(1631, 4847, 0), new WorldPoint(1633, 4850, 0));
        this.bossRoom = new Zone(new WorldPoint(1619, 4825, 0), new WorldPoint(1627, 4834, 0));
    }

    public void setupConditions() {
        this.onIsland = new ZoneRequirement(this.island);
        this.inOutsideArea = new ZoneRequirement(this.outside1, this.outside2, this.outside3);
        this.litCandle1 = new VarbitRequirement(4042, 1);
        this.litCandle2 = new VarbitRequirement(4041, 1);
        this.litCandle3 = new VarbitRequirement(4039, 1);
        this.playedD = new Conditions(new VarbitRequirement(4044, 1), new VarbitRequirement(4049, 1));
        this.playedE = new Conditions(new VarbitRequirement(4045, 1), new VarbitRequirement(4049, 2));
        this.playedA = new Conditions(new VarbitRequirement(4046, 1), new VarbitRequirement(4049, 3));
        this.playedAnyKey = new VarbitRequirement(4049, 1, Operation.GREATER_EQUAL);
        this.inPianoWidget = new WidgetTextRequirement(554, 20, "C");
        this.inGemWidget = new WidgetTextRequirement(555, 1, 1, "Gemstone switch panel");
        this.selectedSaphire = new Conditions(new VarbitRequirement(4051, 1), new VarbitRequirement(4050, 1));
        this.selectedDiamond = new Conditions(new VarbitRequirement(4052, 1), new VarbitRequirement(4050, 2));
        this.selectedZenyte = new Conditions(new VarbitRequirement(4053, 1), new VarbitRequirement(4050, 3));
        this.selectedEmerald = new Conditions(new VarbitRequirement(4054, 1), new VarbitRequirement(4050, 4));
        this.selectedOnyx = new Conditions(new VarbitRequirement(4055, 1), new VarbitRequirement(4050, 5));
        this.selectAnyGem = new VarbitRequirement(4050, 1, Operation.GREATER_EQUAL);
        this.inBossRoom = new ZoneRequirement(this.bossRoom);
    }

    @Override
    public void setupRequirements() {
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.manorKey = new ItemRequirement("Manor key", 21052);
        this.knife = new ItemRequirement("Knife", 946);
        this.notes1 = new ItemRequirement("Notes", 21056);
        this.rubyKey = new ItemRequirement("Ruby key", 21053);
        this.tinderbox = new ItemRequirement("Tinderbox", 590);
        this.notes2 = new ItemRequirement("Notes", 21057);
        this.emeraldKey = new ItemRequirement("Emerald key", 21054);
        this.notes3 = new ItemRequirement("Notes", 21058);
        this.sapphireKey = new ItemRequirement("Sapphire key", 21055);
        this.killersKnife = new ItemRequirement("Killer's knife", 21059);
        this.killersKnifeEquipped = new ItemRequirement("Killer's knife", 21059, 1, true);
    }

    public void setupSteps() {
        this.talkToAbigale = new NpcStep((QuestHelper)this, 7623, new WorldPoint(3237, 3155, 0), "Talk to Abigale in the south east corner of Lumbridge Swamp.", new Requirement[0]);
        this.talkToAbigale.addDialogStep("What has happened here?");
        this.talkToAbigale.addDialogStep("What do you want me to do?");
        this.takeTheBoat = new ObjectStep((QuestHelper)this, 30108, new WorldPoint(3240, 3140, 0), "Board the rowboat south of Abigale.", new Requirement[0]);
        this.takeTheBucket = new ObjectStep((QuestHelper)this, 30147, new WorldPoint(1619, 4816, 0), "Pick up the bucket near the fountain.", this.bucket);
        this.searchTheBarrel = new ObjectStep((QuestHelper)this, 29649, new WorldPoint(1615, 4829, 0), "Search the barrel of rainwater north of the fountain to trigger a cutscene.", this.bucket);
        this.useBucketOnBarrel = new ObjectStep((QuestHelper)this, 29649, new WorldPoint(1615, 4829, 0), "Use the bucket on the barrel of rainwater.", this.bucket);
        this.searchTheBarrelForKey = new ObjectStep((QuestHelper)this, 29649, new WorldPoint(1615, 4829, 0), "Search the barrel of rainwater for the manor key.", new Requirement[0]);
        this.useBucketOnBarrel.addIcon(1925);
        this.openManorDoor = new ObjectStep((QuestHelper)this, 30110, new WorldPoint(1636, 4824, 0), "Enter the manor.", new Requirement[0]);
        this.takeKnife = new ObjectStep((QuestHelper)this, 30145, new WorldPoint(1639, 4831, 0), "Take the knife from the table.", this.knife);
        this.tryToOpenPinkKnobDoor = new ObjectStep((QuestHelper)this, 30112, new WorldPoint(1635, 4838, 0), "Try to open the pink-handled door.", new Requirement[0]);
        this.takeNote1 = new ObjectStep((QuestHelper)this, 2266, new WorldPoint(1635, 4839, 0), "Pick up the note that appeared.", new Requirement[0]);
        this.readNotes1 = new DetailedQuestStep((QuestHelper)this, "Read the notes.", this.notes1);
        this.useKnifeOnPainting = new ObjectStep((QuestHelper)this, 29650, new WorldPoint(1632, 4833, 0), "Use a knife on the marked painting.", this.knife);
        this.useKnifeOnPainting.addIcon(946);
        this.searchPainting = new ObjectStep((QuestHelper)this, 29650, new WorldPoint(1632, 4833, 0), "Search the painting for a ruby key.", new Requirement[0]);
        this.goThroughRubyDoor = new ObjectStep((QuestHelper)this, 30116, new WorldPoint(1640, 4828, 0), "Go through the door with a ruby handle.", this.rubyKey);
        this.takeTinderbox = new ObjectStep((QuestHelper)this, 30146, new WorldPoint(1646, 4826, 0), "Search shelves for a tinderbox.", new Requirement[0]);
        this.lightCandle1 = new ObjectStep((QuestHelper)this, 29655, new WorldPoint(1641, 4826, 0), "Light the unlit candles in the room.", this.tinderbox);
        this.lightCandle1.addIcon(590);
        this.lightCandle2 = new ObjectStep((QuestHelper)this, 29654, new WorldPoint(1647, 4827, 0), "Light the unlit candles in the room.", this.tinderbox);
        this.lightCandle2.addIcon(590);
        this.lightCandle3 = new ObjectStep((QuestHelper)this, 29652, new WorldPoint(1641, 4831, 0), "Light the unlit candles in the room.", this.tinderbox);
        this.lightCandle3.addIcon(590);
        this.lightCandle4 = new ObjectStep((QuestHelper)this, 29653, new WorldPoint(1646, 4832, 0), "Light the unlit candles in the room.", this.tinderbox);
        this.lightCandle4.addIcon(590);
        this.lightBarrel = new ObjectStep((QuestHelper)this, 29651, new WorldPoint(1647, 4830, 0), "Light the fuse on the barrel.", this.tinderbox);
        this.lightBarrel.addIcon(590);
        this.leaveExplosionRoom = new ObjectStep((QuestHelper)this, 30116, new WorldPoint(1640, 4828, 0), "Leave the room to trigger the explosion.", new Requirement[0]);
        this.climbWall = new ObjectStep((QuestHelper)this, 29657, new WorldPoint(1648, 4829, 0), "Climb over the damaged wall.", new Requirement[0]);
        this.observeThroughTree = new ObjectStep((QuestHelper)this, 30150, new WorldPoint(1630, 4849, 0), "Observe Lacey through the trees.", new Requirement[0]);
        this.takeNote2 = new ObjectStep((QuestHelper)this, 2267, new WorldPoint(1632, 4850, 0), "Pick up the note that appeared by the fence.", new Requirement[0]);
        this.readNotes2 = new DetailedQuestStep((QuestHelper)this, "Read the notes.", this.notes2);
        this.playPiano = new ObjectStep((QuestHelper)this, 29658, new WorldPoint(1647, 4842, 0), "Play the piano in the room to the south.", new Requirement[0]);
        this.playD = new WidgetStep((QuestHelper)this, "Play the D key.", 554, 21);
        this.playE = new WidgetStep((QuestHelper)this, "Play the E key.", 554, 22);
        this.playA = new WidgetStep((QuestHelper)this, "Play the A key.", 554, 25);
        this.playDAgain = new WidgetStep((QuestHelper)this, "Play the D key again.", 554, 21);
        this.restartPiano = new DetailedQuestStep((QuestHelper)this, "Unfortunately you've played an incorrect key. Restart.", new Requirement[0]);
        this.searchThePiano = new ObjectStep((QuestHelper)this, 29658, new WorldPoint(1647, 4842, 0), "Search the piano for the emerald key.", new Requirement[0]);
        this.returnOverBrokenWall = new ObjectStep((QuestHelper)this, 29657, new WorldPoint(1648, 4829, 0), "Climb back over the damaged wall into the manor.", this.emeraldKey);
        this.openEmeraldDoor = new ObjectStep((QuestHelper)this, 30117, new WorldPoint(1633, 4837, 0), "Go through the door with a green handle.", this.emeraldKey);
        this.enterBandosGodswordRoomStep = new ObjectStep((QuestHelper)this, 30118, new WorldPoint(1629, 4842, 0), "Try to enter the room with a Bandos Godsword in it.", new Requirement[0]);
        this.takeNote3 = new ObjectStep((QuestHelper)this, 29648, new WorldPoint(1630, 4842, 0), "Pick up the note that appeared by the door.", new Requirement[0]);
        this.readNotes3 = new DetailedQuestStep((QuestHelper)this, "Read the notes.", this.notes3);
        this.useKnifeOnFireplace = new ObjectStep((QuestHelper)this, 29659, new WorldPoint(1647, 4836, 0), "Use a knife on the unlit fireplace in the eastern room.", this.knife);
        this.useKnifeOnFireplace.addIcon(946);
        this.searchFireplace = new ObjectStep((QuestHelper)this, 29659, new WorldPoint(1647, 4836, 0), "Search the fireplace.", new Requirement[0]);
        this.restartGems = new DetailedQuestStep((QuestHelper)this, "You've clicked a gem in the wrong order. Try restarting.", new Requirement[0]);
        this.clickSapphire = new WidgetStep((QuestHelper)this, "Click the sapphire.", 555, 19);
        this.clickDiamond = new WidgetStep((QuestHelper)this, "Click the diamond.", 555, 4);
        this.clickZenyte = new WidgetStep((QuestHelper)this, "Click the zenyte.", 555, 11);
        this.clickEmerald = new WidgetStep((QuestHelper)this, "Click the emerald.", 555, 23);
        this.clickOnyx = new WidgetStep((QuestHelper)this, "Click the onyx.", 555, 7);
        this.clickRuby = new WidgetStep((QuestHelper)this, "Click the ruby.", 555, 15);
        this.searchFireplaceForSapphireKey = new ObjectStep((QuestHelper)this, 29659, new WorldPoint(1647, 4836, 0), "Search the fireplace again for the sapphire key.", new Requirement[0]);
        this.goThroughSapphireDoor = new ObjectStep((QuestHelper)this, 30119, new WorldPoint(1628, 4829, 0), "Go through the sapphire door.", new Requirement[0]);
        this.reflectKnives = new DetailedQuestStep((QuestHelper)this, "This puzzle requires you to move the mirror to reflect the knives the murderer throws. You can tell which wardrobe the murderer will throw from by a black swirl that'll surround it.", new Requirement[0]);
        this.continueThroughSapphireDoor = new ObjectStep((QuestHelper)this, 30119, new WorldPoint(1628, 4829, 0), "Go through the sapphire door to continue.", new Requirement[0]);
        this.pickUpKillersKnife = new DetailedQuestStep((QuestHelper)this, "Pick up the killer's knife.", this.killersKnifeEquipped);
        this.fightAbigale = new NpcStep((QuestHelper)this, 7635, new WorldPoint(1623, 4829, 0), "Equip the killer's knife, then select Fight on Abigale (no actual combat will occur).", this.killersKnifeEquipped);
        this.leaveSapphireRoom = new ObjectStep((QuestHelper)this, 30119, new WorldPoint(1628, 4829, 0), "Attempt to go through the sapphire door.", new Requirement[0]);
        this.talkToMandy = new NpcStep((QuestHelper)this, 7630, new WorldPoint(1636, 4817, 0), "Talk to Mandy just outside the manor to complete the quest.", new Requirement[0]);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 600));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Uncut Ruby", 1619, 1), new ItemReward("Uncut Emerald", 1621, 1), new ItemReward("Uncut Sapphire", 1623, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to Abigale", Collections.singletonList(this.talkToAbigale), new Requirement[0]));
        allSteps.add(new PanelDetails("Enter the manor", Arrays.asList(this.takeTheBoat, this.takeTheBucket, this.searchTheBarrel, this.useBucketOnBarrel, this.searchTheBarrelForKey, this.openManorDoor), new Requirement[0]));
        allSteps.add(new PanelDetails("Solve the first puzzle", Arrays.asList(this.takeKnife, this.tryToOpenPinkKnobDoor, this.takeNote1, this.readNotes1, this.useKnifeOnPainting, this.searchPainting, this.goThroughRubyDoor), new Requirement[0]));
        allSteps.add(new PanelDetails("Solve the second puzzle", Arrays.asList(this.takeTinderbox, this.lightCandle1, this.lightBarrel, this.leaveExplosionRoom, this.climbWall), new Requirement[0]));
        allSteps.add(new PanelDetails("Solve the third puzzle", Arrays.asList(this.observeThroughTree, this.takeNote2, this.readNotes2, this.playPiano, this.playD, this.playE, this.playA, this.playDAgain, this.searchThePiano), new Requirement[0]));
        allSteps.add(new PanelDetails("Witness another murder", Arrays.asList(this.returnOverBrokenWall, this.openEmeraldDoor, this.enterBandosGodswordRoomStep), new Requirement[0]));
        allSteps.add(new PanelDetails("Solve the fourth puzzle", Arrays.asList(this.takeNote3, this.readNotes3, this.useKnifeOnFireplace, this.searchFireplace, this.clickSapphire, this.clickDiamond, this.clickZenyte, this.clickEmerald, this.clickOnyx, this.clickRuby, this.searchFireplaceForSapphireKey), new Requirement[0]));
        allSteps.add(new PanelDetails("Confront the killer", Arrays.asList(this.goThroughSapphireDoor, this.reflectKnives, this.pickUpKillersKnife, this.fightAbigale, this.leaveSapphireRoom, this.talkToMandy), new Requirement[0]));
        return allSteps;
    }
}

