/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.merlinscrystal;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MERLINS_CRYSTAL)
public class MerlinsCrystal
extends BasicQuestHelper {
    ItemRequirement bread;
    ItemRequirement tinderbox;
    ItemRequirement bucketOfWax;
    ItemRequirement batBones;
    ItemRequirement combatGear;
    ItemRequirement bucket;
    ItemRequirement repellent;
    ItemRequirement blackCandle;
    ItemRequirement litBlackCandle;
    ItemRequirement excalibur;
    ItemRequirement batBonesOptional;
    ItemRequirement bucketOfWaxOptional;
    ItemRequirement equippedExcalibur;
    ItemRequirement varrockTeleport;
    ItemRequirement camelotTeleport;
    ItemRequirement twoFaladorTeleports;
    Requirement inFaye;
    Requirement inFayeGround;
    Requirement inFaye1;
    Requirement inFaye2;
    Requirement inCamelot1;
    Requirement inCamelot2;
    Requirement morganNearby;
    Requirement clearedHive;
    Requirement hasAnyBlackCandle;
    Requirement beggarNearby;
    Requirement talkedToLady;
    Requirement hasReadSpell;
    Requirement inCamelot;
    Requirement inStar;
    Requirement thrantaxNearby;
    Requirement inCamelotTower1;
    Requirement inCamelotTower2;
    QuestStep startQuest;
    QuestStep talkToGawain;
    QuestStep goUpstairsInCamelot;
    QuestStep talkToLancelot;
    QuestStep goBackDownStairsCamelot;
    QuestStep hideInArheinCrate;
    QuestStep goToFirstFloor;
    QuestStep goToSecondFloor;
    QuestStep attackMordred;
    QuestStep talkToMorgan;
    QuestStep goToCatherbyAfterFortress;
    QuestStep optionalGetRepellent;
    QuestStep optionalGetBucket;
    QuestStep optionalUseRepellent;
    QuestStep talkToCandleMaker;
    QuestStep talkToLadyOfLake;
    QuestStep enterSarimShopAndTalk;
    QuestStep talkToBeggar;
    QuestStep goReadMagicWords;
    QuestStep returnToCamelot;
    QuestStep returnToCamelotLit;
    QuestStep goStandInStar;
    QuestStep lightCandle;
    QuestStep dropBatBones;
    QuestStep sayWords;
    QuestStep goUpLadder1Camelot;
    QuestStep goUpLadder2Camelot;
    QuestStep smashCrystal;
    QuestStep goDownLadder1Camelot;
    QuestStep goDownLadder2Camelot;
    QuestStep finishQuest;
    ConditionalStep getBlackCandle;
    ConditionalStep getExcalibur;
    Zone fayeGround;
    Zone faye1;
    Zone faye2;
    Zone camelotGround1;
    Zone camelotGround2;
    Zone camelotGround3;
    Zone camelot1;
    Zone camelot2;
    Zone star;
    Zone camelotTower1;
    Zone camelotTower2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuest);
        steps.put(1, this.talkToGawain);
        ConditionalStep findLancelot = new ConditionalStep((QuestHelper)this, this.goUpstairsInCamelot, new Requirement[0]);
        findLancelot.addStep(this.inCamelot1, this.talkToLancelot);
        steps.put(2, findLancelot);
        ConditionalStep discoverHowToFreeMerlin = new ConditionalStep((QuestHelper)this, this.hideInArheinCrate, new Requirement[0]);
        discoverHowToFreeMerlin.addStep(new Conditions(this.inFaye2, this.morganNearby), this.talkToMorgan);
        discoverHowToFreeMerlin.addStep(this.inFaye2, this.attackMordred);
        discoverHowToFreeMerlin.addStep(this.inFaye1, this.goToSecondFloor);
        discoverHowToFreeMerlin.addStep(this.inFayeGround, this.goToFirstFloor);
        discoverHowToFreeMerlin.addStep(this.inCamelot1, this.goBackDownStairsCamelot);
        steps.put(3, discoverHowToFreeMerlin);
        this.getBlackCandle = new ConditionalStep((QuestHelper)this, this.optionalGetRepellent, new Requirement[0]);
        this.getBlackCandle.addStep(this.inFaye, this.goToCatherbyAfterFortress);
        this.getBlackCandle.addStep(this.bucketOfWax, this.talkToCandleMaker);
        this.getBlackCandle.addStep(new Conditions(this.repellent, this.bucket), this.optionalUseRepellent);
        this.getBlackCandle.addStep(this.repellent, this.optionalGetBucket);
        this.getBlackCandle.setLockingCondition(this.hasAnyBlackCandle);
        this.getExcalibur = new ConditionalStep((QuestHelper)this, this.talkToLadyOfLake, new Requirement[0]);
        this.getExcalibur.addStep(this.beggarNearby, this.talkToBeggar);
        this.getExcalibur.addStep(this.talkedToLady, this.enterSarimShopAndTalk);
        this.getExcalibur.setLockingCondition(this.excalibur);
        ConditionalStep performSpell = new ConditionalStep((QuestHelper)this, this.returnToCamelot, new Requirement[0]);
        performSpell.addStep(this.thrantaxNearby, this.sayWords);
        performSpell.addStep(new Conditions(this.inStar, this.litBlackCandle), this.dropBatBones);
        performSpell.addStep(this.inStar, this.lightCandle);
        performSpell.addStep(this.inCamelot, this.goStandInStar);
        performSpell.addStep(this.litBlackCandle, this.returnToCamelotLit);
        ConditionalStep completeAllTasks = new ConditionalStep((QuestHelper)this, (QuestStep)this.getBlackCandle, new Requirement[0]);
        completeAllTasks.addStep(new Conditions(this.hasAnyBlackCandle, this.excalibur, this.hasReadSpell), performSpell);
        completeAllTasks.addStep(new Conditions(this.hasAnyBlackCandle, this.excalibur), this.goReadMagicWords);
        completeAllTasks.addStep(this.hasAnyBlackCandle, this.getExcalibur);
        steps.put(4, completeAllTasks);
        ConditionalStep goFreeMerlin = new ConditionalStep((QuestHelper)this, this.goUpLadder1Camelot, new Requirement[0]);
        goFreeMerlin.addStep(this.inCamelotTower2, this.smashCrystal);
        goFreeMerlin.addStep(this.inCamelotTower1, this.goUpLadder2Camelot);
        steps.put(5, goFreeMerlin);
        ConditionalStep goTellArthur = new ConditionalStep((QuestHelper)this, this.finishQuest, new Requirement[0]);
        goTellArthur.addStep(this.inCamelotTower1, this.goDownLadder1Camelot);
        goTellArthur.addStep(this.inCamelotTower2, this.goDownLadder2Camelot);
        steps.put(6, goTellArthur);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bread = new ItemRequirement("Bread", 2309);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.bucketOfWaxOptional = new ItemRequirement("Bucket of wax", 30);
        this.bucketOfWaxOptional.canBeObtainedDuringQuest();
        this.bucketOfWax = new ItemRequirement("Bucket of wax", 30);
        this.batBones = new ItemRequirement("Bat bones", 530);
        this.batBonesOptional = new ItemRequirement("Bat bones", 530);
        this.batBonesOptional.canBeObtainedDuringQuest();
        this.varrockTeleport = new ItemRequirement("Teleport to Varrock", 8007);
        this.camelotTeleport = new ItemRequirement("Teleport to Camelot", 8010);
        this.twoFaladorTeleports = new ItemRequirement("Teleports to Falador", 8009, 2);
        this.combatGear = new ItemRequirement("Combat gear + food for Sir Mordred (level 39)", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.repellent = new ItemRequirement("Insect repellent", 28).isNotConsumed();
        this.blackCandle = new ItemRequirement("Black candle", 38);
        this.litBlackCandle = new ItemRequirement("Lit black candle", 32);
        this.excalibur = new ItemRequirement("Excalibur", 35).isNotConsumed();
        this.equippedExcalibur = this.excalibur.equipped();
    }

    public void loadZones() {
        this.fayeGround = new Zone(new WorldPoint(2764, 3395, 0), new WorldPoint(2781, 3410, 0));
        this.faye1 = new Zone(new WorldPoint(2764, 3395, 1), new WorldPoint(2781, 3410, 1));
        this.faye2 = new Zone(new WorldPoint(2764, 3395, 2), new WorldPoint(2781, 3410, 2));
        this.camelot1 = new Zone(new WorldPoint(2744, 3483, 1), new WorldPoint(2769, 3517, 1));
        this.camelot2 = new Zone(new WorldPoint(2744, 3483, 2), new WorldPoint(2769, 3517, 2));
        this.camelotGround1 = new Zone(new WorldPoint(2744, 3483, 0), new WorldPoint(2774, 3517, 0));
        this.camelotGround2 = new Zone(new WorldPoint(2775, 3511, 0), new WorldPoint(2783, 3517, 0));
        this.camelotGround3 = new Zone(new WorldPoint(2774, 3505, 0), new WorldPoint(2776, 3511, 0));
        this.star = new Zone(new WorldPoint(2780, 3515, 0), new WorldPoint(2780, 3515, 0));
        this.camelotTower1 = new Zone(new WorldPoint(2765, 3490, 1), new WorldPoint(2770, 3495, 1));
        this.camelotTower2 = new Zone(new WorldPoint(2765, 3490, 2), new WorldPoint(2770, 3494, 2));
    }

    public void setupConditions() {
        this.inFaye = new ZoneRequirement(this.faye1, this.fayeGround, this.faye2);
        this.inFayeGround = new ZoneRequirement(this.fayeGround);
        this.inFaye1 = new ZoneRequirement(this.faye1);
        this.inFaye2 = new ZoneRequirement(this.faye2);
        this.inCamelot = new ZoneRequirement(this.camelotGround1, this.camelotGround2, this.camelotGround3);
        this.inCamelot1 = new ZoneRequirement(this.camelot1);
        this.inCamelot2 = new ZoneRequirement(this.camelot2);
        this.morganNearby = new NpcCondition(3528);
        this.clearedHive = new ObjectCondition(305);
        this.hasAnyBlackCandle = new Conditions(LogicType.OR, this.blackCandle, this.litBlackCandle);
        this.beggarNearby = new NpcCondition(3532);
        this.talkedToLady = new Conditions(true, new DialogRequirement(this.client.getLocalPlayer().getName(), "Ok. That seems easy enough."));
        this.hasReadSpell = new Conditions(true, LogicType.AND, new WidgetTextRequirement(229, 1, "You find a small inscription"));
        this.inStar = new ZoneRequirement(this.star);
        this.thrantaxNearby = new NpcCondition(3518);
        this.inCamelotTower1 = new ZoneRequirement(this.camelotTower1);
        this.inCamelotTower2 = new ZoneRequirement(this.camelotTower2);
    }

    public void setupSteps() {
        this.startQuest = new NpcStep((QuestHelper)this, 3531, new WorldPoint(2763, 3513, 0), "Talk to King Arthur in Camelot Castle to start.", new Requirement[0]);
        this.startQuest.addDialogStep("Yes.");
        this.startQuest.addDialogStep("I want to become a Knight of the Round Table!");
        this.talkToGawain = new NpcStep((QuestHelper)this, 3520, new WorldPoint(2758, 3504, 0), "Talk to Sir Gawain about how Merlin got trapped.", new Requirement[0]);
        this.talkToGawain.addDialogStep("Do you know how Merlin got trapped?");
        this.goUpstairsInCamelot = new ObjectStep((QuestHelper)this, 26106, new WorldPoint(2751, 3511, 0), "Go upstairs to talk to Lancelot.", new Requirement[0]);
        this.talkToLancelot = new NpcStep((QuestHelper)this, 3519, new WorldPoint(2760, 3511, 1), "Talk to Sir Lancelot about getting into Morgan Le Faye's stronghold.", new Requirement[0]);
        this.talkToLancelot.addDialogStep("Any ideas on how to get into Morgan Le Faye's stronghold?");
        this.talkToLancelot.addDialogStep("Thank you for the information.");
        this.goBackDownStairsCamelot = new ObjectStep((QuestHelper)this, 25604, new WorldPoint(2751, 3512, 1), "Hide in Arhein's crate behind the Candle Maker's shop in Catherby.", new Requirement[0]);
        this.hideInArheinCrate = new ObjectStep((QuestHelper)this, 63, new WorldPoint(2801, 3442, 0), "Hide in Arhein's crate behind the Candle Maker's shop in Catherby.", new Requirement[0]);
        this.hideInArheinCrate.addSubSteps(this.goBackDownStairsCamelot);
        this.hideInArheinCrate.addDialogStep("Yes.");
        this.goToFirstFloor = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2770, 3405, 0), "Go up the stairs in the fortress.", new Requirement[0]);
        this.goToSecondFloor = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2770, 3399, 1), "Go up another floor.", new Requirement[0]);
        this.attackMordred = new NpcStep((QuestHelper)this, 3527, new WorldPoint(2770, 3403, 2), "Attack Sir Mordred down to 0hp to cause Morgan Le Faye to spawn.", new Requirement[0]);
        this.attackMordred.addDialogStep("Tell me how to untrap Merlin and I might.");
        this.attackMordred.addDialogStep("Ok I will do all that.");
        this.talkToMorgan = new DetailedQuestStep((QuestHelper)this, "Go through Morgan le Faye's dialog. IF YOU EXIT FROM THIS DIALOG YOU WILL HAVE TO FIGHT MORDRED AGAIN.", new Requirement[0]);
        this.talkToMorgan.addDialogStep("Tell me how to untrap Merlin and I might.");
        this.talkToMorgan.addDialogStep("Ok I will do all that.");
        this.goToCatherbyAfterFortress = new DetailedQuestStep((QuestHelper)this, "Return to Catherby. If you still need bat bones, you can kill one of the bats just outside the fortress.", new Requirement[0]);
        this.optionalGetRepellent = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2807, 3450, 0), "If you still need wax, go grab the insect repellent in a house in north Catherby. Otherwise, get your wax out.", this.repellent);
        this.optionalGetBucket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2766, 3441, 0), "Go grab the bucket in the bee field west of Catherby.", this.bucket);
        this.optionalUseRepellent = new ObjectStep((QuestHelper)this, 68, new WorldPoint(2762, 3443, 0), "Use the insect repellent on a bee hive, then try to take some wax.", this.bucket, this.repellent.highlighted());
        this.talkToCandleMaker = new NpcStep((QuestHelper)this, 3199, new WorldPoint(2797, 3440, 0), "Talk to the Candle Maker in Catherby twice until he gives you a black candle.", this.bucketOfWax);
        this.talkToCandleMaker.addDialogStep("Have you got any black candles?");
        this.talkToLadyOfLake = new NpcStep((QuestHelper)this, 3530, new WorldPoint(2924, 3404, 0), "Talk to the Lady of the Lake in Taverley.", new Requirement[0]);
        this.talkToLadyOfLake.addDialogStep("I seek the sword Excalibur.");
        this.talkToLadyOfLake.setLockingCondition(this.talkedToLady);
        this.enterSarimShopAndTalk = new ObjectStep((QuestHelper)this, 59, new WorldPoint(3016, 3246, 0), "Attempt to enter the jewelery store in Port Sarim.", this.bread);
        this.enterSarimShopAndTalk.addDialogStep("Yes certainly.");
        this.talkToBeggar = new ObjectStep((QuestHelper)this, 59, new WorldPoint(3016, 3246, 0), "Talk to the beggar who appears and give him some bread.", this.bread);
        this.talkToBeggar.addDialogStep("Yes certainly.");
        this.goReadMagicWords = new ObjectStep((QuestHelper)this, 61, new WorldPoint(3260, 3381, 0), "Check the altar in the Zamorak Temple in south east Varrock. If you've already learnt the spell, just mark this step complete in the Quest Helper sidebar.", new Requirement[0]);
        this.goReadMagicWords.setLockingCondition(this.hasReadSpell);
        this.returnToCamelot = new ObjectStep((QuestHelper)this, 26082, new WorldPoint(2758, 3482, 0), "Return to Camelot", this.excalibur, this.blackCandle, this.batBones, this.tinderbox);
        this.returnToCamelotLit = new ObjectStep((QuestHelper)this, 26082, new WorldPoint(2758, 3482, 0), "Return to Camelot", this.excalibur, this.litBlackCandle, this.batBones);
        this.goStandInStar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2780, 3515, 0), "Go stand in the star symbol north east of Camelot Castle.", new Requirement[0]);
        this.goStandInStar.addDialogStep("Snarthon Candtrick Termanto");
        this.lightCandle = new DetailedQuestStep((QuestHelper)this, "Light the Black candle with your tinderbox.", this.blackCandle.highlighted(), this.tinderbox.highlighted());
        this.dropBatBones = new DetailedQuestStep((QuestHelper)this, "Right-click drop the bat bones in the star.", this.batBones.highlighted(), this.excalibur, this.litBlackCandle);
        this.dropBatBones.addDialogStep("Snarthon Candtrick Termanto");
        this.sayWords = new DetailedQuestStep((QuestHelper)this, "Say the spell 'Snarthon Candtrick Termanto'. Be careful not to click the wrong option or you'll have to get another Black Candle.", this.excalibur);
        this.sayWords.addDialogStep("Snarthon Candtrick Termanto");
        this.goUpLadder1Camelot = new ObjectStep((QuestHelper)this, 26107, new WorldPoint(2769, 3493, 0), "Go up the ladder in the south east of Camelot castle.", this.equippedExcalibur);
        this.goUpLadder2Camelot = new ObjectStep((QuestHelper)this, 26107, new WorldPoint(2767, 3491, 1), "Go up the next ladder.", this.equippedExcalibur);
        this.smashCrystal = new ObjectStep((QuestHelper)this, 62, new WorldPoint(2768, 3494, 2), "Smash the Giant Crystal with Excalibur equipped.", this.equippedExcalibur);
        this.goDownLadder1Camelot = new ObjectStep((QuestHelper)this, 25606, new WorldPoint(2769, 3493, 1), "Tell King Arthur you've freed Merlin.", new Requirement[0]);
        this.goDownLadder2Camelot = new ObjectStep((QuestHelper)this, 25606, new WorldPoint(2767, 3491, 2), "Tell King Arthur you've freed Merlin.", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 3531, new WorldPoint(2763, 3513, 0), "Tell King Arthur you've freed Merlin.", new Requirement[0]);
        this.finishQuest.addSubSteps(this.goDownLadder1Camelot, this.goDownLadder2Camelot);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Sir Mordred (level 39)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.combatGear);
        reqs.add(this.bread);
        reqs.add(this.tinderbox);
        reqs.add(this.bucketOfWaxOptional);
        reqs.add(this.batBonesOptional);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.camelotTeleport);
        reqs.add(this.twoFaladorTeleports);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(6);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Excalibur", 35, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.startQuest, this.talkToGawain, this.goUpstairsInCamelot, this.talkToLancelot), new Requirement[0]));
        allSteps.add(new PanelDetails("Infiltrate the fortress", Arrays.asList(this.hideInArheinCrate, this.goToFirstFloor, this.goToSecondFloor, this.attackMordred, this.talkToMorgan), this.combatGear));
        PanelDetails getBlackCandlePanel = new PanelDetails("Get a Black Candle", Arrays.asList(this.goToCatherbyAfterFortress, this.optionalGetRepellent, this.optionalGetBucket, this.optionalUseRepellent, this.talkToCandleMaker), new Requirement[0]);
        getBlackCandlePanel.setLockingStep(this.getBlackCandle);
        getBlackCandlePanel.setVars(4);
        allSteps.add(getBlackCandlePanel);
        PanelDetails getExcaliburPanel = new PanelDetails("Get Excalibur", Arrays.asList(this.talkToLadyOfLake, this.enterSarimShopAndTalk, this.talkToBeggar), this.bread);
        getExcaliburPanel.setLockingStep(this.getExcalibur);
        getExcaliburPanel.setVars(4);
        allSteps.add(getExcaliburPanel);
        PanelDetails readMagicWordsPanel = new PanelDetails("Learn magic words", Collections.singletonList(this.goReadMagicWords), new Requirement[0]);
        readMagicWordsPanel.setLockingStep(this.goReadMagicWords);
        readMagicWordsPanel.setVars(4);
        allSteps.add(readMagicWordsPanel);
        PanelDetails performMagicPanel = new PanelDetails("Perform the spell", Arrays.asList(this.returnToCamelot, this.goStandInStar, this.lightCandle, this.dropBatBones, this.sayWords), this.blackCandle, this.batBones, this.excalibur, this.tinderbox);
        allSteps.add(performMagicPanel);
        allSteps.add(new PanelDetails("Free Merlin", Arrays.asList(this.goUpLadder1Camelot, this.goUpLadder2Camelot, this.smashCrystal, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

