/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.makinghistory;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.ComplexRequirementBuilder;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MAKING_HISTORY)
public class MakingHistory
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement saphAmulet;
    ItemRequirement ghostSpeakAmulet;
    ItemRequirement enchantedKey;
    ItemRequirement chest;
    ItemRequirement journal;
    ItemRequirement scroll;
    ItemRequirement letter;
    ItemRequirement enchantedKeyHighlighted;
    ItemRequirement ectoTokens;
    ComplexRequirement portPhasmatysEntry;
    ItemRequirement ardougneTeleport;
    ItemRequirement ectophial;
    ItemRequirement ringOfDueling;
    ItemRequirement passage;
    ItemRequirement rellekaTeleport;
    ItemRequirement runRestoreItems;
    Requirement talkedtoBlanin;
    Requirement talkedToDron;
    Requirement talkedToMelina;
    Requirement talkedToDroalak;
    Requirement inCastle;
    Requirement gotKey;
    Requirement gotChest;
    Requirement gotScroll;
    Requirement handedInJournal;
    Requirement handedInScroll;
    Requirement finishedFrem;
    Requirement finishedKey;
    Requirement finishedGhost;
    Requirement handedInEverything;
    QuestStep talkToJorral;
    QuestStep talkToSilverMerchant;
    QuestStep dig;
    QuestStep openChest;
    QuestStep talkToBlanin;
    QuestStep talkToDron;
    QuestStep talkToDroalak;
    QuestStep talkToMelina;
    QuestStep returnToDroalak;
    QuestStep returnToJorral;
    QuestStep continueTalkingToJorral;
    QuestStep goUpToLathas;
    QuestStep talkToLathas;
    QuestStep finishQuest;
    ConditionalStep dronSteps;
    ConditionalStep ghostSteps;
    ConditionalStep keySteps;
    Zone castle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToJorral);
        this.keySteps = new ConditionalStep((QuestHelper)this, this.talkToSilverMerchant, new Requirement[0]);
        this.keySteps.addStep(this.chest, this.openChest);
        this.keySteps.addStep(this.gotKey, this.dig);
        this.keySteps.setLockingCondition(this.finishedKey);
        this.dronSteps = new ConditionalStep((QuestHelper)this, this.talkToBlanin, new Requirement[0]);
        this.dronSteps.addStep(this.talkedtoBlanin, this.talkToDron);
        this.dronSteps.setLockingCondition(this.finishedFrem);
        this.ghostSteps = new ConditionalStep((QuestHelper)this, this.talkToDroalak, new Requirement[0]);
        this.ghostSteps.addStep(this.talkedToMelina, this.returnToDroalak);
        this.ghostSteps.addStep(this.talkedToDroalak, this.talkToMelina);
        this.ghostSteps.setLockingCondition(this.finishedGhost);
        ConditionalStep getItems = new ConditionalStep((QuestHelper)this, (QuestStep)this.keySteps, new Requirement[0]);
        getItems.addStep(this.handedInEverything, this.continueTalkingToJorral);
        getItems.addStep(new Conditions(this.finishedKey, this.finishedFrem, this.finishedGhost), this.returnToJorral);
        getItems.addStep(new Conditions(this.finishedKey, this.finishedFrem), this.ghostSteps);
        getItems.addStep(this.finishedKey, this.dronSteps);
        steps.put(1, getItems);
        ConditionalStep goTalkToLathas = new ConditionalStep((QuestHelper)this, this.goUpToLathas, new Requirement[0]);
        goTalkToLathas.addStep(this.inCastle, this.talkToLathas);
        steps.put(2, goTalkToLathas);
        steps.put(3, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.saphAmulet = new ItemRequirement("Sapphire amulet", 1694);
        this.ghostSpeakAmulet = new ItemRequirement("Ghostspeak amulet", ItemCollections.GHOSTSPEAK).equipped().isNotConsumed();
        this.ghostSpeakAmulet.setTooltip("You can also wear the Morytania Legs 2 or higher.");
        this.ardougneTeleport = new ItemRequirement("Teleports to Ardougne", 8011, 3);
        this.ectophial = new ItemRequirement("Ectophial, or method of getting to Port Phasmatys", 4251).isNotConsumed();
        this.ectophial.addAlternates(19621, 12779);
        this.ectophial.addAlternates(ItemCollections.SLAYER_RINGS);
        this.ectophial.addAlternates(13113, 13114, 13115);
        this.ectophial.setTooltip("You will need 2 ecto-tokens if you have not completed Ghosts Ahoy.");
        this.ectophial.appendToTooltip("If you do not have 2 ecto-tokens bring 1 bone, 1 pot and 1 bucket to earn 5 ecto-tokens at the Ectofunctus.\n");
        this.ectophial.appendToTooltip("You can use the Fairy Ring 'ALQ' or the Morytania Legs 2 or higher to get to Port Phasmatys.");
        this.ectophial.appendToTooltip("Slayer rings and the Kharyrll teleport can also be used.");
        this.ectoTokens = new ItemRequirement("Ecto-tokens", 4278, 2);
        this.ectoTokens.setTooltip("You do not need two ecto-tokens if you have completed Ghosts Ahoy.");
        this.ectoTokens.appendToTooltip("If you do not have 2 ecto-tokens bring 1 bone, 1 pot and 1 bucket to earn 5 ecto-tokens at the Ectofunctus.");
        this.ectoTokens.appendToTooltip("Additionally, you can also enter Port Phasmatys via Charter ship, but that costs up to 4,100 coins.");
        this.portPhasmatysEntry = ComplexRequirementBuilder.or("2 x Ecto-tokens, or 4100 coins to travel there via Charter Ship").with(this.ectoTokens).with(new QuestRequirement(QuestHelperQuest.GHOSTS_AHOY, QuestState.FINISHED)).with(new ItemRequirement("Coins", ItemCollections.COINS, 4100)).build();
        this.portPhasmatysEntry.setTooltip(this.ectoTokens.getTooltip());
        this.ringOfDueling = new ItemRequirement("Ring of Dueling", ItemCollections.RING_OF_DUELINGS);
        this.enchantedKey = new KeyringRequirement("Enchanted key", this.configManager, KeyringCollection.ENCHANTED_KEY);
        this.enchantedKey.setTooltip("You can get another from the silver merchant in East Ardougne's market");
        this.enchantedKeyHighlighted = new ItemRequirement("Enchanted key", 6754);
        this.enchantedKeyHighlighted.setTooltip("You can get another from the silver merchant in East Ardougne's market");
        this.enchantedKeyHighlighted.setHighlightInInventory(true);
        this.journal = new ItemRequirement("Journal", 6755);
        this.chest = new ItemRequirement("Chest", 6759);
        this.chest.setTooltip("You can dig up another from north of Castle Wars");
        this.chest.setHighlightInInventory(true);
        this.scroll = new ItemRequirement("Scroll", 6758);
        this.scroll.setTooltip("You can get another from Droalak in Port Phasmatys");
        this.letter = new ItemRequirement("Letter", 6757);
        this.letter.setTooltip("You can get another from King Lathas in East Ardougne castle");
        this.passage = new ItemRequirement("Necklace of passage", ItemCollections.NECKLACE_OF_PASSAGES);
        this.rellekaTeleport = new ItemRequirement("Relleka Teleport", 11744);
        this.rellekaTeleport.addAlternates(ItemCollections.ENCHANTED_LYRE);
        this.rellekaTeleport.addAlternates(13130, 13131, 13132);
        this.rellekaTeleport.setTooltip("You can also use Fairy Rings (DKS or AJR) if you have those unlocked.");
        this.rellekaTeleport.appendToTooltip("You can also teleport to Camelot and run North.");
        this.runRestoreItems = new ItemRequirement("Potions/Items to restore run energy", ItemCollections.RUN_RESTORE_ITEMS);
    }

    public void loadZones() {
        this.castle = new Zone(new WorldPoint(2570, 3283, 1), new WorldPoint(2590, 3310, 1));
    }

    public void setupConditions() {
        this.talkedtoBlanin = new Conditions(LogicType.OR, new VarbitRequirement(1385, 1), new VarbitRequirement(1385, 2));
        this.talkedToDron = new VarbitRequirement(1385, 3, Operation.GREATER_EQUAL);
        this.talkedToDroalak = new Conditions(LogicType.OR, new VarbitRequirement(1386, 2), new VarbitRequirement(1386, 1));
        this.talkedToMelina = new Conditions(LogicType.OR, new VarbitRequirement(1386, 4), new VarbitRequirement(1386, 3));
        this.gotScroll = new VarbitRequirement(1386, 5);
        this.handedInScroll = new VarbitRequirement(1386, 6);
        this.inCastle = new ZoneRequirement(this.castle);
        this.gotKey = new VarbitRequirement(1384, 1, Operation.GREATER_EQUAL);
        this.gotChest = new VarbitRequirement(1384, 2, Operation.GREATER_EQUAL);
        this.handedInJournal = new VarbitRequirement(1384, 4);
        this.handedInEverything = new Conditions(this.handedInJournal, this.handedInScroll, this.talkedToDron);
        this.finishedFrem = this.talkedToDron;
        this.finishedGhost = new Conditions(LogicType.OR, this.handedInScroll, this.gotScroll);
        this.finishedKey = new Conditions(LogicType.OR, this.handedInJournal, this.journal);
    }

    public void setupSteps() {
        this.talkToJorral = new NpcStep((QuestHelper)this, 3490, new WorldPoint(2436, 3346, 0), "Talk to Jorral at the outpost south of the Tree Gnome Stronghold. You can teleport there with a Necklace of Passage.", new Requirement[0]);
        this.talkToJorral.addDialogStep("The Outpost");
        this.talkToJorral.addDialogStep("Tell me more.");
        this.talkToJorral.addDialogStep("Ok, I'll make a stand for history!");
        this.talkToSilverMerchant = new NpcStep((QuestHelper)this, 8722, new WorldPoint(2658, 3316, 0), "Talk to the Silver Merchant in the East Ardougne Market.", new Requirement[0]);
        this.talkToSilverMerchant.addDialogStep("Ask about the outpost.");
        this.dig = new DigStep((QuestHelper)this, new WorldPoint(2442, 3140, 0), "Dig at the marked spot north of Castle Wars.", this.enchantedKey);
        this.openChest = new DetailedQuestStep((QuestHelper)this, "Use the enchanted key on the chest.", this.enchantedKeyHighlighted, this.chest);
        this.talkToBlanin = new NpcStep((QuestHelper)this, 3496, new WorldPoint(2673, 3670, 0), "Talk to Blanin in south east Rellekka.", new Requirement[0]);
        this.talkToDron = new NpcStep((QuestHelper)this, 3495, new WorldPoint(2661, 3698, 0), "Talk to Dron in north Rellekka.", new Requirement[0]);
        this.talkToDron.addDialogStep("I'm after important answers.");
        this.talkToDron.addDialogStep("Why, you're the famous warrior Dron!");
        this.talkToDron.addDialogStep("An iron mace");
        this.talkToDron.addDialogStep(1, "Breakfast");
        this.talkToDron.addDialogStep(2, "Lunch");
        this.talkToDron.addDialogStep("Bunnies");
        this.talkToDron.addDialogStep("Red");
        this.talkToDron.addDialogStep("36");
        this.talkToDron.addDialogStep("8");
        this.talkToDron.addDialogStep("Fifth and Fourth");
        this.talkToDron.addDialogStep("North East side of town");
        this.talkToDron.addDialogStep("Blanin");
        this.talkToDron.addDialogStep("Fluffy");
        this.talkToDron.addDialogStep("12, but what does that have to do with anything?");
        this.talkToDroalak = new NpcStep((QuestHelper)this, 3494, new WorldPoint(3659, 3468, 0), "Enter Port Phasmatys and talk to Droalak outside the general store.", this.ghostSpeakAmulet, this.portPhasmatysEntry);
        this.talkToMelina = new NpcStep((QuestHelper)this, 3492, new WorldPoint(3674, 3479, 0), "Give Melina a sapphire amulet in the house north east of the general store.", this.saphAmulet, this.ghostSpeakAmulet);
        this.returnToDroalak = new NpcStep((QuestHelper)this, 3494, new WorldPoint(3659, 3468, 0), "Return to Droalak outside the general store.", new Requirement[0]);
        this.returnToJorral = new NpcStep((QuestHelper)this, 3490, new WorldPoint(2436, 3346, 0), "Return to Jorral north of West Ardougne with the scroll and journal.", this.scroll, this.journal);
        this.continueTalkingToJorral = new NpcStep((QuestHelper)this, 3490, new WorldPoint(2436, 3346, 0), "Return to Jorral north of West Ardougne.", new Requirement[0]);
        this.returnToJorral.addSubSteps(this.continueTalkingToJorral);
        this.goUpToLathas = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2572, 3296, 0), "Talk to King Lathas in East Ardougne castle.", new Requirement[0]);
        this.talkToLathas = new NpcStep((QuestHelper)this, 9005, new WorldPoint(2578, 3293, 1), "Talk to King Lathas in East Ardougne castle.", new Requirement[0]);
        this.talkToLathas.addDialogStep("Talk about the outpost.");
        this.talkToLathas.addSubSteps(this.goUpToLathas);
        this.finishQuest = new NpcStep((QuestHelper)this, 3490, new WorldPoint(2436, 3346, 0), "Return to Jorral north of West Ardougne with the letter to finish the quest.", this.letter);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.spade);
        reqs.add(this.saphAmulet);
        reqs.add(this.ghostSpeakAmulet);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.ardougneTeleport);
        reqs.add(this.ectophial);
        reqs.add(this.ringOfDueling);
        reqs.add(this.passage);
        reqs.add(this.rellekaTeleport);
        reqs.add(this.runRestoreItems);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 1000), new ExperienceReward(Skill.PRAYER, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 750), new ItemReward("An Enchanted Key", 6754, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToJorral), new Requirement[0]));
        PanelDetails chestPanel = new PanelDetails("Find the book", Arrays.asList(this.talkToSilverMerchant, this.dig, this.openChest), this.spade);
        chestPanel.setLockingStep(this.keySteps);
        PanelDetails fremPanel = new PanelDetails("Fremennik tale", Arrays.asList(this.talkToBlanin, this.talkToDron), new Requirement[0]);
        fremPanel.setLockingStep(this.dronSteps);
        PanelDetails ghostPanel = new PanelDetails("Find the scroll", Arrays.asList(this.talkToDroalak, this.talkToMelina, this.returnToDroalak), this.saphAmulet, this.ghostSpeakAmulet, this.portPhasmatysEntry);
        ghostPanel.setLockingStep(this.ghostSteps);
        PanelDetails finishingPanel = new PanelDetails("Finishing off", Arrays.asList(this.returnToJorral, this.talkToLathas, this.finishQuest), new Requirement[0]);
        allSteps.add(chestPanel);
        allSteps.add(fremPanel);
        allSteps.add(ghostPanel);
        allSteps.add(finishingPanel);
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.IN_PROGRESS));
    }
}

