/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.lunardiplomacy;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.EmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class MimicChallenge
extends DetailedOwnerStep {
    DetailedQuestStep cry;
    DetailedQuestStep bow;
    DetailedQuestStep dance;
    DetailedQuestStep wave;
    DetailedQuestStep think;
    DetailedQuestStep talk;

    public MimicChallenge(QuestHelper questHelper) {
        super(questHelper, "Copy the emotes that the NPC does.", new Requirement[0]);
    }

    @Override
    public void setupSteps() {
        this.cry = new EmoteStep(this.getQuestHelper(), QuestEmote.CRY, new WorldPoint(1769, 5058, 2), "Perform the cry emote.", new Requirement[0]);
        this.bow = new EmoteStep(this.getQuestHelper(), QuestEmote.BOW, new WorldPoint(1770, 5063, 2), "Perform the bow emote.", new Requirement[0]);
        this.dance = new EmoteStep(this.getQuestHelper(), QuestEmote.DANCE, new WorldPoint(1772, 5070, 2), "Perform the dance emote.", new Requirement[0]);
        this.wave = new EmoteStep(this.getQuestHelper(), QuestEmote.WAVE, new WorldPoint(1767, 5061, 2), "Perform the wave emote.", new Requirement[0]);
        this.think = new EmoteStep(this.getQuestHelper(), QuestEmote.THINK, new WorldPoint(1772, 5070, 2), "Perform the think emote.", new Requirement[0]);
        this.talk = new NpcStep(this.getQuestHelper(), 784, "Talk to the Ethereal Mimic.", new Requirement[0]);
        this.talk.addDialogStep("Suppose I may as well have a go.");
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        if (this.client.getVarbitValue(2419) == 0) {
            this.startUpStep(this.talk);
            return;
        }
        switch (this.client.getVarbitValue(2420)) {
            case 1: {
                this.startUpStep(this.cry);
                break;
            }
            case 2: {
                this.startUpStep(this.bow);
                break;
            }
            case 3: {
                this.startUpStep(this.dance);
                break;
            }
            case 4: {
                this.startUpStep(this.wave);
                break;
            }
            case 5: {
                this.startUpStep(this.think);
                break;
            }
            default: {
                this.startUpStep(this.talk);
            }
        }
    }

    public void chooseStepBasedOnIfTalked(QuestStep emoteStep) {
        if (this.client.getVarbitValue(2419) == 1) {
            this.startUpStep(emoteStep);
        } else {
            this.startUpStep(this.talk);
        }
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.talk, this.cry, this.bow, this.dance, this.think, this.wave);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.talk, this.cry, this.bow, this.dance, this.think, this.wave);
    }
}

