/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.lunardiplomacy;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.tools.QuestPerspective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class MemoryChallenge
extends DetailedQuestStep {
    List<WorldPoint> wps = new ArrayList<WorldPoint>();
    List<WorldPoint> currentPath = new ArrayList<WorldPoint>();
    int column1;
    int column2;
    int column3;
    int column4;
    int lastPos;

    public MemoryChallenge(QuestHelper questHelper) {
        super(questHelper, "Work out the route across the cloud tiles through trial and error.", new Requirement[0]);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.setupPaths();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.setupPaths();
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.wps.size() == 0) {
            return;
        }
        if (this.lastPos + 1 == this.wps.size()) {
            return;
        }
        if (this.currentPath.size() == 0) {
            this.checkNextTile(0);
            return;
        }
        WorldPoint lastPoint = this.currentPath.get(this.currentPath.size() - 1);
        WorldPoint instanceWp = this.wps.get(this.lastPos);
        if (instanceWp == null) {
            return;
        }
        if (instanceWp.distanceTo(lastPoint) == 0 && this.wps.get(this.lastPos + 1) != null) {
            this.checkNextTile(this.lastPos + 1);
        }
    }

    public void checkNextTile(int wpsPos) {
        WorldPoint instanceWp = QuestPerspective.getInstanceWorldPointFromReal(this.client, this.wps.get(wpsPos));
        if (instanceWp == null) {
            return;
        }
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getWorldLocation().distanceTo(instanceWp) == 0) {
            this.currentPath.add(this.wps.get(wpsPos));
            this.lastPos = wpsPos;
            this.setLinePoints(this.currentPath);
        }
    }

    public void setupPaths() {
        int current1 = this.client.getVarbitValue(2412);
        int current2 = this.client.getVarbitValue(2413);
        int current3 = this.client.getVarbitValue(2414);
        int current4 = this.client.getVarbitValue(2415);
        if (current1 == this.column1 && current2 == this.column2 && current3 == this.column3 && current4 == this.column4) {
            return;
        }
        this.column1 = current1;
        this.column2 = current2;
        this.column3 = current3;
        this.column4 = current4;
        this.setLinePoints(new ArrayList<WorldPoint>());
        this.currentPath = new ArrayList<WorldPoint>();
        if (this.client.getVarbitValue(2415) == 123) {
            this.wps = Arrays.asList(new WorldPoint(1734, 5108, 2), new WorldPoint(1734, 5106, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1740, 5103, 2), new WorldPoint(1740, 5100, 2), new WorldPoint(1740, 5097, 2), new WorldPoint(1740, 5094, 2), new WorldPoint(1737, 5094, 2), new WorldPoint(1734, 5094, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1731, 5088, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1740, 5088, 2), new WorldPoint(1740, 5085, 2), new WorldPoint(1740, 5083, 2));
            this.setWorldPoint(1740, 5083, 2);
        } else if (this.client.getVarbitValue(2413) == 3) {
            this.wps = Arrays.asList(new WorldPoint(1740, 5108, 2), new WorldPoint(1740, 5106, 2), new WorldPoint(1740, 5103, 2), new WorldPoint(1740, 5100, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1737, 5094, 2), new WorldPoint(1740, 5094, 2), new WorldPoint(1740, 5091, 2), new WorldPoint(1740, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1734, 5085, 2), new WorldPoint(1734, 5083, 2));
            this.setWorldPoint(1734, 5083, 2);
        } else if (this.client.getVarbitValue(2414) == 192) {
            this.wps = Arrays.asList(new WorldPoint(1737, 5108, 2), new WorldPoint(1737, 5106, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1731, 5103, 2), new WorldPoint(1731, 5100, 2), new WorldPoint(1731, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1734, 5094, 2), new WorldPoint(1734, 5091, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1731, 5088, 2), new WorldPoint(1731, 5085, 2), new WorldPoint(1731, 5083, 2));
            this.setWorldPoint(1731, 5083, 2);
        } else if (this.client.getVarbitValue(2412) == 28) {
            this.wps = Arrays.asList(new WorldPoint(1734, 5108, 2), new WorldPoint(1734, 5106, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1731, 5097, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1734, 5091, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1737, 5085, 2), new WorldPoint(1737, 5083, 2));
            this.setWorldPoint(1731, 5083, 2);
        } else if (this.client.getVarbitValue(2414) == 83) {
            this.wps = Arrays.asList(new WorldPoint(1731, 5108, 2), new WorldPoint(1731, 5106, 2), new WorldPoint(1731, 5103, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1740, 5103, 2), new WorldPoint(1740, 5100, 2), new WorldPoint(1740, 5097, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1731, 5097, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1731, 5088, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1737, 5085, 2), new WorldPoint(1737, 5083, 2));
            this.setWorldPoint(1737, 5083, 2);
        } else if (this.client.getVarbitValue(2415) == 7) {
            this.wps = Arrays.asList(new WorldPoint(1731, 5108, 2), new WorldPoint(1731, 5106, 2), new WorldPoint(1731, 5103, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1731, 5097, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1734, 5091, 2), new WorldPoint(1737, 5091, 2), new WorldPoint(1740, 5091, 2), new WorldPoint(1740, 5088, 2), new WorldPoint(1740, 5085, 2), new WorldPoint(1740, 5083, 2));
            this.setWorldPoint(1740, 5083, 2);
        } else if (this.client.getVarbitValue(2414) == 42) {
            this.wps = Arrays.asList(new WorldPoint(1731, 5108, 2), new WorldPoint(1731, 5106, 2), new WorldPoint(1731, 5103, 2), new WorldPoint(1731, 5100, 2), new WorldPoint(1734, 5100, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1740, 5100, 2), new WorldPoint(1740, 5097, 2), new WorldPoint(1740, 5094, 2), new WorldPoint(1737, 5094, 2), new WorldPoint(1734, 5094, 2), new WorldPoint(1734, 5091, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1740, 5088, 2), new WorldPoint(1740, 5085, 2), new WorldPoint(1740, 5083, 2));
            this.setWorldPoint(1740, 5083, 2);
        } else if (this.client.getVarbitValue(2414) == 91) {
            this.wps = Arrays.asList(new WorldPoint(1734, 5108, 2), new WorldPoint(1734, 5106, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1740, 5103, 2), new WorldPoint(1740, 5100, 2), new WorldPoint(1740, 5097, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1737, 5094, 2), new WorldPoint(1734, 5094, 2), new WorldPoint(1734, 5091, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1737, 5085, 2), new WorldPoint(1737, 5083, 2));
            this.setWorldPoint(1737, 5083, 2);
        } else if (this.client.getVarbitValue(2413) == 218) {
            this.wps = Arrays.asList(new WorldPoint(1734, 5108, 2), new WorldPoint(1734, 5106, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1734, 5094, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1731, 5088, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1737, 5085, 2), new WorldPoint(1737, 5083, 2));
            this.setWorldPoint(1737, 5083, 2);
        } else if (this.client.getVarbitValue(2415) == 120) {
            this.wps = Arrays.asList(new WorldPoint(1734, 5108, 2), new WorldPoint(1734, 5106, 2), new WorldPoint(1734, 5103, 2), new WorldPoint(1737, 5103, 2), new WorldPoint(1737, 5100, 2), new WorldPoint(1737, 5097, 2), new WorldPoint(1734, 5097, 2), new WorldPoint(1731, 5097, 2), new WorldPoint(1731, 5094, 2), new WorldPoint(1731, 5091, 2), new WorldPoint(1731, 5088, 2), new WorldPoint(1734, 5088, 2), new WorldPoint(1737, 5088, 2), new WorldPoint(1737, 5085, 2), new WorldPoint(1737, 5083, 2));
            this.setWorldPoint(1737, 5083, 2);
        }
    }
}

