/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.lunardiplomacy;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class ChanceChallenge
extends DetailedOwnerStep {
    DetailedQuestStep talk;
    DetailedQuestStep spinD1;
    DetailedQuestStep spinD2;
    DetailedQuestStep spinD3;
    DetailedQuestStep spinD4;
    DetailedQuestStep spinD5;
    DetailedQuestStep spinD6;
    int currentGoal;
    HashMap<Integer, List<Integer>> solutions = new HashMap();

    public ChanceChallenge(QuestHelper questHelper) {
        super(questHelper, "Flip the dice to sum up to the correct number.", new Requirement[0]);
        this.setupSolutions();
    }

    public void setupSolutions() {
        this.solutions.put(12, Arrays.asList(1, 1, 2, 2, 3, 3));
        this.solutions.put(13, Arrays.asList(1, 1, 2, 2, 3, 4));
        this.solutions.put(14, Arrays.asList(1, 1, 2, 2, 4, 4));
        this.solutions.put(15, Arrays.asList(1, 1, 2, 5, 3, 3));
        this.solutions.put(16, Arrays.asList(1, 1, 2, 5, 3, 4));
        this.solutions.put(17, Arrays.asList(1, 1, 2, 5, 4, 4));
        this.solutions.put(18, Arrays.asList(1, 1, 5, 5, 3, 3));
        this.solutions.put(19, Arrays.asList(1, 1, 5, 5, 3, 4));
        this.solutions.put(20, Arrays.asList(1, 1, 5, 5, 4, 4));
        this.solutions.put(21, Arrays.asList(1, 6, 2, 5, 3, 4));
        this.solutions.put(22, Arrays.asList(1, 6, 2, 5, 4, 4));
        this.solutions.put(23, Arrays.asList(1, 6, 5, 5, 3, 3));
        this.solutions.put(24, Arrays.asList(1, 6, 5, 5, 3, 4));
        this.solutions.put(25, Arrays.asList(1, 6, 5, 5, 4, 4));
        this.solutions.put(26, Arrays.asList(6, 6, 2, 5, 3, 4));
        this.solutions.put(27, Arrays.asList(6, 6, 2, 5, 4, 4));
        this.solutions.put(28, Arrays.asList(6, 6, 5, 5, 3, 3));
        this.solutions.put(29, Arrays.asList(6, 6, 5, 5, 3, 4));
        this.solutions.put(30, Arrays.asList(6, 6, 5, 5, 4, 4));
    }

    @Override
    public void setupSteps() {
        this.talk = new NpcStep(this.getQuestHelper(), 783, new WorldPoint(1737, 5068, 2), "Talk to the Ethereal Fluke, and solve his puzzle.", new Requirement[0]);
        this.talk.addDialogStep("Suppose I may as well have a go.");
        this.spinD1 = new ObjectStep(this.getQuestHelper(), 17019, new WorldPoint(1735, 5064, 2), "Flip the centre west die.", new Requirement[0]);
        this.spinD2 = new ObjectStep(this.getQuestHelper(), 17024, new WorldPoint(1737, 5063, 2), "Flip the centre east die.", new Requirement[0]);
        this.spinD3 = new ObjectStep(this.getQuestHelper(), 17023, new WorldPoint(1732, 5067, 2), "Flip the north west die.", new Requirement[0]);
        this.spinD4 = new ObjectStep(this.getQuestHelper(), 17020, new WorldPoint(1732, 5060, 2), "Flip the south west die.", new Requirement[0]);
        this.spinD5 = new ObjectStep(this.getQuestHelper(), 17022, new WorldPoint(1739, 5067, 2), "Flip the north east die.", new Requirement[0]);
        this.spinD6 = new ObjectStep(this.getQuestHelper(), 17021, new WorldPoint(1739, 5060, 2), "Flip the south east die.", new Requirement[0]);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        this.currentGoal = this.client.getVarbitValue(2411);
        if (this.currentGoal == 0) {
            this.startUpStep(this.talk);
            return;
        }
        int die16A = this.client.getVarbitValue(2399);
        die16A = die16A == 0 ? 1 : 6;
        int die16B = this.client.getVarbitValue(2404);
        die16B = die16B == 0 ? 6 : 1;
        int die25A = this.client.getVarbitValue(2403);
        die25A = die25A == 0 ? 5 : 2;
        int die25B = this.client.getVarbitValue(2400);
        die25B = die25B == 0 ? 2 : 5;
        int die34A = this.client.getVarbitValue(2402);
        die34A = die34A == 0 ? 4 : 3;
        int die34B = this.client.getVarbitValue(2401);
        die34B = die34B == 0 ? 3 : 4;
        this.checkSolutions(die16A, die16B, die25A, die25B, die34A, die34B);
    }

    public void checkSolutions(int d1, int d2, int d3, int d4, int d5, int d6) {
        List<Integer> solution = this.solutions.get(this.currentGoal);
        if (solution == null) {
            this.startUpStep(this.talk);
        } else if (d1 != solution.get(0)) {
            this.startUpStep(this.spinD1);
        } else if (d2 != solution.get(1)) {
            this.startUpStep(this.spinD2);
        } else if (d3 != solution.get(2)) {
            this.startUpStep(this.spinD3);
        } else if (d4 != solution.get(3)) {
            this.startUpStep(this.spinD4);
        } else if (d5 != solution.get(4)) {
            this.startUpStep(this.spinD5);
        } else if (d6 != solution.get(5)) {
            this.startUpStep(this.spinD6);
        }
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.talk, this.spinD1, this.spinD2, this.spinD3, this.spinD4, this.spinD5, this.spinD6);
    }

    public List<QuestStep> getDisplaySteps() {
        return Collections.singletonList(this.talk);
    }
}

