/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.lunardiplomacy;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.steps.NpcStep;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class BringLunarItems
extends NpcStep {
    Requirement handedInHelm;
    Requirement handedInCape;
    Requirement handedInAmulet;
    Requirement handedInTorso;
    Requirement handedInGloves;
    Requirement handedInBoots;
    Requirement handedInLegs;
    Requirement handedInRing;
    ItemRequirement helm;
    ItemRequirement cape;
    ItemRequirement amulet;
    ItemRequirement torso;
    ItemRequirement gloves;
    ItemRequirement boots;
    ItemRequirement legs;
    ItemRequirement ring;
    ItemRequirement sealOfPassage;

    public BringLunarItems(QuestHelper questHelper) {
        super(questHelper, 3835, new WorldPoint(2151, 3867, 0), "Bring all the items to the Oneiromancer in the south east of Lunar Isle.", new Requirement[0]);
        this.setupRequirements();
        this.setupConditions();
    }

    public void setupRequirements() {
        this.helm = new ItemRequirement("Lunar helm", 9096);
        this.amulet = new ItemRequirement("Lunar amulet", 9102);
        this.ring = new ItemRequirement("Lunar ring", 9104);
        this.cape = new ItemRequirement("Lunar cape", 9101);
        this.torso = new ItemRequirement("Lunar torso", 9097);
        this.gloves = new ItemRequirement("Lunar gloves", 9099);
        this.boots = new ItemRequirement("Lunar boots", 9100);
        this.legs = new ItemRequirement("Lunar legs", 9098);
    }

    public void setupConditions() {
        this.sealOfPassage = new ItemRequirement("Seal of passage", 9083);
        this.sealOfPassage.setTooltip("You can get another from Brundt");
        this.handedInHelm = new VarbitRequirement(2436, 1);
        this.handedInCape = new VarbitRequirement(2437, 1);
        this.handedInAmulet = new VarbitRequirement(2438, 1);
        this.handedInTorso = new VarbitRequirement(2439, 1);
        this.handedInGloves = new VarbitRequirement(2441, 1);
        this.handedInBoots = new VarbitRequirement(2440, 1);
        this.handedInLegs = new VarbitRequirement(2442, 1);
        this.handedInRing = new VarbitRequirement(2443, 1);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.updateStep();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.updateStep();
    }

    public void updateStep() {
        this.emptyRequirements();
        this.addRequirement((Requirement)this.sealOfPassage);
        if (!this.handedInAmulet.check(this.client)) {
            this.addRequirement((Requirement)this.amulet);
        }
        if (!this.handedInBoots.check(this.client)) {
            this.addRequirement((Requirement)this.boots);
        }
        if (!this.handedInCape.check(this.client)) {
            this.addRequirement((Requirement)this.cape);
        }
        if (!this.handedInGloves.check(this.client)) {
            this.addRequirement((Requirement)this.gloves);
        }
        if (!this.handedInHelm.check(this.client)) {
            this.addRequirement((Requirement)this.helm);
        }
        if (!this.handedInLegs.check(this.client)) {
            this.addRequirement((Requirement)this.legs);
        }
        if (!this.handedInRing.check(this.client)) {
            this.addRequirement((Requirement)this.ring);
        }
        if (!this.handedInTorso.check(this.client)) {
            this.addRequirement((Requirement)this.torso);
        }
    }
}

