/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.lostcity;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LOST_CITY)
public class LostCity
extends BasicQuestHelper {
    ItemRequirement knife;
    ItemRequirement axe;
    ItemRequirement combatGear;
    ItemRequirement teleport;
    ItemRequirement bronzeAxe;
    ItemRequirement dramenBranch;
    ItemRequirement dramenStaff;
    ItemRequirement dramenStaffEquipped;
    Requirement onEntrana;
    Requirement inDungeon;
    Requirement shamusNearby;
    Requirement bronzeAxeNearby;
    Requirement dramenSpiritNearby;
    QuestStep talkToWarrior;
    QuestStep chopTree;
    QuestStep talkToShamus;
    QuestStep goToEntrana;
    QuestStep goDownHole;
    QuestStep getAxe;
    QuestStep pickupAxe;
    QuestStep attemptToCutDramen;
    QuestStep killDramenSpirit;
    QuestStep cutDramenBranch;
    QuestStep teleportAway;
    QuestStep craftBranch;
    QuestStep enterZanaris;
    QuestStep getAnotherBranch;
    Zone entrana;
    Zone entranaDungeon;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToWarrior);
        ConditionalStep findShamus = new ConditionalStep((QuestHelper)this, this.chopTree, new Requirement[0]);
        findShamus.addStep(this.shamusNearby, this.talkToShamus);
        steps.put(1, findShamus);
        ConditionalStep killingTheSpirit = new ConditionalStep((QuestHelper)this, this.goToEntrana, new Requirement[0]);
        killingTheSpirit.addStep(new Conditions(this.inDungeon, this.dramenSpiritNearby), this.killDramenSpirit);
        killingTheSpirit.addStep(new Conditions(this.inDungeon, this.bronzeAxe), this.attemptToCutDramen);
        killingTheSpirit.addStep(new Conditions(this.inDungeon, this.bronzeAxeNearby), this.pickupAxe);
        killingTheSpirit.addStep(this.inDungeon, this.getAxe);
        killingTheSpirit.addStep(this.onEntrana, this.goDownHole);
        steps.put(2, killingTheSpirit);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.getAnotherBranch, new Requirement[0]);
        finishQuest.addStep(new Conditions(this.inDungeon, this.dramenStaff), this.teleportAway);
        finishQuest.addStep(this.dramenStaff, this.enterZanaris);
        finishQuest.addStep(new Conditions(this.inDungeon, this.dramenBranch), this.teleportAway);
        finishQuest.addStep(this.dramenBranch, this.craftBranch);
        finishQuest.addStep(new Conditions(this.inDungeon, this.bronzeAxe), this.cutDramenBranch);
        finishQuest.addStep(new Conditions(this.inDungeon, this.bronzeAxeNearby), this.pickupAxe);
        finishQuest.addStep(this.inDungeon, this.getAxe);
        finishQuest.addStep(this.onEntrana, this.goDownHole);
        steps.put(3, finishQuest);
        steps.put(4, finishQuest);
        steps.put(5, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.bronzeAxe = new ItemRequirement("Bronze axe", 1351).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", 1351).isNotConsumed();
        this.axe.addAlternates(ItemCollections.AXES);
        this.combatGear = new ItemRequirement("Runes, or a way of dealing damage which you can smuggle onto Entrana. Runes for Crumble Undead (level 39 Magic) are best.", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(964);
        this.teleport = new ItemRequirement("Teleport to Lumbridge. Home teleport will work if off cooldown.", 8008);
        this.dramenBranch = new ItemRequirement("Dramen branch", 771);
        this.dramenStaff = new ItemRequirement("Dramen staff", 772);
        this.dramenStaffEquipped = new ItemRequirement("Dramen staff", 772, 1, true);
    }

    public void loadZones() {
        this.entrana = new Zone(new WorldPoint(2798, 3327, 0), new WorldPoint(2878, 3394, 1));
        this.entranaDungeon = new Zone(new WorldPoint(2817, 9722, 0), new WorldPoint(2879, 9784, 0));
    }

    public void setupConditions() {
        this.onEntrana = new ZoneRequirement(this.entrana);
        this.inDungeon = new ZoneRequirement(this.entranaDungeon);
        this.shamusNearby = new NpcCondition(1162);
        this.bronzeAxeNearby = new ItemOnTileRequirement(1351);
        this.dramenSpiritNearby = new NpcCondition(1163);
    }

    public void setupSteps() {
        this.talkToWarrior = new NpcStep((QuestHelper)this, 1158, new WorldPoint(3151, 3207, 0), "Talk to the Warrior south east of Draynor Village.", new Requirement[0]);
        this.talkToWarrior.addDialogStep("What are you camped out here for?");
        this.talkToWarrior.addDialogStep("What makes you think it's out here?");
        this.talkToWarrior.addDialogStep("If it's hidden how are you planning to find it?");
        this.talkToWarrior.addDialogStep("Looks like you don't know either.");
        this.chopTree = new ObjectStep((QuestHelper)this, 2409, new WorldPoint(3139, 3213, 0), "Try cutting the tree just to the west.", this.axe);
        this.chopTree.addDialogStep("I've been in that shed, I didn't see a city.");
        this.talkToShamus = new NpcStep((QuestHelper)this, 1162, new WorldPoint(3138, 3212, 0), "Talk to Shamus.", new Requirement[0]);
        this.talkToShamus.addDialogStep("I've been in that shed, I didn't see a city.");
        this.goToEntrana = new NpcStep((QuestHelper)this, 1167, new WorldPoint(3047, 3236, 0), "Bank all weapons and armour you have (including the axe), and go to Port Sarim to get a boat to Entrana.", this.combatGear);
        this.goDownHole = new ObjectStep((QuestHelper)this, 2408, new WorldPoint(2820, 3374, 0), "Climb down the ladder on the north side of the island. Once you go down, you can only escape via teleport.", new Requirement[0]);
        this.goDownHole.addDialogStep("Well that is a risk I will have to take.");
        this.getAxe = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2843, 9760, 0), "Kill zombies until one drops a bronze axe.", new Requirement[0]);
        this.pickupAxe = new DetailedQuestStep((QuestHelper)this, "Pick up the bronze axe", this.bronzeAxe);
        this.attemptToCutDramen = new ObjectStep((QuestHelper)this, 1292, new WorldPoint(2861, 9735, 0), "Attempt to cut a branch from the Dramen tree. Be prepared for a Tree Spirit (level 101) to appear, which you can safespot behind nearby fungus.", this.bronzeAxe);
        this.killDramenSpirit = new NpcStep((QuestHelper)this, 1163, new WorldPoint(2859, 9734, 0), "Kill the Tree Spirit. They can be safespotted behind nearby fungi to the east.", new Requirement[0]);
        this.cutDramenBranch = new ObjectStep((QuestHelper)this, 1292, new WorldPoint(2861, 9735, 0), "Cut at least one branch from the Dramen tree. It's recommended you cut at least 4 branches so you don't have to return in future quests.", new Requirement[0]);
        this.teleportAway = new DetailedQuestStep((QuestHelper)this, "Teleport away with the branches.", this.dramenBranch);
        this.getAnotherBranch = new DetailedQuestStep((QuestHelper)this, "If you've lost your Dramen branch/staff, you will need to return to Entrana and cut another. You will not need to defeat the Tree Spirit again.", new Requirement[0]);
        this.craftBranch = new DetailedQuestStep((QuestHelper)this, "Use a knife on the dramen branch to craft a dramen staff.", this.knife, this.dramenBranch);
        this.enterZanaris = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Enter the shed south of Lumbridge with your Dramen Staff equipped.", this.dramenStaffEquipped);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Multiple zombies (level 25) (can be safespotted)");
        reqs.add("Dramen Tree Spirit (level 101) (can be safespotted)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.axe);
        reqs.add(this.knife);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.CRAFTING, 31, true));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 36, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to Zanaris."), new UnlockReward("Ability to craft Cosmic Runes"), new UnlockReward("Ability to buy and wield Dragon Daggers & Longswords"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToWarrior), this.axe));
        allSteps.add(new PanelDetails("Finding Shamus", Arrays.asList(this.chopTree, this.talkToShamus), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting a Dramen branch", Arrays.asList(this.goToEntrana, this.goDownHole, this.getAxe, this.attemptToCutDramen, this.killDramenSpirit, this.cutDramenBranch, this.teleportAway), new Requirement[0]));
        allSteps.add(new PanelDetails("Entering Zanaris", Arrays.asList(this.craftBranch, this.enterZanaris), this.knife));
        return allSteps;
    }
}

