/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.landofthegoblins;

import com.google.common.collect.ImmutableList;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.NoItemRequirement;
import com.questhelper.requirements.npc.FollowerRequirement;
import com.questhelper.requirements.npc.NoFollowerRequirement;
import com.questhelper.requirements.npc.NpcRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.ItemSlots;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetPresenceRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.LAND_OF_THE_GOBLINS)
public class LandOfTheGoblins
extends BasicQuestHelper {
    Requirement noPet;
    ItemRequirement lightSource;
    ItemRequirement toadflaxPotionUnf;
    ItemRequirement goblinMail;
    ItemRequirement yellowDye;
    ItemRequirement blueDye;
    ItemRequirement orangeDye;
    ItemRequirement purpleDye;
    ItemRequirement blackDye;
    ItemRequirement fishingRod;
    ItemRequirement rawSlimyEel;
    ItemRequirement coins;
    ItemRequirement combatGear;
    ItemRequirement tinderbox;
    ItemRequirement dorgeshKaanSphereRec;
    ItemRequirement dramenStaff;
    ItemRequirement skillsNecklace;
    ItemRequirement combatBracelet;
    ItemRequirement lumbridgeTeleport;
    ItemRequirement draynorTeleport;
    ItemRequirement explorersRing;
    ItemRequirement salveAmulet;
    CombatLevelRequirement recommendedCombatLevel;
    ItemRequirement pharmakosBerryHighlight;
    ItemRequirement toadflaxUnfHighlight;
    ItemRequirement goblinPotion;
    ItemRequirement goblinPotionHighlight;
    ItemRequirement noEquippedItems;
    ItemRequirement dorgeshKaanSphere;
    ItemRequirement blackGoblinMail;
    ItemRequirement huzamogaarbKey;
    ItemRequirement hemensterWhitefish;
    ItemRequirement pestleAndMortar;
    ItemRequirement vial;
    ItemRequirement blackMushroom;
    ItemRequirement whiteGoblinMail;
    ItemRequirement yellowGoblinMail;
    ItemRequirement blueGoblinMail;
    ItemRequirement orangeGoblinMail;
    ItemRequirement purpleGoblinMail;
    ItemRequirement saragorgakKey;
    ItemRequirement yurkolgokhKey;
    ItemRequirement ekeleshuunKey;
    ItemRequirement nargoshuunKey;
    ItemRequirement horogothgarKey;
    ItemRequirement anyGoblinMail;
    Zone basement;
    Zone tunnels;
    Zone mines;
    Zone cityF0;
    Zone cityF1;
    Zone dorgeshKaan;
    Zone goblinCave;
    Zone guardArea;
    Zone goblinTemple;
    Zone northEastRoomSouth;
    Zone northEastRoomNorth;
    Zone hemenster;
    Zone whitePriestRoom;
    Zone yellowPriestRoom;
    Zone bluePriestRoom;
    Zone orangePriestRoom;
    Zone purplePriestRoom;
    Zone crypt;
    Zone dorgeshKaanF1;
    Zone dorgeshKaanCaveUpper;
    Zone dorgeshKaanCaveLower;
    Requirement inMines;
    Requirement inTunnels;
    Requirement inBasement;
    Requirement inDorgeshKaanF0;
    Requirement inDorgeshKaanWithGrubfoot;
    Requirement invSpaceToUnequip;
    Requirement inGoblinCave;
    Requirement inGoblinCaveWithZanik;
    Requirement inGoblinCaveWithGoblinPotion;
    Requirement inFrontOfGuardsWithGoblinPotion;
    Requirement goblinSelectionActive;
    Requirement isAGoblin;
    Requirement hasBlackMushroomsOrDye;
    Requirement inGoblinTemple;
    Requirement blackGoblinMailEquipped;
    Requirement inNorthEastRoom;
    Requirement blackDyeOrBlackGoblinMail;
    Requirement knowsAboutWhitefish;
    Requirement inHemenster;
    Requirement inWhitePriestRoom;
    Requirement inYellowPriestRoom;
    Requirement inBluePriestRoom;
    Requirement inOrangePriestRoom;
    Requirement inPurplePriestRoom;
    Requirement hasAllGoblinKeys;
    Requirement inCrypt;
    Requirement snotheadAlive;
    Requirement snailfeetAlive;
    Requirement mosschinAlive;
    Requirement redeyesAlive;
    Requirement strongbonesAlive;
    Requirement snotheadDead;
    Requirement snailfeetDead;
    Requirement mosschinDead;
    Requirement redeyesDead;
    Requirement strongbonesDead;
    Requirement inDorgeshKaanF1;
    Requirement inDorgeshKaanCaveUpper;
    Requirement inDorgeshKaanCaveLower;
    Requirement learnedAboutMachine;
    Requirement firstGreater;
    Requirement firstLess;
    Requirement secondGreater;
    Requirement secondLess;
    Requirement thirdGreater;
    Requirement thirdLess;
    Requirement fairyRingMachineWidgetPresent;
    Requirement fairyRingMachineFixed;
    Requirement inYubiusk;
    Requirement unlockedDoor;
    Requirement grubfootFollowing;
    ConditionalStep goTalkToGrubfoot;
    ConditionalStep goTalkToZanik;
    ConditionalStep goReturnToDorg;
    QuestStep goDownIntoBasement;
    QuestStep climbThroughHole;
    QuestStep talkToKazgar;
    QuestStep talkToGrubfoot;
    QuestStep enterDorgeshKaan;
    QuestStep talkToZanik;
    QuestStep enterGoblinCave;
    QuestStep talkToZanikGoblinCave;
    QuestStep talkToGuard;
    QuestStep talkToMakeoverMage;
    QuestStep pickPharmakosBerry;
    QuestStep mixGoblinPotion;
    QuestStep goBackToGoblinCave;
    QuestStep goToGuards;
    QuestStep drinkGoblinPotion;
    QuestStep makeBlackDye;
    QuestStep confirmGoblin;
    QuestStep pickBlackMushrooms;
    QuestStep talkToGuardAsGoblin;
    QuestStep getGoblinMail;
    QuestStep dyeGoblinMail;
    QuestStep enterTempleDoorForThieving;
    QuestStep enterNorthEastRoom;
    QuestStep searchCrateForSphere;
    QuestStep talkToZanikInCell;
    QuestStep leaveNorthEastRoom;
    QuestStep talkToPriestInTemple;
    QuestStep enterNorthEastRoomForKey;
    QuestStep goBackToGoblinCaveNoDye;
    QuestStep goToGuardsNoDye;
    QuestStep drinkGoblinPotionNoDye;
    QuestStep talkToGuardAsGoblinNoDye;
    QuestStep pickpocketPriest;
    QuestStep talkToAggie;
    QuestStep goToHemenster;
    QuestStep catchWhitefish;
    QuestStep talkToAggieWithFish;
    QuestStep goToTempleWithDyes;
    QuestStep enterGoblinCaveForKilling;
    QuestStep passWhiteGuard;
    QuestStep passYellowGuard;
    QuestStep passBlueGuard;
    QuestStep passOrangeGuard;
    QuestStep passPurpleGuard;
    QuestStep pickpocketWhitePriest;
    QuestStep pickpocketYellowPriest;
    QuestStep pickpocketBluePriest;
    QuestStep pickpocketOrangePriest;
    QuestStep pickpocketPurplePriest;
    QuestStep dyeGoblinMailBlue;
    QuestStep dyeGoblinMailYellow;
    QuestStep dyeGoblinMailOrange;
    QuestStep dyeGoblinMailPurple;
    QuestStep unlockCrypt;
    QuestStep enterCrypt;
    QuestStep sayNameSnothead;
    QuestStep sayNameSnailfeet;
    QuestStep sayNameMosschin;
    QuestStep sayNameRedeyes;
    QuestStep sayNameStrongbones;
    QuestStep defeatSnothead;
    QuestStep defeatSnailfeet;
    QuestStep defeatMosschin;
    QuestStep defeatRedeyes;
    QuestStep defeatStrongbones;
    QuestStep learnSnailfeet;
    QuestStep learnMosschin;
    QuestStep learnRedeyes;
    QuestStep learnStrongbones;
    QuestStep learnYubiusk;
    QuestStep talkToOldak;
    QuestStep returnToDorgeshKaanOrFairyRing;
    QuestStep climbDorgeshKaanStairsF0;
    QuestStep climbDorgeshKaanStairsF1;
    QuestStep climbLadderTop;
    QuestStep talkToOldakAtMachine;
    QuestStep inspectMachine;
    QuestStep increaseFirst;
    QuestStep decreaseFirst;
    QuestStep increaseSecond;
    QuestStep decreaseSecond;
    QuestStep increaseThird;
    QuestStep decreaseThird;
    QuestStep confirmFixMachine;
    QuestStep watchYubiuskCutscene;
    QuestStep goToYubiusk;
    QuestStep openBox;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.goTalkToGrubfoot);
        steps.put(2, this.goTalkToZanik);
        DetailedQuestStep watchTheCutscene = new DetailedQuestStep((QuestHelper)this, "Watch the cutscene.", new Requirement[0]);
        this.goTalkToZanik.addSubSteps(watchTheCutscene);
        steps.put(4, watchTheCutscene);
        steps.put(6, this.goTalkToZanik);
        steps.put(8, this.goTalkToZanik);
        ConditionalStep enterSecretTemple = new ConditionalStep((QuestHelper)this, this.enterGoblinCave, new Requirement[0]);
        enterSecretTemple.addStep(this.inGoblinCaveWithZanik, this.talkToGuard);
        enterSecretTemple.addStep(this.inGoblinCave, this.talkToZanikGoblinCave);
        steps.put(10, enterSecretTemple);
        steps.put(12, this.talkToMakeoverMage);
        steps.put(14, this.talkToMakeoverMage);
        ConditionalStep becomeGoblin = new ConditionalStep((QuestHelper)this, this.pickPharmakosBerry, new Requirement[0]);
        becomeGoblin.addStep(this.goblinSelectionActive, this.confirmGoblin);
        becomeGoblin.addStep(new Conditions(this.inFrontOfGuardsWithGoblinPotion, this.blackDyeOrBlackGoblinMail), this.drinkGoblinPotion);
        becomeGoblin.addStep(new Conditions(this.inFrontOfGuardsWithGoblinPotion, this.blackMushroom), this.makeBlackDye);
        becomeGoblin.addStep(this.inFrontOfGuardsWithGoblinPotion, this.pickBlackMushrooms);
        becomeGoblin.addStep(this.inGoblinCaveWithGoblinPotion, this.goToGuards);
        becomeGoblin.addStep(this.goblinPotion.alsoCheckBank(this.questBank), this.goBackToGoblinCave);
        becomeGoblin.addStep(this.pharmakosBerryHighlight, this.mixGoblinPotion);
        steps.put(16, becomeGoblin);
        ConditionalStep enterTemple = new ConditionalStep((QuestHelper)this, this.goBackToGoblinCave, new Requirement[0]);
        enterTemple.addStep(new Conditions(this.isAGoblin, this.blackDyeOrBlackGoblinMail, new Conditions(LogicType.NOR, this.inGoblinTemple)), this.talkToGuardAsGoblin);
        enterTemple.addStep(this.goblinSelectionActive, this.confirmGoblin);
        enterTemple.addStep(new Conditions(this.inFrontOfGuardsWithGoblinPotion, this.blackDyeOrBlackGoblinMail), this.drinkGoblinPotion);
        enterTemple.addStep(new Conditions(this.blackDyeOrBlackGoblinMail, new Conditions(LogicType.NOR, this.isAGoblin)), this.goToGuards);
        enterTemple.addStep(this.inGoblinCaveWithGoblinPotion, this.pickBlackMushrooms);
        steps.put(18, enterTemple);
        steps.put(20, enterTemple);
        ConditionalStep freeZanik = new ConditionalStep((QuestHelper)this, (QuestStep)enterTemple, new Requirement[0]);
        freeZanik.addStep(new Conditions(LogicType.AND, this.dorgeshKaanSphere, this.inNorthEastRoom), this.talkToZanikInCell);
        freeZanik.addStep(this.inNorthEastRoom, this.searchCrateForSphere);
        freeZanik.addStep(this.blackGoblinMail, this.enterNorthEastRoom);
        freeZanik.addStep(new Conditions(LogicType.AND, this.inGoblinTemple, this.goblinMail), this.dyeGoblinMail);
        freeZanik.addStep(this.inGoblinTemple, this.getGoblinMail);
        steps.put(22, freeZanik);
        steps.put(24, freeZanik);
        steps.put(26, freeZanik);
        ConditionalStep talkToPriest = new ConditionalStep((QuestHelper)this, this.goBackToGoblinCaveNoDye, new Requirement[0]);
        talkToPriest.addStep(this.inNorthEastRoom, this.leaveNorthEastRoom);
        talkToPriest.addStep(this.inGoblinTemple, this.talkToPriestInTemple);
        talkToPriest.addStep(this.isAGoblin, this.talkToGuardAsGoblinNoDye);
        talkToPriest.addStep(this.goblinSelectionActive, this.confirmGoblin);
        talkToPriest.addStep(this.inFrontOfGuardsWithGoblinPotion, this.drinkGoblinPotionNoDye);
        talkToPriest.addStep(this.inGoblinCaveWithGoblinPotion, this.goToGuardsNoDye);
        steps.put(28, talkToPriest);
        steps.put(30, talkToPriest);
        steps.put(32, talkToPriest);
        ConditionalStep returnToTempleWithDyes = new ConditionalStep((QuestHelper)this, this.goToTempleWithDyes, "Return to the goblin temple with all the dyes and some combat gear.", new Requirement[0]);
        returnToTempleWithDyes.addStep(this.isAGoblin, this.enterTempleDoorForThieving);
        returnToTempleWithDyes.addStep(this.goblinSelectionActive, this.confirmGoblin);
        returnToTempleWithDyes.addStep(this.inFrontOfGuardsWithGoblinPotion, this.drinkGoblinPotion);
        returnToTempleWithDyes.addStep(this.inGoblinCaveWithGoblinPotion, this.goToGuards);
        returnToTempleWithDyes.addStep(this.goblinPotion.alsoCheckBank(this.questBank), this.goBackToGoblinCave);
        this.goToTempleWithDyes.addSubSteps(returnToTempleWithDyes);
        ConditionalStep dyeing = new ConditionalStep((QuestHelper)this, this.goToHemenster, new Requirement[0]);
        dyeing.addStep(this.hasAllGoblinKeys, this.unlockCrypt);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.inWhitePriestRoom, this.saragorgakKey)), this.passWhiteGuard);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.saragorgakKey)), this.pickpocketWhitePriest);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.yellowGoblinMail, this.yurkolgokhKey)), this.dyeGoblinMailYellow);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.inYellowPriestRoom, this.yurkolgokhKey)), this.passYellowGuard);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.yurkolgokhKey)), this.pickpocketYellowPriest);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.blueGoblinMail, this.ekeleshuunKey)), this.dyeGoblinMailBlue);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.inBluePriestRoom, this.ekeleshuunKey)), this.passBlueGuard);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.ekeleshuunKey)), this.pickpocketBluePriest);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.orangeGoblinMail, this.nargoshuunKey)), this.dyeGoblinMailOrange);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.inOrangePriestRoom, this.nargoshuunKey)), this.passOrangeGuard);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.nargoshuunKey)), this.pickpocketOrangePriest);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.purpleGoblinMail, this.horogothgarKey)), this.dyeGoblinMailPurple);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.inPurplePriestRoom, this.horogothgarKey)), this.passPurpleGuard);
        dyeing.addStep(new Conditions(this.inGoblinTemple, new Conditions(LogicType.NOR, this.horogothgarKey)), this.pickpocketPurplePriest);
        dyeing.addStep(this.whiteGoblinMail, returnToTempleWithDyes);
        dyeing.addStep(this.hemensterWhitefish, this.talkToAggieWithFish);
        dyeing.addStep(this.inHemenster, this.catchWhitefish);
        ConditionalStep getKeys = new ConditionalStep((QuestHelper)this, (QuestStep)enterTemple, new Requirement[0]);
        getKeys.addStep(this.knowsAboutWhitefish, dyeing);
        getKeys.addStep(this.huzamogaarbKey, this.talkToAggie);
        getKeys.addStep(this.inNorthEastRoom, this.pickpocketPriest);
        getKeys.addStep(this.inGoblinTemple, this.enterNorthEastRoomForKey);
        steps.put(34, getKeys);
        ConditionalStep goEnterCrypt = new ConditionalStep((QuestHelper)this, this.enterGoblinCaveForKilling, "Return to the goblin temple with all the dyes and some combat gear.", new Requirement[0]);
        goEnterCrypt.addStep(this.inGoblinTemple, this.enterCrypt);
        goEnterCrypt.addStep(this.isAGoblin, this.enterTempleDoorForThieving);
        goEnterCrypt.addStep(this.goblinSelectionActive, this.confirmGoblin);
        goEnterCrypt.addStep(new ZoneRequirement(this.guardArea), this.drinkGoblinPotion);
        goEnterCrypt.addStep(new Conditions(new Conditions(LogicType.NOR, this.isAGoblin), this.inGoblinCave), this.goToGuards);
        this.enterCrypt.addSubSteps(goEnterCrypt);
        ConditionalStep snothead = new ConditionalStep((QuestHelper)this, (QuestStep)goEnterCrypt, new Requirement[0]);
        snothead.addStep(this.snotheadDead, this.learnSnailfeet);
        snothead.addStep(this.snotheadAlive, this.defeatSnothead);
        snothead.addStep(this.inCrypt, this.sayNameSnothead);
        steps.put(36, snothead);
        steps.put(38, snothead);
        ConditionalStep snailfeet = new ConditionalStep((QuestHelper)this, (QuestStep)goEnterCrypt, new Requirement[0]);
        snailfeet.addStep(this.snailfeetDead, this.learnMosschin);
        snailfeet.addStep(this.snailfeetAlive, this.defeatSnailfeet);
        snailfeet.addStep(this.inCrypt, this.sayNameSnailfeet);
        steps.put(40, snailfeet);
        ConditionalStep mosschin = new ConditionalStep((QuestHelper)this, (QuestStep)goEnterCrypt, new Requirement[0]);
        mosschin.addStep(this.mosschinDead, this.learnRedeyes);
        mosschin.addStep(this.mosschinAlive, this.defeatMosschin);
        mosschin.addStep(this.inCrypt, this.sayNameMosschin);
        steps.put(42, mosschin);
        ConditionalStep redeyes = new ConditionalStep((QuestHelper)this, (QuestStep)goEnterCrypt, new Requirement[0]);
        redeyes.addStep(this.redeyesDead, this.learnStrongbones);
        redeyes.addStep(this.redeyesAlive, this.defeatRedeyes);
        redeyes.addStep(this.inCrypt, this.sayNameRedeyes);
        steps.put(44, redeyes);
        ConditionalStep strongbones = new ConditionalStep((QuestHelper)this, (QuestStep)goEnterCrypt, new Requirement[0]);
        strongbones.addStep(this.strongbonesDead, this.learnYubiusk);
        strongbones.addStep(this.strongbonesAlive, this.defeatStrongbones);
        strongbones.addStep(this.inCrypt, this.sayNameStrongbones);
        steps.put(46, strongbones);
        ConditionalStep oldakInDorgeshKaan = new ConditionalStep((QuestHelper)this, (QuestStep)this.goReturnToDorg, new Requirement[0]);
        oldakInDorgeshKaan.addStep(new ZoneRequirement(this.dorgeshKaan), this.talkToOldak);
        steps.put(48, oldakInDorgeshKaan);
        ConditionalStep fixMachine = new ConditionalStep((QuestHelper)this, this.returnToDorgeshKaanOrFairyRing, new Requirement[0]);
        fixMachine.addStep(this.fairyRingMachineFixed, this.watchYubiuskCutscene);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.firstGreater), this.decreaseFirst);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.firstLess), this.increaseFirst);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.secondGreater), this.decreaseSecond);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.secondLess), this.increaseSecond);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.thirdGreater), this.decreaseThird);
        fixMachine.addStep(new Conditions(this.fairyRingMachineWidgetPresent, this.thirdLess), this.increaseThird);
        fixMachine.addStep(this.fairyRingMachineWidgetPresent, this.confirmFixMachine);
        fixMachine.addStep(this.inDorgeshKaanF0, this.climbDorgeshKaanStairsF0);
        fixMachine.addStep(this.inDorgeshKaanF1, this.climbDorgeshKaanStairsF1);
        fixMachine.addStep(this.inDorgeshKaanCaveUpper, this.climbLadderTop);
        fixMachine.addStep(new Conditions(this.inDorgeshKaanCaveLower, new Conditions(LogicType.NOR, this.learnedAboutMachine)), this.talkToOldakAtMachine);
        fixMachine.addStep(this.inDorgeshKaanCaveLower, this.inspectMachine);
        steps.put(50, fixMachine);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.returnToDorgeshKaanOrFairyRing, new Requirement[0]);
        finishQuest.addStep(this.inDorgeshKaanF0, this.climbDorgeshKaanStairsF0);
        finishQuest.addStep(this.inDorgeshKaanF1, this.climbDorgeshKaanStairsF1);
        finishQuest.addStep(this.inDorgeshKaanCaveUpper, this.climbLadderTop);
        finishQuest.addStep(this.inDorgeshKaanCaveLower, this.goToYubiusk);
        finishQuest.addStep(this.inYubiusk, this.openBox);
        steps.put(52, finishQuest);
        return steps;
    }

    public void setupZones() {
        this.basement = new Zone(new WorldPoint(3208, 9614, 0), new WorldPoint(3219, 9625, 0));
        this.tunnels = new Zone(new WorldPoint(3221, 9602, 0), new WorldPoint(3308, 9661, 0));
        this.mines = new Zone(new WorldPoint(3309, 9600, 0), new WorldPoint(3327, 9655, 0));
        this.cityF0 = new Zone(new WorldPoint(2688, 5248, 0), new WorldPoint(2750, 5375, 0));
        this.cityF1 = new Zone(new WorldPoint(2688, 5248, 1), new WorldPoint(2750, 5375, 1));
        this.dorgeshKaan = new Zone(10835, 0);
        this.goblinCave = new Zone(10393);
        this.guardArea = new Zone(new WorldPoint(2574, 9840, 0), new WorldPoint(2590, 9856, 0));
        this.goblinTemple = new Zone(14915);
        this.northEastRoomSouth = new Zone(new WorldPoint(3754, 4329, 0), new WorldPoint(3757, 4337, 0));
        this.northEastRoomNorth = new Zone(new WorldPoint(3757, 4337, 0), new WorldPoint(3742, 4352, 0));
        this.hemenster = new Zone(new WorldPoint(2642, 3445, 0), new WorldPoint(2631, 3435, 0));
        this.whitePriestRoom = new Zone(new WorldPoint(3731, 4323, 0), new WorldPoint(3723, 4312, 0));
        this.yellowPriestRoom = new Zone(new WorldPoint(3721, 4328, 0), new WorldPoint(3735, 4333, 0));
        this.bluePriestRoom = new Zone(new WorldPoint(3757, 4327, 0), new WorldPoint(3764, 4313, 0));
        this.orangePriestRoom = new Zone(new WorldPoint(3766, 4310, 0), new WorldPoint(3753, 4306, 0));
        this.purplePriestRoom = new Zone(new WorldPoint(3735, 4298, 0), new WorldPoint(3728, 4311, 0));
        this.crypt = new Zone(14916);
        this.dorgeshKaanF1 = new Zone(new WorldPoint(2688, 5248, 1), new WorldPoint(2750, 5375, 1));
        this.dorgeshKaanCaveUpper = new Zone(new WorldPoint(2680, 5200, 3), new WorldPoint(2751, 5252, 3));
        this.dorgeshKaanCaveLower = new Zone(10833, 0);
    }

    @Override
    public void setupRequirements() {
        this.inBasement = new ZoneRequirement(this.basement);
        this.inTunnels = new ZoneRequirement(this.tunnels);
        this.inMines = new ZoneRequirement(this.mines);
        this.inDorgeshKaanF0 = new ZoneRequirement(this.cityF0);
        this.grubfootFollowing = new Conditions(LogicType.OR, new FollowerRequirement("Grubfoot", 11259), new VarbitRequirement(QuestHelperQuest.LAND_OF_THE_GOBLINS.getId(), 8, Operation.GREATER_EQUAL));
        this.inDorgeshKaanWithGrubfoot = new Conditions(LogicType.AND, this.inDorgeshKaanF0, this.grubfootFollowing);
        this.inGoblinCave = new ZoneRequirement(this.goblinCave);
        FollowerRequirement zanikFollowing = new FollowerRequirement("Zanik", 11261);
        this.inGoblinCaveWithZanik = new Conditions(LogicType.AND, this.inGoblinCave, zanikFollowing);
        this.unlockedDoor = new VarbitRequirement(QuestHelperQuest.LAND_OF_THE_GOBLINS.getId(), 36, Operation.GREATER_EQUAL);
        this.pharmakosBerryHighlight = new ItemRequirement("Pharmakos berries", 26569);
        this.pharmakosBerryHighlight.setHighlightInInventory(true);
        this.toadflaxUnfHighlight = new ItemRequirement("Toadflax potion (unf)", 3002);
        this.toadflaxUnfHighlight.setHighlightInInventory(true);
        this.goblinPotion = new ItemRequirement("Goblin potion", Arrays.asList(26587, 26585, 26583));
        this.goblinPotion.setTooltip("You can make another with a toadflax potion (unf) and some pharmakos berries from the bush outside the Makeover Mage's house");
        this.inGoblinCaveWithGoblinPotion = new Conditions(LogicType.AND, this.inGoblinCave, this.goblinPotion);
        this.inFrontOfGuardsWithGoblinPotion = new Conditions(LogicType.AND, new ZoneRequirement(this.guardArea), this.goblinPotion);
        this.goblinPotionHighlight = new ItemRequirement("Goblin potion", Arrays.asList(26587, 26585, 26583));
        this.goblinPotionHighlight.setHighlightInInventory(true);
        this.goblinSelectionActive = new WidgetPresenceRequirement(739, 31);
        this.hasBlackMushroomsOrDye = new Conditions(LogicType.OR, this.blackMushroom, this.blackDye);
        this.isAGoblin = new VarbitRequirement(13612, 1);
        this.inGoblinTemple = new ZoneRequirement(this.goblinTemple);
        this.blackGoblinMail = new ItemRequirement("Black goblin mail", 9055);
        this.blackGoblinMailEquipped = new ItemRequirement("Black goblin mail", 9055, 1, true);
        this.inNorthEastRoom = new Conditions(LogicType.OR, new ZoneRequirement(this.northEastRoomSouth), new ZoneRequirement(this.northEastRoomNorth));
        this.dorgeshKaanSphere = new ItemRequirement("Dorgesh-Kaan sphere", 10972);
        this.blackDyeOrBlackGoblinMail = new Conditions(LogicType.OR, this.blackDye, this.blackGoblinMail);
        this.huzamogaarbKey = new ItemRequirement("Huzamogaarb key", 26573).alsoCheckBank(this.questBank);
        this.knowsAboutWhitefish = new VarbitRequirement(13602, 1);
        this.inHemenster = new ZoneRequirement(this.hemenster);
        this.hemensterWhitefish = new ItemRequirement("Whitefish", 26579);
        this.whiteGoblinMail = new ItemRequirement("White goblin mail", 26567);
        this.yellowGoblinMail = new ItemRequirement("Yellow goblin mail", 9056);
        this.blueGoblinMail = new ItemRequirement("Blue goblin mail", 287);
        this.orangeGoblinMail = new ItemRequirement("Orange goblin mail", 286);
        this.purpleGoblinMail = new ItemRequirement("Purple goblin mail", 9058);
        this.anyGoblinMail = new ItemRequirement("Goblin mail", 288);
        this.anyGoblinMail.addAlternates(9055, 26567, 9056, 287, 286, 9058);
        this.saragorgakKey = new ItemRequirement("Saragorgak key", 26574).alsoCheckBank(this.questBank);
        this.yurkolgokhKey = new ItemRequirement("Yurkolgokh key", 26576).alsoCheckBank(this.questBank);
        this.ekeleshuunKey = new ItemRequirement("Ekeleshuun key", 26571).alsoCheckBank(this.questBank);
        this.nargoshuunKey = new ItemRequirement("Narogoshuun key", 26572).alsoCheckBank(this.questBank);
        this.horogothgarKey = new ItemRequirement("Horogothgar key", 26575).alsoCheckBank(this.questBank);
        this.hasAllGoblinKeys = new Conditions(this.huzamogaarbKey, this.saragorgakKey, this.yurkolgokhKey, this.ekeleshuunKey, this.nargoshuunKey, this.horogothgarKey);
        this.inWhitePriestRoom = new ZoneRequirement(this.whitePriestRoom);
        this.inYellowPriestRoom = new ZoneRequirement(this.yellowPriestRoom);
        this.inBluePriestRoom = new ZoneRequirement(this.bluePriestRoom);
        this.inOrangePriestRoom = new ZoneRequirement(this.orangePriestRoom);
        this.inPurplePriestRoom = new ZoneRequirement(this.purplePriestRoom);
        this.inCrypt = new ZoneRequirement(this.crypt);
        this.snotheadAlive = new NpcRequirement("Snothead", 11269);
        this.snailfeetAlive = new NpcRequirement("Snailfeet", 11270);
        this.mosschinAlive = new NpcRequirement("Mosschin", 11271);
        this.redeyesAlive = new NpcRequirement("Redeyes", 11272);
        this.strongbonesAlive = new NpcRequirement("Strongbones", 11273);
        this.snotheadDead = new NpcRequirement("Snothead", 11274);
        this.snailfeetDead = new NpcRequirement("Snailfeet", 11275);
        this.mosschinDead = new NpcRequirement("Mosschin", 11298);
        this.redeyesDead = new NpcRequirement("Redeyes", 11299);
        this.strongbonesDead = new NpcRequirement("Strongbones", 11300);
        this.inDorgeshKaanF1 = new ZoneRequirement(this.dorgeshKaanF1);
        this.inDorgeshKaanCaveUpper = new ZoneRequirement(this.dorgeshKaanCaveUpper);
        this.inDorgeshKaanCaveLower = new ZoneRequirement(this.dorgeshKaanCaveLower);
        this.learnedAboutMachine = new VarbitRequirement(13618, 1);
        this.firstGreater = new VarbitRequirement(13603, 9, Operation.GREATER);
        this.firstLess = new VarbitRequirement(13603, 9, Operation.LESS);
        this.secondGreater = new VarbitRequirement(13604, 4, Operation.GREATER);
        this.secondLess = new VarbitRequirement(13604, 4, Operation.LESS);
        this.thirdGreater = new VarbitRequirement(13605, 1, Operation.GREATER);
        this.thirdLess = new VarbitRequirement(13605, 1, Operation.LESS);
        this.fairyRingMachineWidgetPresent = new WidgetTextRequirement(738, 2, 1, "Fairy Ring Power Relay");
        this.fairyRingMachineFixed = new VarbitRequirement(13611, 0, Operation.GREATER);
        this.inYubiusk = new InInstanceRequirement();
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES);
        this.toadflaxPotionUnf = new ItemRequirement("Toadflax potion (unf)", 3002);
        this.goblinMail = new ItemRequirement("Goblin mail", 288).hideConditioned(this.unlockedDoor);
        this.goblinMail.canBeObtainedDuringQuest();
        this.yellowDye = new ItemRequirement("Yellow dye", 1765).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.yurkolgokhKey));
        this.blueDye = new ItemRequirement("Blue dye", 1767).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.ekeleshuunKey));
        this.orangeDye = new ItemRequirement("Orange dye", 1769).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.nargoshuunKey));
        this.purpleDye = new ItemRequirement("Purple dye", 1773).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.horogothgarKey));
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.huzamogaarbKey));
        this.vial = new ItemRequirement("Vial", 229).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.huzamogaarbKey));
        this.blackMushroom = new ItemRequirement("Black mushroom", 4620).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.huzamogaarbKey));
        this.blackDye = new ItemRequirement("Black dye", 4622).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.huzamogaarbKey));
        this.blackDye.setTooltip("Black mushrooms obtainable during quest - bring empty vial and pestle and mortar");
        this.fishingRod = new ItemRequirement("Fishing rod", 307).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.saragorgakKey));
        this.rawSlimyEel = new ItemRequirement("Raw slimy eel", 3379).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.saragorgakKey));
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 5).hideConditioned(new Conditions(LogicType.OR, this.unlockedDoor, this.saragorgakKey));
        this.noPet = new NoFollowerRequirement("No pet following you");
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.invSpaceToUnequip = new ItemRequirement("Inventory space to unequip all your items", -1, -1);
        this.noEquippedItems = new NoItemRequirement("No equipped items", ItemSlots.ANY_EQUIPPED);
        this.recommendedCombatLevel = new CombatLevelRequirement(65);
        this.tinderbox = new ItemRequirement("Tinderbox", 590);
        this.tinderbox.setTooltip("If using an extinguishable light source");
        this.dorgeshKaanSphereRec = new ItemRequirement("Dorgesh-Kaan sphere", 10972, 2);
        this.dramenStaff = new ItemRequirement("Dramen staff", 772);
        this.dramenStaff.addAlternates(9084);
        this.dramenStaff.setTooltip("For transportation via fairy rings");
        this.skillsNecklace = new ItemRequirement("Skills necklace", ItemCollections.SKILLS_NECKLACES, 3);
        this.skillsNecklace.setChargedItem(true);
        this.combatBracelet = new ItemRequirement("Combat bracelet", ItemCollections.COMBAT_BRACELETS);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge teleport", -1, 2);
        this.draynorTeleport = new ItemRequirement("Draynor Village teleport", ItemCollections.AMULET_OF_GLORIES, 2);
        this.draynorTeleport.setChargedItem(true);
        this.explorersRing = new ItemRequirement("Explorer's ring 3 or 4", Arrays.asList(13127, 13128));
        this.salveAmulet = new ItemRequirement("Salve amulet or Salve amulet (e)", ItemCollections.SALVE_AMULET);
    }

    public void setupSteps() {
        this.goDownIntoBasement = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Enter the Lumbridge Castle basement.", new Requirement[0]);
        this.climbThroughHole = new ObjectStep((QuestHelper)this, 6898, new WorldPoint(3219, 9618, 0), "", new Requirement[0]);
        this.talkToKazgar = new NpcStep((QuestHelper)this, 7301, new WorldPoint(3230, 9610, 0), "Travel with Kazgar to shortcut to Mistag.", new Requirement[0]);
        this.talkToKazgar.addDialogStep("Can you show me the way to the mines?");
        this.talkToGrubfoot = new NpcStep((QuestHelper)this, 11255, new WorldPoint(3318, 9611, 0), "", new Requirement[0]);
        this.talkToGrubfoot.addDialogStep("Yes.");
        this.talkToGrubfoot.addDialogStep("Follow me.");
        this.enterDorgeshKaan = new ObjectStep((QuestHelper)this, 6919, new WorldPoint(3317, 9601, 0), "Enter the city of Dorgesh-Kaan.", new Requirement[0]);
        this.talkToZanik = new NpcStep((QuestHelper)this, 11260, new WorldPoint(2704, 5365, 0), "Talk to Zanik in Oldak's lab.", new Requirement[0]);
        this.talkToZanik.addDialogStep("So why have you come to talk to Zanik?");
        this.talkToZanik.addDialogStep("What was this new dream?");
        this.talkToZanik.addDialogSteps("It's just a dream. It doesn't mean anything.", "I think it must mean something.", "I don't know.");
        this.talkToZanik.addDialogStep("I'm ready.");
        this.enterGoblinCave = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Enter the Goblin Cave next to the Fishing Guild.", new Requirement[0]);
        this.talkToZanikGoblinCave = new NpcStep((QuestHelper)this, 11260, new WorldPoint(2617, 9797, 0), "Talk to Zanik and get her to follow you.", new Requirement[0]);
        this.talkToZanikGoblinCave.addDialogStep("Follow me.");
        this.talkToGuard = new NpcStep((QuestHelper)this, 11314, new WorldPoint(2580, 9852, 0), "Talk to the goblin guard in the northwest of the cave.", new Requirement[0]);
        this.talkToMakeoverMage = new NpcStep((QuestHelper)this, new int[]{1306, 1307}, new WorldPoint(2917, 3322, 0), "Talk to the Makeover Mage southwest of Falador.", this.toadflaxPotionUnf);
        ((NpcStep)this.talkToMakeoverMage).addTeleport(this.skillsNecklace.quantity(1).named("Skills necklace (Crafting Guild [3])"));
        this.talkToMakeoverMage.addDialogSteps("Can you turn me into a goblin?", "I need to slip past some goblin guards.", "Can you turn me into a goblin or not?");
        this.pickPharmakosBerry = new ObjectStep((QuestHelper)this, 43158, "Pick some Pharmakos berries from the bushes outside.", this.toadflaxPotionUnf);
        this.mixGoblinPotion = new DetailedQuestStep((QuestHelper)this, "Use the pharmakos berries on the unfinished toadflax potion.", this.pharmakosBerryHighlight, this.toadflaxUnfHighlight);
        this.goBackToGoblinCave = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Go back to the Goblin Cave outside the Fishing Guild.", this.goblinPotion, this.vial, this.pestleAndMortar, this.noEquippedItems);
        ((ObjectStep)this.goBackToGoblinCave).addTeleport(this.skillsNecklace.quantity(1).named("Skills necklace (Fishing Guild [1])"));
        this.pickBlackMushrooms = new ObjectStep((QuestHelper)this, 6311, new WorldPoint(2577, 9845, 0), "Pick some black mushrooms and use it on a vial to make black dye.", this.goblinPotion, this.vial, this.pestleAndMortar, this.noEquippedItems);
        this.makeBlackDye = new DetailedQuestStep((QuestHelper)this, "Make black dye by using the blackmushrooms on a vial.", this.blackMushroom.highlighted(), this.vial.highlighted(), this.pestleAndMortar);
        this.goToGuards = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2580, 9850, 0), "Go to the area outside the temple near the guards.", this.goblinPotion, this.noEquippedItems);
        this.drinkGoblinPotion = new DetailedQuestStep((QuestHelper)this, "Drink the goblin potion.", this.goblinPotionHighlight, this.noEquippedItems);
        this.confirmGoblin = new WidgetStep((QuestHelper)this, "Confirm to become a goblin. Your selection doesn't matter.", 739, 31);
        this.talkToGuardAsGoblin = new NpcStep((QuestHelper)this, 11314, new WorldPoint(2580, 9852, 0), "Talk to the goblin guard to enter the temple. If you want, you can tell them to guess your name until you get one you like.", this.blackDye);
        this.talkToGuardAsGoblin.addDialogStep("Me want get into temple.");
        this.talkToGuardAsGoblin.addDialogStep(Pattern.compile("^Yes, me .*"));
        this.talkToGuardAsGoblin.addDialogStep("Yes.");
        this.getGoblinMail = new ObjectStep((QuestHelper)this, 43086, new WorldPoint(3747, 4309, 0), "Search the crate by the entrance for some goblin mail.", this.blackDye);
        this.dyeGoblinMail = new DetailedQuestStep((QuestHelper)this, "Use the black dye on the goblin mail.", this.blackDye.highlighted(), this.goblinMail.highlighted());
        this.enterNorthEastRoom = new NpcStep((QuestHelper)this, 11318, new WorldPoint(3753, 4329, 0), "Pass by the guard to the northeastern room. WARNING: If you teleport away with a full inventory and while wearing the goblin mail, it will be DESTROYED.", this.blackGoblinMail.highlighted().equipped());
        this.enterNorthEastRoomForKey = new NpcStep((QuestHelper)this, 11318, new WorldPoint(3753, 4329, 0), "Pass by the guard to the northeastern room again.", this.blackGoblinMail.highlighted().equipped());
        this.searchCrateForSphere = new ObjectStep((QuestHelper)this, 43085, new WorldPoint(3757, 4342, 0), "Search the crate for a Dorgesh-Kaan sphere.", new Requirement[0]);
        this.talkToZanikInCell = new NpcStep((QuestHelper)this, 11260, new WorldPoint(3751, 4343, 0), "Talk to Zanik in the cell.", this.dorgeshKaanSphere);
        this.leaveNorthEastRoom = new NpcStep((QuestHelper)this, 11318, new WorldPoint(3753, 4329, 0), "Pass by the guard to leave the northeastern room.", new Requirement[0]);
        this.talkToPriestInTemple = new NpcStep((QuestHelper)this, 11267, new WorldPoint(3744, 4328, 0), "Talk to High Priest Bighead. When prompted, answer in this order: True, False, False.", new Requirement[0]);
        this.talkToPriestInTemple.addDialogConsideringLastLineCondition("True or false: Those who do not believe in Big High War God, whether they goblins or other races, must die.", "True.");
        this.talkToPriestInTemple.addDialogConsideringLastLineCondition("Second question. True or false: Big High War God chose goblins to be his race because goblins mighty warriors.", "False.");
        this.talkToPriestInTemple.addDialogConsideringLastLineCondition("Third question. True or false: Goblin leaders should be good at planning in order to win battles.", "False.");
        this.talkToPriestInTemple.addDialogStep("Yes.");
        this.talkToPriestInTemple.addDialogStep("I understand Big High War God.");
        this.talkToPriestInTemple.addDialogStep("Big High War God commands it.");
        this.talkToPriestInTemple.addDialogStep("Goblins not mighty warriors before he chose us.");
        this.talkToPriestInTemple.addDialogStep("That one of the commandments.");
        this.talkToPriestInTemple.addDialogStep("Lead goblins to victory over whole world.");
        this.talkToPriestInTemple.addDialogStep("Me want to know about Yu'biusk.");
        this.talkToPriestInTemple.addDialogStep("Where is Yu'biusk?");
        this.talkToPriestInTemple.addDialogStep("Can I talk to old high priests?");
        this.goBackToGoblinCaveNoDye = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Go back to the Goblin Cave outside the Fishing Guild.", this.goblinPotion, this.noEquippedItems);
        this.enterGoblinCaveForKilling = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Go back to the Goblin Cave outside the Fishing Guild, ready for fighting.", this.goblinPotion, this.noEquippedItems, this.combatGear);
        this.goToGuardsNoDye = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2580, 9850, 0), "Go to the area outside the temple near the guards.", this.goblinPotion, this.noEquippedItems);
        this.drinkGoblinPotionNoDye = new DetailedQuestStep((QuestHelper)this, "Drink the goblin potion.", this.goblinPotionHighlight, this.noEquippedItems);
        this.talkToGuardAsGoblinNoDye = new NpcStep((QuestHelper)this, 11314, new WorldPoint(2580, 9852, 0), "Talk to the goblin guard to enter the temple. If you want, you can tell them to guess your name until you get one you like.", new Requirement[0]);
        this.talkToGuardAsGoblin.addDialogStep("Me want get into temple.");
        this.talkToGuardAsGoblin.addDialogStep(Pattern.compile("^Yes, me .*"));
        this.talkToGuardAsGoblin.addDialogStep("Yes.");
        this.pickpocketPriest = new NpcStep((QuestHelper)this, 11307, new WorldPoint(3754, 4340, 0), "Pickpocket a key from the priest.", new Requirement[0]);
        this.talkToAggie = new NpcStep((QuestHelper)this, 4284, new WorldPoint(3086, 3258, 0), "Talk to Aggie in Draynor Village.", new Requirement[0]);
        ((NpcStep)this.talkToAggie).addTeleport(this.draynorTeleport.quantity(1).named("Amulet of glory (Draynor Village [3])"));
        this.talkToAggie.addDialogSteps("Draynor Village", "Can you make dyes for me please?", "Can you make black or white dye?", "Thanks.");
        this.goToHemenster = new ObjectStep((QuestHelper)this, 48, new WorldPoint(2642, 3441, 0), "Go to Hemenster to catch a whitefish.", this.fishingRod, this.rawSlimyEel);
        ((ObjectStep)this.goToHemenster).addTeleport(this.combatBracelet.named("Combat bracelet (Ranging Guild [4])"));
        this.goToHemenster.addDialogSteps("Ranging Guild", "I need to catch a Hemenster Whitefish.");
        this.catchWhitefish = new NpcStep((QuestHelper)this, 4080, new WorldPoint(2637, 3444, 0), "Catch a Hemenster whitefish.", this.fishingRod, this.rawSlimyEel);
        this.talkToAggieWithFish = new NpcStep((QuestHelper)this, 4284, new WorldPoint(3086, 3258, 0), "Bring the whitefish and black goblin mail to Aggie.", this.coins, this.hemensterWhitefish, this.blackGoblinMail);
        ((NpcStep)this.talkToAggieWithFish).addTeleport(this.draynorTeleport.quantity(1).named("Amulet of glory (Draynor Village [3])"));
        this.talkToAggieWithFish.addDialogSteps("Draynor Village", "Can you make dyes for me please?", "Could you remove the dye from this goblin mail?");
        this.goToTempleWithDyes = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Return to the goblin temple with all the dyes and some combat gear.", this.whiteGoblinMail, this.goblinPotion, this.huzamogaarbKey, this.yellowDye, this.blueDye, this.orangeDye, this.purpleDye, this.noEquippedItems, this.combatGear);
        ((ObjectStep)this.goToTempleWithDyes).addTeleport(this.skillsNecklace.quantity(1).named("Skills necklace (Fishing Guild [1])"));
        this.enterTempleDoorForThieving = new ObjectStep((QuestHelper)this, 43261, new WorldPoint(2581, 9853, 0), "Enter the temple.", new Requirement[0]);
        this.dyeGoblinMailYellow = new DetailedQuestStep((QuestHelper)this, "Use the yellow dye on your goblin mail. It is safe to unequip the goblin mail inside the enclave, you will be thrown out to the center area.", this.yellowDye.highlighted(), this.anyGoblinMail.highlighted());
        this.dyeGoblinMailBlue = new DetailedQuestStep((QuestHelper)this, "Use the blue dye on your goblin mail. It is safe to unequip the goblin mail inside the enclave, you will be thrown out to the center area.", this.blueDye.highlighted(), this.anyGoblinMail.highlighted());
        this.dyeGoblinMailOrange = new DetailedQuestStep((QuestHelper)this, "Use the orange dye on your goblin mail. It is safe to unequip the goblin mail inside the enclave, you will be thrown out to the center area.", this.orangeDye.highlighted(), this.anyGoblinMail.highlighted());
        this.dyeGoblinMailPurple = new DetailedQuestStep((QuestHelper)this, "Use the purple dye on your goblin mail. It is safe to unequip the goblin mail inside the enclave, you will be thrown out to the center area.", this.purpleDye.highlighted(), this.anyGoblinMail.highlighted());
        this.passWhiteGuard = new NpcStep((QuestHelper)this, 11319, new WorldPoint(3732, 4320, 0), "Pass by the guard to enter the western area.", this.whiteGoblinMail.equipped().highlighted());
        this.passYellowGuard = new NpcStep((QuestHelper)this, 11321, new WorldPoint(3735, 4329, 0), "Pass by the guard to enter the north-western area.", this.yellowGoblinMail.equipped().highlighted());
        this.passBlueGuard = new NpcStep((QuestHelper)this, 11316, new WorldPoint(3756, 4320, 0), "Pass by the guard to enter the eastern area.", this.blueGoblinMail.equipped().highlighted());
        this.passOrangeGuard = new NpcStep((QuestHelper)this, 11317, new WorldPoint(3753, 4311, 0), "Pass by the guard to enter the south-eastern area.", this.orangeGoblinMail.equipped().highlighted());
        this.passPurpleGuard = new NpcStep((QuestHelper)this, 11320, new WorldPoint(3735, 4311, 0), "Pass by the guard to enter the south-western area.", this.purpleGoblinMail.equipped().highlighted());
        this.pickpocketWhitePriest = new NpcStep((QuestHelper)this, 11309, new WorldPoint(3727, 4316, 0), "Pickpocket the priest in the western room for the Saragorak key.", new Requirement[0]);
        this.pickpocketYellowPriest = new NpcStep((QuestHelper)this, 11313, new WorldPoint(3727, 4330, 0), "Pickpocket the priest in the north-western room for the Yurkolgokh key.", new Requirement[0]);
        this.pickpocketBluePriest = new NpcStep((QuestHelper)this, 11303, new WorldPoint(3760, 4320, 0), "Pickpocket the priest in the eastern room for the Ekeleshuun key.", new Requirement[0]);
        this.pickpocketOrangePriest = new NpcStep((QuestHelper)this, 11305, new WorldPoint(3762, 4318, 0), "Pickpocket the priest in the south-eastern room for the Narogoshuun key.", new Requirement[0]);
        this.pickpocketPurplePriest = new NpcStep((QuestHelper)this, 11311, new WorldPoint(3730, 4302, 0), "Pickpocket the priest in the south-western room for the Horogothgar key.", new Requirement[0]);
        this.unlockCrypt = new ObjectStep((QuestHelper)this, 43088, new WorldPoint(3744, 4332, 0), "Unlock the door using the 6 keys. You may leave to gear up after unlocking it.", this.huzamogaarbKey, this.saragorgakKey, this.yurkolgokhKey, this.ekeleshuunKey, this.nargoshuunKey, this.horogothgarKey);
        this.enterCrypt = new ObjectStep((QuestHelper)this, 43088, new WorldPoint(3744, 4332, 0), "Enter the crypt.", this.combatGear);
        this.sayNameSnothead = new ObjectStep((QuestHelper)this, 43122, new WorldPoint(3738, 4385, 0), "Say Snothead's name at the south-west grave.", new Requirement[0]);
        this.sayNameSnailfeet = new ObjectStep((QuestHelper)this, 43123, new WorldPoint(3746, 4385, 0), "Say Snailfeet's name at the south-east grave.", new Requirement[0]);
        this.sayNameSnailfeet.addDialogStep("Snailfeet.");
        this.sayNameMosschin = new ObjectStep((QuestHelper)this, 43124, new WorldPoint(3738, 4389, 0), "Say Mosschin's name at the north-west grave.", new Requirement[0]);
        this.sayNameMosschin.addDialogStep("Mosschin.");
        this.sayNameRedeyes = new ObjectStep((QuestHelper)this, 43125, new WorldPoint(3746, 4389, 0), "Say Redeyes's name at the north-east grave.", new Requirement[0]);
        this.sayNameRedeyes.addDialogStep("Redeyes.");
        this.sayNameStrongbones = new ObjectStep((QuestHelper)this, 43126, new WorldPoint(3742, 4393, 0), "Say Strongbones's name at the north grave.", new Requirement[0]);
        this.sayNameStrongbones.addDialogStep("Strongbones.");
        this.defeatSnothead = new NpcStep((QuestHelper)this, 11269, "Defeat Snothead. He attacks using melee.", new Requirement[0]);
        this.defeatSnailfeet = new NpcStep((QuestHelper)this, 11270, "Defeat Snailfeet. He attacks using melee and range.", new Requirement[0]);
        this.defeatMosschin = new NpcStep((QuestHelper)this, 11271, "Defeat Mosschin. He attacks using melee and magic.", new Requirement[0]);
        this.defeatRedeyes = new NpcStep((QuestHelper)this, 11272, "Defeat Redeyes. He attacks using melee and magic, and lowers your attack, strength, and defence.", new Requirement[0]);
        this.defeatStrongbones = new NpcStep((QuestHelper)this, 11273, "Defeat Strongbones. He attacks using all 3 combat styles, lowers your attack, strength and defence. Ignore the level 29 Skoblins he spawns.", new Requirement[0]);
        this.learnSnailfeet = new NpcStep((QuestHelper)this, 11274, "Talk to Snothead to learn the name of the next priest.", new Requirement[0]);
        this.learnSnailfeet.addDialogStep("What was your predecessor's name?");
        this.learnMosschin = new NpcStep((QuestHelper)this, 11275, "Talk to Snailfeet to learn the name of the next priest.", new Requirement[0]);
        this.learnMosschin.addDialogStep("What was your predecessor's name?");
        this.learnRedeyes = new NpcStep((QuestHelper)this, 11298, "Talk to Mosschin to learn the name of the next priest.", new Requirement[0]);
        this.learnRedeyes.addDialogStep("What was your predecessor's name?");
        this.learnStrongbones = new NpcStep((QuestHelper)this, 11299, "Talk to Redeyes to learn the name of the next priest.", new Requirement[0]);
        this.learnStrongbones.addDialogStep("What was your predecessor's name?");
        this.learnYubiusk = new NpcStep((QuestHelper)this, 11300, "Talk to Strongbones to learn where Yu'biusk is.", new Requirement[0]);
        this.learnYubiusk.addDialogStep("Where is Yu'biusk?");
        this.talkToOldak = new NpcStep((QuestHelper)this, 11384, new WorldPoint(2703, 5366, 0), "Talk to Oldak in his workshop.", new Requirement[0]);
        this.climbDorgeshKaanStairsF0 = new ObjectStep((QuestHelper)this, 22937, new WorldPoint(2714, 5283, 0), "If you have access to fairy rings, travel to AJQ. Otherwise, climb the stairs in south Dorgesh-Kaan.", new Requirement[0]);
        this.climbDorgeshKaanStairsF1 = new ObjectStep((QuestHelper)this, 22941, new WorldPoint(2723, 5253, 1), "Climb up the stairs to the south to enter the Dorgesh-Kaan cave.", new Requirement[0]);
        this.climbLadderTop = new ObjectStep((QuestHelper)this, 22666, new WorldPoint(2719, 5241, 3), "Climb down the ladder to the west.", new Requirement[0]);
        this.talkToOldakAtMachine = new NpcStep((QuestHelper)this, 11385, new WorldPoint(2741, 5220, 0), "Talk to Oldak near the machine at the fairy ring in the the caves south of Dorgesh-Kaan.", new Requirement[0]);
        this.inspectMachine = new ObjectStep((QuestHelper)this, 43101, new WorldPoint(2740, 5219, 0), "Fix the machine.", new Requirement[0]);
        this.increaseFirst = new WidgetStep((QuestHelper)this, "Set the first value to 9.", 738, 21);
        this.decreaseFirst = new WidgetStep((QuestHelper)this, "Set the first value to 9.", 738, 22);
        this.increaseSecond = new WidgetStep((QuestHelper)this, "Set the second value to 4.", 738, 23);
        this.decreaseSecond = new WidgetStep((QuestHelper)this, "Set the first value to 4.", 738, 24);
        this.increaseThird = new WidgetStep((QuestHelper)this, "Set the first value to 1.", 738, 25);
        this.decreaseThird = new WidgetStep((QuestHelper)this, "Set the first value to 1.", 738, 26);
        this.confirmFixMachine = new WidgetStep((QuestHelper)this, "Fix the machine.", 738, 39);
        this.watchYubiuskCutscene = new DetailedQuestStep((QuestHelper)this, "Watch the cutscene.", new Requirement[0]);
        this.goToYubiusk = new NpcStep((QuestHelper)this, 11385, new WorldPoint(2741, 5220, 0), "Talk to Oldak to return to Yu'Biusk.", new Requirement[0]);
        this.openBox = new ObjectStep((QuestHelper)this, 43246, new WorldPoint(3537, 4389, 0), "Walk up to the strange box and watch the cutscene. Quest complete!", new Requirement[0]);
        ConditionalStep getToMine = new ConditionalStep((QuestHelper)this, this.goDownIntoBasement, new Requirement[0]);
        getToMine.addStep(this.inTunnels, this.talkToKazgar);
        getToMine.addStep(this.inBasement, this.climbThroughHole);
        this.goTalkToGrubfoot = new ConditionalStep((QuestHelper)this, (QuestStep)getToMine, "Talk to Grubfoot in the Dorgeshuun Mines.", new Requirement[0]);
        this.goTalkToGrubfoot.addStep(this.inMines, this.talkToGrubfoot);
        ConditionalStep enterCity = new ConditionalStep((QuestHelper)this, (QuestStep)getToMine, new Requirement[0]);
        enterCity.addStep(this.inMines, this.enterDorgeshKaan);
        this.goTalkToZanik = new ConditionalStep((QuestHelper)this, (QuestStep)this.goTalkToGrubfoot, new Requirement[0]);
        this.goTalkToZanik.addStep(this.inDorgeshKaanWithGrubfoot, this.talkToZanik);
        this.goTalkToZanik.addStep(this.grubfootFollowing, enterCity);
        this.goReturnToDorg = new ConditionalStep((QuestHelper)this, (QuestStep)enterCity, "Return to Dorgesh-Kaan and speak to Oldak.", new Requirement[0]);
        this.returnToDorgeshKaanOrFairyRing = new ConditionalStep((QuestHelper)this, (QuestStep)enterCity, "If you have access to fairy rings, travel to AJQ. Otherwise, return to Dorgesh-Kaan.", new Requirement[0]);
        this.drinkGoblinPotion.addSubSteps(this.confirmGoblin);
        this.drinkGoblinPotionNoDye.addSubSteps(this.confirmGoblin);
        this.dyeGoblinMail.addSubSteps(this.getGoblinMail);
        this.talkToGuardAsGoblin.addSubSteps(this.talkToGuardAsGoblinNoDye, this.enterTempleDoorForThieving);
        this.pickpocketWhitePriest.addSubSteps(this.passWhiteGuard);
        this.pickpocketYellowPriest.addSubSteps(this.passYellowGuard);
        this.pickpocketBluePriest.addSubSteps(this.passBlueGuard);
        this.pickpocketOrangePriest.addSubSteps(this.passOrangeGuard);
        this.pickpocketPurplePriest.addSubSteps(this.passPurpleGuard);
        this.defeatSnothead.addSubSteps(this.learnSnailfeet);
        this.defeatSnailfeet.addSubSteps(this.learnMosschin);
        this.defeatMosschin.addSubSteps(this.learnRedeyes);
        this.defeatRedeyes.addSubSteps(this.learnStrongbones);
        this.talkToOldakAtMachine.addSubSteps(this.climbDorgeshKaanStairsF0, this.climbDorgeshKaanStairsF1, this.climbLadderTop);
        this.inspectMachine.addSubSteps(this.decreaseFirst, this.increaseFirst, this.decreaseSecond, this.increaseSecond, this.decreaseThird, this.increaseThird, this.confirmFixMachine);
        this.openBox.addSubSteps(this.returnToDorgeshKaanOrFairyRing);
    }

    public ArrayList<ItemRequirement> getItemRequirements() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.lightSource, this.toadflaxPotionUnf, this.goblinMail, this.yellowDye, this.blueDye, this.orangeDye, this.purpleDye, this.pestleAndMortar, this.vial, this.fishingRod, this.rawSlimyEel, this.coins, this.combatGear));
    }

    public ArrayList<ItemRequirement> getItemRecommended() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.tinderbox, this.dorgeshKaanSphereRec, this.dramenStaff, this.skillsNecklace, this.combatBracelet, this.lumbridgeTeleport, this.draynorTeleport, this.explorersRing, this.salveAmulet));
    }

    public ArrayList<String> getCombatRequirements() {
        return new ArrayList<String>((Collection<String>)ImmutableList.of((Object)"Snothead (level 32)", (Object)"Snailfeet (level 56)", (Object)"Mosschin (level 88)", (Object)"Redeyes (level 121)", (Object)"Strongbones (level 184)"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.ANOTHER_SLICE_OF_HAM, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.FISHING_CONTEST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 38, false));
        req.add(new SkillRequirement(Skill.FISHING, 40, false));
        req.add(new SkillRequirement(Skill.THIEVING, 45, false));
        req.add(new SkillRequirement(Skill.HERBLORE, 48, false));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.AGILITY, 8000), new ExperienceReward(Skill.FISHING, 8000), new ExperienceReward(Skill.THIEVING, 8000), new ExperienceReward(Skill.HERBLORE, 8000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Goblin Temple"), new UnlockReward("Access to Yu'Biusk (with fairy ring code BLQ)"), new UnlockReward("Ability to purchase plain of mud spheres"), new UnlockReward("Ability to make goblin potions"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> panels = new ArrayList<PanelDetails>();
        panels.add(new PanelDetails("Grubfoot's Dream", Arrays.asList(this.goTalkToGrubfoot, this.enterDorgeshKaan, this.talkToZanik), this.lightSource, this.noPet));
        panels.add(new PanelDetails("Impostor Among Goblins", Arrays.asList(this.enterGoblinCave, this.talkToZanikGoblinCave, this.talkToGuard, this.talkToMakeoverMage, this.pickPharmakosBerry, this.mixGoblinPotion), Collections.singletonList(this.toadflaxPotionUnf), Arrays.asList(this.skillsNecklace, this.invSpaceToUnequip)));
        panels.add(new PanelDetails("The Temple of Tribes", Arrays.asList(this.goBackToGoblinCave, this.goToGuards, this.pickBlackMushrooms, this.makeBlackDye, this.drinkGoblinPotion, this.talkToGuardAsGoblin, this.dyeGoblinMail, this.enterNorthEastRoom, this.searchCrateForSphere, this.talkToZanikInCell, this.leaveNorthEastRoom, this.talkToPriestInTemple, this.enterNorthEastRoomForKey, this.pickpocketPriest), Arrays.asList(this.noPet, this.goblinPotion, this.vial, this.pestleAndMortar, this.goblinMail), Arrays.asList(this.skillsNecklace.quantity(1), this.invSpaceToUnequip, this.dorgeshKaanSphereRec)));
        panels.add(new PanelDetails("Keys to the Crypt", Arrays.asList(this.talkToAggie, this.goToHemenster, this.catchWhitefish, this.talkToAggieWithFish, this.goToTempleWithDyes, this.pickpocketWhitePriest, this.dyeGoblinMailYellow, this.pickpocketYellowPriest, this.dyeGoblinMailBlue, this.pickpocketBluePriest, this.dyeGoblinMailOrange, this.pickpocketOrangePriest, this.dyeGoblinMailPurple, this.pickpocketPurplePriest, this.unlockCrypt), Arrays.asList(this.fishingRod, this.rawSlimyEel, this.coins, this.yellowDye, this.blueDye, this.orangeDye, this.purpleDye, this.blackGoblinMail, this.goblinPotion, this.huzamogaarbKey, this.combatGear), Arrays.asList(this.draynorTeleport, this.combatBracelet, this.skillsNecklace.quantity(1))));
        panels.add(new PanelDetails("High Priests of Ages Past", Arrays.asList(this.enterCrypt, this.sayNameSnothead, this.defeatSnothead, this.sayNameSnailfeet, this.defeatSnailfeet, this.sayNameMosschin, this.defeatMosschin, this.sayNameRedeyes, this.defeatRedeyes, this.sayNameStrongbones, this.defeatStrongbones, this.learnYubiusk), this.combatGear));
        panels.add(new PanelDetails("Path to Yu'biusk", Arrays.asList(this.goReturnToDorg, this.talkToOldak, this.talkToOldakAtMachine, this.inspectMachine, this.watchYubiuskCutscene, this.openBox), Collections.singletonList(this.lightSource), Arrays.asList(this.dorgeshKaanSphereRec, this.dramenStaff)));
        return panels;
    }
}

