/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.kingsransom;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class LockpickPuzzle
extends QuestStep {
    int[] TUMBLER_ANSWERS = new int[]{3894, 3895, 3896, 3897};
    int[] TUMBLER_WIDGETS = new int[]{20, 21, 22, 23};
    int[] TUMBLER_CURRENT = new int[]{3901, 3902, 3903, 3904};
    int CURRENT_TUMBLER = 3905;
    int UP_WIDGET = 12;
    int DOWN_WIDGET = 13;
    int TRY_LOCK = 14;
    int highlightChildID;

    public LockpickPuzzle(QuestHelper questHelper) {
        super(questHelper, "Click the highlighted boxes to solve the puzzle. The solution is:");
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
        this.setText("Click the highlighted boxes to solve the puzzle. The solution is:");
        this.addText("Tumbler 1: " + this.client.getVarbitValue(this.TUMBLER_ANSWERS[0]) + ".");
        this.addText("Tumbler 2: " + this.client.getVarbitValue(this.TUMBLER_ANSWERS[1]) + ".");
        this.addText("Tumbler 3: " + this.client.getVarbitValue(this.TUMBLER_ANSWERS[2]) + ".");
        this.addText("Tumbler 4: " + this.client.getVarbitValue(this.TUMBLER_ANSWERS[3]) + ".");
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        int answer3;
        int answer2;
        int answer1;
        int answer0;
        int current0 = this.client.getVarbitValue(this.TUMBLER_CURRENT[0]);
        if (current0 != (answer0 = this.client.getVarbitValue(this.TUMBLER_ANSWERS[0]))) {
            this.updateWidget(0, current0, answer0);
            return;
        }
        int current1 = this.client.getVarbitValue(this.TUMBLER_CURRENT[1]);
        if (current1 != (answer1 = this.client.getVarbitValue(this.TUMBLER_ANSWERS[1]))) {
            this.updateWidget(1, current1, answer1);
            return;
        }
        int current2 = this.client.getVarbitValue(this.TUMBLER_CURRENT[2]);
        if (current2 != (answer2 = this.client.getVarbitValue(this.TUMBLER_ANSWERS[2]))) {
            this.updateWidget(2, current2, answer2);
            return;
        }
        int current3 = this.client.getVarbitValue(this.TUMBLER_CURRENT[3]);
        if (current3 != (answer3 = this.client.getVarbitValue(this.TUMBLER_ANSWERS[3]))) {
            this.updateWidget(3, current3, answer3);
            return;
        }
        this.highlightChildID = this.TRY_LOCK;
    }

    private void updateWidget(int widgetID, int currentVal, int answer) {
        int currentTumbler = this.client.getVarbitValue(this.CURRENT_TUMBLER);
        this.highlightChildID = currentTumbler != widgetID + 1 ? this.TUMBLER_WIDGETS[widgetID] : (currentVal > answer ? this.DOWN_WIDGET : this.UP_WIDGET);
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget widgetWrapper = this.client.getWidget(588, this.highlightChildID);
        if (widgetWrapper != null) {
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widgetWrapper.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widgetWrapper.getBounds());
        }
    }
}

