/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.kingsransom;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.kingsransom.LockpickPuzzle;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KINGS_RANSOM)
public class KingsRansom
extends BasicQuestHelper {
    ItemRequirement scrapPaper;
    ItemRequirement addressForm;
    ItemRequirement blackHelm;
    ItemRequirement criminalsThread;
    ItemRequirement hairclip;
    ItemRequirement lawRune;
    ItemRequirement airRune;
    ItemRequirement bronzeMed;
    ItemRequirement ironChain;
    ItemRequirement bronzeMedWorn;
    ItemRequirement ironChainWorn;
    ItemRequirement blackKnightLeg;
    ItemRequirement blackKnightLegWorn;
    ItemRequirement blackKnightBody;
    ItemRequirement blackKnightBodyWorn;
    ItemRequirement blackKnightHelm;
    ItemRequirement blackKnightHelmWorn;
    ItemRequirement animateRock;
    ItemRequirement lockpick;
    ItemRequirement grabOrLockpick;
    ItemRequirement hairclipOrLockpick;
    ItemRequirement holyGrail;
    ItemRequirement granite;
    ItemRequirement telegrab;
    ItemRequirement ardougneTeleport;
    ItemRequirement camelotTeleport;
    ItemRequirement monasteryOrEdgevilleTeleport;
    Requirement hasBlackHelm;
    Requirement hasScrapPaper;
    Requirement hasForm;
    Requirement inUpstairsManor;
    Requirement inDownstairsManor;
    Requirement inTrialRoom;
    Requirement handlerInRoom;
    Requirement butlerInRoom;
    Requirement maidInRoom;
    Requirement askedAboutThread;
    Requirement askedAboutDagger;
    Requirement askedAboutNight;
    Requirement askedAboutPoison;
    Requirement inPrison;
    Requirement inBasement;
    Requirement inPuzzle;
    Requirement hasTelegrabItems;
    Requirement inBoxWidget;
    Requirement inKeepF0;
    Requirement inKeepF1;
    Requirement inKeepF2;
    Requirement inFortressEntrance;
    Requirement inSecretRoom;
    QuestStep talkToGossip;
    QuestStep talkToGuard;
    QuestStep breakWindow;
    QuestStep grabPaper;
    QuestStep goUpstairsManor;
    QuestStep takeForm;
    QuestStep searchBookcase;
    QuestStep goDownstairsManor;
    QuestStep goDownstairsForPaper;
    QuestStep leaveWindow;
    QuestStep returnToGuard;
    QuestStep talkToGossipAgain;
    QuestStep talkToAnna;
    QuestStep goIntoTrial;
    QuestStep callHandlerAboutPoison;
    QuestStep callButlerAboutDagger;
    QuestStep callMaidAboutNight;
    QuestStep talkToHandlerAboutPoison;
    QuestStep talkToButlerAboutDagger;
    QuestStep talkToMaidAboutNight;
    QuestStep waitForVerdict;
    QuestStep leaveCourt;
    QuestStep talkToAnnaAfterTrial;
    QuestStep enterStatue;
    QuestStep talkToMerlin;
    QuestStep reachForVent;
    QuestStep useGrabOnGuard;
    QuestStep useHairClipOnOnDoor;
    QuestStep solvePuzzle;
    QuestStep climbF0ToF1;
    QuestStep climbF1ToF2;
    QuestStep searchTable;
    QuestStep selectPurpleBox;
    QuestStep goDownToArthur;
    QuestStep getLockpickOrRunes;
    QuestStep openMetalDoor;
    QuestStep enterStatueForGrail;
    QuestStep enterFortress;
    QuestStep enterWallInFortress;
    QuestStep freeArthur;
    QuestStep talkToArthur;
    QuestStep talkToArthurInCamelot;
    QuestStep enterFortressAfterFreeing;
    QuestStep enterWallInFortressAfterFreeing;
    QuestStep enterBasementAfterFreeing;
    NpcStep callAboutThread;
    NpcStep talkToCromperty;
    Zone upstairsManor;
    Zone downstairsManor;
    Zone downstairsManor2;
    Zone trialRoom;
    Zone prison;
    Zone basement;
    Zone keepF0;
    Zone keepF1;
    Zone keepF2;
    Zone secretRoomFloor0;
    Zone mainEntrance1;
    Zone mainEntrance2;
    Zone mainEntrance3;
    Zone mainEntrance4;
    Zone secretBasement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToGossip);
        steps.put(5, this.talkToGuard);
        ConditionalStep collectItems = new ConditionalStep((QuestHelper)this, this.breakWindow, new Requirement[0]);
        collectItems.addStep(new Conditions(this.inDownstairsManor, this.hasScrapPaper, this.hasForm, this.hasBlackHelm), this.leaveWindow);
        collectItems.addStep(new Conditions(this.inUpstairsManor, this.hasScrapPaper, this.hasForm, this.hasBlackHelm), this.goDownstairsManor);
        collectItems.addStep(new Conditions(this.hasScrapPaper, this.hasForm, this.hasBlackHelm), this.returnToGuard);
        collectItems.addStep(new Conditions(this.inUpstairsManor, this.hasScrapPaper, this.hasForm), this.searchBookcase);
        collectItems.addStep(new Conditions(this.inUpstairsManor, this.hasScrapPaper), this.takeForm);
        collectItems.addStep(this.inUpstairsManor, this.goDownstairsForPaper);
        collectItems.addStep(new Conditions(this.inDownstairsManor, this.hasScrapPaper), this.goUpstairsManor);
        collectItems.addStep(this.inDownstairsManor, this.grabPaper);
        steps.put(10, collectItems);
        steps.put(15, this.talkToGossipAgain);
        steps.put(20, this.talkToGossipAgain);
        steps.put(25, this.talkToAnna);
        ConditionalStep trialsSteps = new ConditionalStep((QuestHelper)this, this.talkToAnna, new Requirement[0]);
        trialsSteps.addStep(new Conditions(this.askedAboutPoison, this.askedAboutDagger, this.askedAboutNight, this.askedAboutThread), this.waitForVerdict);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.askedAboutPoison, this.askedAboutDagger, this.askedAboutNight), this.callAboutThread);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.askedAboutPoison, this.askedAboutDagger, this.maidInRoom), this.talkToMaidAboutNight);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.askedAboutPoison, this.askedAboutDagger), this.callMaidAboutNight);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.askedAboutPoison, this.butlerInRoom), this.talkToButlerAboutDagger);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.askedAboutPoison), this.callButlerAboutDagger);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.handlerInRoom), this.talkToHandlerAboutPoison);
        trialsSteps.addStep(new Conditions(this.criminalsThread, this.inTrialRoom), this.callHandlerAboutPoison);
        trialsSteps.addStep(this.criminalsThread, this.goIntoTrial);
        steps.put(30, trialsSteps);
        ConditionalStep talkToAnnaAfterTrialSteps = new ConditionalStep((QuestHelper)this, this.talkToAnnaAfterTrial, new Requirement[0]);
        talkToAnnaAfterTrialSteps.addStep(this.inTrialRoom, this.leaveCourt);
        steps.put(35, talkToAnnaAfterTrialSteps);
        steps.put(40, this.enterStatue);
        ConditionalStep goTalkToMerlin = new ConditionalStep((QuestHelper)this, this.enterStatue, new Requirement[0]);
        goTalkToMerlin.addStep(this.inPrison, this.talkToMerlin);
        steps.put(45, goTalkToMerlin);
        ConditionalStep findMerlinEscape = new ConditionalStep((QuestHelper)this, this.enterStatue, new Requirement[0]);
        findMerlinEscape.addStep(this.inPrison, this.reachForVent);
        steps.put(50, findMerlinEscape);
        ConditionalStep freeKnights = new ConditionalStep((QuestHelper)this, this.enterStatue, new Requirement[0]);
        freeKnights.addStep(this.inPuzzle, this.solvePuzzle);
        freeKnights.addStep(new Conditions(this.inPrison, this.hairclipOrLockpick), this.useHairClipOnOnDoor);
        freeKnights.addStep(new Conditions(this.inPrison, this.hasTelegrabItems), this.useGrabOnGuard);
        freeKnights.addStep(this.inPrison, this.getLockpickOrRunes);
        steps.put(55, freeKnights);
        steps.put(60, freeKnights);
        ConditionalStep getGrail = new ConditionalStep((QuestHelper)this, this.enterStatueForGrail, new Requirement[0]);
        getGrail.addStep(this.inBoxWidget, this.selectPurpleBox);
        getGrail.addStep(this.inKeepF2, this.searchTable);
        getGrail.addStep(this.inKeepF1, this.climbF1ToF2);
        getGrail.addStep(this.inKeepF0, this.climbF0ToF1);
        getGrail.addStep(this.inPrison, this.openMetalDoor);
        steps.put(65, getGrail);
        steps.put(70, this.talkToCromperty);
        ConditionalStep goFreeArthur = new ConditionalStep((QuestHelper)this, this.enterFortress, new Requirement[0]);
        goFreeArthur.addStep(this.inBasement, this.freeArthur);
        goFreeArthur.addStep(this.inSecretRoom, this.goDownToArthur);
        goFreeArthur.addStep(this.inFortressEntrance, this.enterWallInFortress);
        steps.put(75, goFreeArthur);
        ConditionalStep talkToArthurInBasement = new ConditionalStep((QuestHelper)this, this.enterFortressAfterFreeing, new Requirement[0]);
        talkToArthurInBasement.addStep(this.inBasement, this.talkToArthur);
        talkToArthurInBasement.addStep(this.inSecretRoom, this.enterBasementAfterFreeing);
        talkToArthurInBasement.addStep(this.inFortressEntrance, this.enterWallInFortressAfterFreeing);
        steps.put(80, talkToArthurInBasement);
        steps.put(85, this.talkToArthurInCamelot);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.scrapPaper = new ItemRequirement("Scrap paper", 11681);
        this.addressForm = new ItemRequirement("Address form", 11680);
        this.blackHelm = new ItemRequirement("Black knight helm", 11678);
        this.criminalsThread = new ItemRequirement("Criminal's thread", 1809);
        this.lawRune = new ItemRequirement("Law rune", 563);
        this.airRune = new ItemRequirement("Air rune", ItemCollections.AIR_RUNE);
        this.airRune.addAlternates(ItemCollections.AIR_STAFF);
        this.hairclip = new ItemRequirement("Hair clip", 11682);
        this.hairclip.setHighlightInInventory(true);
        this.ironChain = new ItemRequirement("Iron chainbody", 1101);
        this.ironChainWorn = new ItemRequirement("Iron chainbody", 1101, 1, true);
        this.bronzeMed = new ItemRequirement("Bronze med helm", 1139);
        this.bronzeMedWorn = new ItemRequirement("Bronze med helm", 1139, 1, true);
        this.blackKnightBody = new ItemRequirement("Black platebody", 1125).isNotConsumed();
        this.blackKnightBodyWorn = this.blackKnightBody.equipped();
        this.blackKnightLeg = new ItemRequirement("Black platelegs", 1077).isNotConsumed();
        this.blackKnightLegWorn = this.blackKnightLeg.equipped();
        this.blackKnightHelm = new ItemRequirement("Black full helm", 1165).isNotConsumed();
        this.blackKnightHelmWorn = this.blackKnightHelm.equipped();
        this.animateRock = new ItemRequirement("Animate rock scroll", 4428);
        this.animateRock.setTooltip("If you don't have one, you can get another from Wizard Cromperty in Ardougne during the quest");
        this.lockpick = new ItemRequirement("Lockpick", 1523);
        this.telegrab = new ItemRequirements("Telegrab runes", new ItemRequirement("Law rune", 563), new ItemRequirements(LogicType.OR, "Air runes or staff", new ItemRequirement("Air runes", ItemCollections.AIR_RUNE), new ItemRequirement("Air staff", ItemCollections.AIR_STAFF)));
        this.grabOrLockpick = new ItemRequirements(LogicType.OR, "Runes for telekinetic grab or a lockpick", new ItemRequirement("Lockpick", 1523), this.telegrab);
        this.hairclipOrLockpick = new ItemRequirement("Hair clip or Lockpick", 1523);
        this.hairclipOrLockpick.addAlternates(11682);
        this.holyGrail = new ItemRequirement("Holy grail", 19);
        this.holyGrail.setTooltip("You can get another from the purple box on the table in Morgan la Faye's Keep");
        this.granite = new ItemRequirement("Any granite", 6981);
        this.granite.setDisplayMatchedItemName(true);
        this.granite.addAlternates(6983, 6979);
        this.ardougneTeleport = new ItemRequirement("Ardougne teleport", 8011);
        this.camelotTeleport = new ItemRequirement("Camelot teleport", 8010, 3);
        this.monasteryOrEdgevilleTeleport = new ItemRequirement("Monastery with Combat Bracelet or Edgeville glory teleport", ItemCollections.AMULET_OF_GLORIES);
        this.monasteryOrEdgevilleTeleport.addAlternates(ItemCollections.COMBAT_BRACELETS);
    }

    public void loadZones() {
        this.upstairsManor = new Zone(new WorldPoint(2729, 3572, 1), new WorldPoint(2749, 3584, 1));
        this.downstairsManor = new Zone(new WorldPoint(2733, 3574, 0), new WorldPoint(2747, 3582, 0));
        this.downstairsManor2 = new Zone(new WorldPoint(2739, 3573, 0), new WorldPoint(2742, 3573, 0));
        this.trialRoom = new Zone(new WorldPoint(1815, 4260, 0), new WorldPoint(1825, 4276, 0));
        this.prison = new Zone(new WorldPoint(1690, 4250, 0), new WorldPoint(1909, 4283, 0));
        this.keepF0 = new Zone(new WorldPoint(1689, 4250, 0), new WorldPoint(1701, 4264, 0));
        this.keepF1 = new Zone(new WorldPoint(1689, 4250, 1), new WorldPoint(1701, 4264, 1));
        this.keepF2 = new Zone(new WorldPoint(1689, 4250, 2), new WorldPoint(1701, 4264, 2));
        this.basement = new Zone(new WorldPoint(1862, 4231, 0), new WorldPoint(1871, 4246, 0));
        this.secretRoomFloor0 = new Zone(new WorldPoint(3015, 3517, 0), new WorldPoint(3016, 3519, 0));
        this.secretBasement = new Zone(new WorldPoint(1862, 4264, 0), new WorldPoint(1873, 4229, 0));
        this.mainEntrance1 = new Zone(new WorldPoint(3008, 3513, 0), new WorldPoint(3012, 3518, 0));
        this.mainEntrance2 = new Zone(new WorldPoint(3012, 3514, 0), new WorldPoint(3014, 3516, 0));
        this.mainEntrance3 = new Zone(new WorldPoint(3015, 3515, 0), new WorldPoint(3019, 3516, 0));
        this.mainEntrance4 = new Zone(new WorldPoint(3019, 3513, 0), new WorldPoint(3019, 3517, 0));
    }

    public void setupConditions() {
        this.hasForm = new Conditions(LogicType.OR, this.addressForm, new VarbitRequirement(3890, 1));
        this.hasScrapPaper = new Conditions(LogicType.OR, this.scrapPaper, new VarbitRequirement(3891, 1));
        this.hasBlackHelm = new Conditions(LogicType.OR, this.blackHelm, new VarbitRequirement(3892, 1));
        this.inUpstairsManor = new ZoneRequirement(this.upstairsManor);
        this.inDownstairsManor = new ZoneRequirement(this.downstairsManor, this.downstairsManor2);
        this.inTrialRoom = new ZoneRequirement(this.trialRoom);
        this.inPrison = new ZoneRequirement(this.prison);
        this.inKeepF0 = new ZoneRequirement(this.keepF0);
        this.inKeepF1 = new ZoneRequirement(this.keepF1);
        this.inKeepF2 = new ZoneRequirement(this.keepF2);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inSecretRoom = new ZoneRequirement(this.secretRoomFloor0);
        this.inFortressEntrance = new ZoneRequirement(this.mainEntrance1, this.mainEntrance2, this.mainEntrance3, this.mainEntrance4);
        this.handlerInRoom = new VarbitRequirement(3907, 2);
        this.butlerInRoom = new VarbitRequirement(3907, 3);
        this.maidInRoom = new VarbitRequirement(3907, 5);
        this.askedAboutThread = new VarbitRequirement(3900, 1);
        this.askedAboutPoison = new VarbitRequirement(3912, 1);
        this.askedAboutDagger = new VarbitRequirement(3913, 1);
        this.askedAboutNight = new VarbitRequirement(3915, 1);
        this.inPuzzle = new WidgetModelRequirement(588, 1, 27214);
        this.hasTelegrabItems = new Conditions(this.airRune, this.lawRune);
        this.inBoxWidget = new WidgetModelRequirement(390, 0, 27488);
    }

    public void setupSteps() {
        this.talkToGossip = new NpcStep((QuestHelper)this, 4219, new WorldPoint(2741, 3557, 0), "Talk to Gossip, just south of the Sinclair Mansion.", new Requirement[0]);
        this.talkToGossip.addDialogStep("Yes.");
        this.talkToGossip.addDialogStep("How curious. Maybe I should investigate it.");
        this.talkToGuard = new NpcStep((QuestHelper)this, 4218, new WorldPoint(2741, 3561, 0), "Talk to the Guard in the Sinclair Manor.", new Requirement[0]);
        this.breakWindow = new ObjectStep((QuestHelper)this, 26123, new WorldPoint(2748, 3577, 0), "Right-click break the east window of the mansion, and enter it.", new Requirement[0]);
        this.goUpstairsManor = new ObjectStep((QuestHelper)this, 25682, new WorldPoint(2737, 3582, 0), "Go upstairs.", new Requirement[0]);
        this.goDownstairsForPaper = new ObjectStep((QuestHelper)this, 25683, new WorldPoint(2736, 3581, 1), "Pick up the scrap paper downstairs.", new Requirement[0]);
        this.grabPaper = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2746, 3580, 0), "Pick up the scrap paper.", this.scrapPaper);
        this.grabPaper.addSubSteps(this.goDownstairsForPaper);
        this.takeForm = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2739, 3581, 1), "Pick up the address form.", this.addressForm);
        this.searchBookcase = new ObjectStep((QuestHelper)this, 26053, new WorldPoint(2738, 3580, 1), "Search the west bookcase for a black knight helm.", new Requirement[0]);
        this.goDownstairsManor = new ObjectStep((QuestHelper)this, 25683, new WorldPoint(2736, 3581, 1), "Go down the staircase.", new Requirement[0]);
        this.leaveWindow = new ObjectStep((QuestHelper)this, 26123, new WorldPoint(2748, 3577, 0), "Step out of the window.", new Requirement[0]);
        this.returnToGuard = new NpcStep((QuestHelper)this, 4218, new WorldPoint(2741, 3561, 0), "Return to the guard with the 3 items.", new Requirement[0]);
        this.returnToGuard.addDialogSteps("I have proof that the Sinclairs have left.", "I have proof that links the Sinclairs to Camelot.", "I have proof of foul play.");
        this.talkToGossipAgain = new NpcStep((QuestHelper)this, 4219, new WorldPoint(2741, 3557, 0), "Ask Gossip all 3 chat options.", new Requirement[0]);
        this.talkToAnna = new NpcStep((QuestHelper)this, 967, new WorldPoint(2737, 3466, 0), "Talk to Anna in the Seers' Village Court House.", new Requirement[0]);
        this.talkToAnna.addDialogStep("Okay, I guess I don't have much of a choice.");
        this.talkToAnna.setAllowInCutscene(true);
        this.goIntoTrial = new ObjectStep((QuestHelper)this, 26017, new WorldPoint(2738, 3470, 0), "Go down the stairs to the court room.", new Requirement[0]);
        this.goIntoTrial.addDialogStep("Yes, I'm ready.");
        this.goIntoTrial.setAllowInCutscene(true);
        this.callHandlerAboutPoison = new ObjectStep((QuestHelper)this, 25956, new WorldPoint(1820, 4276, 0), "Talk to the judge to call the Dog Handler and ask them about the poison.", new Requirement[0]);
        this.callHandlerAboutPoison.addDialogSteps("Dog handler", "Previous page");
        this.callHandlerAboutPoison.setAllowInCutscene(true);
        this.talkToHandlerAboutPoison = new NpcStep((QuestHelper)this, 4213, "Ask Pierre about the poison.", new Requirement[0]);
        this.talkToHandlerAboutPoison.addDialogStep("Ask about the poison");
        this.talkToHandlerAboutPoison.setAllowInCutscene(true);
        this.callHandlerAboutPoison.addSubSteps(this.talkToHandlerAboutPoison);
        this.callButlerAboutDagger = new ObjectStep((QuestHelper)this, 25956, new WorldPoint(1820, 4276, 0), "Talk to the judge to call the Butler and ask them about the dagger.", new Requirement[0]);
        this.callButlerAboutDagger.addDialogSteps("Butler", "Previous page");
        this.callButlerAboutDagger.setAllowInCutscene(true);
        this.talkToButlerAboutDagger = new NpcStep((QuestHelper)this, 4214, "Ask Hobbes about the dagger.", new Requirement[0]);
        this.talkToButlerAboutDagger.addDialogStep("Ask about the dagger");
        this.talkToButlerAboutDagger.setAllowInCutscene(true);
        this.callButlerAboutDagger.addSubSteps(this.talkToButlerAboutDagger);
        this.callMaidAboutNight = new ObjectStep((QuestHelper)this, 25956, new WorldPoint(1820, 4276, 0), "Talk to the judge to call the Maid and ask them about the night of the murder.", new Requirement[0]);
        this.callMaidAboutNight.addDialogSteps("Maid", "Next page");
        this.callMaidAboutNight.setAllowInCutscene(true);
        this.talkToMaidAboutNight = new NpcStep((QuestHelper)this, 4216, "Ask Mary about the night of the murder.", new Requirement[0]);
        this.talkToMaidAboutNight.addDialogStep("Ask about the night of the murder");
        this.talkToMaidAboutNight.setAllowInCutscene(true);
        this.callMaidAboutNight.addSubSteps(this.talkToMaidAboutNight);
        this.callAboutThread = new NpcStep((QuestHelper)this, 4216, "Ask anyone about the thread.", new Requirement[0]);
        this.callAboutThread.addDialogStep("Ask about the thread");
        this.callAboutThread.addAlternateNpcs(4214, 4213, 4212, 4215, 4217);
        this.callAboutThread.setAllowInCutscene(true);
        this.waitForVerdict = new DetailedQuestStep((QuestHelper)this, "Wait for the jury to reach their verdict.", new Requirement[0]);
        this.callAboutThread.addSubSteps(this.waitForVerdict);
        this.leaveCourt = new ObjectStep((QuestHelper)this, 26042, new WorldPoint(1820, 4268, 0), "Leave the court room.", new Requirement[0]);
        this.talkToAnnaAfterTrial = new NpcStep((QuestHelper)this, 967, new WorldPoint(2737, 3466, 0), "Talk to Anna in the Seers' Village Court House.", new Requirement[0]);
        this.enterStatue = new ObjectStep((QuestHelper)this, 26073, new WorldPoint(2780, 3508, 0), "Search the statue east of Camelot.", this.grabOrLockpick);
        this.talkToMerlin = new NpcStep((QuestHelper)this, 3529, new WorldPoint(1907, 4281, 0), "Talk to Merlin.", new Requirement[0]);
        this.talkToMerlin.addDialogStep("What do we do now?");
        this.reachForVent = new ObjectStep((QuestHelper)this, 25880, new WorldPoint(1904, 4283, 0), "Reach for the vent on the north wall.", new Requirement[0]);
        this.useGrabOnGuard = new NpcStep((QuestHelper)this, 4332, new WorldPoint(1906, 4270, 0), "Use telekinetic grab on the guard grooming their hair.", this.lawRune, this.airRune);
        this.useHairClipOnOnDoor = new ObjectStep((QuestHelper)this, 25876, new WorldPoint(1904, 4273, 0), "Attempt to open the cell door.", this.hairclipOrLockpick);
        this.getLockpickOrRunes = new DetailedQuestStep((QuestHelper)this, "Get a lockpick or runes for telegrab. Talking to the knights in the room can give you a lockpick.", new Requirement[0]);
        this.useGrabOnGuard.addSubSteps(this.getLockpickOrRunes);
        this.goDownToArthur = new ObjectStep((QuestHelper)this, 25843, new WorldPoint(3016, 3519, 0), "Enter the Black Knight Fortress basement.", new Requirement[0]);
        this.solvePuzzle = new LockpickPuzzle(this);
        this.enterStatueForGrail = new ObjectStep((QuestHelper)this, 26073, new WorldPoint(2780, 3508, 0), "Search the statue east of Camelot.", new Requirement[0]);
        this.openMetalDoor = new ObjectStep((QuestHelper)this, 25876, new WorldPoint(1904, 4273, 0), "Go through the cell door.", new Requirement[0]);
        this.climbF0ToF1 = new ObjectStep((QuestHelper)this, 25786, new WorldPoint(1696, 4260, 0), "Climb to the top of the keep.", new Requirement[0]);
        this.climbF1ToF2 = new ObjectStep((QuestHelper)this, 25786, new WorldPoint(1696, 4254, 1), "Climb to the top of the keep.", new Requirement[0]);
        this.climbF0ToF1.addSubSteps(this.climbF1ToF2);
        this.searchTable = new ObjectStep((QuestHelper)this, 2650, new WorldPoint(1696, 4259, 2), "Search the table and take the purple round box.", new Requirement[0]);
        this.selectPurpleBox = new WidgetStep((QuestHelper)this, "Take the purple round box.", 390, 16);
        this.searchTable.addSubSteps(this.selectPurpleBox);
        this.talkToCromperty = new NpcStep((QuestHelper)this, 8480, new WorldPoint(2684, 3323, 0), "Talk to Wizard Cromperty in East Ardougne.", new Requirement[0]);
        this.talkToCromperty.addAlternateNpcs(8481);
        this.talkToCromperty.addDialogSteps("Chat.");
        this.enterFortress = new ObjectStep((QuestHelper)this, 2337, new WorldPoint(3016, 3514, 0), "Enter the Black Knight Fortress wearing the bronze med helm and iron chainbody.", this.bronzeMedWorn, this.ironChainWorn, this.blackKnightHelm, this.blackKnightBody, this.blackKnightLeg, this.animateRock, this.holyGrail, this.granite);
        this.enterWallInFortress = new ObjectStep((QuestHelper)this, 2341, new WorldPoint(3016, 3517, 0), "Enter the secret room wearing the black knight armour.", this.blackKnightHelmWorn, this.blackKnightBodyWorn, this.blackKnightLegWorn, this.animateRock, this.holyGrail, this.granite);
        this.freeArthur = new ObjectStep((QuestHelper)this, 25943, new WorldPoint(1867, 4233, 0), "Free King Arthur by using the animate rock scroll.", this.animateRock.highlighted(), this.holyGrail, this.granite);
        this.enterFortressAfterFreeing = new ObjectStep((QuestHelper)this, 2337, new WorldPoint(3016, 3514, 0), "Enter the Black Knight Fortress.", this.bronzeMedWorn, this.ironChainWorn, this.blackKnightHelm, this.blackKnightBody, this.blackKnightLeg);
        this.enterWallInFortressAfterFreeing = new ObjectStep((QuestHelper)this, 2341, new WorldPoint(3016, 3517, 0), "Enter the secret room.", this.blackKnightHelmWorn, this.blackKnightBodyWorn, this.blackKnightLegWorn, this.bronzeMed, this.ironChain);
        this.enterBasementAfterFreeing = new ObjectStep((QuestHelper)this, 25843, new WorldPoint(3016, 3519, 0), "Enter the Black Knight Fortress basement.", new Requirement[0]);
        this.talkToArthur = new NpcStep((QuestHelper)this, 3531, new WorldPoint(1867, 4235, 0), "Talk to King Arthur in the basement.", this.bronzeMed, this.ironChain);
        this.talkToArthur.addSubSteps(this.enterBasementAfterFreeing, this.enterFortressAfterFreeing, this.enterWallInFortressAfterFreeing);
        this.talkToArthurInCamelot = new NpcStep((QuestHelper)this, 3531, new WorldPoint(2763, 3512, 0), "Talk to King Arthur in Camelot to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.grabOrLockpick, this.granite, this.blackKnightHelm, this.blackKnightBody, this.blackKnightLeg, this.bronzeMed, this.ironChain);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ardougneTeleport, this.camelotTeleport, this.monasteryOrEdgevilleTeleport);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.BLACK_KNIGHTS_FORTRESS, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.HOLY_GRAIL, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.MURDER_MYSTERY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.ONE_SMALL_FAVOUR, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.MAGIC, 45));
        req.add(new SkillRequirement(Skill.DEFENCE, 65));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.DEFENCE, 33000), new ExperienceReward(Skill.MAGIC, 5000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("5,000 Experience Lamp (any skill over 50).", 4447, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.talkToGossip, this.talkToGuard, this.breakWindow, this.grabPaper, this.goUpstairsManor, this.takeForm, this.searchBookcase, this.goDownstairsManor, this.leaveWindow, this.returnToGuard, this.talkToGossipAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Freeing Anna", Arrays.asList(this.talkToAnna, this.goIntoTrial, this.callHandlerAboutPoison, this.callButlerAboutDagger, this.callMaidAboutNight, this.callAboutThread, this.leaveCourt, this.talkToAnnaAfterTrial), new Requirement[0]));
        allSteps.add(new PanelDetails("Saving Merlin and Knights", Arrays.asList(this.enterStatue, this.talkToMerlin, this.reachForVent, this.useGrabOnGuard, this.useHairClipOnOnDoor, this.solvePuzzle, this.climbF0ToF1, this.searchTable, this.talkToCromperty), this.grabOrLockpick));
        allSteps.add(new PanelDetails("Saving Arthur", Arrays.asList(this.enterFortress, this.enterWallInFortress, this.goDownToArthur, this.freeArthur, this.talkToArthur, this.talkToArthurInCamelot), this.bronzeMed, this.ironChain, this.blackKnightHelm, this.blackKnightBody, this.blackKnightLeg, this.granite, this.animateRock));
        return allSteps;
    }
}

