/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.junglepotion;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.JUNGLE_POTION)
public class JunglePotion
extends BasicQuestHelper {
    ItemRequirement grimySnakeWeed;
    ItemRequirement snakeWeed;
    ItemRequirement grimyArdrigal;
    ItemRequirement ardrigal;
    ItemRequirement grimySitoFoil;
    ItemRequirement sitoFoil;
    ItemRequirement grimyVolenciaMoss;
    ItemRequirement volenciaMoss;
    ItemRequirement roguesPurse;
    ItemRequirement grimyRoguesPurse;
    QuestStep startQuest;
    QuestStep finishQuest;
    ObjectStep getSnakeWeed;
    ObjectStep getArdrigal;
    ObjectStep getSitoFoil;
    ObjectStep getVolenciaMoss;
    ObjectStep enterCave;
    ObjectStep getRoguePurseHerb;
    ConditionalStep cleanAndReturnSnakeWeed;
    ConditionalStep cleanAndReturnArdrigal;
    ConditionalStep cleanAndReturnSitoFoil;
    ConditionalStep cleanAndReturnVolenciaMoss;
    ConditionalStep getRoguesPurse;
    ConditionalStep cleanAndReturnRoguesPurse;
    ZoneRequirement isUnderground;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        return this.getSteps();
    }

    @Override
    public void setupRequirements() {
        this.grimySnakeWeed = new ItemRequirement("Grimy Snake Weed", 1525);
        this.grimySnakeWeed.setHighlightInInventory(true);
        this.snakeWeed = new ItemRequirement("Snake Weed", 1526);
        this.grimyArdrigal = new ItemRequirement("Grimy Ardrigal", 1527);
        this.grimyArdrigal.setHighlightInInventory(true);
        this.ardrigal = new ItemRequirement("Ardrigal", 1528);
        this.grimySitoFoil = new ItemRequirement("Grimy Sito Foil", 1529);
        this.grimySitoFoil.setHighlightInInventory(true);
        this.sitoFoil = new ItemRequirement("Sito Foil", 1530);
        this.grimyVolenciaMoss = new ItemRequirement("Grimy Volencia Moss", 1531);
        this.grimyVolenciaMoss.setHighlightInInventory(true);
        this.volenciaMoss = new ItemRequirement("Volencia Moss", 1532);
        this.grimyRoguesPurse = new ItemRequirement("Grimy Rogues Purse", 1533);
        this.grimyRoguesPurse.setHighlightInInventory(true);
        this.roguesPurse = new ItemRequirement("Rogues Purse", 1534);
    }

    private void setupZones() {
        Zone undergroundZone = new Zone(new WorldPoint(2824, 9462, 0), new WorldPoint(2883, 9533, 0));
        this.isUnderground = new ZoneRequirement(undergroundZone);
    }

    private Map<Integer, QuestStep> getSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuestStep());
        steps.put(1, this.getSnakeWeed());
        steps.put(2, this.returnSnakeWeed());
        steps.put(3, this.getArdrigal());
        steps.put(4, this.returnArdigal());
        steps.put(5, this.getSitoFoil());
        steps.put(6, this.returnSitoFoil());
        steps.put(7, this.getVolenciaMoss());
        steps.put(8, this.returnVolenciaMoss());
        steps.put(9, this.getRoguesPurse());
        steps.put(10, this.returnRoguesPurse());
        steps.put(11, this.finishQuestStep());
        return steps;
    }

    private QuestStep startQuestStep() {
        this.startQuest = this.talkToTrufitus("Talk to Trufitus in Tai Bwo Wannai on Karamja.", new Requirement[0]);
        this.startQuest.addDialogSteps("It's a nice village, where is everyone?");
        this.startQuest.addDialogSteps("Me? How can I help?");
        this.startQuest.addDialogSteps("It sounds like just the challenge for me.");
        return this.startQuest;
    }

    private QuestStep returnArdigal() {
        this.cleanAndReturnArdrigal = this.getReturnHerbStep("Ardrigal", this.grimyArdrigal, this.ardrigal);
        return this.cleanAndReturnArdrigal;
    }

    private QuestStep returnSnakeWeed() {
        this.cleanAndReturnSnakeWeed = this.getReturnHerbStep("Snake Weed", this.grimySnakeWeed, this.snakeWeed);
        return this.cleanAndReturnSnakeWeed;
    }

    private QuestStep returnSitoFoil() {
        this.cleanAndReturnSitoFoil = this.getReturnHerbStep("Sito Foil", this.grimySitoFoil, this.sitoFoil);
        return this.cleanAndReturnSitoFoil;
    }

    private QuestStep returnVolenciaMoss() {
        this.cleanAndReturnVolenciaMoss = this.getReturnHerbStep("Volencia Moss", this.grimyVolenciaMoss, this.volenciaMoss);
        return this.cleanAndReturnVolenciaMoss;
    }

    private QuestStep returnRoguesPurse() {
        this.cleanAndReturnRoguesPurse = this.getReturnHerbStep("Rogues Purse", this.grimyRoguesPurse, this.roguesPurse);
        this.cleanAndReturnRoguesPurse.addStep(this.isUnderground, new ObjectStep((QuestHelper)this, 2585, new WorldPoint(2830, 9522, 0), "Climb out of the cave.", new Requirement[0]));
        return this.cleanAndReturnRoguesPurse;
    }

    private ConditionalStep getReturnHerbStep(String herbName, ItemRequirement grimyHerb, ItemRequirement cleanHerb) {
        NpcStep returnHerb = this.talkToTrufitus("", cleanHerb);
        returnHerb.addDialogSteps("Of course!");
        DetailedQuestStep cleanGrimyHerb = new DetailedQuestStep((QuestHelper)this, "", grimyHerb);
        ConditionalStep cleanAndReturnHerb = new ConditionalStep((QuestHelper)this, (QuestStep)cleanGrimyHerb, "Clean and return the " + herbName + " to Trufitus.", new Requirement[0]);
        cleanAndReturnHerb.addStep(cleanHerb, returnHerb);
        return cleanAndReturnHerb;
    }

    private QuestStep getSnakeWeed() {
        this.getSnakeWeed = new ObjectStep((QuestHelper)this, 2575, new WorldPoint(2763, 3044, 0), "Search a marshy jungle vine south of Tai Bwo Wannai for some snake weed.", new Requirement[0]);
        this.getSnakeWeed.addText("If you want to do Zogre Flesh Eaters or Legends' Quest grab one for each as you will need them later.");
        return this.getSnakeWeed;
    }

    private QuestStep getArdrigal() {
        this.getArdrigal = new ObjectStep((QuestHelper)this, 2577, new WorldPoint(2871, 3116, 0), "Search the palm trees north east of Tai Bwo Wannai for an Ardrigal herb.", new Requirement[0]);
        this.getArdrigal.addText("If you want to do Legends' Quest grab one extra as you will need it later.");
        return this.getArdrigal;
    }

    private QuestStep getSitoFoil() {
        this.getSitoFoil = new ObjectStep((QuestHelper)this, 2579, new WorldPoint(2791, 3047, 0), "Search the scorched earth in the south of Tai Bwo Wannai for a Sito Foil herb.", new Requirement[0]);
        return this.getSitoFoil;
    }

    private QuestStep getVolenciaMoss() {
        this.getVolenciaMoss = new ObjectStep((QuestHelper)this, 2581, new WorldPoint(2851, 3036, 0), "Search the rock for a Volencia Moss herb at the mine south east of Tai Bwo Wannai.", new Requirement[0]);
        this.getVolenciaMoss.addText("If you plan on doing Fairy Tale I then take an extra.");
        return this.getVolenciaMoss;
    }

    private QuestStep getRoguesPurse() {
        this.enterCave = new ObjectStep((QuestHelper)this, 2584, new WorldPoint(2825, 3119, 0), "Enter the cave to the north by clicking on the rocks.", new Requirement[0]);
        this.enterCave.addDialogStep("Yes, I'll enter the cave.");
        this.getRoguePurseHerb = new ObjectStep((QuestHelper)this, 2583, "Get the Rogues Purse from the fungus covered wall in the underground dungeon.", new Requirement[0]);
        this.getRoguePurseHerb.setHideWorldArrow(true);
        this.getRoguePurseHerb.addText("If you are planning on doing Zogre Flesh Eaters then take an extra.");
        this.getRoguesPurse = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCave, new Requirement[0]);
        this.getRoguesPurse.addStep(this.isUnderground, this.getRoguePurseHerb);
        this.getRoguesPurse.addSubSteps(this.enterCave);
        return this.getRoguesPurse;
    }

    private QuestStep finishQuestStep() {
        this.finishQuest = this.talkToTrufitus("Talk to Trufitus to finish the quest.", new Requirement[0]);
        return this.finishQuest;
    }

    private NpcStep talkToTrufitus(String text, Requirement ... requirements) {
        return new NpcStep((QuestHelper)this, 4625, new WorldPoint(2809, 3085, 0), text, requirements);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Survive against level 53 Jogres and level 46 Harpie Bug Swarms.");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        ItemRequirement food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        reqs.add(food);
        reqs.add(new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS));
        ItemRequirement karaTele = new ItemRequirement("Teleport to Karamja (Glory/house teleport)", 11745);
        karaTele.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        reqs.add(karaTele);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.DRUIDIC_RITUAL, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.HERBLORE, 3, false));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.HERBLORE, 775));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> steps = new ArrayList<PanelDetails>();
        PanelDetails startingPanel = new PanelDetails("Starting quest", Collections.singletonList(this.startQuest), new Requirement[0]);
        steps.add(startingPanel);
        PanelDetails snakeWeedPanel = new PanelDetails("Snake Weed", Arrays.asList(this.getSnakeWeed, this.cleanAndReturnSnakeWeed), new Requirement[0]);
        steps.add(snakeWeedPanel);
        PanelDetails ardrigalPanel = new PanelDetails("Ardrigal", Arrays.asList(this.getArdrigal, this.cleanAndReturnArdrigal), new Requirement[0]);
        steps.add(ardrigalPanel);
        PanelDetails sitoFoilpanel = new PanelDetails("Sito Foil", Arrays.asList(this.getSitoFoil, this.cleanAndReturnSitoFoil), new Requirement[0]);
        steps.add(sitoFoilpanel);
        PanelDetails volenciaMossPanel = new PanelDetails("Volencia Moss", Arrays.asList(this.getVolenciaMoss, this.cleanAndReturnVolenciaMoss), new Requirement[0]);
        steps.add(volenciaMossPanel);
        PanelDetails roguesPursePanel = new PanelDetails("Rogues Purse", Arrays.asList(this.enterCave, this.getRoguePurseHerb, this.cleanAndReturnRoguesPurse), new Requirement[0]);
        steps.add(roguesPursePanel);
        return steps;
    }
}

