/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.insearchofknowledge;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.insearchofknowledge.FeedingAimeri;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Prayer;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.IN_SEARCH_OF_KNOWLEDGE)
public class InSearchOfKnowledge
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement food5;
    ItemRequirement food5Highlighted;
    ItemRequirement knife;
    ItemRequirement moonPage;
    ItemRequirement templePage;
    ItemRequirement sunPage;
    ItemRequirement sunTome;
    ItemRequirement moonTome;
    ItemRequirement templeTome;
    Requirement protectFromMagic;
    Requirement inDungeon;
    Requirement fedAimeri;
    Requirement hadTempleTome;
    Requirement hadSunTome;
    Requirement hadMoonTome;
    Requirement repairedMoon;
    Requirement repairedSun;
    Requirement repairedTemple;
    Requirement repairedTomes;
    Requirement givenSunTome;
    Requirement givenMoonTome;
    Requirement givenTempleTome;
    QuestStep enterDungeon;
    QuestStep useFoodOnAimeri;
    QuestStep talkToAimeriAgain;
    QuestStep searchBookcasesForTemple;
    QuestStep searchBookcasesForMoon;
    QuestStep searchBookcasesForSun;
    QuestStep getPages;
    QuestStep enterDungeonAgain;
    QuestStep useMoonOnLogosia;
    QuestStep useSunOnLogosia;
    QuestStep useTempleOnLogosia;
    QuestStep talkToLogosia;
    Zone dungeon;
    ConditionalStep goTalkToAimeri;
    ConditionalStep repairTomes;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goFeedAimeri = new ConditionalStep((QuestHelper)this, this.enterDungeon, new Requirement[0]);
        goFeedAimeri.addStep(new Conditions(this.inDungeon, this.fedAimeri), this.talkToAimeriAgain);
        goFeedAimeri.addStep(this.inDungeon, this.useFoodOnAimeri);
        steps.put(0, goFeedAimeri);
        this.goTalkToAimeri = new ConditionalStep((QuestHelper)this, this.enterDungeonAgain, new Requirement[0]);
        this.goTalkToAimeri.addStep(new Conditions(this.inDungeon, this.hadTempleTome, this.hadSunTome), this.searchBookcasesForMoon);
        this.goTalkToAimeri.addStep(new Conditions(this.inDungeon, this.hadTempleTome), this.searchBookcasesForSun);
        this.goTalkToAimeri.addStep(this.inDungeon, this.searchBookcasesForTemple);
        this.goTalkToAimeri.setLockingCondition(new Conditions(this.hadTempleTome, this.hadSunTome, this.hadMoonTome));
        this.repairTomes = new ConditionalStep((QuestHelper)this, (QuestStep)this.goTalkToAimeri, new Requirement[0]);
        this.repairTomes.addStep(new Conditions(this.hadTempleTome, this.hadSunTome, this.hadMoonTome), this.getPages);
        this.repairTomes.setLockingCondition(this.repairedTomes);
        ConditionalStep bringTomesToFinish = new ConditionalStep((QuestHelper)this, (QuestStep)this.repairTomes, new Requirement[0]);
        bringTomesToFinish.addStep(new Conditions(this.repairedTomes, this.givenMoonTome, this.givenSunTome), this.useTempleOnLogosia);
        bringTomesToFinish.addStep(new Conditions(this.repairedTomes, this.givenMoonTome), this.useSunOnLogosia);
        bringTomesToFinish.addStep(this.repairedTomes, this.useMoonOnLogosia);
        steps.put(1, bringTomesToFinish);
        steps.put(2, this.talkToLogosia);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food5 = new ItemRequirement("Food", ItemCollections.FISH_FOOD, 5);
        this.food5Highlighted = new ItemRequirement("Food", ItemCollections.FISH_FOOD, 5);
        this.food5Highlighted.setHighlightInInventory(true);
        this.knife = new ItemRequirement("Knife or slash weapon to cut through a web", 946).isNotConsumed();
        this.knife.addAlternates(3981, 13108, 13109, 13110, 13111);
        this.protectFromMagic = new PrayerRequirement("Protect from Magic", Prayer.PROTECT_FROM_MAGIC);
        this.sunPage = new ItemRequirement("Tattered sun page", 23512);
        this.moonPage = new ItemRequirement("Tattered moon page", 23510);
        this.templePage = new ItemRequirement("Tattered temple page", 23514);
        this.sunTome = new ItemRequirement("Tome of the sun", 23506);
        this.sunTome.setTooltip("You can get another from the bookshelves in the Forthos Dungeon");
        this.sunTome.setHighlightInInventory(true);
        this.moonTome = new ItemRequirement("Tome of the moon", 23504);
        this.moonTome.setTooltip("You can get another from the bookshelves in the Forthos Dungeon");
        this.moonTome.setHighlightInInventory(true);
        this.templeTome = new ItemRequirement("Tome of the temple", 23508);
        this.templeTome.setTooltip("You can get another from the bookshelves in the Forthos Dungeon");
        this.templeTome.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.dungeon = new Zone(new WorldPoint(1792, 9880, 0), new WorldPoint(1856, 9983, 0));
    }

    public void setupConditions() {
        this.inDungeon = new ZoneRequirement(this.dungeon);
        this.fedAimeri = new VarbitRequirement(8393, 5);
        this.givenSunTome = new VarbitRequirement(8405, 1);
        this.givenMoonTome = new VarbitRequirement(8404, 1);
        this.givenTempleTome = new VarbitRequirement(8406, 1);
        this.hadTempleTome = new Conditions(true, LogicType.OR, this.templeTome, this.givenTempleTome);
        this.hadMoonTome = new Conditions(true, LogicType.OR, this.moonTome, this.givenMoonTome);
        this.hadSunTome = new Conditions(true, LogicType.OR, this.sunTome, this.givenSunTome);
        this.repairedSun = new VarbitRequirement(8399, 4);
        this.repairedMoon = new VarbitRequirement(8400, 4);
        this.repairedTemple = new VarbitRequirement(8401, 4);
        this.repairedTomes = new Conditions(this.repairedSun, this.repairedMoon, this.repairedTemple);
    }

    public void setupSteps() {
        this.enterDungeon = new ObjectStep((QuestHelper)this, 34862, new WorldPoint(1702, 3574, 0), "Enter the Forthos Dungeon.", this.knife, this.food5);
        this.useFoodOnAimeri = new FeedingAimeri(this);
        this.talkToAimeriAgain = new NpcStep((QuestHelper)this, 8705, new WorldPoint(1840, 9926, 0), "Talk to Aimeri again.", new Requirement[0]);
        this.talkToAimeriAgain.addDialogStep("Who are you?");
        this.searchBookcasesForTemple = new ObjectStep((QuestHelper)this, 34849, new WorldPoint(1796, 9935, 0), "Search the musty bookshelves to the west of Aimeri for the tomes of moon, sun, and temple.", this.protectFromMagic);
        this.searchBookcasesForSun = new ObjectStep((QuestHelper)this, 34847, new WorldPoint(1805, 9935, 0), "Search the musty bookshelves to the west of Aimeri for the tomes of moon, sun, and temple.", this.protectFromMagic);
        this.searchBookcasesForMoon = new ObjectStep((QuestHelper)this, 34848, new WorldPoint(1804, 9943, 0), "Search the musty bookshelves to the west of Aimeri for the tomes of moon, sun, and temple.", this.protectFromMagic);
        this.enterDungeonAgain = new ObjectStep((QuestHelper)this, 34862, new WorldPoint(1702, 3574, 0), "Kill any monsters in the Forthos Dungeon for pages for the tomes. You'll need 4 page for each tome.", this.combatGear);
        this.getPages = new DetailedQuestStep((QuestHelper)this, "Kill any monsters in the Forthos Dungeon for pages for the tomes. You'll need to use 4 pages on each tome.", this.combatGear);
        this.getPages.addSubSteps(this.enterDungeonAgain);
        this.useMoonOnLogosia = new NpcStep((QuestHelper)this, 7044, new WorldPoint(1633, 3808, 0), "Give the tomes to Logosia in the Arceuus library.", this.moonTome);
        this.useMoonOnLogosia.addIcon(23504);
        this.useSunOnLogosia = new NpcStep((QuestHelper)this, 7044, new WorldPoint(1633, 3808, 0), "Give the tomes to Logosia in the Arceuus library.", this.sunTome);
        this.useSunOnLogosia.addIcon(23506);
        this.useTempleOnLogosia = new NpcStep((QuestHelper)this, 7044, new WorldPoint(1633, 3808, 0), "Give the tomes to Logosia in the Arceuus library.", this.templeTome);
        this.useTempleOnLogosia.addIcon(23508);
        this.talkToLogosia = new NpcStep((QuestHelper)this, 7044, new WorldPoint(1633, 3808, 0), "Talk to Logosia in the Arceuus library.", new Requirement[0]);
        this.useMoonOnLogosia.addSubSteps(this.useSunOnLogosia, this.useTempleOnLogosia, this.talkToLogosia);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.knife, this.food5, this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Many monsters in the Forthos Dungeon");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("10,000 Experience Lamp (any skill over level 40).", 4447, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping Aimeri", Arrays.asList(this.enterDungeon, this.useFoodOnAimeri, this.talkToAimeriAgain), this.knife, this.food5, this.combatGear));
        PanelDetails getBookPanel = new PanelDetails("Getting the books", Collections.singletonList(this.searchBookcasesForTemple), new Requirement[0]);
        getBookPanel.setLockingStep(this.goTalkToAimeri);
        allSteps.add(getBookPanel);
        PanelDetails getPagesPanel = new PanelDetails("Repairing the books", Collections.singletonList(this.getPages), this.combatGear);
        getPagesPanel.setLockingStep(this.repairTomes);
        allSteps.add(getPagesPanel);
        allSteps.add(new PanelDetails("Document the Tomes", Collections.singletonList(this.useMoonOnLogosia), this.moonTome, this.sunTome, this.templeTome));
        return allSteps;
    }
}

