/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.impcatcher;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.IMP_CATCHER)
public class ImpCatcher
extends BasicQuestHelper {
    ItemRequirement blackBead;
    ItemRequirement whiteBead;
    ItemRequirement redBead;
    ItemRequirement yellowBead;
    QuestStep moveToTower;
    QuestStep climbTower;
    QuestStep turnInQuest;
    QuestStep collectBeads;
    Zone towerSecond;
    Zone towerThird;
    ZoneRequirement inTowerSecond;
    ZoneRequirement inTowerThird;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep doQuest = new ConditionalStep((QuestHelper)this, this.collectBeads, new Requirement[0]);
        doQuest.addStep(new Conditions(this.blackBead, this.whiteBead, this.redBead, this.yellowBead, this.inTowerThird), this.turnInQuest);
        doQuest.addStep(new Conditions(this.blackBead, this.whiteBead, this.redBead, this.yellowBead, this.inTowerSecond), this.climbTower);
        doQuest.addStep(new Conditions(this.blackBead, this.whiteBead, this.redBead, this.yellowBead), this.moveToTower);
        steps.put(0, doQuest);
        steps.put(1, doQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.blackBead = new ItemRequirement("Black bead", 1474);
        this.whiteBead = new ItemRequirement("White bead", 1476);
        this.redBead = new ItemRequirement("Red bead", 1470);
        this.yellowBead = new ItemRequirement("Yellow bead", 1472);
        this.inTowerSecond = new ZoneRequirement(this.towerSecond);
        this.inTowerThird = new ZoneRequirement(this.towerThird);
    }

    public void setupSteps() {
        this.collectBeads = new DetailedQuestStep((QuestHelper)this, "Collect one of each bead. You can kill imps for these beads, or buy them on the Grand Exchange.", this.blackBead, this.whiteBead, this.redBead, this.yellowBead);
        this.moveToTower = new ObjectStep((QuestHelper)this, 12536, new WorldPoint(3103, 3159, 0), "Head to the Wizards' Tower and climb up the staircase with the required beads.", this.blackBead, this.whiteBead, this.redBead, this.yellowBead);
        this.climbTower = new ObjectStep((QuestHelper)this, 12537, new WorldPoint(3103, 3159, 1), "Climb the staircase again.", this.blackBead, this.whiteBead, this.redBead, this.yellowBead);
        this.turnInQuest = new NpcStep((QuestHelper)this, 7746, new WorldPoint(3103, 3163, 2), "Talk to Wizard Mizgog with the required beads to finish the quest.", this.blackBead, this.whiteBead, this.redBead, this.yellowBead);
        this.turnInQuest.addDialogSteps("Give me a quest please.", "Yes.");
    }

    public void loadZones() {
        this.towerSecond = new Zone(new WorldPoint(3089, 3176, 1), new WorldPoint(3126, 3146, 1));
        this.towerThird = new Zone(new WorldPoint(3089, 3176, 2), new WorldPoint(3126, 3146, 2));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.blackBead);
        reqs.add(this.whiteBead);
        reqs.add(this.redBead);
        reqs.add(this.yellowBead);
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Bring Mizgog his beads", Arrays.asList(this.collectBeads, this.moveToTower, this.climbTower, this.turnInQuest), this.blackBead, this.whiteBead, this.redBead, this.yellowBead));
        return allSteps;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MAGIC, 875));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("An Amulet of Accuracy", 1478, 1));
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Imps (level 2) if you plan on collecting the beads yourself");
    }
}

