/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.icthlarinslittlehelper;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.NpcCollections;
import com.questhelper.helpers.quests.icthlarinslittlehelper.DoorPuzzleStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.FollowerItemRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.FollowerRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ICTHLARINS_LITTLE_HELPER)
public class IcthlarinsLittleHelper
extends BasicQuestHelper {
    ItemRequirement cat;
    ItemRequirement tinderbox;
    ItemRequirement coins600;
    ItemRequirement bagOfSaltOrBucket;
    ItemRequirement willowLog;
    ItemRequirement bucketOfSap;
    ItemRequirement waterskin4;
    ItemRequirement food;
    ItemRequirement sphinxsToken;
    ItemRequirement jar;
    ItemRequirement coinsOrLinen;
    ItemRequirement coins30;
    ItemRequirement linen;
    ItemRequirement holySymbol;
    ItemRequirement unholySymbol;
    ItemRequirement combatGear;
    ItemRequirement prayerPotions;
    ItemRequirement antipoison;
    ItemRequirement bucketOfSaltwater;
    ItemRequirement salt;
    ItemRequirement bucket;
    Requirement catFollower;
    Requirement inSoph;
    Requirement inPyramid;
    Requirement inNorthPyramid;
    Requirement puzzleOpen;
    Requirement givenToken;
    Requirement hasScarabasJar;
    Requirement hasCrondisJar;
    Requirement hasHetJar;
    Requirement hasApmekenJar;
    Requirement killedGuardian;
    Requirement talkedToEmbalmer;
    Requirement givenLinen;
    Requirement givenSalt;
    Requirement givenSap;
    Requirement givenEmbalmerAllItems;
    Requirement talkedToCarpenter;
    Requirement givenCarpenterLogs;
    Requirement inEastRoom;
    Requirement possessedPriestNearby;
    QuestStep talkToWanderer;
    QuestStep talkToWandererAgain;
    QuestStep enterRock;
    QuestStep touchPyramidDoor;
    QuestStep jumpPit;
    QuestStep openWestDoor;
    QuestStep solveDoorPuzzle;
    QuestStep talkToSphinx;
    QuestStep talkToHighPriest;
    QuestStep talkToHighPriestWithoutToken;
    QuestStep openPyramidDoor;
    QuestStep jumpPitAgain;
    QuestStep pickUpScarabasJar;
    QuestStep pickUpCrondisJar;
    QuestStep pickUpHetJar;
    QuestStep pickUpApmekenJar;
    QuestStep pickUpScarabasJarAgain;
    QuestStep pickUpCrondisJarAgain;
    QuestStep pickUpHetJarAgain;
    QuestStep pickUpApmekenJarAgain;
    QuestStep returnOverPit;
    QuestStep jumpOverPitAgain;
    QuestStep dropJar;
    QuestStep dropCrondisJar;
    QuestStep dropScarabasJar;
    QuestStep dropHetJar;
    QuestStep dropApmekenJar;
    QuestStep solvePuzzleAgain;
    QuestStep leavePyramid;
    QuestStep returnToHighPriest;
    QuestStep talkToEmbalmer;
    QuestStep talkToEmbalmerAgain;
    QuestStep talkToCarpenter;
    QuestStep talkToCarpenterAgain;
    QuestStep talkToCarpenterOnceMore;
    QuestStep buyLinen;
    QuestStep enterRockWithItems;
    QuestStep openPyramidDoorWithSymbol;
    QuestStep jumpPitWithSymbol;
    QuestStep enterEastRoom;
    QuestStep useSymbolOnSarcopagus;
    QuestStep leaveEastRoom;
    QuestStep jumpPitWithSymbolAgain;
    QuestStep enterEastRoomAgain;
    QuestStep killPriest;
    QuestStep talkToHighPriestInPyramid;
    QuestStep enterPyramidAtEnd;
    QuestStep leavePyramidToFinish;
    QuestStep talkToHighPriestToFinish;
    QuestStep fillBucketWithWater;
    QuestStep makeSalt;
    ObjectStep pickUpAnyJar;
    ObjectStep pickUpAnyJarAgain;
    Zone soph;
    Zone pyramid;
    Zone northPyramid;
    Zone northPyramid2;
    Zone eastRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupConditions();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToWanderer);
        steps.put(1, this.talkToWandererAgain);
        steps.put(2, this.enterRock);
        ConditionalStep firstMemory = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        firstMemory.addStep(this.puzzleOpen, this.solveDoorPuzzle);
        firstMemory.addStep(this.inNorthPyramid, this.openWestDoor);
        firstMemory.addStep(this.inPyramid, this.jumpPit);
        firstMemory.addStep(this.inSoph, this.touchPyramidDoor);
        steps.put(3, firstMemory);
        steps.put(4, firstMemory);
        ConditionalStep talkToSphinxSteps = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        talkToSphinxSteps.addStep(this.inSoph, this.talkToSphinx);
        steps.put(5, talkToSphinxSteps);
        ConditionalStep talkToHighPriestSteps = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        talkToHighPriestSteps.addStep(new Conditions(this.inSoph, this.givenToken), this.talkToHighPriestWithoutToken);
        talkToHighPriestSteps.addStep(this.inSoph, this.talkToHighPriest);
        steps.put(6, talkToHighPriestSteps);
        ConditionalStep takeTheJar = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.jar), this.returnOverPit);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasHetJar, this.killedGuardian), this.pickUpHetJarAgain);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasCrondisJar, this.killedGuardian), this.pickUpCrondisJarAgain);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.killedGuardian), this.pickUpAnyJarAgain);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasHetJar), this.pickUpHetJar);
        takeTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasCrondisJar), this.pickUpCrondisJar);
        takeTheJar.addStep(this.inNorthPyramid, this.pickUpAnyJar);
        takeTheJar.addStep(this.inPyramid, this.jumpPitAgain);
        takeTheJar.addStep(this.inSoph, this.openPyramidDoor);
        steps.put(7, takeTheJar);
        steps.put(8, takeTheJar);
        steps.put(9, takeTheJar);
        steps.put(10, takeTheJar);
        steps.put(11, takeTheJar);
        ConditionalStep returnTheJar = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        returnTheJar.addStep(this.puzzleOpen, this.solvePuzzleAgain);
        returnTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasHetJar), this.dropHetJar);
        returnTheJar.addStep(new Conditions(this.inNorthPyramid, this.hasCrondisJar), this.dropCrondisJar);
        returnTheJar.addStep(this.inNorthPyramid, this.dropJar);
        returnTheJar.addStep(this.inPyramid, this.jumpOverPitAgain);
        returnTheJar.addStep(this.inSoph, this.openPyramidDoor);
        steps.put(12, returnTheJar);
        steps.put(13, returnTheJar);
        ConditionalStep afterPlacingJarSteps = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        afterPlacingJarSteps.addStep(this.inSoph, this.returnToHighPriest);
        afterPlacingJarSteps.addStep(this.inPyramid, this.leavePyramid);
        steps.put(14, afterPlacingJarSteps);
        ConditionalStep prepareItems = new ConditionalStep((QuestHelper)this, this.enterRockWithItems, new Requirement[0]);
        prepareItems.addStep(new Conditions(this.inSoph, this.givenEmbalmerAllItems, this.givenCarpenterLogs), this.talkToCarpenterOnceMore);
        prepareItems.addStep(new Conditions(this.inSoph, this.givenEmbalmerAllItems, this.talkedToCarpenter), this.talkToCarpenterAgain);
        prepareItems.addStep(new Conditions(this.inSoph, this.givenEmbalmerAllItems), this.talkToCarpenter);
        Conditions givenOrHaveLinen = new Conditions(LogicType.OR, this.linen, this.givenLinen);
        Conditions givenOrHaveSalt = new Conditions(LogicType.OR, this.salt, this.givenSalt);
        prepareItems.addStep(new Conditions(this.inSoph, this.talkedToEmbalmer, givenOrHaveLinen, givenOrHaveSalt), this.talkToEmbalmerAgain);
        prepareItems.addStep(new Conditions(this.inSoph, this.talkedToEmbalmer, givenOrHaveLinen, this.bucketOfSaltwater), this.makeSalt);
        prepareItems.addStep(new Conditions(this.inSoph, this.talkedToEmbalmer, givenOrHaveLinen), this.fillBucketWithWater);
        prepareItems.addStep(new Conditions(this.inSoph, this.talkedToEmbalmer), this.buyLinen);
        prepareItems.addStep(new Conditions(this.inSoph), this.talkToEmbalmer);
        steps.put(15, prepareItems);
        ConditionalStep goToRitual = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        goToRitual.addStep(new Conditions(this.inEastRoom, this.possessedPriestNearby), this.killPriest);
        goToRitual.addStep(this.inEastRoom, this.talkToHighPriestInPyramid);
        goToRitual.addStep(this.inNorthPyramid, this.enterEastRoomAgain);
        goToRitual.addStep(this.inPyramid, this.jumpPitWithSymbol);
        goToRitual.addStep(this.inSoph, this.openPyramidDoorWithSymbol);
        steps.put(16, goToRitual);
        ConditionalStep placeSymbol = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        placeSymbol.addStep(this.inEastRoom, this.useSymbolOnSarcopagus);
        placeSymbol.addStep(this.inPyramid, this.enterEastRoom);
        placeSymbol.addStep(this.inSoph, this.openPyramidDoorWithSymbol);
        steps.put(17, placeSymbol);
        steps.put(18, this.leaveEastRoom);
        steps.put(19, goToRitual);
        steps.put(20, goToRitual);
        steps.put(21, goToRitual);
        steps.put(22, goToRitual);
        steps.put(23, goToRitual);
        ConditionalStep meetIcthlarin = new ConditionalStep((QuestHelper)this, this.enterPyramidAtEnd, new Requirement[0]);
        meetIcthlarin.addStep(this.inPyramid, this.leavePyramidToFinish);
        steps.put(24, meetIcthlarin);
        ConditionalStep finishTheQuest = new ConditionalStep((QuestHelper)this, this.enterRock, new Requirement[0]);
        finishTheQuest.addStep(this.inPyramid, this.leavePyramidToFinish);
        finishTheQuest.addStep(this.inSoph, this.talkToHighPriestToFinish);
        steps.put(25, finishTheQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cat = new FollowerItemRequirement("A cat", ItemCollections.CATS, NpcCollections.getCats()).isNotConsumed();
        this.catFollower = new FollowerRequirement("Any cat following you", NpcCollections.getCats());
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.waterskin4 = new ItemRequirement("Waterskin(4), bring a few to avoid drinking it", 1823);
        this.coins600 = new ItemRequirement("Coins or more for various payments", ItemCollections.COINS, 600);
        this.bagOfSaltOrBucket = new ItemRequirement("Bag of Salt from a Slayer Master, or an empty bucket to get some", 4161).hideConditioned(this.givenSalt);
        this.bagOfSaltOrBucket.addAlternates(4689, 1925);
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.salt = new ItemRequirement("Salt", 4161).hideConditioned(this.givenSalt);
        this.salt.addAlternates(4689);
        this.coins30 = new ItemRequirement("Coins", ItemCollections.COINS, 30).hideConditioned(this.givenLinen);
        this.linen = new ItemRequirement("Linen", 4684).hideConditioned(this.givenLinen);
        this.coinsOrLinen = new ItemRequirements(LogicType.OR, "1 x Linen or 30 coins to buy some", this.coins30, this.linen).hideConditioned(this.givenLinen);
        this.willowLog = new ItemRequirement("Willow logs", 1519).hideConditioned(this.givenCarpenterLogs);
        this.bucketOfSap = new ItemRequirement("Bucket of sap", 4687).hideConditioned(this.givenSap);
        this.bucketOfSap.setTooltip("You can get this by using a knife on an evergreen tree with a bucket in your inventory");
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS, -1);
        this.combatGear = new ItemRequirement("Combat equipment", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.sphinxsToken = new ItemRequirement("Sphinx's token", 4691);
        this.sphinxsToken.setTooltip("You can get another from the Sphinx");
        this.jar = new ItemRequirement("Canopic jar", 4678);
        this.jar.addAlternates(4679, 4680, 4681);
        this.jar.setHighlightInInventory(true);
        this.bucketOfSaltwater = new ItemRequirement("Bucket of saltwater", 4693);
        this.holySymbol = new ItemRequirement("Holy symbol", 4682);
        this.holySymbol.setTooltip("You can get another from the Carpenter in Sophanem");
        this.unholySymbol = new ItemRequirement("Unholy symbol", 4683);
        this.unholySymbol.setHighlightInInventory(true);
    }

    public void setupConditions() {
        this.inSoph = new ZoneRequirement(this.soph);
        this.inPyramid = new ZoneRequirement(this.pyramid);
        this.inNorthPyramid = new ZoneRequirement(this.northPyramid, this.northPyramid2, this.eastRoom);
        this.inEastRoom = new ZoneRequirement(this.eastRoom);
        this.puzzleOpen = new WidgetModelRequirement(147, 3, 6474);
        this.givenToken = new VarbitRequirement(450, 1);
        this.hasHetJar = new VarbitRequirement(397, 1);
        this.hasCrondisJar = new VarbitRequirement(397, 4);
        this.hasApmekenJar = new VarbitRequirement(397, 3);
        this.hasScarabasJar = new VarbitRequirement(397, 2);
        this.killedGuardian = new VarbitRequirement(418, 11, Operation.GREATER_EQUAL);
        this.talkedToEmbalmer = new VarbitRequirement(399, 1);
        this.givenSalt = new VarbitRequirement(401, 1);
        this.givenSap = new VarbitRequirement(402, 1);
        this.givenLinen = new VarbitRequirement(403, 1);
        this.givenEmbalmerAllItems = new VarbitRequirement(400, 7);
        this.talkedToCarpenter = new VarbitRequirement(412, 1);
        this.givenCarpenterLogs = new VarbitRequirement(398, 1);
        this.possessedPriestNearby = new NpcCondition(4210);
    }

    public void loadZones() {
        this.soph = new Zone(new WorldPoint(3262, 2751, 0), new WorldPoint(3322, 2809, 0));
        this.pyramid = new Zone(new WorldPoint(3273, 9170, 0), new WorldPoint(3311, 9204, 0));
        this.northPyramid = new Zone(new WorldPoint(3276, 9194, 0), new WorldPoint(3311, 9204, 0));
        this.northPyramid2 = new Zone(new WorldPoint(3276, 9192, 0), new WorldPoint(3287, 9193, 0));
        this.eastRoom = new Zone(new WorldPoint(3300, 9192, 0), new WorldPoint(3311, 9199, 0));
    }

    public void setupSteps() {
        this.talkToWanderer = new NpcStep((QuestHelper)this, 4194, new WorldPoint(3316, 2849, 0), "Talk to the Wanderer west of the Agility Pyramid.", this.catFollower, this.waterskin4, this.tinderbox);
        this.talkToWanderer.addDialogStep("Yes.");
        this.talkToWanderer.addDialogStep("Why? What's your problem with it?");
        this.talkToWanderer.addDialogStep("Ok I'll get your supplies.");
        this.talkToWandererAgain = new NpcStep((QuestHelper)this, 4194, new WorldPoint(3316, 2849, 0), "Talk to the Wanderer again with the required items.", this.waterskin4, this.tinderbox);
        this.talkToWandererAgain.addDialogStep("Yes. I have them all here.");
        this.enterRock = new ObjectStep((QuestHelper)this, 6621, new WorldPoint(3324, 2858, 0), "Enter the rock west of the Agility Pyramid to re-enter Sophanem.", new Requirement[0]);
        this.touchPyramidDoor = new ObjectStep((QuestHelper)this, 6614, new WorldPoint(3295, 2779, 0), "Enter the pyramid in the south of Sophanem.", new Requirement[0]);
        this.jumpPit = new ObjectStep((QuestHelper)this, 6632, new WorldPoint(3292, 9194, 0), "Follow the path until you reach a pit, and jump it. Move using the minimap to avoid all the traps.", new Requirement[0]);
        this.openWestDoor = new ObjectStep((QuestHelper)this, 44059, new WorldPoint(3280, 9199, 0), "Attempt to open the western door.", new Requirement[0]);
        this.solveDoorPuzzle = new DoorPuzzleStep(this);
        this.talkToSphinx = new NpcStep((QuestHelper)this, 4209, new WorldPoint(3301, 2785, 0), "Talk to the Sphinx in Sophanem with your cat, and answer its riddle with '9.'.", this.catFollower);
        this.talkToSphinx.addDialogStep("I need help.");
        this.talkToSphinx.addDialogStep("Okay, that sounds fair.");
        this.talkToSphinx.addDialogStep("9.");
        this.talkToSphinx.addDialogStep("Totally positive.");
        this.talkToHighPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Talk to the High Priest in the south west of Sophanem.", this.sphinxsToken);
        this.talkToHighPriestWithoutToken = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Talk to the High Priest in the south west of Sophanem.", new Requirement[0]);
        this.talkToHighPriest.addSubSteps(this.talkToHighPriestWithoutToken);
        this.openPyramidDoor = new ObjectStep((QuestHelper)this, 6614, new WorldPoint(3295, 2779, 0), "Enter the pyramid in the south of Sophanem.", this.catFollower);
        this.jumpPitAgain = new ObjectStep((QuestHelper)this, 6632, new WorldPoint(3292, 9194, 0), "Follow the path again until you reach a pit, and jump it. Move using the minimap to avoid all the traps.", new Requirement[0]);
        this.pickUpCrondisJar = new ObjectStep((QuestHelper)this, 6636, new WorldPoint(3286, 9195, 0), "Attempt to pick up the Crondis Canopic Jar, and kill Apparition (level 75) when they appear. They will attack with magic.", new Requirement[0]);
        this.pickUpScarabasJar = new ObjectStep((QuestHelper)this, 6638, new WorldPoint(3286, 9196, 0), "Attempt to pick up the Scarabas Canopic Jar, and kill Apparition (level 75) when they appear. They will attack with melee.", new Requirement[0]);
        this.pickUpApmekenJar = new ObjectStep((QuestHelper)this, 6640, new WorldPoint(3286, 9193, 0), "Attempt to pick up the Apmeken Canopic Jar, and kill Apparition (level 75) when they appear. They will attack with magic.", new Requirement[0]);
        this.pickUpHetJar = new ObjectStep((QuestHelper)this, 6634, new WorldPoint(3286, 9194, 0), "Attempt to pick up the Het Canopic Jar, and kill Apparition (level 81) when they appear. They will attack with melee.", new Requirement[0]);
        this.pickUpAnyJar = new ObjectStep((QuestHelper)this, 6634, "Try picking up the canopic jars in the north west room until a level 75-81 enemy spawns. Kill them. You can safespot them on the central table.", new Requirement[0]);
        this.pickUpAnyJar.addAlternateObjects(6636, 6638, 6640);
        this.pickUpAnyJar.addSubSteps(this.pickUpCrondisJar, this.pickUpScarabasJar, this.pickUpApmekenJar, this.pickUpHetJar);
        this.pickUpCrondisJarAgain = new ObjectStep((QuestHelper)this, 6636, new WorldPoint(3286, 9195, 0), "Pick up the Crondis Canopic Jar.", new Requirement[0]);
        this.pickUpScarabasJarAgain = new ObjectStep((QuestHelper)this, 6638, new WorldPoint(3286, 9196, 0), "Pick up the Scarabas Canopic Jar.", new Requirement[0]);
        this.pickUpApmekenJarAgain = new ObjectStep((QuestHelper)this, 6640, new WorldPoint(3286, 9193, 0), "Pick up the Apmeken Canopic Jar.", new Requirement[0]);
        this.pickUpHetJarAgain = new ObjectStep((QuestHelper)this, 6634, new WorldPoint(3286, 9194, 0), "Pick up the Het Canopic Jar.", new Requirement[0]);
        this.pickUpAnyJarAgain = new ObjectStep((QuestHelper)this, 6634, "Try picking up the canopic jars in the north west room again.", new Requirement[0]);
        this.pickUpAnyJarAgain.addAlternateObjects(6636, 6638, 6640);
        this.pickUpAnyJarAgain.addSubSteps(this.pickUpCrondisJarAgain, this.pickUpScarabasJarAgain, this.pickUpApmekenJarAgain, this.pickUpHetJarAgain);
        this.returnOverPit = new ObjectStep((QuestHelper)this, 6633, new WorldPoint(3292, 9196, 0), "Jump back over the pit with the jar.", new Requirement[0]);
        this.jumpOverPitAgain = new ObjectStep((QuestHelper)this, 6632, new WorldPoint(3292, 9194, 0), "Jump back over to the north side of the pit. Move using the minimap to avoid all the traps inside the pyramid.", new Requirement[0]);
        this.dropCrondisJar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3286, 9195, 0), "Drop the canopic jar in the spot you took it from.", this.jar);
        this.dropApmekenJar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3286, 9193, 0), "Drop the canopic jar in the spot you took it from.", this.jar);
        this.dropHetJar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3286, 9194, 0), "Drop the canopic jar in the spot you took it from.", this.jar);
        this.dropScarabasJar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3286, 9196, 0), "Drop the canopic jar in the spot you took it from.", this.jar);
        this.dropJar = new DetailedQuestStep((QuestHelper)this, "Drop the canopic jar in the spot you took it from.", this.jar);
        this.dropJar.addSubSteps(this.dropCrondisJar, this.dropApmekenJar, this.dropHetJar, this.dropScarabasJar);
        this.solvePuzzleAgain = new DoorPuzzleStep(this);
        this.leavePyramid = new ObjectStep((QuestHelper)this, 6645, new WorldPoint(3277, 9172, 0), "Leave the pyramid and return to the High Priest.", new Requirement[0]);
        this.returnToHighPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Return to the High Priest in the south west of Sophanem.", new Requirement[0]);
        this.returnToHighPriest.addDialogStep("Sure, no problem.");
        this.leavePyramid.addSubSteps(this.returnToHighPriest);
        this.talkToEmbalmer = new NpcStep((QuestHelper)this, 4202, new WorldPoint(3287, 2755, 0), "Talk to the Embalmer just south of the High Priest.", this.bagOfSaltOrBucket, this.bucketOfSap);
        this.talkToEmbalmerAgain = new NpcStep((QuestHelper)this, 4202, new WorldPoint(3287, 2755, 0), "Talk to the Embalmer again just south of the High Priest.", this.bagOfSaltOrBucket, this.linen, this.bucketOfSap);
        this.fillBucketWithWater = new ObjectStep((QuestHelper)this, 6605, new WorldPoint(3286, 2840, 0), "Fill up a bucket with salt water from the lake north of Sophanem, or buy a bag of salt from a Slayer Master.", this.bucket);
        this.makeSalt = new ObjectStep((QuestHelper)this, 6606, new WorldPoint(3305, 2756, 0), "Use the bucket of saltwater on the suntrap in the south east of Sophenam.", this.bucketOfSaltwater.highlighted());
        this.makeSalt.addIcon(4693);
        this.talkToCarpenter = new NpcStep((QuestHelper)this, 4203, new WorldPoint(3313, 2770, 0), "Talk to the Carpenter in the east of Sophanem until he gives you the holy symbol.", this.willowLog);
        this.talkToCarpenter.addDialogStep("Alright, I'll get the wood for you.");
        this.talkToCarpenterAgain = new NpcStep((QuestHelper)this, 4203, new WorldPoint(3313, 2770, 0), "Talk to the Carpenter again in the east of Sophanem.", new Requirement[0]);
        this.talkToCarpenterOnceMore = new NpcStep((QuestHelper)this, 4203, new WorldPoint(3313, 2770, 0), "Talk to the Carpenter again in the east of Sophanem once more.", new Requirement[0]);
        this.talkToCarpenter.addSubSteps(this.talkToCarpenterAgain, this.talkToCarpenterOnceMore);
        this.buyLinen = new NpcStep((QuestHelper)this, 11598, new WorldPoint(3311, 2787, 0), "Get some linen. You can buy some from Raetul in east Sophanem for 30 coins.", this.coins30);
        this.enterRockWithItems = new ObjectStep((QuestHelper)this, 6621, new WorldPoint(3324, 2858, 0), "Enter the rock west of the Agility Pyramid to re-enter Sophanem. Make sure to bring the items you need.", this.bucketOfSap, this.bagOfSaltOrBucket, this.coinsOrLinen, this.willowLog, this.catFollower);
        this.openPyramidDoorWithSymbol = new ObjectStep((QuestHelper)this, 6614, new WorldPoint(3295, 2779, 0), "Enter the pyramid in the south of Sophanem.", this.catFollower, this.holySymbol);
        this.jumpPitWithSymbol = new ObjectStep((QuestHelper)this, 6632, new WorldPoint(3292, 9194, 0), "Follow the path again until you reach a pit, and jump it. Move using the minimap to avoid all the traps.", this.holySymbol);
        this.enterEastRoom = new ObjectStep((QuestHelper)this, 44060, new WorldPoint(3306, 9199, 0), "Enter the east room.", new Requirement[0]);
        this.useSymbolOnSarcopagus = new ObjectStep((QuestHelper)this, 6505, new WorldPoint(3312, 9197, 0), "Use the unholy symbol on a sarcophagus.", this.unholySymbol);
        this.useSymbolOnSarcopagus.addIcon(4683);
        this.leaveEastRoom = new ObjectStep((QuestHelper)this, 44060, new WorldPoint(3306, 9199, 0), "Leave the east room.", new Requirement[0]);
        this.jumpPitWithSymbolAgain = new ObjectStep((QuestHelper)this, 6632, new WorldPoint(3292, 9194, 0), "Jump over the pit.", this.holySymbol);
        this.enterEastRoomAgain = new ObjectStep((QuestHelper)this, 44060, new WorldPoint(3306, 9199, 0), "Enter the east room again.", new Requirement[0]);
        this.killPriest = new NpcStep((QuestHelper)this, 4210, new WorldPoint(3306, 9196, 0), "Kill the possessed priest. Pray protect from magic against the priest.", new Requirement[0]);
        this.talkToHighPriestInPyramid = new NpcStep((QuestHelper)this, 11603, new WorldPoint(3306, 9196, 0), "Talk to the High Priest in the north east room of the pyramid.", new Requirement[0]);
        this.enterPyramidAtEnd = new ObjectStep((QuestHelper)this, 6614, new WorldPoint(3295, 2779, 0), "Open the door of the pyramid in the south of Sophanem to watch a cutscene.", new Requirement[0]);
        this.leavePyramidToFinish = new ObjectStep((QuestHelper)this, 6645, new WorldPoint(3277, 9172, 0), "Leave the pyramid and witness a cutscene at the exit.", new Requirement[0]);
        this.talkToHighPriestToFinish = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Return to the High Priest in the south west of Sophanem to finish the quest.", new Requirement[0]);
        this.leavePyramidToFinish.addSubSteps(this.enterPyramidAtEnd);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.cat, this.tinderbox, this.coins600, this.bagOfSaltOrBucket, this.willowLog, this.bucketOfSap, this.waterskin4, this.coinsOrLinen);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Level 75 or 81 guardian", "Possessed priest (level 91)");
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.prayerPotions, this.antipoison);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestRequirement(QuestHelperQuest.GERTRUDES_CAT, QuestState.FINISHED));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.THIEVING, 4500), new ExperienceReward(Skill.AGILITY, 4000), new ExperienceReward(Skill.WOODCUTTING, 4000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Catspeak Amulet", 4677, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the city of Sophanem."), new UnlockReward("Ability to take carpet rides from Pollnivneah to Sophanem and Menaphos."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToWanderer, this.talkToWandererAgain), this.cat, this.waterskin4, this.tinderbox, this.coins600, this.bagOfSaltOrBucket, this.willowLog, this.bucketOfSap));
        allSteps.add(new PanelDetails("Remembering", Arrays.asList(this.touchPyramidDoor, this.jumpPit, this.openWestDoor), new Requirement[0]));
        allSteps.add(new PanelDetails("Returning the jar", Arrays.asList(this.talkToSphinx, this.talkToHighPriest, this.openPyramidDoor, this.jumpPitAgain, this.pickUpAnyJar, this.pickUpAnyJarAgain, this.returnOverPit, this.jumpOverPitAgain, this.solvePuzzleAgain, this.dropJar, this.leavePyramid), this.combatGear, this.food, this.cat));
        allSteps.add(new PanelDetails("Prepare the ritual", Arrays.asList(this.talkToEmbalmer, this.buyLinen, this.talkToEmbalmerAgain, this.talkToCarpenter), this.bucketOfSap, this.bagOfSaltOrBucket, this.coinsOrLinen, this.willowLog));
        allSteps.add(new PanelDetails("Save the ritual", Arrays.asList(this.openPyramidDoorWithSymbol, this.jumpPitWithSymbol, this.enterEastRoom, this.useSymbolOnSarcopagus, this.leaveEastRoom, this.jumpPitWithSymbolAgain, this.enterEastRoomAgain, this.killPriest, this.talkToHighPriestInPyramid, this.leavePyramidToFinish, this.talkToHighPriestToFinish), this.combatGear, this.food, this.cat));
        return allSteps;
    }
}

