/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.icthlarinslittlehelper;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.helpers.quests.icthlarinslittlehelper.RowSolution;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class DoorPuzzleStep
extends QuestStep {
    int[] currentState = new int[20];
    int[] lastState = new int[20];
    int[] clickSquares = new int[20];
    RowSolution[] solutions = new RowSolution[]{new RowSolution(new int[]{0, 0, 1, 0, 0}, new int[]{1, 0, 0, 0, 1}), new RowSolution(new int[]{1, 0, 0, 0, 1}, new int[]{0, 0, 1, 0, 0}), new RowSolution(new int[]{0, 1, 1, 1, 0}, new int[]{1, 0, 1, 1, 0}), new RowSolution(new int[]{1, 1, 0, 1, 1}, new int[]{0, 0, 0, 1, 1}), new RowSolution(new int[]{0, 1, 0, 1, 0}, new int[]{1, 0, 1, 0, 1}), new RowSolution(new int[]{1, 1, 0, 0, 0}, new int[]{0, 0, 0, 1, 0}), new RowSolution(new int[]{0, 0, 0, 1, 1}, new int[]{0, 1, 0, 0, 0}), new RowSolution(new int[]{1, 1, 1, 0, 0}, new int[]{0, 0, 0, 0, 1}), new RowSolution(new int[]{0, 0, 1, 1, 1}, new int[]{1, 0, 0, 0, 0}), new RowSolution(new int[]{0, 1, 1, 0, 1}, new int[]{0, 1, 1, 0, 0}), new RowSolution(new int[]{1, 0, 1, 1, 0}, new int[]{0, 0, 1, 1, 0}), new RowSolution(new int[]{1, 0, 0, 1, 0}, new int[]{0, 0, 1, 0, 1}), new RowSolution(new int[]{0, 1, 0, 0, 1}, new int[]{1, 0, 1, 0, 0}), new RowSolution(new int[]{1, 0, 1, 1, 0}, new int[]{0, 0, 1, 1, 0}), new RowSolution(new int[]{0, 1, 1, 0, 1}, new int[]{0, 1, 1, 0, 0}), new RowSolution(new int[]{0, 0, 0, 0, 0}, new int[]{0, 1, 0, 0, 1}), new RowSolution(new int[]{1, 1, 1, 1, 1}, new int[]{0, 0, 0, 0, 0})};

    public DoorPuzzleStep(QuestHelper questHelper) {
        super(questHelper, "Click the highlighted boxes to turn the squares to solve the puzzle.");
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        int START_VARBIT_ID = 420;
        for (int i = 0; i < 20; ++i) {
            this.currentState[i] = (1 + this.client.getVarbitValue(START_VARBIT_ID + i)) % 2;
        }
        if (Arrays.equals(this.currentState, this.lastState)) {
            return;
        }
        this.lastState = (int[])this.currentState.clone();
        block1: for (int y = 0; y < 4; ++y) {
            int[] row = new int[5];
            System.arraycopy(this.currentState, y * 5, row, 0, 5);
            for (RowSolution solution : this.solutions) {
                int[] result = solution.checkMatch(row);
                if (result == null) continue;
                System.arraycopy(result, 0, this.clickSquares, y * 5, 5);
                this.updateCurrentState(result, y + 1);
                continue block1;
            }
        }
    }

    public void updateCurrentState(int[] result, int clickY) {
        for (int cell = 0; cell < result.length; ++cell) {
            if (result[cell] != 1) continue;
            if (clickY <= 3) {
                this.currentState[clickY * 5 + cell] = (this.currentState[clickY * 5 + cell] + 1) % 2;
            }
            if (clickY < 3) {
                this.currentState[(clickY + 1) * 5 + cell] = (this.currentState[(clickY + 1) * 5 + cell] + 1) % 2;
            }
            if (cell != 4) {
                if (clickY <= 3) {
                    this.currentState[clickY * 5 + cell + 1] = (this.currentState[clickY * 5 + cell + 1] + 1) % 2;
                }
                if (clickY < 3) {
                    this.currentState[(clickY + 1) * 5 + cell + 1] = (this.currentState[(clickY + 1) * 5 + cell + 1] + 1) % 2;
                }
            }
            if (cell == 0) continue;
            if (clickY <= 3) {
                this.currentState[clickY * 5 + cell - 1] = (this.currentState[clickY * 5 + cell - 1] + 1) % 2;
            }
            if (clickY >= 3) continue;
            this.currentState[(clickY + 1) * 5 + cell - 1] = (this.currentState[(clickY + 1) * 5 + cell - 1] + 1) % 2;
        }
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget widgetWrapper = this.client.getWidget(147, 0);
        if (widgetWrapper != null) {
            for (int i = 0; i < 20; ++i) {
                int START_WIDGET_ID;
                Widget widget;
                if (this.clickSquares[i] != 1 || (widget = this.client.getWidget(147, (START_WIDGET_ID = 9) + i)) == null) continue;
                graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                graphics.fill(widget.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget.getBounds());
            }
        }
    }
}

