/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.horrorfromthedeep;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HORROR_FROM_THE_DEEP)
public class HorrorFromTheDeep
extends BasicQuestHelper {
    ItemRequirement fireRune;
    ItemRequirement airRune;
    ItemRequirement waterRune;
    ItemRequirement earthRune;
    ItemRequirement sword;
    ItemRequirement arrow;
    ItemRequirement moltenGlass;
    ItemRequirement tinderbox;
    ItemRequirement hammer;
    ItemRequirement steelNails;
    ItemRequirement plank2;
    ItemRequirement plank;
    ItemRequirement swampTar1;
    ItemRequirement combatRunes;
    ItemRequirement magicCombat;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement gamesNecklace;
    Requirement protectFromMissiles;
    ItemRequirement lighthouseKey;
    Zone lighthouseF0;
    Zone lighthouseF1;
    Zone lighthouseF2;
    Zone lighthouseF2V2;
    Zone basement;
    Zone dagCave;
    Requirement inLighthouseF0;
    Requirement inLighthouseF1;
    Requirement inLighthouseF2;
    Requirement inBasement;
    Requirement inDagCave;
    Requirement repairedBridge1;
    Requirement repairedBridge2;
    Requirement gotKey;
    Requirement usedTar;
    Requirement usedTinderbox;
    Requirement usedGlass;
    Requirement notUsedAirRune;
    Requirement notUsedWaterRune;
    Requirement notUsedEarthRune;
    Requirement notUsedFireRune;
    Requirement notUsedArrow;
    Requirement notUsedSword;
    Requirement doorUnlocked;
    Requirement dagannothNearby;
    Requirement motherNearby;
    QuestStep talkToLarrissa;
    QuestStep usePlankOnBridge;
    QuestStep useSecondPlank;
    QuestStep talkToGunnjorn;
    QuestStep openLighthouse;
    QuestStep enterLighthouse;
    QuestStep goToF1;
    QuestStep goToF2;
    QuestStep useTar;
    QuestStep useTinderbox;
    QuestStep useGlass;
    QuestStep goDownToF2;
    QuestStep goDownToF1;
    QuestStep goDownToF0;
    QuestStep goDownToBasement;
    QuestStep useAirRune;
    QuestStep useWaterRune;
    QuestStep useEarthRune;
    QuestStep useFireRune;
    QuestStep useSword;
    QuestStep useArrow;
    QuestStep goThroughDoor;
    QuestStep talkToJossik;
    QuestStep killDagannoth;
    QuestStep killMother;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToLarrissa);
        ConditionalStep repairBridgeAndGetKey = new ConditionalStep((QuestHelper)this, this.usePlankOnBridge, new Requirement[0]);
        repairBridgeAndGetKey.addStep(new Conditions(this.repairedBridge1, this.repairedBridge2, this.gotKey), this.openLighthouse);
        repairBridgeAndGetKey.addStep(new Conditions(this.repairedBridge1, this.repairedBridge2), this.talkToGunnjorn);
        repairBridgeAndGetKey.addStep(this.repairedBridge1, this.useSecondPlank);
        steps.put(1, repairBridgeAndGetKey);
        ConditionalStep repairLightingMechanism = new ConditionalStep((QuestHelper)this, this.enterLighthouse, new Requirement[0]);
        repairLightingMechanism.addStep(new Conditions(this.inLighthouseF2, this.usedTar, this.usedTinderbox), this.useGlass);
        repairLightingMechanism.addStep(new Conditions(this.inLighthouseF2, this.usedTar), this.useTinderbox);
        repairLightingMechanism.addStep(this.inLighthouseF2, this.useTar);
        repairLightingMechanism.addStep(this.inLighthouseF1, this.goToF2);
        repairLightingMechanism.addStep(this.inLighthouseF0, this.goToF1);
        steps.put(2, repairLightingMechanism);
        steps.put(3, repairLightingMechanism);
        ConditionalStep goOpenStrangeDoor = new ConditionalStep((QuestHelper)this, this.enterLighthouse, new Requirement[0]);
        goOpenStrangeDoor.addStep(this.dagannothNearby, this.killDagannoth);
        goOpenStrangeDoor.addStep(new Conditions(this.inDagCave), this.talkToJossik);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.doorUnlocked), this.goThroughDoor);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedAirRune), this.useAirRune);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedWaterRune), this.useWaterRune);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedEarthRune), this.useEarthRune);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedFireRune), this.useFireRune);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedArrow), this.useArrow);
        goOpenStrangeDoor.addStep(new Conditions(this.inBasement, this.notUsedSword), this.useSword);
        goOpenStrangeDoor.addStep(this.inLighthouseF0, this.goDownToBasement);
        goOpenStrangeDoor.addStep(this.inLighthouseF1, this.goDownToF0);
        goOpenStrangeDoor.addStep(this.inLighthouseF2, this.goDownToF1);
        goOpenStrangeDoor.addDialogStep("Yes");
        steps.put(4, goOpenStrangeDoor);
        ConditionalStep goDefeatMother = new ConditionalStep((QuestHelper)this, this.enterLighthouse, new Requirement[0]);
        goDefeatMother.addStep(this.motherNearby, this.killMother);
        goDefeatMother.addStep(this.inDagCave, this.talkToJossik);
        goDefeatMother.addStep(this.inBasement, this.goThroughDoor);
        goDefeatMother.addStep(this.inLighthouseF0, this.goDownToBasement);
        steps.put(5, goDefeatMother);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.fireRune = new ItemRequirement("Fire rune", 554);
        this.airRune = new ItemRequirement("Air rune", 556);
        this.waterRune = new ItemRequirement("Water rune", 555);
        this.earthRune = new ItemRequirement("Earth rune", 557);
        this.sword = new ItemRequirement("Any sword you're willing to lose", ItemCollections.SWORDS);
        this.arrow = new ItemRequirement("Any arrow", ItemCollections.METAL_ARROWS);
        this.moltenGlass = new ItemRequirement("Molten glass", 1775);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.steelNails = new ItemRequirement("Steel nails", 1539);
        this.plank2 = new ItemRequirement("Plank", 960, 2);
        this.plank = new ItemRequirement("Plank", 960);
        this.swampTar1 = new ItemRequirement("Swamp tar", 1939);
        this.magicCombat = new ItemRequirement("Magic combat gear", -1, -1).isNotConsumed();
        this.magicCombat.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.combatRunes = new ItemRequirement("20+ casts of each element spell", -1, -1);
        this.combatRunes.setDisplayItemId(560);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.protectFromMissiles = new PrayerRequirement("Protect from Missiles", Prayer.PROTECT_FROM_MISSILES);
        this.lighthouseKey = new ItemRequirement("Lighthouse key", 3848);
        this.lighthouseKey.setTooltip("You can get another from Gunnjorn in the Barbarian Agility Course");
    }

    public void setupZones() {
        this.lighthouseF0 = new Zone(new WorldPoint(2440, 4596, 0), new WorldPoint(2449, 4605, 0));
        this.lighthouseF1 = new Zone(new WorldPoint(2440, 4596, 1), new WorldPoint(2449, 4605, 1));
        this.lighthouseF2 = new Zone(new WorldPoint(2440, 4596, 2), new WorldPoint(2449, 4605, 2));
        this.lighthouseF2V2 = new Zone(new WorldPoint(2504, 3636, 2), new WorldPoint(2513, 3645, 2));
        this.basement = new Zone(new WorldPoint(2506, 4610, 0), new WorldPoint(2522, 4626, 0));
        this.dagCave = new Zone(new WorldPoint(2506, 4627, 0), new WorldPoint(2539, 4670, 0));
    }

    public void setupConditions() {
        this.inLighthouseF0 = new ZoneRequirement(this.lighthouseF0);
        this.inLighthouseF1 = new ZoneRequirement(this.lighthouseF1);
        this.inLighthouseF2 = new ZoneRequirement(this.lighthouseF2, this.lighthouseF2V2);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inDagCave = new ZoneRequirement(this.dagCave);
        this.repairedBridge1 = new VarbitRequirement(36, 1);
        this.repairedBridge2 = new VarbitRequirement(37, 1);
        this.gotKey = new VarbitRequirement(38, 1);
        this.usedTar = new VarbitRequirement(46, 1);
        this.usedTinderbox = new VarbitRequirement(48, 1);
        this.usedGlass = new VarbitRequirement(47, 1);
        this.notUsedAirRune = new Conditions(LogicType.NOR, new VarbitRequirement(43, 1));
        this.notUsedWaterRune = new Conditions(LogicType.NOR, new VarbitRequirement(41, 1));
        this.notUsedEarthRune = new Conditions(LogicType.NOR, new VarbitRequirement(42, 1));
        this.notUsedFireRune = new Conditions(LogicType.NOR, new VarbitRequirement(40, 1));
        this.notUsedSword = new Conditions(LogicType.NOR, new VarbitRequirement(44, 1));
        this.notUsedArrow = new Conditions(LogicType.NOR, new VarbitRequirement(45, 1));
        this.doorUnlocked = new VarbitRequirement(35, 1);
        this.dagannothNearby = new NpcHintArrowRequirement(979);
        this.motherNearby = new NpcHintArrowRequirement(980, 981, 982, 983, 984, 985, 986, 987, 988);
    }

    public void setupSteps() {
        this.talkToLarrissa = new NpcStep((QuestHelper)this, 4425, new WorldPoint(2507, 3634, 0), "Talk to Larrissa outside the Lighthouse north of the Barbarian Outpost. You can get here by Fairy Ring (alp), by jumping over the bassalt rocks from the Barbarian Outpost, or from the Fremennik Province.", new Requirement[0]);
        this.talkToLarrissa.addDialogSteps("With what?", "But how can I help?", "Okay, I'll help!");
        this.usePlankOnBridge = new ObjectStep((QuestHelper)this, 4615, new WorldPoint(2596, 3608, 0), "Use a plank on the bridge east of the Lighthouse.", this.plank.highlighted(), this.steelNails.quantity(30), this.hammer);
        this.usePlankOnBridge.addIcon(960);
        this.useSecondPlank = new ObjectStep((QuestHelper)this, 4616, new WorldPoint(2598, 3608, 0), "Use a plank on the other side of the bridge east of the Lighthouse.", this.plank.highlighted(), this.steelNails.quantity(30), this.hammer);
        this.useSecondPlank.addIcon(960);
        this.talkToGunnjorn = new NpcStep((QuestHelper)this, 2153, new WorldPoint(2547, 3553, 0), "Talk to Gunnjorn in the Barbarian Agility Course south of the lighthouse.", new Requirement[0]);
        this.openLighthouse = new ObjectStep((QuestHelper)this, 4577, new WorldPoint(2509, 3636, 0), "Unlock the Lighthouse.", this.lighthouseKey);
        this.enterLighthouse = new ObjectStep((QuestHelper)this, 4577, new WorldPoint(2509, 3636, 0), "Enter the Lighthouse.", new Requirement[0]);
        this.goToF1 = new ObjectStep((QuestHelper)this, 4568, new WorldPoint(2443, 4601, 0), "Go to the top of the lighthouse.", new Requirement[0]);
        this.goToF2 = new ObjectStep((QuestHelper)this, 4569, new WorldPoint(2443, 4601, 1), "Go to the top of the lighthouse.", new Requirement[0]);
        this.goToF2.addDialogStep("Climb up");
        this.goToF2.addSubSteps(this.goToF1);
        this.useTar = new ObjectStep((QuestHelper)this, 4588, new WorldPoint(2445, 4601, 2), "Use swamp tar on the lighting mechanism.", this.swampTar1.highlighted());
        this.useTar.addIcon(1939);
        this.useTinderbox = new ObjectStep((QuestHelper)this, 4588, new WorldPoint(2445, 4601, 2), "Use a tinderbox on the lighting mechanism.", this.tinderbox.highlighted());
        this.useTinderbox.addIcon(590);
        this.useGlass = new ObjectStep((QuestHelper)this, 4588, new WorldPoint(2445, 4601, 2), "Use molten glass on the lighting mechanism.", this.moltenGlass.highlighted());
        this.useGlass.addIcon(1775);
        this.goDownToF1 = new ObjectStep((QuestHelper)this, 4570, new WorldPoint(2443, 4601, 1), "Go to the basement of the lighthouse.", new Requirement[0]);
        this.goDownToF0 = new ObjectStep((QuestHelper)this, 4569, new WorldPoint(2443, 4601, 1), "Go to the basement of the lighthouse.", new Requirement[0]);
        this.goDownToF0.addDialogStep("Climb down");
        this.goDownToBasement = new ObjectStep((QuestHelper)this, 4383, new WorldPoint(2445, 4604, 0), "Go to the basement of the lighthouse.", new Requirement[0]);
        this.goDownToBasement.addSubSteps(this.goDownToF1, this.goDownToF2);
        this.useAirRune = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use an air rune on the strange wall.", this.airRune.highlighted());
        this.useAirRune.addIcon(556);
        this.useWaterRune = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use a water rune on the strange wall.", this.waterRune.highlighted());
        this.useWaterRune.addIcon(555);
        this.useEarthRune = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use an earth rune on the strange wall.", this.earthRune.highlighted());
        this.useEarthRune.addIcon(557);
        this.useFireRune = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use a fire rune on the strange wall.", this.fireRune.highlighted());
        this.useFireRune.addIcon(554);
        this.useArrow = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use an arrow on the strange wall.", this.arrow.highlighted());
        this.useArrow.addIcon(882);
        this.useSword = new ObjectStep((QuestHelper)this, 4544, new WorldPoint(2515, 4627, 0), "Use a sword on the strange wall. You will lose it.", this.sword.highlighted());
        this.useSword.addIcon(1277);
        this.goThroughDoor = new ObjectStep((QuestHelper)this, 4545, new WorldPoint(2516, 4627, 0), "Go through the strange wall, ready for fighting.", new Requirement[0]);
        this.talkToJossik = new NpcStep((QuestHelper)this, 4424, new WorldPoint(2518, 4634, 0), "Talk to Jossik.", new Requirement[0]);
        this.killDagannoth = new NpcStep((QuestHelper)this, 979, new WorldPoint(2518, 4640, 0), "Defeat the dagannoth.", new Requirement[0]);
        this.killMother = new NpcStep((QuestHelper)this, 980, new WorldPoint(2518, 4640, 0), "Defeat the Dagannoth mother. She can only be hurt by air spells when white, water spells when blue, earth spells when brown, fire spells when red, melee when orange and ranged when green.", this.protectFromMissiles, this.magicCombat, this.combatRunes);
        ((NpcStep)this.killMother).addAlternateNpcs(981, 982, 983, 984, 985, 986, 987, 988);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.fireRune, this.airRune, this.waterRune, this.earthRune, this.sword, this.arrow, this.moltenGlass, this.tinderbox, this.hammer, this.steelNails.quantity(60), this.plank2, this.swampTar1, this.combatRunes);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.gamesNecklace, this.magicCombat, this.food, this.prayerPotions);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 35, true));
        reqs.add(new QuestRequirement(QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("The Dagannoth Mother will swap over time between being vulnerable to melee, ranged, and each of the 4 magic elements. You can bring multiple combat types, or just wait for her to swap to what you have brought along.");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Dagannoth (level 100)", "Dagannoth Mother (level 100)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MAGIC, 4662), new ExperienceReward(Skill.STRENGTH, 4662), new ExperienceReward(Skill.RANGED, 4662));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("A damaged God Book of your choice."), new UnlockReward("Access to The Lighthouse"), new UnlockReward("Ability to receive Dagannoth as a Slayer task."));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Saving Jossik", Arrays.asList(this.talkToLarrissa, this.usePlankOnBridge, this.useSecondPlank, this.talkToGunnjorn, this.openLighthouse, this.enterLighthouse, this.goToF1, this.useTar, this.useTinderbox, this.useGlass, this.goDownToBasement, this.useAirRune, this.useWaterRune, this.useEarthRune, this.useFireRune, this.useArrow, this.useSword), this.hammer, this.steelNails.quantity(60), this.plank2, this.moltenGlass, this.tinderbox, this.swampTar1, this.fireRune, this.airRune, this.waterRune, this.earthRune, this.sword, this.arrow, this.combatRunes));
        allSteps.add(new PanelDetails("Defeating the dagannoths", Arrays.asList(this.goThroughDoor, this.talkToJossik, this.killDagannoth, this.killMother), this.combatRunes));
        return allSteps;
    }
}

