/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.holygrail;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HOLY_GRAIL)
public class HolyGrail
extends BasicQuestHelper {
    ItemRequirement antipoison;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement threeCamelotTele;
    ItemRequirement ardyTele;
    ItemRequirement faladorTele;
    ItemRequirement sixtyCoins;
    ItemRequirement excalibur;
    ItemRequirement holyTableNapkin;
    ItemRequirement twoMagicWhistles;
    ItemRequirement highlightMagicWhistle1;
    ItemRequirement goldFeather;
    ItemRequirement grailBell;
    ItemRequirement highlightGrailBell;
    ItemRequirement emptyInvSpot;
    ItemRequirement oneMagicWhistle;
    ItemRequirement highlightMagicWhistle2;
    ItemRequirement grail;
    Requirement inCamelot;
    Requirement inCamelotUpstairs;
    Requirement inMerlinRoom;
    Requirement merlinNearby;
    Requirement onEntrana;
    Requirement inGalahadHouse;
    Requirement inDraynorFrontManor;
    Requirement inDraynorManorBottomFloor;
    Requirement inDraynorManorSecondFloor;
    Requirement inDraynorManorTopFloor;
    Requirement inMagicWhistleRoom;
    Requirement inTeleportLocation;
    Requirement inFisherKingRealmEntrance;
    Requirement titanNearby;
    Requirement inFisherKingRealmAfterTitan;
    Requirement talkedToFisherman;
    Requirement inGrailBellRingLocation;
    Requirement inFisherKingCastle1BottomFloor;
    Requirement inFisherKingCastle1SecondFloor;
    Requirement inFisherKingRealm;
    Requirement inFisherKingCastle2BottomFloor;
    Requirement inFisherKingCastle2SecondFloor;
    Requirement inFisherKingCastle2ThirdFloor;
    QuestStep talkToKingArthur1;
    QuestStep talkToMerlin;
    QuestStep goUpStairsCamelot;
    QuestStep openMerlinDoor;
    QuestStep goToEntrana;
    QuestStep talkToHighPriest;
    QuestStep goToGalahad;
    QuestStep talkToGalahad;
    QuestStep goToDraynorManor;
    QuestStep enterDraynorManor;
    QuestStep goUpStairsDraynor1;
    QuestStep goUpStairsDraynor2;
    QuestStep openWhistleDoor;
    QuestStep takeWhistles;
    QuestStep goGetExcalibur;
    QuestStep goToTeleportLocation1;
    QuestStep blowWhistle1;
    QuestStep attackTitan;
    QuestStep talkToFisherman;
    QuestStep pickupBell;
    QuestStep ringBell;
    QuestStep goUpStairsBrokenCastle;
    QuestStep talkToFisherKing;
    QuestStep goToCamelot;
    QuestStep talkToKingArthur2;
    QuestStep openSack;
    QuestStep goToTeleportLocation2;
    QuestStep blowWhistle2;
    QuestStep openFisherKingCastleDoor;
    QuestStep goUpNewCastleStairs;
    QuestStep goUpNewCastleLadder;
    QuestStep takeGrail;
    QuestStep talkToKingArthur3;
    ConditionalStep findFisherKing;
    Zone camelotGround;
    Zone camelotUpstairsZone1;
    Zone camelotUpstairsZone2;
    Zone merlinRoom;
    Zone entranaBoat;
    Zone entranaIsland;
    Zone galahadHouse;
    Zone draynorManorFront;
    Zone draynorManorBottomFloor;
    Zone draynorManorSecondFloor;
    Zone draynorManorTopFloor;
    Zone magicWhistleRoom;
    Zone teleportLocation;
    Zone fisherKingRealmEntrance;
    Zone fisherKingRealmAfterTitan1;
    Zone fisherKingRealmAfterTitan2;
    Zone fisherKingRealmAfterTitan3;
    Zone grailBellRingLocation;
    Zone fisherKingRealmCastle1BottomFloor;
    Zone fisherKingRealmCastle1SecondFloor;
    Zone fisherKingRealm;
    Zone fisherKingRealmCastle2BottomFloor;
    Zone fisherKingRealmCastle2SecondFloor;
    Zone fisherKingRealmCastle2ThirdFloor;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToKingArthur1);
        ConditionalStep findingMerlin = new ConditionalStep((QuestHelper)this, this.goUpStairsCamelot, new Requirement[0]);
        findingMerlin.addStep(new Conditions(this.inMerlinRoom, this.merlinNearby), this.talkToMerlin);
        findingMerlin.addStep(this.inCamelotUpstairs, this.openMerlinDoor);
        steps.put(2, findingMerlin);
        ConditionalStep findHighPriest = new ConditionalStep((QuestHelper)this, this.goToEntrana, new Requirement[0]);
        findHighPriest.addStep(this.onEntrana, this.talkToHighPriest);
        steps.put(3, findHighPriest);
        this.findFisherKing = new ConditionalStep((QuestHelper)this, this.goToGalahad, new Requirement[0]);
        this.findFisherKing.addStep(this.inFisherKingCastle1SecondFloor, this.talkToFisherKing);
        this.findFisherKing.addStep(this.inFisherKingCastle1BottomFloor, this.goUpStairsBrokenCastle);
        this.findFisherKing.addStep(new Conditions(this.grailBell, this.inFisherKingRealmAfterTitan), this.ringBell);
        this.findFisherKing.addStep(this.talkedToFisherman, this.pickupBell);
        this.findFisherKing.addStep(this.inFisherKingRealmAfterTitan, this.talkToFisherman);
        this.findFisherKing.addStep(new Conditions(this.excalibur, this.titanNearby), this.attackTitan);
        this.findFisherKing.addStep(new Conditions(this.twoMagicWhistles, this.inTeleportLocation, this.excalibur), this.blowWhistle1);
        this.findFisherKing.addStep(new Conditions(this.twoMagicWhistles, this.excalibur), this.goToTeleportLocation1);
        this.findFisherKing.addStep(this.twoMagicWhistles, this.goGetExcalibur);
        this.findFisherKing.addStep(this.inMagicWhistleRoom, this.takeWhistles);
        this.findFisherKing.addStep(this.inDraynorManorTopFloor, this.openWhistleDoor);
        this.findFisherKing.addStep(this.inDraynorManorSecondFloor, this.goUpStairsDraynor2);
        this.findFisherKing.addStep(this.inDraynorManorBottomFloor, this.goUpStairsDraynor1);
        this.findFisherKing.addStep(this.inDraynorFrontManor, this.enterDraynorManor);
        this.findFisherKing.addStep(this.holyTableNapkin, this.goToDraynorManor);
        this.findFisherKing.addStep(this.inGalahadHouse, this.talkToGalahad);
        this.findFisherKing.setLockingCondition(this.twoMagicWhistles);
        steps.put(4, this.findFisherKing);
        steps.put(7, this.findFisherKing);
        ConditionalStep findPercival = new ConditionalStep((QuestHelper)this, this.talkToKingArthur2, new Requirement[0]);
        findPercival.addStep(this.goldFeather, this.openSack);
        steps.put(8, findPercival);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.goToTeleportLocation2, new Requirement[0]);
        finishQuest.addStep(this.grail, this.talkToKingArthur3);
        finishQuest.addStep(this.inFisherKingCastle2ThirdFloor, this.takeGrail);
        finishQuest.addStep(this.inFisherKingCastle2SecondFloor, this.goUpNewCastleLadder);
        finishQuest.addStep(this.inFisherKingCastle2BottomFloor, this.goUpNewCastleStairs);
        finishQuest.addStep(this.inFisherKingRealm, this.openFisherKingCastleDoor);
        finishQuest.addStep(this.inTeleportLocation, this.blowWhistle2);
        steps.put(9, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.excalibur = new ItemRequirement("Excalibur", 35).isNotConsumed();
        this.holyTableNapkin = new ItemRequirement("Holy Table Napkin", 15);
        this.twoMagicWhistles = new ItemRequirement("Magic Whistles", 16, 2);
        this.threeCamelotTele = new ItemRequirement("Camelot Teleports", 8010, 3);
        this.ardyTele = new ItemRequirement("Ardougne Teleport", 8011);
        this.faladorTele = new ItemRequirement("Falador Teleport", 8009);
        this.sixtyCoins = new ItemRequirement("Coins", ItemCollections.COINS, 60);
        this.antipoison = new ItemRequirement("Antipoison", 2446);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.combatGear = new ItemRequirement("A weapon and armour", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.emptyInvSpot = new ItemRequirement("Empty Inventory Spot", -1, 1);
        this.goldFeather = new ItemRequirement("Magic gold feather", 18);
        this.grailBell = new ItemRequirement("Grail Bell", 17);
        this.oneMagicWhistle = new ItemRequirement("Magic Whistle", 16);
        this.grail = new ItemRequirement("Holy Grail", 19);
        this.highlightMagicWhistle1 = new ItemRequirement("Magic Whistle", 16, 2);
        this.highlightMagicWhistle1.setHighlightInInventory(true);
        this.highlightMagicWhistle2 = new ItemRequirement("Magic Whistle", 16);
        this.highlightMagicWhistle2.setHighlightInInventory(true);
        this.highlightGrailBell = new ItemRequirement("Grail Bell", 17);
        this.highlightGrailBell.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.camelotGround = new Zone(new WorldPoint(2744, 3517, 0), new WorldPoint(2733, 3483, 0));
        this.camelotUpstairsZone1 = new Zone(new WorldPoint(2768, 3517, 1), new WorldPoint(2757, 3506, 1));
        this.camelotUpstairsZone2 = new Zone(new WorldPoint(2764, 3517, 1), new WorldPoint(2748, 3496, 1));
        this.merlinRoom = new Zone(new WorldPoint(2768, 3505, 1), new WorldPoint(2765, 3496, 1));
        this.entranaBoat = new Zone(new WorldPoint(2841, 3332, 0), new WorldPoint(2823, 3328, 2));
        this.entranaIsland = new Zone(new WorldPoint(2871, 3393, 0), new WorldPoint(2800, 3329, 2));
        this.galahadHouse = new Zone(new WorldPoint(2616, 3480, 0), new WorldPoint(2609, 3473, 0));
        this.draynorManorFront = new Zone(new WorldPoint(3116, 3353, 0), new WorldPoint(3100, 3347, 0));
        this.draynorManorBottomFloor = new Zone(new WorldPoint(3119, 3373, 0), new WorldPoint(3097, 3354, 0));
        this.draynorManorSecondFloor = new Zone(new WorldPoint(3118, 3373, 1), new WorldPoint(3098, 3354, 1));
        this.draynorManorTopFloor = new Zone(new WorldPoint(3112, 3370, 2), new WorldPoint(3104, 3362, 2));
        this.magicWhistleRoom = new Zone(new WorldPoint(3112, 3361, 2), new WorldPoint(3104, 3357, 2));
        this.teleportLocation = new Zone(new WorldPoint(2743, 3237, 0), new WorldPoint(2740, 3234, 0));
        this.fisherKingRealmAfterTitan1 = new Zone(new WorldPoint(2791, 4734, 0), new WorldPoint(2752, 4671, 0));
        this.fisherKingRealmAfterTitan2 = new Zone(new WorldPoint(2808, 4707, 0), new WorldPoint(2791, 4688, 0));
        this.fisherKingRealmAfterTitan3 = new Zone(new WorldPoint(2798, 4710, 0), new WorldPoint(2781, 4707, 0));
        this.grailBellRingLocation = new Zone(new WorldPoint(2762, 4694, 0), new WorldPoint(2761, 4694, 0));
        this.fisherKingRealmCastle1BottomFloor = new Zone(new WorldPoint(2780, 4692, 0), new WorldPoint(2756, 4675, 0));
        this.fisherKingRealmCastle1SecondFloor = new Zone(new WorldPoint(2771, 4692, 1), new WorldPoint(2756, 4675, 1));
        this.fisherKingRealm = new Zone(new WorldPoint(2683, 4733, 0), new WorldPoint(2625, 4672, 0));
        this.fisherKingRealmCastle2BottomFloor = new Zone(new WorldPoint(2652, 4692, 0), new WorldPoint(2628, 4675, 0));
        this.fisherKingRealmCastle2SecondFloor = new Zone(new WorldPoint(2652, 4687, 1), new WorldPoint(2646, 4681, 1));
        this.fisherKingRealmCastle2ThirdFloor = new Zone(new WorldPoint(2651, 4686, 2), new WorldPoint(2647, 4682, 2));
    }

    public void setupConditions() {
        this.inCamelot = new ZoneRequirement(this.camelotGround);
        this.inCamelotUpstairs = new Conditions(LogicType.OR, new ZoneRequirement(this.camelotUpstairsZone1), new ZoneRequirement(this.camelotUpstairsZone2));
        this.inMerlinRoom = new ZoneRequirement(this.merlinRoom);
        this.merlinNearby = new NpcCondition(4059);
        this.onEntrana = new Conditions(LogicType.OR, new ZoneRequirement(this.entranaBoat), new ZoneRequirement(this.entranaIsland));
        this.inGalahadHouse = new ZoneRequirement(this.galahadHouse);
        this.inDraynorFrontManor = new ZoneRequirement(this.draynorManorFront);
        this.inDraynorManorBottomFloor = new ZoneRequirement(this.draynorManorBottomFloor);
        this.inDraynorManorSecondFloor = new ZoneRequirement(this.draynorManorSecondFloor);
        this.inDraynorManorTopFloor = new ZoneRequirement(this.draynorManorTopFloor);
        this.inMagicWhistleRoom = new ZoneRequirement(this.magicWhistleRoom);
        this.inTeleportLocation = new ZoneRequirement(this.teleportLocation);
        this.inFisherKingRealmEntrance = new ZoneRequirement(this.fisherKingRealmEntrance);
        this.titanNearby = new NpcCondition(4067);
        this.inFisherKingRealmAfterTitan = new Conditions(LogicType.OR, new ZoneRequirement(this.fisherKingRealmAfterTitan1), new ZoneRequirement(this.fisherKingRealmAfterTitan2), new ZoneRequirement(this.fisherKingRealmAfterTitan3));
        this.talkedToFisherman = new Conditions(true, new DialogRequirement("You must be blind then. There's ALWAYS bells there when I go to the castle."));
        this.inGrailBellRingLocation = new ZoneRequirement(this.grailBellRingLocation);
        this.inFisherKingCastle1BottomFloor = new ZoneRequirement(this.fisherKingRealmCastle1BottomFloor);
        this.inFisherKingCastle1SecondFloor = new ZoneRequirement(this.fisherKingRealmCastle1SecondFloor);
        this.inFisherKingRealm = new ZoneRequirement(this.fisherKingRealm);
        this.inFisherKingCastle2BottomFloor = new ZoneRequirement(this.fisherKingRealmCastle2BottomFloor);
        this.inFisherKingCastle2SecondFloor = new ZoneRequirement(this.fisherKingRealmCastle2SecondFloor);
        this.inFisherKingCastle2ThirdFloor = new ZoneRequirement(this.fisherKingRealmCastle2ThirdFloor);
    }

    public void setupSteps() {
        WorldPoint kingArthurWorldPoint = new WorldPoint(2763, 3513, 0);
        this.talkToKingArthur1 = new NpcStep((QuestHelper)this, 3531, kingArthurWorldPoint, "Talk to King Arthur in Camelot Castle to start.", new Requirement[0]);
        this.talkToKingArthur1.addDialogStep("Tell me of this quest.");
        this.talkToKingArthur1.addDialogStep("I'd enjoy trying that.");
        this.goUpStairsCamelot = new ObjectStep((QuestHelper)this, 26106, new WorldPoint(2751, 3511, 0), "Go upstairs to talk to Merlin.", new Requirement[0]);
        this.openMerlinDoor = new ObjectStep((QuestHelper)this, 24, "Open the door to go to Merlin's room.", new Requirement[0]);
        this.talkToMerlin = new NpcStep((QuestHelper)this, 4059, new WorldPoint(2763, 3513, 1), "Talk to Merlin", new Requirement[0]);
        this.talkToMerlin.addDialogStep("Where can I find Sir Galahad?");
        this.goToEntrana = new NpcStep((QuestHelper)this, 1167, new WorldPoint(3048, 3235, 0), "Talk to a monk of Entrana. Bank all combat gear.", true, new Requirement[0]);
        this.talkToHighPriest = new NpcStep((QuestHelper)this, 4062, new WorldPoint(2851, 3348, 0), "Talk to the High Priest.", new Requirement[0]);
        this.talkToHighPriest.addDialogSteps("Ask about the Holy Grail Quest", "Ok, I will go searching.");
        this.goToGalahad = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2612, 3475, 0), "Travel to Galahad's House. His house is west of McGrubor's Woods.", new Requirement[0]);
        this.talkToGalahad = new NpcStep((QuestHelper)this, 4064, new WorldPoint(2612, 3475, 0), "Talk to Galahad.", new Requirement[0]);
        this.talkToGalahad.addDialogStep("I seek an item from the realm of the Fisher King.");
        this.goToDraynorManor = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3108, 3350, 0), "Travel to Draynor Manor.", this.holyTableNapkin);
        this.enterDraynorManor = new ObjectStep((QuestHelper)this, 135, "Enter Draynor Manor.", this.holyTableNapkin);
        this.goUpStairsDraynor1 = new ObjectStep((QuestHelper)this, 11498, new WorldPoint(3109, 3364, 0), "Go up the stairs in Draynor Manor.", this.holyTableNapkin);
        this.goUpStairsDraynor2 = new ObjectStep((QuestHelper)this, 11511, new WorldPoint(3105, 3363, 1), "Go up the second set of stairs in Draynor Manor.", this.holyTableNapkin);
        this.openWhistleDoor = new ObjectStep((QuestHelper)this, 22, "Open the door to the Magic Whistles.", this.holyTableNapkin);
        this.takeWhistles = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3107, 3359, 2), "Pickup 2 Magic Whistles.", this.holyTableNapkin);
        this.goGetExcalibur = new ItemStep((QuestHelper)this, "Go retrieve Excalibur from your bank. If you do not own Excalibur, you can retrieve it from the Lady of the Lake in Taverly for 500 coins.", this.twoMagicWhistles, this.excalibur);
        WorldPoint teleportLocationPoint = new WorldPoint(2742, 3236, 0);
        this.goToTeleportLocation1 = new DetailedQuestStep((QuestHelper)this, teleportLocationPoint, "Go to the tower on Karamja near gold mine west of Brimhaven.", this.twoMagicWhistles, this.excalibur);
        this.blowWhistle1 = new ItemStep((QuestHelper)this, "Blow the whistle once you are underneath of the tower.", this.highlightMagicWhistle1, this.excalibur);
        this.attackTitan = new NpcStep((QuestHelper)this, 4067, "Kill the Black Knight Titan with Excalibur. (You only need to deal the killing blow with excalibur!)", this.twoMagicWhistles, this.excalibur);
        this.talkToFisherman = new NpcStep((QuestHelper)this, 4065, new WorldPoint(2798, 4706, 0), "Talk to the fisherman by the river. After talking to him walk West to the castle.", new Requirement[0]);
        this.talkToFisherman.addDialogStep("Any idea how to get into the castle?");
        this.pickupBell = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2762, 4694, 0), "Pickup the bell outside of the castle.", new Requirement[0]);
        this.ringBell = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2762, 4694, 0), "Ring the grail bell directly north of the broken castle wall (Where you picked up the bell)", this.highlightGrailBell);
        this.ringBell.addIcon(17);
        this.goUpStairsBrokenCastle = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2762, 4681, 0), "Go up the stairs inside of the castle.", new Requirement[0]);
        this.talkToFisherKing = new NpcStep((QuestHelper)this, 4066, "Talk to The Fisher King.", new Requirement[0]);
        this.talkToFisherKing.addDialogStep("You don't look too well.");
        this.goToCamelot = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2758, 3486, 0), "Go back to Camelot.", new Requirement[0]);
        this.talkToKingArthur2 = new NpcStep((QuestHelper)this, 3531, kingArthurWorldPoint, "Return to Camelot and talk to King Arthur.", this.emptyInvSpot);
        this.openSack = new ObjectStep((QuestHelper)this, 23, new WorldPoint(2962, 3506, 0), "Travel to the Goblin Village North of Falador. Right click and open the sacks.", this.twoMagicWhistles);
        this.openSack.addDialogStep("Come with me, I shall make you a king.");
        this.goToTeleportLocation2 = new DetailedQuestStep((QuestHelper)this, teleportLocationPoint, "Go to the tower on Karamja near gold mine west of Brimhaven.", this.oneMagicWhistle, this.goldFeather);
        this.blowWhistle2 = new ItemStep((QuestHelper)this, "Blow the whistle once you are underneath of the tower.", this.highlightMagicWhistle2, this.goldFeather);
        this.openFisherKingCastleDoor = new ObjectStep((QuestHelper)this, 1524, "Open the door to the castle and enter.", this.goldFeather);
        this.goUpNewCastleStairs = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2649, 4684, 0), "Go up the stairs to the east.", this.goldFeather);
        this.goUpNewCastleLadder = new ObjectStep((QuestHelper)this, 16683, "Climb the ladder on the second floor.", this.goldFeather);
        this.takeGrail = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2649, 4684, 2), "Pickup the Grail.", this.goldFeather);
        this.talkToKingArthur3 = new NpcStep((QuestHelper)this, 3531, kingArthurWorldPoint, "Return to Camelot and talk to King Arthur", this.grail);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Black Knight Titan (level 120)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.excalibur);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.threeCamelotTele);
        reqs.add(this.ardyTele.quantity(2));
        reqs.add(this.faladorTele);
        reqs.add(this.sixtyCoins);
        reqs.add(this.antipoison);
        reqs.add(this.food);
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.PRAYER, 11000), new ExperienceReward(Skill.DEFENCE, 15300));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Fisher Realm."), new UnlockReward("Ability to put King Arthur picture on the wall in the POH."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting Off", Arrays.asList(this.talkToKingArthur1, this.goUpStairsCamelot, this.openMerlinDoor, this.talkToMerlin), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting the Napkin", Arrays.asList(this.goToEntrana, this.talkToHighPriest, this.goToGalahad, this.talkToGalahad), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting the Magic Whistles", Arrays.asList(this.goToDraynorManor, this.enterDraynorManor, this.goUpStairsDraynor1, this.goUpStairsDraynor2, this.openWhistleDoor, this.takeWhistles), this.holyTableNapkin));
        allSteps.add(new PanelDetails("Fisher King Realm Pt.1", Arrays.asList(this.goToTeleportLocation1, this.blowWhistle1, this.attackTitan, this.talkToFisherman, this.pickupBell, this.ringBell, this.goUpStairsBrokenCastle, this.talkToFisherKing), this.twoMagicWhistles, this.excalibur));
        allSteps.add(new PanelDetails("Finding Percival", Arrays.asList(this.talkToKingArthur2, this.openSack), this.emptyInvSpot, this.twoMagicWhistles));
        allSteps.add(new PanelDetails("Fisher King Realm Pt.2", Arrays.asList(this.goToTeleportLocation2, this.blowWhistle2, this.openFisherKingCastleDoor, this.goUpNewCastleStairs, this.goUpNewCastleLadder, this.takeGrail), this.oneMagicWhistle, this.goldFeather));
        allSteps.add(new PanelDetails("Finishing Up", Collections.singletonList(this.talkToKingArthur3), this.grail));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.MERLINS_CRYSTAL, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.ATTACK, 20));
        return req;
    }
}

