/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.heroesquest;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HEROES_QUEST)
public class HeroesQuest
extends BasicQuestHelper {
    ItemRequirement iceGloves;
    ItemRequirement equippedIceGloves;
    ItemRequirement fishingRod;
    ItemRequirement fishingBait;
    ItemRequirement dustyKey;
    ItemRequirement dustyKeyHint;
    ItemRequirement harralanderUnf;
    ItemRequirement pickaxe;
    ItemRequirement blamishSlime;
    ItemRequirement blamishOil;
    ItemRequirement oilRod;
    ItemRequirement jailKey;
    ItemRequirement rawLavaEel;
    ItemRequirement lavaEel;
    ItemRequirement thievesArmband;
    ItemRequirement rangedMage;
    ItemRequirement miscKey;
    ItemRequirement blackFullHelm;
    ItemRequirement blackPlatebody;
    ItemRequirement blackPlatelegs;
    ItemRequirement idPapers;
    ItemRequirement candlestick;
    ItemRequirement gripsKey;
    ItemRequirement fireFeather;
    ItemRequirement combatGear;
    ItemRequirement antifireShield;
    ItemRequirement varrockTeleport;
    ItemRequirement burthorpeTeleport;
    ItemRequirement brimhavenTeleport;
    ItemRequirement taverleyTeleport;
    ItemRequirement portSarimTeleport;
    Requirement inTaverleyDungeon;
    Requirement has70Agility;
    Requirement inDeepTaverleyDungeon;
    Requirement talkedToKatrine;
    Requirement talkedToStraven;
    Requirement inJailCell;
    Requirement inBlackArmGang;
    Requirement inPhoenixBase;
    Requirement talkedToAlfonse;
    Requirement blackArmGangDoorUnlocked;
    Requirement gottenPapers;
    Requirement enteredMansion;
    Requirement talkedToGrip;
    Requirement inGarden;
    Requirement inSecretRoom;
    Requirement chestOpen;
    Requirement gripsKeyOnFloor;
    Requirement inTreasureRoom;
    Requirement talkedToCharlie;
    Requirement unlockedCandlestickBlackArm;
    Requirement unlockedCandlestickPhoenix;
    Requirement finishedBlackArm;
    Requirement finishedPhoenix;
    Requirement inIceEntrance;
    Requirement inIceUndergroundRoom1;
    Requirement inIceUndergroundRoom2;
    Requirement inIceAboveGround1;
    Requirement inIceAboveGround2;
    Requirement iceGlovesNearby;
    Requirement inThroneRoom;
    Requirement fireFeatherNearby;
    Requirement onEntrana;
    DetailedQuestStep talkToAchietties;
    DetailedQuestStep talkToGerrant;
    DetailedQuestStep makeBlamishOil;
    DetailedQuestStep useOilOnRod;
    DetailedQuestStep enterTaverleyDungeon;
    DetailedQuestStep goThroughPipe;
    DetailedQuestStep killJailerForKey;
    DetailedQuestStep getDustyFromAdventurer;
    DetailedQuestStep enterDeeperTaverley;
    DetailedQuestStep fishLavaEel;
    DetailedQuestStep cookLavaEel;
    DetailedQuestStep talkToKatrine;
    DetailedQuestStep tryToEnterTrobertHouse;
    DetailedQuestStep talkToTrobert;
    DetailedQuestStep enterMansion;
    DetailedQuestStep talkToGrip;
    DetailedQuestStep getKeyFromGrip;
    DetailedQuestStep pickupKey;
    DetailedQuestStep enterTreasureRoom;
    DetailedQuestStep searchChest;
    DetailedQuestStep returnToKatrine;
    DetailedQuestStep enterPhoenixBase;
    DetailedQuestStep talkToStraven;
    DetailedQuestStep talkToAlfonse;
    DetailedQuestStep getKeyFromPartner;
    DetailedQuestStep talkToCharlie;
    DetailedQuestStep useKeyOnDoor;
    DetailedQuestStep pushWall;
    DetailedQuestStep killGrip;
    DetailedQuestStep enterPhoenixBaseAgain;
    DetailedQuestStep bringCandlestickToStraven;
    DetailedQuestStep mineEntranceRocks;
    DetailedQuestStep takeLadder1Down;
    DetailedQuestStep takeLadder2Up;
    DetailedQuestStep takeLadder3Down;
    DetailedQuestStep takeLadder4Up;
    DetailedQuestStep takeLadder5Down;
    DetailedQuestStep killIceQueen;
    DetailedQuestStep pickupIceGloves;
    DetailedQuestStep goToEntrana;
    DetailedQuestStep getCandlestick;
    DetailedQuestStep killFireBird;
    DetailedQuestStep pickupFireFeather;
    DetailedQuestStep finishQuest;
    ConditionalStep getThievesArmband;
    ConditionalStep getIceGloves;
    ConditionalStep getLavaEel;
    ConditionalStep getFireFeather;
    Zone taverleyDungeon;
    Zone deepTaverleyDungeon1;
    Zone deepTaverleyDungeon2;
    Zone deepTaverleyDungeon3;
    Zone deepTaverleyDungeon4;
    Zone jailCell;
    Zone phoenixBase;
    Zone phoenixEntry;
    Zone garden1;
    Zone garden2;
    Zone secretRoom;
    Zone treasureRoom;
    Zone iceEntrance;
    Zone iceRoom1P1;
    Zone iceRoom1P2;
    Zone iceRoom1P3;
    Zone iceRoom2P1;
    Zone iceRoom2P2;
    Zone iceRoom2P3;
    Zone iceRoom2P4;
    Zone iceUp1P1;
    Zone iceUp1P2;
    Zone iceUp1P3;
    Zone iceUp1P4;
    Zone iceUp2;
    Zone iceThrone1;
    Zone iceThrone2;
    Zone iceThrone3;
    Zone entrana;
    boolean isInBlackArmGang;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        if (this.inBlackArmGang.check(this.client)) {
            this.isInBlackArmGang = true;
        }
        steps.put(0, this.talkToAchietties);
        this.getLavaEel = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToGerrant, new Requirement[0]);
        this.getLavaEel.addStep(this.rawLavaEel, this.cookLavaEel);
        this.getLavaEel.addStep(new Conditions(this.oilRod, this.inDeepTaverleyDungeon), this.fishLavaEel);
        this.getLavaEel.addStep(new Conditions(this.oilRod, this.inTaverleyDungeon, this.has70Agility), this.goThroughPipe);
        this.getLavaEel.addStep(new Conditions(this.oilRod, this.inTaverleyDungeon, this.dustyKey), this.enterDeeperTaverley);
        this.getLavaEel.addStep(new Conditions(this.oilRod, this.inTaverleyDungeon, new Conditions(LogicType.OR, this.inJailCell, this.jailKey)), this.getDustyFromAdventurer);
        this.getLavaEel.addStep(new Conditions(this.oilRod, this.inTaverleyDungeon), this.killJailerForKey);
        this.getLavaEel.addStep(new Conditions(this.oilRod), this.enterTaverleyDungeon);
        this.getLavaEel.addStep(this.blamishOil, this.useOilOnRod);
        this.getLavaEel.addStep(this.blamishSlime, this.makeBlamishOil);
        this.getLavaEel.setLockingCondition(this.lavaEel);
        if (this.inBlackArmGang.check(this.client)) {
            this.thievesArmband.setTooltip("You can get another from Katrine in the Black Arm Gang base.");
            this.getThievesArmband = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToKatrine, new Requirement[0]);
            this.getThievesArmband.addStep(this.candlestick, this.returnToKatrine);
            this.getThievesArmband.addStep(new Conditions(this.inTreasureRoom, this.chestOpen), this.searchChest);
            this.getThievesArmband.addStep(this.inTreasureRoom, this.searchChest);
            this.getThievesArmband.addStep(this.gripsKey, this.enterTreasureRoom);
            this.getThievesArmband.addStep(this.gripsKeyOnFloor, this.pickupKey);
            this.getThievesArmband.addStep(this.talkedToGrip, this.getKeyFromGrip);
            this.getThievesArmband.addStep(this.enteredMansion, this.talkToGrip);
            this.getThievesArmband.addStep(this.gottenPapers, this.enterMansion);
            this.getThievesArmband.addStep(this.blackArmGangDoorUnlocked, this.talkToTrobert);
            this.getThievesArmband.addStep(this.talkedToKatrine, this.tryToEnterTrobertHouse);
            this.getThievesArmband.setLockingCondition(this.finishedBlackArm);
        } else {
            this.thievesArmband.setTooltip("You can get another from Straven in the Phoenix Gang base.");
            this.getThievesArmband = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterPhoenixBase, new Requirement[0]);
            this.getThievesArmband.addStep(new Conditions(this.candlestick, this.inPhoenixBase), this.bringCandlestickToStraven);
            this.getThievesArmband.addStep(this.candlestick, this.enterPhoenixBaseAgain);
            this.getThievesArmband.addStep(this.unlockedCandlestickPhoenix, this.getCandlestick);
            this.getThievesArmband.addStep(this.inSecretRoom, this.killGrip);
            this.getThievesArmband.addStep(new Conditions(this.inGarden, this.miscKey), this.useKeyOnDoor);
            this.getThievesArmband.addStep(new Conditions(this.talkedToCharlie, this.miscKey), this.pushWall);
            this.getThievesArmband.addStep(new Conditions(this.talkedToAlfonse, this.miscKey), this.talkToCharlie);
            this.getThievesArmband.addStep(this.talkedToAlfonse, this.getKeyFromPartner);
            this.getThievesArmband.addStep(this.talkedToStraven, this.talkToAlfonse);
            this.getThievesArmband.addStep(this.inPhoenixBase, this.talkToStraven);
            this.getThievesArmband.setLockingCondition(this.finishedPhoenix);
        }
        this.getIceGloves = new ConditionalStep((QuestHelper)this, (QuestStep)this.mineEntranceRocks, new Requirement[0]);
        this.getIceGloves.addStep(this.iceGlovesNearby, this.pickupIceGloves);
        this.getIceGloves.addStep(this.inThroneRoom, this.killIceQueen);
        this.getIceGloves.addStep(this.inIceAboveGround2, this.takeLadder5Down);
        this.getIceGloves.addStep(this.inIceUndergroundRoom2, this.takeLadder4Up);
        this.getIceGloves.addStep(this.inIceAboveGround1, this.takeLadder3Down);
        this.getIceGloves.addStep(this.inIceUndergroundRoom1, this.takeLadder2Up);
        this.getIceGloves.addStep(this.inIceEntrance, this.takeLadder1Down);
        this.getIceGloves.setLockingCondition(this.iceGloves);
        this.getFireFeather = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToEntrana, new Requirement[0]);
        this.getFireFeather.addStep(this.fireFeatherNearby, this.pickupFireFeather);
        this.getFireFeather.addStep(this.onEntrana, this.killFireBird);
        this.getFireFeather.setLockingCondition(this.fireFeather);
        ConditionalStep wholeQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.getLavaEel, new Requirement[0]);
        wholeQuest.addStep(new Conditions(this.lavaEel, this.thievesArmband, this.iceGloves, this.fireFeather), this.finishQuest);
        wholeQuest.addStep(new Conditions(this.lavaEel, this.thievesArmband, this.iceGloves), this.getFireFeather);
        wholeQuest.addStep(new Conditions(this.lavaEel, this.thievesArmband), this.getIceGloves);
        wholeQuest.addStep(this.lavaEel, this.getThievesArmband);
        steps.put(1, wholeQuest);
        steps.put(2, wholeQuest);
        steps.put(3, wholeQuest);
        steps.put(4, wholeQuest);
        steps.put(5, wholeQuest);
        steps.put(6, wholeQuest);
        steps.put(7, wholeQuest);
        steps.put(8, wholeQuest);
        steps.put(9, wholeQuest);
        steps.put(10, wholeQuest);
        steps.put(11, wholeQuest);
        steps.put(12, wholeQuest);
        steps.put(13, wholeQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.iceGloves = new ItemRequirement("Ice gloves/Smiths gloves (i)", 1580).isNotConsumed();
        this.iceGloves.canBeObtainedDuringQuest();
        this.iceGloves.addAlternates(27031);
        this.equippedIceGloves = new ItemRequirement("Ice gloves/Smiths gloves (i)", 1580, 1, true).isNotConsumed();
        this.equippedIceGloves.addAlternates(27031);
        this.fishingRod = new ItemRequirement("Fishing rod", 307).isNotConsumed();
        this.fishingRod.addAlternates(1585);
        this.fishingBait = new ItemRequirement("Fishing bait", 313);
        this.jailKey = new ItemRequirement("Jail key", 1591).isNotConsumed();
        this.dustyKey = new KeyringRequirement("Dusty Key", this.configManager, KeyringCollection.DUSTY_KEY).isNotConsumed();
        this.dustyKeyHint = new KeyringRequirement("Dusty key (obtainable in quest)", this.configManager, KeyringCollection.DUSTY_KEY).isNotConsumed();
        this.harralanderUnf = new ItemRequirement("Harralander potion (unf)", 97);
        this.pickaxe = new ItemRequirement("Any pickaxe", 1265).isNotConsumed();
        this.pickaxe.addAlternates(ItemCollections.PICKAXES);
        this.blamishSlime = new ItemRequirement("Blamish snail slime", 1581);
        this.blamishOil = new ItemRequirement("Blamish oil", 1582);
        this.oilRod = new ItemRequirement("Oily fishing rod", 1585).isNotConsumed();
        this.lavaEel = new ItemRequirement("Lava eel", 2149);
        this.rawLavaEel = new ItemRequirement("Raw lava eel", 2148);
        this.thievesArmband = new ItemRequirement("Thieves' armband", 1579);
        this.rangedMage = new ItemRequirement("A ranged or magic attack method", -1, -1).isNotConsumed();
        this.rangedMage.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.miscKey = new ItemRequirement("Miscellaneous key", 1586);
        this.blackFullHelm = new ItemRequirement("Black full helm", 1165, 1, true).isNotConsumed();
        this.blackPlatebody = new ItemRequirement("Black platebody", 1125, 1, true).isNotConsumed();
        this.blackPlatelegs = new ItemRequirement("Black platelegs", 1077, 1, true).isNotConsumed();
        this.idPapers = new ItemRequirement("Id papers", 1584);
        this.idPapers.setTooltip("You can get another from Trobert in the building in east Brimhaven.");
        this.candlestick = new ItemRequirement("Pete's candlestick", 1577);
        this.gripsKey = new ItemRequirement("Grip's keyring", 1588);
        this.fireFeather = new ItemRequirement("Fire feather", 1583);
        this.combatGear = new ItemRequirement("Weapons, armour and food for the Ice Queen", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.antifireShield = new ItemRequirement("Anti-dragon shield", 1540).isNotConsumed();
        this.burthorpeTeleport = new ItemRequirement("Burthorpe teleport", ItemCollections.GAMES_NECKLACES);
        this.taverleyTeleport = new ItemRequirement("Taverley teleport", 11742);
        this.taverleyTeleport.addAlternates(8009);
        this.brimhavenTeleport = new ItemRequirement("Brimhaven teleport, or travel by boat from Ardougne/Port Sarim for 30gp", 11745);
        this.portSarimTeleport = new ItemRequirement("Port Sarim teleport (Explorer's ring 2/3/4, Amulet of Glory to Draynor)", 13128);
        this.portSarimTeleport.addAlternates(13127, 13126, 13125);
        this.portSarimTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.setupConditions();
    }

    public void loadZones() {
        this.taverleyDungeon = new Zone(new WorldPoint(2816, 9668, 0), new WorldPoint(2973, 9855, 0));
        this.deepTaverleyDungeon1 = new Zone(new WorldPoint(2816, 9856, 0), new WorldPoint(2880, 9760, 0));
        this.deepTaverleyDungeon2 = new Zone(new WorldPoint(2880, 9760, 0), new WorldPoint(2907, 9793, 0));
        this.deepTaverleyDungeon3 = new Zone(new WorldPoint(2889, 9793, 0), new WorldPoint(2923, 9815, 0));
        this.deepTaverleyDungeon4 = new Zone(new WorldPoint(2907, 9772, 0), new WorldPoint(2928, 9793, 0));
        this.jailCell = new Zone(new WorldPoint(2928, 9683, 0), new WorldPoint(2934, 9689, 0));
        this.phoenixEntry = new Zone(new WorldPoint(3239, 9780, 0), new WorldPoint(3249, 9786, 0));
        this.phoenixBase = new Zone(new WorldPoint(3232, 9761, 0), new WorldPoint(3254, 9785, 0));
        this.garden1 = new Zone(new WorldPoint(2783, 3194, 0), new WorldPoint(2797, 3199, 1));
        this.garden2 = new Zone(new WorldPoint(2780, 3188, 0), new WorldPoint(2786, 3196, 0));
        this.secretRoom = new Zone(new WorldPoint(2780, 3197, 0), new WorldPoint(2782, 3198, 0));
        this.treasureRoom = new Zone(new WorldPoint(2764, 3196, 0), new WorldPoint(2769, 3199, 0));
        this.iceEntrance = new Zone(new WorldPoint(2840, 3512, 0), new WorldPoint(2851, 3522, 0));
        this.iceRoom1P1 = new Zone(new WorldPoint(2811, 9897, 0), new WorldPoint(2841, 9908, 0));
        this.iceRoom1P2 = new Zone(new WorldPoint(2832, 9907, 0), new WorldPoint(2853, 9965, 0));
        this.iceRoom1P3 = new Zone(new WorldPoint(2811, 9907, 0), new WorldPoint(2824, 9942, 0));
        this.iceRoom2P1 = new Zone(new WorldPoint(2825, 9909, 0), new WorldPoint(2829, 9970, 0));
        this.iceRoom2P2 = new Zone(new WorldPoint(2854, 9908, 0), new WorldPoint(2878, 9918, 0));
        this.iceRoom2P3 = new Zone(new WorldPoint(2878, 9920, 0), new WorldPoint(2899, 9977, 0));
        this.iceRoom2P4 = new Zone(new WorldPoint(2826, 9965, 0), new WorldPoint(2888, 9977, 0));
        this.iceUp1P1 = new Zone(new WorldPoint(2799, 3500, 0), new WorldPoint(2811, 3515, 0));
        this.iceUp1P2 = new Zone(new WorldPoint(2811, 3503, 0), new WorldPoint(2828, 3514, 0));
        this.iceUp1P3 = new Zone(new WorldPoint(2811, 3514, 0), new WorldPoint(2823, 3518, 0));
        this.iceUp1P4 = new Zone(new WorldPoint(2823, 3514, 0), new WorldPoint(2825, 3516, 0));
        this.iceUp2 = new Zone(new WorldPoint(2852, 3515, 0), new WorldPoint(2862, 3522, 0));
        this.iceThrone1 = new Zone(new WorldPoint(2857, 9919, 0), new WorldPoint(2873, 9965, 0));
        this.iceThrone2 = new Zone(new WorldPoint(2874, 9937, 0), new WorldPoint(2879, 9965, 0));
        this.iceThrone3 = new Zone(new WorldPoint(2860, 9917, 0), new WorldPoint(2866, 9918, 0));
        this.entrana = new Zone(new WorldPoint(2798, 3327, 0), new WorldPoint(2878, 3394, 1));
    }

    public void setupConditions() {
        this.inTaverleyDungeon = new ZoneRequirement(this.taverleyDungeon);
        this.inDeepTaverleyDungeon = new ZoneRequirement(this.deepTaverleyDungeon1, this.deepTaverleyDungeon2, this.deepTaverleyDungeon3, this.deepTaverleyDungeon4);
        this.inJailCell = new ZoneRequirement(this.jailCell);
        this.has70Agility = new SkillRequirement(Skill.AGILITY, 70);
        this.talkedToKatrine = new VarplayerRequirement(188, 7, Operation.GREATER_EQUAL);
        this.blackArmGangDoorUnlocked = new VarplayerRequirement(188, 8, Operation.GREATER_EQUAL);
        this.gottenPapers = new VarplayerRequirement(188, 9, Operation.GREATER_EQUAL);
        this.enteredMansion = new VarplayerRequirement(188, 10, Operation.GREATER_EQUAL);
        this.talkedToGrip = new VarplayerRequirement(188, 11, Operation.GREATER_EQUAL);
        this.unlockedCandlestickBlackArm = new VarplayerRequirement(188, 12);
        this.finishedBlackArm = new VarplayerRequirement(188, 13, Operation.GREATER_EQUAL);
        this.talkedToStraven = new VarplayerRequirement(188, 2, Operation.GREATER_EQUAL);
        this.talkedToAlfonse = new VarplayerRequirement(188, 3, Operation.GREATER_EQUAL);
        this.talkedToCharlie = new VarplayerRequirement(188, 4, Operation.GREATER_EQUAL);
        this.unlockedCandlestickPhoenix = new VarplayerRequirement(188, 5, Operation.GREATER_EQUAL);
        this.finishedPhoenix = new VarplayerRequirement(188, 6, Operation.GREATER_EQUAL);
        this.inSecretRoom = new ZoneRequirement(this.secretRoom);
        this.inGarden = new ZoneRequirement(this.garden1, this.garden2);
        this.gripsKeyOnFloor = new ItemOnTileRequirement(this.gripsKey);
        this.inTreasureRoom = new ZoneRequirement(this.treasureRoom);
        this.chestOpen = new ObjectCondition(2633);
        this.inBlackArmGang = new VarplayerRequirement(146, 4, Operation.GREATER_EQUAL);
        this.inPhoenixBase = new ZoneRequirement(this.phoenixBase, this.phoenixEntry);
        this.inIceEntrance = new ZoneRequirement(this.iceEntrance);
        this.inIceUndergroundRoom1 = new ZoneRequirement(this.iceRoom1P1, this.iceRoom1P2, this.iceRoom1P3);
        this.inIceUndergroundRoom2 = new ZoneRequirement(this.iceRoom2P1, this.iceRoom2P2, this.iceRoom2P3, this.iceRoom2P4);
        this.inIceAboveGround1 = new ZoneRequirement(this.iceUp1P1, this.iceUp1P2, this.iceUp1P3, this.iceUp1P4);
        this.inIceAboveGround2 = new ZoneRequirement(this.iceUp2);
        this.inThroneRoom = new ZoneRequirement(this.iceThrone1, this.iceThrone2, this.iceThrone3);
        this.iceGlovesNearby = new ItemOnTileRequirement(1580);
        this.fireFeatherNearby = new ItemOnTileRequirement(1583);
        this.onEntrana = new ZoneRequirement(this.entrana);
    }

    public void setupSteps() {
        this.talkToAchietties = new NpcStep((QuestHelper)this, 4923, new WorldPoint(2904, 3511, 0), "Talk to Achietties outside the Heroes' Guild, south of Burthorpe.", new Requirement[0]);
        this.talkToAchietties.addDialogStep("I'm a hero, may I apply to join?");
        this.talkToAchietties.addDialogStep("I'll start looking for all those things then.");
        this.talkToAchietties.addTeleport(this.burthorpeTeleport);
        this.talkToGerrant = new NpcStep((QuestHelper)this, 2891, new WorldPoint(3013, 3224, 0), "You need to get an oily rod. Talk to Gerrant in Port Sarim to get some slime.", new Requirement[0]);
        this.talkToGerrant.addDialogStep("I want to find out how to catch a lava eel.");
        this.talkToGerrant.addTeleport(this.portSarimTeleport);
        this.makeBlamishOil = new ItemStep((QuestHelper)this, "Combine the harralander potion (unf) with the blamish snail slime.", this.harralanderUnf.highlighted(), this.blamishSlime.highlighted());
        this.useOilOnRod = new ItemStep((QuestHelper)this, "Use the Blamish oil on your fishing rod.", this.blamishOil.highlighted(), this.fishingRod.highlighted());
        this.enterTaverleyDungeon = this.client.getRealSkillLevel(Skill.AGILITY) >= 70 ? new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. As you're 70 Agility, you don't need a dusty key.", this.oilRod, this.fishingBait) : new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. Bring a dusty key if you have one, otherwise you can get one in the dungeon.", this.oilRod, this.fishingBait, this.dustyKey);
        this.enterTaverleyDungeon.addTeleport(this.taverleyTeleport);
        this.goThroughPipe = new ObjectStep((QuestHelper)this, 16509, new WorldPoint(2888, 9799, 0), "Squeeze through the obstacle pipe.", new Requirement[0]);
        this.killJailerForKey = new NpcStep((QuestHelper)this, 300, new WorldPoint(2930, 9692, 0), "Travel through Taverley Dungeon until you reach the Black Knights' Base. Kill the Jailer in the east side of the base for a jail key.", new Requirement[0]);
        this.getDustyFromAdventurer = new NpcStep((QuestHelper)this, 4925, new WorldPoint(2930, 9685, 0), "Use the jail key on the south door and talk to Velrak for a dusty key.", this.jailKey);
        this.getDustyFromAdventurer.addDialogStep("So... do you know anywhere good to explore?");
        this.enterDeeperTaverley = new ObjectStep((QuestHelper)this, 2623, new WorldPoint(2924, 9803, 0), "Enter the gate to the deeper Taverley dungeon.", this.dustyKey);
        this.fishLavaEel = new NpcStep((QuestHelper)this, 4928, new WorldPoint(2898, 9764, 0), "Fish a lava eel from the lava south of the blue dragons.", this.oilRod, this.fishingBait);
        this.cookLavaEel = new DetailedQuestStep((QuestHelper)this, "Cook the Lava Eel at a range. You cannot fail this.", this.rawLavaEel);
        this.enterTaverleyDungeon.addSubSteps(this.goThroughPipe, this.killJailerForKey, this.getDustyFromAdventurer, this.enterDeeperTaverley);
        this.talkToKatrine = new NpcStep((QuestHelper)this, 5210, new WorldPoint(3185, 3385, 0), "Talk to Katrine at the Black Arm Gang base in South west Varrock.", new Requirement[0]);
        this.talkToKatrine.addDialogStep("Is there any way I can get the rank of master thief?");
        this.talkToKatrine.addTeleport(this.varrockTeleport);
        this.tryToEnterTrobertHouse = new ObjectStep((QuestHelper)this, 2626, new WorldPoint(2811, 3170, 0), "Try to enter the house in east Brimhaven.", new Requirement[0]);
        this.tryToEnterTrobertHouse.addDialogStep("Four leaved clover.");
        this.tryToEnterTrobertHouse.addTeleport(this.brimhavenTeleport);
        this.talkToTrobert = new NpcStep((QuestHelper)this, 4917, new WorldPoint(2807, 3174, 0), "Talk to Trobert inside.", new Requirement[0]);
        this.talkToTrobert.addDialogStep("So can you help me get Scarface Pete's candlesticks?");
        this.talkToTrobert.addDialogStep("I volunteer to undertake that mission!");
        this.enterMansion = new ObjectStep((QuestHelper)this, 2627, new WorldPoint(2774, 3187, 0), "Equip your black armour and enter the mansion in the north west of Brimhaven.", this.idPapers, this.blackFullHelm, this.blackPlatebody, this.blackPlatelegs);
        this.talkToGrip = new NpcStep((QuestHelper)this, 4919, new WorldPoint(2775, 3192, 0), "Talk to Grip.", this.idPapers);
        this.getKeyFromGrip = new ObjectStep((QuestHelper)this, 2635, new WorldPoint(2776, 3196, 0), "Get a miscellaneous key from Grip then give it to your partner. Once you've done that, wait for your partner to enter the north east room of the mansion.After that, search the cupboard in the north room to lure Grip there. Your partner should kill them.", new Requirement[0]);
        this.getKeyFromGrip.addDialogStep("So what do my duties involve?");
        this.getKeyFromGrip.addDialogStep("Anything I can do now?");
        this.getKeyFromGrip.addDialogStep("He won't notice me having a quick look.");
        this.pickupKey = new DetailedQuestStep((QuestHelper)this, "Pick up Grip's keyring", this.gripsKey);
        this.enterTreasureRoom = new ObjectStep((QuestHelper)this, 2621, new WorldPoint(2764, 3197, 0), "Use Grip's keyring on the treasure room door.", this.gripsKey.highlighted());
        this.enterTreasureRoom.addIcon(1588);
        this.searchChest = new ObjectStep((QuestHelper)this, 2632, new WorldPoint(2766, 3199, 0), "Search the chest in the treasure room for two candlesticks.", new Requirement[0]);
        ((ObjectStep)this.searchChest).addAlternateObjects(2633);
        this.returnToKatrine = new NpcStep((QuestHelper)this, 5210, new WorldPoint(3185, 3385, 0), "Give one of Pete's candlesticks to your partner. Afterwards, return to Katrine with Pete's candlestick", this.candlestick);
        this.returnToKatrine.addDialogStep("I have a candlestick now.");
        this.returnToKatrine.addTeleport(this.varrockTeleport);
        this.enterPhoenixBase = new ObjectStep((QuestHelper)this, 11803, new WorldPoint(3244, 3383, 0), "Head into the Phoenix Gang's base in south Varrock.", new Requirement[0]);
        this.enterPhoenixBase.addTeleport(this.varrockTeleport);
        this.talkToStraven = new NpcStep((QuestHelper)this, 5212, new WorldPoint(3247, 9781, 0), "Talk to Straven.", new Requirement[0]);
        this.talkToAlfonse = new NpcStep((QuestHelper)this, 4920, new WorldPoint(2792, 3186, 0), "Talk to Alfonse the Waiter in the restaurant in Brimhaven.", this.rangedMage);
        this.talkToAlfonse.addTeleport(this.brimhavenTeleport);
        this.talkToAlfonse.addDialogStep("Do you sell Gherkins?");
        this.getKeyFromPartner = new ItemStep((QuestHelper)this, "You'll need your partner to give you a miscellaneous key.", this.miscKey);
        this.getKeyFromPartner.hideRequirements = true;
        this.talkToCharlie = new NpcStep((QuestHelper)this, 4921, new WorldPoint(2790, 3191, 0), "Talk to Charlie the Cook in the back of the restaurant.", new Requirement[0]);
        this.talkToCharlie.addDialogStep("I'm looking for a gherkin...");
        this.talkToCharlie.addDialogStep("I want to steal Scarface Pete's candlesticks.");
        this.pushWall = new ObjectStep((QuestHelper)this, 2629, new WorldPoint(2787, 3190, 0), "Push the wall to enter Pete's garden.", new Requirement[0]);
        this.useKeyOnDoor = new ObjectStep((QuestHelper)this, 2622, new WorldPoint(2781, 3197, 0), "Use the misc key on the door to the north west.", this.miscKey.highlighted());
        this.useKeyOnDoor.addIcon(1586);
        this.killGrip = new NpcStep((QuestHelper)this, 4919, new WorldPoint(2775, 3192, 0), "Wait for your partner to lure Grip into the room next to yours, and kill him with magic/ranged. Afterwards, trade your partner for a candlestick.", new Requirement[0]);
        this.getCandlestick = new ItemStep((QuestHelper)this, "Get your candlestick from your partner.", this.candlestick);
        this.getCandlestick.hideRequirements = true;
        this.killGrip.addSubSteps(this.getCandlestick);
        this.enterPhoenixBaseAgain = new ObjectStep((QuestHelper)this, 11803, new WorldPoint(3244, 3383, 0), "Bring the candlestick back to Straven.", new Requirement[0]);
        this.enterPhoenixBaseAgain.addTeleport(this.varrockTeleport);
        this.bringCandlestickToStraven = new NpcStep((QuestHelper)this, 5212, new WorldPoint(3247, 9781, 0), "Bring the candlestick back to Straven.", new Requirement[0]);
        this.bringCandlestickToStraven.addSubSteps(this.enterPhoenixBaseAgain);
        this.mineEntranceRocks = new ObjectStep((QuestHelper)this, 2634, new WorldPoint(2839, 3518, 0), "Head to White Wolf Mountain, and mine a rockslide in the northern part.", this.pickaxe);
        this.mineEntranceRocks.addTeleport(this.taverleyTeleport);
        this.takeLadder1Down = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2848, 3513, 0), "Take the south east ladder down.", new Requirement[0]);
        this.takeLadder2Up = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2824, 9907, 0), "Follow the tunnel south, then go up the ladder there.", new Requirement[0]);
        this.takeLadder3Down = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2827, 3510, 0), "Take the east ladder down.", new Requirement[0]);
        this.takeLadder4Up = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2857, 9917, 0), "Follow the path around until you reach a ladder, then climb it.", new Requirement[0]);
        this.takeLadder5Down = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2859, 3519, 0), "Take the south ladder down.", new Requirement[0]);
        this.killIceQueen = new NpcStep((QuestHelper)this, 4922, new WorldPoint(2865, 9948, 0), "Kill the Ice Queen for ice gloves.", new Requirement[0]);
        this.pickupIceGloves = new DetailedQuestStep((QuestHelper)this, "Pick up the ice gloves.", this.iceGloves);
        this.killIceQueen.addSubSteps(this.pickupIceGloves);
        this.goToEntrana = new NpcStep((QuestHelper)this, 1167, new WorldPoint(3047, 3236, 0), "Travel to Entrana with the monks in Port Sarim.", this.equippedIceGloves);
        this.goToEntrana.addTeleport(this.portSarimTeleport);
        this.killFireBird = new NpcStep((QuestHelper)this, 4927, new WorldPoint(2840, 3374, 0), "Kill the entrana firebird on the north of Entrana.", this.equippedIceGloves);
        this.pickupFireFeather = new ItemStep((QuestHelper)this, "Pick up the fire feather.", this.fireFeather);
        this.finishQuest = new NpcStep((QuestHelper)this, 4923, new WorldPoint(2904, 3511, 0), "Bring Achietties all the items to finish.", this.fireFeather, this.thievesArmband, this.lavaEel);
        this.finishQuest.addTeleport(this.burthorpeTeleport);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Ice Queen (level 111) for ice gloves");
        if (!this.inBlackArmGang.check(this.client)) {
            reqs.add("Grip (level 26)");
        }
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.fishingRod);
        reqs.add(this.fishingBait);
        reqs.add(this.harralanderUnf);
        reqs.add(this.pickaxe);
        reqs.add(this.iceGloves);
        if (this.inBlackArmGang.check(this.client)) {
            reqs.add(this.blackFullHelm);
            reqs.add(this.blackPlatebody);
            reqs.add(this.blackPlatelegs);
        } else {
            reqs.add(this.rangedMage);
        }
        if (this.client.getRealSkillLevel(Skill.AGILITY) < 70) {
            reqs.add(this.dustyKeyHint);
        }
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.combatGear);
        reqs.add(this.varrockTeleport);
        reqs.add(this.antifireShield);
        reqs.add(this.burthorpeTeleport.quantity(2));
        reqs.add(this.taverleyTeleport.quantity(2));
        reqs.add(this.varrockTeleport.quantity(2));
        reqs.add(this.portSarimTeleport.quantity(2));
        reqs.add(this.brimhavenTeleport);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.ATTACK, 3075), new ExperienceReward(Skill.DEFENCE, 3075), new ExperienceReward(Skill.STRENGTH, 3075), new ExperienceReward(Skill.RANGED, 2075), new ExperienceReward(Skill.HITPOINTS, 3075), new ExperienceReward(Skill.FISHING, 2725), new ExperienceReward(Skill.COOKING, 2825), new ExperienceReward(Skill.WOODCUTTING, 1575), new ExperienceReward(Skill.FIREMAKING, 1575), new ExperienceReward(Skill.SMITHING, 2257), new ExperienceReward(Skill.MINING, 2275), new ExperienceReward(Skill.HERBLORE, 1325));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Hero's Guild."), new UnlockReward("Ability to use the Fountain of Rune."), new UnlockReward("Ability to use Charge Dragonstone Jewellery scrolls."), new UnlockReward("Ability to purchase and equip Dragon Battleaxes and Maces."));
    }

    @Override
    public List<String> getNotes() {
        ArrayList<String> reqs = new ArrayList<String>();
        if (this.inBlackArmGang.check(this.client)) {
            reqs.add("You will need to find another player who joined the Phoenix Gang during the Shield of Arrav quest to assist you. If one of you is an Ironman, you can use the necessary items on one another to trade them.");
        } else {
            reqs.add("You will need to find another player who joined the Black Arm Gang during the Shield of Arrav quest to assist you. If one of you is an Ironman, you can use the necessary items on one another to trade them.");
        }
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails firstPanel = new PanelDetails("Start the quest", Collections.singletonList(this.talkToAchietties), Collections.singletonList(this.burthorpeTeleport));
        PanelDetails secondPanel = new PanelDetails("Get the Lava Eel", Arrays.asList(this.talkToGerrant, this.makeBlamishOil, this.useOilOnRod, this.enterTaverleyDungeon, this.fishLavaEel, this.cookLavaEel), Arrays.asList(this.harralanderUnf, this.fishingRod, this.fishingBait, this.dustyKey), Arrays.asList(this.portSarimTeleport, this.taverleyTeleport));
        secondPanel.setLockingStep(this.getLavaEel);
        PanelDetails thirdPanel = this.inBlackArmGang.check(this.client) ? new PanelDetails("Get thieves' armband", Arrays.asList(this.talkToKatrine, this.tryToEnterTrobertHouse, this.talkToTrobert, this.enterMansion, this.talkToGrip, this.getKeyFromGrip, this.pickupKey, this.enterTreasureRoom, this.searchChest, this.returnToKatrine), Arrays.asList(this.blackFullHelm, this.blackPlatebody, this.blackPlatelegs), Arrays.asList(this.varrockTeleport.quantity(2), this.brimhavenTeleport)) : new PanelDetails("Get thieves' armband", Arrays.asList(this.talkToStraven, this.talkToAlfonse, this.getKeyFromPartner, this.talkToCharlie, this.pushWall, this.useKeyOnDoor, this.killGrip, this.bringCandlestickToStraven), Collections.singletonList(this.rangedMage), Arrays.asList(this.varrockTeleport.quantity(2), this.brimhavenTeleport));
        thirdPanel.setLockingStep(this.getThievesArmband);
        PanelDetails fourthPanel = new PanelDetails("Get ice gloves", Arrays.asList(this.mineEntranceRocks, this.takeLadder1Down, this.takeLadder2Up, this.takeLadder3Down, this.takeLadder4Up, this.takeLadder5Down, this.killIceQueen), Collections.singletonList(this.pickaxe), Collections.singletonList(this.taverleyTeleport));
        fourthPanel.setLockingStep(this.getIceGloves);
        PanelDetails fifthPanel = new PanelDetails("Get fire feather", Arrays.asList(this.goToEntrana, this.killFireBird), Collections.singletonList(this.iceGloves), Collections.singletonList(this.portSarimTeleport));
        fifthPanel.setLockingStep(this.getFireFeather);
        PanelDetails sixthPanel = new PanelDetails("Finish off", Collections.singletonList(this.finishQuest), Arrays.asList(this.fireFeather, this.thievesArmband, this.lavaEel), Collections.singletonList(this.burthorpeTeleport));
        allSteps.add(firstPanel);
        allSteps.add(secondPanel);
        allSteps.add(thirdPanel);
        allSteps.add(fourthPanel);
        allSteps.add(fifthPanel);
        allSteps.add(sixthPanel);
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        return Collections.singletonList(new ItemRequirement("Another player", -1, -1));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestPointRequirement(55));
        req.add(new SkillRequirement(Skill.COOKING, 53, true));
        req.add(new SkillRequirement(Skill.FISHING, 53, true));
        req.add(new SkillRequirement(Skill.HERBLORE, 25, true));
        req.add(new SkillRequirement(Skill.MINING, 50, true));
        if (this.isInBlackArmGang) {
            req.add(new QuestRequirement(QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG, QuestState.FINISHED));
        } else {
            req.add(new QuestRequirement(QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG, QuestState.FINISHED));
        }
        req.add(new QuestRequirement(QuestHelperQuest.LOST_CITY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.MERLINS_CRYSTAL, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.DRAGON_SLAYER_I, QuestState.FINISHED));
        return req;
    }
}

