/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.hazeelcult;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.ManualRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class HazeelValves
extends DetailedOwnerStep {
    DetailedQuestStep turnValve1;
    DetailedQuestStep turnValve2;
    DetailedQuestStep turnValve3;
    DetailedQuestStep turnValve4;
    DetailedQuestStep turnValve5;
    DetailedQuestStep turnValve1NoDialog;
    DetailedQuestStep turnValve2NoDialog;
    DetailedQuestStep turnValve3NoDialog;
    DetailedQuestStep turnValve4NoDialog;
    DetailedQuestStep turnValve5NoDialog;
    private Zone valve1;
    private Zone valve2;
    private Zone valve3;
    private Zone valve4;
    private Zone valve5;
    private ZoneRequirement atValve1;
    private ZoneRequirement atValve2;
    private ZoneRequirement atValve3;
    private ZoneRequirement atValve4;
    private ZoneRequirement atValve5;
    private RuneliteRequirement solved1;
    private RuneliteRequirement solved2;
    private RuneliteRequirement solved3;
    private RuneliteRequirement solved4;
    private RuneliteRequirement solved5;
    public ManualRequirement solved;

    public HazeelValves(QuestHelper questHelper) {
        super(questHelper, "Turn the valves near the cave to direct the underground water.", new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        if (!this.solved1.check(this.client)) {
            if (this.atValve1.check(this.client)) {
                this.startUpStep(this.turnValve1);
            } else {
                this.startUpStep(this.turnValve1NoDialog);
            }
        } else if (!this.solved2.check(this.client)) {
            if (this.atValve2.check(this.client)) {
                this.startUpStep(this.turnValve2);
            } else {
                this.startUpStep(this.turnValve2NoDialog);
            }
        } else if (!this.solved3.check(this.client)) {
            if (this.atValve3.check(this.client)) {
                this.startUpStep(this.turnValve3);
            } else {
                this.startUpStep(this.turnValve3NoDialog);
            }
        } else if (!this.solved4.check(this.client)) {
            if (this.atValve4.check(this.client)) {
                this.startUpStep(this.turnValve4);
            } else {
                this.startUpStep(this.turnValve4NoDialog);
            }
        } else if (!this.solved5.check(this.client)) {
            if (this.atValve5.check(this.client)) {
                this.startUpStep(this.turnValve5);
            } else {
                this.startUpStep(this.turnValve5NoDialog);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Widget textContainingWidget;
        Widget currentStateWidget = this.client.getWidget(219, 1);
        String currentStateText = null;
        if (currentStateWidget != null && (textContainingWidget = currentStateWidget.getChild(0)) != null) {
            currentStateText = textContainingWidget.getText();
        }
        Widget wheelTurnedWidget = this.client.getWidget(229, 1);
        String wheelTurnedText = null;
        if (wheelTurnedWidget != null) {
            wheelTurnedText = wheelTurnedWidget.getText();
        }
        String text = null;
        if (wheelTurnedText != null) {
            text = wheelTurnedText;
        }
        if (currentStateText != null) {
            text = currentStateText;
        }
        if (text == null) {
            return;
        }
        boolean turnedLeft = text.contains("left");
        if (!turnedLeft && !text.contains("right")) {
            return;
        }
        if (this.atValve1.check(this.client)) {
            this.updateState(!turnedLeft, this.solved1);
        } else if (this.atValve2.check(this.client)) {
            this.updateState(!turnedLeft, this.solved2);
        } else if (this.atValve3.check(this.client)) {
            this.updateState(turnedLeft, this.solved3);
        } else if (this.atValve4.check(this.client)) {
            this.updateState(!turnedLeft, this.solved4);
        } else if (this.atValve5.check(this.client)) {
            this.updateState(!turnedLeft, this.solved5);
        }
        this.solved.setShouldPass(this.solved1.check(this.client) && this.solved2.check(this.client) && this.solved3.check(this.client) && this.solved4.check(this.client) && this.solved5.check(this.client));
        this.updateSteps();
    }

    private void updateState(boolean shouldPass, RuneliteRequirement req) {
        if (shouldPass) {
            req.setConfigValue("true");
        } else {
            req.setConfigValue("false");
        }
    }

    protected void setupZones() {
        this.valve1 = new Zone(new WorldPoint(2560, 3245, 0), new WorldPoint(2565, 3251, 0));
        this.valve2 = new Zone(new WorldPoint(2567, 3262, 0), new WorldPoint(2575, 3264, 0));
        this.valve3 = new Zone(new WorldPoint(2581, 3242, 0), new WorldPoint(2589, 3248, 0));
        this.valve4 = new Zone(new WorldPoint(2594, 3261, 0), new WorldPoint(2600, 3266, 0));
        this.valve5 = new Zone(new WorldPoint(2607, 3239, 0), new WorldPoint(2615, 3245, 0));
    }

    protected void setupConditions() {
        this.solved1 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "hazeelvalves1", "true");
        this.solved1.initWithValue("false");
        this.solved2 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "hazeelvalves2", "true");
        this.solved2.initWithValue("false");
        this.solved3 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "hazeelvalves3", "true");
        this.solved3.initWithValue("false");
        this.solved4 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "hazeelvalves4", "true");
        this.solved4.initWithValue("false");
        this.solved5 = new RuneliteRequirement(this.getQuestHelper().getConfigManager(), "hazeelvalves5", "true");
        this.solved5.initWithValue("false");
        this.atValve1 = new ZoneRequirement(this.valve1);
        this.atValve2 = new ZoneRequirement(this.valve2);
        this.atValve3 = new ZoneRequirement(this.valve3);
        this.atValve4 = new ZoneRequirement(this.valve4);
        this.atValve5 = new ZoneRequirement(this.valve5);
        this.solved = new ManualRequirement();
    }

    @Override
    protected void setupSteps() {
        this.setupZones();
        this.setupConditions();
        this.turnValve1 = new ObjectStep(this.getQuestHelper(), 2844, new WorldPoint(2562, 3247, 0), "Turn the valve west of the Clocktower to the right.", new Requirement[0]);
        this.turnValve1.addDialogStep("Turn it to the right.");
        this.turnValve2 = new ObjectStep(this.getQuestHelper(), 2845, new WorldPoint(2572, 3263, 0), "Turn the valve next to the Carnillean home to the right.", new Requirement[0]);
        this.turnValve2.addDialogStep("Turn it to the right.");
        this.turnValve3 = new ObjectStep(this.getQuestHelper(), 2846, new WorldPoint(2585, 3245, 0), "Turn the valve east of the Clocktower to the left.", new Requirement[0]);
        this.turnValve3.addDialogStep("Turn it to the left.");
        this.turnValve4 = new ObjectStep(this.getQuestHelper(), 2847, new WorldPoint(2597, 3263, 0), "Turn the valve next to the zoo to the right.", new Requirement[0]);
        this.turnValve4.addDialogStep("Turn it to the right.");
        this.turnValve5 = new ObjectStep(this.getQuestHelper(), 2848, new WorldPoint(2611, 3242, 0), "Turn the valve north of the monastery to the right.", new Requirement[0]);
        this.turnValve5.addDialogStep("Turn it to the right.");
        this.turnValve1NoDialog = new ObjectStep(this.getQuestHelper(), 2844, new WorldPoint(2562, 3247, 0), "Turn the valve west of the Clocktower to the right.", new Requirement[0]);
        this.turnValve1.addSubSteps(this.turnValve1NoDialog);
        this.turnValve2NoDialog = new ObjectStep(this.getQuestHelper(), 2845, new WorldPoint(2572, 3263, 0), "Turn the valve next to the Carnillean home to the right.", new Requirement[0]);
        this.turnValve2.addSubSteps(this.turnValve2NoDialog);
        this.turnValve3NoDialog = new ObjectStep(this.getQuestHelper(), 2846, new WorldPoint(2585, 3245, 0), "Turn the valve east of the Clocktower to the left.", new Requirement[0]);
        this.turnValve3.addSubSteps(this.turnValve3NoDialog);
        this.turnValve4NoDialog = new ObjectStep(this.getQuestHelper(), 2847, new WorldPoint(2597, 3263, 0), "Turn the valve next to the zoo to the right.", new Requirement[0]);
        this.turnValve4.addSubSteps(this.turnValve4NoDialog);
        this.turnValve5NoDialog = new ObjectStep(this.getQuestHelper(), 2848, new WorldPoint(2611, 3242, 0), "Turn the valve north of the monastery to the right.", new Requirement[0]);
        this.turnValve5.addSubSteps(this.turnValve5NoDialog);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.turnValve1, this.turnValve2, this.turnValve3, this.turnValve4, this.turnValve5, this.turnValve1NoDialog, this.turnValve2NoDialog, this.turnValve3NoDialog, this.turnValve4NoDialog, this.turnValve5NoDialog);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.turnValve1, this.turnValve2, this.turnValve3, this.turnValve4, this.turnValve5);
    }
}

