/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.hazeelcult;

import com.questhelper.helpers.quests.hazeelcult.HazeelValves;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HAZEEL_CULT)
public class HazeelCult
extends BasicQuestHelper {
    ItemRequirement ardougneCloak;
    ItemRequirement hazeelScroll;
    ItemRequirement poison;
    ItemRequirement carnilleanArmour;
    ItemRequirement key;
    ItemRequirement hazeelMark;
    Requirement inCultEntrance;
    Requirement inCultRoom;
    Requirement inManorBasement;
    Requirement inManorF1;
    Requirement inManorF2;
    Requirement talkedToCerilAfterPoison;
    Requirement armourNearby;
    Requirement hasHazeelItem;
    Requirement receivedMark;
    Requirement onStep7;
    Requirement givenAlmoneScroll;
    QuestStep talkToCeril;
    QuestStep enterCave;
    QuestStep talkToClivet;
    QuestStep leaveCaveForValves;
    QuestStep leaveCaveForPoison;
    QuestStep enterKitchen;
    QuestStep usePoisonOnRange;
    QuestStep leaveKitchen;
    QuestStep talkToCerilAfterPoison;
    QuestStep enterCaveAfterPoison;
    QuestStep talkToClivetAfterPoison;
    QuestStep boardRaftAfterPoison;
    QuestStep talkToAlomone;
    QuestStep returnOnRaftAfterAlmone;
    QuestStep leaveCaveAfterAlmone;
    QuestStep enterKitchenAfterButler;
    QuestStep searchCrateForKey;
    QuestStep leaveKitchenWithKey;
    QuestStep goToF1WithKey;
    QuestStep climbLadderWithKey;
    QuestStep searchChestForScroll;
    QuestStep goF2ToF1WithScroll;
    QuestStep goF1ToF0WithScroll;
    QuestStep enterCaveWithScroll;
    QuestStep boardRaftWithScroll;
    QuestStep giveAlmoneScroll;
    QuestStep enterCaveAfterValvesForCeril;
    QuestStep boardRaftToKill;
    QuestStep killAlomone;
    QuestStep pickupArmour;
    QuestStep returnOnRaftAfterKilling;
    QuestStep leaveCaveAfterKilling;
    QuestStep talkToJonesAfterKilling;
    QuestStep goUpToCeril;
    QuestStep talkToCerilAfterKilling;
    QuestStep goUpToCupboard;
    QuestStep searchCupboardForEvidence;
    HazeelValves valveStepsCeril;
    HazeelValves valveStepsHazeel;
    Zone cultEntrance;
    Zone cultRoom;
    Zone manorBasement;
    Zone manorF1;
    Zone manorF2;
    ConditionalStep cerilSteps;
    ConditionalStep hazeel4Steps;
    NpcCondition alomoneNearby;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToCeril);
        ConditionalStep goTalkToClivet = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        goTalkToClivet.addStep(this.inCultEntrance, this.talkToClivet);
        steps.put(2, goTalkToClivet);
        steps.put(3, goTalkToClivet);
        this.hazeel4Steps = new ConditionalStep((QuestHelper)this, this.enterKitchen, new Requirement[0]);
        this.hazeel4Steps.addStep(this.inManorBasement, this.usePoisonOnRange);
        this.hazeel4Steps.addStep(this.inCultEntrance, this.leaveCaveForPoison);
        ConditionalStep goTalkAfterPoison = new ConditionalStep((QuestHelper)this, this.talkToCerilAfterPoison, new Requirement[0]);
        goTalkAfterPoison.addStep(this.inManorBasement, this.leaveKitchen);
        ConditionalStep goTalkToClivetAfterPoison = new ConditionalStep((QuestHelper)this, (QuestStep)goTalkAfterPoison, new Requirement[0]);
        goTalkToClivetAfterPoison.addStep(new Conditions(this.inCultRoom, this.hazeelMark.alsoCheckBank(this.questBank)), this.talkToAlomone);
        goTalkToClivetAfterPoison.addStep(new Conditions(this.inCultEntrance, this.valveStepsHazeel.solved, this.hazeelMark.alsoCheckBank(this.questBank)), this.boardRaftAfterPoison);
        goTalkToClivetAfterPoison.addStep(new Conditions(this.inCultEntrance, this.valveStepsHazeel.solved), this.talkToClivetAfterPoison);
        goTalkToClivetAfterPoison.addStep(this.valveStepsHazeel.solved, this.enterCaveAfterPoison);
        goTalkToClivetAfterPoison.addStep(this.talkedToCerilAfterPoison, this.valveStepsHazeel);
        Conditions hadScroll = new Conditions(LogicType.OR, this.hazeelScroll.alsoCheckBank(this.questBank), this.givenAlmoneScroll);
        ConditionalStep goGetScroll = new ConditionalStep((QuestHelper)this, this.enterKitchenAfterButler, new Requirement[0]);
        goGetScroll.addStep(new Conditions(this.inCultRoom, hadScroll), this.giveAlmoneScroll);
        goGetScroll.addStep(new Conditions(this.inCultEntrance, hadScroll), this.boardRaftWithScroll);
        goGetScroll.addStep(new Conditions(this.inManorF1, hadScroll), this.goF1ToF0WithScroll);
        goGetScroll.addStep(new Conditions(this.inManorF2, hadScroll), this.goF2ToF1WithScroll);
        goGetScroll.addStep(new Conditions(hadScroll), this.enterCaveWithScroll);
        goGetScroll.addStep(new Conditions(this.inManorF2, this.key), this.searchChestForScroll);
        goGetScroll.addStep(new Conditions(this.inManorF1, this.key), this.climbLadderWithKey);
        goGetScroll.addStep(new Conditions(this.inManorBasement, this.key), this.leaveKitchenWithKey);
        goGetScroll.addStep(new Conditions(this.key), this.goToF1WithKey);
        goGetScroll.addStep(this.inManorBasement, this.searchCrateForKey);
        goGetScroll.addStep(this.inCultEntrance, this.leaveCaveAfterAlmone);
        goGetScroll.addStep(this.inCultRoom, this.returnOnRaftAfterAlmone);
        this.cerilSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.valveStepsCeril, new Requirement[0]);
        this.cerilSteps.addStep(new Conditions(this.onStep7, this.inManorF1), this.searchCupboardForEvidence);
        this.cerilSteps.addStep(this.onStep7, this.goUpToCupboard);
        this.cerilSteps.addStep(new Conditions(this.inManorF1, this.carnilleanArmour.alsoCheckBank(this.questBank)), this.talkToCerilAfterKilling);
        this.cerilSteps.addStep(new Conditions(this.inCultEntrance, this.carnilleanArmour.alsoCheckBank(this.questBank)), this.leaveCaveAfterKilling);
        this.cerilSteps.addStep(new Conditions(this.inCultRoom, this.carnilleanArmour.alsoCheckBank(this.questBank)), this.returnOnRaftAfterKilling);
        this.cerilSteps.addStep(new Conditions(this.carnilleanArmour.alsoCheckBank(this.questBank)), this.goUpToCeril);
        this.cerilSteps.addStep(new Conditions(this.inCultRoom), this.pickupArmour);
        this.cerilSteps.addStep(new Conditions(this.inCultRoom, this.alomoneNearby), this.killAlomone);
        this.cerilSteps.addStep(new Conditions(this.inCultEntrance, this.valveStepsCeril.solved), this.boardRaftToKill);
        this.cerilSteps.addStep(this.valveStepsCeril.solved, this.enterCaveAfterValvesForCeril);
        this.cerilSteps.addStep(this.inCultEntrance, this.leaveCaveForValves);
        this.cerilSteps.setLockingCondition(this.hasHazeelItem);
        ConditionalStep step4 = new ConditionalStep((QuestHelper)this, (QuestStep)this.cerilSteps, new Requirement[0]);
        step4.addStep(this.hasHazeelItem, this.hazeel4Steps);
        steps.put(4, step4);
        steps.put(5, goTalkToClivetAfterPoison);
        ConditionalStep step6And7 = new ConditionalStep((QuestHelper)this, (QuestStep)this.cerilSteps, new Requirement[0]);
        step6And7.addStep(this.hasHazeelItem, goGetScroll);
        steps.put(6, step6And7);
        steps.put(7, step6And7);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.givenAlmoneScroll = new VarbitRequirement(14780, 1);
        this.ardougneCloak = new ItemRequirement("Ardougne cloak for Monastery teleport", 13121).isNotConsumed();
        this.ardougneCloak.addAlternates(13122, 13123, 13124);
        this.poison = new ItemRequirement("Poison", 273);
        this.poison.setTooltip("You can get another from Clivet");
        this.hazeelScroll = new ItemRequirement("Hazeel scroll", 2403).hideConditioned(this.givenAlmoneScroll);
        this.carnilleanArmour = new ItemRequirement("Carnillean armour", 2405);
        this.key = new ItemRequirement("Chest key", 2404);
        this.hazeelMark = new ItemRequirement("Hazeel's mark", 2406);
        this.inCultEntrance = new ZoneRequirement(this.cultEntrance);
        this.inCultRoom = new ZoneRequirement(this.cultRoom);
        this.inManorBasement = new ZoneRequirement(this.manorBasement);
        this.inManorF1 = new ZoneRequirement(this.manorF1);
        this.inManorF2 = new ZoneRequirement(this.manorF2);
        this.alomoneNearby = new NpcCondition(12092);
        this.talkedToCerilAfterPoison = new VarbitRequirement(14775, 1);
        this.armourNearby = new ItemOnTileRequirement(this.carnilleanArmour);
        this.hasHazeelItem = new Conditions(true, LogicType.OR, this.poison.alsoCheckBank(this.questBank), this.hazeelScroll.alsoCheckBank(this.questBank), this.hazeelMark.alsoCheckBank(this.questBank), this.key.alsoCheckBank(this.questBank));
        this.receivedMark = new VarbitRequirement(14777, 1);
        this.onStep7 = new VarplayerRequirement(QuestVarPlayer.QUEST_HAZEEL_CULT.getId(), 7);
    }

    public void loadZones() {
        this.cultEntrance = new Zone(new WorldPoint(2565, 9679, 0), new WorldPoint(2571, 9685, 0));
        this.cultRoom = new Zone(new WorldPoint(2600, 9666, 0), new WorldPoint(2615, 9693, 0));
        this.manorF1 = new Zone(new WorldPoint(2564, 3267, 1), new WorldPoint(2576, 3275, 1));
        this.manorF2 = new Zone(new WorldPoint(2564, 3267, 2), new WorldPoint(2576, 3275, 2));
        this.manorBasement = new Zone(new WorldPoint(2535, 9692, 0), new WorldPoint(2550, 9703, 0));
    }

    public void setupSteps() {
        this.talkToCeril = new NpcStep((QuestHelper)this, 12085, new WorldPoint(2569, 3275, 0), "Talk to Ceril Carnillean in the south west of East Ardougne.", new Requirement[0]);
        this.talkToCeril.addDialogSteps("What's wrong?", "Yes.");
        this.enterCave = new ObjectStep((QuestHelper)this, 2852, new WorldPoint(2587, 3235, 0), "Enter the cave south east of the Clocktower.", new Requirement[0]);
        this.talkToClivet = new NpcStep((QuestHelper)this, 12095, new WorldPoint(2569, 9682, 0), "Talk to Clivet. You can choose to either side with him or with the Carnilleans.", new Requirement[0]);
        this.talkToClivet.addDialogSteps("Alright, I've made my decision.", "I have no more questions.", "What do you mean?");
        this.talkToClivet.addDialogChange("I won't help you.", "I won't help you. (side with Ceril)");
        this.talkToClivet.addDialogChange("Alright, how do I do it?", "Alright, how do I do it? (side with Hazeel)");
        this.talkToClivet.addDialogChange("I'll help you.", "I'll help you. (side with Hazeel)");
        this.leaveCaveForValves = new ObjectStep((QuestHelper)this, 2853, new WorldPoint(2571, 9684, 0), "Go back to the surface.", new Requirement[0]);
        this.valveStepsHazeel = new HazeelValves(this);
        this.valveStepsCeril = new HazeelValves(this);
        this.valveStepsCeril.addSubSteps(this.leaveCaveForValves);
        this.leaveCaveForPoison = new ObjectStep((QuestHelper)this, 2853, new WorldPoint(2571, 9684, 0), "Go back to the surface.", this.poison);
        this.enterKitchen = new ObjectStep((QuestHelper)this, 46717, new WorldPoint(2570, 3267, 0), "Climb down the ladder in the Carnillean house to the kitchen.", this.poison);
        this.usePoisonOnRange = new ObjectStep((QuestHelper)this, 2859, new WorldPoint(2538, 9699, 0), "Use the poison on the range.", this.poison.highlighted());
        this.usePoisonOnRange.addIcon(273);
        this.leaveKitchen = new ObjectStep((QuestHelper)this, 46716, new WorldPoint(2544, 9694, 0), "Leave the kitchen.", new Requirement[0]);
        this.talkToCerilAfterPoison = new NpcStep((QuestHelper)this, 12085, new WorldPoint(2569, 3275, 0), "Talk to Ceril Carnillean to confirm the results of the poison.", new Requirement[0]);
        this.enterCaveAfterPoison = new ObjectStep((QuestHelper)this, 2852, new WorldPoint(2587, 3235, 0), "Return to Clivet in the cave south of East Ardougne.", new Requirement[0]);
        this.talkToClivetAfterPoison = new NpcStep((QuestHelper)this, 12095, new WorldPoint(2569, 9682, 0), "Return to Clivet.", new Requirement[0]);
        this.talkToClivetAfterPoison.addSubSteps(this.enterCaveAfterPoison);
        this.boardRaftAfterPoison = new ObjectStep((QuestHelper)this, 2849, new WorldPoint(2568, 9679, 0), "Board the raft.", new Requirement[0]);
        this.talkToAlomone = new NpcStep((QuestHelper)this, 12092, new WorldPoint(2607, 9673, 0), "Talk to Alomone.", new Requirement[0]);
        this.returnOnRaftAfterAlmone = new ObjectStep((QuestHelper)this, 2849, new WorldPoint(2607, 9693, 0), "Search a crate in the Carnillean's kitchen for a key.", new Requirement[0]);
        this.leaveCaveAfterAlmone = new ObjectStep((QuestHelper)this, 2853, new WorldPoint(2571, 9684, 0), "Search a crate in the Carnillean's kitchen for a key.", new Requirement[0]);
        this.enterKitchenAfterButler = new ObjectStep((QuestHelper)this, 46717, new WorldPoint(2570, 3267, 0), "Search a crate in the Carnillean's basement kitchen for a key.", new Requirement[0]);
        this.searchCrateForKey = new ObjectStep((QuestHelper)this, 2858, new WorldPoint(2545, 9696, 0), "Search a crate in the Carnillean's basement kitchen for a key.", new Requirement[0]);
        this.searchCrateForKey.addSubSteps(this.returnOnRaftAfterAlmone, this.leaveCaveAfterAlmone, this.enterKitchenAfterButler);
        this.leaveKitchenWithKey = new ObjectStep((QuestHelper)this, 46716, new WorldPoint(2544, 9694, 0), "Go back upstairs from the kitchen.", this.key);
        this.goToF1WithKey = new ObjectStep((QuestHelper)this, 46704, new WorldPoint(2569, 3269, 0), "Go upstairs in the house.", this.key);
        this.climbLadderWithKey = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2573, 3271, 1), "Knock the wall to enter the hidden room, then climb up the ladder.", this.key);
        this.climbLadderWithKey.addDialogStep("Yes.");
        this.searchChestForScroll = new ObjectStep((QuestHelper)this, 46903, new WorldPoint(2571, 3269, 2), "Open the chest.", this.key.highlighted());
        this.searchChestForScroll.addIcon(2404);
        this.goF2ToF1WithScroll = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2573, 3271, 2), "Return to Almone with the scroll.", this.hazeelScroll);
        this.goF1ToF0WithScroll = new ObjectStep((QuestHelper)this, 46705, new WorldPoint(2569, 3269, 1), "Return to Almone with the scroll.", this.hazeelScroll);
        this.enterCaveWithScroll = new ObjectStep((QuestHelper)this, 2852, new WorldPoint(2587, 3235, 0), "Return to Almone with the scroll.", this.hazeelScroll);
        this.boardRaftWithScroll = new ObjectStep((QuestHelper)this, 2849, new WorldPoint(2568, 9679, 0), "Return to Almone with the scroll. If the raft doesn't go to Alomone, repeat the prior valve steps first.", this.hazeelScroll);
        this.giveAlmoneScroll = new NpcStep((QuestHelper)this, 12092, new WorldPoint(2607, 9673, 0), "Return to Almone with the scroll.", this.hazeelScroll);
        this.giveAlmoneScroll.addSubSteps(this.goF2ToF1WithScroll, this.goF1ToF0WithScroll, this.enterCaveWithScroll, this.boardRaftWithScroll);
        this.enterCaveAfterValvesForCeril = new ObjectStep((QuestHelper)this, 2852, new WorldPoint(2587, 3235, 0), "Re-enter the cave.", new Requirement[0]);
        this.boardRaftToKill = new ObjectStep((QuestHelper)this, 2849, new WorldPoint(2568, 9679, 0), "Board the raft.", new Requirement[0]);
        this.killAlomone = new NpcStep((QuestHelper)this, 12092, new WorldPoint(2607, 9673, 0), "Kill Almone.", new Requirement[0]);
        this.pickupArmour = new ObjectStep((QuestHelper)this, 46713, new WorldPoint(2611, 9674, 0), "Retrieve armour from the chest.", this.carnilleanArmour);
        this.returnOnRaftAfterKilling = new ObjectStep((QuestHelper)this, 2849, new WorldPoint(2607, 9693, 0), "Return to Ceril Carnillean.", this.carnilleanArmour);
        this.leaveCaveAfterKilling = new ObjectStep((QuestHelper)this, 2853, new WorldPoint(2571, 9684, 0), "Return to Ceril Carnillean.", this.carnilleanArmour);
        this.talkToJonesAfterKilling = new NpcStep((QuestHelper)this, 12089, new WorldPoint(2569, 3271, 0), "Talk to Butler Jones.", new Requirement[0]);
        this.goUpToCeril = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2569, 3269, 0), "Go upstairs in the house.", new Requirement[0]);
        this.talkToCerilAfterKilling = new NpcStep((QuestHelper)this, 12085, new WorldPoint(2572, 3268, 1), "Talk to Ceril upstairs in the house.", new Requirement[0]);
        this.talkToCerilAfterKilling.addSubSteps(this.returnOnRaftAfterKilling, this.leaveCaveAfterKilling, this.goUpToCeril);
        this.goUpToCupboard = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2569, 3269, 0), "Go upstairs in the house.", new Requirement[0]);
        this.searchCupboardForEvidence = new ObjectStep((QuestHelper)this, 2850, new WorldPoint(2574, 3267, 1), "Search the cupboard in the east room.", new Requirement[0]);
        ((ObjectStep)this.searchCupboardForEvidence).addAlternateObjects(2851);
        this.searchCupboardForEvidence.addSubSteps(this.goUpToCupboard);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.ardougneCloak);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Alomone (level 13) if taking Ceril's side");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 1500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("(2,005 if siding with Ceril) Coins", 995, 2000), new ItemReward("Hazeel's mark (if you sided with Hazeel)", 2406), new ItemReward("Carnillean armour (if you sided with Ceril)", 2405));
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("If you sided with Hazeel and are being guided to help Ceril, just click the box in the Ceril sidebar header to switch to Hazeel");
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToCeril, this.enterCave, this.talkToClivet), new Requirement[0]));
        ArrayList<QuestStep> cerilSteps = new ArrayList<QuestStep>(this.valveStepsCeril.getSteps());
        cerilSteps.addAll(Arrays.asList(this.enterCaveAfterValvesForCeril, this.boardRaftToKill, this.killAlomone, this.pickupArmour, this.talkToCerilAfterKilling, this.talkToJonesAfterKilling, this.searchCupboardForEvidence));
        PanelDetails cerilPanel = new PanelDetails("Siding with Ceril", cerilSteps, new Requirement[0]);
        cerilPanel.setLockingStep(this.cerilSteps);
        allSteps.add(cerilPanel);
        ArrayList<QuestStep> hazeelSteps = new ArrayList<QuestStep>(Arrays.asList(this.leaveCaveForPoison, this.enterKitchen, this.usePoisonOnRange, this.leaveKitchen, this.talkToCerilAfterPoison));
        hazeelSteps.addAll(this.valveStepsHazeel.getDisplaySteps());
        hazeelSteps.addAll(Arrays.asList(this.talkToClivetAfterPoison, this.boardRaftAfterPoison, this.talkToAlomone, this.searchCrateForKey, this.leaveKitchenWithKey, this.goToF1WithKey, this.climbLadderWithKey, this.searchChestForScroll, this.giveAlmoneScroll));
        allSteps.add(new PanelDetails("Siding with Hazeel", hazeelSteps, new Requirement[0]));
        return allSteps;
    }
}

