/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.hauntedmine;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.HAUNTED_MINE)
public class HauntedMine
extends BasicQuestHelper {
    ItemRequirement zealotsKey;
    ItemRequirement chisel;
    ItemRequirement glowingFungus;
    ItemRequirement glowingFungusHighlight;
    ItemRequirement crystalMineKey;
    ItemRequirement combatGear;
    ItemRequirement zealotsKeyHighlighted;
    ItemRequirement food;
    ItemRequirement emptyInvSpots;
    Requirement askedAboutKey;
    Requirement inLevel1South;
    Requirement valveOpened;
    Requirement valveOpen;
    Requirement hasKeyOrOpenedValve;
    Requirement inLiftRoom;
    Requirement inLevel2North;
    Requirement inLevel3North;
    Requirement inLevel2South;
    Requirement inLevel3South;
    Requirement inCartRoom;
    Requirement inCollectRoom;
    Requirement leverAWrong;
    Requirement leverBWrong;
    Requirement leverCWrong;
    Requirement leverDWrong;
    Requirement leverEWrong;
    Requirement leverFWrong;
    Requirement leverGWrong;
    Requirement leverHWrong;
    Requirement fungusInCart;
    Requirement fungusOnOtherSide;
    Requirement inLevel1North;
    Requirement inFloodedRoom;
    Requirement daythNearby;
    Requirement inDaythRoom;
    Requirement inCrystalRoom;
    Requirement inCrystalEntrance;
    Requirement killedDayth;
    Requirement inCrystalOrCrystalEntranceRoom;
    Requirement inDarkDaythRoom;
    Requirement inDarkCrystalRoom;
    DetailedQuestStep talkToZealot;
    DetailedQuestStep pickpocketZealot;
    DetailedQuestStep enterMine;
    DetailedQuestStep goDownFromLevel1South;
    DetailedQuestStep goDownFromLevel2North;
    DetailedQuestStep goDownFromLevel3NorthEast;
    DetailedQuestStep useKeyOnValve;
    DetailedQuestStep openValve;
    DetailedQuestStep goDownLift;
    DetailedQuestStep pickUpChisel;
    DetailedQuestStep goUpFromLiftRoom;
    DetailedQuestStep goUpFromCollectRoom;
    DetailedQuestStep goDownToCollectFungus;
    DetailedQuestStep collectFungus;
    DetailedQuestStep goDownFromLevel2South;
    DetailedQuestStep goDownToFungusRoom;
    DetailedQuestStep pickFungus;
    DetailedQuestStep pullLeverA;
    DetailedQuestStep pullLeverB;
    DetailedQuestStep pullLeverC;
    DetailedQuestStep pullLeverD;
    DetailedQuestStep pullLeverE;
    DetailedQuestStep pullLeverF;
    DetailedQuestStep pullLeverG;
    DetailedQuestStep pullLeverH;
    DetailedQuestStep readPanel;
    DetailedQuestStep putFungusInCart;
    DetailedQuestStep goUpFromFungusRoom;
    DetailedQuestStep goUpFromLevel3South;
    DetailedQuestStep goUpFromLevel2South;
    DetailedQuestStep leaveLevel1South;
    DetailedQuestStep enterMineNorth;
    DetailedQuestStep goDownLevel1North;
    DetailedQuestStep goDownLevel2North;
    DetailedQuestStep goDownToDayth;
    DetailedQuestStep goDownToCrystals;
    DetailedQuestStep tryToPickUpKey;
    DetailedQuestStep killDayth;
    DetailedQuestStep pickUpKey;
    DetailedQuestStep goUpFromDayth;
    DetailedQuestStep cutCrystal;
    DetailedQuestStep leaveCrystalRoom;
    DetailedQuestStep goBackUpLift;
    DetailedQuestStep leaveDarkCrystalRoom;
    DetailedQuestStep leaveDarkDaythRoom;
    DetailedQuestStep solvePuzzle;
    Zone entryRoom1;
    Zone level1South;
    Zone liftRoom1;
    Zone liftRoom2;
    Zone level2South;
    Zone level2North;
    Zone level2North2;
    Zone level3North1;
    Zone level3North2;
    Zone level3North3;
    Zone level3North4;
    Zone level3South1;
    Zone level3South2;
    Zone level3South3;
    Zone cartRoom;
    Zone collectRoom;
    Zone level1North;
    Zone floodedRoom;
    Zone daythRoom1;
    Zone daythRoom2;
    Zone crystalRoom1;
    Zone crystalRoom2;
    Zone crystalRoom3;
    Zone crystalEntrance;
    Zone crystalEntranceDark;
    Zone daythRoomDark;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToZealot);
        ConditionalStep solveMineCarts = new ConditionalStep((QuestHelper)this, (QuestStep)this.readPanel, new Requirement[0]);
        solveMineCarts.addStep(this.leverAWrong, this.pullLeverA);
        solveMineCarts.addStep(this.leverBWrong, this.pullLeverB);
        solveMineCarts.addStep(this.leverCWrong, this.pullLeverC);
        solveMineCarts.addStep(this.leverDWrong, this.pullLeverD);
        solveMineCarts.addStep(this.leverEWrong, this.pullLeverE);
        solveMineCarts.addStep(this.leverFWrong, this.pullLeverF);
        solveMineCarts.addStep(this.leverGWrong, this.pullLeverG);
        solveMineCarts.addStep(this.leverHWrong, this.pullLeverH);
        ConditionalStep exploreMine = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToZealot, new Requirement[0]);
        exploreMine.addStep(this.inCrystalRoom, this.cutCrystal);
        exploreMine.addStep(this.inDarkCrystalRoom, this.leaveDarkCrystalRoom);
        exploreMine.addStep(this.inDarkDaythRoom, this.leaveDarkDaythRoom);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inCrystalEntrance, this.crystalMineKey, this.chisel), this.cutCrystal);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inFloodedRoom, this.crystalMineKey, this.chisel), this.goDownToCrystals);
        exploreMine.addStep(new Conditions(this.inFloodedRoom, this.crystalMineKey), this.goBackUpLift);
        exploreMine.addStep(new Conditions(this.inDaythRoom, this.crystalMineKey), this.goUpFromDayth);
        exploreMine.addStep(new Conditions(this.inDaythRoom, this.killedDayth), this.pickUpKey);
        exploreMine.addStep(new Conditions(this.daythNearby), this.killDayth);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inDaythRoom), this.tryToPickUpKey);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inFloodedRoom), this.goDownToDayth);
        exploreMine.addStep(new Conditions(this.inCrystalEntrance), this.leaveCrystalRoom);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLiftRoom, this.valveOpen, this.chisel), this.goDownLift);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLiftRoom, this.valveOpened, this.chisel), this.openValve);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLiftRoom, this.zealotsKey, this.chisel), this.useKeyOnValve);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLiftRoom, this.hasKeyOrOpenedValve), this.pickUpChisel);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inCollectRoom, this.hasKeyOrOpenedValve), this.goUpFromCollectRoom);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLevel3North, this.hasKeyOrOpenedValve), this.goDownFromLevel3NorthEast);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLevel2North, this.hasKeyOrOpenedValve), this.goDownLevel2North);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inLevel1North, this.hasKeyOrOpenedValve), this.goDownLevel1North);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inCollectRoom, this.hasKeyOrOpenedValve), this.collectFungus);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel3North, this.hasKeyOrOpenedValve), this.goDownToCollectFungus);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLiftRoom, this.hasKeyOrOpenedValve), this.goUpFromLiftRoom);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel2North, this.hasKeyOrOpenedValve), this.goDownLevel2North);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel1North, this.hasKeyOrOpenedValve), this.goDownLevel1North);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel1South, this.hasKeyOrOpenedValve), this.leaveLevel1South);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel2South, this.hasKeyOrOpenedValve), this.goUpFromLevel2South);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inLevel3South, this.hasKeyOrOpenedValve), this.goUpFromLevel3South);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.inCartRoom, this.hasKeyOrOpenedValve), this.goUpFromFungusRoom);
        exploreMine.addStep(new Conditions(this.fungusOnOtherSide, this.hasKeyOrOpenedValve), this.enterMineNorth);
        exploreMine.addStep(new Conditions(this.fungusInCart, this.inCartRoom), solveMineCarts);
        exploreMine.addStep(new Conditions(this.glowingFungus, this.inCartRoom), this.putFungusInCart);
        exploreMine.addStep(this.inCartRoom, this.pickFungus);
        exploreMine.addStep(this.inLevel3South, this.goDownToFungusRoom);
        exploreMine.addStep(this.inLevel2South, this.goDownFromLevel2South);
        exploreMine.addStep(this.inLevel1South, this.goDownFromLevel1South);
        exploreMine.addStep(this.hasKeyOrOpenedValve, this.enterMine);
        exploreMine.addStep(this.askedAboutKey, this.pickpocketZealot);
        steps.put(1, exploreMine);
        steps.put(2, exploreMine);
        steps.put(3, exploreMine);
        steps.put(4, exploreMine);
        steps.put(5, exploreMine);
        steps.put(6, exploreMine);
        steps.put(7, exploreMine);
        steps.put(8, exploreMine);
        steps.put(9, exploreMine);
        steps.put(10, exploreMine);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.zealotsKey = new ItemRequirement("Zealot's key", 4078);
        this.zealotsKeyHighlighted = new ItemRequirement("Zealot's key", 4078);
        this.zealotsKeyHighlighted.setHighlightInInventory(true);
        this.chisel = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.glowingFungus = new ItemRequirement("Glowing fungus", 4075);
        this.glowingFungusHighlight = new ItemRequirement("Glowing fungus", 4075);
        this.glowingFungusHighlight.setHighlightInInventory(true);
        this.emptyInvSpots = new ItemRequirement("Empty Inventory Spot", -1, 3);
        this.crystalMineKey = new ItemRequirement("Crystal-mine key", 4077);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
    }

    public void loadZones() {
        this.entryRoom1 = new Zone(new WorldPoint(2647, 9803, 0), new WorldPoint(2680, 9814, 0));
        this.level1North = new Zone(new WorldPoint(3404, 9628, 0), new WorldPoint(3439, 9662, 0));
        this.level1South = new Zone(new WorldPoint(3409, 9616, 0), new WorldPoint(3431, 9627, 0));
        this.level2South = new Zone(new WorldPoint(2780, 4558, 0), new WorldPoint(2815, 4576, 0));
        this.level2North = new Zone(new WorldPoint(2765, 4577, 0), new WorldPoint(2814, 4605, 0));
        this.level2North2 = new Zone(new WorldPoint(2770, 4575, 0), new WorldPoint(2775, 4576, 0));
        this.level3North1 = new Zone(new WorldPoint(2709, 4518, 0), new WorldPoint(2744, 4543, 0));
        this.level3North2 = new Zone(new WorldPoint(2693, 4496, 0), new WorldPoint(2724, 4517, 0));
        this.level3North3 = new Zone(new WorldPoint(2694, 4493, 0), new WorldPoint(2698, 4495, 0));
        this.level3North4 = new Zone(new WorldPoint(2721, 4492, 0), new WorldPoint(2724, 4496, 0));
        this.level3South1 = new Zone(new WorldPoint(2725, 4485, 0), new WorldPoint(2741, 4517, 0));
        this.level3South2 = new Zone(new WorldPoint(2718, 4484, 0), new WorldPoint(2729, 4490, 0));
        this.level3South3 = new Zone(new WorldPoint(2710, 4491, 0), new WorldPoint(2718, 4495, 0));
        this.liftRoom1 = new Zone(new WorldPoint(2798, 4489, 0), new WorldPoint(2812, 4532, 0));
        this.liftRoom2 = new Zone(new WorldPoint(2794, 4524, 0), new WorldPoint(2797, 4532, 0));
        this.cartRoom = new Zone(new WorldPoint(2757, 4483, 0), new WorldPoint(2795, 4545, 0));
        this.collectRoom = new Zone(new WorldPoint(2772, 4535, 0), new WorldPoint(2776, 4542, 0));
        this.floodedRoom = new Zone(new WorldPoint(2688, 4432, 0), new WorldPoint(2753, 4472, 0));
        this.daythRoom1 = new Zone(new WorldPoint(2779, 4441, 0), new WorldPoint(2815, 4474, 0));
        this.daythRoom2 = new Zone(new WorldPoint(2774, 4457, 0), new WorldPoint(2779, 4465, 0));
        this.daythRoomDark = new Zone(new WorldPoint(2716, 4559, 0), new WorldPoint(2734, 4569, 0));
        this.crystalRoom1 = new Zone(new WorldPoint(2762, 4418, 0), new WorldPoint(2780, 4449, 0));
        this.crystalRoom2 = new Zone(new WorldPoint(2762, 4421, 0), new WorldPoint(2810, 4439, 0));
        this.crystalRoom3 = new Zone(new WorldPoint(2797, 4440, 0), new WorldPoint(2808, 4450, 0));
        this.crystalEntrance = new Zone(new WorldPoint(2758, 4450, 0), new WorldPoint(2776, 4456, 0));
        this.crystalEntranceDark = new Zone(new WorldPoint(2708, 4588, 0), new WorldPoint(2736, 5499, 0));
    }

    public void setupConditions() {
        this.askedAboutKey = new VarbitRequirement(2397, 1);
        this.inLevel1North = new ZoneRequirement(this.level1North);
        this.inLevel1South = new ZoneRequirement(this.level1South);
        this.inLevel2South = new ZoneRequirement(this.level2South);
        this.inLevel2North = new ZoneRequirement(this.level2North, this.level2North2);
        this.inLevel3South = new ZoneRequirement(this.level3South1, this.level3South2, this.level3South3);
        this.inLevel3North = new ZoneRequirement(this.level3North1, this.level3North2, this.level3North3, this.level3North4);
        this.inLiftRoom = new ZoneRequirement(this.liftRoom1, this.liftRoom2);
        this.inCartRoom = new ZoneRequirement(this.cartRoom);
        this.inCollectRoom = new ZoneRequirement(this.collectRoom);
        this.inFloodedRoom = new ZoneRequirement(this.floodedRoom);
        this.inDaythRoom = new ZoneRequirement(this.daythRoom1, this.daythRoom2);
        this.inCrystalRoom = new ZoneRequirement(this.crystalRoom1, this.crystalRoom2, this.crystalRoom3);
        this.inCrystalEntrance = new ZoneRequirement(this.crystalEntrance);
        this.inCrystalOrCrystalEntranceRoom = new ZoneRequirement(this.crystalRoom1, this.crystalRoom2, this.crystalRoom3, this.crystalEntrance);
        this.valveOpened = new VarbitRequirement(2393, 1);
        this.valveOpen = new VarbitRequirement(2394, 1);
        this.hasKeyOrOpenedValve = new Conditions(LogicType.OR, this.zealotsKey, this.valveOpened);
        this.leverAWrong = new VarbitRequirement(2385, 0);
        this.leverBWrong = new VarbitRequirement(2386, 0);
        this.leverCWrong = new VarbitRequirement(2387, 1);
        this.leverDWrong = new VarbitRequirement(2388, 1);
        this.leverEWrong = new VarbitRequirement(2389, 0);
        this.leverFWrong = new VarbitRequirement(2390, 0);
        this.leverGWrong = new VarbitRequirement(2391, 1);
        this.leverHWrong = new VarbitRequirement(2392, 1);
        this.fungusInCart = new VarbitRequirement(2395, 1);
        this.fungusOnOtherSide = new VarbitRequirement(2396, 1);
        this.daythNearby = new NpcHintArrowRequirement(3616, 3617);
        this.killedDayth = new VarplayerRequirement(382, 9, Operation.GREATER_EQUAL);
        this.inDarkCrystalRoom = new ZoneRequirement(this.crystalEntranceDark);
        this.inDarkDaythRoom = new ZoneRequirement(this.daythRoomDark);
    }

    public void setupSteps() {
        this.talkToZealot = new NpcStep((QuestHelper)this, 3611, new WorldPoint(3443, 3258, 0), "Talk to the Zealot outside the Abandoned Mine in south west Morytania.", new Requirement[0]);
        this.talkToZealot.addDialogSteps("And what sort of purpose would that be?", "Yes.", "Is there any other way into the mines?", "I come seeking challenges and quests.", "I follow the path of Saradomin.", "What quest is that then?");
        this.pickpocketZealot = new NpcStep((QuestHelper)this, 3611, new WorldPoint(3443, 3258, 0), "Pickpocket the Zealot outside the Abandoned Mine in south west Morytania.", new Requirement[0]);
        this.enterMine = new ObjectStep((QuestHelper)this, 4915, new WorldPoint(3429, 3225, 0), "Enter the south cart tunnel around the back of the mine.", new Requirement[0]);
        this.goDownFromLevel1South = new ObjectStep((QuestHelper)this, 4965, new WorldPoint(3422, 9625, 0), "Climb down the ladder to the east.", new Requirement[0]);
        this.goDownFromLevel2South = new ObjectStep((QuestHelper)this, 4969, new WorldPoint(2798, 4567, 0), "Climb down another ladder to the east.", new Requirement[0]);
        this.goDownFromLevel2North = new ObjectStep((QuestHelper)this, 4969, new WorldPoint(2797, 4599, 0), "Climb down the ladder to the north east.", new Requirement[0]);
        this.goDownFromLevel3NorthEast = new ObjectStep((QuestHelper)this, 4967, new WorldPoint(2732, 4529, 0), "Climb down the ladder in the room in the north east.", new Requirement[0]);
        this.goDownToFungusRoom = new ObjectStep((QuestHelper)this, 4967, new WorldPoint(2725, 4486, 0), "Go down the ladder to the south, making sure to avoid the moving mine cart.", new Requirement[0]);
        this.readPanel = new ObjectStep((QuestHelper)this, 4949, new WorldPoint(2770, 4522, 0), "Check the Points Settings panel in the centre of the room. Click the 'Start' button in the interface.", new Requirement[0]);
        this.pullLeverA = new ObjectStep((QuestHelper)this, 4950, new WorldPoint(2785, 4517, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverB = new ObjectStep((QuestHelper)this, 4951, new WorldPoint(2784, 4517, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverC = new ObjectStep((QuestHelper)this, 4952, new WorldPoint(2786, 4517, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverD = new ObjectStep((QuestHelper)this, 4953, new WorldPoint(2786, 4515, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverE = new ObjectStep((QuestHelper)this, 4954, new WorldPoint(2785, 4515, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverF = new ObjectStep((QuestHelper)this, 4955, new WorldPoint(2768, 4533, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverG = new ObjectStep((QuestHelper)this, 4956, new WorldPoint(2769, 4533, 0), "Pull the marked lever.", new Requirement[0]);
        this.pullLeverH = new ObjectStep((QuestHelper)this, 4957, new WorldPoint(2770, 4533, 0), "Pull the marked lever.", new Requirement[0]);
        this.solvePuzzle = new DetailedQuestStep((QuestHelper)this, "Pull levers until the tracks are lined up to take the cart to the north east corner.", new Requirement[0]);
        this.solvePuzzle.addSubSteps(this.pullLeverA, this.pullLeverB, this.pullLeverC, this.pullLeverD, this.pullLeverE, this.pullLeverF, this.pullLeverG, this.pullLeverH);
        this.useKeyOnValve = new ObjectStep((QuestHelper)this, 4924, new WorldPoint(2808, 4496, 0), "Use the Zealot's key on the water valve. Make sure you have some energy as you'll need to race to the lift afterwards.", this.zealotsKeyHighlighted);
        this.useKeyOnValve.addIcon(4078);
        this.openValve = new ObjectStep((QuestHelper)this, 4924, new WorldPoint(2808, 4496, 0), "Turn the valve. Make sure you have some energy as you'll need to race to the lift afterwards.", new Requirement[0]);
        this.useKeyOnValve.addSubSteps(this.openValve);
        this.goDownLift = new ObjectStep((QuestHelper)this, 4938, new WorldPoint(2807, 4492, 0), "Race to the lift before the ghost turns off the valve.", new Requirement[0]);
        this.goDownToCollectFungus = new ObjectStep((QuestHelper)this, 4967, new WorldPoint(2710, 4540, 0), "Go down the north west ladder to collect the glowing fungus.", new Requirement[0]);
        this.collectFungus = new ObjectStep((QuestHelper)this, 4974, new WorldPoint(2774, 4537, 0), "Search the mine cart for the glowing fungus.", new Requirement[0]);
        this.collectFungus.addDialogStep("Take it.");
        this.goUpFromCollectRoom = new ObjectStep((QuestHelper)this, 4968, new WorldPoint(2774, 4540, 0), "Take the fungus back upstairs.", new Requirement[0]);
        this.pickUpChisel = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2800, 4500, 0), "Pick up the chisel nearby.", this.chisel);
        this.pickFungus = new ObjectStep((QuestHelper)this, 4933, new WorldPoint(2793, 4493, 0), "Pick a glowing fungus.", new Requirement[0]);
        this.goUpFromLiftRoom = new ObjectStep((QuestHelper)this, 4968, new WorldPoint(2796, 4529, 0), "Go back up the ladder.", new Requirement[0]);
        this.putFungusInCart = new ObjectStep((QuestHelper)this, 4974, new WorldPoint(2778, 4506, 0), "Put the glowing fungus into the mine cart north west of the ladder.", this.glowingFungusHighlight);
        this.putFungusInCart.addIcon(4075);
        this.goUpFromFungusRoom = new ObjectStep((QuestHelper)this, 4968, new WorldPoint(2789, 4486, 0), "Climb back up to the surface.", new Requirement[0]);
        this.goUpFromLevel3South = new ObjectStep((QuestHelper)this, 4970, new WorldPoint(2734, 4503, 0), "Climb back up to the surface.", new Requirement[0]);
        this.goUpFromLevel2South = new ObjectStep((QuestHelper)this, 4966, new WorldPoint(2782, 4569, 0), "Climb back up to the surface.", new Requirement[0]);
        this.leaveLevel1South = new ObjectStep((QuestHelper)this, 15830, new WorldPoint(3408, 9623, 0), "Leave through the cart tunnel.", new Requirement[0]);
        this.goUpFromFungusRoom.addSubSteps(this.goUpFromLevel3South, this.goUpFromLevel2South, this.leaveLevel1South);
        this.enterMineNorth = new ObjectStep((QuestHelper)this, 4914, new WorldPoint(3430, 3233, 0), "Make sure you're prepared to fight Treus Dayth (level 95), then enter the north area of the Haunted Mine.", new Requirement[0]);
        this.goDownLevel1North = new ObjectStep((QuestHelper)this, 4965, new WorldPoint(3413, 9633, 0), "Climb down the west ladder.", new Requirement[0]);
        this.goDownLevel2North = new ObjectStep((QuestHelper)this, 4969, new WorldPoint(2797, 4599, 0), "Climb down the north east ladder.", new Requirement[0]);
        this.goDownToDayth = new ObjectStep((QuestHelper)this, 4971, new WorldPoint(2748, 4437, 0), "Go down the east stairs.", new Requirement[0]);
        this.goDownToCrystals = new ObjectStep((QuestHelper)this, 4971, new WorldPoint(2694, 4437, 0), "Go down the west stairs.", new Requirement[0]);
        this.tryToPickUpKey = new NpcStep((QuestHelper)this, 3619, new WorldPoint(2788, 4455, 0), "Attempt to pick up the innocent-looking key. Treus Dayth (level 95) will spawn. Kill him.", new Requirement[0]);
        this.killDayth = new NpcStep((QuestHelper)this, 3616, new WorldPoint(2788, 4450, 0), "Kill Treus Dayth.", new Requirement[0]);
        this.tryToPickUpKey.addSubSteps(this.killDayth);
        this.pickUpKey = new NpcStep((QuestHelper)this, 3619, new WorldPoint(2788, 4455, 0), "Pick up the innocent-looking key.", new Requirement[0]);
        this.goUpFromDayth = new ObjectStep((QuestHelper)this, 4973, new WorldPoint(2813, 4454, 0), "Go back up to the flooded area.", new Requirement[0]);
        this.cutCrystal = new ObjectStep((QuestHelper)this, 4926, new WorldPoint(2787, 4428, 0), "Cut from a crystal outcrop with a chisel in the south room to finish the quest.", this.chisel);
        this.leaveCrystalRoom = new ObjectStep((QuestHelper)this, 4973, new WorldPoint(2756, 4454, 0), "Go back up to the flooded area.", new Requirement[0]);
        this.goBackUpLift = new ObjectStep((QuestHelper)this, 4942, new WorldPoint(2726, 4456, 0), "Go back up the lift to get a chisel.", new Requirement[0]);
        this.leaveDarkCrystalRoom = new ObjectStep((QuestHelper)this, 4972, new WorldPoint(2710, 4593, 0), "You need a glowing fungus. Go back up to the flooded area.", new Requirement[0]);
        this.leaveDarkDaythRoom = new ObjectStep((QuestHelper)this, 4972, new WorldPoint(2732, 4563, 0), "You need a glowing fungus. Go back up to the flooded area.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return QuestUtil.toArrayList(this.food);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Treus Dayth (level 95)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.STRENGTH, 22000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to create the Salve Amulet"), new UnlockReward("Ability to access Tarn's Lair"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToZealot, this.pickpocketZealot), this.combatGear, this.food, this.emptyInvSpots));
        allSteps.add(new PanelDetails("Getting a light source", Arrays.asList(this.enterMine, this.goDownFromLevel1South, this.goDownFromLevel2South, this.goDownToFungusRoom, this.pickFungus, this.putFungusInCart, this.solvePuzzle, this.readPanel, this.goUpFromFungusRoom), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting the salve crystals", Arrays.asList(this.enterMineNorth, this.goDownLevel1North, this.goDownLevel2North, this.goDownToCollectFungus, this.collectFungus, this.goUpFromCollectRoom, this.goDownFromLevel3NorthEast, this.pickUpChisel, this.useKeyOnValve, this.goDownLift, this.goDownToDayth, this.tryToPickUpKey, this.pickUpKey, this.goUpFromDayth, this.goDownToCrystals, this.cutCrystal), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 35));
        return req;
    }
}

