/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.grimtales;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.GRIM_TALES)
public class GrimTales
extends BasicQuestHelper {
    ItemRequirement tarrominUnf2;
    ItemRequirement tarrominUnf;
    ItemRequirement dibber;
    ItemRequirement can;
    ItemRequirement axe;
    ItemRequirement combatGear;
    ItemRequirement griffinFeather;
    ItemRequirement rupertsHelmet;
    ItemRequirement miazrqasPendant;
    ItemRequirement goldenGoblin;
    ItemRequirement houseKey;
    ItemRequirement ogleroot;
    ItemRequirement shrinkPotion;
    ItemRequirement shrinkPotionHighlight;
    ItemRequirement tarrominUnfHighlight;
    ItemRequirement oglerootHighlight;
    ItemRequirement magicBeans;
    ItemRequirement canHighlight;
    ItemRequirement food;
    Requirement inHouse;
    Requirement inBasement;
    Requirement grimgnashAsleep;
    Requirement givenFeather;
    Requirement inTowerBase;
    Requirement inTowerUpstairs;
    Requirement talkedToDrainOnce;
    Requirement beardDropped;
    Requirement talkedToRupert;
    Requirement talkedToMiazrqa;
    Requirement inPianoWidget;
    Requirement pressed1;
    Requirement pressed2;
    Requirement pressed3;
    Requirement pressed4;
    Requirement pressed5;
    Requirement pressed6;
    Requirement pressed7;
    Requirement pressed8;
    Requirement unlockedPiano;
    Requirement searchedPiano;
    Requirement inMouseRoom1;
    Requirement inMouseRoom2;
    Requirement inMouseRoom3;
    Requirement inMouseRoom4;
    Requirement inMouseRoom5;
    Requirement inMouseRoom6;
    Requirement inWrongMouse1;
    Requirement inWrongMouse2;
    Requirement givenPendant;
    Requirement releasedRupert;
    Requirement plantedSeed;
    Requirement wateredSeed;
    Requirement onCloud;
    Requirement killedGlod;
    Requirement usedPotion;
    Requirement hasMiazrqasPendant;
    QuestStep talkToSylas;
    QuestStep talkToGrimgnash;
    QuestStep stealFeather;
    QuestStep returnFeatherToSylas;
    QuestStep climbWall;
    QuestStep talkToDrainPipe;
    QuestStep talkToDrainPipeAgain;
    QuestStep climbBeard;
    QuestStep talkToRupert;
    QuestStep climbDownBeard;
    QuestStep talkToMiazrqa;
    QuestStep enterWitchsHouse;
    QuestStep enterWitchBasement;
    QuestStep playPiano;
    QuestStep upperE;
    QuestStep upperF;
    QuestStep upperEAgain;
    QuestStep upperD;
    QuestStep upperC;
    QuestStep lowerA;
    QuestStep lowerE;
    QuestStep lowerG;
    QuestStep lowerAAgain;
    QuestStep searchPiano;
    QuestStep makePotions;
    QuestStep leaveBasement;
    QuestStep drinkPotion;
    QuestStep enterWitchsHouseWithPotion;
    QuestStep climb1;
    QuestStep climb2;
    QuestStep climb3;
    QuestStep climb4;
    QuestStep climb5;
    QuestStep takePendant;
    QuestStep givePendant;
    QuestStep talkMizAfterPendant;
    QuestStep talkToRupertAfterAmulet;
    QuestStep leaveWrong1;
    QuestStep leaveWrong2;
    QuestStep giveHelmetToSylas;
    QuestStep talkToSylasAfterGivingItems;
    QuestStep plantBean;
    QuestStep waterBean;
    QuestStep climbBean;
    QuestStep climbBeanForStatue;
    QuestStep killGlod;
    QuestStep pickUpGoldenGoblin;
    QuestStep giveGoldenGoblinToSylas;
    QuestStep usePotionOnBean;
    QuestStep chopBean;
    QuestStep talkToSylasFinish;
    Zone house;
    Zone basement;
    Zone towerBase;
    Zone towerUpstairs;
    Zone mouseRoom1;
    Zone mouseRoom2;
    Zone mouseRoom3;
    Zone mouseRoom4;
    Zone mouseRoom5;
    Zone mouseRoom6;
    Zone wrongMouse1;
    Zone wrongMouse2;
    Zone cloud;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToSylas);
        steps.put(1, this.talkToSylas);
        steps.put(2, this.talkToSylas);
        steps.put(3, this.talkToSylas);
        steps.put(4, this.talkToSylas);
        ConditionalStep getHelmet = new ConditionalStep((QuestHelper)this, this.climbWall, new Requirement[0]);
        getHelmet.addStep(this.rupertsHelmet, this.giveHelmetToSylas);
        getHelmet.addStep(this.releasedRupert, this.talkToRupertAfterAmulet);
        getHelmet.addStep(new Conditions(this.givenPendant), this.talkMizAfterPendant);
        getHelmet.addStep(new Conditions(this.hasMiazrqasPendant), this.givePendant);
        getHelmet.addStep(new Conditions(this.inMouseRoom6), this.takePendant);
        getHelmet.addStep(new Conditions(this.inMouseRoom5), this.climb5);
        getHelmet.addStep(new Conditions(this.inMouseRoom4), this.climb4);
        getHelmet.addStep(new Conditions(this.inMouseRoom3), this.climb3);
        getHelmet.addStep(new Conditions(this.inMouseRoom2), this.climb2);
        getHelmet.addStep(new Conditions(this.inMouseRoom1), this.climb1);
        getHelmet.addStep(new Conditions(this.inWrongMouse2), this.leaveWrong2);
        getHelmet.addStep(new Conditions(this.inWrongMouse1), this.leaveWrong1);
        getHelmet.addStep(new Conditions(this.inHouse, this.shrinkPotion), this.drinkPotion);
        getHelmet.addStep(new Conditions(this.inBasement, this.shrinkPotion), this.leaveBasement);
        getHelmet.addStep(new Conditions(this.shrinkPotion), this.enterWitchsHouseWithPotion);
        getHelmet.addStep(new Conditions(this.searchedPiano), this.makePotions);
        getHelmet.addStep(new Conditions(this.inBasement, this.unlockedPiano), this.searchPiano);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed8), this.lowerAAgain);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed7), this.lowerG);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed6), this.lowerE);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed5), this.lowerA);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed4), this.upperC);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed3), this.upperD);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed2), this.upperEAgain);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa, this.pressed1), this.upperF);
        getHelmet.addStep(new Conditions(this.inPianoWidget, this.talkedToMiazrqa), this.upperE);
        getHelmet.addStep(new Conditions(this.inBasement, this.talkedToMiazrqa), this.playPiano);
        getHelmet.addStep(new Conditions(this.inHouse, this.talkedToMiazrqa), this.enterWitchBasement);
        getHelmet.addStep(new Conditions(this.talkedToMiazrqa), this.enterWitchsHouse);
        getHelmet.addStep(new Conditions(this.inTowerUpstairs, this.talkedToRupert), this.climbDownBeard);
        getHelmet.addStep(new Conditions(this.talkedToRupert), this.talkToMiazrqa);
        getHelmet.addStep(new Conditions(this.inTowerUpstairs), this.talkToRupert);
        getHelmet.addStep(new Conditions(this.inTowerBase, this.beardDropped), this.climbBeard);
        getHelmet.addStep(new Conditions(this.talkedToDrainOnce, this.inTowerBase), this.talkToDrainPipeAgain);
        getHelmet.addStep(new Conditions(this.inTowerBase), this.talkToDrainPipe);
        ConditionalStep getFeatherAndHelmet = new ConditionalStep((QuestHelper)this, this.talkToGrimgnash, new Requirement[0]);
        getFeatherAndHelmet.addStep(this.givenFeather, getHelmet);
        getFeatherAndHelmet.addStep(this.griffinFeather, this.returnFeatherToSylas);
        getFeatherAndHelmet.addStep(this.grimgnashAsleep, this.stealFeather);
        steps.put(10, getFeatherAndHelmet);
        steps.put(12, this.talkToSylasAfterGivingItems);
        steps.put(15, this.talkToSylasAfterGivingItems);
        steps.put(16, this.talkToSylasAfterGivingItems);
        steps.put(17, this.talkToSylasAfterGivingItems);
        steps.put(19, this.talkToSylasAfterGivingItems);
        ConditionalStep sortBean = new ConditionalStep((QuestHelper)this, this.plantBean, new Requirement[0]);
        sortBean.addStep(this.plantedSeed, this.waterBean);
        steps.put(20, sortBean);
        ConditionalStep climbAndKillGlod = new ConditionalStep((QuestHelper)this, this.climbBean, new Requirement[0]);
        climbAndKillGlod.addStep(this.goldenGoblin, this.giveGoldenGoblinToSylas);
        climbAndKillGlod.addStep(new Conditions(this.onCloud, this.killedGlod), this.pickUpGoldenGoblin);
        climbAndKillGlod.addStep(this.killedGlod, this.climbBeanForStatue);
        climbAndKillGlod.addStep(this.onCloud, this.killGlod);
        steps.put(30, climbAndKillGlod);
        ConditionalStep finish = new ConditionalStep((QuestHelper)this, this.usePotionOnBean, new Requirement[0]);
        finish.addStep(this.usedPotion, this.chopBean);
        steps.put(40, finish);
        steps.put(50, this.talkToSylasFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.tarrominUnf2 = new ItemRequirement("Tarromin potion (unf)", 95, 2);
        this.tarrominUnf = new ItemRequirement("Tarromin potion (unf)", 95);
        this.tarrominUnfHighlight = new ItemRequirement("Tarromin potion (unf)", 95);
        this.tarrominUnfHighlight.setHighlightInInventory(true);
        this.dibber = new ItemRequirement("Seed dibber", 5343).isNotConsumed();
        this.can = new ItemRequirement("Watering can with at least 1 use", ItemCollections.WATERING_CANS).isNotConsumed();
        this.can.setTooltip("Gricollers' can is also valid. ");
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear and food", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.griffinFeather = new ItemRequirement("Griffin feather", 11196);
        this.rupertsHelmet = new ItemRequirement("Rupert's helmet", 11199);
        this.miazrqasPendant = new ItemRequirement("Miazrqa's pendant", 11197);
        this.goldenGoblin = new ItemRequirement("Golden goblin", 11210);
        this.houseKey = new ItemRequirement("Door key", 2409);
        this.houseKey.setTooltip("You can get another from the pot outside the Witch's House");
        this.ogleroot = new ItemRequirement("Shrunk ogleroot", 11205);
        this.ogleroot.setTooltip("You will need to get more by fighting Experiment No.2 in the sewer outside the Witch's House");
        this.oglerootHighlight = new ItemRequirement("Shrunk ogleroot", 11205);
        this.oglerootHighlight.setTooltip("You will need to get more by fighting Experiment No.2 in the sewer outside the Witch's House");
        this.oglerootHighlight.setHighlightInInventory(true);
        this.shrinkPotion = new ItemRequirement("Shrink-me-quick", 11204);
        this.shrinkPotionHighlight = new ItemRequirement("Shrink-me-quick", 11204);
        this.shrinkPotionHighlight.setHighlightInInventory(true);
        this.magicBeans = new ItemRequirement("Magic beans", 11211);
        this.magicBeans.setTooltip("You can get more from Sylas in Taverley");
        this.magicBeans.setHighlightInInventory(true);
        this.canHighlight = new ItemRequirement("Watering can with at least 1 use", ItemCollections.WATERING_CANS);
    }

    public void loadZones() {
        this.house = new Zone(new WorldPoint(2901, 3466, 0), new WorldPoint(2907, 3476, 0));
        this.basement = new Zone(new WorldPoint(2897, 9870, 0), new WorldPoint(2909, 9878, 0));
        this.towerBase = new Zone(new WorldPoint(2966, 3460, 0), new WorldPoint(2970, 3464, 0));
        this.towerUpstairs = new Zone(new WorldPoint(2966, 3465, 2), new WorldPoint(2972, 3473, 2));
        this.mouseRoom1 = new Zone(new WorldPoint(2274, 5521, 0), new WorldPoint(2286, 5557, 0));
        this.mouseRoom2 = new Zone(new WorldPoint(2262, 5514, 1), new WorldPoint(2284, 5556, 1));
        this.mouseRoom3 = new Zone(new WorldPoint(2263, 5514, 2), new WorldPoint(2277, 5520, 2));
        this.mouseRoom4 = new Zone(new WorldPoint(2263, 5513, 3), new WorldPoint(2284, 5532, 3));
        this.mouseRoom5 = new Zone(new WorldPoint(2276, 5524, 2), new WorldPoint(2283, 5545, 2));
        this.mouseRoom6 = new Zone(new WorldPoint(2276, 5539, 3), new WorldPoint(2284, 5556, 3));
        this.wrongMouse1 = new Zone(new WorldPoint(2276, 5549, 2), new WorldPoint(2285, 5560, 2));
        this.wrongMouse2 = new Zone(new WorldPoint(2263, 5516, 0), new WorldPoint(2276, 5519, 0));
        this.cloud = new Zone(new WorldPoint(2130, 5522, 3), new WorldPoint(2156, 5547, 3));
    }

    public void setupConditions() {
        this.inHouse = new ZoneRequirement(this.house);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inTowerBase = new ZoneRequirement(this.towerBase);
        this.inTowerUpstairs = new ZoneRequirement(this.towerUpstairs);
        this.grimgnashAsleep = new VarbitRequirement(3717, 1);
        this.givenFeather = new VarbitRequirement(3719, 1);
        this.talkedToDrainOnce = new VarbitRequirement(3694, 5, Operation.GREATER_EQUAL);
        this.beardDropped = new VarbitRequirement(3694, 10, Operation.GREATER_EQUAL);
        this.talkedToRupert = new VarbitRequirement(3694, 15, Operation.GREATER_EQUAL);
        this.talkedToMiazrqa = new VarbitRequirement(3694, 20, Operation.GREATER_EQUAL);
        this.inPianoWidget = new WidgetModelRequirement(535, 1, 25890);
        this.pressed1 = new VarbitRequirement(3697, 1);
        this.pressed2 = new VarbitRequirement(3697, 2);
        this.pressed3 = new VarbitRequirement(3697, 3);
        this.pressed4 = new VarbitRequirement(3697, 4);
        this.pressed5 = new VarbitRequirement(3697, 5);
        this.pressed6 = new VarbitRequirement(3697, 6);
        this.pressed7 = new VarbitRequirement(3697, 7);
        this.pressed8 = new VarbitRequirement(3697, 8);
        this.unlockedPiano = new VarbitRequirement(3698, 1);
        this.searchedPiano = new VarbitRequirement(3716, 1);
        this.inMouseRoom1 = new ZoneRequirement(this.mouseRoom1);
        this.inMouseRoom2 = new ZoneRequirement(this.mouseRoom2);
        this.inMouseRoom3 = new ZoneRequirement(this.mouseRoom3);
        this.inMouseRoom4 = new ZoneRequirement(this.mouseRoom4);
        this.inMouseRoom5 = new ZoneRequirement(this.mouseRoom5);
        this.inMouseRoom6 = new ZoneRequirement(this.mouseRoom6);
        this.inWrongMouse1 = new ZoneRequirement(this.wrongMouse1);
        this.inWrongMouse2 = new ZoneRequirement(this.wrongMouse2);
        this.hasMiazrqasPendant = new VarbitRequirement(3721, 1);
        this.givenPendant = new VarbitRequirement(3694, 25);
        this.releasedRupert = new VarbitRequirement(3701, 1);
        this.plantedSeed = new VarbitRequirement(3714, 1);
        this.wateredSeed = new VarbitRequirement(3714, 2);
        this.onCloud = new ZoneRequirement(this.cloud);
        this.killedGlod = new VarbitRequirement(3715, 1);
        this.usedPotion = new VarbitRequirement(3714, 3);
    }

    public void setupSteps() {
        this.talkToSylas = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Talk to Sylas in Taverley.", new Requirement[0]);
        this.talkToSylas.addDialogStep("Yes");
        this.talkToGrimgnash = new NpcStep((QuestHelper)this, 5119, new WorldPoint(2862, 3511, 0), "Talk to Grimgnash in the north east of White Wolf Mountain.", new Requirement[0]);
        this.talkToGrimgnash.addDialogSteps("I heard you were a great and mighty Griffin!", "There once was a graveyard filled with undead.", "There lived a skeleton named Skullrot.", "Skullrot was insane!", "Skullrot hungrily grabbed the gnome's hair.", "Started to strangle the poor gnome.", "He saw some bones lying in the corner.");
        this.stealFeather = new ObjectStep((QuestHelper)this, 24841, new WorldPoint(2864, 3510, 0), "Steal a feather from Grimgnash.", new Requirement[0]);
        this.returnFeatherToSylas = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Bring Sylas in Taverley a griffin feather.", this.griffinFeather);
        this.climbWall = new ObjectStep((QuestHelper)this, 24749, new WorldPoint(2971, 3462, 0), "Climb over the crumbling wall of the tower south east of Goblin Village.", new Requirement[0]);
        this.climbBeard = new ObjectStep((QuestHelper)this, 24776, new WorldPoint(2968, 3464, 0), "Climb the beard.", new Requirement[0]);
        this.talkToDrainPipe = new ObjectStep((QuestHelper)this, 24723, new WorldPoint(2966, 3465, 0), "Talk to the drain pipe.", new Requirement[0]);
        this.talkToDrainPipeAgain = new ObjectStep((QuestHelper)this, 24723, new WorldPoint(2966, 3465, 0), "Talk to the drain pipe again.", new Requirement[0]);
        this.talkToDrainPipeAgain.addDialogSteps("I could try and climb up.", "Is there anything up there that can help?");
        this.talkToRupert = new ObjectStep((QuestHelper)this, 24774, new WorldPoint(2968, 3467, 2), "Talk to Rupert the beard.", new Requirement[0]);
        this.climbDownBeard = new ObjectStep((QuestHelper)this, 24774, new WorldPoint(2968, 3467, 2), "Climb down the beard.", new Requirement[0]);
        this.talkToMiazrqa = new NpcStep((QuestHelper)this, 5125, new WorldPoint(2968, 3473, 0), "Talk to Miazrqa.", new Requirement[0]);
        this.talkToMiazrqa.addDialogSteps("I see there is an embarrassed-looking dwarf...", "Your second-cousin, twice removed?", "I need a key for the house.", "I should be off, I think.");
        this.enterWitchsHouse = new ObjectStep((QuestHelper)this, 2861, new WorldPoint(2900, 3473, 0), "Enter the witch's house.", this.houseKey);
        this.enterWitchBasement = new ObjectStep((QuestHelper)this, 24718, new WorldPoint(2907, 3476, 0), "Go down the ladder to the basement.", new Requirement[0]);
        this.playPiano = new ObjectStep((QuestHelper)this, 24881, new WorldPoint(2908, 9870, 0), "Play the piano. Press upper E-F-E-D-C, then lower A-E-G-A.", new Requirement[0]);
        this.upperE = new WidgetStep((QuestHelper)this, "Press upper E.", 535, 77);
        this.upperF = new WidgetStep((QuestHelper)this, "Press upper F.", 535, 78);
        this.upperEAgain = new WidgetStep((QuestHelper)this, "Press upper E again.", 535, 77);
        this.upperD = new WidgetStep((QuestHelper)this, "Press upper D.", 535, 76);
        this.upperC = new WidgetStep((QuestHelper)this, "Press upper C.", 535, 75);
        this.lowerA = new WidgetStep((QuestHelper)this, "Press lower A.", 535, 73);
        this.lowerE = new WidgetStep((QuestHelper)this, "Press lower E.", 535, 70);
        this.lowerG = new WidgetStep((QuestHelper)this, "Press lower G.", 535, 72);
        this.lowerAAgain = new WidgetStep((QuestHelper)this, "Presslower A.", 535, 73);
        this.playPiano.addSubSteps(this.upperE, this.upperF, this.upperEAgain, this.upperD, this.upperC, this.lowerA, this.lowerE, this.lowerG, this.lowerAAgain);
        this.searchPiano = new ObjectStep((QuestHelper)this, 24881, new WorldPoint(2908, 9870, 0), "Right-click search the piano.", new Requirement[0]);
        this.makePotions = new DetailedQuestStep((QuestHelper)this, "Add the shrunk ogleroot to both your tarromin potion (unf). You'll need the second potion for later in the quest.", this.tarrominUnfHighlight, this.oglerootHighlight);
        this.leaveBasement = new ObjectStep((QuestHelper)this, 24717, new WorldPoint(2907, 9876, 0), "Climb back up the ladder.", new Requirement[0]);
        this.enterWitchsHouseWithPotion = new ObjectStep((QuestHelper)this, 2861, new WorldPoint(2900, 3473, 0), "Return to the witch's house with your shrinking potion.", this.houseKey, this.shrinkPotion);
        this.drinkPotion = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2903, 3466, 0), "Stand in the south room and drink the shrink-me-quick potion.", this.shrinkPotionHighlight);
        this.climb1 = new ObjectStep((QuestHelper)this, 24795, new WorldPoint(2282, 5543, 0), "Climb the nails in the north east of the room", new Requirement[0]);
        this.climb2 = new ObjectStep((QuestHelper)this, 24795, new WorldPoint(2268, 5520, 1), "Climb up the nails in the south west of the room.", new Requirement[0]);
        this.climb3 = new ObjectStep((QuestHelper)this, 24795, new WorldPoint(2270, 5515, 2), "Climb the nails in the south of the room.", new Requirement[0]);
        this.climb4 = new ObjectStep((QuestHelper)this, 24796, new WorldPoint(2283, 5530, 3), "Climb down the nails in the north east of the room.", new Requirement[0]);
        this.climb5 = new ObjectStep((QuestHelper)this, 24795, new WorldPoint(2284, 5542, 2), "Climb down the nails in the north east of the room.", new Requirement[0]);
        this.takePendant = new ObjectStep((QuestHelper)this, 24886, new WorldPoint(2279, 5555, 3), "Take the pendant and return to Miazrqa.", new Requirement[0]);
        this.leaveWrong1 = new ObjectStep((QuestHelper)this, 24796, new WorldPoint(2277, 5551, 2), "Go back down the nails.", new Requirement[0]);
        this.leaveWrong2 = new ObjectStep((QuestHelper)this, 24795, new WorldPoint(2268, 5515, 0), "Go back up the nails.", new Requirement[0]);
        this.givePendant = new NpcStep((QuestHelper)this, 5125, new WorldPoint(2968, 3473, 0), "Return the pendant to Miazrqa.", this.miazrqasPendant);
        this.talkMizAfterPendant = new NpcStep((QuestHelper)this, 5125, new WorldPoint(2968, 3473, 0), "Talk to Miazrqa.", new Requirement[0]);
        this.talkToRupertAfterAmulet = new NpcStep((QuestHelper)this, 5120, new WorldPoint(2968, 3475, 0), "Talk to Rupert the beard to get his helmet.", new Requirement[0]);
        this.giveHelmetToSylas = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Bring Sylas in Taverley Rupert's helmet.", this.rupertsHelmet);
        this.talkToSylasAfterGivingItems = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Talk to Sylas in Taverley.", new Requirement[0]);
        this.plantBean = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Plant the magic beans in the earth mound in south east Taverley", this.magicBeans, this.dibber, this.can);
        this.plantBean.addIcon(11211);
        this.waterBean = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Use your watering can on the magic beans you just planted in the earth mound", this.canHighlight);
        this.waterBean.addIcon(5331);
        this.climbBean = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Climb the bean stalk, ready to fight Glod.", this.combatGear);
        this.climbBeanForStatue = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Climb the bean stalk for another golden goblin.", new Requirement[0]);
        this.killGlod = new NpcStep((QuestHelper)this, 5129, "Kill Glod.", new Requirement[0]);
        this.pickUpGoldenGoblin = new ItemStep((QuestHelper)this, "Pick up the golden goblin.", this.goldenGoblin);
        this.giveGoldenGoblinToSylas = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Bring the golden goblin to Sylas in Taverley.", this.goldenGoblin);
        this.usePotionOnBean = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Use a shrink potion on the bean stalk.", this.shrinkPotionHighlight, this.axe);
        this.usePotionOnBean.addIcon(11204);
        this.chopBean = new ObjectStep((QuestHelper)this, 24884, new WorldPoint(2922, 3425, 0), "Chop down the bean stalk.", this.axe);
        this.talkToSylasFinish = new NpcStep((QuestHelper)this, 5118, new WorldPoint(2892, 3454, 0), "Talk to Sylas in Taverley.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.tarrominUnf2, this.dibber, this.can, this.axe, this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Glod (level 138)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FARMING, 10000), new ExperienceReward(Skill.HERBLORE, 15000), new ExperienceReward(Skill.HITPOINTS, 5000), new ExperienceReward(Skill.WOODCUTTING, 60000), new ExperienceReward(Skill.AGILITY, 25000), new ExperienceReward(Skill.THIEVING, 25000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Dwarven Helmet", 11200, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToSylas), new Requirement[0]));
        allSteps.add(new PanelDetails("Griffin feather", Arrays.asList(this.talkToGrimgnash, this.stealFeather, this.returnFeatherToSylas), new Requirement[0]));
        allSteps.add(new PanelDetails("Rupert's helmet", Arrays.asList(this.climbWall, this.talkToDrainPipe, this.talkToDrainPipeAgain, this.climbBeard, this.talkToRupert, this.climbDownBeard, this.talkToMiazrqa, this.enterWitchsHouse, this.enterWitchBasement, this.playPiano, this.searchPiano, this.makePotions, this.leaveBasement, this.drinkPotion, this.climb1, this.climb2, this.climb3, this.climb4, this.climb5, this.takePendant, this.givePendant, this.talkToRupertAfterAmulet), this.tarrominUnf2, this.houseKey, this.food));
        allSteps.add(new PanelDetails("Golden goblin", Arrays.asList(this.giveHelmetToSylas, this.plantBean, this.waterBean, this.climbBean, this.killGlod, this.pickUpGoldenGoblin, this.giveGoldenGoblinToSylas, this.usePotionOnBean, this.chopBean, this.talkToSylasFinish), this.combatGear, this.food, this.dibber, this.can, this.axe, this.shrinkPotion));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.WITCHS_HOUSE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.FARMING, 45, true));
        req.add(new SkillRequirement(Skill.HERBLORE, 52, true));
        req.add(new SkillRequirement(Skill.THIEVING, 58, true));
        req.add(new SkillRequirement(Skill.AGILITY, 59, true));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 71, true));
        return req;
    }
}

