/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.goblindiplomacy;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.GOBLIN_DIPLOMACY)
public class GoblinDiplomacy
extends BasicQuestHelper {
    ItemRequirement goblinMailThree;
    ItemRequirement orangeDye;
    ItemRequirement blueDye;
    ItemRequirement goblinMail;
    ItemRequirement goblinMailTwo;
    ItemRequirement blueArmour;
    ItemRequirement orangeArmour;
    ItemRequirement mailReq;
    Requirement isUpstairs;
    Requirement hasUpstairsArmour;
    Requirement hasWestArmour;
    Requirement hasNorthArmour;
    QuestStep talkToGeneral1;
    QuestStep talkToGeneral2;
    QuestStep talkToGeneral3;
    QuestStep goUpLadder;
    QuestStep searchUpLadder;
    QuestStep goDownLadder;
    QuestStep searchWestHut;
    QuestStep searchBehindGenerals;
    QuestStep dyeOrange;
    QuestStep dyeBlue;
    QuestStep getCrate2;
    QuestStep getCrate3;
    Zone upstairs;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep lootArmour = new ConditionalStep((QuestHelper)this, this.goUpLadder, new Requirement[0]);
        lootArmour.addStep(new Conditions(this.isUpstairs, this.hasUpstairsArmour), this.goDownLadder);
        lootArmour.addStep(new Conditions(this.hasUpstairsArmour, this.hasWestArmour), this.searchBehindGenerals);
        lootArmour.addStep(this.hasUpstairsArmour, this.searchWestHut);
        lootArmour.addStep(this.isUpstairs, this.searchUpLadder);
        ConditionalStep prepareForQuest = new ConditionalStep((QuestHelper)this, (QuestStep)lootArmour, new Requirement[0]);
        prepareForQuest.addStep(new Conditions(this.goblinMail, this.blueArmour), this.dyeOrange);
        prepareForQuest.addStep(new Conditions(LogicType.OR, this.goblinMailThree, new Conditions(this.hasUpstairsArmour, this.hasWestArmour, this.hasNorthArmour)), this.dyeBlue);
        ConditionalStep step1 = new ConditionalStep((QuestHelper)this, (QuestStep)prepareForQuest, new Requirement[0]);
        step1.addStep(new Conditions(this.goblinMail, this.blueArmour, this.orangeArmour), this.talkToGeneral1);
        steps.put(0, step1);
        steps.put(3, step1);
        ConditionalStep prepareBlueArmour = new ConditionalStep((QuestHelper)this, (QuestStep)lootArmour, new Requirement[0]);
        prepareBlueArmour.addStep(new Conditions(LogicType.OR, this.goblinMailTwo, new Conditions(this.hasUpstairsArmour, this.hasWestArmour, this.hasNorthArmour)), this.dyeBlue);
        ConditionalStep step2 = new ConditionalStep((QuestHelper)this, (QuestStep)prepareBlueArmour, new Requirement[0]);
        step2.addStep(this.blueArmour, this.talkToGeneral2);
        steps.put(4, step2);
        ConditionalStep step3 = new ConditionalStep((QuestHelper)this, (QuestStep)lootArmour, new Requirement[0]);
        step3.addStep(new Conditions(LogicType.OR, this.goblinMail, new Conditions(this.hasUpstairsArmour, this.hasWestArmour, this.hasNorthArmour)), this.talkToGeneral3);
        steps.put(5, step3);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.blueDye = new ItemRequirement("Blue dye", 1767);
        this.blueDye.setTooltip("You can have Aggie in Draynor Village make you some for 2 woad leaves (bought from Wyson in Falador Park for 20 coins) and 5 coins.");
        this.blueDye.setHighlightInInventory(true);
        this.orangeDye = new ItemRequirement("Orange dye", 1769);
        this.orangeDye.setTooltip("This is made from red dye and yellow dye. Bring Aggie in Draynor Village 3 redberries and 5 coins for red dye, then 2 onions and 5 coins for yellow dye.");
        this.orangeDye.setHighlightInInventory(true);
        this.goblinMailThree = new ItemRequirement("Goblin mail", 288, 3);
        this.mailReq = new ItemRequirement("Goblin mail", 288, 3);
        this.mailReq.canBeObtainedDuringQuest();
        this.goblinMailTwo = new ItemRequirement("Goblin mail", 288, 2);
        this.goblinMail = new ItemRequirement("Goblin mail", 288);
        this.goblinMail.setTooltip("You can get goblin mail by killing goblins around goblin village.");
        this.goblinMail.setHighlightInInventory(true);
        this.blueArmour = new ItemRequirement("Blue goblin mail", 287);
        this.orangeArmour = new ItemRequirement("Orange goblin mail", 286);
    }

    public void setupConditions() {
        this.isUpstairs = new ZoneRequirement(this.upstairs);
        this.hasUpstairsArmour = new VarbitRequirement(2381, 1);
        this.hasWestArmour = new VarbitRequirement(2380, 1);
        this.hasNorthArmour = new VarbitRequirement(2379, 1);
    }

    public void setupZones() {
        this.upstairs = new Zone(new WorldPoint(2952, 3495, 2), new WorldPoint(2959, 3498, 2));
    }

    public void setupSteps() {
        this.goUpLadder = new ObjectStep((QuestHelper)this, 16450, new WorldPoint(2954, 3497, 0), "You need three goblin mails, which you can find around the Goblin Village. The first is up the ladder in a crate in the south of the village.", new Requirement[0]);
        this.searchUpLadder = new ObjectStep((QuestHelper)this, 16561, new WorldPoint(2955, 3498, 2), "Search the crate up the ladder.", new Requirement[0]);
        this.goUpLadder.addSubSteps(this.searchUpLadder);
        this.goDownLadder = new ObjectStep((QuestHelper)this, 16556, new WorldPoint(2954, 3497, 2), "Go back down the ladder.", new Requirement[0]);
        this.searchWestHut = new ObjectStep((QuestHelper)this, 16560, new WorldPoint(2951, 3508, 0), "Search the crate in the west of Goblin Village for Goblin Mail.", new Requirement[0]);
        this.getCrate2 = new DetailedQuestStep((QuestHelper)this, "The second goblin mail can be found in the west hut in a crate.", new Requirement[0]);
        this.getCrate2.addSubSteps(this.goDownLadder, this.searchWestHut);
        this.searchBehindGenerals = new ObjectStep((QuestHelper)this, 16559, new WorldPoint(2959, 3514, 0), "Search the crate north of the General's hut in Goblin Village.", new Requirement[0]);
        this.getCrate3 = new DetailedQuestStep((QuestHelper)this, "The last goblin mail is north of the generals' hut in a crate.", new Requirement[0]);
        this.getCrate3.addSubSteps(this.searchBehindGenerals);
        this.dyeBlue = new DetailedQuestStep((QuestHelper)this, "Use the blue dye on one of the goblin mail.", this.blueDye, this.goblinMail);
        this.dyeOrange = new DetailedQuestStep((QuestHelper)this, "Use the orange dye on one of the goblin mail.", this.orangeDye, this.goblinMail);
        this.talkToGeneral1 = new NpcStep((QuestHelper)this, 669, new WorldPoint(2958, 3512, 0), "Talk to one of the Goblin Generals in Goblin Village.", this.orangeArmour);
        this.talkToGeneral1.addDialogStep("So how is life for the goblins?");
        this.talkToGeneral1.addDialogStep("Yes, Wartface looks fat");
        this.talkToGeneral1.addDialogStep("Do you want me to pick an armour colour for you?");
        this.talkToGeneral1.addDialogStep("What about a different colour?");
        this.talkToGeneral1.addDialogStep("I have some orange armour here.");
        this.talkToGeneral2 = new NpcStep((QuestHelper)this, 669, new WorldPoint(2958, 3512, 0), "Talk to one of the Goblin Generals in Goblin Village again.", this.blueArmour);
        this.talkToGeneral2.addDialogStep("So how is life for the goblins?");
        this.talkToGeneral2.addDialogStep("I have some blue armour here.");
        this.talkToGeneral3 = new NpcStep((QuestHelper)this, 669, new WorldPoint(2958, 3512, 0), "Talk to one of the Goblin Generals in Goblin Village once more.", this.goblinMail);
        this.talkToGeneral3.addDialogStep("So how is life for the goblins?");
        this.talkToGeneral3.addDialogStep("Yes, Wartface looks fat");
        this.talkToGeneral3.addDialogStep("I have some brown armour here.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.blueDye);
        reqs.add(this.orangeDye);
        reqs.add(this.mailReq);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(5);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 200));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Gold Bar", 2357, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails getArmours = new PanelDetails("Prepare goblin mail", Arrays.asList(this.goUpLadder, this.getCrate2, this.getCrate3, this.dyeBlue, this.dyeOrange), this.blueDye, this.orangeDye);
        allSteps.add(getArmours);
        allSteps.add(new PanelDetails("Present the armours", Arrays.asList(this.talkToGeneral1, this.talkToGeneral2, this.talkToGeneral3), new Requirement[0]));
        return allSteps;
    }
}

