/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ghostsahoy;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.ghostsahoy.DyeShipSteps;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.GHOSTS_AHOY)
public class GhostsAhoy
extends BasicQuestHelper {
    ItemRequirement ghostspeak;
    ItemRequirement coins400;
    ItemRequirement milk;
    ItemRequirement silk;
    ItemRequirement dyes;
    ItemRequirement spade;
    ItemRequirement oakLongbow;
    ItemRequirement knife;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement bucketOfSlime;
    ItemRequirement nettleTea;
    ItemRequirement ectoToken2;
    ItemRequirement ectoToken4;
    ItemRequirement chestKey;
    ItemRequirement nettleTeaHighlighted;
    ItemRequirement milkHighlighted;
    ItemRequirement milkyTea;
    ItemRequirement cup;
    ItemRequirement cupWithMilkyTea;
    ItemRequirement cupWithTea;
    ItemRequirement modelShip;
    ItemRequirement repairedShip;
    ItemRequirement ectoToken12;
    ItemRequirement ectoToken27;
    ItemRequirement charos;
    ItemRequirement map;
    ItemRequirement signedOakBow;
    ItemRequirement ectoToken10;
    ItemRequirement ectoToken25;
    ItemRequirement ectoSheets;
    ItemRequirement bedsheet;
    ItemRequirement petition;
    ItemRequirement boneKey;
    ItemRequirement boneKeyHighlighted;
    ItemRequirement robes;
    ItemRequirement book;
    ItemRequirement manual;
    ItemRequirement mapPiece1;
    ItemRequirement mapPiece2;
    ItemRequirement mapPiece3;
    ItemRequirement silkHighlighted;
    ItemRequirement ectoTokensCharos;
    ItemRequirement ectoTokensNoCharos;
    ItemRequirement ectoSheetsEquipped;
    ItemRequirement enchantedGhostspeakEquipped;
    Requirement inPhas;
    Requirement onDragontooth;
    Requirement hasCupOfMilkyTea;
    Requirement hasCupOfTea;
    Requirement hasModelShip;
    Requirement hasRepairedShip;
    Requirement hasPiece1;
    Requirement hasPiece2;
    Requirement hasPiece3;
    Requirement hasMap;
    Requirement lobsterNearby;
    Requirement hasCup;
    Requirement killedLobster;
    Requirement hadChestKey;
    Requirement onDeck;
    Requirement onTopOfShip;
    Requirement onRocks;
    Requirement unlockedChest2;
    Requirement hasBook;
    Requirement hasSheet;
    Requirement hasEctoSheet;
    Requirement hasMysticalRobes;
    Requirement hasManual;
    Requirement boneKeyNearby;
    Requirement hasBoneKey;
    Requirement talkedToAkHaranu;
    Requirement hasSignedOakBow;
    Requirement hasPetition;
    Requirement hasSignatures;
    Requirement givenPetitionToNecro;
    Requirement inUpstairsEcto;
    Requirement doorUnlocked;
    QuestStep enterPhas;
    QuestStep talkToVelorina;
    QuestStep talkToNecrovarus;
    QuestStep enterPhasAfterNecro;
    QuestStep talkToVelorinaAfterNecro;
    QuestStep talkToCrone;
    QuestStep useTeaOnCup;
    QuestStep useMilkOnTea;
    QuestStep talkToCroneAgain;
    QuestStep repairShip;
    QuestStep goUpToDeck;
    QuestStep useKeyOnChest;
    QuestStep goDownFromMast;
    QuestStep searchChestForLobster;
    QuestStep killLobster;
    QuestStep searchChestAfterLobster;
    QuestStep goAcrossPlank;
    QuestStep openSecondChest;
    QuestStep openThirdChest;
    QuestStep useMapsTogether;
    QuestStep enterPhasForDigging;
    QuestStep takeRowingBoat;
    QuestStep digForBook;
    QuestStep returnToPhas;
    QuestStep talkToAkHaranu;
    QuestStep talkToInnkeeper;
    QuestStep useSlimeOnSheet;
    QuestStep talkToGravingas;
    QuestStep talkToVillagers;
    QuestStep showPetitionToNecro;
    QuestStep talkToNecroForKey;
    QuestStep takeKey;
    QuestStep goUpFromNecro;
    QuestStep useKeyOnDoor;
    QuestStep takeRobes;
    QuestStep returnToCrone;
    QuestStep bringCroneAmulet;
    QuestStep talkToNecroAfterCurse;
    QuestStep enterPhasFinal;
    QuestStep talkToVelorinaFinal;
    QuestStep talkToCroneAgainForShip;
    QuestStep enterPhasForManual;
    QuestStep enterPhasForRobe;
    QuestStep talkToRobin;
    QuestStep bringBowToAkHaranu;
    ConditionalStep getBookSteps;
    ConditionalStep getManualSteps;
    ConditionalStep getRobesSteps;
    DyeShipSteps dyeFlags;
    Zone phas1;
    Zone phas2;
    Zone phas3;
    Zone phas4;
    Zone phas5;
    Zone phas6;
    Zone phas7;
    Zone phas8;
    Zone dragontooth;
    Zone deck;
    Zone topOfShip;
    Zone rocks;
    Zone upstairsEcto;
    boolean canUseCharos;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.canUseCharos = this.client.getVarbitValue(QuestVarbits.QUEST_GARDEN_OF_TRANQUILLITY.getId()) > 2;
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.enterPhas, new Requirement[0]);
        startQuest.addStep(this.inPhas, this.talkToVelorina);
        steps.put(0, startQuest);
        steps.put(1, this.talkToNecrovarus);
        ConditionalStep goReturnToVelorina = new ConditionalStep((QuestHelper)this, this.enterPhasAfterNecro, new Requirement[0]);
        goReturnToVelorina.addStep(this.inPhas, this.talkToVelorinaAfterNecro);
        steps.put(2, goReturnToVelorina);
        ConditionalStep makeCroneTea = new ConditionalStep((QuestHelper)this, this.talkToCrone, new Requirement[0]);
        makeCroneTea.addStep(this.hasCupOfMilkyTea, this.talkToCroneAgain);
        makeCroneTea.addStep(this.hasCupOfTea, this.useMilkOnTea);
        makeCroneTea.addStep(this.hasCup, this.useTeaOnCup);
        steps.put(3, makeCroneTea);
        this.getBookSteps = new ConditionalStep((QuestHelper)this, this.talkToCroneAgainForShip, new Requirement[0]);
        this.getBookSteps.addStep(new Conditions(this.hasBook, this.inPhas), this.returnToPhas);
        this.getBookSteps.addStep(new Conditions(this.hasBook, this.onDragontooth), this.returnToPhas);
        this.getBookSteps.addStep(new Conditions(this.hasBook, this.onDragontooth), this.returnToPhas);
        this.getBookSteps.addStep(new Conditions(this.hasMap, this.onDragontooth), this.digForBook);
        this.getBookSteps.addStep(new Conditions(this.hasMap, this.inPhas), this.takeRowingBoat);
        this.getBookSteps.addStep(new Conditions(this.hasMap), this.enterPhasForDigging);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hasPiece2, this.hasPiece3), this.useMapsTogether);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hasPiece2, this.onRocks), this.openThirdChest);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hasPiece2, this.onDeck), this.goAcrossPlank);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hasPiece2, this.onTopOfShip), this.goDownFromMast);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hasPiece2), this.goUpToDeck);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.unlockedChest2, this.onDeck), this.openSecondChest);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hadChestKey, this.onDeck), this.useKeyOnChest);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hadChestKey, this.onTopOfShip), this.goDownFromMast);
        this.getBookSteps.addStep(new Conditions(this.hasPiece1, this.hadChestKey), this.goUpToDeck);
        this.getBookSteps.addStep(new Conditions(this.hasRepairedShip, this.hasPiece1), this.dyeFlags);
        this.getBookSteps.addStep(new Conditions(this.hasRepairedShip, this.killedLobster), this.searchChestAfterLobster);
        this.getBookSteps.addStep(new Conditions(this.hasRepairedShip, this.lobsterNearby), this.killLobster);
        this.getBookSteps.addStep(this.hasRepairedShip, this.searchChestForLobster);
        this.getBookSteps.addStep(this.hasModelShip, this.repairShip);
        this.getBookSteps.setLockingCondition(this.hasBook);
        this.getManualSteps = new ConditionalStep((QuestHelper)this, this.enterPhasForManual, new Requirement[0]);
        this.getManualSteps.addStep(this.onDragontooth, this.returnToPhas);
        this.getManualSteps.addStep(new Conditions(this.inPhas, this.hasSignedOakBow), this.bringBowToAkHaranu);
        this.getManualSteps.addStep(new Conditions(this.inPhas, this.talkedToAkHaranu), this.talkToRobin);
        this.getManualSteps.addStep(this.inPhas, this.talkToAkHaranu);
        this.getManualSteps.setLockingCondition(this.hasManual);
        this.getRobesSteps = new ConditionalStep((QuestHelper)this, this.enterPhasForRobe, new Requirement[0]);
        this.getRobesSteps.addStep(this.onDragontooth, this.returnToPhas);
        this.getRobesSteps.addStep(new Conditions(this.inUpstairsEcto, this.doorUnlocked), this.takeRobes);
        this.getRobesSteps.addStep(new Conditions(this.inUpstairsEcto, this.hasBoneKey), this.useKeyOnDoor);
        this.getRobesSteps.addStep(new Conditions(this.hasBoneKey), this.goUpFromNecro);
        this.getRobesSteps.addStep(new Conditions(this.boneKeyNearby), this.takeKey);
        this.getRobesSteps.addStep(new Conditions(this.givenPetitionToNecro), this.talkToNecroForKey);
        this.getRobesSteps.addStep(new Conditions(this.hasSignatures), this.showPetitionToNecro);
        this.getRobesSteps.addStep(new Conditions(this.hasEctoSheet, this.inPhas, this.hasPetition), this.talkToVillagers);
        this.getRobesSteps.addStep(new Conditions(this.hasEctoSheet, this.inPhas), this.talkToGravingas);
        this.getRobesSteps.addStep(this.hasSheet, this.useSlimeOnSheet);
        this.getRobesSteps.addStep(this.inPhas, this.talkToInnkeeper);
        this.getRobesSteps.setLockingCondition(this.hasMysticalRobes);
        ConditionalStep getItemSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.getBookSteps, new Requirement[0]);
        getItemSteps.addStep(new Conditions(this.hasBook, this.hasManual, this.hasMysticalRobes), this.returnToCrone);
        getItemSteps.addStep(new Conditions(this.hasBook, this.hasManual), this.getRobesSteps);
        getItemSteps.addStep(this.hasBook, this.getManualSteps);
        steps.put(4, getItemSteps);
        steps.put(5, this.bringCroneAmulet);
        steps.put(6, this.talkToNecroAfterCurse);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.enterPhasFinal, new Requirement[0]);
        finishQuest.addStep(this.inPhas, this.talkToVelorinaFinal);
        steps.put(7, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ectoToken2 = new ItemRequirement("Ecto-token, or travel by Charter Ship", 4278, 2);
        this.charos = new ItemRequirement("Ring of Charos (a)", 6465).isNotConsumed();
        this.ectoTokensCharos = new ItemRequirement("20 Ecto-token, OR 10 Ecto-Tokens and coins to travel by Charter Ship", 4278, 20);
        this.ectoTokensNoCharos = new ItemRequirement("31 Ecto-token, OR 25 Ecto-Tokens and coins to travel by Charter Ship", 4278, 31);
        this.ectoToken4 = new ItemRequirement("Ecto-token, or travel by Charter Ship", 4278, 4);
        this.ectoToken12 = new ItemRequirement("Ecto-token, or travel by Charter Ship and 10 ecto-tokens", 4278, 12);
        this.ectoToken27 = new ItemRequirement("Ecto-token, or travel by Charter Ship and 25 ecto-tokens", 4278, 27);
        this.ectoToken10 = new ItemRequirement("Ecto-token", 4278, 10);
        this.ectoToken25 = new ItemRequirement("Ecto-token", 4278, 25);
        this.chestKey = new ItemRequirement("Chest key", 4273);
        this.chestKey.setTooltip("You can get another from the Old man on the abandoned ship");
        this.chestKey.setHighlightInInventory(true);
        this.nettleTea = new ItemRequirement("Nettle tea", 4239);
        this.nettleTea.setTooltip("You can make this by picking nettles whilst wearing gloves (Edgeville yews for example), then using them on a bowl of water. Cook this to have nettle tea");
        this.nettleTeaHighlighted = new ItemRequirement("Nettle tea", 4239);
        this.nettleTeaHighlighted.setTooltip("You can make this by picking nettles whilst wearing gloves (Edgeville yews for example), then using them on a bowl of water. Cook this to have nettle tea");
        this.nettleTeaHighlighted.setHighlightInInventory(true);
        this.milk = new ItemRequirement("Bucket of milk", 1927);
        this.milkHighlighted = new ItemRequirement("Bucket of milk", 1927);
        this.milkHighlighted.setHighlightInInventory(true);
        this.milkyTea = new ItemRequirement("Nettle tea", 4240);
        this.milkyTea.setHighlightInInventory(true);
        this.cup = new ItemRequirement("Porcelain cup", 4244);
        this.cup.setHighlightInInventory(true);
        this.cupWithTea = new ItemRequirement("Cup of tea", 4245);
        this.cupWithTea.setHighlightInInventory(true);
        this.cupWithMilkyTea = new ItemRequirement("Cup of tea", 4246);
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", 552, 1, true).isNotConsumed();
        this.enchantedGhostspeakEquipped = new ItemRequirement("Ghostspeak amulet", 4250, 1, true).isNotConsumed();
        this.coins400 = new ItemRequirement("400+ coins", ItemCollections.COINS, -1);
        this.silk = new ItemRequirement("Silk", 950);
        this.silkHighlighted = new ItemRequirement("Silk", 950);
        this.silkHighlighted.setHighlightInInventory(true);
        ItemRequirement redDye = new ItemRequirement("Red dye", 1763, 3);
        ItemRequirement blueDye = new ItemRequirement("Blue dye", 1767, 3);
        ItemRequirement yellowDye = new ItemRequirement("Yellow dye", 1765, 3);
        this.dyes = new ItemRequirements("3 colours of dyes. Which you'll need is random. To be prepared, bring 3 red/blue/yellow dyes", redDye, blueDye, yellowDye);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.oakLongbow = new ItemRequirement("Oak longbow", 845);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.needle = new ItemRequirement("Needle", 1733).isNotConsumed();
        this.thread = new ItemRequirement("Thread", 1734);
        this.bucketOfSlime = new ItemRequirement("Bucket of slime", 4286);
        this.bucketOfSlime.setTooltip("You can buy one from the Charter Ship crew");
        this.bucketOfSlime.setHighlightInInventory(true);
        this.modelShip = new ItemRequirement("Model ship", 4253);
        this.modelShip.setHighlightInInventory(true);
        this.repairedShip = new ItemRequirement("Model ship", 4254);
        this.mapPiece1 = new ItemRequirement("Map scrap", 4275);
        this.mapPiece2 = new ItemRequirement("Map scrap", 4274);
        this.mapPiece3 = new ItemRequirement("Map scrap", 4276);
        this.map = new ItemRequirement("Treasure map", 4277);
        this.bedsheet = new ItemRequirement("Bedsheet", 4284);
        this.bedsheet.setHighlightInInventory(true);
        this.ectoSheets = new ItemRequirement("Bedsheet", 4285);
        this.ectoSheetsEquipped = new ItemRequirement("Bedsheet", 4285, 1, true);
        this.petition = new ItemRequirement("Petition form", 4283);
        this.boneKey = new ItemRequirement("Bone key", 4272);
        this.boneKeyHighlighted = new ItemRequirement("Bone key", 4272);
        this.boneKeyHighlighted.setHighlightInInventory(true);
        this.robes = new ItemRequirement("Mystical robes", 4247);
        this.book = new ItemRequirement("Book of haricanto", 4248);
        this.manual = new ItemRequirement("Translation manual", 4249);
        this.manual.setTooltip("You can get another from Ak-Haranu");
        this.signedOakBow = new ItemRequirement("Signed oak bow", 4236);
    }

    public void loadZones() {
        this.phas1 = new Zone(new WorldPoint(3653, 3457, 0), new WorldPoint(3710, 3507, 0));
        this.phas2 = new Zone(new WorldPoint(3669, 3508, 0), new WorldPoint(3710, 3510, 0));
        this.phas3 = new Zone(new WorldPoint(3672, 3511, 0), new WorldPoint(3710, 3513, 0));
        this.phas4 = new Zone(new WorldPoint(3675, 3514, 0), new WorldPoint(3710, 3516, 0));
        this.phas5 = new Zone(new WorldPoint(3684, 3517, 0), new WorldPoint(3693, 3532, 0));
        this.phas6 = new Zone(new WorldPoint(3661, 3454, 0), new WorldPoint(3674, 3456, 0));
        this.phas7 = new Zone(new WorldPoint(3675, 3456, 0), new WorldPoint(3709, 3456, 0));
        this.phas8 = new Zone(new WorldPoint(3694, 3454, 0), new WorldPoint(3706, 3455, 0));
        this.upstairsEcto = new Zone(new WorldPoint(3652, 3512, 1), new WorldPoint(3667, 3527, 1));
        this.topOfShip = new Zone(new WorldPoint(3616, 3541, 2), new WorldPoint(3622, 3545, 2));
        this.deck = new Zone(new WorldPoint(3600, 3541, 1), new WorldPoint(3623, 3545, 1));
        this.rocks = new Zone(new WorldPoint(3592, 3547, 0), new WorldPoint(3609, 3571, 0));
        this.dragontooth = new Zone(new WorldPoint(3775, 3520, 0), new WorldPoint(3836, 3581, 0));
    }

    public void setupConditions() {
        this.inPhas = new ZoneRequirement(this.phas1, this.phas2, this.phas3, this.phas4, this.phas5, this.phas6, this.phas7, this.phas8);
        this.inUpstairsEcto = new ZoneRequirement(this.upstairsEcto);
        this.onTopOfShip = new ZoneRequirement(this.topOfShip);
        this.onDeck = new ZoneRequirement(this.deck);
        this.onRocks = new ZoneRequirement(this.rocks);
        this.onDragontooth = new ZoneRequirement(this.dragontooth);
        this.hasCupOfMilkyTea = this.cupWithMilkyTea.alsoCheckBank(this.questBank);
        this.hasCupOfTea = this.cupWithTea.alsoCheckBank(this.questBank);
        this.hasMap = this.map.alsoCheckBank(this.questBank);
        this.hasPiece1 = this.mapPiece1.alsoCheckBank(this.questBank);
        this.hasPiece2 = this.mapPiece2.alsoCheckBank(this.questBank);
        this.hasPiece3 = this.mapPiece3.alsoCheckBank(this.questBank);
        this.hasModelShip = this.modelShip.alsoCheckBank(this.questBank);
        this.hasRepairedShip = this.repairedShip.alsoCheckBank(this.questBank);
        this.hasCup = this.cup.alsoCheckBank(this.questBank);
        this.hasBook = new Conditions(LogicType.OR, new VarbitRequirement(208, 1), this.book.alsoCheckBank(this.questBank));
        this.hasManual = new Conditions(LogicType.OR, new VarbitRequirement(206, 1), new VarbitRequirement(212, 8));
        this.hasSheet = this.bedsheet.alsoCheckBank(this.questBank);
        this.hasEctoSheet = this.ectoSheets.alsoCheckBank(this.questBank);
        this.hasMysticalRobes = new Conditions(LogicType.OR, new VarbitRequirement(207, 1), this.robes.alsoCheckBank(this.questBank));
        this.hasSignedOakBow = this.signedOakBow.alsoCheckBank(this.questBank);
        this.hasPetition = this.petition.alsoCheckBank(this.questBank);
        this.hasSignatures = new VarbitRequirement(209, 11, Operation.GREATER_EQUAL);
        this.givenPetitionToNecro = new VarbitRequirement(209, 31, Operation.GREATER_EQUAL);
        this.hadChestKey = new Conditions(LogicType.OR, this.chestKey, new VarbitRequirement(214, 2, Operation.GREATER_EQUAL));
        this.unlockedChest2 = new VarbitRequirement(214, 3, Operation.GREATER_EQUAL);
        this.doorUnlocked = new VarbitRequirement(213, 1);
        this.lobsterNearby = new NpcCondition(2994);
        this.killedLobster = new VarbitRequirement(215, 1);
        this.boneKeyNearby = new ItemOnTileRequirement(this.boneKey);
        this.hasBoneKey = new Conditions(LogicType.OR, this.boneKey, this.doorUnlocked);
        this.talkedToAkHaranu = new VarbitRequirement(212, 1, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        this.enterPhas = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.ectoToken2, this.ghostspeak);
        this.talkToVelorina = new NpcStep((QuestHelper)this, 2985, new WorldPoint(3677, 3508, 0), "Talk to Velorina in east Port Phasmatys.", this.ghostspeak);
        this.talkToVelorina.addDialogSteps("Why, what is the matter?", "Yes, I do. It is a very sad story.", "Yes.");
        this.talkToNecrovarus = new NpcStep((QuestHelper)this, 2986, new WorldPoint(3660, 3516, 0), "Talk to Necrovarus at the Ectofuntus.", this.ghostspeak);
        this.enterPhasAfterNecro = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.ectoToken2, this.ghostspeak);
        this.talkToVelorinaAfterNecro = new NpcStep((QuestHelper)this, 2985, new WorldPoint(3677, 3508, 0), "Return to Velorina in east Port Phasmatys.", this.ghostspeak);
        this.talkToVelorinaAfterNecro.addSubSteps(this.enterPhasAfterNecro);
        this.talkToCrone = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3462, 3558, 0), "Talk to the Old Crone east of the Slayer Tower.", this.nettleTea, this.milk);
        this.talkToCrone.addDialogSteps("I'm here about Necrovarus.");
        this.useTeaOnCup = new DetailedQuestStep((QuestHelper)this, "Use the nettle tea on the porcelain cup.", this.nettleTeaHighlighted, this.cup);
        this.useMilkOnTea = new DetailedQuestStep((QuestHelper)this, "Use the bucket of milk on the porcelain cup.", this.milkHighlighted, this.cupWithTea);
        this.talkToCroneAgain = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3462, 3558, 0), "Talk to the Old Crone east of the Slayer Tower.", this.cupWithMilkyTea);
        this.talkToCroneAgain.addDialogSteps("I'm here about Necrovarus.");
        this.talkToCroneAgainForShip = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3462, 3558, 0), "Talk to the Old Crone and offer to help.", new Requirement[0]);
        this.talkToCroneAgainForShip.addDialogSteps("I'm here about Necrovarus.");
        this.talkToCroneAgainForShip.addDialogSteps("You are doing so much for me - is there anything I can do for you?", "I am afraid I have lost the boat you gave to me.");
        this.repairShip = new DetailedQuestStep((QuestHelper)this, "Use the silk on the model ship.", this.silkHighlighted, this.needle, this.thread, this.knife, this.modelShip);
        this.searchChestForLobster = new ObjectStep((QuestHelper)this, 16118, new WorldPoint(3618, 3542, 0), "Attempt to search the chest in the east of the hull of the ship west of Port Phasmatys. A giant lobster will spawn you need to kill.", new Requirement[0]);
        ((ObjectStep)this.searchChestForLobster).addAlternateObjects(16119);
        this.killLobster = new NpcStep((QuestHelper)this, 2994, "Kill the Giant Lobster.", new Requirement[0]);
        this.searchChestAfterLobster = new ObjectStep((QuestHelper)this, 16118, new WorldPoint(3618, 3542, 0), "Search the chest in the east of the hull again.", new Requirement[0]);
        ((ObjectStep)this.searchChestAfterLobster).addAlternateObjects(16119);
        this.dyeFlags = new DyeShipSteps(this);
        this.useKeyOnChest = new ObjectStep((QuestHelper)this, 16116, new WorldPoint(3619, 3545, 1), "Use the key on the chest in the Captain's Room, then search it.", this.chestKey);
        this.useKeyOnChest.addIcon(432);
        this.openSecondChest = new ObjectStep((QuestHelper)this, 16116, new WorldPoint(3619, 3545, 1), "Search the chest in the Captain's Room.", new Requirement[0]);
        this.useKeyOnChest.addSubSteps(this.openSecondChest);
        this.goDownFromMast = new ObjectStep((QuestHelper)this, 16112, new WorldPoint(3615, 3541, 2), "Go to the main deck of the ship.", new Requirement[0]);
        this.goUpToDeck = new ObjectStep((QuestHelper)this, 16111, new WorldPoint(3613, 3543, 0), "Go up the ladder in the ship west of Port Phasmatys.", new Requirement[0]);
        this.goAcrossPlank = new ObjectStep((QuestHelper)this, 16651, new WorldPoint(3605, 3546, 1), "Go across the gangplank to the north.", new Requirement[0]);
        this.goAcrossPlank.addSubSteps(this.goDownFromMast, this.goUpToDeck);
        this.openThirdChest = new ObjectStep((QuestHelper)this, 16118, new WorldPoint(3606, 3564, 0), "Jump across the rocks to the chest and search it for a map piece.", new Requirement[0]);
        ((ObjectStep)this.openThirdChest).addAlternateObjects(16119);
        ((ObjectStep)this.openThirdChest).setLinePoints(Arrays.asList(new WorldPoint(3604, 3550, 0), new WorldPoint(3601, 3550, 0), new WorldPoint(3601, 3552, 0), new WorldPoint(3595, 3552, 0), new WorldPoint(3595, 3557, 0), new WorldPoint(3597, 3557, 0), new WorldPoint(3597, 3564, 0), new WorldPoint(3605, 3564, 0)));
        this.useMapsTogether = new DetailedQuestStep((QuestHelper)this, "Use the map pieces together.", this.mapPiece1.highlighted(), this.mapPiece2.highlighted(), this.mapPiece3.highlighted());
        if (this.canUseCharos) {
            this.enterPhasForDigging = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.charos, this.ectoToken12, this.spade, this.map, this.ghostspeak);
            this.takeRowingBoat = new NpcStep((QuestHelper)this, 3005, new WorldPoint(3703, 3487, 0), "Talk to the Ghost captain at the rowing boat on the docks with your Ring of Charos (a) equipped.", this.charos, this.ectoToken10, this.spade, this.map);
        } else {
            this.enterPhasForDigging = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.ectoToken27, this.spade, this.map, this.ghostspeak);
            this.takeRowingBoat = new NpcStep((QuestHelper)this, 3005, new WorldPoint(3703, 3487, 0), "Travel on the rowing boat on the docks.", this.ectoToken25, this.spade, this.map, this.ghostspeak);
        }
        this.digForBook = new DigStep((QuestHelper)this, new WorldPoint(3803, 3530, 0), "Dig on the south of the island for a book.", this.map);
        this.returnToPhas = new NpcStep((QuestHelper)this, 3005, new WorldPoint(3791, 3559, 0), "Return to Port Phasmatys with the Ghost Captain.", this.ghostspeak);
        this.enterPhasForManual = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.ectoToken2, this.ghostspeak);
        this.talkToAkHaranu = new NpcStep((QuestHelper)this, 2989, new WorldPoint(3689, 3499, 0), "Talk to Ak-Haranu.", new Requirement[0]);
        this.talkToAkHaranu.addDialogStep("Okay, wait here - I'll get you your bow.");
        this.talkToAkHaranu.addSubSteps(this.enterPhasForManual);
        this.talkToRobin = new NpcStep((QuestHelper)this, 2995, new WorldPoint(3675, 3495, 0), "Talk to Robin in the Port Phasmatys pub. Keep playing runedraw until he agrees to sign your bow.", this.oakLongbow, this.coins400);
        this.talkToRobin.addDialogStep("Yes, I'll give you a game.");
        this.bringBowToAkHaranu = new NpcStep((QuestHelper)this, 2989, new WorldPoint(3689, 3499, 0), "Bring the signed bow to Ak-Haranu.", this.signedOakBow);
        this.enterPhasForRobe = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys.", this.ectoToken2, this.ghostspeak);
        this.talkToInnkeeper = new NpcStep((QuestHelper)this, 3001, new WorldPoint(3681, 3495, 0), "Talk to the Ghost Innkeeper.", this.ghostspeak);
        this.talkToInnkeeper.addDialogSteps("Do you have any jobs I can do?", "Yes, I'd be delighted.");
        this.talkToInnkeeper.addSubSteps(this.enterPhasForRobe);
        this.useSlimeOnSheet = new DetailedQuestStep((QuestHelper)this, "Use a bucket of slime on the bedsheets.", this.bucketOfSlime, this.bedsheet);
        this.talkToGravingas = new NpcStep((QuestHelper)this, 2987, new WorldPoint(3660, 3499, 0), "Talk to Gravingas wearing the bedsheet.", this.ectoSheetsEquipped, this.ghostspeak);
        this.talkToGravingas.addDialogStep("After hearing Velorina's story I will be happy to help out.");
        this.talkToVillagers = new NpcStep((QuestHelper)this, 2998, new WorldPoint(3662, 3497, 0), "Alternate talking with the ghost villagers until you have 10 signatures.", true, this.ghostspeak);
        this.showPetitionToNecro = new NpcStep((QuestHelper)this, 2986, new WorldPoint(3660, 3516, 0), "Bring the petition to Necrovarus at the Ectofuntus to cause him to drop a bone key.", this.petition, this.ghostspeak);
        this.talkToNecroForKey = new NpcStep((QuestHelper)this, 2986, new WorldPoint(3660, 3516, 0), "Talk to Necrovarus at the Ectofuntus until he drops a bone key.", this.ghostspeak);
        this.showPetitionToNecro.addSubSteps(this.talkToNecroForKey);
        this.takeKey = new ItemStep((QuestHelper)this, "Pick up the bone key.", this.boneKey);
        this.goUpFromNecro = new ObjectStep((QuestHelper)this, 16646, new WorldPoint(3667, 3520, 0), "Go upstairs at the Ectofuntus.", new Requirement[0]);
        this.useKeyOnDoor = new ObjectStep((QuestHelper)this, 5244, new WorldPoint(3656, 3514, 1), "Use the key on the south room's door.", this.boneKeyHighlighted);
        this.useKeyOnDoor.addIcon(4272);
        this.takeRobes = new ObjectStep((QuestHelper)this, 16644, new WorldPoint(3660, 3514, 1), "Search the coffin.", new Requirement[0]);
        ((ObjectStep)this.takeRobes).addAlternateObjects(16645);
        this.returnToCrone = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3462, 3558, 0), "Bring the items to the Old Crone east of the Slayer Tower.", this.robes, this.book, this.manual, this.ghostspeak);
        this.returnToCrone.addDialogSteps("I'm here about Necrovarus.");
        this.bringCroneAmulet = new NpcStep((QuestHelper)this, 2996, new WorldPoint(3462, 3558, 0), "Bring a ghostspeak amulet to the Old Crone east of the Slayer Tower.", this.ghostspeak);
        this.bringCroneAmulet.addDialogSteps("I'm here about Necrovarus.");
        this.returnToCrone.addSubSteps(this.bringCroneAmulet);
        this.talkToNecroAfterCurse = new NpcStep((QuestHelper)this, 2986, new WorldPoint(3660, 3516, 0), "Talk to Necrovarus at the Ectofuntus.", this.enchantedGhostspeakEquipped);
        this.talkToNecroAfterCurse.addDialogStep("Let any ghost who so wishes pass on into the next world.");
        this.enterPhasFinal = new ObjectStep((QuestHelper)this, 16105, new WorldPoint(3660, 3508, 0), "Enter Port Phasmatys. You don't need ecto-tokens for this any more.", this.ghostspeak);
        this.talkToVelorinaFinal = new NpcStep((QuestHelper)this, 2985, new WorldPoint(3677, 3508, 0), "Talk to Velorina in east Port Phasmatys to finish!", this.ghostspeak);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        if (this.canUseCharos) {
            return Arrays.asList(this.ghostspeak, this.charos, this.ectoTokensCharos, this.coins400, this.nettleTea, this.milk, this.silk, this.knife, this.needle, this.thread, this.dyes, this.spade, this.oakLongbow, this.bucketOfSlime);
        }
        return Arrays.asList(this.ghostspeak, this.ectoTokensNoCharos, this.coins400, this.nettleTea, this.milk, this.silk, this.knife, this.needle, this.thread, this.dyes, this.spade, this.oakLongbow, this.bucketOfSlime);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Giant lobster (level 32) (safespottable)");
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Arrays.asList(this.enterPhas, this.talkToVelorina, this.talkToNecrovarus, this.talkToVelorinaAfterNecro), this.ghostspeak, this.ectoToken4));
        allSteps.add(new PanelDetails("Getting help", Arrays.asList(this.talkToCrone, this.useTeaOnCup, this.useMilkOnTea, this.talkToCroneAgain, this.talkToCroneAgainForShip), this.ghostspeak, this.nettleTea, this.milk));
        List<QuestStep> mapSteps = QuestUtil.toArrayList(this.repairShip, this.searchChestForLobster, this.killLobster, this.searchChestAfterLobster);
        mapSteps.addAll(this.dyeFlags.getDisplaySteps());
        mapSteps.addAll(Arrays.asList(this.useKeyOnChest, this.goAcrossPlank, this.openThirdChest, this.useMapsTogether, this.enterPhasForDigging, this.takeRowingBoat, this.digForBook, this.returnToPhas));
        PanelDetails bookPanel = this.canUseCharos ? new PanelDetails("Finding the book", mapSteps, this.ghostspeak, this.silk, this.needle, this.thread, this.knife, this.dyes, this.spade, this.ectoToken12, this.charos) : new PanelDetails("Finding the book", mapSteps, this.ghostspeak, this.silk, this.needle, this.thread, this.knife, this.dyes, this.spade, this.ectoToken27);
        bookPanel.setLockingStep(this.getBookSteps);
        allSteps.add(bookPanel);
        PanelDetails manualPanel = new PanelDetails("Finding the manual", Arrays.asList(this.talkToAkHaranu, this.talkToRobin, this.bringBowToAkHaranu), this.coins400, this.oakLongbow);
        manualPanel.setLockingStep(this.getManualSteps);
        allSteps.add(manualPanel);
        PanelDetails robePanel = new PanelDetails("Finding the robes", Arrays.asList(this.talkToInnkeeper, this.useSlimeOnSheet, this.talkToGravingas, this.talkToVillagers, this.showPetitionToNecro, this.goUpFromNecro, this.useKeyOnDoor, this.takeRobes), this.ghostspeak, this.bucketOfSlime);
        robePanel.setLockingStep(this.getRobesSteps);
        allSteps.add(robePanel);
        allSteps.add(new PanelDetails("Undoing the curse", Arrays.asList(this.returnToCrone, this.talkToNecroAfterCurse, this.talkToVelorinaFinal), this.ghostspeak, this.book, this.manual, this.robes));
        return allSteps;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.PRAYER, 2400));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ectophial", 4251, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Free passage into Port Phasmatys"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 25, true));
        req.add(new SkillRequirement(Skill.COOKING, 20, true));
        return req;
    }
}

