/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ghostsahoy;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class DyeShipSteps
extends DetailedOwnerStep {
    boolean coloursKnown = false;
    HashMap<String, FlagColour> shapeColours = new HashMap();
    HashMap<String, FlagColour> currentColours = new HashMap();
    DetailedQuestStep searchMast;
    DetailedQuestStep dyeTop;
    DetailedQuestStep dyeSkull;
    DetailedQuestStep dyeBottom;
    DetailedQuestStep goDownToMan;
    DetailedQuestStep talkToMan;
    DetailedQuestStep goUpToMan;
    DetailedQuestStep goUpToDeckForMast;
    DetailedQuestStep goUpToMast;
    Requirement onTopOfShip;
    Requirement onDeck;
    Zone topOfShip = new Zone(new WorldPoint(3616, 3541, 2), new WorldPoint(3622, 3545, 2));
    Zone deck = new Zone(new WorldPoint(3600, 3541, 1), new WorldPoint(3623, 3545, 1));
    ItemRequirement modelShip;

    public DyeShipSteps(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
        this.onTopOfShip = new ZoneRequirement(this.topOfShip);
        this.onDeck = new ZoneRequirement(this.deck);
        this.shapeColours.put("skull", FlagColour.WHITE);
        this.shapeColours.put("top", FlagColour.WHITE);
        this.shapeColours.put("bottom", FlagColour.WHITE);
        this.currentColours.put("skull", FlagColour.WHITE);
        this.currentColours.put("top", FlagColour.WHITE);
        this.currentColours.put("bottom", FlagColour.WHITE);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    private void updateCurrentColours() {
        String[] splitText;
        Widget dyed = this.client.getWidget(12648450);
        if (dyed == null) {
            return;
        }
        String text = dyed.getText();
        if (text.isEmpty()) {
            return;
        }
        String[] splitOnNewLines = text.split("<br>");
        if (splitOnNewLines.length > 1) {
            for (String splitOnNewLine : splitOnNewLines) {
                this.updateCurrentColoursFromString(splitOnNewLine);
            }
        }
        if ((splitText = text.split("dye the ")).length < 2) {
            return;
        }
        this.updateCurrentColoursFromString(splitText[1]);
    }

    private void updateCurrentColoursFromString(String text) {
        String[] shapeAndColour = text.split(" (emblem|of the flag) ");
        if (shapeAndColour.length < 2) {
            return;
        }
        String shape = shapeAndColour[0];
        String colour = shapeAndColour[1];
        shape = shape.replace("The ", "");
        colour = colour.replace("is ", "");
        this.currentColours.put(shape, FlagColour.findByKey(colour));
    }

    @Override
    public void updateSteps() {
        this.updateCurrentColours();
        this.updateColours();
        FlagColour topColour = this.shapeColours.get("top");
        FlagColour bottomColour = this.shapeColours.get("bottom");
        FlagColour skullColour = this.shapeColours.get("skull");
        FlagColour currentTopColour = this.currentColours.get("top");
        FlagColour currentBottomColour = this.currentColours.get("bottom");
        FlagColour currentSkullColour = this.currentColours.get("skull");
        if (!this.coloursKnown && topColour != FlagColour.WHITE && skullColour != FlagColour.WHITE && bottomColour != FlagColour.WHITE) {
            this.coloursKnown = true;
            this.dyeTop.setRequirements(Arrays.asList(topColour.getItem(), this.modelShip));
            this.dyeTop.setText("Dye the top of the model ship's flag " + topColour.getColourText() + " If you already have, inspect the ship.");
            this.dyeTop.addDialogStep("Top half");
            this.dyeBottom.setRequirements(Arrays.asList(bottomColour.getItem(), this.modelShip));
            this.dyeBottom.setText("Dye the bottom of the model ship's flag " + bottomColour.getColourText() + " If you already have, inspect the ship.");
            this.dyeBottom.addDialogStep("Bottom half");
            this.dyeSkull.setRequirements(Arrays.asList(skullColour.getItem(), this.modelShip));
            this.dyeSkull.addDialogStep("Skull emblem");
            this.dyeSkull.setText("Dye the skull on the model ship's flag " + skullColour.getColourText() + " If you already have, inspect the ship.");
        }
        if (!this.coloursKnown) {
            if (this.onDeck.check(this.client)) {
                this.startUpStep(this.goUpToMast);
            } else if (this.onTopOfShip.check(this.client)) {
                this.startUpStep(this.searchMast);
            } else {
                this.startUpStep(this.goUpToDeckForMast);
            }
            return;
        }
        if (topColour != currentTopColour) {
            this.startUpStep(this.dyeTop);
        } else if (bottomColour != currentBottomColour) {
            this.startUpStep(this.dyeBottom);
        } else if (skullColour != currentSkullColour) {
            this.startUpStep(this.dyeSkull);
        } else if (this.onTopOfShip.check(this.client)) {
            this.startUpStep(this.goDownToMan);
        } else if (this.onDeck.check(this.client)) {
            this.startUpStep(this.talkToMan);
        } else {
            this.startUpStep(this.goUpToMan);
        }
    }

    public void updateColours() {
        Widget textWidget = this.client.getWidget(229, 1);
        if (textWidget != null) {
            String text = textWidget.getText();
            if (text.isEmpty()) {
                return;
            }
            String[] splitText = text.split("The ");
            if (splitText.length < 2) {
                return;
            }
            String mainText = splitText[1];
            if (!mainText.contains("coloured")) {
                return;
            }
            String[] shapeAndColour = mainText.split(" (emblem|half of the flag) is coloured ");
            if (shapeAndColour.length < 2) {
                return;
            }
            String shape = shapeAndColour[0];
            String colour = shapeAndColour[1];
            this.shapeColours.put(shape, FlagColour.findByKey(colour));
        }
    }

    @Override
    protected void setupSteps() {
        this.modelShip = new ItemRequirement("Model ship", 4254);
        this.modelShip.setHighlightInInventory(true);
        this.searchMast = new ObjectStep(this.getQuestHelper(), 16640, new WorldPoint(3619, 3543, 2), "Search the Mast repeatedly until you've found out all the colours for the toy boat.", new Requirement[0]);
        this.dyeTop = new DetailedQuestStep(this.getQuestHelper(), "Dye the top of the model ship's flag to match the real ship.", this.modelShip);
        this.dyeBottom = new DetailedQuestStep(this.getQuestHelper(), "Dye the bottom of the model ship's flag to match the real ship.", this.modelShip);
        this.dyeSkull = new DetailedQuestStep(this.getQuestHelper(), "Dye the skull of the model ship's flag to match the real ship.", this.modelShip);
        this.talkToMan = new NpcStep(this.getQuestHelper(), 2997, new WorldPoint(3616, 3543, 1), "Talk to the Old Man with the model ship to get a key.", new Requirement[0]);
        this.talkToMan.addDialogStep("Is this your toy boat?");
        this.goDownToMan = new ObjectStep(this.getQuestHelper(), 16112, new WorldPoint(3615, 3541, 2), "Go to the main deck of the ship.", new Requirement[0]);
        this.goUpToMan = new ObjectStep(this.getQuestHelper(), 16111, new WorldPoint(3613, 3543, 0), "Go up the ladder in the ship west of Port Phasmatys.", new Requirement[0]);
        this.goDownToMan.addSubSteps(this.goUpToMan);
        this.goUpToDeckForMast = new ObjectStep(this.getQuestHelper(), 16111, new WorldPoint(3613, 3543, 0), "Go up the ladder in the ship west of Port Phasmatys.", new Requirement[0]);
        this.goUpToMast = new ObjectStep(this.getQuestHelper(), 16111, new WorldPoint(3615, 3541, 1), "Go up to the mast of the ship.", new Requirement[0]);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.searchMast, this.dyeTop, this.dyeBottom, this.dyeSkull, this.talkToMan, this.goDownToMan, this.goUpToMan, this.goUpToDeckForMast, this.goUpToMast);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.goUpToDeckForMast, this.goUpToMast, this.searchMast, this.dyeTop, this.dyeBottom, this.dyeSkull, this.goDownToMan, this.talkToMan);
    }

    private static enum FlagColour {
        RED("red.", new ItemRequirement("Red dye", 1763)),
        BLUE("blue.", new ItemRequirement("Blue dye", 1767)),
        YELLOW("yellow.", new ItemRequirement("Yellow dye", 1765)),
        GREEN("green.", new ItemRequirement("Green dye", 1771)),
        PURPLE("purple.", new ItemRequirement("Purple dye", 1773)),
        ORANGE("orange.", new ItemRequirement("Orange dye", 1769)),
        WHITE("white.", new ItemRequirement("White", -1, -1));

        private final String colourText;
        private final ItemRequirement item;

        private FlagColour(String colourText, ItemRequirement item) {
            this.colourText = colourText;
            item.setHighlightInInventory(true);
            this.item = item;
        }

        public String getColourText() {
            return this.colourText;
        }

        public ItemRequirement getItem() {
            return this.item;
        }

        public static FlagColour findByKey(String colour) {
            FlagColour[] flagColours;
            for (FlagColour flagColour : flagColours = FlagColour.values()) {
                if (!flagColour.colourText.equals(colour)) continue;
                return flagColour;
            }
            return null;
        }
    }
}

