/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.gettingahead;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.GETTING_AHEAD)
public class GettingAhead
extends BasicQuestHelper {
    ItemRequirement bearFur;
    ItemRequirement softClay;
    ItemRequirement hammer;
    ItemRequirement saw;
    ItemRequirement planks;
    ItemRequirement nails;
    ItemRequirement knife;
    ItemRequirement redDye;
    ItemRequirement potOfFlour;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement food;
    ItemRequirement staminaPotions;
    ItemRequirement combatGear;
    ItemRequirement skillsNeck;
    ItemRequirement clayHead;
    ItemRequirement clayHeadHighlighted;
    ItemRequirement furHead;
    ItemRequirement furHeadHighlighted;
    ItemRequirement bloodyHead;
    ItemRequirement clay;
    ItemRequirement pickaxe;
    ItemRequirement bucket;
    ItemRequirement bucketOfWater;
    ItemRequirement itemsTip;
    QuestStep talkToGordon1;
    QuestStep talkToMary;
    QuestStep talkToGordon2;
    QuestStep talkToMary2;
    QuestStep talkToGordonGen;
    QuestStep talkToGordonGen2;
    QuestStep talkToGordonGen3;
    QuestStep talkToGordonFinal;
    QuestStep usePotOfFlour;
    QuestStep goToMine;
    QuestStep leaveCave;
    QuestStep killBeast;
    QuestStep useKnifeOnClay;
    QuestStep useFurOnHead;
    QuestStep useDyeOnHead;
    QuestStep buildBearHead;
    QuestStep goUpstairsHouse;
    QuestStep takePot;
    QuestStep goDownstairsHouse;
    QuestStep getNeedle;
    QuestStep getThread;
    QuestStep takePickaxe;
    QuestStep mineClay;
    QuestStep takeKnife;
    QuestStep fillBucket;
    QuestStep wetClay;
    QuestStep takeBucket;
    QuestStep takeDye;
    QuestStep takeNails;
    QuestStep takeSaw;
    QuestStep takeHammer;
    QuestStep takePlanks;
    ConditionalStep goUseFlourOnGate;
    ConditionalStep returnToGordon;
    ConditionalStep makeClayHead;
    ConditionalStep addFurToHead;
    ConditionalStep dyeHead;
    ConditionalStep putUpHead;
    Requirement inMine;
    Requirement inUpstairsHouse;
    Zone kebosMine;
    Zone upstairsHouse;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToGordon1);
        steps.put(2, this.talkToMary);
        this.goUseFlourOnGate = new ConditionalStep((QuestHelper)this, this.goUpstairsHouse, "Use the pot of flour on the cow pen gate.", new Requirement[0]);
        this.goUseFlourOnGate.addStep(new Conditions(this.inUpstairsHouse, this.potOfFlour), this.goDownstairsHouse);
        this.goUseFlourOnGate.addStep(new Conditions(this.potOfFlour), this.usePotOfFlour);
        this.goUseFlourOnGate.addStep(this.inUpstairsHouse, this.takePot);
        steps.put(4, this.goUseFlourOnGate);
        ConditionalStep killBeastStep = new ConditionalStep((QuestHelper)this, this.goToMine, new Requirement[0]);
        killBeastStep.addStep(this.inMine, this.killBeast);
        steps.put(6, killBeastStep);
        steps.put(8, killBeastStep);
        steps.put(10, killBeastStep);
        steps.put(12, killBeastStep);
        this.returnToGordon = new ConditionalStep((QuestHelper)this, this.takePickaxe, "Return to Gordon and talk to him.", new Requirement[0]);
        this.returnToGordon.addStep(this.inMine, this.leaveCave);
        this.returnToGordon.addStep(new Conditions(new Conditions(LogicType.OR, this.clay, this.softClay), this.planks), this.talkToGordon2);
        this.returnToGordon.addStep(new Conditions(LogicType.OR, this.clay, this.softClay), this.takePlanks);
        this.returnToGordon.addStep(this.pickaxe, this.mineClay);
        steps.put(14, this.returnToGordon);
        steps.put(16, this.talkToMary2);
        this.makeClayHead = new ConditionalStep((QuestHelper)this, this.takePickaxe, "Use the knife on the soft clay then talk to Gordon.", new Requirement[0]);
        this.makeClayHead.addStep(new Conditions(this.softClay, this.knife), this.useKnifeOnClay);
        this.makeClayHead.addStep(this.softClay, this.takeKnife);
        this.makeClayHead.addStep(new Conditions(this.bucketOfWater, this.clay), this.wetClay);
        this.makeClayHead.addStep(new Conditions(this.bucket, this.clay), this.fillBucket);
        this.makeClayHead.addStep(this.clay, this.takeBucket);
        this.makeClayHead.addStep(this.pickaxe, this.mineClay);
        this.makeClayHead.addSubSteps(this.talkToGordonGen);
        steps.put(18, this.makeClayHead);
        steps.put(20, this.talkToGordonGen);
        this.addFurToHead = new ConditionalStep((QuestHelper)this, this.goUpstairsHouse, "Use the bear fur on the clay head then talk to Gordon.", new Requirement[0]);
        this.addFurToHead.addStep(new Conditions(this.thread, this.needle), this.useFurOnHead);
        this.addFurToHead.addStep(new Conditions(this.inUpstairsHouse, this.needle), this.getThread);
        this.addFurToHead.addStep(this.inUpstairsHouse, this.getNeedle);
        this.addFurToHead.addSubSteps(this.talkToGordonGen2);
        steps.put(22, this.addFurToHead);
        steps.put(24, this.talkToGordonGen2);
        this.dyeHead = new ConditionalStep((QuestHelper)this, this.takeDye, "Use the red dye on the fur head then talk to Gordon.", new Requirement[0]);
        this.dyeHead.addStep(this.redDye, this.useDyeOnHead);
        this.dyeHead.addSubSteps(this.talkToGordonGen3);
        steps.put(26, this.dyeHead);
        steps.put(28, this.talkToGordonGen3);
        this.putUpHead = new ConditionalStep((QuestHelper)this, this.takePlanks, "Build the Mounted Head Space inside the farmhouse.", new Requirement[0]);
        this.putUpHead.addStep(new Conditions(this.planks, this.hammer, this.saw, this.nails), this.buildBearHead);
        this.putUpHead.addStep(new Conditions(this.planks, this.hammer, this.saw), this.takeNails);
        this.putUpHead.addStep(new Conditions(this.planks, this.hammer), this.takeSaw);
        this.putUpHead.addStep(this.planks, this.takeHammer);
        steps.put(30, this.putUpHead);
        steps.put(32, this.talkToGordonFinal);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.itemsTip = new ItemRequirement("You can get all the required items during the quest.", -1, -1);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.staminaPotions = new ItemRequirement("Stamina Potion", ItemCollections.STAMINA_POTIONS);
        this.skillsNeck = new ItemRequirement("Skills Necklace", ItemCollections.SKILLS_NECKLACES);
        this.bearFur = new ItemRequirement("Bear Fur", 948);
        this.bearFur.canBeObtainedDuringQuest();
        this.bearFur.setTooltip("You can kill a bear west of the farm for some fur");
        this.bearFur.setHighlightInInventory(true);
        this.softClay = new ItemRequirement("Soft Clay", 1761, 1);
        this.softClay.canBeObtainedDuringQuest();
        this.softClay.setHighlightInInventory(true);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.hammer.canBeObtainedDuringQuest();
        this.saw = new ItemRequirement("Any saw", 8794).isNotConsumed();
        this.saw.canBeObtainedDuringQuest();
        this.saw.addAlternates(9625, 24880);
        this.planks = new ItemRequirement("Planks", 960, 2);
        this.planks.canBeObtainedDuringQuest();
        this.nails = new ItemRequirement("Nails", ItemCollections.NAILS, 6);
        this.nails.canBeObtainedDuringQuest();
        this.knife = new ItemRequirement("Knife", 946, 1).isNotConsumed();
        this.knife.canBeObtainedDuringQuest();
        this.knife.setHighlightInInventory(true);
        this.redDye = new ItemRequirement("Red Dye", 1763, 1);
        this.redDye.canBeObtainedDuringQuest();
        this.redDye.setHighlightInInventory(true);
        this.potOfFlour = new ItemRequirement("Pot of Flour", 1933, 1);
        this.potOfFlour.canBeObtainedDuringQuest();
        this.potOfFlour.setHighlightInInventory(true);
        this.needle = new ItemRequirement("Needle", 1733, 1).isNotConsumed();
        this.needle.canBeObtainedDuringQuest();
        this.thread = new ItemRequirement("Thread", 1734, 1);
        this.thread.canBeObtainedDuringQuest();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.pickaxe.canBeObtainedDuringQuest();
        this.clay = new ItemRequirement("Clay", 434);
        this.clay.canBeObtainedDuringQuest();
        this.clay.setHighlightInInventory(true);
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.bucket.canBeObtainedDuringQuest();
        this.bucket.setHighlightInInventory(true);
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.bucketOfWater.canBeObtainedDuringQuest();
        this.bucketOfWater.setHighlightInInventory(true);
        this.clayHead = new ItemRequirement("Clay Head", 25145);
        this.clayHead.setTooltip("You can make another by using a knife on some soft clay");
        this.clayHeadHighlighted = new ItemRequirement("Clay Head", 25145);
        this.clayHeadHighlighted.setTooltip("You can make another by using a knife on some soft clay");
        this.clayHeadHighlighted.setHighlightInInventory(true);
        this.furHead = new ItemRequirement("Fur Head", 25146);
        this.furHead.setTooltip("You can make another by using a knife on soft clay, then adding bear fur");
        this.furHeadHighlighted = new ItemRequirement("Fur Head", 25146);
        this.furHeadHighlighted.setTooltip("You can make another by using a knife on soft clay, then adding bear fur");
        this.furHeadHighlighted.setHighlightInInventory(true);
        this.bloodyHead = new ItemRequirement("Bloody Head", 25147);
    }

    public void setupConditions() {
        this.inMine = new ZoneRequirement(this.kebosMine);
        this.inUpstairsHouse = new ZoneRequirement(this.upstairsHouse);
    }

    public void loadZones() {
        this.kebosMine = new Zone(new WorldPoint(1174, 10000, 0), new WorldPoint(1215, 10035, 0));
        this.upstairsHouse = new Zone(new WorldPoint(1238, 3677, 1), new WorldPoint(1244, 3687, 1));
    }

    public void setupSteps() {
        this.talkToGordon1 = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "Talk to Gordon south of the Farming Guild.", new Requirement[0]);
        this.talkToGordon1.addDialogStep("Need a hand with anything?");
        this.talkToGordon1.addDialogStep("Yes.");
        this.talkToMary = new NpcStep((QuestHelper)this, 10502, new WorldPoint(1237, 3678, 0), "Talk to Mary inside the main building, west of Gordon.", new Requirement[0]);
        this.goUpstairsHouse = new ObjectStep((QuestHelper)this, 34502, new WorldPoint(1240, 3686, 0), "Climb up the nearby house's staircase.", new Requirement[0]);
        this.takePot = new ItemStep((QuestHelper)this, "Take the nearby pot of flour, or fill a pot with the barrel of flour in the south west room.", this.potOfFlour);
        this.goDownstairsHouse = new ObjectStep((QuestHelper)this, 34503, new WorldPoint(1240, 3686, 1), "Go back downstairs.", new Requirement[0]);
        this.usePotOfFlour = new ObjectStep((QuestHelper)this, 40427, new WorldPoint(1257, 3686, 0), "", this.potOfFlour);
        this.usePotOfFlour.addIcon(1933);
        this.goToMine = new ObjectStep((QuestHelper)this, 20852, new WorldPoint(1212, 3647, 0), "Enter the Kebos Lowlands mine just west of the bridge and kill the Headless Beast (level 82).", new Requirement[0]);
        this.goToMine.addDialogStep("Yes.");
        this.killBeast = new NpcStep((QuestHelper)this, 10506, new WorldPoint(1191, 10021, 0), "Kill the headless beast. You can safespot it from the south west corner of the pond in the cave.", new Requirement[0]);
        ((NpcStep)this.killBeast).addSafeSpots(new WorldPoint(1190, 10017, 0));
        this.goToMine.addSubSteps(this.killBeast);
        this.talkToGordon2 = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "", new Requirement[0]);
        this.leaveCave = new ObjectStep((QuestHelper)this, 20853, new WorldPoint(1190, 10029, 0), "Leave the cave.", new Requirement[0]);
        this.talkToGordon2.addSubSteps(this.leaveCave);
        this.talkToGordonGen = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "Talk with Gordon.", this.clayHead);
        this.talkToGordonGen2 = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "Talk with Gordon.", this.furHead);
        this.talkToGordonGen3 = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "Talk with Gordon.", this.bloodyHead);
        this.talkToMary2 = new NpcStep((QuestHelper)this, 10502, new WorldPoint(1237, 3678, 0), "Talk to Mary inside the house.", new Requirement[0]);
        this.takePickaxe = new ObjectStep((QuestHelper)this, 40365, new WorldPoint(1222, 3653, 0), "Take the pickaxe in the mine.", new Requirement[0]);
        this.mineClay = new ObjectStep((QuestHelper)this, 11362, new WorldPoint(1217, 3657, 0), "Mine some clay.", this.pickaxe);
        this.takeKnife = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1241, 3679, 0), "Take the knife near Mary.", this.knife);
        this.takeBucket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1244, 3682, 0), "Take the bucket in the house.", this.bucket);
        this.fillBucket = new ObjectStep((QuestHelper)this, 1763, new WorldPoint(1240, 3677, 0), "Fill the bucket on the sink.", this.bucket);
        this.fillBucket.addIcon(1925);
        this.wetClay = new DetailedQuestStep((QuestHelper)this, "Use the bucket of water on the clay.", this.bucketOfWater, this.clay);
        this.useKnifeOnClay = new DetailedQuestStep((QuestHelper)this, "", this.knife, this.softClay);
        this.useKnifeOnClay.addDialogStep("Yes.");
        this.getNeedle = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1244, 3685, 1), "Take the needle.", this.needle);
        this.getThread = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1244, 3684, 1), "Take the thread.", this.thread);
        this.useFurOnHead = new DetailedQuestStep((QuestHelper)this, "Use the bear fur on the clay head then talk to Gordon.", this.bearFur, this.clayHeadHighlighted, this.thread, this.needle);
        this.useFurOnHead.addDialogStep("Yes.");
        this.takeDye = new ObjectStep((QuestHelper)this, 40362, new WorldPoint(1240, 3688, 0), "Get some red dye from the shelves in the farm house.", new Requirement[0]);
        this.takeDye.addDialogStep("Take some red dye.");
        this.useDyeOnHead = new DetailedQuestStep((QuestHelper)this, "", this.redDye, this.furHeadHighlighted);
        this.useDyeOnHead.addDialogStep("Yes.");
        this.useDyeOnHead.addSubSteps(this.talkToGordonGen3);
        this.takePlanks = new ItemStep((QuestHelper)this, new WorldPoint(1202, 3649, 0), "Take the planks outside the monster's cave.", this.planks);
        this.takeSaw = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1239, 3696, 0), "Take the saw in the building north of the farmhouse.", this.saw);
        this.takeHammer = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1259, 3686, 0), "Take the hammer east of the farmhouse.", this.hammer);
        this.takeNails = new ObjectStep((QuestHelper)this, 40364, new WorldPoint(1239, 3699, 0), "Take some nails from the farm's workbench.", new Requirement[0]);
        this.takeNails.addDialogStep("Take the nails.");
        this.buildBearHead = new ObjectStep((QuestHelper)this, 20858, new WorldPoint(1240, 3683, 0), "", this.bloodyHead, this.nails, this.planks, this.saw, this.hammer);
        this.buildBearHead.addDialogStep("Yes.");
        this.talkToGordonFinal = new NpcStep((QuestHelper)this, 10500, new WorldPoint(1248, 3686, 0), "Return to Gordon to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.itemsTip, this.bearFur, this.softClay, this.hammer, this.saw, this.planks, this.nails, this.knife, this.redDye, this.potOfFlour, this.needle, this.thread);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.staminaPotions, this.combatGear, this.skillsNeck);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Headless Beast (level 82, safespottable)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 4000), new ExperienceReward(Skill.CONSTRUCTION, 3200));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 3000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the tannery on Kebos Lowlands"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToGordon1, this.talkToMary), new Requirement[0]));
        allSteps.add(new PanelDetails("Killing the Beast", Arrays.asList(this.goUseFlourOnGate, this.goToMine, this.returnToGordon), this.potOfFlour));
        allSteps.add(new PanelDetails("Making the fake head", Arrays.asList(this.talkToMary2, this.makeClayHead, this.addFurToHead, this.dyeHead, this.putUpHead, this.talkToGordonFinal), this.bearFur, this.softClay, this.hammer, this.saw, this.planks, this.nails, this.knife, this.redDye, this.needle, this.thread));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        requirements.add(new SkillRequirement(Skill.CRAFTING, 30));
        requirements.add(new SkillRequirement(Skill.CONSTRUCTION, 26));
        return requirements;
    }
}

