/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.gertrudescat;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.GERTRUDES_CAT)
public class GertrudesCat
extends BasicQuestHelper {
    ItemRequirement bucketOfMilk;
    ItemRequirement coins;
    ItemRequirement seasonedSardine;
    ItemRequirement sardine;
    ItemRequirement doogleLeaves;
    ItemRequirement milkHighlighted;
    ItemRequirement seasonedSardineHighlighted;
    ItemRequirement kittenHighlighted;
    ItemRequirement lumberyardTeleport;
    ItemRequirement varrockTeleport;
    QuestStep talkToGertrude;
    QuestStep talkToChildren;
    QuestStep gertrudesCat;
    QuestStep gertrudesCat2;
    QuestStep searchNearbyCrates;
    QuestStep giveKittenToFluffy;
    QuestStep finishQuest;
    QuestStep pickupDoogle;
    QuestStep makeSeasonedSardine;
    ConditionalStep giveMilkToCatSteps;
    ConditionalStep giveSardineToCat;
    Requirement isUpstairsLumberyard;
    Requirement hasFluffsKitten;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        return this.getSteps();
    }

    private Map<Integer, QuestStep> getSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.talkToGertrude = this.getTalkToGertrude();
        steps.put(0, this.talkToGertrude);
        this.talkToChildren = this.getTalkToChildren();
        ConditionalStep conditionalTalkToChildren = new ConditionalStep((QuestHelper)this, this.pickupDoogle, new Requirement[0]);
        conditionalTalkToChildren.addStep(new ItemRequirements(LogicType.AND, "", this.sardine, this.doogleLeaves), this.makeSeasonedSardine);
        conditionalTalkToChildren.addStep(this.seasonedSardine, this.talkToChildren);
        steps.put(1, conditionalTalkToChildren);
        this.giveMilkToCatSteps = this.getGiveMilkToCat();
        steps.put(2, this.giveMilkToCatSteps);
        this.giveSardineToCat = this.getFeedCat();
        steps.put(3, this.giveSardineToCat);
        steps.put(4, this.findFluffsKitten());
        this.finishQuest = this.returnToGertrude();
        steps.put(5, this.finishQuest);
        return steps;
    }

    private NpcStep returnToGertrude() {
        return new NpcStep((QuestHelper)this, 7284, new WorldPoint(3148, 3413, 0), "Return to Gertrude to complete the quest.", new Requirement[0]);
    }

    private QuestStep findFluffsKitten() {
        this.searchNearbyCrates = new NpcStep((QuestHelper)this, 3499, new WorldPoint(3306, 3505, 0), "Search for a kitten in the crates in the Lumberyard.", true, new Requirement[0]);
        ((NpcStep)this.searchNearbyCrates).setHideWorldArrow(true);
        ObjectStep climbDownLadderStep = this.goDownLadderStep();
        ObjectStep climbUpLadderStep = this.getClimbLadder(new ItemRequirement[0]);
        ArrayList<ItemRequirement> fluffsKittenRequirement = new ArrayList<ItemRequirement>();
        fluffsKittenRequirement.add(new ItemRequirement("Fluffs' Kitten", 1554));
        climbUpLadderStep.addItemRequirements(fluffsKittenRequirement);
        Conditions hasFluffsKittenUpstairs = new Conditions(this.hasFluffsKitten, this.isUpstairsLumberyard);
        this.kittenHighlighted = new ItemRequirement("Fluffs' Kitten", 1554);
        this.kittenHighlighted.setHighlightInInventory(true);
        this.giveKittenToFluffy = this.getGertrudesCat(this.kittenHighlighted);
        this.giveKittenToFluffy.setText("Return the kitten to Gertrude's cat.");
        this.giveKittenToFluffy.addIcon(1554);
        ConditionalStep conditionalKitten = new ConditionalStep((QuestHelper)this, this.searchNearbyCrates, new Requirement[0]);
        conditionalKitten.addStep(hasFluffsKittenUpstairs, this.giveKittenToFluffy);
        conditionalKitten.addStep(this.hasFluffsKitten, climbUpLadderStep);
        conditionalKitten.addStep(this.isUpstairsLumberyard, climbDownLadderStep);
        this.searchNearbyCrates.addSubSteps(climbDownLadderStep);
        this.giveKittenToFluffy.addSubSteps(climbUpLadderStep);
        return conditionalKitten;
    }

    private ObjectStep goDownLadderStep() {
        return new ObjectStep((QuestHelper)this, 11795, new WorldPoint(3310, 3509, 1), "Climb down ladder in the Lumberyard.", new Requirement[0]);
    }

    private ConditionalStep getFeedCat() {
        this.gertrudesCat2 = this.getGertrudesCat(this.seasonedSardineHighlighted);
        this.gertrudesCat2.addIcon(1552);
        ObjectStep climbLadder = new ObjectStep((QuestHelper)this, 11794, new WorldPoint(3310, 3509, 0), "Climb up the ladder in the Lumberyard.", this.seasonedSardine);
        ConditionalStep lumberyard = new ConditionalStep((QuestHelper)this, (QuestStep)climbLadder, "Use a seasoned sardine on Gertrude's cat upstairs in the Lumberyard north east of Varrock.", new Requirement[0]);
        lumberyard.addStep(this.isUpstairsLumberyard, this.gertrudesCat2);
        this.gertrudesCat2.addSubSteps(climbLadder);
        return lumberyard;
    }

    private ConditionalStep getGiveMilkToCat() {
        this.gertrudesCat = this.getGertrudesCat(this.milkHighlighted);
        this.gertrudesCat.addIcon(1927);
        ObjectStep climbLadder = this.getClimbLadder(this.bucketOfMilk);
        ConditionalStep giveMilkToCat = new ConditionalStep((QuestHelper)this, (QuestStep)climbLadder, "Use a bucket of milk on Gertrude's cat upstairs in the Lumberyard north east of Varrock.", this.seasonedSardine);
        giveMilkToCat.addStep(this.isUpstairsLumberyard, this.gertrudesCat);
        return giveMilkToCat;
    }

    private NpcStep getGertrudesCat(ItemRequirement ... requirement) {
        return new NpcStep((QuestHelper)this, 3497, new WorldPoint(3308, 3511, 1), "", (Requirement[])requirement);
    }

    private QuestStep getTalkToChildren() {
        this.pickupDoogle = new DetailedQuestStep((QuestHelper)this, "Pickup some Doogle Leaves south of Gertrude's house.", new ItemRequirement("Doogle Leaves", 1573), this.sardine);
        this.makeSeasonedSardine = new DetailedQuestStep((QuestHelper)this, "Use your Doogle Leaves on  the Sardine.", this.sardine, this.doogleLeaves);
        NpcStep talkToChildren = new NpcStep((QuestHelper)this, 3501, new WorldPoint(3222, 3435, 0), "Talk to Shilop or Wilough in the Varrock Square.", true, this.seasonedSardine, this.coins);
        talkToChildren.addAlternateNpcs(3503);
        talkToChildren.addDialogSteps("What will make you tell me?", "Okay then, I'll pay.");
        return talkToChildren;
    }

    private QuestStep getTalkToGertrude() {
        NpcStep talkToGertrude = new NpcStep((QuestHelper)this, 7284, new WorldPoint(3148, 3413, 0), "Talk to Gertrude.", new Requirement[0]);
        talkToGertrude.addDialogStep("Yes.");
        return talkToGertrude;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfMilk = new ItemRequirement("Bucket of milk", 1927);
        this.milkHighlighted = new ItemRequirement("Bucket of milk", 1927);
        this.milkHighlighted.setHighlightInInventory(true);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 100);
        this.seasonedSardine = new ItemRequirement("Seasoned Sardine", 1552);
        this.seasonedSardine.setTooltip("Can be created by using a sardine on Doogle leaves(South of Gertrudes House)");
        this.seasonedSardineHighlighted = new ItemRequirement("Seasoned Sardine", 1552);
        this.seasonedSardineHighlighted.setTooltip("Can be created by using a sardine on Doogle leaves(South of Gertrudes House)");
        this.seasonedSardineHighlighted.setHighlightInInventory(true);
        this.sardine = new ItemRequirement("Raw Sardine", 327);
        this.sardine.setHighlightInInventory(true);
        this.doogleLeaves = new ItemRequirement("Doogle Leaves", 1573);
        this.doogleLeaves.setHighlightInInventory(true);
        this.lumberyardTeleport = new ItemRequirement("Lumberyard teleport", 12642);
        this.varrockTeleport = new ItemRequirement("Varrock teleports", 8007, 2);
    }

    private void setupZones() {
        Zone zone = new Zone(new WorldPoint(3306, 3507, 12), new WorldPoint(3312, 3513, 1));
        this.isUpstairsLumberyard = new ZoneRequirement(zone);
    }

    private void setupConditions() {
        this.hasFluffsKitten = new ItemRequirements(new ItemRequirement("Fluffs' kitten", 1554));
    }

    private ObjectStep getClimbLadder(ItemRequirement ... itemRequirements) {
        return new ObjectStep((QuestHelper)this, 11794, new WorldPoint(3310, 3509, 0), "Climb up the ladder in the Lumberyard.", (Requirement[])itemRequirements);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.bucketOfMilk, this.coins, this.sardine);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTeleport, this.lumberyardTeleport);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.COOKING, 1525));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A pet Kitten", 1555, 1), new ItemReward("Chocolate Cake", 1897, 1), new ItemReward("Stew", 2003, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to raise kittens."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> steps = new ArrayList<PanelDetails>();
        PanelDetails startingPanel = new PanelDetails("Starting out", Arrays.asList(this.talkToGertrude, this.pickupDoogle, this.makeSeasonedSardine, this.talkToChildren), this.sardine, this.coins);
        steps.add(startingPanel);
        PanelDetails lumberYardPanel = new PanelDetails("The secret playground (Lumber Yard)", Arrays.asList(this.giveMilkToCatSteps, this.giveSardineToCat, this.searchNearbyCrates, this.giveKittenToFluffy), this.seasonedSardine, this.bucketOfMilk);
        steps.add(lumberYardPanel);
        PanelDetails finishQuestPanel = new PanelDetails("Finish the quest", Collections.singletonList(this.finishQuest), new Requirement[0]);
        steps.add(finishQuestPanel);
        return steps;
    }
}

