/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.fishingcontest;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FISHING_CONTEST)
public class FishingContest
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement fishingPass;
    ItemRequirement garlic;
    ItemRequirement fishingRod;
    ItemRequirement spade;
    ItemRequirement redVineWorm;
    ItemRequirement winningFish;
    ItemRequirement trophy;
    ItemRequirement combatBracelet;
    ItemRequirement camelotTeleport;
    ItemRequirement food;
    QuestRequirement fairyRingAccess;
    QuestStep talkToVestriStep;
    QuestStep getGarlic;
    QuestStep goToMcGruborWood;
    QuestStep goToRedVine;
    QuestStep grandpaJack;
    QuestStep runToJack;
    QuestStep goToHemenster;
    QuestStep teleToHemenster;
    QuestStep putGarlicInPipe;
    QuestStep speakToBonzo;
    QuestStep speakToBonzoWithFish;
    QuestStep speaktoVestri;
    ConditionalStep goToHemensterStep;
    ConditionalStep getWorms;
    ConditionalStep fishNearPipes;
    ItemRequirement noCombatBracelet;
    ItemRequirement noFishingRod;
    ItemRequirement noGarlic;
    ItemRequirement noWorms;
    Requirement hasEverything;
    Requirement notNearWorms;
    Requirement inWoods;
    Requirement notInWoods;
    Requirement enteredContest;
    Requirement hasPutGarlicInPipe;
    VarbitRequirement garlicInPipeVarbit;
    WidgetTextRequirement garlicInPipeScreen;
    DialogRequirement confirmGarlicInPipe;
    Zone mcGruborWoodEntrance;
    Zone cmbBraceletTeleportZone;
    Zone nearRedVineWorms;
    Zone contestGroundsEntrance;
    ZoneRequirement passedThroughMcGruborEntrance;
    ZoneRequirement atCmbBraceletTeleportZone;
    ZoneRequirement onContestGrounds;

    public void setupZones() {
        this.mcGruborWoodEntrance = new Zone(new WorldPoint(2662, 3500, 0));
        this.passedThroughMcGruborEntrance = new ZoneRequirement(this.mcGruborWoodEntrance);
        this.cmbBraceletTeleportZone = new Zone(new WorldPoint(2651, 3444, 0), new WorldPoint(2657, 3439, 0));
        this.atCmbBraceletTeleportZone = new ZoneRequirement(this.cmbBraceletTeleportZone);
        this.nearRedVineWorms = new Zone(new WorldPoint(2634, 3491, 0), new WorldPoint(2626, 3500, 0));
        this.contestGroundsEntrance = new Zone(new WorldPoint(2642, 3445, 0), new WorldPoint(2631, 3434, 0));
        Zone tilesEastOfPipe = new Zone(new WorldPoint(2641, 3446, 0), new WorldPoint(2638, 3446, 0));
        this.onContestGrounds = new ZoneRequirement(this.contestGroundsEntrance, tilesEastOfPipe);
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 5);
        this.coins.setTooltip("10 if you buy a fishing rod from Jack");
        this.fishingPass = new ItemRequirement("Fishing Pass", 27);
        this.fishingPass.setTooltip("<html>This can be obtained during the quest.<br>If you lose this you can get another from Vestri.</html>");
        this.garlic = new ItemRequirement("Garlic", 1550);
        this.garlic.setTooltip("This can be obtained during the quest.");
        this.garlic.setHighlightInInventory(true);
        this.fishingRod = new ItemRequirement("Fishing Rod", 307).isNotConsumed();
        this.fishingRod.setTooltip("This can be obtained during the quest.");
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.redVineWorm = new ItemRequirement("Red Vine Worm", 25, 1);
        this.redVineWorm.setTooltip("This can be obtained during the quest.");
        this.food = new ItemRequirement("Food for low levels", ItemCollections.GOOD_EATING_FOOD, -1);
        this.winningFish = new ItemRequirement("Raw Giant Carp", 338);
        this.winningFish.setHighlightInInventory(true);
        this.trophy = new ItemRequirement("Fishing Trophy", 26);
        this.trophy.setHighlightInInventory(true);
        this.trophy.setTooltip("You can get another from Bonzo in Hemenster if you lost this.");
        this.combatBracelet = new ItemRequirement("Combat Bracelet", ItemCollections.COMBAT_BRACELETS);
        this.combatBracelet.setHighlightInInventory(true);
        this.combatBracelet.setTooltip("Highly recommended!");
        this.camelotTeleport = new ItemRequirement("Camelot Teleport", 8010);
        this.fairyRingAccess = new QuestRequirement(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestState.IN_PROGRESS, "Fairy ring access");
        this.fairyRingAccess.setTooltip(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN.getName() + " is required to at least be started in order to use fairy rings");
    }

    public void setupSteps() {
        this.talkToVestriStep = new NpcStep((QuestHelper)this, 4078, new WorldPoint(2821, 3486, 0), "Talk to Vestri just north of Catherby.", new Requirement[0]);
        this.talkToVestriStep.addDialogStep("I was wondering what was down those stairs?");
        this.talkToVestriStep.addDialogStep("Why not?");
        this.talkToVestriStep.addDialogStep("If you were my friend I wouldn't mind it.");
        this.talkToVestriStep.addDialogStep("Well, let's be friends!");
        this.talkToVestriStep.addDialogStep("And how am I meant to do that?");
        this.getGarlic = new ObjectStep((QuestHelper)this, 25930, new WorldPoint(2714, 3478, 0), "", new Requirement[0]);
        this.getGarlic.setText("Pick the garlic up on the table in Seers' Village.\nIf it is not there it spawns about every 30 seconds.");
        this.goToMcGruborWood = new ObjectStep((QuestHelper)this, 51, new WorldPoint(2662, 3500, 0), "", this.spade);
        this.goToMcGruborWood.setText("Enter McGrubor's Woods via the northern entrance.\nBe careful of the Guard Dogs (level 44). They are aggressive!");
        this.goToRedVine = new ObjectStep((QuestHelper)this, 2990, new WorldPoint(2631, 3496, 0), "", this.spade);
        this.goToRedVine.setText("Use your spade on the red vines to gather 1 Red Vine Worm.");
        this.goToRedVine.addIcon(952);
        ((ObjectStep)this.goToRedVine).addAlternateObjects(2013, 2991, 2992, 2994);
        ((ObjectStep)this.goToRedVine).addAlternateObjects(58, 2993, 2989);
        this.goToHemenster = new ObjectStep((QuestHelper)this, 48, new WorldPoint(2642, 3441, 0), "Enter Hemenster with your fishing pass.", new Requirement[0]);
        ((ObjectStep)this.goToHemenster).addAlternateObjects(47);
        this.grandpaJack = new NpcStep((QuestHelper)this, 4075, new WorldPoint(2649, 3451, 0), "Talk to Grandpa Jack to get a fishing rod.", new Requirement[0]);
        this.grandpaJack.addDialogStep("Can I buy one of your fishing rods?");
        this.grandpaJack.addDialogStep("Very fair, I'll buy that rod!");
        this.putGarlicInPipe = new ObjectStep((QuestHelper)this, 41, new WorldPoint(2638, 3446, 0), "Put garlic in the pipes.", this.garlic);
        this.putGarlicInPipe.addIcon(1550);
        this.speakToBonzo = new NpcStep((QuestHelper)this, 4069, new WorldPoint(2641, 3437, 0), "Speak to Bonzo to start the competition.", this.coins);
        this.speakToBonzo.addDialogStep("I'll enter the competition please.");
        this.speakToBonzoWithFish = new NpcStep((QuestHelper)this, 4069, new WorldPoint(2641, 3437, 0), "", this.winningFish);
        this.speakToBonzoWithFish.setText("Speak to Bonzo again after you have caught the winning fish.");
        this.speakToBonzoWithFish.addDialogStep("I have this big fish. Is it enough to win?");
        NpcStep fishingSpot = new NpcStep((QuestHelper)this, 4080, new WorldPoint(2637, 3444, 0), "", new Requirement[0]);
        fishingSpot.setText("Fish near the pipes after the Sinister Stranger leaves.");
        this.fishNearPipes = new ConditionalStep((QuestHelper)this, (QuestStep)fishingSpot, "Catch the winning fish at the fishing spot near the pipes.", this.fishingRod, this.redVineWorm);
        this.fishNearPipes.addStep(this.winningFish, this.speakToBonzoWithFish);
        this.teleToHemenster = new NpcStep((QuestHelper)this, 4075, "", this.coins);
        this.teleToHemenster.addText("\nTeleport to Hemenster via the combat bracelet.\n\nSpeak to Grandpa Jack to buy a fishing rod.");
        this.teleToHemenster.addDialogStep("Ranging Guild");
        this.teleToHemenster.addDialogStep("Can I buy one of your fishing rods?");
        this.teleToHemenster.addDialogStep("Very fair, I'll buy that rod!");
        this.runToJack = new NpcStep((QuestHelper)this, 4075, new WorldPoint(2649, 3451, 0), "", this.coins);
        this.runToJack.setText("Speak to Grandpa Jack to get a fishing rod.\nYou can leave McGrubor's Woods via the northern entrance.");
        this.runToJack.addDialogStep("Can I buy one of your fishing rods?");
        this.runToJack.addDialogStep("Very fair, I'll buy that rod!");
        this.speaktoVestri = new NpcStep((QuestHelper)this, 4078, new WorldPoint(2821, 3486, 0), "Talk to Vestri just north of Catherby.", this.trophy);
        this.goToHemensterStep = new ConditionalStep((QuestHelper)this, this.goToHemenster, "Enter Hemenster with your fishing pass.", new Requirement[0]);
        this.goToHemensterStep.addDialogStep("Ranging Guild");
        this.getWorms = new ConditionalStep((QuestHelper)this, this.goToRedVine, "Gather 1 Red Vine Worm in McGrubor's Woods.", new Requirement[0]);
        this.getWorms.addStep(new Conditions(this.noWorms, this.notNearWorms, this.notInWoods), this.goToMcGruborWood);
        this.getWorms.addStep(this.inWoods, this.goToRedVine);
    }

    public void setupConditions() {
        this.noCombatBracelet = new ItemRequirements(LogicType.NOR, "", this.combatBracelet);
        this.noFishingRod = new ItemRequirements(LogicType.NOR, "", this.fishingRod);
        this.noGarlic = new ItemRequirements(LogicType.NOR, "", this.garlic);
        this.noWorms = new ItemRequirements(LogicType.NOR, "", this.redVineWorm);
        this.hasEverything = new Conditions(this.garlic, this.redVineWorm, this.fishingRod, this.fishingPass);
        this.notNearWorms = new Conditions(LogicType.NOR, new ZoneRequirement(this.nearRedVineWorms));
        this.inWoods = new Conditions(true, this.passedThroughMcGruborEntrance);
        this.notInWoods = new Conditions(LogicType.NOR, this.inWoods);
        this.garlicInPipeVarbit = new VarbitRequirement(2054, 1);
        this.enteredContest = new Conditions(true, LogicType.AND, this.hasEverything, this.onContestGrounds);
        this.garlicInPipeScreen = new WidgetTextRequirement(12648450, "You stash the garlic in the pipe.");
        this.confirmGarlicInPipe = new DialogRequirement(this.client.getLocalPlayer().getName(), "I shoved some garlic up here.");
        this.hasPutGarlicInPipe = new Conditions(true, LogicType.OR, this.garlicInPipeVarbit, this.garlicInPipeScreen, this.confirmGarlicInPipe);
    }

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.goToHemensterStep.addStep(this.hasPutGarlicInPipe, this.speakToBonzo);
        this.goToHemensterStep.addStep(this.enteredContest, this.putGarlicInPipe);
        this.goToHemensterStep.addStep(this.noGarlic, this.getGarlic);
        this.goToHemensterStep.addStep(this.noWorms, this.getWorms);
        this.goToHemensterStep.addStep(this.fishingRod, this.goToHemenster);
        this.goToHemensterStep.addStep(new Conditions(this.noCombatBracelet, this.redVineWorm, this.noFishingRod), this.runToJack);
        this.goToHemensterStep.addStep(new Conditions(this.combatBracelet, this.redVineWorm, this.noFishingRod), this.teleToHemenster);
        this.goToHemensterStep.addStep(new Conditions(this.noFishingRod, this.redVineWorm), this.grandpaJack);
        steps.put(0, this.talkToVestriStep);
        steps.put(1, this.goToHemensterStep);
        steps.put(2, this.goToHemensterStep);
        steps.put(3, this.fishNearPipes);
        steps.put(4, this.speaktoVestri);
        return steps;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.FISHING, 2437));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the underground White Wolf Mountain passage"), new UnlockReward("Ability to catch minnows in The Fishing Guild."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> panels = new ArrayList<PanelDetails>();
        List<QuestStep> steps = Arrays.asList(this.talkToVestriStep, this.goToHemensterStep, this.fishNearPipes, this.speaktoVestri);
        PanelDetails fisingContest = new PanelDetails("Fishing Contest", steps, this.fishingRod, this.garlic, this.coins, this.redVineWorm, this.spade);
        panels.add(fisingContest);
        return panels;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.FISHING, 10));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins, this.redVineWorm, this.garlic, this.spade, this.fishingRod);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatBracelet, this.camelotTeleport);
    }
}

